# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateDeployRequest(JDCloudRequest):
    """
    创建部署任务
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateDeployRequest, self).__init__(
            '/regions/{regionId}/deploy', 'POST', header, version)
        self.parameters = parameters


class CreateDeployParameters(object):

    def __init__(self, regionId, groupId, deploySource, ):
        """
        :param regionId: 地域ID
        :param groupId: 部署组ID，部署组的唯一标识
        :param deploySource: 部署来源：1url，2云编译，3云存储
        """

        self.regionId = regionId
        self.groupId = groupId
        self.desc = None
        self.deploySource = deploySource
        self.deployCmd = None
        self.cmdSource = None
        self.cmdType = None
        self.productType = None
        self.downloadUrl = None
        self.md5 = None
        self.compileProject = None
        self.compileSeries = None
        self.ossSpace = None
        self.ossDir = None
        self.fileType = None

    def setDesc(self, desc):
        """
        :param desc: (Optional) 描述
        """
        self.desc = desc

    def setDeployCmd(self, deployCmd):
        """
        :param deployCmd: (Optional) 部署操作
        """
        self.deployCmd = deployCmd

    def setCmdSource(self, cmdSource):
        """
        :param cmdSource: (Optional) 1使用输入的操作，2使用程序自带操作
        """
        self.cmdSource = cmdSource

    def setCmdType(self, cmdType):
        """
        :param cmdType: (Optional) 部署操作展示格式：1form,2ymal
        """
        self.cmdType = cmdType

    def setProductType(self, productType):
        """
        :param productType: (Optional) 项目类型 1tomcat,2
        """
        self.productType = productType

    def setDownloadUrl(self, downloadUrl):
        """
        :param downloadUrl: (Optional) 下载url
        """
        self.downloadUrl = downloadUrl

    def setMd5(self, md5):
        """
        :param md5: (Optional) md5
        """
        self.md5 = md5

    def setCompileProject(self, compileProject):
        """
        :param compileProject: (Optional) 云编译项目名
        """
        self.compileProject = compileProject

    def setCompileSeries(self, compileSeries):
        """
        :param compileSeries: (Optional) 云编译构建序号
        """
        self.compileSeries = compileSeries

    def setOssSpace(self, ossSpace):
        """
        :param ossSpace: (Optional) 云存储空间
        """
        self.ossSpace = ossSpace

    def setOssDir(self, ossDir):
        """
        :param ossDir: (Optional) 云存储目录
        """
        self.ossDir = ossDir

    def setFileType(self, fileType):
        """
        :param fileType: (Optional) 文件类型：1.tar，2.zip,3.tar.gz
        """
        self.fileType = fileType

