# Archived Documentation

This directory contains historical, deprecated, and obsolete documentation that is no longer actively maintained but preserved for reference.

## 📋 Archive Structure

### Implementation Reports (`implementation-reports/`)
Historical implementation summaries and status reports that are no longer relevant:

- **Visualization Implementation Reports** - Various visualization feature implementations
- **Compact Layout Reports** - Folder layout implementation summaries
- **Feature Implementation Summaries** - Completed feature implementation reports

### Summaries (`summaries/`)
Project reorganization and status summaries:

- **Documentation Reorganization** - Previous reorganization attempts and summaries
- **Project Status Reports** - Historical project status documents

### Old Versions (`old-versions/`)
Previous versions of documentation that have been superseded.

### Deprecated Features (`deprecated/`)
Documentation for features that are no longer supported.

### Temporary Files (`temp-files/`)
Temporary documentation files that were created during development.

## 🗂️ Archive Policy

### What Gets Archived
- ✅ Completed implementation summaries
- ✅ Outdated status reports
- ✅ Superseded documentation versions
- ✅ Temporary development documents
- ✅ Deprecated feature documentation

### What Stays Active
- ❌ Current user guides
- ❌ Active development documentation
- ❌ Reference materials
- ❌ Architecture documentation
- ❌ Current configuration guides

## 📅 Archive Process

When archiving documentation:

1. **Move** files to appropriate subdirectory
2. **Add date suffix** if not already present: `filename-YYYYMMDD.md`
3. **Update links** that pointed to archived content
4. **Add entry** to this index if significant

## 🔍 Finding Archived Content

### By Category
- **Implementation Reports**: Look in `implementation-reports/`
- **Status Reports**: Look in `summaries/`
- **Old Versions**: Look in `old-versions/`

### By Date
Most archived files include dates in their filenames for easy chronological sorting.

## ⚠️ Important Notes

- **Archived content is not maintained** and may contain outdated information
- **Links within archived documents** may be broken
- **Use archived content for reference only** - do not rely on it for current procedures
- **Some archived content** may be incomplete or represent work-in-progress

## 🔗 Related Documentation

- **[Documentation Standards](../DOCUMENTATION-STANDARDS.md)** - Current documentation standards
- **[Development](../development/README.md)** - Current development documentation
- **[Internal](../internal/README.md)** - Current internal documentation

---

**Last Updated**: December 2025
**Archive Policy Version**: 1.0
