# A Python Client for Metablock API

[![PyPI version](https://badge.fury.io/py/metablock.svg)](https://badge.fury.io/py/metablock)
[![Python versions](https://img.shields.io/pypi/pyversions/metablock.svg)](https://pypi.org/project/metablock)
[![Build](https://github.com/quantmind/metablock-py/workflows/build/badge.svg)](https://github.com/quantmind/metablock-py/actions?query=workflow%3Abuild)
[![codecov](https://codecov.io/gh/quantmind/metablock-py/branch/master/graph/badge.svg?token=EAdSVpD0Af)](https://codecov.io/gh/quantmind/metablock-py)

This is an asynchronous python client for [metablock API](https://api.metablock.io/v1/docs).

## Installation

This is a simple python package you can install via pip:

```
pip install metablock
```

## Usage

Create the client

```python
from metablock import Metablock

cli = Metablock()

# get the user associated with the API token
user = await cli.get_user()
```
