''' Creates MD5-HASH from given input file.

To simplify simulations of different VA-Codes, the corresponding VA-File can be given and added to the hash
finally an additional (bytes) string can be given to add further customization

Author: Mario Krattenmacher | Mario.Krattenmacher@tu-dresden.de
'''
# DMT
# Copyright (C) 2019  Markus Müller and Mario Krattenmacher and the DMT contributors <https://gitlab.hrz.tu-chemnitz.de/CEDIC_Bipolar/DMT/>
#
# This file is part of DMT.
#
# DMT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DMT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>
import hashlib

def create_md5_hash(*contents):
    ''' Construct the hash MD5 string with all parameters

    Parameters
    -----------
    contents : \*str
        Either a path to a file to read or some object which can be converted to a string using str()

    Returns
    -----------
    hash : str
        MD5 string
    '''
    str_to_hash = ''

    for content in contents:
        try: # is content a file?
            with open(content) as my_file:
                str_to_hash += my_file.read()
        except (OSError, ValueError, TypeError):
            # content is a castable?
            str_to_hash += str(content)

    # create hash object from python lib
    hash_creator = hashlib.md5()
    # feed the binary string into the object
    hash_creator.update(str_to_hash.encode())

    return hash_creator.hexdigest()