prompts = {
    "completion": {
        "expertises": """You are a helpful assistant for recommending useful domain expertises. What domain expertises have the knowledge and experience needed to identify causal relationships and causal influences between the {{analysis_context}}? What domain expertises are needed to work with and reason about the causal influence between {{factors_list}}? What domain expertises have the knowledge and experience to reason and answer questions about influence and cause between such factors? Think about this in a step by step manner and recommend {{n_experts}} expertises and provide each one wrapped within the tags, <domain_expertise></domain_expertise>, along with the reasoning and explanation wrapped between the tags <explanation></explanation>. {{gen "output" temperature=temperature}}""",
        "stakeholders": """You are a helpful assistant for recommending useful primary and seconday stakeholders. What stakeholders have knowledge and experience in and about {{analysis_context}}? What stakeholders can work best with and reason well about the causal influece between {{factors_list}}? What stakeholders have the knowledge and experience useful to reason within this context? Think about this in a step by step manner and recommend {{n_stakeholders}} stakeholders. Then provide each useful stakeholder wrapped within the tags, <stakeholder></stakeholder>, along with the reasoning and explanation wrapped between the tags <explanation></explanation>. {{gen "output" temperature=temperature}}""",
        "domain_experts": """You are a helpful assistant for recommending useful domain experts. What domain expertises have the knowledge and experience needed to identify causal relationships and causal influences between the {{analysis_context}}? What domain expertises are needed to work with and reason about the causal influence between {{factors_list}}? What domain expertises have the knowledge and experience to reason and answer questions about influence and cause between such factors? Think about this in a step by step manner and recommend {{n_experts}} domain experts and provide each one wrapped within the tags, <domain_expert></domain_expert>, along with the reasoning and explanation wrapped between the tags <explanation></explanation>. {{gen "output" temperature=temperature}}""",
        "expert_suggests_parents": """You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing and causing the {{factor}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}} think step by step as you consider the relevant factor directly influencing and causing the {{factor}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}} which of the following factors has a high likelihood of directly influencing and causing the {{factor}}? factors list: [{{factors_list}}] For any factors within the list with a high likelihood of directly influencing and causing the {{factor}} wrap the name of the factor with the tags <influencing_factor>factor_name</influencing_factor>. If a factor does not have a high likelihood of directly influencing and causing the {{factor}}, then do not wrap the factor with any tags. Your answer as an expert in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_children": """You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing and causing the {{factor}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}} think step by step as you consider which factor(s), from the factors list, if any at all, is/are directly influenced and caused by the {{factor}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}}, which of the following factor(s) from the factors list, if any at all, has/have a high likelihood of being directly influenced and caused by the {{factor}}? What factor(s) from the factors list, if any at all, is/are affected by the {{factor}}? factors list: [{{factors_list}}] For any factors within the list with a high likelihood of being directly influenced and caused by the {{factor}} wrap the name of the factor with the tags <influencing_factor>factor_name</influencing_factor>. If a factor has a high likelihood of being affected and influenced by the {{factor}}, then wrap the name of the factor with the tags <influenced_factor>factor_name</influenced_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of directly influencing and causing the {{factor}}, then do not wrap the factor with any tags. Your answer as an expert in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_group_suggests_parents": """Your task is to role play the part of each domain expert: {{top_expertises}}. Use the domain knowledge of each expert to respond as they may have done. Stay in character, do not break character. These characters are conducting a study about {{analysis_context}} becuase they wish to find factors with a high likelihood of directly influencing and causing the {{factor}}. Each expert has identified the factors they consider to be influencing and causing the {{factor}} and added them to this list. [{{suggested_factors_list}}] From the factors identified, they now wish to validate the factors that are influencing and causing the {{factor}} from those that are not influencing and causing the {{factor}}. Each domain expert character should critique the other's response and they should all debate amongst themselves in order to unanimously arrive at the factors with the highest likelihood of influecing and causing the {{factor}}. Provide the step by step debate between the experts within the tags <debate></debate>. Return the discussion between the experts within the tags <debate></debate>. When they are done debating, return each factor wrapped within the tags <influencing_factor>factor_name</influencing_factor>. If they have arrived a conclusion, output each factor, wrapped within the tags <influencing_factor>factor_name</influencing_factor>. Once they unanimously arrive at the the factors with the highest likelihood of influecing and causing the {{factor}}, provide each factor wrapped within the tags <influencing_factor>factor_name</influencing_factor>. When done, return the tag <end> so that no information gets lost. If you are done listing the factors, provide the tag <end>. If you are done, output <end>. {{gen "output" temperature=temperature}}""",
        "expert_suggests_pairwise_relationships": """You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. From your perspective as an expert in {{domain_expertise}}, which of the following is most likely true? (A) {{a}} affects {{b}}; {{a}} has a high likelihood of directly influencing {{b}}; and {{a}} causes {{b}}. (B) {{b}} affects {{a}}; {{b}} has a high likelihood of directly influencing {{a}}; and {{b}} causes {{a}}. (C) Neither A nor B; {{a}} does not cause {{b}}; and {{b}} does not cause {{a}}. Select the answer that you as an expert in {{domain_expertise}} believe has the likelihood of being true. Think step by step and provide your thoughts within the tags <thinking></thinking>. Then select that answer A, B, or C, that is causally correct. When you reach a conclusion, wrap your answer within the tags <answer></answer>. If you are done thinking, provide your answer wrapped within the tags <answer></answer>. e.g. <answer>A</answer>, <answer>B</answer>, or <answer>C</answer>. Your answer as an expert in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_confounders": """You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors that may interact between the {{treatment}} and the {{outcome}}. Use your knowlegde as an expert in {{domain_expertise}} to describe the confounders, if there are any at all, between the {{treatment}} and the {{outcome}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if any at all, has/have a high likelihood of directly influencing and causing both the assignment of the {{treatment}} and the {{outcome}}? Which factor(s) of the following factors, if any at all, have a causal chain that links to the {{treatment}} to the {{outcome}}? Which factor(s) of the following factors, if any at all, are a confounder to the causal relationship between the {{treatment}} and the {{outcome}}? Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. factor_names : {{factors_list}} Wrap the name of the factor(s), if any at all, that has/have a high likelihood of directly influencing and causing both  the {{treatment}} and the {{outcome}}, within the tags <confounding_factor>factor_name</confounding_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of directly confounding, then do not wrap the factor with any tags. Your step by step answer as an expert in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_mediators": """You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing athe {{outcome}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors that may interact between the {{treatment}} and the {{outcome}}. Use your knowlegde as an expert in {{domain_expertise}} to describe the mediators, if there are any at all, betweem {{treatment}} and the {{outcome}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>.  (2) From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if any at all, has/have a high likelihood of directly influencing and causing the assignment of the {{outcome}} and also has/have a high likelihood of being directly influenced and caused by the assignment of the {{treatment}}? Which factor(s) of the following factors, if any at all, is/are on the causal chain that links the {{treatment}} to the {{outcome}}? From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if any at all, mediates, is/are on the causal chain, that links the {{treatment}} to the {{outcome}}? Then provide your step by step chain of thoughts within the tags <thinking></thinking>. factor_names : {{factors_list}} Wrap the name of the factor(s), if any at all, that has/have a high likelihood of directly influencing and causing the assignment of the {{outcome}} and also has/have a high likelihood of being directly influenced and caused by the assignment of the {{treatment}} within the tags <mediating_factor>factor_name</mediating_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of mediating, then do not wrap the factor with any tags. Your step by step answer as an in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_ivs": """You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing athe {{outcome}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors that may interact with the {{treatment}} and do not interact with {{outcome}}. Use your knowlegde as an expert in {{domain_expertise}} to describe the instrumental variable(s), if there are any at all, that both has/have a high likelihood of influecing and causing the {{treatment}} and has/have a very low likelihood of influencing and causing the {{outcome}}. Be concise and keep your thinking within two paragraphs.  Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if there are any at all, both has/have a high likelihood of influecing and causing the {{treatment}} and has/have a very low likelihood of influencing and causing the {{outcome}}? Which factor(s) of the following factors, if any at all, has/have a causal link to the {{treatment}} and has not causal link to the {{outcome}}? Which factor(s) of the following factors, if any at all, are (an) instrumental variable(s) to the causal relationship of the {{treatment}} causing the {{outcome}}? Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. factor_names : {{factors_list}} Wrap the name of the factor(s), if there are any at all, that both has/have a high likelihood of influecing and causing the {{treatment}} and has/have a very low likelihood of influencing and causing the {{outcome}}, within the tags <iv_factor>factor_name</iv_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of being an instrumental variable, then do not wrap the factor with any tags. Your step by step answer as an in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_latent_confounders": """You are an expert in the {{domain_expertise}} and are studying the {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the {{domain_expertise}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in the {{domain_expertise}}. (1) From your perspective as an expert in the {{domain_expertise}}, think step by step as you consider the factors that may interact between the {{treatment}} and the {{outcome}}. Use your knowlegde as an expert in the {{domain_expertise}} to describe the confounders, if there are any at all, between the {{treatment}} and the {{outcome}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in the {{domain_expertise}}, which factor(s), if any at all, has/have a high likelihood of directly influencing and causing both the assignment of the {{treatment}} and the {{outcome}}? Which factor(s), if any at all, have a causal chain that links to the {{treatment}} to the {{outcome}}? Which factor(s), if any at all, are a confounder to the causal relationship between the {{treatment}} and the {{outcome}}? Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. Wrap the name of the factor(s), if any at all, that has/have a high likelihood of directly influencing and causing both the {{treatment}} and the {{outcome}}, within the tags <confounding_factor>factor_name</confounding_factor>. If a factor does not have a high likelihood of directly confounding, then do not wrap the factor with any tags. Your step by step answer as an expert in the {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_latent_negative_controls": """You are an expert in {{domain_expertise}} and are studying the {{analysis_context}}. You are using your domain knowledge to help understand the negative controls for a causal model that contains all the assumptions about the {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by answering questions about cause and effect using your domain knowledge in the {{domain_expertise}}. From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors, relevant to the {{analysis_context}}, in which we should see zero treatment effect when changing the {{treatment}}? What factors, relevant to the {{analysis_context}}, are negative controls on the causal mechanisms that affect the {{outcome}} when changing {{treatment}}? Using your domain knowledge, what factors, relevant to the {{analysis_context}}, should we expect to be unaffected by any changes to {{treatment}}? What factors would be surprising to see affected by a change made to the {{treatment}}? Be concise and keep your thoughts under two paragaphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. Once you have thought things through, wrap the name of the factor(s) that has/have a high likelihood of being negative controls on the causal mechanisms that affect {{outcome}} when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. Wrap the name of the factor(s) that has/have a high likelihood of being unaffected when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. If a factor does not have a high likelihood of being a negative control relevant to the {{analysis_context}}, then do not wrap the factor with any tags. Provide your step by step answer as an expert in {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_suggests_negative_controls": """You are an expert in the {{domain_expertise}} and are studying the {{analysis_context}}. You are using your domain knowledge to help understand the negative controls for a causal model that contains all the assumptions about the {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by answering questions about cause and effect using your domain knowledge in the {{domain_expertise}}. factor_names: {{factors_list}} From your perspective as an expert in the {{domain_expertise}}, what factor(s) from the list of factors, relevant to the {{analysis_context}}, should see zero treatment effect when changing the {{treatment}}? Which factor(s) from the list of factors, if any at all, relevant to the {{analysis_context}}, are negative controls on the causal mechanisms that affect the {{outcome}} when changing {{treatment}}? Using your domain knowledge, which factor(s) from the list of factors, if any at all, relevant to the {{analysis_context}}, should we expect to be unaffected by any changes in {{treatment}}? Which factor(s) from the list of factors, if any at all, would be surprising if affected by a change in {{treatment}}? Be concise and keep your thoughts under two paragaphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. Once you have thought things through, wrap the name of the factor(s) from the list of factors, that has/have a high likelihood of being negative controls on the causal mechanisms that affect {{outcome}} when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. Wrap the name of the factor(s) from the list of factors, that has/have a high likelihood of being unaffected when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of being a negative control relevant to the {{analysis_context}}, then do not wrap the factor with any tags. Provide your step by step answer as an expert in the {{domain_expertise}}: {{gen "output" temperature=temperature}}""",
        "expert_critiques_parents": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors causing {{factor}}. Steps: (1) Analyze potential factors [{{potential_factors_list}}] for factors directly influencing/causing/affecting {{factor}}. Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{factor}} influenced/caused/affected by  [{{potential_factors_list}}]? Is relationship direct? Ignore feedback mechanisms/factors not in list. Wrap factors highly likely directly influencing/causing/affecting {{factor}} in <influencing_factor></influencing_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{gen "output" temperature=temperature}}""",
        "expert_critiques_children": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors caused by {{factor}}. Steps: (1) Analyze potential factors [{{potential_factors_list}}] for factors directly influenced/caused/affected by {{factor}}. Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{factor}} influences/causes/affects [{{potential_factors_list}}]? Is relationship direct? Ignore feedback mechanisms/factors not in list. Wrap factors highly likely directly influenced/caused/affected by {{factor}} in <influenced_factor></influenced_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{gen "output" temperature=temperature}}""",
        "expert_critiques_pairwise": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify relationship between {{a}} and {{b}}. Steps: (1) Does {{a}} influence/cause/affect {{b}}? Is relationship direct? Does {{b}} influence/cause/affect {{a}}? Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to select likely answer: (A) {{a}} influences {{b}} (B) {{b}} influences {{a}} (C) Neither. Wrap answer in <answer></answer>. e.g. <answer>A</answer>, <answer>B</answer>, <answer>C</answer>. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{gen "output" temperature=temperature}}""",
        "expert_suggests_parents_condensed": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors causing {{factor}}. Steps: (1) Analyze potential factors [{{factors_list}}] for factors directly influencing/causing/affecting {{factor}}. Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{factor}} influenced/caused/affected by  [{{potential_factors_list}}]? Is relationship direct? Ignore feedback mechanisms/factors not in list. Wrap factors highly likely directly influencing/causing/affecting {{factor}} in <influencing_factor></influencing_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{gen "output" temperature=temperature}}""",
        "expert_suggests_children_condensed": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors caused by {{factor}}. Steps: (1) Analyze potential factors [{{factors_list}}] for factors directly influenced/caused/affected by {{factor}}. Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{factor}} influences/causes/affects [{{potential_factors_list}}]? Is relationship direct? Ignore feedback mechanisms/factors not in list. Wrap factors highly likely directly influenced/caused/affected by {{factor}} in <influenced_factor></influenced_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{gen "output" temperature=temperature}}""",
        "expert_suggests_pairwise_relationships_condensed": """Expert in {{domain_expertise}}, studying {{analysis_context}}, building causal model. Q: True? (A) {{a}}->{{b}} (B) {{b}}->{{a}} (C) No causality. Think <thinking></thinking>, select A/B/C, answer <answer></answer>. Your answer as {{domain_expertise}} expert: {{gen "output" temperature=temperature}}""",
        "expert_suggests_confounders_condensed": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors that are confounders to {{treatment}} and {{outcome}}. Steps: (1) Analyze potential factors [{{factors_list}}] for factors directly influencing/causing/affecting {{treatment}} and {{outcome}}. Is relationship direct? If relationship direct, ignore feedback mechanisms/other factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{treatment}} and {{outcome}} influenced/caused/affected by  [{{potential_factors_list}}]? Is relationship direct? If relationship direct, ignore feedback mechanisms/other factors not in list. Wrap factors directly influencing/causing/affecting {{factor}} in <confounding_factor></confounding_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{gen "output" temperature=temperature}}""",
        "expert_suggests_mediators_condensed": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors that are mediators between {{treatment}} and {{outcome}}. Steps: (1) Analyze [{{factors_list}}] for factors mediating relationship from {{treatment}} to {{outcome}}. If factor is  between {{treatment}} and {{outcome}} on causal chain, then gnore feedback mechanisms/other factors not in list. Answer in <thinking></thinking>. (2) Use prior thoughts to answer: Identify high-likelihood factors influencing {{outcome}} and influenced by {{treatment}}, on causal chain.Ignore feedback mechanisms/other factors not in list. Wrap mediating factors in <mediating_factor>factor_name</mediating_factor> from {{factors_list}}. {{gen "output" temperature=temperature}}""",
        "expert_suggests_ivs_condensed": """U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors that are instrumental variables (ivs) influencing treatment: {{treatment}}, and do not affect outcome: {{outcome}}. Steps: (1) Analyze [{{factors_list}}] for factors that are ivs influencing treatment: {{treatment}}, and do not affect outcome: {{outcome}}. If factor causes treatment: {{treatment}}, and does not cause outcome: {{outcome}} on causal chain, then ignore feedback mechanisms/other factors not in list. Answer in <thinking></thinking>. (2) Use prior thoughts to answer: Identify high-likelihood instrumental variables influencing treatment: {{treatment}}, that do not affect outcome: {{outcome}} on causal chain. Ignore feedback mechanisms/other factors not in list. Wrap mediating factors in <iv_factor>factor_name</iv_factor> from {{factors_list}}. {{gen "output" temperature=temperature}}""",
    },
    "chat": {
        "expertises": """{{#system~}} You are a helpful assistant for recommending useful domain expertises. {{~/system}}  {{#user~}} What domain expertises have the knowledge and experience needed to identify causal relationships and causal influences between the {{analysis_context}}? What domain expertises are needed to work with and reason about the causal influence between {{factors_list}}? What domain expertises have the knowledge and experience to reason and answer questions about influence and cause between such factors? Think about this in a step by step manner and recommend {{n_experts}} expertises and provide each one wrapped within the tags, <domain_expertise></domain_expertise>, along with the reasoning and explanation wrapped between the tags <explanation></explanation>. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "domain_experts": """{{#system~}} You are a helpful assistant for recommending useful domain experts. {{~/system}} {{#user~}} What domain expertises ave the knowledge and experience needed to identify causal relationships and causal influences between the {{analysis_context}}? What domain expertises are needed to work with and reason about the causal influence between {{factors_list}}? What domain expertises have the knowledge and experience to reason and answer questions about influence and cause between such factors? Think about this in a step by step manner and recommend {{n_experts}} expertises and provide each one wrapped within the tags, <domain_expert></domain_expert>, along with the reasoning and explanation wrapped between the tags <explanation></explanation>. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "stakeholders": """{{#system~}} You are a helpful assistant for recommending useful primary and seconday stakeholders. {{~/system}} {{#user~}} What domain expertises have the knowledge and experience needed to identify causal relationships and causal influences between the {{analysis_context}}? What domain expertises are needed to work with and reason about the causal influence between {{factors_list}}? What domain expertises have the knowledge and experience to reason and answer questions about influence and cause between such factors? Think about this in a step by step manner and recommend {{n_experts}} stakeholders and provide each one wrapped within the tags, <stakeholder></stakeholder>, along with the reasoning and explanation wrapped between the tags <explanation></explanation>. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_parents": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. {{~/system}} {{#user~}} You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing and causing the {{factor}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}} think step by step as you consider the relevant factor directly influencing and causing the {{factor}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}} which of the following factors has a high likelihood of directly influencing and causing the {{factor}}? factors list: [{{factors_list}}] For any factors within the list with a high likelihood of directly influencing and causing the {{factor}} wrap the name of the factor with the tags <influencing_factor>factor_name</influencing_factor>. If a factor does not have a high likelihood of directly influencing and causing the {{factor}}, then do not wrap the factor with any tags. Your answer as an expert in {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_children": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. {{~/system}} {{#user~}} You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing and causing the {{factor}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: (1) From your perspective as an expert in {{domain_expertise}} think step by step as you consider which factor(s), from the factors list, if any at all, is/are directly influenced and caused by the {{factor}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}}, which of the following factor(s) from the factors list, if any at all, has/have a high likelihood of being directly influenced and caused by the {{factor}}? What factor(s) from the factors list, if any at all, is/are affected by the {{factor}}? factors list: [{{factors_list}}] For any factors within the list with a high likelihood of being directly influenced and caused by the {{factor}}, wrap the name of the factor with the tags <influencing_factor>factor_name</influencing_factor>. If a factor has a high likelihood of being affected and influenced by the {{factor}}, then wrap the name of the factor with the tags <influencing_factor>factor_name</influencing_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of directly influencing and causing the {{factor}}, then do not wrap the factor with any tags. Your answer as an expert in {{domain_expertise}}:   {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_group_suggests_parents": """{{#system~}} Your task is to role play the part of each domain expert: {{top_expertises}}. Use the domain knowledge of each expert to respond as they may have done. Stay in character, do not break character. {{~/system}} {{#user~}} These characters are conducting a study about {{analysis_context}} becuase they wish to find factors with a high likelihood of directly influencing and causing the {{factor}}. Each expert has identified the factors they consider to be influencing and causing the {{factor}} and added them to this list. [{{suggested_factors_list}}] From the factors identified, they now wish to validate the factors that are influencing and causing the {{factor}} from those that are not influencing and causing the {{factor}}. Each domain expert character should critique the other's response and they should all debate amongst themselves in order to unanimously arrive at the factors with the highest likelihood of influecing and causing the {{factor}}. Provide the step by step debate between the experts within the tags <debate></debate>. Return the discussion between the experts within the tags <debate></debate>. When they are done debating, return each factor wrapped within the tags <influencing_factor>factor_name</influencing_factor>. If they have arrived a conclusion, output each factor, wrapped within the tags <influencing_factor>factor_name</influencing_factor>. Once they unanimously arrive at the the factors with the highest likelihood of influecing and causing the {{factor}}, provide each factor wrapped within the tags <influencing_factor>factor_name</influencing_factor>. When done, return the tag <end> so that no information gets lost. If you are done listing the factors, provide the tag <end>. If you are done, output <end>. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_parent_relationships": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the factors that are directly influencing and causing the {{factor}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. {{~/system}} {{#user~}} From your perspective as an expert in {{domain_expertise}} think step by step as you consider which relationship has the highest likelihood of being true: (A) {{a}} has a high likelihood of directly influencing and causing the {{b}}. (B) {{b}} has a high likelihood of directly influencing and causing the {{a}}. (C) Both A and B. (D) Neither A nor B. Select the answer that you as an expert in {{domain_expertise}} believe has the likelihood of being true. When you reach a conclusion, wrap your answer within the tags <answer></answer>. If you are done thinking, provide your answer wrapped within the tags <answer></answer>. e.g. <answer>A</answer>, <answer>B</answer>, <answer>C</answer>, or <answer>D</answer>). Your answer as an expert in {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_pairwise_relationships": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge as an expert in {{domain_expertise}}. {{~/system}} {{#user~}} From your perspective as an expert in {{domain_expertise}}, which of the following is most likely true? (A) {{a}} affects {{b}}; {{a}} has a high likelihood of directly influencing {{b}}; and {{a}} causes {{b}}. (B) {{b}} affects {{a}}; {{b}} has a high likelihood of directly influencing {{a}}; and {{b}} causes {{a}}. (C) Neither A nor B; {{a}} does not cause {{b}}; and {{b}} does not cause {{a}}. Select the answer that you as an expert in {{domain_expertise}} believe has the likelihood of being true. Think step by step and provide your thoughts within the tags <thinking></thinking>. Then select that answer A, B, or C, that is causally correct. When you reach a conclusion, wrap your answer within the tags <answer></answer>. If you are done thinking, provide your answer wrapped within the tags <answer></answer>. e.g. <answer>A</answer>, <answer>B</answer>, or <answer>C</answer>. Your answer as an expert in {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_confounders": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: {{~/system}} {{#user~}} (1) From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors that may interact between the {{treatment}} and the {{outcome}}. Use your knowlegde as an expert in {{domain_expertise}} to describe the confounders, if there are any at all, between the {{treatment}} and the {{outcome}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if any at all, has/have a high likelihood of directly influencing and causing both the assignment of the {{treatment}} and the {{outcome}}? Which factor(s) of the following factors, if any at all, have a causal chain that links to the {{treatment}} to the {{outcome}}? Which factor(s) of the following factors, if any at all, are a confounder to the causal relationship between the {{treatment}} and the {{outcome}}? Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. factor_names : {{factors_list}} Wrap the name of the factor(s), if any at all, that has/have a high likelihood of directly influencing and causing both  the {{treatment}} and the {{outcome}}, within the tags <confounding_factor>factor_name</confounding_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of directly confoundin {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_mediators": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: {{~/system}} {{#user~}} (1) From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors that may interact between the {{treatment}} and the {{outcome}}. Use your knowlegde as an expert in {{domain_expertise}} to describe the mediators, if there are any at all, betweem {{treatment}} and the {{outcome}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>.  (2) From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if any at all, has/have a high likelihood of directly influencing and causing the assignment of the {{outcome}} and also has/have a high likelihood of being directly influenced and caused by the assignment of the {{treatment}}? Which factor(s) of the following factors, if any at all, is/are on the causal chain that links the {{treatment}} to the {{outcome}}? From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if any at all, mediates, is/are on the causal chain, that links the {{treatment}} to the {{outcome}}? Then provide your step by step chain of thoughts within the tags <thinking></thinking>. factor_names : {{factors_list}} Wrap the name of the factor(s), if any at all, that has/have a high likelihood of directly influencing and causing the assignment of the {{outcome}} and also has/have a high likelihood of being directly influenced and caused by the assignment of the {{treatment}} within the tags <mediating_factor>factor_name</mediating_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of mediating, then do not wrap the factor with any tags. Your step by step answer as an in {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_ivs": """{{#system~}} You are an expert in {{domain_expertise}} and are studying {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in {{domain_expertise}}. Follow the next two steps, and complete the first one before moving on to the second: {{~/system}} {{#user~}} (1) From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors that may interact with the {{treatment}} and do not interact with {{outcome}}. Use your knowlegde as an expert in {{domain_expertise}} to describe the instrumental variable(s), if there are any at all, that both has/have a high likelihood of influecing and causing the {{treatment}} and has/have a very low likelihood of influencing and causing the {{outcome}}. Be concise and keep your thinking within two paragraphs.  Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in {{domain_expertise}}, which factor(s) of the following factors, if there are any at all, both has/have a high likelihood of influecing and causing the {{treatment}} and has/have a very low likelihood of influencing and causing the {{outcome}}? Which factor(s) of the following factors, if any at all, has/have a causal link to the {{treatment}} and has not causal link to the {{outcome}}? Which factor(s) of the following factors, if any at all, are (an) instrumental variable(s) to the causal relationship of the {{treatment}} causing the {{outcome}}? Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. factor_names : {{factors_list}} Wrap the name of the factor(s), if there are any at all, that both has/have a high likelihood of influecing and causing the {{treatment}} and has/have a very low likelihood of influencing and causing the {{outcome}}, within the tags <iv_factor>factor_name</iv_factor>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of being an instrumental variable, then do not wrap the factor with any tags. Your step by step answer as an in {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_latent_confounders": """{{#system~}} You are an expert in the {{domain_expertise}} and are studying the {{analysis_context}}. You are using your knowledge to help build a causal model that contains all the assumptions about the {{domain_expertise}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by by answering questions about cause and effect and using your domain knowledge in the {{domain_expertise}}. {{~/system}} {{#user~}} (1) From your perspective as an expert in the {{domain_expertise}}, think step by step as you consider the factors that may interact between the {{treatment}} and the {{outcome}}. Use your knowlegde as an expert in the {{domain_expertise}} to describe the confounders, if there are any at all, between the {{treatment}} and the {{outcome}}. Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. (2) From your perspective as an expert in the {{domain_expertise}}, which factor(s), if any at all, has/have a high likelihood of directly influencing and causing both the assignment of the {{treatment}} and the {{outcome}}? Which factor(s), if any at all, have a causal chain that links to the {{treatment}} to the {{outcome}}? Which factor(s), if any at all, are a confounder to the causal relationship between the {{treatment}} and the {{outcome}}? Be concise and keep your thinking within two paragraphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. Wrap the name of the factor(s), if any at all, that has/have a high likelihood of directly influencing and causing both the {{treatment}} and the {{outcome}}, within the tags <confounding_factor>factor_name</confounding_factor>. If a factor does not have a high likelihood of directly confounding, then do not wrap the factor with any tags. Your step by step answer as an expert in the {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_latent_negative_controls": """{{#system~}} You are an expert in {{domain_expertise}} and are studying the {{analysis_context}}. You are using your domain knowledge to help understand the negative controls for a causal model that contains all the assumptions about the {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by answering questions about cause and effect using your domain knowledge in the {{domain_expertise}}. {{~/system}} {{#user~}} From your perspective as an expert in {{domain_expertise}}, think step by step as you consider the factors, relevant to the {{analysis_context}}, in which we should see zero treatment effect when changing the {{treatment}}? What factors, relevant to the {{analysis_context}}, are negative controls on the causal mechanisms that affect the {{outcome}} when changing {{treatment}}? Using your domain knowledge, what factors, relevant to the {{analysis_context}}, should we expect to be unaffected by any changes to {{treatment}}? What factors would be surprising to see affected by a change made to the {{treatment}}? Be concise and keep your thoughts under two paragaphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. Once you have thought things through, wrap the name of the factor(s) that has/have a high likelihood of being negative controls on the causal mechanisms that affect {{outcome}} when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. Wrap the name of the factor(s) that has/have a high likelihood of being unaffected when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. If a factor does not have a high likelihood of being a negative control relevant to the {{analysis_context}}, then do not wrap the factor with any tags. Provide your step by step answer as an expert in {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_suggests_negative_controls": """{{#system~}} You are an expert in the {{domain_expertise}} and are studying the {{analysis_context}}. You are using your domain knowledge to help understand the negative controls for a causal model that contains all the assumptions about the {{analysis_context}}. Where a causal model is a conceptual model that describes the causal mechanisms of a system. You will do this by answering questions about cause and effect using your domain knowledge in the {{domain_expertise}}. {{~/system}} {{#user~}} factor_names: {{factors_list}} From your perspective as an expert in the {{domain_expertise}}, what factor(s) from the list of factors, relevant to the {{analysis_context}}, should see zero treatment effect when changing the {{treatment}}? Which factor(s) from the list of factors, if any at all, relevant to the {{analysis_context}}, are negative controls on the causal mechanisms that affect the {{outcome}} when changing {{treatment}}? Using your domain knowledge, which factor(s) from the list of factors, if any at all, relevant to the {{analysis_context}}, should we expect to be unaffected by any changes in {{treatment}}? Which factor(s) from the list of factors, if any at all, would be surprising if affected by a change in {{treatment}}? Be concise and keep your thoughts under two paragaphs. Then provide your step by step chain of thoughts within the tags <thinking></thinking>. Once you have thought things through, wrap the name of the factor(s) from the list of factors, that has/have a high likelihood of being negative controls on the causal mechanisms that affect {{outcome}} when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. Wrap the name of the factor(s) from the list of factors, that has/have a high likelihood of being unaffected when changing {{treatment}}, within the tags <negative_control>factor_name</negative_control>. Where factor_name is one of the items within the factor_names list. If a factor does not have a high likelihood of being a negative control relevant to the {{analysis_context}}, then do not wrap the factor with any tags. Provide your step by step answer as an expert in the {{domain_expertise}}: {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_critiques_parents": """{{#system~}} U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors causing {{factor}}. {{~/system}} {{#user~}} Steps: (1) Analyze potential factors [{{potential_factors_list}}] for factors directly influencing/causing/affecting {{factor}}. Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{factor}} influenced/caused/affected by  [{{potential_factors_list}}]? Is relationship direct? Ignore feedback mechanisms/factors not in list. Wrap factors highly likely directly influencing/causing/affecting {{factor}} in <influencing_factor></influencing_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_critiques_children": """{{#system~}} U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify factors caused by {{factor}}.  {{~/system}} {{#user~}} Steps: (1) Analyze potential factors [{{potential_factors_list}}] for factors directly influenced/caused/affected by {{factor}}. Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to answer: how {{factor}} influences/causes/affects [{{potential_factors_list}}]? Is relationship direct? Ignore feedback mechanisms/factors not in list. Wrap factors highly likely directly influenced/caused/affected by {{factor}} in <influenced_factor></influenced_factor> tags. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
        "expert_critiques_pairwise": """{{#system~}} U: helpful causal assistant, expert in {{domain_expertise}}, studying {{analysis_context}}. Task: identify relationship between {{a}} and {{b}}. {{~/system}} {{#user~}} Steps: (1) Does {{a}} influence/cause/affect {{b}}? Is relationship direct? Does {{b}} influence/cause/affect {{a}}? Is relationship direct? Ignore feedback mechanisms/factors not in list. Keep thoughts within <thinking></thinking> tags. (2) Use prior thoughts to select likely answer: (A) {{a}} influences {{b}} (B) {{b}} influences {{a}} (C) Neither. Wrap answer in <answer></answer>. e.g. <answer>A</answer>, <answer>B</answer>, <answer>C</answer>. No tags for low likelihood factors. Ignore feedback mechanisms/factors not in list. Answer as {{domain_expertise}} expert. {{~/user}} {{#assistant~}} {{gen "output" temperature=temperature}} {{~/assistant}}""",
    },
}
