# LLMstudio by [TensorOps](http://tensorops.ai "TensorOps")

Prompt Engineering at your fingertips

![LLMstudio logo](https://imgur.com/Xqsj6V2.gif)

## 🌟 Features

![LLMstudio UI](https://imgur.com/zBnhtTN.png)

1.  **Python Client Gateway**: Seamless integration with multiple LLMs and chaining libraries such as LangChain.
2.  **Prompt Editing UI**: An intuitive interface designed for prompt engineering.
3.  **History Management**: Track past runs and easily export your data as needed.

### 👀 Coming soon:

- Multiple LLM comparison
- Prompt testing and validation
- Projects and sessions
- API keys manager

## 🚀 Quick Install

Install the SDK using

```
pip install llmstudio
```

Clone the repo and run the following command at root level

```
docker-compose up --build
```

You can access the UI at http://localhost:3000

## 🤔 About LLMstudio

Powered by TensorOps, LLMstudio redefines your experience with OpenAI, Vertex Ai and more language model providers. More than just a tool, it’s an evolving environment where teams can experiment, modify, and optimize their interactions with advanced language models.

Benefits include:

- **Streamlined Prompt Engineering**: Simplify and enhance your prompt design process.
- **Execution History**: Keep a detailed log of past executions, track progress, and make iterative improvements effortlessly.
- **Effortless Data Export**: Share your team's endeavors by exporting data to shareable CSV files.

Step into the future of AI with LLMstudio, by watching our [introduction video](https://www.youtube.com/watch?v=I9h701fbD18)

## 📖 Documentation

- [Visit our docs to learn how the SDK works](https://docs.llmstudio.ai) (coming soon)
- Checkout our [notebook examples](https://github.com/TensorOpsAI/LLMstudio/tree/main/examples) to follow along with interactive tutorials
- Checkout out [LLMStudio Architecture Roadmap](https://github.com/TensorOpsAI/LLMstudio/blob/main/docs/llmstudio-architecture/llmstudio-architecture-roadmap.md)

## 👨‍💻 Contributing

- Head on to our [Contribution Guide](https://github.com/TensorOpsAI/LLMstudio/tree/main/CONTRIBUTING.md) to see how you can help LLMstudio.

---

Thank you for choosing LLMstudio. Your journey to perfecting AI interactions begins here.
