# coding: utf-8

"""
    Connection Rest API 1.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BaseTemplateConversion(BaseModel):
    """
    BaseTemplateConversion
    """ # noqa: E501
    original_value: Optional[StrictStr] = Field(default=None, alias="originalValue")
    original_template_id: Optional[StrictStr] = Field(default=None, alias="originalTemplateId")
    new_value: Optional[StrictStr] = Field(default=None, alias="newValue")
    description: Optional[StrictStr] = None
    new_template_id: Optional[StrictStr] = Field(default=None, alias="newTemplateId")
    __properties: ClassVar[List[str]] = ["originalValue", "originalTemplateId", "newValue", "description", "newTemplateId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseTemplateConversion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if original_value (nullable) is None
        # and model_fields_set contains the field
        if self.original_value is None and "original_value" in self.model_fields_set:
            _dict['originalValue'] = None

        # set to None if original_template_id (nullable) is None
        # and model_fields_set contains the field
        if self.original_template_id is None and "original_template_id" in self.model_fields_set:
            _dict['originalTemplateId'] = None

        # set to None if new_value (nullable) is None
        # and model_fields_set contains the field
        if self.new_value is None and "new_value" in self.model_fields_set:
            _dict['newValue'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if new_template_id (nullable) is None
        # and model_fields_set contains the field
        if self.new_template_id is None and "new_template_id" in self.model_fields_set:
            _dict['newTemplateId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseTemplateConversion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "originalValue": obj.get("originalValue"),
            "originalTemplateId": obj.get("originalTemplateId"),
            "newValue": obj.get("newValue"),
            "description": obj.get("description"),
            "newTemplateId": obj.get("newTemplateId")
        })
        return _obj


