module IntXbar(
  input   auto_int_in_0,
  input   auto_int_in_1,
  input   auto_int_in_2,
  input   auto_int_in_3,
  output  auto_int_out_0,
  output  auto_int_out_1,
  output  auto_int_out_2,
  output  auto_int_out_3
);
  assign auto_int_out_0 = auto_int_in_0; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_int_out_1 = auto_int_in_1; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_int_out_2 = auto_int_in_2; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_int_out_3 = auto_int_in_3; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
endmodule
module NonSyncResetSynchronizerPrimitiveShiftReg_d3(
  input   clock,
  input   io_d,
  output  io_q
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
`endif // RANDOMIZE_REG_INIT
  reg  sync_0; // @[SynchronizerReg.scala 51:66]
  reg  sync_1; // @[SynchronizerReg.scala 51:66]
  reg  sync_2; // @[SynchronizerReg.scala 51:66]
  assign io_q = sync_0; // @[SynchronizerReg.scala 59:8]
  always @(posedge clock) begin
    sync_0 <= sync_1; // @[SynchronizerReg.scala 57:10]
    sync_1 <= sync_2; // @[SynchronizerReg.scala 57:10]
    sync_2 <= io_d; // @[SynchronizerReg.scala 54:22]
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  sync_0 = _RAND_0[0:0];
  _RAND_1 = {1{`RANDOM}};
  sync_1 = _RAND_1[0:0];
  _RAND_2 = {1{`RANDOM}};
  sync_2 = _RAND_2[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module SynchronizerShiftReg_w4_d3(
  input        clock,
  input  [3:0] io_d,
  output [3:0] io_q
);
  wire  output_chain_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_io_q; // @[ShiftReg.scala 45:23]
  wire  output_chain_1_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_1_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_1_io_q; // @[ShiftReg.scala 45:23]
  wire  output_chain_2_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_2_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_2_io_q; // @[ShiftReg.scala 45:23]
  wire  output_chain_3_clock; // @[ShiftReg.scala 45:23]
  wire  output_chain_3_io_d; // @[ShiftReg.scala 45:23]
  wire  output_chain_3_io_q; // @[ShiftReg.scala 45:23]
  wire  output_1 = output_chain_1_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire  output_0 = output_chain_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire [1:0] io_q_lo = {output_1,output_0}; // @[Cat.scala 30:58]
  wire  output_3 = output_chain_3_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire  output_2 = output_chain_2_io_q; // @[ShiftReg.scala 48:24 ShiftReg.scala 48:24]
  wire [1:0] io_q_hi = {output_3,output_2}; // @[Cat.scala 30:58]
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_clock),
    .io_d(output_chain_io_d),
    .io_q(output_chain_io_q)
  );
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain_1 ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_1_clock),
    .io_d(output_chain_1_io_d),
    .io_q(output_chain_1_io_q)
  );
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain_2 ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_2_clock),
    .io_d(output_chain_2_io_d),
    .io_q(output_chain_2_io_q)
  );
  NonSyncResetSynchronizerPrimitiveShiftReg_d3 output_chain_3 ( // @[ShiftReg.scala 45:23]
    .clock(output_chain_3_clock),
    .io_d(output_chain_3_io_d),
    .io_q(output_chain_3_io_q)
  );
  assign io_q = {io_q_hi,io_q_lo}; // @[Cat.scala 30:58]
  assign output_chain_clock = clock;
  assign output_chain_io_d = io_d[0]; // @[SynchronizerReg.scala 173:39]
  assign output_chain_1_clock = clock;
  assign output_chain_1_io_d = io_d[1]; // @[SynchronizerReg.scala 173:39]
  assign output_chain_2_clock = clock;
  assign output_chain_2_io_d = io_d[2]; // @[SynchronizerReg.scala 173:39]
  assign output_chain_3_clock = clock;
  assign output_chain_3_io_d = io_d[3]; // @[SynchronizerReg.scala 173:39]
endmodule
module IntSyncAsyncCrossingSink(
  input   clock,
  input   auto_in_sync_0,
  input   auto_in_sync_1,
  input   auto_in_sync_2,
  input   auto_in_sync_3,
  output  auto_out_0,
  output  auto_out_1,
  output  auto_out_2,
  output  auto_out_3
);
  wire  chain_clock; // @[ShiftReg.scala 45:23]
  wire [3:0] chain_io_d; // @[ShiftReg.scala 45:23]
  wire [3:0] chain_io_q; // @[ShiftReg.scala 45:23]
  wire [1:0] chain_io_d_lo = {auto_in_sync_1,auto_in_sync_0}; // @[ShiftReg.scala 47:22]
  wire [1:0] chain_io_d_hi = {auto_in_sync_3,auto_in_sync_2}; // @[ShiftReg.scala 47:22]
  wire [3:0] _WIRE_1 = chain_io_q;
  SynchronizerShiftReg_w4_d3 chain ( // @[ShiftReg.scala 45:23]
    .clock(chain_clock),
    .io_d(chain_io_d),
    .io_q(chain_io_q)
  );
  assign auto_out_0 = _WIRE_1[0]; // @[ShiftReg.scala 48:24]
  assign auto_out_1 = _WIRE_1[1]; // @[ShiftReg.scala 48:24]
  assign auto_out_2 = _WIRE_1[2]; // @[ShiftReg.scala 48:24]
  assign auto_out_3 = _WIRE_1[3]; // @[ShiftReg.scala 48:24]
  assign chain_clock = clock;
  assign chain_io_d = {chain_io_d_hi,chain_io_d_lo}; // @[ShiftReg.scala 47:22]
endmodule
module SimpleClockGroupSource(
  input   clock,
  input   reset,
  output  auto_out_member_subsystem_sbus_5_clock,
  output  auto_out_member_subsystem_sbus_5_reset,
  output  auto_out_member_subsystem_sbus_4_clock,
  output  auto_out_member_subsystem_sbus_4_reset,
  output  auto_out_member_subsystem_sbus_3_clock,
  output  auto_out_member_subsystem_sbus_3_reset,
  output  auto_out_member_subsystem_sbus_2_clock,
  output  auto_out_member_subsystem_sbus_2_reset,
  output  auto_out_member_subsystem_sbus_1_clock,
  output  auto_out_member_subsystem_sbus_1_reset,
  output  auto_out_member_subsystem_sbus_0_clock,
  output  auto_out_member_subsystem_sbus_0_reset
);
  assign auto_out_member_subsystem_sbus_5_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_5_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_4_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_4_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_3_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_3_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_2_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_2_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_1_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_1_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
  assign auto_out_member_subsystem_sbus_0_clock = clock; // @[Nodes.scala 1207:84 ClockGroup.scala 72:17]
  assign auto_out_member_subsystem_sbus_0_reset = reset; // @[Nodes.scala 1207:84 ClockGroup.scala 72:35]
endmodule
module FixedClockBroadcast(
  input   auto_in_clock,
  input   auto_in_reset,
  output  auto_out_2_clock,
  output  auto_out_2_reset,
  output  auto_out_1_clock,
  output  auto_out_0_clock,
  output  auto_out_0_reset
);
  assign auto_out_2_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_2_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_clock = auto_in_clock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_reset = auto_in_reset; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
endmodule
module TLMonitor(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [3:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [3:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [63:0] _RAND_14;
  reg [127:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [127:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T_1 = ~io_in_a_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok = _source_ok_T_1 | io_in_a_bits_source[3]; // @[Parameters.scala 1163:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_71 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_71; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  mask_sub_acc = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_sub_acc_1 = mask_sub_acc | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_sub_acc_2 = mask_sub_acc | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_sub_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_3 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_2; // @[Misc.scala 214:29]
  wire  mask_sub_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_4 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_3; // @[Misc.scala 214:29]
  wire  mask_sub_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_5 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_4; // @[Misc.scala 214:29]
  wire  mask_sub_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_6 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq = mask_sub_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_sub_acc_3 | mask_size_2 & mask_eq; // @[Misc.scala 214:29]
  wire  mask_eq_1 = mask_sub_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_sub_acc_3 | mask_size_2 & mask_eq_1; // @[Misc.scala 214:29]
  wire  mask_eq_2 = mask_sub_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_sub_acc_4 | mask_size_2 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_sub_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_sub_acc_4 | mask_size_2 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_sub_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_sub_acc_5 | mask_size_2 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_sub_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_sub_acc_5 | mask_size_2 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_eq_6 = mask_sub_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_sub_acc_6 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_sub_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_sub_acc_6 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_12 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_34 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25]
  wire  _T_36 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_51 = _T_36 & source_ok; // @[Parameters.scala 1213:30]
  wire  _T_61 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_64 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_65 = {1'b0,$signed(_T_64)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_67 = $signed(_T_65) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_68 = $signed(_T_67) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_69 = _T_61 & _T_68; // @[Parameters.scala 667:56]
  wire  _T_72 = _T_51 & _T_69; // @[Parameters.scala 1422:195]
  wire  _T_101 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_105 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18]
  wire  _T_106 = _T_105 == 8'h0; // @[Monitor.scala 90:31]
  wire  _T_110 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18]
  wire  _T_114 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25]
  wire  _T_185 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31]
  wire  _T_198 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25]
  wire [31:0] _T_224 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 137:31]
  wire [32:0] _T_225 = {1'b0,$signed(_T_224)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_227 = $signed(_T_225) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_228 = $signed(_T_227) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_229 = _T_36 & _T_228; // @[Parameters.scala 667:56]
  wire [32:0] _T_237 = $signed(_T_12) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_238 = $signed(_T_237) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_239 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_240 = {1'b0,$signed(_T_239)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_242 = $signed(_T_240) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_243 = $signed(_T_242) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_244 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_245 = {1'b0,$signed(_T_244)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_247 = $signed(_T_245) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_248 = $signed(_T_247) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_249 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_250 = {1'b0,$signed(_T_249)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_252 = $signed(_T_250) & 33'shf8000000; // @[Parameters.scala 137:52]
  wire  _T_253 = $signed(_T_252) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_254 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_255 = {1'b0,$signed(_T_254)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_257 = $signed(_T_255) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _T_258 = $signed(_T_257) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_259 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_260 = {1'b0,$signed(_T_259)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_262 = $signed(_T_260) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _T_263 = $signed(_T_262) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_264 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_265 = {1'b0,$signed(_T_264)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_267 = $signed(_T_265) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _T_268 = $signed(_T_267) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_280 = _T_238 | _T_243 | _T_248 | _T_253 | _T_258 | _T_263 | _T_268 | _T_68; // @[Parameters.scala 668:42]
  wire  _T_281 = _T_61 & _T_280; // @[Parameters.scala 667:56]
  wire  _T_283 = _T_229 | _T_281; // @[Parameters.scala 669:30]
  wire  _T_293 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31]
  wire  _T_297 = io_in_a_bits_mask == mask; // @[Monitor.scala 112:30]
  wire  _T_305 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25]
  wire  _T_360 = _T_238 | _T_248 | _T_253 | _T_68; // @[Parameters.scala 668:42]
  wire  _T_361 = _T_61 & _T_360; // @[Parameters.scala 667:56]
  wire  _T_370 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_389 = _T_258 | _T_263 | _T_268; // @[Parameters.scala 668:42]
  wire  _T_390 = _T_370 & _T_389; // @[Parameters.scala 667:56]
  wire  _T_394 = _T_229 | _T_361 | _T_390; // @[Parameters.scala 669:30]
  wire  _T_395 = _T_51 & _T_394; // @[Parameters.scala 1426:195]
  wire  _T_413 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25]
  wire [7:0] _T_517 = ~mask; // @[Monitor.scala 129:33]
  wire [7:0] _T_518 = io_in_a_bits_mask & _T_517; // @[Monitor.scala 129:31]
  wire  _T_519 = _T_518 == 8'h0; // @[Monitor.scala 129:40]
  wire  _T_523 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25]
  wire  _T_543 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire [32:0] _T_549 = $signed(_T_12) & 33'shf8010000; // @[Parameters.scala 137:52]
  wire  _T_550 = $signed(_T_549) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_556 = _T_550 | _T_253; // @[Parameters.scala 668:42]
  wire  _T_557 = _T_543 & _T_556; // @[Parameters.scala 667:56]
  wire  _T_591 = _T_51 & _T_557; // @[Parameters.scala 1423:195]
  wire  _T_601 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_609 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25]
  wire  _T_687 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_695 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25]
  wire  _T_775 = _T_51 & _T_229; // @[Parameters.scala 1428:195]
  wire  _T_785 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_797 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_13 = ~io_in_d_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok_1 = _source_ok_T_13 | io_in_d_bits_source[3]; // @[Parameters.scala 1163:46]
  wire  _T_801 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25]
  wire  _T_805 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27]
  wire  _T_809 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28]
  wire  _T_813 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15]
  wire  _T_817 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15]
  wire  _T_821 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25]
  wire  _T_832 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_836 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28]
  wire  _T_849 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25]
  wire  _T_869 = _T_817 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30]
  wire  _T_878 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25]
  wire  _T_895 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25]
  wire  _T_913 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 386:22]
  reg [2:0] param; // @[Monitor.scala 387:22]
  reg [3:0] size; // @[Monitor.scala 388:22]
  reg [3:0] source; // @[Monitor.scala 389:22]
  reg [31:0] address; // @[Monitor.scala 390:22]
  wire  _T_943 = io_in_a_valid & ~a_first; // @[Monitor.scala 391:19]
  wire  _T_944 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 392:32]
  wire  _T_948 = io_in_a_bits_param == param; // @[Monitor.scala 393:32]
  wire  _T_952 = io_in_a_bits_size == size; // @[Monitor.scala 394:32]
  wire  _T_956 = io_in_a_bits_source == source; // @[Monitor.scala 395:32]
  wire  _T_960 = io_in_a_bits_address == address; // @[Monitor.scala 396:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 537:22]
  reg [1:0] param_1; // @[Monitor.scala 538:22]
  reg [3:0] size_1; // @[Monitor.scala 539:22]
  reg [3:0] source_1; // @[Monitor.scala 540:22]
  reg [1:0] sink; // @[Monitor.scala 541:22]
  reg  denied; // @[Monitor.scala 542:22]
  wire  _T_967 = io_in_d_valid & ~d_first; // @[Monitor.scala 543:19]
  wire  _T_968 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 544:29]
  wire  _T_972 = io_in_d_bits_param == param_1; // @[Monitor.scala 545:29]
  wire  _T_976 = io_in_d_bits_size == size_1; // @[Monitor.scala 546:29]
  wire  _T_980 = io_in_d_bits_source == source_1; // @[Monitor.scala 547:29]
  wire  _T_984 = io_in_d_bits_sink == sink; // @[Monitor.scala 548:29]
  wire  _T_988 = io_in_d_bits_denied == denied; // @[Monitor.scala 549:29]
  reg [15:0] inflight; // @[Monitor.scala 613:27]
  reg [63:0] inflight_opcodes; // @[Monitor.scala 615:35]
  reg [127:0] inflight_sizes; // @[Monitor.scala 617:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [5:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69]
  wire [6:0] _a_opcode_lookup_T = {{1'd0}, _GEN_72}; // @[Monitor.scala 636:69]
  wire [63:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 636:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 611:57]
  wire [63:0] _GEN_73 = {{48'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 636:97]
  wire [63:0] _a_opcode_lookup_T_6 = _a_opcode_lookup_T_1 & _GEN_73; // @[Monitor.scala 636:97]
  wire [63:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[63:1]}; // @[Monitor.scala 636:152]
  wire [6:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65]
  wire [127:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 640:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 611:57]
  wire [127:0] _GEN_75 = {{112'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 640:91]
  wire [127:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 640:91]
  wire [127:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[127:1]}; // @[Monitor.scala 640:144]
  wire  _T_994 = io_in_a_valid & a_first_1; // @[Monitor.scala 650:26]
  wire [15:0] _a_set_wo_ready_T = 16'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] a_set_wo_ready = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 650:71 Monitor.scala 651:22]
  wire  _T_997 = _a_first_T & a_first_1; // @[Monitor.scala 654:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 656:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 657:59]
  wire [5:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79]
  wire [6:0] _a_opcodes_set_T = {{1'd0}, _GEN_77}; // @[Monitor.scala 658:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 656:28]
  wire [130:0] _GEN_78 = {{127'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54]
  wire [130:0] _a_opcodes_set_T_1 = _GEN_78 << _a_opcodes_set_T; // @[Monitor.scala 658:54]
  wire [6:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 654:72 Monitor.scala 657:28]
  wire [131:0] _GEN_79 = {{127'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52]
  wire [131:0] _a_sizes_set_T_1 = _GEN_79 << _a_sizes_set_T; // @[Monitor.scala 659:52]
  wire [15:0] _T_999 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26]
  wire  _T_1001 = ~_T_999[0]; // @[Monitor.scala 660:17]
  wire [15:0] a_set = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 654:72 Monitor.scala 655:28]
  wire [130:0] _GEN_19 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 131'h0; // @[Monitor.scala 654:72 Monitor.scala 658:28]
  wire [131:0] _GEN_20 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 132'h0; // @[Monitor.scala 654:72 Monitor.scala 659:28]
  wire  _T_1005 = io_in_d_valid & d_first_1; // @[Monitor.scala 673:26]
  wire  _T_1007 = ~_T_801; // @[Monitor.scala 673:74]
  wire  _T_1008 = io_in_d_valid & d_first_1 & ~_T_801; // @[Monitor.scala 673:71]
  wire [15:0] _d_clr_wo_ready_T = 16'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] d_clr_wo_ready = io_in_d_valid & d_first_1 & ~_T_801 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 673:90 Monitor.scala 674:22]
  wire [142:0] _GEN_81 = {{127'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 679:76]
  wire [142:0] _d_opcodes_clr_T_5 = _GEN_81 << _a_opcode_lookup_T; // @[Monitor.scala 679:76]
  wire [142:0] _GEN_82 = {{127'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 680:74]
  wire [142:0] _d_sizes_clr_T_5 = _GEN_82 << _a_size_lookup_T; // @[Monitor.scala 680:74]
  wire [15:0] d_clr = _d_first_T & d_first_1 & _T_1007 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 677:91 Monitor.scala 678:21]
  wire [142:0] _GEN_23 = _d_first_T & d_first_1 & _T_1007 ? _d_opcodes_clr_T_5 : 143'h0; // @[Monitor.scala 677:91 Monitor.scala 679:21]
  wire [142:0] _GEN_24 = _d_first_T & d_first_1 & _T_1007 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 677:91 Monitor.scala 680:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113]
  wire  same_cycle_resp = _T_994 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:88]
  wire [15:0] _T_1018 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25]
  wire  _T_1020 = _T_1018[0] | same_cycle_resp; // @[Monitor.scala 684:49]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire  _T_1025 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 688:39]
  wire  _T_1026 = io_in_d_bits_opcode == _GEN_32 | _T_1025; // @[Monitor.scala 687:77]
  wire  _T_1030 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire  _T_1037 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 692:38]
  wire  _T_1038 = io_in_d_bits_opcode == _GEN_48 | _T_1037; // @[Monitor.scala 691:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36]
  wire  _T_1042 = _GEN_83 == a_size_lookup; // @[Monitor.scala 693:36]
  wire  _T_1052 = _T_1005 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_1007; // @[Monitor.scala 696:116]
  wire  _T_1054 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 697:32]
  wire  _T_1061 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 701:48]
  wire [15:0] _inflight_T = inflight | a_set; // @[Monitor.scala 704:27]
  wire [15:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 704:38]
  wire [15:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 704:36]
  wire [63:0] a_opcodes_set = _GEN_19[63:0];
  wire [63:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43]
  wire [63:0] d_opcodes_clr = _GEN_23[63:0];
  wire [63:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 705:62]
  wire [63:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 705:60]
  wire [127:0] a_sizes_set = _GEN_20[127:0];
  wire [127:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39]
  wire [127:0] d_sizes_clr = _GEN_24[127:0];
  wire [127:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 706:56]
  wire [127:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 706:54]
  reg [31:0] watchdog; // @[Monitor.scala 708:27]
  wire  _T_1070 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 711:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 713:26]
  reg [15:0] inflight_1; // @[Monitor.scala 725:35]
  reg [127:0] inflight_sizes_1; // @[Monitor.scala 727:35]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [127:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 749:42]
  wire [127:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 749:93]
  wire [127:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[127:1]}; // @[Monitor.scala 749:146]
  wire  _T_1096 = io_in_d_valid & d_first_2 & _T_801; // @[Monitor.scala 781:71]
  wire [15:0] d_clr_1 = _d_first_T & d_first_2 & _T_801 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 785:90 Monitor.scala 786:21]
  wire [142:0] _GEN_69 = _d_first_T & d_first_2 & _T_801 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 785:90 Monitor.scala 788:21]
  wire [15:0] _T_1104 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_1114 = _GEN_83 == c_size_lookup; // @[Monitor.scala 797:36]
  wire [15:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 811:46]
  wire [15:0] _inflight_T_5 = inflight_1 & _inflight_T_4; // @[Monitor.scala 811:44]
  wire [127:0] d_sizes_clr_1 = _GEN_69[127:0];
  wire [127:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 813:58]
  wire [127:0] _inflight_sizes_T_5 = inflight_sizes_1 & _inflight_sizes_T_4; // @[Monitor.scala 813:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 815:27]
  wire  _T_1139 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 818:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 820:26]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 401:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 402:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 403:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 555:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 556:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 557:15]
    end
    if (reset) begin // @[Monitor.scala 613:27]
      inflight <= 16'h0; // @[Monitor.scala 613:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 704:14]
    end
    if (reset) begin // @[Monitor.scala 615:35]
      inflight_opcodes <= 64'h0; // @[Monitor.scala 615:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 705:22]
    end
    if (reset) begin // @[Monitor.scala 617:33]
      inflight_sizes <= 128'h0; // @[Monitor.scala 617:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 706:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 708:27]
      watchdog <= 32'h0; // @[Monitor.scala 708:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 714:47]
      watchdog <= 32'h0; // @[Monitor.scala 714:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 713:14]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_1 <= 16'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Monitor.scala 727:35]
      inflight_sizes_1 <= 128'h0; // @[Monitor.scala 727:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 813:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 815:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 815:27]
    end else if (_d_first_T) begin // @[Monitor.scala 821:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 821:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 820:14]
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_72 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_72 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_72 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_72 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_185 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_185 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_51 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_51 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_283 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_283 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_395 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_395 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_395 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_395 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_519 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_519 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_591 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_591 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_601 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_601 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_591 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_591 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_687 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_687 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_775 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_775 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_785 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_785 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_797 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_797 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_805 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_805 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_817 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_817 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_805 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_805 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_832 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_832 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_836 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_836 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_805 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_805 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_832 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_832 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_836 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_836 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_869 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_869 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_869 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_869 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_944 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_944 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_948 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_948 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_952 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_952 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_956 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_956 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_960 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_960 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_968 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_968 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_972 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_972 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_976 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_976 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_980 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_980 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_984 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_984 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_988 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_988 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_997 & ~(_T_1001 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_997 & ~(_T_1001 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & ~(_T_1020 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & ~(_T_1020 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1026 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1026 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1030 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1030 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1038 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1038 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1042 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1042 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1052 & ~(_T_1054 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1052 & ~(_T_1054 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1061 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1061 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1070 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1070 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1096 & ~(_T_1104[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1096 & ~(_T_1104[0] | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1096 & ~(_T_1114 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1096 & ~(_T_1114 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1139 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1139 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[3:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[15:0];
  _RAND_14 = {2{`RANDOM}};
  inflight_opcodes = _RAND_14[63:0];
  _RAND_15 = {4{`RANDOM}};
  inflight_sizes = _RAND_15[127:0];
  _RAND_16 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  watchdog = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[15:0];
  _RAND_20 = {4{`RANDOM}};
  inflight_sizes_1 = _RAND_20[127:0];
  _RAND_21 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  watchdog_1 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_1(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [1:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_b_ready,
  input         io_in_b_valid,
  input  [1:0]  io_in_b_bits_param,
  input  [31:0] io_in_b_bits_address,
  input         io_in_c_ready,
  input         io_in_c_valid,
  input  [2:0]  io_in_c_bits_opcode,
  input  [2:0]  io_in_c_bits_param,
  input  [3:0]  io_in_c_bits_size,
  input  [1:0]  io_in_c_bits_source,
  input  [31:0] io_in_c_bits_address,
  input         io_in_c_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [1:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt,
  input         io_in_e_valid,
  input  [1:0]  io_in_e_bits_sink
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T = io_in_a_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_1 = io_in_a_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_2 = io_in_a_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok = _source_ok_T | _source_ok_T_1 | _source_ok_T_2; // @[Parameters.scala 1163:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_86 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_86; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  mask_sub_acc = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_sub_acc_1 = mask_sub_acc | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_sub_acc_2 = mask_sub_acc | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_sub_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_3 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_2; // @[Misc.scala 214:29]
  wire  mask_sub_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_4 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_3; // @[Misc.scala 214:29]
  wire  mask_sub_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_5 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_4; // @[Misc.scala 214:29]
  wire  mask_sub_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_6 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq = mask_sub_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_sub_acc_3 | mask_size_2 & mask_eq; // @[Misc.scala 214:29]
  wire  mask_eq_1 = mask_sub_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_sub_acc_3 | mask_size_2 & mask_eq_1; // @[Misc.scala 214:29]
  wire  mask_eq_2 = mask_sub_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_sub_acc_4 | mask_size_2 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_sub_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_sub_acc_4 | mask_size_2 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_sub_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_sub_acc_5 | mask_size_2 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_sub_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_sub_acc_5 | mask_size_2 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_eq_6 = mask_sub_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_sub_acc_6 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_sub_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_sub_acc_6 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_7 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_33 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25]
  wire  _T_35 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_42 = _T_35 & source_ok; // @[Parameters.scala 1213:30]
  wire  _T_52 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_55 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_56 = {1'b0,$signed(_T_55)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_58 = $signed(_T_56) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_59 = $signed(_T_58) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_60 = _T_52 & _T_59; // @[Parameters.scala 667:56]
  wire  _T_63 = _T_42 & _T_60; // @[Parameters.scala 1422:195]
  wire  _T_70 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 91:48]
  wire  _T_71 = _source_ok_T & _T_70; // @[Mux.scala 27:72]
  wire  _T_87 = _T_71 & _T_35; // @[Parameters.scala 1437:195]
  wire  _T_101 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_105 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18]
  wire  _T_106 = _T_105 == 8'h0; // @[Monitor.scala 90:31]
  wire  _T_110 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18]
  wire  _T_114 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25]
  wire  _T_186 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31]
  wire  _T_199 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25]
  wire [31:0] _T_217 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 137:31]
  wire [32:0] _T_218 = {1'b0,$signed(_T_217)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_220 = $signed(_T_218) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_221 = $signed(_T_220) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_222 = _T_35 & _T_221; // @[Parameters.scala 667:56]
  wire [32:0] _T_230 = $signed(_T_7) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_231 = $signed(_T_230) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_232 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_233 = {1'b0,$signed(_T_232)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_235 = $signed(_T_233) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_236 = $signed(_T_235) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_237 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_238 = {1'b0,$signed(_T_237)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_240 = $signed(_T_238) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_241 = $signed(_T_240) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_242 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_243 = {1'b0,$signed(_T_242)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_245 = $signed(_T_243) & 33'shf8000000; // @[Parameters.scala 137:52]
  wire  _T_246 = $signed(_T_245) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_247 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_248 = {1'b0,$signed(_T_247)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_250 = $signed(_T_248) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _T_251 = $signed(_T_250) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_252 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_253 = {1'b0,$signed(_T_252)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_255 = $signed(_T_253) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _T_256 = $signed(_T_255) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_257 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_258 = {1'b0,$signed(_T_257)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_260 = $signed(_T_258) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _T_261 = $signed(_T_260) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_273 = _T_231 | _T_236 | _T_241 | _T_246 | _T_251 | _T_256 | _T_261 | _T_59; // @[Parameters.scala 668:42]
  wire  _T_274 = _T_52 & _T_273; // @[Parameters.scala 667:56]
  wire  _T_276 = _T_222 | _T_274; // @[Parameters.scala 669:30]
  wire  _T_286 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31]
  wire  _T_290 = io_in_a_bits_mask == mask; // @[Monitor.scala 112:30]
  wire  _T_298 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25]
  wire  _T_345 = _T_231 | _T_241 | _T_246 | _T_59; // @[Parameters.scala 668:42]
  wire  _T_346 = _T_52 & _T_345; // @[Parameters.scala 667:56]
  wire  _T_355 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_374 = _T_251 | _T_256 | _T_261; // @[Parameters.scala 668:42]
  wire  _T_375 = _T_355 & _T_374; // @[Parameters.scala 667:56]
  wire  _T_379 = _T_222 | _T_346 | _T_375; // @[Parameters.scala 669:30]
  wire  _T_380 = _T_42 & _T_379; // @[Parameters.scala 1426:195]
  wire  _T_398 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25]
  wire [7:0] _T_494 = ~mask; // @[Monitor.scala 129:33]
  wire [7:0] _T_495 = io_in_a_bits_mask & _T_494; // @[Monitor.scala 129:31]
  wire  _T_496 = _T_495 == 8'h0; // @[Monitor.scala 129:40]
  wire  _T_500 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25]
  wire  _T_512 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire [32:0] _T_518 = $signed(_T_7) & 33'shf8010000; // @[Parameters.scala 137:52]
  wire  _T_519 = $signed(_T_518) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_525 = _T_519 | _T_246; // @[Parameters.scala 668:42]
  wire  _T_526 = _T_512 & _T_525; // @[Parameters.scala 667:56]
  wire  _T_560 = _T_42 & _T_526; // @[Parameters.scala 1423:195]
  wire  _T_570 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_578 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25]
  wire  _T_648 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_656 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25]
  wire  _T_728 = _T_42 & _T_222; // @[Parameters.scala 1428:195]
  wire  _T_738 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_750 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_4 = io_in_d_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_5 = io_in_d_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_6 = io_in_d_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_1 = _source_ok_T_4 | _source_ok_T_5 | _source_ok_T_6; // @[Parameters.scala 1163:46]
  wire  _T_754 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25]
  wire  _T_758 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27]
  wire  _T_762 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28]
  wire  _T_766 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15]
  wire  _T_770 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15]
  wire  _T_774 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25]
  wire  _T_785 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_789 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28]
  wire  _T_802 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25]
  wire  _T_822 = _T_770 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30]
  wire  _T_831 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25]
  wire  _T_848 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25]
  wire  _T_866 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25]
  wire [32:0] _T_890 = {1'b0,$signed(io_in_b_bits_address)}; // @[Parameters.scala 137:49]
  wire [31:0] _address_ok_T = io_in_b_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_1 = {1'b0,$signed(_address_ok_T)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_3 = $signed(_address_ok_T_1) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_4 = $signed(_address_ok_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_5 = io_in_b_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_6 = {1'b0,$signed(_address_ok_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_8 = $signed(_address_ok_T_6) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_9 = $signed(_address_ok_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_10 = io_in_b_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_11 = {1'b0,$signed(_address_ok_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_13 = $signed(_address_ok_T_11) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_14 = $signed(_address_ok_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_18 = $signed(_T_890) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_19 = $signed(_address_ok_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_20 = io_in_b_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_21 = {1'b0,$signed(_address_ok_T_20)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_23 = $signed(_address_ok_T_21) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_24 = $signed(_address_ok_T_23) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_25 = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_26 = {1'b0,$signed(_address_ok_T_25)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_28 = $signed(_address_ok_T_26) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_29 = $signed(_address_ok_T_28) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_30 = io_in_b_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_31 = {1'b0,$signed(_address_ok_T_30)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_33 = $signed(_address_ok_T_31) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_34 = $signed(_address_ok_T_33) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_35 = io_in_b_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_36 = {1'b0,$signed(_address_ok_T_35)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_38 = $signed(_address_ok_T_36) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_39 = $signed(_address_ok_T_38) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_40 = io_in_b_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_41 = {1'b0,$signed(_address_ok_T_40)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_43 = $signed(_address_ok_T_41) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_44 = $signed(_address_ok_T_43) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_46 = _address_ok_T_34 | _address_ok_T_39 | _address_ok_T_44; // @[Parameters.scala 598:92]
  wire  address_ok = _address_ok_T_4 | _address_ok_T_9 | _address_ok_T_14 | _address_ok_T_19 | _address_ok_T_24 |
    _address_ok_T_29 | _address_ok_T_46; // @[Parameters.scala 622:64]
  wire [31:0] _is_aligned_T_1 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 20:16]
  wire  is_aligned_1 = _is_aligned_T_1 == 32'h0; // @[Edges.scala 20:24]
  wire  _T_950 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _source_ok_T_8 = io_in_c_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_9 = io_in_c_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_10 = io_in_c_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_2 = _source_ok_T_8 | _source_ok_T_9 | _source_ok_T_10; // @[Parameters.scala 1163:46]
  wire [26:0] _is_aligned_mask_T_7 = 27'hfff << io_in_c_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask_2 = ~_is_aligned_mask_T_7[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_87 = {{20'd0}, is_aligned_mask_2}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T_2 = io_in_c_bits_address & _GEN_87; // @[Edges.scala 20:16]
  wire  is_aligned_2 = _is_aligned_T_2 == 32'h0; // @[Edges.scala 20:24]
  wire [31:0] _address_ok_T_52 = io_in_c_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_53 = {1'b0,$signed(_address_ok_T_52)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_55 = $signed(_address_ok_T_53) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_56 = $signed(_address_ok_T_55) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_57 = io_in_c_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_58 = {1'b0,$signed(_address_ok_T_57)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_60 = $signed(_address_ok_T_58) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_61 = $signed(_address_ok_T_60) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_62 = io_in_c_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_63 = {1'b0,$signed(_address_ok_T_62)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_65 = $signed(_address_ok_T_63) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_66 = $signed(_address_ok_T_65) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_68 = {1'b0,$signed(io_in_c_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_70 = $signed(_address_ok_T_68) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_71 = $signed(_address_ok_T_70) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_72 = io_in_c_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_73 = {1'b0,$signed(_address_ok_T_72)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_75 = $signed(_address_ok_T_73) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_76 = $signed(_address_ok_T_75) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_77 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_78 = {1'b0,$signed(_address_ok_T_77)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_80 = $signed(_address_ok_T_78) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_81 = $signed(_address_ok_T_80) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_82 = io_in_c_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_83 = {1'b0,$signed(_address_ok_T_82)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_85 = $signed(_address_ok_T_83) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_86 = $signed(_address_ok_T_85) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_87 = io_in_c_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_88 = {1'b0,$signed(_address_ok_T_87)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_90 = $signed(_address_ok_T_88) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_91 = $signed(_address_ok_T_90) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_92 = io_in_c_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_93 = {1'b0,$signed(_address_ok_T_92)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_95 = $signed(_address_ok_T_93) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_96 = $signed(_address_ok_T_95) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_98 = _address_ok_T_86 | _address_ok_T_91 | _address_ok_T_96; // @[Parameters.scala 598:92]
  wire  address_ok_1 = _address_ok_T_56 | _address_ok_T_61 | _address_ok_T_66 | _address_ok_T_71 | _address_ok_T_76 |
    _address_ok_T_81 | _address_ok_T_98; // @[Parameters.scala 622:64]
  wire  _T_1199 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 244:25]
  wire  _T_1206 = io_in_c_bits_size >= 4'h3; // @[Monitor.scala 247:30]
  wire  _T_1213 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 120:29]
  wire  _T_1217 = ~io_in_c_bits_corrupt; // @[Monitor.scala 250:18]
  wire  _T_1221 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 253:25]
  wire  _T_1239 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 261:25]
  wire  _T_1241 = io_in_c_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_1248 = _T_1241 & source_ok_2; // @[Parameters.scala 1213:30]
  wire  _T_1258 = io_in_c_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [32:0] _T_1264 = $signed(_address_ok_T_78) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_1265 = $signed(_T_1264) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_1266 = _T_1258 & _T_1265; // @[Parameters.scala 667:56]
  wire  _T_1269 = _T_1248 & _T_1266; // @[Parameters.scala 1422:195]
  wire  _T_1276 = 4'h6 == io_in_c_bits_size; // @[Parameters.scala 91:48]
  wire  _T_1277 = _source_ok_T_8 & _T_1276; // @[Mux.scala 27:72]
  wire  _T_1293 = _T_1277 & _T_1241; // @[Parameters.scala 1437:195]
  wire  _T_1315 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 271:25]
  wire  _T_1387 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 280:25]
  wire  _T_1397 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 284:31]
  wire  _T_1405 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 288:25]
  wire  _T_1419 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 295:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 386:22]
  reg [2:0] param; // @[Monitor.scala 387:22]
  reg [3:0] size; // @[Monitor.scala 388:22]
  reg [1:0] source; // @[Monitor.scala 389:22]
  reg [31:0] address; // @[Monitor.scala 390:22]
  wire  _T_1441 = io_in_a_valid & ~a_first; // @[Monitor.scala 391:19]
  wire  _T_1442 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 392:32]
  wire  _T_1446 = io_in_a_bits_param == param; // @[Monitor.scala 393:32]
  wire  _T_1450 = io_in_a_bits_size == size; // @[Monitor.scala 394:32]
  wire  _T_1454 = io_in_a_bits_source == source; // @[Monitor.scala 395:32]
  wire  _T_1458 = io_in_a_bits_address == address; // @[Monitor.scala 396:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 537:22]
  reg [1:0] param_1; // @[Monitor.scala 538:22]
  reg [3:0] size_1; // @[Monitor.scala 539:22]
  reg [1:0] source_1; // @[Monitor.scala 540:22]
  reg [1:0] sink; // @[Monitor.scala 541:22]
  reg  denied; // @[Monitor.scala 542:22]
  wire  _T_1465 = io_in_d_valid & ~d_first; // @[Monitor.scala 543:19]
  wire  _T_1466 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 544:29]
  wire  _T_1470 = io_in_d_bits_param == param_1; // @[Monitor.scala 545:29]
  wire  _T_1474 = io_in_d_bits_size == size_1; // @[Monitor.scala 546:29]
  wire  _T_1478 = io_in_d_bits_source == source_1; // @[Monitor.scala 547:29]
  wire  _T_1482 = io_in_d_bits_sink == sink; // @[Monitor.scala 548:29]
  wire  _T_1486 = io_in_d_bits_denied == denied; // @[Monitor.scala 549:29]
  wire  b_first_done = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37]
  reg [8:0] b_first_counter; // @[Edges.scala 228:27]
  wire [8:0] b_first_counter1 = b_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  b_first = b_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [1:0] param_2; // @[Monitor.scala 410:22]
  reg [31:0] address_1; // @[Monitor.scala 413:22]
  wire  _T_1493 = io_in_b_valid & ~b_first; // @[Monitor.scala 414:19]
  wire  _T_1498 = io_in_b_bits_param == param_2; // @[Monitor.scala 416:32]
  wire  _T_1510 = io_in_b_bits_address == address_1; // @[Monitor.scala 419:32]
  wire  _c_first_T = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37]
  wire [8:0] c_first_beats1_decode = is_aligned_mask_2[11:3]; // @[Edges.scala 219:59]
  wire  c_first_beats1_opdata = io_in_c_bits_opcode[0]; // @[Edges.scala 101:36]
  reg [8:0] c_first_counter; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1 = c_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  c_first = c_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_3; // @[Monitor.scala 514:22]
  reg [2:0] param_3; // @[Monitor.scala 515:22]
  reg [3:0] size_3; // @[Monitor.scala 516:22]
  reg [1:0] source_3; // @[Monitor.scala 517:22]
  reg [31:0] address_2; // @[Monitor.scala 518:22]
  wire  _T_1517 = io_in_c_valid & ~c_first; // @[Monitor.scala 519:19]
  wire  _T_1518 = io_in_c_bits_opcode == opcode_3; // @[Monitor.scala 520:32]
  wire  _T_1522 = io_in_c_bits_param == param_3; // @[Monitor.scala 521:32]
  wire  _T_1526 = io_in_c_bits_size == size_3; // @[Monitor.scala 522:32]
  wire  _T_1530 = io_in_c_bits_source == source_3; // @[Monitor.scala 523:32]
  wire  _T_1534 = io_in_c_bits_address == address_2; // @[Monitor.scala 524:32]
  reg [2:0] inflight; // @[Monitor.scala 613:27]
  reg [11:0] inflight_opcodes; // @[Monitor.scala 615:35]
  reg [23:0] inflight_sizes; // @[Monitor.scala 617:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [3:0] _GEN_88 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69]
  wire [4:0] _a_opcode_lookup_T = {{1'd0}, _GEN_88}; // @[Monitor.scala 636:69]
  wire [11:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 636:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 611:57]
  wire [15:0] _GEN_89 = {{4'd0}, _a_opcode_lookup_T_1}; // @[Monitor.scala 636:97]
  wire [15:0] _a_opcode_lookup_T_6 = _GEN_89 & _a_opcode_lookup_T_5; // @[Monitor.scala 636:97]
  wire [15:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[15:1]}; // @[Monitor.scala 636:152]
  wire [4:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65]
  wire [23:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 640:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 611:57]
  wire [23:0] _GEN_91 = {{8'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 640:91]
  wire [23:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_91; // @[Monitor.scala 640:91]
  wire [23:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[23:1]}; // @[Monitor.scala 640:144]
  wire  _T_1540 = io_in_a_valid & a_first_1; // @[Monitor.scala 650:26]
  wire [3:0] _a_set_wo_ready_T = 4'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_27 = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 650:71 Monitor.scala 651:22]
  wire  _T_1543 = _a_first_T & a_first_1; // @[Monitor.scala 654:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 656:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 657:59]
  wire [3:0] _GEN_93 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79]
  wire [4:0] _a_opcodes_set_T = {{1'd0}, _GEN_93}; // @[Monitor.scala 658:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 656:28]
  wire [34:0] _GEN_94 = {{31'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54]
  wire [34:0] _a_opcodes_set_T_1 = _GEN_94 << _a_opcodes_set_T; // @[Monitor.scala 658:54]
  wire [4:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 654:72 Monitor.scala 657:28]
  wire [35:0] _GEN_95 = {{31'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52]
  wire [35:0] _a_sizes_set_T_1 = _GEN_95 << _a_sizes_set_T; // @[Monitor.scala 659:52]
  wire [2:0] _T_1545 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26]
  wire  _T_1547 = ~_T_1545[0]; // @[Monitor.scala 660:17]
  wire [3:0] _GEN_28 = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 655:28]
  wire [34:0] _GEN_31 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 35'h0; // @[Monitor.scala 654:72 Monitor.scala 658:28]
  wire [35:0] _GEN_32 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 36'h0; // @[Monitor.scala 654:72 Monitor.scala 659:28]
  wire  _T_1551 = io_in_d_valid & d_first_1; // @[Monitor.scala 673:26]
  wire  _T_1553 = ~_T_754; // @[Monitor.scala 673:74]
  wire  _T_1554 = io_in_d_valid & d_first_1 & ~_T_754; // @[Monitor.scala 673:71]
  wire [3:0] _d_clr_wo_ready_T = 4'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_33 = io_in_d_valid & d_first_1 & ~_T_754 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 673:90 Monitor.scala 674:22]
  wire [46:0] _GEN_97 = {{31'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 679:76]
  wire [46:0] _d_opcodes_clr_T_5 = _GEN_97 << _a_opcode_lookup_T; // @[Monitor.scala 679:76]
  wire [46:0] _GEN_98 = {{31'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 680:74]
  wire [46:0] _d_sizes_clr_T_5 = _GEN_98 << _a_size_lookup_T; // @[Monitor.scala 680:74]
  wire [3:0] _GEN_34 = _d_first_T & d_first_1 & _T_1553 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 677:91 Monitor.scala 678:21]
  wire [46:0] _GEN_35 = _d_first_T & d_first_1 & _T_1553 ? _d_opcodes_clr_T_5 : 47'h0; // @[Monitor.scala 677:91 Monitor.scala 679:21]
  wire [46:0] _GEN_36 = _d_first_T & d_first_1 & _T_1553 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 677:91 Monitor.scala 680:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113]
  wire  same_cycle_resp = _T_1540 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:88]
  wire [2:0] _T_1564 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25]
  wire  _T_1566 = _T_1564[0] | same_cycle_resp; // @[Monitor.scala 684:49]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire  _T_1571 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 688:39]
  wire  _T_1572 = io_in_d_bits_opcode == _GEN_44 | _T_1571; // @[Monitor.scala 687:77]
  wire  _T_1576 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire  _T_1583 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 692:38]
  wire  _T_1584 = io_in_d_bits_opcode == _GEN_60 | _T_1583; // @[Monitor.scala 691:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_99 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36]
  wire  _T_1588 = _GEN_99 == a_size_lookup; // @[Monitor.scala 693:36]
  wire  _T_1598 = _T_1551 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_1553; // @[Monitor.scala 696:116]
  wire  _T_1599 = ~io_in_d_ready; // @[Monitor.scala 697:15]
  wire  _T_1600 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 697:32]
  wire [2:0] a_set_wo_ready = _GEN_27[2:0];
  wire [2:0] d_clr_wo_ready = _GEN_33[2:0];
  wire  _T_1607 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 701:48]
  wire [2:0] a_set = _GEN_28[2:0];
  wire [2:0] _inflight_T = inflight | a_set; // @[Monitor.scala 704:27]
  wire [2:0] d_clr = _GEN_34[2:0];
  wire [2:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 704:38]
  wire [2:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 704:36]
  wire [11:0] a_opcodes_set = _GEN_31[11:0];
  wire [11:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43]
  wire [11:0] d_opcodes_clr = _GEN_35[11:0];
  wire [11:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 705:62]
  wire [11:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 705:60]
  wire [23:0] a_sizes_set = _GEN_32[23:0];
  wire [23:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39]
  wire [23:0] d_sizes_clr = _GEN_36[23:0];
  wire [23:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 706:56]
  wire [23:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 706:54]
  reg [31:0] watchdog; // @[Monitor.scala 708:27]
  wire  _T_1616 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 711:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 713:26]
  reg [2:0] inflight_1; // @[Monitor.scala 725:35]
  reg [23:0] inflight_sizes_1; // @[Monitor.scala 727:35]
  reg [8:0] c_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1_1 = c_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  c_first_1 = c_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [23:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 749:42]
  wire [23:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_91; // @[Monitor.scala 749:93]
  wire [23:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[23:1]}; // @[Monitor.scala 749:146]
  wire  _T_1626 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 67:40]
  wire  _T_1627 = io_in_c_valid & c_first_1 & _T_1626; // @[Monitor.scala 758:37]
  wire [3:0] _c_set_wo_ready_T = 4'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_72 = io_in_c_valid & c_first_1 & _T_1626 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 758:71 Monitor.scala 759:22]
  wire  _T_1633 = _c_first_T & c_first_1 & _T_1626; // @[Monitor.scala 762:38]
  wire [4:0] _c_sizes_set_interm_T = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 765:51]
  wire [4:0] _c_sizes_set_interm_T_1 = _c_sizes_set_interm_T | 5'h1; // @[Monitor.scala 765:59]
  wire [4:0] _c_sizes_set_T = {io_in_c_bits_source, 3'h0}; // @[Monitor.scala 767:77]
  wire [4:0] c_sizes_set_interm = _c_first_T & c_first_1 & _T_1626 ? _c_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 762:72 Monitor.scala 765:28]
  wire [35:0] _GEN_107 = {{31'd0}, c_sizes_set_interm}; // @[Monitor.scala 767:52]
  wire [35:0] _c_sizes_set_T_1 = _GEN_107 << _c_sizes_set_T; // @[Monitor.scala 767:52]
  wire [2:0] _T_1634 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 768:26]
  wire  _T_1636 = ~_T_1634[0]; // @[Monitor.scala 768:17]
  wire [3:0] _GEN_73 = _c_first_T & c_first_1 & _T_1626 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 762:72 Monitor.scala 763:28]
  wire [35:0] _GEN_77 = _c_first_T & c_first_1 & _T_1626 ? _c_sizes_set_T_1 : 36'h0; // @[Monitor.scala 762:72 Monitor.scala 767:28]
  wire  _T_1640 = io_in_d_valid & d_first_2; // @[Monitor.scala 781:26]
  wire  _T_1642 = io_in_d_valid & d_first_2 & _T_754; // @[Monitor.scala 781:71]
  wire [3:0] _GEN_78 = io_in_d_valid & d_first_2 & _T_754 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 781:89 Monitor.scala 782:22]
  wire [3:0] _GEN_79 = _d_first_T & d_first_2 & _T_754 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 785:90 Monitor.scala 786:21]
  wire [46:0] _GEN_81 = _d_first_T & d_first_2 & _T_754 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 785:90 Monitor.scala 788:21]
  wire  _same_cycle_resp_T_8 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 792:113]
  wire  same_cycle_resp_1 = _T_1627 & io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 792:88]
  wire [2:0] _T_1650 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25]
  wire  _T_1652 = _T_1650[0] | same_cycle_resp_1; // @[Monitor.scala 793:49]
  wire  _T_1656 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 795:36]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_1660 = _GEN_99 == c_size_lookup; // @[Monitor.scala 797:36]
  wire  _T_1669 = _T_1640 & c_first_1 & io_in_c_valid & _same_cycle_resp_T_8 & _T_754; // @[Monitor.scala 801:116]
  wire  _T_1671 = _T_1599 | io_in_c_ready; // @[Monitor.scala 802:32]
  wire [2:0] c_set_wo_ready = _GEN_72[2:0];
  wire  _T_1675 = |c_set_wo_ready; // @[Monitor.scala 806:28]
  wire [2:0] d_clr_wo_ready_1 = _GEN_78[2:0];
  wire  _T_1676 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 807:31]
  wire [2:0] c_set = _GEN_73[2:0];
  wire [2:0] _inflight_T_3 = inflight_1 | c_set; // @[Monitor.scala 811:35]
  wire [2:0] d_clr_1 = _GEN_79[2:0];
  wire [2:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 811:46]
  wire [2:0] _inflight_T_5 = _inflight_T_3 & _inflight_T_4; // @[Monitor.scala 811:44]
  wire [23:0] c_sizes_set = _GEN_77[23:0];
  wire [23:0] _inflight_sizes_T_3 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 813:41]
  wire [23:0] d_sizes_clr_1 = _GEN_81[23:0];
  wire [23:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 813:58]
  wire [23:0] _inflight_sizes_T_5 = _inflight_sizes_T_3 & _inflight_sizes_T_4; // @[Monitor.scala 813:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 815:27]
  wire  _T_1685 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 818:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 820:26]
  reg [3:0] inflight_2; // @[Monitor.scala 825:27]
  reg [8:0] d_first_counter_3; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_3 = d_first_counter_3 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_3 = d_first_counter_3 == 9'h0; // @[Edges.scala 230:25]
  wire  _T_1697 = io_in_d_bits_opcode[2] & ~io_in_d_bits_opcode[1]; // @[Edges.scala 70:40]
  wire  _T_1698 = _d_first_T & d_first_3 & _T_1697; // @[Monitor.scala 831:38]
  wire [3:0] _d_set_T = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_1699 = inflight_2 >> io_in_d_bits_sink; // @[Monitor.scala 833:23]
  wire  _T_1701 = ~_T_1699[0]; // @[Monitor.scala 833:14]
  wire [3:0] d_set = _d_first_T & d_first_3 & _T_1697 ? _d_set_T : 4'h0; // @[Monitor.scala 831:72 Monitor.scala 832:13]
  wire [3:0] _e_clr_T = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_1708 = d_set | inflight_2; // @[Monitor.scala 839:24]
  wire [3:0] _T_1709 = _T_1708 >> io_in_e_bits_sink; // @[Monitor.scala 839:35]
  wire [3:0] e_clr = io_in_e_valid ? _e_clr_T : 4'h0; // @[Monitor.scala 837:73 Monitor.scala 838:13]
  wire [3:0] _inflight_T_6 = inflight_2 | d_set; // @[Monitor.scala 844:27]
  wire [3:0] _inflight_T_7 = ~e_clr; // @[Monitor.scala 844:38]
  wire [3:0] _inflight_T_8 = _inflight_T_6 & _inflight_T_7; // @[Monitor.scala 844:36]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 401:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 402:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 403:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 555:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 556:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 557:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      b_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (b_first_done) begin // @[Edges.scala 234:17]
      if (b_first) begin // @[Edges.scala 235:21]
        b_first_counter <= 9'h0;
      end else begin
        b_first_counter <= b_first_counter1;
      end
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 421:32]
      param_2 <= io_in_b_bits_param; // @[Monitor.scala 423:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 421:32]
      address_1 <= io_in_b_bits_address; // @[Monitor.scala 426:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter <= c_first_beats1_decode;
        end else begin
          c_first_counter <= 9'h0;
        end
      end else begin
        c_first_counter <= c_first_counter1;
      end
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      opcode_3 <= io_in_c_bits_opcode; // @[Monitor.scala 527:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      param_3 <= io_in_c_bits_param; // @[Monitor.scala 528:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      size_3 <= io_in_c_bits_size; // @[Monitor.scala 529:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      source_3 <= io_in_c_bits_source; // @[Monitor.scala 530:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      address_2 <= io_in_c_bits_address; // @[Monitor.scala 531:15]
    end
    if (reset) begin // @[Monitor.scala 613:27]
      inflight <= 3'h0; // @[Monitor.scala 613:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 704:14]
    end
    if (reset) begin // @[Monitor.scala 615:35]
      inflight_opcodes <= 12'h0; // @[Monitor.scala 615:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 705:22]
    end
    if (reset) begin // @[Monitor.scala 617:33]
      inflight_sizes <= 24'h0; // @[Monitor.scala 617:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 706:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 708:27]
      watchdog <= 32'h0; // @[Monitor.scala 708:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 714:47]
      watchdog <= 32'h0; // @[Monitor.scala 714:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 713:14]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_1 <= 3'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Monitor.scala 727:35]
      inflight_sizes_1 <= 24'h0; // @[Monitor.scala 727:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 813:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first_1) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter_1 <= c_first_beats1_decode;
        end else begin
          c_first_counter_1 <= 9'h0;
        end
      end else begin
        c_first_counter_1 <= c_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 815:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 815:27]
    end else if (_c_first_T | _d_first_T) begin // @[Monitor.scala 821:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 821:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 820:14]
    end
    if (reset) begin // @[Monitor.scala 825:27]
      inflight_2 <= 4'h0; // @[Monitor.scala 825:27]
    end else begin
      inflight_2 <= _inflight_T_8; // @[Monitor.scala 844:14]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_3 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_3) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_3 <= d_first_beats1_decode;
        end else begin
          d_first_counter_3 <= 9'h0;
        end
      end else begin
        d_first_counter_3 <= d_first_counter1_3;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_63 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_63 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_87 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_87 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_63 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_63 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_87 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_87 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_186 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_186 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_42 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_42 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_276 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_276 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_286 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_380 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_380 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_286 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_380 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_380 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_286 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_496 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_496 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_570 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_570 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_648 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_648 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_728 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_728 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_738 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_738 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_750 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_750 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_758 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_758 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_770 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_770 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_758 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_758 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_785 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_785 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_789 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_789 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_758 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_758 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_785 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_785 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_789 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_789 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_822 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_822 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_822 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_822 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_950 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries invalid cap param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_950 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1269 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release type unsupported by manager (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1269 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1269 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1269 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid report param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1397 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1397 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(_T_1397 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(_T_1397 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries unmanaged address (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck address not aligned to size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1397 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid param (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1397 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck is corrupt (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1442 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1442 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1446 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1446 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1450 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1450 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1454 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1454 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1458 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1458 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1466 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1470 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1474 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1474 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1478 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1478 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1482 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1482 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1486 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1486 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1493 & ~(_T_1498 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1493 & ~(_T_1498 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1493 & ~(_T_1510 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel addresss changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1493 & ~(_T_1510 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1518 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1522 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel param changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1522 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1526 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel size changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1526 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1530 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel source changed within multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1530 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1534 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel address changed with multibeat operation (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1534 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1543 & ~(_T_1547 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1543 & ~(_T_1547 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & ~(_T_1566 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & ~(_T_1566 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1572 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1572 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1576 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1576 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1584 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1584 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1588 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1588 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1598 & ~(_T_1600 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1598 & ~(_T_1600 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1607 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1607 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1616 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1616 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1633 & ~(_T_1636 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel re-used a source ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1633 & ~(_T_1636 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1642 & ~(_T_1652 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1642 & ~(_T_1652 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1642 & same_cycle_resp_1 & ~(_T_1656 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1642 & same_cycle_resp_1 & ~(_T_1656 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1642 & ~same_cycle_resp_1 & ~(_T_1660 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1642 & ~same_cycle_resp_1 & ~(_T_1660 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1669 & ~(_T_1671 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1669 & ~(_T_1671 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1675 & ~(_T_1676 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1675 & ~(_T_1676 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1685 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1685 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1698 & ~(_T_1701 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel re-used a sink ID (connected at SystemBus.scala:41:55)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1698 & ~(_T_1701 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_e_valid & ~(_T_1709[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'E' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:55)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_e_valid & ~(_T_1709[0] | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[1:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  b_first_counter = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  param_2 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  address_1 = _RAND_15[31:0];
  _RAND_16 = {1{`RANDOM}};
  c_first_counter = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  opcode_3 = _RAND_17[2:0];
  _RAND_18 = {1{`RANDOM}};
  param_3 = _RAND_18[2:0];
  _RAND_19 = {1{`RANDOM}};
  size_3 = _RAND_19[3:0];
  _RAND_20 = {1{`RANDOM}};
  source_3 = _RAND_20[1:0];
  _RAND_21 = {1{`RANDOM}};
  address_2 = _RAND_21[31:0];
  _RAND_22 = {1{`RANDOM}};
  inflight = _RAND_22[2:0];
  _RAND_23 = {1{`RANDOM}};
  inflight_opcodes = _RAND_23[11:0];
  _RAND_24 = {1{`RANDOM}};
  inflight_sizes = _RAND_24[23:0];
  _RAND_25 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_25[8:0];
  _RAND_26 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_26[8:0];
  _RAND_27 = {1{`RANDOM}};
  watchdog = _RAND_27[31:0];
  _RAND_28 = {1{`RANDOM}};
  inflight_1 = _RAND_28[2:0];
  _RAND_29 = {1{`RANDOM}};
  inflight_sizes_1 = _RAND_29[23:0];
  _RAND_30 = {1{`RANDOM}};
  c_first_counter_1 = _RAND_30[8:0];
  _RAND_31 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  watchdog_1 = _RAND_32[31:0];
  _RAND_33 = {1{`RANDOM}};
  inflight_2 = _RAND_33[3:0];
  _RAND_34 = {1{`RANDOM}};
  d_first_counter_3 = _RAND_34[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLXbar(
  input         clock,
  input         reset,
  output        auto_in_1_a_ready,
  input         auto_in_1_a_valid,
  input  [2:0]  auto_in_1_a_bits_opcode,
  input  [2:0]  auto_in_1_a_bits_param,
  input  [3:0]  auto_in_1_a_bits_size,
  input  [1:0]  auto_in_1_a_bits_source,
  input  [31:0] auto_in_1_a_bits_address,
  input         auto_in_1_a_bits_user_amba_prot_bufferable,
  input         auto_in_1_a_bits_user_amba_prot_modifiable,
  input         auto_in_1_a_bits_user_amba_prot_readalloc,
  input         auto_in_1_a_bits_user_amba_prot_writealloc,
  input         auto_in_1_a_bits_user_amba_prot_privileged,
  input         auto_in_1_a_bits_user_amba_prot_secure,
  input         auto_in_1_a_bits_user_amba_prot_fetch,
  input  [7:0]  auto_in_1_a_bits_mask,
  input  [63:0] auto_in_1_a_bits_data,
  input         auto_in_1_a_bits_corrupt,
  input         auto_in_1_b_ready,
  output        auto_in_1_b_valid,
  output [1:0]  auto_in_1_b_bits_param,
  output [31:0] auto_in_1_b_bits_address,
  output        auto_in_1_c_ready,
  input         auto_in_1_c_valid,
  input  [2:0]  auto_in_1_c_bits_opcode,
  input  [2:0]  auto_in_1_c_bits_param,
  input  [3:0]  auto_in_1_c_bits_size,
  input  [1:0]  auto_in_1_c_bits_source,
  input  [31:0] auto_in_1_c_bits_address,
  input  [63:0] auto_in_1_c_bits_data,
  input         auto_in_1_c_bits_corrupt,
  input         auto_in_1_d_ready,
  output        auto_in_1_d_valid,
  output [2:0]  auto_in_1_d_bits_opcode,
  output [1:0]  auto_in_1_d_bits_param,
  output [3:0]  auto_in_1_d_bits_size,
  output [1:0]  auto_in_1_d_bits_source,
  output [1:0]  auto_in_1_d_bits_sink,
  output        auto_in_1_d_bits_denied,
  output [63:0] auto_in_1_d_bits_data,
  output        auto_in_1_d_bits_corrupt,
  input         auto_in_1_e_valid,
  input  [1:0]  auto_in_1_e_bits_sink,
  output        auto_in_0_a_ready,
  input         auto_in_0_a_valid,
  input  [2:0]  auto_in_0_a_bits_opcode,
  input  [2:0]  auto_in_0_a_bits_param,
  input  [3:0]  auto_in_0_a_bits_size,
  input  [3:0]  auto_in_0_a_bits_source,
  input  [31:0] auto_in_0_a_bits_address,
  input         auto_in_0_a_bits_user_amba_prot_bufferable,
  input         auto_in_0_a_bits_user_amba_prot_modifiable,
  input         auto_in_0_a_bits_user_amba_prot_readalloc,
  input         auto_in_0_a_bits_user_amba_prot_writealloc,
  input         auto_in_0_a_bits_user_amba_prot_privileged,
  input         auto_in_0_a_bits_user_amba_prot_secure,
  input         auto_in_0_a_bits_user_amba_prot_fetch,
  input  [7:0]  auto_in_0_a_bits_mask,
  input  [63:0] auto_in_0_a_bits_data,
  input         auto_in_0_a_bits_corrupt,
  input         auto_in_0_d_ready,
  output        auto_in_0_d_valid,
  output [2:0]  auto_in_0_d_bits_opcode,
  output [1:0]  auto_in_0_d_bits_param,
  output [3:0]  auto_in_0_d_bits_size,
  output [3:0]  auto_in_0_d_bits_source,
  output [1:0]  auto_in_0_d_bits_sink,
  output        auto_in_0_d_bits_denied,
  output [63:0] auto_in_0_d_bits_data,
  output        auto_in_0_d_bits_corrupt,
  input         auto_out_2_a_ready,
  output        auto_out_2_a_valid,
  output [2:0]  auto_out_2_a_bits_opcode,
  output [2:0]  auto_out_2_a_bits_param,
  output [3:0]  auto_out_2_a_bits_size,
  output [4:0]  auto_out_2_a_bits_source,
  output [30:0] auto_out_2_a_bits_address,
  output        auto_out_2_a_bits_user_amba_prot_bufferable,
  output        auto_out_2_a_bits_user_amba_prot_modifiable,
  output        auto_out_2_a_bits_user_amba_prot_readalloc,
  output        auto_out_2_a_bits_user_amba_prot_writealloc,
  output        auto_out_2_a_bits_user_amba_prot_privileged,
  output        auto_out_2_a_bits_user_amba_prot_secure,
  output        auto_out_2_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_2_a_bits_mask,
  output [63:0] auto_out_2_a_bits_data,
  output        auto_out_2_a_bits_corrupt,
  output        auto_out_2_d_ready,
  input         auto_out_2_d_valid,
  input  [2:0]  auto_out_2_d_bits_opcode,
  input  [3:0]  auto_out_2_d_bits_size,
  input  [4:0]  auto_out_2_d_bits_source,
  input         auto_out_2_d_bits_denied,
  input  [63:0] auto_out_2_d_bits_data,
  input         auto_out_2_d_bits_corrupt,
  input         auto_out_1_a_ready,
  output        auto_out_1_a_valid,
  output [2:0]  auto_out_1_a_bits_opcode,
  output [2:0]  auto_out_1_a_bits_param,
  output [2:0]  auto_out_1_a_bits_size,
  output [4:0]  auto_out_1_a_bits_source,
  output [31:0] auto_out_1_a_bits_address,
  output        auto_out_1_a_bits_user_amba_prot_bufferable,
  output        auto_out_1_a_bits_user_amba_prot_modifiable,
  output        auto_out_1_a_bits_user_amba_prot_readalloc,
  output        auto_out_1_a_bits_user_amba_prot_writealloc,
  output        auto_out_1_a_bits_user_amba_prot_privileged,
  output        auto_out_1_a_bits_user_amba_prot_secure,
  output        auto_out_1_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_1_a_bits_mask,
  output [63:0] auto_out_1_a_bits_data,
  output        auto_out_1_a_bits_corrupt,
  output        auto_out_1_b_ready,
  input         auto_out_1_b_valid,
  input  [1:0]  auto_out_1_b_bits_param,
  input  [31:0] auto_out_1_b_bits_address,
  input         auto_out_1_c_ready,
  output        auto_out_1_c_valid,
  output [2:0]  auto_out_1_c_bits_opcode,
  output [2:0]  auto_out_1_c_bits_param,
  output [2:0]  auto_out_1_c_bits_size,
  output [4:0]  auto_out_1_c_bits_source,
  output [31:0] auto_out_1_c_bits_address,
  output [63:0] auto_out_1_c_bits_data,
  output        auto_out_1_c_bits_corrupt,
  output        auto_out_1_d_ready,
  input         auto_out_1_d_valid,
  input  [2:0]  auto_out_1_d_bits_opcode,
  input  [1:0]  auto_out_1_d_bits_param,
  input  [2:0]  auto_out_1_d_bits_size,
  input  [4:0]  auto_out_1_d_bits_source,
  input  [1:0]  auto_out_1_d_bits_sink,
  input         auto_out_1_d_bits_denied,
  input  [63:0] auto_out_1_d_bits_data,
  input         auto_out_1_d_bits_corrupt,
  output        auto_out_1_e_valid,
  output [1:0]  auto_out_1_e_bits_sink,
  input         auto_out_0_a_ready,
  output        auto_out_0_a_valid,
  output [2:0]  auto_out_0_a_bits_opcode,
  output [2:0]  auto_out_0_a_bits_param,
  output [3:0]  auto_out_0_a_bits_size,
  output [4:0]  auto_out_0_a_bits_source,
  output [27:0] auto_out_0_a_bits_address,
  output [7:0]  auto_out_0_a_bits_mask,
  output [63:0] auto_out_0_a_bits_data,
  output        auto_out_0_a_bits_corrupt,
  output        auto_out_0_d_ready,
  input         auto_out_0_d_valid,
  input  [2:0]  auto_out_0_d_bits_opcode,
  input  [1:0]  auto_out_0_d_bits_param,
  input  [3:0]  auto_out_0_d_bits_size,
  input  [4:0]  auto_out_0_d_bits_source,
  input         auto_out_0_d_bits_sink,
  input         auto_out_0_d_bits_denied,
  input  [63:0] auto_out_0_d_bits_data,
  input         auto_out_0_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
`endif // RANDOMIZE_REG_INIT
  wire  monitor_clock; // @[Nodes.scala 24:25]
  wire  monitor_reset; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_clock; // @[Nodes.scala 24:25]
  wire  monitor_1_reset; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_1_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  reg [8:0] beatsLeft_3; // @[Arbiter.scala 87:30]
  wire  idle_3 = beatsLeft_3 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_0 = ~auto_out_2_d_bits_source[4]; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_0_valid = auto_out_2_d_valid & requestDOI_2_0; // @[Xbar.scala 179:40]
  wire  requestDOI_1_0 = ~auto_out_1_d_bits_source[4]; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_0_valid = auto_out_1_d_valid & requestDOI_1_0; // @[Xbar.scala 179:40]
  wire  requestDOI_0_0 = ~auto_out_0_d_bits_source[4]; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__0_valid = auto_out_0_d_valid & requestDOI_0_0; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_3 = {portsDIO_filtered_2_0_valid,portsDIO_filtered_1_0_valid,portsDIO_filtered__0_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_3; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_3 = ~readys_mask_3; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_3 = readys_filter_lo_3 & _readys_filter_T_3; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_3 = {readys_filter_hi_3,portsDIO_filtered_2_0_valid,portsDIO_filtered_1_0_valid,
    portsDIO_filtered__0_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_5 = {{1'd0}, readys_filter_3[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_16 = readys_filter_3 | _GEN_5; // @[package.scala 253:43]
  wire [5:0] _GEN_6 = {{2'd0}, _readys_unready_T_16[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_18 = _readys_unready_T_16 | _GEN_6; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_21 = {readys_mask_3, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_7 = {{1'd0}, _readys_unready_T_18[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_3 = _GEN_7 | _readys_unready_T_21; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_11 = readys_unready_3[5:3] & readys_unready_3[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_3 = ~_readys_readys_T_11; // @[Arbiter.scala 26:18]
  wire  readys_3_0 = readys_readys_3[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_0 = readys_3_0 & portsDIO_filtered__0_valid; // @[Arbiter.scala 97:79]
  reg  state_3_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_0 = idle_3 ? earlyWinner_3_0 : state_3_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_259 = muxStateEarly_3_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_3_1 = readys_readys_3[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_1 = readys_3_1 & portsDIO_filtered_1_0_valid; // @[Arbiter.scala 97:79]
  reg  state_3_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_1 = idle_3 ? earlyWinner_3_1 : state_3_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_260 = muxStateEarly_3_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_262 = _T_259 | _T_260; // @[Mux.scala 27:72]
  wire  readys_3_2 = readys_readys_3[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_3_2 = readys_3_2 & portsDIO_filtered_2_0_valid; // @[Arbiter.scala 97:79]
  reg  state_3_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_3_2 = idle_3 ? earlyWinner_3_2 : state_3_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_261 = muxStateEarly_3_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_7_bits_source = _T_262 | _T_261; // @[Mux.scala 27:72]
  wire [4:0] _GEN_8 = {{3'd0}, auto_in_1_a_bits_source}; // @[Xbar.scala 237:55]
  wire [4:0] in_1_a_bits_source = _GEN_8 | 5'h10; // @[Xbar.scala 237:55]
  wire [4:0] _GEN_9 = {{3'd0}, auto_in_1_c_bits_source}; // @[Xbar.scala 259:55]
  reg [8:0] beatsLeft_4; // @[Arbiter.scala 87:30]
  wire  idle_4 = beatsLeft_4 == 9'h0; // @[Arbiter.scala 88:28]
  wire  requestDOI_2_1 = auto_out_2_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_2_1_valid = auto_out_2_d_valid & requestDOI_2_1; // @[Xbar.scala 179:40]
  wire  requestDOI_1_1 = auto_out_1_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered_1_1_valid = auto_out_1_d_valid & requestDOI_1_1; // @[Xbar.scala 179:40]
  wire  requestDOI_0_1 = auto_out_0_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 54:32]
  wire  portsDIO_filtered__1_valid = auto_out_0_d_valid & requestDOI_0_1; // @[Xbar.scala 179:40]
  wire [2:0] readys_filter_lo_4 = {portsDIO_filtered_2_1_valid,portsDIO_filtered_1_1_valid,portsDIO_filtered__1_valid}; // @[Cat.scala 30:58]
  reg [2:0] readys_mask_4; // @[Arbiter.scala 23:23]
  wire [2:0] _readys_filter_T_4 = ~readys_mask_4; // @[Arbiter.scala 24:30]
  wire [2:0] readys_filter_hi_4 = readys_filter_lo_4 & _readys_filter_T_4; // @[Arbiter.scala 24:28]
  wire [5:0] readys_filter_4 = {readys_filter_hi_4,portsDIO_filtered_2_1_valid,portsDIO_filtered_1_1_valid,
    portsDIO_filtered__1_valid}; // @[Cat.scala 30:58]
  wire [5:0] _GEN_10 = {{1'd0}, readys_filter_4[5:1]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_23 = readys_filter_4 | _GEN_10; // @[package.scala 253:43]
  wire [5:0] _GEN_11 = {{2'd0}, _readys_unready_T_23[5:2]}; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_25 = _readys_unready_T_23 | _GEN_11; // @[package.scala 253:43]
  wire [5:0] _readys_unready_T_28 = {readys_mask_4, 3'h0}; // @[Arbiter.scala 25:66]
  wire [5:0] _GEN_12 = {{1'd0}, _readys_unready_T_25[5:1]}; // @[Arbiter.scala 25:58]
  wire [5:0] readys_unready_4 = _GEN_12 | _readys_unready_T_28; // @[Arbiter.scala 25:58]
  wire [2:0] _readys_readys_T_14 = readys_unready_4[5:3] & readys_unready_4[2:0]; // @[Arbiter.scala 26:39]
  wire [2:0] readys_readys_4 = ~_readys_readys_T_14; // @[Arbiter.scala 26:18]
  wire  readys_4_0 = readys_readys_4[0]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_4_0 = readys_4_0 & portsDIO_filtered__1_valid; // @[Arbiter.scala 97:79]
  reg  state_4_0; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_4_0 = idle_4 ? earlyWinner_4_0 : state_4_0; // @[Arbiter.scala 117:30]
  wire [4:0] _T_331 = muxStateEarly_4_0 ? auto_out_0_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire  readys_4_1 = readys_readys_4[1]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_4_1 = readys_4_1 & portsDIO_filtered_1_1_valid; // @[Arbiter.scala 97:79]
  reg  state_4_1; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_4_1 = idle_4 ? earlyWinner_4_1 : state_4_1; // @[Arbiter.scala 117:30]
  wire [4:0] _T_332 = muxStateEarly_4_1 ? auto_out_1_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_334 = _T_331 | _T_332; // @[Mux.scala 27:72]
  wire  readys_4_2 = readys_readys_4[2]; // @[Arbiter.scala 95:86]
  wire  earlyWinner_4_2 = readys_4_2 & portsDIO_filtered_2_1_valid; // @[Arbiter.scala 97:79]
  reg  state_4_2; // @[Arbiter.scala 116:26]
  wire  muxStateEarly_4_2 = idle_4 ? earlyWinner_4_2 : state_4_2; // @[Arbiter.scala 117:30]
  wire [4:0] _T_333 = muxStateEarly_4_2 ? auto_out_2_d_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] sink_ACancel_9_bits_source = _T_334 | _T_333; // @[Mux.scala 27:72]
  wire [32:0] _requestAIO_T_1 = {1'b0,$signed(auto_in_0_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_3 = $signed(_requestAIO_T_1) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_0_0 = $signed(_requestAIO_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_5 = auto_in_0_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_6 = {1'b0,$signed(_requestAIO_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_8 = $signed(_requestAIO_T_6) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_0_1 = $signed(_requestAIO_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_10 = auto_in_0_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_11 = {1'b0,$signed(_requestAIO_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_13 = $signed(_requestAIO_T_11) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_14 = $signed(_requestAIO_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_15 = auto_in_0_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_16 = {1'b0,$signed(_requestAIO_T_15)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_18 = $signed(_requestAIO_T_16) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_19 = $signed(_requestAIO_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_20 = auto_in_0_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_21 = {1'b0,$signed(_requestAIO_T_20)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_23 = $signed(_requestAIO_T_21) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_24 = $signed(_requestAIO_T_23) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_0_2 = _requestAIO_T_14 | _requestAIO_T_19 | _requestAIO_T_24; // @[Xbar.scala 363:92]
  wire [32:0] _requestAIO_T_28 = {1'b0,$signed(auto_in_1_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_30 = $signed(_requestAIO_T_28) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  requestAIO_1_0 = $signed(_requestAIO_T_30) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_32 = auto_in_1_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_33 = {1'b0,$signed(_requestAIO_T_32)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_35 = $signed(_requestAIO_T_33) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  requestAIO_1_1 = $signed(_requestAIO_T_35) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_37 = auto_in_1_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_38 = {1'b0,$signed(_requestAIO_T_37)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_40 = $signed(_requestAIO_T_38) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_41 = $signed(_requestAIO_T_40) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_42 = auto_in_1_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_43 = {1'b0,$signed(_requestAIO_T_42)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_45 = $signed(_requestAIO_T_43) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_46 = $signed(_requestAIO_T_45) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _requestAIO_T_47 = auto_in_1_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _requestAIO_T_48 = {1'b0,$signed(_requestAIO_T_47)}; // @[Parameters.scala 137:49]
  wire [32:0] _requestAIO_T_50 = $signed(_requestAIO_T_48) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _requestAIO_T_51 = $signed(_requestAIO_T_50) == 33'sh0; // @[Parameters.scala 137:67]
  wire  requestAIO_1_2 = _requestAIO_T_41 | _requestAIO_T_46 | _requestAIO_T_51; // @[Xbar.scala 363:92]
  wire [26:0] _beatsAI_decode_T_1 = 27'hfff << auto_in_0_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_3 = ~_beatsAI_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode = _beatsAI_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata = ~auto_in_0_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsIn_0 = beatsAI_opdata ? beatsAI_decode : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsAI_decode_T_5 = 27'hfff << auto_in_1_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsAI_decode_T_7 = ~_beatsAI_decode_T_5[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsAI_decode_1 = _beatsAI_decode_T_7[11:3]; // @[Edges.scala 219:59]
  wire  beatsAI_opdata_1 = ~auto_in_1_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] beatsIn_1 = beatsAI_opdata_1 ? beatsAI_decode_1 : 9'h0; // @[Edges.scala 220:14]
  wire [26:0] _beatsDO_decode_T_1 = 27'hfff << auto_out_0_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _beatsDO_decode_T_3 = ~_beatsDO_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] beatsDO_decode = _beatsDO_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  beatsDO_opdata = auto_out_0_d_bits_opcode[0]; // @[Edges.scala 105:36]
  wire [8:0] beatsIn_0_1 = beatsDO_opdata ? beatsDO_decode : 9'h0; // @[Edges.scala 220:14]
  wire [3:0] out__1_d_bits_size = {{1'd0}, auto_out_1_d_bits_size}; // @[Xbar.scala 288:19 BundleMap.scala 247:19]
  wire [20:0] _beatsDO_decode_T_5 = 21'h3f << out__1_d_bits_size; // @[package.scala 234:77]
  wire [5:0] _beatsDO_decode_T_7 = ~_beatsDO_decode_T_5[5:0]; // @[package.scala 234:46]
  wire [2:0] beatsDO_decode_1 = _beatsDO_decode_T_7[5:3]; // @[Edges.scala 219:59]
  wire  beatsDO_opdata_1 = auto_out_1_d_bits_opcode[0]; // @[Edges.scala 105:36]
  wire [2:0] beatsIn_1_1 = beatsDO_opdata_1 ? beatsDO_decode_1 : 3'h0; // @[Edges.scala 220:14]
  wire [22:0] _beatsDO_decode_T_9 = 23'hff << auto_out_2_d_bits_size; // @[package.scala 234:77]
  wire [7:0] _beatsDO_decode_T_11 = ~_beatsDO_decode_T_9[7:0]; // @[package.scala 234:46]
  wire [4:0] beatsDO_decode_2 = _beatsDO_decode_T_11[7:3]; // @[Edges.scala 219:59]
  wire  beatsDO_opdata_2 = auto_out_2_d_bits_opcode[0]; // @[Edges.scala 105:36]
  wire [4:0] beatsIn_2 = beatsDO_opdata_2 ? beatsDO_decode_2 : 5'h0; // @[Edges.scala 220:14]
  wire  portsAOI_filtered__0_earlyValid = auto_in_0_a_valid & requestAIO_0_0; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered__1_earlyValid = auto_in_0_a_valid & requestAIO_0_1; // @[Xbar.scala 428:50]
  wire  portsAOI_filtered__2_earlyValid = auto_in_0_a_valid & requestAIO_0_2; // @[Xbar.scala 428:50]
  reg [8:0] beatsLeft; // @[Arbiter.scala 87:30]
  wire  idle = beatsLeft == 9'h0; // @[Arbiter.scala 88:28]
  wire  portsAOI_filtered_1_0_earlyValid = auto_in_1_a_valid & requestAIO_1_0; // @[Xbar.scala 428:50]
  wire [1:0] readys_filter_lo = {portsAOI_filtered_1_0_earlyValid,portsAOI_filtered__0_earlyValid}; // @[Cat.scala 30:58]
  reg [1:0] readys_mask; // @[Arbiter.scala 23:23]
  wire [1:0] _readys_filter_T = ~readys_mask; // @[Arbiter.scala 24:30]
  wire [1:0] readys_filter_hi = readys_filter_lo & _readys_filter_T; // @[Arbiter.scala 24:28]
  wire [3:0] readys_filter = {readys_filter_hi,portsAOI_filtered_1_0_earlyValid,portsAOI_filtered__0_earlyValid}; // @[Cat.scala 30:58]
  wire [3:0] _GEN_13 = {{1'd0}, readys_filter[3:1]}; // @[package.scala 253:43]
  wire [3:0] _readys_unready_T_1 = readys_filter | _GEN_13; // @[package.scala 253:43]
  wire [3:0] _readys_unready_T_4 = {readys_mask, 2'h0}; // @[Arbiter.scala 25:66]
  wire [3:0] _GEN_14 = {{1'd0}, _readys_unready_T_1[3:1]}; // @[Arbiter.scala 25:58]
  wire [3:0] readys_unready = _GEN_14 | _readys_unready_T_4; // @[Arbiter.scala 25:58]
  wire [1:0] _readys_readys_T_2 = readys_unready[3:2] & readys_unready[1:0]; // @[Arbiter.scala 26:39]
  wire [1:0] readys_readys = ~_readys_readys_T_2; // @[Arbiter.scala 26:18]
  wire  readys__0 = readys_readys[0]; // @[Arbiter.scala 95:86]
  reg  state__0; // @[Arbiter.scala 116:26]
  wire  allowed__0 = idle ? readys__0 : state__0; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered__0_ready = auto_out_0_a_ready & allowed__0; // @[Arbiter.scala 123:31]
  reg [8:0] beatsLeft_1; // @[Arbiter.scala 87:30]
  wire  idle_1 = beatsLeft_1 == 9'h0; // @[Arbiter.scala 88:28]
  wire  portsAOI_filtered_1_1_earlyValid = auto_in_1_a_valid & requestAIO_1_1; // @[Xbar.scala 428:50]
  wire [1:0] readys_filter_lo_1 = {portsAOI_filtered_1_1_earlyValid,portsAOI_filtered__1_earlyValid}; // @[Cat.scala 30:58]
  reg [1:0] readys_mask_1; // @[Arbiter.scala 23:23]
  wire [1:0] _readys_filter_T_1 = ~readys_mask_1; // @[Arbiter.scala 24:30]
  wire [1:0] readys_filter_hi_1 = readys_filter_lo_1 & _readys_filter_T_1; // @[Arbiter.scala 24:28]
  wire [3:0] readys_filter_1 = {readys_filter_hi_1,portsAOI_filtered_1_1_earlyValid,portsAOI_filtered__1_earlyValid}; // @[Cat.scala 30:58]
  wire [3:0] _GEN_15 = {{1'd0}, readys_filter_1[3:1]}; // @[package.scala 253:43]
  wire [3:0] _readys_unready_T_6 = readys_filter_1 | _GEN_15; // @[package.scala 253:43]
  wire [3:0] _readys_unready_T_9 = {readys_mask_1, 2'h0}; // @[Arbiter.scala 25:66]
  wire [3:0] _GEN_16 = {{1'd0}, _readys_unready_T_6[3:1]}; // @[Arbiter.scala 25:58]
  wire [3:0] readys_unready_1 = _GEN_16 | _readys_unready_T_9; // @[Arbiter.scala 25:58]
  wire [1:0] _readys_readys_T_5 = readys_unready_1[3:2] & readys_unready_1[1:0]; // @[Arbiter.scala 26:39]
  wire [1:0] readys_readys_1 = ~_readys_readys_T_5; // @[Arbiter.scala 26:18]
  wire  readys_1_0 = readys_readys_1[0]; // @[Arbiter.scala 95:86]
  reg  state_1_0; // @[Arbiter.scala 116:26]
  wire  allowed_1_0 = idle_1 ? readys_1_0 : state_1_0; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered__1_ready = auto_out_1_a_ready & allowed_1_0; // @[Arbiter.scala 123:31]
  reg [8:0] beatsLeft_2; // @[Arbiter.scala 87:30]
  wire  idle_2 = beatsLeft_2 == 9'h0; // @[Arbiter.scala 88:28]
  wire  portsAOI_filtered_1_2_earlyValid = auto_in_1_a_valid & requestAIO_1_2; // @[Xbar.scala 428:50]
  wire [1:0] readys_filter_lo_2 = {portsAOI_filtered_1_2_earlyValid,portsAOI_filtered__2_earlyValid}; // @[Cat.scala 30:58]
  reg [1:0] readys_mask_2; // @[Arbiter.scala 23:23]
  wire [1:0] _readys_filter_T_2 = ~readys_mask_2; // @[Arbiter.scala 24:30]
  wire [1:0] readys_filter_hi_2 = readys_filter_lo_2 & _readys_filter_T_2; // @[Arbiter.scala 24:28]
  wire [3:0] readys_filter_2 = {readys_filter_hi_2,portsAOI_filtered_1_2_earlyValid,portsAOI_filtered__2_earlyValid}; // @[Cat.scala 30:58]
  wire [3:0] _GEN_17 = {{1'd0}, readys_filter_2[3:1]}; // @[package.scala 253:43]
  wire [3:0] _readys_unready_T_11 = readys_filter_2 | _GEN_17; // @[package.scala 253:43]
  wire [3:0] _readys_unready_T_14 = {readys_mask_2, 2'h0}; // @[Arbiter.scala 25:66]
  wire [3:0] _GEN_18 = {{1'd0}, _readys_unready_T_11[3:1]}; // @[Arbiter.scala 25:58]
  wire [3:0] readys_unready_2 = _GEN_18 | _readys_unready_T_14; // @[Arbiter.scala 25:58]
  wire [1:0] _readys_readys_T_8 = readys_unready_2[3:2] & readys_unready_2[1:0]; // @[Arbiter.scala 26:39]
  wire [1:0] readys_readys_2 = ~_readys_readys_T_8; // @[Arbiter.scala 26:18]
  wire  readys_2_0 = readys_readys_2[0]; // @[Arbiter.scala 95:86]
  reg  state_2_0; // @[Arbiter.scala 116:26]
  wire  allowed_2_0 = idle_2 ? readys_2_0 : state_2_0; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered__2_ready = auto_out_2_a_ready & allowed_2_0; // @[Arbiter.scala 123:31]
  wire  readys__1 = readys_readys[1]; // @[Arbiter.scala 95:86]
  reg  state__1; // @[Arbiter.scala 116:26]
  wire  allowed__1 = idle ? readys__1 : state__1; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_1_0_ready = auto_out_0_a_ready & allowed__1; // @[Arbiter.scala 123:31]
  wire  readys_1_1 = readys_readys_1[1]; // @[Arbiter.scala 95:86]
  reg  state_1_1; // @[Arbiter.scala 116:26]
  wire  allowed_1_1 = idle_1 ? readys_1_1 : state_1_1; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_1_1_ready = auto_out_1_a_ready & allowed_1_1; // @[Arbiter.scala 123:31]
  wire  readys_2_1 = readys_readys_2[1]; // @[Arbiter.scala 95:86]
  reg  state_2_1; // @[Arbiter.scala 116:26]
  wire  allowed_2_1 = idle_2 ? readys_2_1 : state_2_1; // @[Arbiter.scala 121:24]
  wire  portsAOI_filtered_1_2_ready = auto_out_2_a_ready & allowed_2_1; // @[Arbiter.scala 123:31]
  wire  allowed_3_0 = idle_3 ? readys_3_0 : state_3_0; // @[Arbiter.scala 121:24]
  wire  sourcesIn_0_ready = auto_in_0_d_ready & allowed_3_0; // @[Arbiter.scala 123:31]
  wire  allowed_4_0 = idle_4 ? readys_4_0 : state_4_0; // @[Arbiter.scala 121:24]
  wire  sourcesIn_0_1_ready = auto_in_1_d_ready & allowed_4_0; // @[Arbiter.scala 123:31]
  wire  allowed_3_1 = idle_3 ? readys_3_1 : state_3_1; // @[Arbiter.scala 121:24]
  wire  sourcesIn_1_ready = auto_in_0_d_ready & allowed_3_1; // @[Arbiter.scala 123:31]
  wire  allowed_4_1 = idle_4 ? readys_4_1 : state_4_1; // @[Arbiter.scala 121:24]
  wire  sourcesIn_1_1_ready = auto_in_1_d_ready & allowed_4_1; // @[Arbiter.scala 123:31]
  wire  allowed_3_2 = idle_3 ? readys_3_2 : state_3_2; // @[Arbiter.scala 121:24]
  wire  sourcesIn_2_ready = auto_in_0_d_ready & allowed_3_2; // @[Arbiter.scala 123:31]
  wire  allowed_4_2 = idle_4 ? readys_4_2 : state_4_2; // @[Arbiter.scala 121:24]
  wire  sourcesIn_2_1_ready = auto_in_1_d_ready & allowed_4_2; // @[Arbiter.scala 123:31]
  wire  latch = idle & auto_out_0_a_ready; // @[Arbiter.scala 89:24]
  wire [1:0] _readys_mask_T = readys_readys & readys_filter_lo; // @[Arbiter.scala 28:29]
  wire [2:0] _readys_mask_T_1 = {_readys_mask_T, 1'h0}; // @[package.scala 244:48]
  wire [1:0] _readys_mask_T_3 = _readys_mask_T | _readys_mask_T_1[1:0]; // @[package.scala 244:43]
  wire  earlyWinner__0 = readys__0 & portsAOI_filtered__0_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner__1 = readys__1 & portsAOI_filtered_1_0_earlyValid; // @[Arbiter.scala 97:79]
  wire  _prefixOR_T = earlyWinner__0 | earlyWinner__1; // @[Arbiter.scala 104:53]
  wire  _T_10 = portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid; // @[Arbiter.scala 107:36]
  wire  _T_11 = ~(portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0 = earlyWinner__0 ? beatsIn_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1 = earlyWinner__1 ? beatsIn_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] initBeats = maskedBeats_0 | maskedBeats_1; // @[Arbiter.scala 112:44]
  wire  muxStateEarly__0 = idle ? earlyWinner__0 : state__0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly__1 = idle ? earlyWinner__1 : state__1; // @[Arbiter.scala 117:30]
  wire  _out_0_a_earlyValid_T_3 = state__0 & portsAOI_filtered__0_earlyValid | state__1 &
    portsAOI_filtered_1_0_earlyValid; // @[Mux.scala 27:72]
  wire  out__0_a_earlyValid = idle ? _T_10 : _out_0_a_earlyValid_T_3; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_2 = auto_out_0_a_ready & out__0_a_earlyValid; // @[ReadyValidCancel.scala 51:33]
  wire [8:0] _GEN_19 = {{8'd0}, _beatsLeft_T_2}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_4 = beatsLeft - _GEN_19; // @[Arbiter.scala 113:52]
  wire [63:0] _T_27 = muxStateEarly__0 ? auto_in_0_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_28 = muxStateEarly__1 ? auto_in_1_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_30 = muxStateEarly__0 ? auto_in_0_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_31 = muxStateEarly__1 ? auto_in_1_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_54 = muxStateEarly__0 ? auto_in_0_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_55 = muxStateEarly__1 ? auto_in_1_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] out__0_a_bits_address = _T_54 | _T_55; // @[Mux.scala 27:72]
  wire [4:0] in_0_a_bits_source = {{1'd0}, auto_in_0_a_bits_source}; // @[Xbar.scala 231:18 Xbar.scala 237:29]
  wire [4:0] _T_57 = muxStateEarly__0 ? in_0_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_58 = muxStateEarly__1 ? in_1_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_60 = muxStateEarly__0 ? auto_in_0_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_61 = muxStateEarly__1 ? auto_in_1_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_63 = muxStateEarly__0 ? auto_in_0_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_64 = muxStateEarly__1 ? auto_in_1_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_66 = muxStateEarly__0 ? auto_in_0_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_67 = muxStateEarly__1 ? auto_in_1_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire  latch_1 = idle_1 & auto_out_1_a_ready; // @[Arbiter.scala 89:24]
  wire [1:0] _readys_mask_T_5 = readys_readys_1 & readys_filter_lo_1; // @[Arbiter.scala 28:29]
  wire [2:0] _readys_mask_T_6 = {_readys_mask_T_5, 1'h0}; // @[package.scala 244:48]
  wire [1:0] _readys_mask_T_8 = _readys_mask_T_5 | _readys_mask_T_6[1:0]; // @[package.scala 244:43]
  wire  earlyWinner_1_0 = readys_1_0 & portsAOI_filtered__1_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_1_1 = readys_1_1 & portsAOI_filtered_1_1_earlyValid; // @[Arbiter.scala 97:79]
  wire  _prefixOR_T_1 = earlyWinner_1_0 | earlyWinner_1_1; // @[Arbiter.scala 104:53]
  wire  _T_79 = portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid; // @[Arbiter.scala 107:36]
  wire  _T_80 = ~(portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_1 = earlyWinner_1_0 ? beatsIn_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1_1 = earlyWinner_1_1 ? beatsIn_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] initBeats_1 = maskedBeats_0_1 | maskedBeats_1_1; // @[Arbiter.scala 112:44]
  wire  muxStateEarly_1_0 = idle_1 ? earlyWinner_1_0 : state_1_0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_1_1 = idle_1 ? earlyWinner_1_1 : state_1_1; // @[Arbiter.scala 117:30]
  wire  _out_1_a_earlyValid_T_3 = state_1_0 & portsAOI_filtered__1_earlyValid | state_1_1 &
    portsAOI_filtered_1_1_earlyValid; // @[Mux.scala 27:72]
  wire  out__1_a_earlyValid = idle_1 ? _T_79 : _out_1_a_earlyValid_T_3; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_8 = auto_out_1_a_ready & out__1_a_earlyValid; // @[ReadyValidCancel.scala 51:33]
  wire [8:0] _GEN_20 = {{8'd0}, _beatsLeft_T_8}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_10 = beatsLeft_1 - _GEN_20; // @[Arbiter.scala 113:52]
  wire [63:0] _T_96 = muxStateEarly_1_0 ? auto_in_0_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_97 = muxStateEarly_1_1 ? auto_in_1_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_99 = muxStateEarly_1_0 ? auto_in_0_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_100 = muxStateEarly_1_1 ? auto_in_1_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_123 = muxStateEarly_1_0 ? auto_in_0_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_124 = muxStateEarly_1_1 ? auto_in_1_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_126 = muxStateEarly_1_0 ? in_0_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_127 = muxStateEarly_1_1 ? in_1_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_129 = muxStateEarly_1_0 ? auto_in_0_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_130 = muxStateEarly_1_1 ? auto_in_1_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] out__1_a_bits_size = _T_129 | _T_130; // @[Mux.scala 27:72]
  wire [2:0] _T_132 = muxStateEarly_1_0 ? auto_in_0_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_133 = muxStateEarly_1_1 ? auto_in_1_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_135 = muxStateEarly_1_0 ? auto_in_0_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_136 = muxStateEarly_1_1 ? auto_in_1_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire  latch_2 = idle_2 & auto_out_2_a_ready; // @[Arbiter.scala 89:24]
  wire [1:0] _readys_mask_T_10 = readys_readys_2 & readys_filter_lo_2; // @[Arbiter.scala 28:29]
  wire [2:0] _readys_mask_T_11 = {_readys_mask_T_10, 1'h0}; // @[package.scala 244:48]
  wire [1:0] _readys_mask_T_13 = _readys_mask_T_10 | _readys_mask_T_11[1:0]; // @[package.scala 244:43]
  wire  earlyWinner_2_0 = readys_2_0 & portsAOI_filtered__2_earlyValid; // @[Arbiter.scala 97:79]
  wire  earlyWinner_2_1 = readys_2_1 & portsAOI_filtered_1_2_earlyValid; // @[Arbiter.scala 97:79]
  wire  _prefixOR_T_2 = earlyWinner_2_0 | earlyWinner_2_1; // @[Arbiter.scala 104:53]
  wire  _T_148 = portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid; // @[Arbiter.scala 107:36]
  wire  _T_149 = ~(portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_2 = earlyWinner_2_0 ? beatsIn_0 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] maskedBeats_1_2 = earlyWinner_2_1 ? beatsIn_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [8:0] initBeats_2 = maskedBeats_0_2 | maskedBeats_1_2; // @[Arbiter.scala 112:44]
  wire  muxStateEarly_2_0 = idle_2 ? earlyWinner_2_0 : state_2_0; // @[Arbiter.scala 117:30]
  wire  muxStateEarly_2_1 = idle_2 ? earlyWinner_2_1 : state_2_1; // @[Arbiter.scala 117:30]
  wire  _out_2_a_earlyValid_T_3 = state_2_0 & portsAOI_filtered__2_earlyValid | state_2_1 &
    portsAOI_filtered_1_2_earlyValid; // @[Mux.scala 27:72]
  wire  out__2_a_earlyValid = idle_2 ? _T_148 : _out_2_a_earlyValid_T_3; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_14 = auto_out_2_a_ready & out__2_a_earlyValid; // @[ReadyValidCancel.scala 51:33]
  wire [8:0] _GEN_21 = {{8'd0}, _beatsLeft_T_14}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_16 = beatsLeft_2 - _GEN_21; // @[Arbiter.scala 113:52]
  wire [63:0] _T_165 = muxStateEarly_2_0 ? auto_in_0_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_166 = muxStateEarly_2_1 ? auto_in_1_a_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_168 = muxStateEarly_2_0 ? auto_in_0_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [7:0] _T_169 = muxStateEarly_2_1 ? auto_in_1_a_bits_mask : 8'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_192 = muxStateEarly_2_0 ? auto_in_0_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] _T_193 = muxStateEarly_2_1 ? auto_in_1_a_bits_address : 32'h0; // @[Mux.scala 27:72]
  wire [31:0] out__2_a_bits_address = _T_192 | _T_193; // @[Mux.scala 27:72]
  wire [4:0] _T_195 = muxStateEarly_2_0 ? in_0_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [4:0] _T_196 = muxStateEarly_2_1 ? in_1_a_bits_source : 5'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_198 = muxStateEarly_2_0 ? auto_in_0_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_199 = muxStateEarly_2_1 ? auto_in_1_a_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_201 = muxStateEarly_2_0 ? auto_in_0_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_202 = muxStateEarly_2_1 ? auto_in_1_a_bits_param : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_204 = muxStateEarly_2_0 ? auto_in_0_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_205 = muxStateEarly_2_1 ? auto_in_1_a_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire  latch_3 = idle_3 & auto_in_0_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_15 = readys_readys_3 & readys_filter_lo_3; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_16 = {_readys_mask_T_15, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_18 = _readys_mask_T_15 | _readys_mask_T_16[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_19 = {_readys_mask_T_18, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_21 = _readys_mask_T_18 | _readys_mask_T_19[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2 = earlyWinner_3_0 | earlyWinner_3_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_3 = prefixOR_2 | earlyWinner_3_2; // @[Arbiter.scala 104:53]
  wire  _T_222 = portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid; // @[Arbiter.scala 107:36]
  wire  _T_223 = ~(portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_3 = earlyWinner_3_0 ? beatsIn_0_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_3 = earlyWinner_3_1 ? beatsIn_1_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2 = earlyWinner_3_2 ? beatsIn_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_22 = {{6'd0}, maskedBeats_1_3}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T = maskedBeats_0_3 | _GEN_22; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_23 = {{4'd0}, maskedBeats_2}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_3 = _initBeats_T | _GEN_23; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_6 = state_3_0 & portsDIO_filtered__0_valid | state_3_1 & portsDIO_filtered_1_0_valid
     | state_3_2 & portsDIO_filtered_2_0_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_7_earlyValid = idle_3 ? _T_222 : _sink_ACancel_earlyValid_T_6; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_20 = auto_in_0_d_ready & sink_ACancel_7_earlyValid; // @[ReadyValidCancel.scala 51:33]
  wire [8:0] _GEN_24 = {{8'd0}, _beatsLeft_T_20}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_22 = beatsLeft_3 - _GEN_24; // @[Arbiter.scala 113:52]
  wire [63:0] _T_244 = muxStateEarly_3_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_245 = muxStateEarly_3_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_246 = muxStateEarly_3_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_247 = _T_244 | _T_245; // @[Mux.scala 27:72]
  wire [1:0] out__0_d_bits_sink = {{1'd0}, auto_out_0_d_bits_sink}; // @[Xbar.scala 288:19 Xbar.scala 323:28]
  wire [1:0] _T_254 = muxStateEarly_3_0 ? out__0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_255 = muxStateEarly_3_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_264 = muxStateEarly_3_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_265 = muxStateEarly_3_1 ? out__1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_266 = muxStateEarly_3_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_267 = _T_264 | _T_265; // @[Mux.scala 27:72]
  wire [1:0] _T_269 = muxStateEarly_3_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_270 = muxStateEarly_3_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_274 = muxStateEarly_3_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_275 = muxStateEarly_3_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_276 = muxStateEarly_3_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_277 = _T_274 | _T_275; // @[Mux.scala 27:72]
  wire  latch_4 = idle_4 & auto_in_1_d_ready; // @[Arbiter.scala 89:24]
  wire [2:0] _readys_mask_T_23 = readys_readys_4 & readys_filter_lo_4; // @[Arbiter.scala 28:29]
  wire [3:0] _readys_mask_T_24 = {_readys_mask_T_23, 1'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_26 = _readys_mask_T_23 | _readys_mask_T_24[2:0]; // @[package.scala 244:43]
  wire [4:0] _readys_mask_T_27 = {_readys_mask_T_26, 2'h0}; // @[package.scala 244:48]
  wire [2:0] _readys_mask_T_29 = _readys_mask_T_26 | _readys_mask_T_27[2:0]; // @[package.scala 244:43]
  wire  prefixOR_2_1 = earlyWinner_4_0 | earlyWinner_4_1; // @[Arbiter.scala 104:53]
  wire  _prefixOR_T_4 = prefixOR_2_1 | earlyWinner_4_2; // @[Arbiter.scala 104:53]
  wire  _T_294 = portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid; // @[Arbiter.scala 107:36]
  wire  _T_295 = ~(portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid); // @[Arbiter.scala 107:15]
  wire [8:0] maskedBeats_0_4 = earlyWinner_4_0 ? beatsIn_0_1 : 9'h0; // @[Arbiter.scala 111:73]
  wire [2:0] maskedBeats_1_4 = earlyWinner_4_1 ? beatsIn_1_1 : 3'h0; // @[Arbiter.scala 111:73]
  wire [4:0] maskedBeats_2_1 = earlyWinner_4_2 ? beatsIn_2 : 5'h0; // @[Arbiter.scala 111:73]
  wire [8:0] _GEN_25 = {{6'd0}, maskedBeats_1_4}; // @[Arbiter.scala 112:44]
  wire [8:0] _initBeats_T_1 = maskedBeats_0_4 | _GEN_25; // @[Arbiter.scala 112:44]
  wire [8:0] _GEN_26 = {{4'd0}, maskedBeats_2_1}; // @[Arbiter.scala 112:44]
  wire [8:0] initBeats_4 = _initBeats_T_1 | _GEN_26; // @[Arbiter.scala 112:44]
  wire  _sink_ACancel_earlyValid_T_14 = state_4_0 & portsDIO_filtered__1_valid | state_4_1 & portsDIO_filtered_1_1_valid
     | state_4_2 & portsDIO_filtered_2_1_valid; // @[Mux.scala 27:72]
  wire  sink_ACancel_9_earlyValid = idle_4 ? _T_294 : _sink_ACancel_earlyValid_T_14; // @[Arbiter.scala 125:29]
  wire  _beatsLeft_T_26 = auto_in_1_d_ready & sink_ACancel_9_earlyValid; // @[ReadyValidCancel.scala 51:33]
  wire [8:0] _GEN_27 = {{8'd0}, _beatsLeft_T_26}; // @[Arbiter.scala 113:52]
  wire [8:0] _beatsLeft_T_28 = beatsLeft_4 - _GEN_27; // @[Arbiter.scala 113:52]
  wire [63:0] _T_316 = muxStateEarly_4_0 ? auto_out_0_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_317 = muxStateEarly_4_1 ? auto_out_1_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_318 = muxStateEarly_4_2 ? auto_out_2_d_bits_data : 64'h0; // @[Mux.scala 27:72]
  wire [63:0] _T_319 = _T_316 | _T_317; // @[Mux.scala 27:72]
  wire [1:0] _T_326 = muxStateEarly_4_0 ? out__0_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_327 = muxStateEarly_4_1 ? auto_out_1_d_bits_sink : 2'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_336 = muxStateEarly_4_0 ? auto_out_0_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_337 = muxStateEarly_4_1 ? out__1_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_338 = muxStateEarly_4_2 ? auto_out_2_d_bits_size : 4'h0; // @[Mux.scala 27:72]
  wire [3:0] _T_339 = _T_336 | _T_337; // @[Mux.scala 27:72]
  wire [1:0] _T_341 = muxStateEarly_4_0 ? auto_out_0_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _T_342 = muxStateEarly_4_1 ? auto_out_1_d_bits_param : 2'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_346 = muxStateEarly_4_0 ? auto_out_0_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_347 = muxStateEarly_4_1 ? auto_out_1_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_348 = muxStateEarly_4_2 ? auto_out_2_d_bits_opcode : 3'h0; // @[Mux.scala 27:72]
  wire [2:0] _T_349 = _T_346 | _T_347; // @[Mux.scala 27:72]
  TLMonitor monitor ( // @[Nodes.scala 24:25]
    .clock(monitor_clock),
    .reset(monitor_reset),
    .io_in_a_ready(monitor_io_in_a_ready),
    .io_in_a_valid(monitor_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_io_in_a_bits_corrupt),
    .io_in_d_ready(monitor_io_in_d_ready),
    .io_in_d_valid(monitor_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_io_in_d_bits_corrupt)
  );
  TLMonitor_1 monitor_1 ( // @[Nodes.scala 24:25]
    .clock(monitor_1_clock),
    .reset(monitor_1_reset),
    .io_in_a_ready(monitor_1_io_in_a_ready),
    .io_in_a_valid(monitor_1_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_1_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_1_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_1_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_1_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_1_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_1_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_1_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_1_io_in_b_ready),
    .io_in_b_valid(monitor_1_io_in_b_valid),
    .io_in_b_bits_param(monitor_1_io_in_b_bits_param),
    .io_in_b_bits_address(monitor_1_io_in_b_bits_address),
    .io_in_c_ready(monitor_1_io_in_c_ready),
    .io_in_c_valid(monitor_1_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_1_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_1_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_1_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_1_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_1_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_1_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_1_io_in_d_ready),
    .io_in_d_valid(monitor_1_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_1_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_1_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_1_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_1_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_1_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_1_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_1_io_in_d_bits_corrupt),
    .io_in_e_valid(monitor_1_io_in_e_valid),
    .io_in_e_bits_sink(monitor_1_io_in_e_bits_sink)
  );
  assign auto_in_1_a_ready = requestAIO_1_0 & portsAOI_filtered_1_0_ready | requestAIO_1_1 & portsAOI_filtered_1_1_ready
     | requestAIO_1_2 & portsAOI_filtered_1_2_ready; // @[Mux.scala 27:72]
  assign auto_in_1_b_valid = auto_out_1_b_valid; // @[Xbar.scala 179:40]
  assign auto_in_1_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_c_ready = auto_out_1_c_ready; // @[Mux.scala 27:72]
  assign auto_in_1_d_valid = idle_4 ? _T_294 : _sink_ACancel_earlyValid_T_14; // @[Arbiter.scala 125:29]
  assign auto_in_1_d_bits_opcode = _T_349 | _T_348; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_param = _T_341 | _T_342; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_size = _T_339 | _T_338; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_source = sink_ACancel_9_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign auto_in_1_d_bits_sink = _T_326 | _T_327; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_denied = muxStateEarly_4_0 & auto_out_0_d_bits_denied | muxStateEarly_4_1 &
    auto_out_1_d_bits_denied | muxStateEarly_4_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_data = _T_319 | _T_318; // @[Mux.scala 27:72]
  assign auto_in_1_d_bits_corrupt = muxStateEarly_4_0 & auto_out_0_d_bits_corrupt | muxStateEarly_4_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_4_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_in_0_a_ready = requestAIO_0_0 & portsAOI_filtered__0_ready | requestAIO_0_1 & portsAOI_filtered__1_ready
     | requestAIO_0_2 & portsAOI_filtered__2_ready; // @[Mux.scala 27:72]
  assign auto_in_0_d_valid = idle_3 ? _T_222 : _sink_ACancel_earlyValid_T_6; // @[Arbiter.scala 125:29]
  assign auto_in_0_d_bits_opcode = _T_277 | _T_276; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_param = _T_269 | _T_270; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_size = _T_267 | _T_266; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_source = sink_ACancel_7_bits_source[3:0]; // @[Xbar.scala 228:69]
  assign auto_in_0_d_bits_sink = _T_254 | _T_255; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_denied = muxStateEarly_3_0 & auto_out_0_d_bits_denied | muxStateEarly_3_1 &
    auto_out_1_d_bits_denied | muxStateEarly_3_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_data = _T_247 | _T_246; // @[Mux.scala 27:72]
  assign auto_in_0_d_bits_corrupt = muxStateEarly_3_0 & auto_out_0_d_bits_corrupt | muxStateEarly_3_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_3_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_2_a_valid = idle_2 ? _T_148 : _out_2_a_earlyValid_T_3; // @[Arbiter.scala 125:29]
  assign auto_out_2_a_bits_opcode = _T_204 | _T_205; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_param = _T_201 | _T_202; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_size = _T_198 | _T_199; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_source = _T_195 | _T_196; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_address = out__2_a_bits_address[30:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_2_a_bits_user_amba_prot_bufferable = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_bufferable |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_bufferable; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_modifiable = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_modifiable |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_modifiable; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_readalloc = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_readalloc |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_readalloc; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_writealloc = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_writealloc |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_writealloc; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_privileged = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_privileged |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_privileged; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_secure = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_secure |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_secure; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_user_amba_prot_fetch = muxStateEarly_2_0 & auto_in_0_a_bits_user_amba_prot_fetch |
    muxStateEarly_2_1 & auto_in_1_a_bits_user_amba_prot_fetch; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_mask = _T_168 | _T_169; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_data = _T_165 | _T_166; // @[Mux.scala 27:72]
  assign auto_out_2_a_bits_corrupt = muxStateEarly_2_0 & auto_in_0_a_bits_corrupt | muxStateEarly_2_1 &
    auto_in_1_a_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_2_d_ready = requestDOI_2_0 & sourcesIn_2_ready | requestDOI_2_1 & sourcesIn_2_1_ready; // @[Mux.scala 27:72]
  assign auto_out_1_a_valid = idle_1 ? _T_79 : _out_1_a_earlyValid_T_3; // @[Arbiter.scala 125:29]
  assign auto_out_1_a_bits_opcode = _T_135 | _T_136; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_param = _T_132 | _T_133; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_size = out__1_a_bits_size[2:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_1_a_bits_source = _T_126 | _T_127; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_address = _T_123 | _T_124; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_bufferable = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_bufferable |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_bufferable; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_modifiable = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_modifiable |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_modifiable; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_readalloc = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_readalloc |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_readalloc; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_writealloc = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_writealloc |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_writealloc; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_privileged = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_privileged |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_privileged; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_secure = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_secure |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_secure; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_user_amba_prot_fetch = muxStateEarly_1_0 & auto_in_0_a_bits_user_amba_prot_fetch |
    muxStateEarly_1_1 & auto_in_1_a_bits_user_amba_prot_fetch; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_mask = _T_99 | _T_100; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_data = _T_96 | _T_97; // @[Mux.scala 27:72]
  assign auto_out_1_a_bits_corrupt = muxStateEarly_1_0 & auto_in_0_a_bits_corrupt | muxStateEarly_1_1 &
    auto_in_1_a_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_1_b_ready = auto_in_1_b_ready; // @[Mux.scala 27:72]
  assign auto_out_1_c_valid = auto_in_1_c_valid; // @[ReadyValidCancel.scala 22:38]
  assign auto_out_1_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_size = auto_in_1_c_bits_size[2:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_1_c_bits_source = _GEN_9 | 5'h10; // @[Xbar.scala 259:55]
  assign auto_out_1_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_data = auto_in_1_c_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_d_ready = requestDOI_1_0 & sourcesIn_1_ready | requestDOI_1_1 & sourcesIn_1_1_ready; // @[Mux.scala 27:72]
  assign auto_out_1_e_valid = auto_in_1_e_valid; // @[ReadyValidCancel.scala 22:38]
  assign auto_out_1_e_bits_sink = auto_in_1_e_bits_sink; // @[Xbar.scala 228:69]
  assign auto_out_0_a_valid = idle ? _T_10 : _out_0_a_earlyValid_T_3; // @[Arbiter.scala 125:29]
  assign auto_out_0_a_bits_opcode = _T_66 | _T_67; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_param = _T_63 | _T_64; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_size = _T_60 | _T_61; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_source = _T_57 | _T_58; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_address = out__0_a_bits_address[27:0]; // @[Xbar.scala 132:50 BundleMap.scala 247:19]
  assign auto_out_0_a_bits_mask = _T_30 | _T_31; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_data = _T_27 | _T_28; // @[Mux.scala 27:72]
  assign auto_out_0_a_bits_corrupt = muxStateEarly__0 & auto_in_0_a_bits_corrupt | muxStateEarly__1 &
    auto_in_1_a_bits_corrupt; // @[Mux.scala 27:72]
  assign auto_out_0_d_ready = requestDOI_0_0 & sourcesIn_0_ready | requestDOI_0_1 & sourcesIn_0_1_ready; // @[Mux.scala 27:72]
  assign monitor_clock = clock;
  assign monitor_reset = reset;
  assign monitor_io_in_a_ready = requestAIO_0_0 & portsAOI_filtered__0_ready | requestAIO_0_1 &
    portsAOI_filtered__1_ready | requestAIO_0_2 & portsAOI_filtered__2_ready; // @[Mux.scala 27:72]
  assign monitor_io_in_a_valid = auto_in_0_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_ready = auto_in_0_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_valid = idle_3 ? _T_222 : _sink_ACancel_earlyValid_T_6; // @[Arbiter.scala 125:29]
  assign monitor_io_in_d_bits_opcode = _T_277 | _T_276; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_param = _T_269 | _T_270; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_size = _T_267 | _T_266; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_source = sink_ACancel_7_bits_source[3:0]; // @[Xbar.scala 228:69]
  assign monitor_io_in_d_bits_sink = _T_254 | _T_255; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_denied = muxStateEarly_3_0 & auto_out_0_d_bits_denied | muxStateEarly_3_1 &
    auto_out_1_d_bits_denied | muxStateEarly_3_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_io_in_d_bits_corrupt = muxStateEarly_3_0 & auto_out_0_d_bits_corrupt | muxStateEarly_3_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_3_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_1_clock = clock;
  assign monitor_1_reset = reset;
  assign monitor_1_io_in_a_ready = requestAIO_1_0 & portsAOI_filtered_1_0_ready | requestAIO_1_1 &
    portsAOI_filtered_1_1_ready | requestAIO_1_2 & portsAOI_filtered_1_2_ready; // @[Mux.scala 27:72]
  assign monitor_1_io_in_a_valid = auto_in_1_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_ready = auto_in_1_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_valid = auto_out_1_b_valid; // @[Xbar.scala 179:40]
  assign monitor_1_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_c_ready = auto_out_1_c_ready; // @[Mux.scala 27:72]
  assign monitor_1_io_in_c_valid = auto_in_1_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_ready = auto_in_1_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_valid = idle_4 ? _T_294 : _sink_ACancel_earlyValid_T_14; // @[Arbiter.scala 125:29]
  assign monitor_1_io_in_d_bits_opcode = _T_349 | _T_348; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_param = _T_341 | _T_342; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_size = _T_339 | _T_338; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_source = sink_ACancel_9_bits_source[1:0]; // @[Xbar.scala 228:69]
  assign monitor_1_io_in_d_bits_sink = _T_326 | _T_327; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_denied = muxStateEarly_4_0 & auto_out_0_d_bits_denied | muxStateEarly_4_1 &
    auto_out_1_d_bits_denied | muxStateEarly_4_2 & auto_out_2_d_bits_denied; // @[Mux.scala 27:72]
  assign monitor_1_io_in_d_bits_corrupt = muxStateEarly_4_0 & auto_out_0_d_bits_corrupt | muxStateEarly_4_1 &
    auto_out_1_d_bits_corrupt | muxStateEarly_4_2 & auto_out_2_d_bits_corrupt; // @[Mux.scala 27:72]
  assign monitor_1_io_in_e_valid = auto_in_1_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  always @(posedge clock) begin
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_3 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_3) begin // @[Arbiter.scala 113:23]
      beatsLeft_3 <= initBeats_3;
    end else begin
      beatsLeft_3 <= _beatsLeft_T_22;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_3 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_3 & |readys_filter_lo_3) begin // @[Arbiter.scala 27:32]
      readys_mask_3 <= _readys_mask_T_21; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_0 <= earlyWinner_3_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_1 <= earlyWinner_3_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_3_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_3) begin // @[Arbiter.scala 117:30]
      state_3_2 <= earlyWinner_3_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_4 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_4) begin // @[Arbiter.scala 113:23]
      beatsLeft_4 <= initBeats_4;
    end else begin
      beatsLeft_4 <= _beatsLeft_T_28;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_4 <= 3'h7; // @[Arbiter.scala 23:23]
    end else if (latch_4 & |readys_filter_lo_4) begin // @[Arbiter.scala 27:32]
      readys_mask_4 <= _readys_mask_T_29; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_0 <= earlyWinner_4_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_1 <= earlyWinner_4_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_4_2 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_4) begin // @[Arbiter.scala 117:30]
      state_4_2 <= earlyWinner_4_2;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch) begin // @[Arbiter.scala 113:23]
      beatsLeft <= initBeats;
    end else begin
      beatsLeft <= _beatsLeft_T_4;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask <= 2'h3; // @[Arbiter.scala 23:23]
    end else if (latch & |readys_filter_lo) begin // @[Arbiter.scala 27:32]
      readys_mask <= _readys_mask_T_3; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__0 <= earlyWinner__0;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_1 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_1) begin // @[Arbiter.scala 113:23]
      beatsLeft_1 <= initBeats_1;
    end else begin
      beatsLeft_1 <= _beatsLeft_T_10;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_1 <= 2'h3; // @[Arbiter.scala 23:23]
    end else if (latch_1 & |readys_filter_lo_1) begin // @[Arbiter.scala 27:32]
      readys_mask_1 <= _readys_mask_T_8; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_0 <= earlyWinner_1_0;
    end
    if (reset) begin // @[Arbiter.scala 87:30]
      beatsLeft_2 <= 9'h0; // @[Arbiter.scala 87:30]
    end else if (latch_2) begin // @[Arbiter.scala 113:23]
      beatsLeft_2 <= initBeats_2;
    end else begin
      beatsLeft_2 <= _beatsLeft_T_16;
    end
    if (reset) begin // @[Arbiter.scala 23:23]
      readys_mask_2 <= 2'h3; // @[Arbiter.scala 23:23]
    end else if (latch_2 & |readys_filter_lo_2) begin // @[Arbiter.scala 27:32]
      readys_mask_2 <= _readys_mask_T_13; // @[Arbiter.scala 28:12]
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_2_0 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_2) begin // @[Arbiter.scala 117:30]
      state_2_0 <= earlyWinner_2_0;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state__1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle) begin // @[Arbiter.scala 117:30]
      state__1 <= earlyWinner__1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_1_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_1) begin // @[Arbiter.scala 117:30]
      state_1_1 <= earlyWinner_1_1;
    end
    if (reset) begin // @[Arbiter.scala 116:26]
      state_2_1 <= 1'h0; // @[Arbiter.scala 116:26]
    end else if (idle_2) begin // @[Arbiter.scala 117:30]
      state_2_1 <= earlyWinner_2_1;
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~earlyWinner__0 | ~earlyWinner__1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~earlyWinner__0 | ~earlyWinner__1 | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid) | _prefixOR_T | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsAOI_filtered__0_earlyValid | portsAOI_filtered_1_0_earlyValid) | _prefixOR_T | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_11 | _T_10 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_11 | _T_10 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~earlyWinner_1_0 | ~earlyWinner_1_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~earlyWinner_1_0 | ~earlyWinner_1_1 | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid) | _prefixOR_T_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsAOI_filtered__1_earlyValid | portsAOI_filtered_1_1_earlyValid) | _prefixOR_T_1 | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_80 | _T_79 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_80 | _T_79 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~earlyWinner_2_0 | ~earlyWinner_2_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~earlyWinner_2_0 | ~earlyWinner_2_1 | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid) | _prefixOR_T_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsAOI_filtered__2_earlyValid | portsAOI_filtered_1_2_earlyValid) | _prefixOR_T_2 | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_149 | _T_148 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_149 | _T_148 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_3_0 | ~earlyWinner_3_1) & (~prefixOR_2 | ~earlyWinner_3_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_3_0 | ~earlyWinner_3_1) & (~prefixOR_2 | ~earlyWinner_3_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid) | _prefixOR_T_3
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__0_valid | portsDIO_filtered_1_0_valid | portsDIO_filtered_2_0_valid) | _prefixOR_T_3
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_223 | _T_222 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_223 | _T_222 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~((~earlyWinner_4_0 | ~earlyWinner_4_1) & (~prefixOR_2_1 | ~earlyWinner_4_2) | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:105 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"
            ); // @[Arbiter.scala 105:13]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~((~earlyWinner_4_0 | ~earlyWinner_4_1) & (~prefixOR_2_1 | ~earlyWinner_4_2) | reset)) begin
          $fatal; // @[Arbiter.scala 105:13]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~(portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid) | _prefixOR_T_4
           | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:107 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"
            ); // @[Arbiter.scala 107:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~(portsDIO_filtered__1_valid | portsDIO_filtered_1_1_valid | portsDIO_filtered_2_1_valid) | _prefixOR_T_4
           | reset)) begin
          $fatal; // @[Arbiter.scala 107:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_295 | _T_294 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at Arbiter.scala:108 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"
            ); // @[Arbiter.scala 108:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_295 | _T_294 | reset)) begin
          $fatal; // @[Arbiter.scala 108:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  beatsLeft_3 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  readys_mask_3 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  state_3_0 = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  state_3_1 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  state_3_2 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  beatsLeft_4 = _RAND_5[8:0];
  _RAND_6 = {1{`RANDOM}};
  readys_mask_4 = _RAND_6[2:0];
  _RAND_7 = {1{`RANDOM}};
  state_4_0 = _RAND_7[0:0];
  _RAND_8 = {1{`RANDOM}};
  state_4_1 = _RAND_8[0:0];
  _RAND_9 = {1{`RANDOM}};
  state_4_2 = _RAND_9[0:0];
  _RAND_10 = {1{`RANDOM}};
  beatsLeft = _RAND_10[8:0];
  _RAND_11 = {1{`RANDOM}};
  readys_mask = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  state__0 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  beatsLeft_1 = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  readys_mask_1 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  state_1_0 = _RAND_15[0:0];
  _RAND_16 = {1{`RANDOM}};
  beatsLeft_2 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  readys_mask_2 = _RAND_17[1:0];
  _RAND_18 = {1{`RANDOM}};
  state_2_0 = _RAND_18[0:0];
  _RAND_19 = {1{`RANDOM}};
  state__1 = _RAND_19[0:0];
  _RAND_20 = {1{`RANDOM}};
  state_1_1 = _RAND_20[0:0];
  _RAND_21 = {1{`RANDOM}};
  state_2_1 = _RAND_21[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_2(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [3:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [3:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [63:0] _RAND_14;
  reg [127:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [127:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T_1 = ~io_in_a_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok = _source_ok_T_1 | io_in_a_bits_source[3]; // @[Parameters.scala 1163:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_71 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_71; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  mask_sub_acc = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_sub_acc_1 = mask_sub_acc | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_sub_acc_2 = mask_sub_acc | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_sub_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_3 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_2; // @[Misc.scala 214:29]
  wire  mask_sub_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_4 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_3; // @[Misc.scala 214:29]
  wire  mask_sub_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_5 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_4; // @[Misc.scala 214:29]
  wire  mask_sub_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_6 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq = mask_sub_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_sub_acc_3 | mask_size_2 & mask_eq; // @[Misc.scala 214:29]
  wire  mask_eq_1 = mask_sub_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_sub_acc_3 | mask_size_2 & mask_eq_1; // @[Misc.scala 214:29]
  wire  mask_eq_2 = mask_sub_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_sub_acc_4 | mask_size_2 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_sub_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_sub_acc_4 | mask_size_2 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_sub_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_sub_acc_5 | mask_size_2 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_sub_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_sub_acc_5 | mask_size_2 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_eq_6 = mask_sub_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_sub_acc_6 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_sub_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_sub_acc_6 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_12 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_34 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25]
  wire  _T_36 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_51 = _T_36 & source_ok; // @[Parameters.scala 1213:30]
  wire  _T_61 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_64 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_65 = {1'b0,$signed(_T_64)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_67 = $signed(_T_65) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_68 = $signed(_T_67) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_69 = _T_61 & _T_68; // @[Parameters.scala 667:56]
  wire  _T_72 = _T_51 & _T_69; // @[Parameters.scala 1422:195]
  wire  _T_101 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_105 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18]
  wire  _T_106 = _T_105 == 8'h0; // @[Monitor.scala 90:31]
  wire  _T_110 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18]
  wire  _T_114 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25]
  wire  _T_185 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31]
  wire  _T_198 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25]
  wire [31:0] _T_224 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 137:31]
  wire [32:0] _T_225 = {1'b0,$signed(_T_224)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_227 = $signed(_T_225) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_228 = $signed(_T_227) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_229 = _T_36 & _T_228; // @[Parameters.scala 667:56]
  wire [32:0] _T_237 = $signed(_T_12) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_238 = $signed(_T_237) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_239 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_240 = {1'b0,$signed(_T_239)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_242 = $signed(_T_240) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_243 = $signed(_T_242) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_244 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_245 = {1'b0,$signed(_T_244)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_247 = $signed(_T_245) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_248 = $signed(_T_247) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_249 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_250 = {1'b0,$signed(_T_249)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_252 = $signed(_T_250) & 33'shf8000000; // @[Parameters.scala 137:52]
  wire  _T_253 = $signed(_T_252) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_254 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_255 = {1'b0,$signed(_T_254)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_257 = $signed(_T_255) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _T_258 = $signed(_T_257) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_259 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_260 = {1'b0,$signed(_T_259)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_262 = $signed(_T_260) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _T_263 = $signed(_T_262) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_264 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_265 = {1'b0,$signed(_T_264)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_267 = $signed(_T_265) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _T_268 = $signed(_T_267) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_280 = _T_238 | _T_243 | _T_248 | _T_253 | _T_258 | _T_263 | _T_268 | _T_68; // @[Parameters.scala 668:42]
  wire  _T_281 = _T_61 & _T_280; // @[Parameters.scala 667:56]
  wire  _T_283 = _T_229 | _T_281; // @[Parameters.scala 669:30]
  wire  _T_293 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31]
  wire  _T_297 = io_in_a_bits_mask == mask; // @[Monitor.scala 112:30]
  wire  _T_305 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25]
  wire  _T_360 = _T_238 | _T_248 | _T_253 | _T_68; // @[Parameters.scala 668:42]
  wire  _T_361 = _T_61 & _T_360; // @[Parameters.scala 667:56]
  wire  _T_370 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_389 = _T_258 | _T_263 | _T_268; // @[Parameters.scala 668:42]
  wire  _T_390 = _T_370 & _T_389; // @[Parameters.scala 667:56]
  wire  _T_394 = _T_229 | _T_361 | _T_390; // @[Parameters.scala 669:30]
  wire  _T_395 = _T_51 & _T_394; // @[Parameters.scala 1426:195]
  wire  _T_413 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25]
  wire [7:0] _T_517 = ~mask; // @[Monitor.scala 129:33]
  wire [7:0] _T_518 = io_in_a_bits_mask & _T_517; // @[Monitor.scala 129:31]
  wire  _T_519 = _T_518 == 8'h0; // @[Monitor.scala 129:40]
  wire  _T_523 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25]
  wire  _T_543 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire [32:0] _T_549 = $signed(_T_12) & 33'shf8010000; // @[Parameters.scala 137:52]
  wire  _T_550 = $signed(_T_549) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_556 = _T_550 | _T_253; // @[Parameters.scala 668:42]
  wire  _T_557 = _T_543 & _T_556; // @[Parameters.scala 667:56]
  wire  _T_591 = _T_51 & _T_557; // @[Parameters.scala 1423:195]
  wire  _T_601 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_609 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25]
  wire  _T_687 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_695 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25]
  wire  _T_775 = _T_51 & _T_229; // @[Parameters.scala 1428:195]
  wire  _T_785 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_797 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_13 = ~io_in_d_bits_source[3]; // @[Parameters.scala 54:32]
  wire  source_ok_1 = _source_ok_T_13 | io_in_d_bits_source[3]; // @[Parameters.scala 1163:46]
  wire  _T_801 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25]
  wire  _T_805 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27]
  wire  _T_809 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28]
  wire  _T_813 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15]
  wire  _T_817 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15]
  wire  _T_821 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25]
  wire  _T_832 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_836 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28]
  wire  _T_849 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25]
  wire  _T_869 = _T_817 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30]
  wire  _T_878 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25]
  wire  _T_895 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25]
  wire  _T_913 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 386:22]
  reg [2:0] param; // @[Monitor.scala 387:22]
  reg [3:0] size; // @[Monitor.scala 388:22]
  reg [3:0] source; // @[Monitor.scala 389:22]
  reg [31:0] address; // @[Monitor.scala 390:22]
  wire  _T_943 = io_in_a_valid & ~a_first; // @[Monitor.scala 391:19]
  wire  _T_944 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 392:32]
  wire  _T_948 = io_in_a_bits_param == param; // @[Monitor.scala 393:32]
  wire  _T_952 = io_in_a_bits_size == size; // @[Monitor.scala 394:32]
  wire  _T_956 = io_in_a_bits_source == source; // @[Monitor.scala 395:32]
  wire  _T_960 = io_in_a_bits_address == address; // @[Monitor.scala 396:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 537:22]
  reg [1:0] param_1; // @[Monitor.scala 538:22]
  reg [3:0] size_1; // @[Monitor.scala 539:22]
  reg [3:0] source_1; // @[Monitor.scala 540:22]
  reg [1:0] sink; // @[Monitor.scala 541:22]
  reg  denied; // @[Monitor.scala 542:22]
  wire  _T_967 = io_in_d_valid & ~d_first; // @[Monitor.scala 543:19]
  wire  _T_968 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 544:29]
  wire  _T_972 = io_in_d_bits_param == param_1; // @[Monitor.scala 545:29]
  wire  _T_976 = io_in_d_bits_size == size_1; // @[Monitor.scala 546:29]
  wire  _T_980 = io_in_d_bits_source == source_1; // @[Monitor.scala 547:29]
  wire  _T_984 = io_in_d_bits_sink == sink; // @[Monitor.scala 548:29]
  wire  _T_988 = io_in_d_bits_denied == denied; // @[Monitor.scala 549:29]
  reg [15:0] inflight; // @[Monitor.scala 613:27]
  reg [63:0] inflight_opcodes; // @[Monitor.scala 615:35]
  reg [127:0] inflight_sizes; // @[Monitor.scala 617:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [5:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69]
  wire [6:0] _a_opcode_lookup_T = {{1'd0}, _GEN_72}; // @[Monitor.scala 636:69]
  wire [63:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 636:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 611:57]
  wire [63:0] _GEN_73 = {{48'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 636:97]
  wire [63:0] _a_opcode_lookup_T_6 = _a_opcode_lookup_T_1 & _GEN_73; // @[Monitor.scala 636:97]
  wire [63:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[63:1]}; // @[Monitor.scala 636:152]
  wire [6:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65]
  wire [127:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 640:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 611:57]
  wire [127:0] _GEN_75 = {{112'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 640:91]
  wire [127:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 640:91]
  wire [127:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[127:1]}; // @[Monitor.scala 640:144]
  wire  _T_994 = io_in_a_valid & a_first_1; // @[Monitor.scala 650:26]
  wire [15:0] _a_set_wo_ready_T = 16'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] a_set_wo_ready = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 650:71 Monitor.scala 651:22]
  wire  _T_997 = _a_first_T & a_first_1; // @[Monitor.scala 654:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 656:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 657:59]
  wire [5:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79]
  wire [6:0] _a_opcodes_set_T = {{1'd0}, _GEN_77}; // @[Monitor.scala 658:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 656:28]
  wire [130:0] _GEN_78 = {{127'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54]
  wire [130:0] _a_opcodes_set_T_1 = _GEN_78 << _a_opcodes_set_T; // @[Monitor.scala 658:54]
  wire [6:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 654:72 Monitor.scala 657:28]
  wire [131:0] _GEN_79 = {{127'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52]
  wire [131:0] _a_sizes_set_T_1 = _GEN_79 << _a_sizes_set_T; // @[Monitor.scala 659:52]
  wire [15:0] _T_999 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26]
  wire  _T_1001 = ~_T_999[0]; // @[Monitor.scala 660:17]
  wire [15:0] a_set = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 16'h0; // @[Monitor.scala 654:72 Monitor.scala 655:28]
  wire [130:0] _GEN_19 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 131'h0; // @[Monitor.scala 654:72 Monitor.scala 658:28]
  wire [131:0] _GEN_20 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 132'h0; // @[Monitor.scala 654:72 Monitor.scala 659:28]
  wire  _T_1005 = io_in_d_valid & d_first_1; // @[Monitor.scala 673:26]
  wire  _T_1007 = ~_T_801; // @[Monitor.scala 673:74]
  wire  _T_1008 = io_in_d_valid & d_first_1 & ~_T_801; // @[Monitor.scala 673:71]
  wire [15:0] _d_clr_wo_ready_T = 16'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [15:0] d_clr_wo_ready = io_in_d_valid & d_first_1 & ~_T_801 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 673:90 Monitor.scala 674:22]
  wire [142:0] _GEN_81 = {{127'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 679:76]
  wire [142:0] _d_opcodes_clr_T_5 = _GEN_81 << _a_opcode_lookup_T; // @[Monitor.scala 679:76]
  wire [142:0] _GEN_82 = {{127'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 680:74]
  wire [142:0] _d_sizes_clr_T_5 = _GEN_82 << _a_size_lookup_T; // @[Monitor.scala 680:74]
  wire [15:0] d_clr = _d_first_T & d_first_1 & _T_1007 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 677:91 Monitor.scala 678:21]
  wire [142:0] _GEN_23 = _d_first_T & d_first_1 & _T_1007 ? _d_opcodes_clr_T_5 : 143'h0; // @[Monitor.scala 677:91 Monitor.scala 679:21]
  wire [142:0] _GEN_24 = _d_first_T & d_first_1 & _T_1007 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 677:91 Monitor.scala 680:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113]
  wire  same_cycle_resp = _T_994 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:88]
  wire [15:0] _T_1018 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25]
  wire  _T_1020 = _T_1018[0] | same_cycle_resp; // @[Monitor.scala 684:49]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire  _T_1025 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 688:39]
  wire  _T_1026 = io_in_d_bits_opcode == _GEN_32 | _T_1025; // @[Monitor.scala 687:77]
  wire  _T_1030 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire  _T_1037 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 692:38]
  wire  _T_1038 = io_in_d_bits_opcode == _GEN_48 | _T_1037; // @[Monitor.scala 691:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36]
  wire  _T_1042 = _GEN_83 == a_size_lookup; // @[Monitor.scala 693:36]
  wire  _T_1052 = _T_1005 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_1007; // @[Monitor.scala 696:116]
  wire  _T_1054 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 697:32]
  wire  _T_1061 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 701:48]
  wire [15:0] _inflight_T = inflight | a_set; // @[Monitor.scala 704:27]
  wire [15:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 704:38]
  wire [15:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 704:36]
  wire [63:0] a_opcodes_set = _GEN_19[63:0];
  wire [63:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43]
  wire [63:0] d_opcodes_clr = _GEN_23[63:0];
  wire [63:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 705:62]
  wire [63:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 705:60]
  wire [127:0] a_sizes_set = _GEN_20[127:0];
  wire [127:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39]
  wire [127:0] d_sizes_clr = _GEN_24[127:0];
  wire [127:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 706:56]
  wire [127:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 706:54]
  reg [31:0] watchdog; // @[Monitor.scala 708:27]
  wire  _T_1070 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 711:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 713:26]
  reg [15:0] inflight_1; // @[Monitor.scala 725:35]
  reg [127:0] inflight_sizes_1; // @[Monitor.scala 727:35]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [127:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 749:42]
  wire [127:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 749:93]
  wire [127:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[127:1]}; // @[Monitor.scala 749:146]
  wire  _T_1096 = io_in_d_valid & d_first_2 & _T_801; // @[Monitor.scala 781:71]
  wire [15:0] d_clr_1 = _d_first_T & d_first_2 & _T_801 ? _d_clr_wo_ready_T : 16'h0; // @[Monitor.scala 785:90 Monitor.scala 786:21]
  wire [142:0] _GEN_69 = _d_first_T & d_first_2 & _T_801 ? _d_sizes_clr_T_5 : 143'h0; // @[Monitor.scala 785:90 Monitor.scala 788:21]
  wire [15:0] _T_1104 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_1114 = _GEN_83 == c_size_lookup; // @[Monitor.scala 797:36]
  wire [15:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 811:46]
  wire [15:0] _inflight_T_5 = inflight_1 & _inflight_T_4; // @[Monitor.scala 811:44]
  wire [127:0] d_sizes_clr_1 = _GEN_69[127:0];
  wire [127:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 813:58]
  wire [127:0] _inflight_sizes_T_5 = inflight_sizes_1 & _inflight_sizes_T_4; // @[Monitor.scala 813:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 815:27]
  wire  _T_1139 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 818:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 820:26]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 401:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 402:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 403:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 555:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 556:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 557:15]
    end
    if (reset) begin // @[Monitor.scala 613:27]
      inflight <= 16'h0; // @[Monitor.scala 613:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 704:14]
    end
    if (reset) begin // @[Monitor.scala 615:35]
      inflight_opcodes <= 64'h0; // @[Monitor.scala 615:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 705:22]
    end
    if (reset) begin // @[Monitor.scala 617:33]
      inflight_sizes <= 128'h0; // @[Monitor.scala 617:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 706:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 708:27]
      watchdog <= 32'h0; // @[Monitor.scala 708:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 714:47]
      watchdog <= 32'h0; // @[Monitor.scala 714:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 713:14]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_1 <= 16'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Monitor.scala 727:35]
      inflight_sizes_1 <= 128'h0; // @[Monitor.scala 727:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 813:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 815:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 815:27]
    end else if (_d_first_T) begin // @[Monitor.scala 821:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 821:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 820:14]
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_72 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_72 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_34 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_72 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_72 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_185 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_185 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_51 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_51 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_283 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_283 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_198 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_395 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_395 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_305 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_395 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_395 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_519 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_413 & ~(_T_519 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_591 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_591 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_601 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_601 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_523 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_591 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_591 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_687 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_687 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_609 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_775 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_775 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_785 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_785 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_297 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_297 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_695 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_797 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_797 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_805 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_805 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_817 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_801 & ~(_T_817 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_805 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_805 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_832 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_832 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_836 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_836 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_821 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_805 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_805 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_832 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_832 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_836 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_836 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_869 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_849 & ~(_T_869 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_878 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_869 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_895 & ~(_T_869 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_809 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_809 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_813 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_913 & ~(_T_813 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_944 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_944 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_948 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_948 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_952 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_952 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_956 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_956 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_943 & ~(_T_960 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_943 & ~(_T_960 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_968 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_968 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_972 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_972 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_976 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_976 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_980 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_980 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_984 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_984 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_967 & ~(_T_988 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_967 & ~(_T_988 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_997 & ~(_T_1001 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_997 & ~(_T_1001 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & ~(_T_1020 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & ~(_T_1020 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1026 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1026 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1030 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & same_cycle_resp & ~(_T_1030 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1038 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1038 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1042 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1008 & ~same_cycle_resp & ~(_T_1042 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1052 & ~(_T_1054 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1052 & ~(_T_1054 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1061 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1061 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1070 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1070 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1096 & ~(_T_1104[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1096 & ~(_T_1104[0] | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1096 & ~(_T_1114 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1096 & ~(_T_1114 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1139 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1139 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[3:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[15:0];
  _RAND_14 = {2{`RANDOM}};
  inflight_opcodes = _RAND_14[63:0];
  _RAND_15 = {4{`RANDOM}};
  inflight_sizes = _RAND_15[127:0];
  _RAND_16 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  watchdog = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[15:0];
  _RAND_20 = {4{`RANDOM}};
  inflight_sizes_1 = _RAND_20[127:0];
  _RAND_21 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  watchdog_1 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLMonitor_3(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [1:0]  io_in_a_bits_source,
  input  [31:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_b_ready,
  input         io_in_b_valid,
  input  [1:0]  io_in_b_bits_param,
  input  [31:0] io_in_b_bits_address,
  input         io_in_c_ready,
  input         io_in_c_valid,
  input  [2:0]  io_in_c_bits_opcode,
  input  [2:0]  io_in_c_bits_param,
  input  [3:0]  io_in_c_bits_size,
  input  [1:0]  io_in_c_bits_source,
  input  [31:0] io_in_c_bits_address,
  input         io_in_c_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [1:0]  io_in_d_bits_param,
  input  [3:0]  io_in_d_bits_size,
  input  [1:0]  io_in_d_bits_source,
  input  [1:0]  io_in_d_bits_sink,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt,
  input         io_in_e_valid,
  input  [1:0]  io_in_e_bits_sink
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T = io_in_a_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_1 = io_in_a_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_2 = io_in_a_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok = _source_ok_T | _source_ok_T_1 | _source_ok_T_2; // @[Parameters.scala 1163:46]
  wire [26:0] _is_aligned_mask_T_1 = 27'hfff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask = ~_is_aligned_mask_T_1[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_86 = {{20'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T = io_in_a_bits_address & _GEN_86; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 32'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  mask_sub_acc = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_sub_acc_1 = mask_sub_acc | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_sub_acc_2 = mask_sub_acc | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_sub_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_3 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_2; // @[Misc.scala 214:29]
  wire  mask_sub_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_4 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_3; // @[Misc.scala 214:29]
  wire  mask_sub_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_5 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_4; // @[Misc.scala 214:29]
  wire  mask_sub_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_6 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq = mask_sub_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_sub_acc_3 | mask_size_2 & mask_eq; // @[Misc.scala 214:29]
  wire  mask_eq_1 = mask_sub_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_sub_acc_3 | mask_size_2 & mask_eq_1; // @[Misc.scala 214:29]
  wire  mask_eq_2 = mask_sub_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_sub_acc_4 | mask_size_2 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_sub_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_sub_acc_4 | mask_size_2 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_sub_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_sub_acc_5 | mask_size_2 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_sub_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_sub_acc_5 | mask_size_2 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_eq_6 = mask_sub_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_sub_acc_6 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_sub_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_sub_acc_6 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [32:0] _T_7 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 137:49]
  wire  _T_33 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25]
  wire  _T_35 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_42 = _T_35 & source_ok; // @[Parameters.scala 1213:30]
  wire  _T_52 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [31:0] _T_55 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_56 = {1'b0,$signed(_T_55)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_58 = $signed(_T_56) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_59 = $signed(_T_58) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_60 = _T_52 & _T_59; // @[Parameters.scala 667:56]
  wire  _T_63 = _T_42 & _T_60; // @[Parameters.scala 1422:195]
  wire  _T_70 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 91:48]
  wire  _T_71 = _source_ok_T & _T_70; // @[Mux.scala 27:72]
  wire  _T_87 = _T_71 & _T_35; // @[Parameters.scala 1437:195]
  wire  _T_101 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_105 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18]
  wire  _T_106 = _T_105 == 8'h0; // @[Monitor.scala 90:31]
  wire  _T_110 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18]
  wire  _T_114 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25]
  wire  _T_186 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31]
  wire  _T_199 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25]
  wire [31:0] _T_217 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 137:31]
  wire [32:0] _T_218 = {1'b0,$signed(_T_217)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_220 = $signed(_T_218) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_221 = $signed(_T_220) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_222 = _T_35 & _T_221; // @[Parameters.scala 667:56]
  wire [32:0] _T_230 = $signed(_T_7) & 33'shfa012000; // @[Parameters.scala 137:52]
  wire  _T_231 = $signed(_T_230) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_232 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _T_233 = {1'b0,$signed(_T_232)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_235 = $signed(_T_233) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_236 = $signed(_T_235) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_237 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_238 = {1'b0,$signed(_T_237)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_240 = $signed(_T_238) & 33'shfa010000; // @[Parameters.scala 137:52]
  wire  _T_241 = $signed(_T_240) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_242 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_243 = {1'b0,$signed(_T_242)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_245 = $signed(_T_243) & 33'shf8000000; // @[Parameters.scala 137:52]
  wire  _T_246 = $signed(_T_245) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_247 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_248 = {1'b0,$signed(_T_247)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_250 = $signed(_T_248) & 33'shf0000000; // @[Parameters.scala 137:52]
  wire  _T_251 = $signed(_T_250) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_252 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_253 = {1'b0,$signed(_T_252)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_255 = $signed(_T_253) & 33'she0000000; // @[Parameters.scala 137:52]
  wire  _T_256 = $signed(_T_255) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _T_257 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _T_258 = {1'b0,$signed(_T_257)}; // @[Parameters.scala 137:49]
  wire [32:0] _T_260 = $signed(_T_258) & 33'shc0000000; // @[Parameters.scala 137:52]
  wire  _T_261 = $signed(_T_260) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_273 = _T_231 | _T_236 | _T_241 | _T_246 | _T_251 | _T_256 | _T_261 | _T_59; // @[Parameters.scala 668:42]
  wire  _T_274 = _T_52 & _T_273; // @[Parameters.scala 667:56]
  wire  _T_276 = _T_222 | _T_274; // @[Parameters.scala 669:30]
  wire  _T_286 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31]
  wire  _T_290 = io_in_a_bits_mask == mask; // @[Monitor.scala 112:30]
  wire  _T_298 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25]
  wire  _T_345 = _T_231 | _T_241 | _T_246 | _T_59; // @[Parameters.scala 668:42]
  wire  _T_346 = _T_52 & _T_345; // @[Parameters.scala 667:56]
  wire  _T_355 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_374 = _T_251 | _T_256 | _T_261; // @[Parameters.scala 668:42]
  wire  _T_375 = _T_355 & _T_374; // @[Parameters.scala 667:56]
  wire  _T_379 = _T_222 | _T_346 | _T_375; // @[Parameters.scala 669:30]
  wire  _T_380 = _T_42 & _T_379; // @[Parameters.scala 1426:195]
  wire  _T_398 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25]
  wire [7:0] _T_494 = ~mask; // @[Monitor.scala 129:33]
  wire [7:0] _T_495 = io_in_a_bits_mask & _T_494; // @[Monitor.scala 129:31]
  wire  _T_496 = _T_495 == 8'h0; // @[Monitor.scala 129:40]
  wire  _T_500 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25]
  wire  _T_512 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 92:42]
  wire [32:0] _T_518 = $signed(_T_7) & 33'shf8010000; // @[Parameters.scala 137:52]
  wire  _T_519 = $signed(_T_518) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_525 = _T_519 | _T_246; // @[Parameters.scala 668:42]
  wire  _T_526 = _T_512 & _T_525; // @[Parameters.scala 667:56]
  wire  _T_560 = _T_42 & _T_526; // @[Parameters.scala 1423:195]
  wire  _T_570 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_578 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25]
  wire  _T_648 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_656 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25]
  wire  _T_728 = _T_42 & _T_222; // @[Parameters.scala 1428:195]
  wire  _T_738 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_750 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_4 = io_in_d_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_5 = io_in_d_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_6 = io_in_d_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_1 = _source_ok_T_4 | _source_ok_T_5 | _source_ok_T_6; // @[Parameters.scala 1163:46]
  wire  _T_754 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25]
  wire  _T_758 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27]
  wire  _T_762 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28]
  wire  _T_766 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15]
  wire  _T_770 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15]
  wire  _T_774 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25]
  wire  _T_785 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _T_789 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28]
  wire  _T_802 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25]
  wire  _T_822 = _T_770 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30]
  wire  _T_831 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25]
  wire  _T_848 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25]
  wire  _T_866 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25]
  wire [32:0] _T_890 = {1'b0,$signed(io_in_b_bits_address)}; // @[Parameters.scala 137:49]
  wire [31:0] _address_ok_T = io_in_b_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_1 = {1'b0,$signed(_address_ok_T)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_3 = $signed(_address_ok_T_1) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_4 = $signed(_address_ok_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_5 = io_in_b_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_6 = {1'b0,$signed(_address_ok_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_8 = $signed(_address_ok_T_6) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_9 = $signed(_address_ok_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_10 = io_in_b_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_11 = {1'b0,$signed(_address_ok_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_13 = $signed(_address_ok_T_11) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_14 = $signed(_address_ok_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_18 = $signed(_T_890) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_19 = $signed(_address_ok_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_20 = io_in_b_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_21 = {1'b0,$signed(_address_ok_T_20)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_23 = $signed(_address_ok_T_21) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_24 = $signed(_address_ok_T_23) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_25 = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_26 = {1'b0,$signed(_address_ok_T_25)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_28 = $signed(_address_ok_T_26) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_29 = $signed(_address_ok_T_28) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_30 = io_in_b_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_31 = {1'b0,$signed(_address_ok_T_30)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_33 = $signed(_address_ok_T_31) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_34 = $signed(_address_ok_T_33) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_35 = io_in_b_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_36 = {1'b0,$signed(_address_ok_T_35)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_38 = $signed(_address_ok_T_36) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_39 = $signed(_address_ok_T_38) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_40 = io_in_b_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_41 = {1'b0,$signed(_address_ok_T_40)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_43 = $signed(_address_ok_T_41) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_44 = $signed(_address_ok_T_43) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_46 = _address_ok_T_34 | _address_ok_T_39 | _address_ok_T_44; // @[Parameters.scala 598:92]
  wire  address_ok = _address_ok_T_4 | _address_ok_T_9 | _address_ok_T_14 | _address_ok_T_19 | _address_ok_T_24 |
    _address_ok_T_29 | _address_ok_T_46; // @[Parameters.scala 622:64]
  wire [31:0] _is_aligned_T_1 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 20:16]
  wire  is_aligned_1 = _is_aligned_T_1 == 32'h0; // @[Edges.scala 20:24]
  wire  _T_950 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 102:26]
  wire  _source_ok_T_8 = io_in_c_bits_source == 2'h0; // @[Parameters.scala 46:9]
  wire  _source_ok_T_9 = io_in_c_bits_source == 2'h1; // @[Parameters.scala 46:9]
  wire  _source_ok_T_10 = io_in_c_bits_source == 2'h2; // @[Parameters.scala 46:9]
  wire  source_ok_2 = _source_ok_T_8 | _source_ok_T_9 | _source_ok_T_10; // @[Parameters.scala 1163:46]
  wire [26:0] _is_aligned_mask_T_7 = 27'hfff << io_in_c_bits_size; // @[package.scala 234:77]
  wire [11:0] is_aligned_mask_2 = ~_is_aligned_mask_T_7[11:0]; // @[package.scala 234:46]
  wire [31:0] _GEN_87 = {{20'd0}, is_aligned_mask_2}; // @[Edges.scala 20:16]
  wire [31:0] _is_aligned_T_2 = io_in_c_bits_address & _GEN_87; // @[Edges.scala 20:16]
  wire  is_aligned_2 = _is_aligned_T_2 == 32'h0; // @[Edges.scala 20:24]
  wire [31:0] _address_ok_T_52 = io_in_c_bits_address ^ 32'h3000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_53 = {1'b0,$signed(_address_ok_T_52)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_55 = $signed(_address_ok_T_53) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_56 = $signed(_address_ok_T_55) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_57 = io_in_c_bits_address ^ 32'hc000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_58 = {1'b0,$signed(_address_ok_T_57)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_60 = $signed(_address_ok_T_58) & -33'sh4000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_61 = $signed(_address_ok_T_60) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_62 = io_in_c_bits_address ^ 32'h2000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_63 = {1'b0,$signed(_address_ok_T_62)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_65 = $signed(_address_ok_T_63) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_66 = $signed(_address_ok_T_65) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _address_ok_T_68 = {1'b0,$signed(io_in_c_bits_address)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_70 = $signed(_address_ok_T_68) & -33'sh1000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_71 = $signed(_address_ok_T_70) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_72 = io_in_c_bits_address ^ 32'h10000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_73 = {1'b0,$signed(_address_ok_T_72)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_75 = $signed(_address_ok_T_73) & -33'sh10000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_76 = $signed(_address_ok_T_75) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_77 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_78 = {1'b0,$signed(_address_ok_T_77)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_80 = $signed(_address_ok_T_78) & -33'sh80000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_81 = $signed(_address_ok_T_80) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_82 = io_in_c_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_83 = {1'b0,$signed(_address_ok_T_82)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_85 = $signed(_address_ok_T_83) & -33'sh10000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_86 = $signed(_address_ok_T_85) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_87 = io_in_c_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_88 = {1'b0,$signed(_address_ok_T_87)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_90 = $signed(_address_ok_T_88) & -33'sh20000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_91 = $signed(_address_ok_T_90) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _address_ok_T_92 = io_in_c_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _address_ok_T_93 = {1'b0,$signed(_address_ok_T_92)}; // @[Parameters.scala 137:49]
  wire [32:0] _address_ok_T_95 = $signed(_address_ok_T_93) & -33'sh40000000; // @[Parameters.scala 137:52]
  wire  _address_ok_T_96 = $signed(_address_ok_T_95) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _address_ok_T_98 = _address_ok_T_86 | _address_ok_T_91 | _address_ok_T_96; // @[Parameters.scala 598:92]
  wire  address_ok_1 = _address_ok_T_56 | _address_ok_T_61 | _address_ok_T_66 | _address_ok_T_71 | _address_ok_T_76 |
    _address_ok_T_81 | _address_ok_T_98; // @[Parameters.scala 622:64]
  wire  _T_1199 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 244:25]
  wire  _T_1206 = io_in_c_bits_size >= 4'h3; // @[Monitor.scala 247:30]
  wire  _T_1213 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 120:29]
  wire  _T_1217 = ~io_in_c_bits_corrupt; // @[Monitor.scala 250:18]
  wire  _T_1221 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 253:25]
  wire  _T_1239 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 261:25]
  wire  _T_1241 = io_in_c_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_1248 = _T_1241 & source_ok_2; // @[Parameters.scala 1213:30]
  wire  _T_1258 = io_in_c_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire [32:0] _T_1264 = $signed(_address_ok_T_78) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  _T_1265 = $signed(_T_1264) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _T_1266 = _T_1258 & _T_1265; // @[Parameters.scala 667:56]
  wire  _T_1269 = _T_1248 & _T_1266; // @[Parameters.scala 1422:195]
  wire  _T_1276 = 4'h6 == io_in_c_bits_size; // @[Parameters.scala 91:48]
  wire  _T_1277 = _source_ok_T_8 & _T_1276; // @[Mux.scala 27:72]
  wire  _T_1293 = _T_1277 & _T_1241; // @[Parameters.scala 1437:195]
  wire  _T_1315 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 271:25]
  wire  _T_1387 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 280:25]
  wire  _T_1397 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 284:31]
  wire  _T_1405 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 288:25]
  wire  _T_1419 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 295:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [8:0] a_first_beats1_decode = is_aligned_mask[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 386:22]
  reg [2:0] param; // @[Monitor.scala 387:22]
  reg [3:0] size; // @[Monitor.scala 388:22]
  reg [1:0] source; // @[Monitor.scala 389:22]
  reg [31:0] address; // @[Monitor.scala 390:22]
  wire  _T_1441 = io_in_a_valid & ~a_first; // @[Monitor.scala 391:19]
  wire  _T_1442 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 392:32]
  wire  _T_1446 = io_in_a_bits_param == param; // @[Monitor.scala 393:32]
  wire  _T_1450 = io_in_a_bits_size == size; // @[Monitor.scala 394:32]
  wire  _T_1454 = io_in_a_bits_source == source; // @[Monitor.scala 395:32]
  wire  _T_1458 = io_in_a_bits_address == address; // @[Monitor.scala 396:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 537:22]
  reg [1:0] param_1; // @[Monitor.scala 538:22]
  reg [3:0] size_1; // @[Monitor.scala 539:22]
  reg [1:0] source_1; // @[Monitor.scala 540:22]
  reg [1:0] sink; // @[Monitor.scala 541:22]
  reg  denied; // @[Monitor.scala 542:22]
  wire  _T_1465 = io_in_d_valid & ~d_first; // @[Monitor.scala 543:19]
  wire  _T_1466 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 544:29]
  wire  _T_1470 = io_in_d_bits_param == param_1; // @[Monitor.scala 545:29]
  wire  _T_1474 = io_in_d_bits_size == size_1; // @[Monitor.scala 546:29]
  wire  _T_1478 = io_in_d_bits_source == source_1; // @[Monitor.scala 547:29]
  wire  _T_1482 = io_in_d_bits_sink == sink; // @[Monitor.scala 548:29]
  wire  _T_1486 = io_in_d_bits_denied == denied; // @[Monitor.scala 549:29]
  wire  b_first_done = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37]
  reg [8:0] b_first_counter; // @[Edges.scala 228:27]
  wire [8:0] b_first_counter1 = b_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  b_first = b_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [1:0] param_2; // @[Monitor.scala 410:22]
  reg [31:0] address_1; // @[Monitor.scala 413:22]
  wire  _T_1493 = io_in_b_valid & ~b_first; // @[Monitor.scala 414:19]
  wire  _T_1498 = io_in_b_bits_param == param_2; // @[Monitor.scala 416:32]
  wire  _T_1510 = io_in_b_bits_address == address_1; // @[Monitor.scala 419:32]
  wire  _c_first_T = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37]
  wire [8:0] c_first_beats1_decode = is_aligned_mask_2[11:3]; // @[Edges.scala 219:59]
  wire  c_first_beats1_opdata = io_in_c_bits_opcode[0]; // @[Edges.scala 101:36]
  reg [8:0] c_first_counter; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1 = c_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  c_first = c_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_3; // @[Monitor.scala 514:22]
  reg [2:0] param_3; // @[Monitor.scala 515:22]
  reg [3:0] size_3; // @[Monitor.scala 516:22]
  reg [1:0] source_3; // @[Monitor.scala 517:22]
  reg [31:0] address_2; // @[Monitor.scala 518:22]
  wire  _T_1517 = io_in_c_valid & ~c_first; // @[Monitor.scala 519:19]
  wire  _T_1518 = io_in_c_bits_opcode == opcode_3; // @[Monitor.scala 520:32]
  wire  _T_1522 = io_in_c_bits_param == param_3; // @[Monitor.scala 521:32]
  wire  _T_1526 = io_in_c_bits_size == size_3; // @[Monitor.scala 522:32]
  wire  _T_1530 = io_in_c_bits_source == source_3; // @[Monitor.scala 523:32]
  wire  _T_1534 = io_in_c_bits_address == address_2; // @[Monitor.scala 524:32]
  reg [2:0] inflight; // @[Monitor.scala 613:27]
  reg [11:0] inflight_opcodes; // @[Monitor.scala 615:35]
  reg [23:0] inflight_sizes; // @[Monitor.scala 617:33]
  reg [8:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] a_first_counter1_1 = a_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_1 = d_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  wire [3:0] _GEN_88 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69]
  wire [4:0] _a_opcode_lookup_T = {{1'd0}, _GEN_88}; // @[Monitor.scala 636:69]
  wire [11:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 636:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 611:57]
  wire [15:0] _GEN_89 = {{4'd0}, _a_opcode_lookup_T_1}; // @[Monitor.scala 636:97]
  wire [15:0] _a_opcode_lookup_T_6 = _GEN_89 & _a_opcode_lookup_T_5; // @[Monitor.scala 636:97]
  wire [15:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[15:1]}; // @[Monitor.scala 636:152]
  wire [4:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65]
  wire [23:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 640:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 611:57]
  wire [23:0] _GEN_91 = {{8'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 640:91]
  wire [23:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_91; // @[Monitor.scala 640:91]
  wire [23:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[23:1]}; // @[Monitor.scala 640:144]
  wire  _T_1540 = io_in_a_valid & a_first_1; // @[Monitor.scala 650:26]
  wire [3:0] _a_set_wo_ready_T = 4'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_27 = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 650:71 Monitor.scala 651:22]
  wire  _T_1543 = _a_first_T & a_first_1; // @[Monitor.scala 654:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 656:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 657:59]
  wire [3:0] _GEN_93 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79]
  wire [4:0] _a_opcodes_set_T = {{1'd0}, _GEN_93}; // @[Monitor.scala 658:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 656:28]
  wire [34:0] _GEN_94 = {{31'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54]
  wire [34:0] _a_opcodes_set_T_1 = _GEN_94 << _a_opcodes_set_T; // @[Monitor.scala 658:54]
  wire [4:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 654:72 Monitor.scala 657:28]
  wire [35:0] _GEN_95 = {{31'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52]
  wire [35:0] _a_sizes_set_T_1 = _GEN_95 << _a_sizes_set_T; // @[Monitor.scala 659:52]
  wire [2:0] _T_1545 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26]
  wire  _T_1547 = ~_T_1545[0]; // @[Monitor.scala 660:17]
  wire [3:0] _GEN_28 = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 655:28]
  wire [34:0] _GEN_31 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 35'h0; // @[Monitor.scala 654:72 Monitor.scala 658:28]
  wire [35:0] _GEN_32 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 36'h0; // @[Monitor.scala 654:72 Monitor.scala 659:28]
  wire  _T_1551 = io_in_d_valid & d_first_1; // @[Monitor.scala 673:26]
  wire  _T_1553 = ~_T_754; // @[Monitor.scala 673:74]
  wire  _T_1554 = io_in_d_valid & d_first_1 & ~_T_754; // @[Monitor.scala 673:71]
  wire [3:0] _d_clr_wo_ready_T = 4'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_33 = io_in_d_valid & d_first_1 & ~_T_754 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 673:90 Monitor.scala 674:22]
  wire [46:0] _GEN_97 = {{31'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 679:76]
  wire [46:0] _d_opcodes_clr_T_5 = _GEN_97 << _a_opcode_lookup_T; // @[Monitor.scala 679:76]
  wire [46:0] _GEN_98 = {{31'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 680:74]
  wire [46:0] _d_sizes_clr_T_5 = _GEN_98 << _a_size_lookup_T; // @[Monitor.scala 680:74]
  wire [3:0] _GEN_34 = _d_first_T & d_first_1 & _T_1553 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 677:91 Monitor.scala 678:21]
  wire [46:0] _GEN_35 = _d_first_T & d_first_1 & _T_1553 ? _d_opcodes_clr_T_5 : 47'h0; // @[Monitor.scala 677:91 Monitor.scala 679:21]
  wire [46:0] _GEN_36 = _d_first_T & d_first_1 & _T_1553 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 677:91 Monitor.scala 680:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113]
  wire  same_cycle_resp = _T_1540 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:88]
  wire [2:0] _T_1564 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25]
  wire  _T_1566 = _T_1564[0] | same_cycle_resp; // @[Monitor.scala 684:49]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire  _T_1571 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 688:39]
  wire  _T_1572 = io_in_d_bits_opcode == _GEN_44 | _T_1571; // @[Monitor.scala 687:77]
  wire  _T_1576 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire  _T_1583 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 692:38]
  wire  _T_1584 = io_in_d_bits_opcode == _GEN_60 | _T_1583; // @[Monitor.scala 691:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_99 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36]
  wire  _T_1588 = _GEN_99 == a_size_lookup; // @[Monitor.scala 693:36]
  wire  _T_1598 = _T_1551 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_1553; // @[Monitor.scala 696:116]
  wire  _T_1599 = ~io_in_d_ready; // @[Monitor.scala 697:15]
  wire  _T_1600 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 697:32]
  wire [2:0] a_set_wo_ready = _GEN_27[2:0];
  wire [2:0] d_clr_wo_ready = _GEN_33[2:0];
  wire  _T_1607 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 701:48]
  wire [2:0] a_set = _GEN_28[2:0];
  wire [2:0] _inflight_T = inflight | a_set; // @[Monitor.scala 704:27]
  wire [2:0] d_clr = _GEN_34[2:0];
  wire [2:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 704:38]
  wire [2:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 704:36]
  wire [11:0] a_opcodes_set = _GEN_31[11:0];
  wire [11:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43]
  wire [11:0] d_opcodes_clr = _GEN_35[11:0];
  wire [11:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 705:62]
  wire [11:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 705:60]
  wire [23:0] a_sizes_set = _GEN_32[23:0];
  wire [23:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39]
  wire [23:0] d_sizes_clr = _GEN_36[23:0];
  wire [23:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 706:56]
  wire [23:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 706:54]
  reg [31:0] watchdog; // @[Monitor.scala 708:27]
  wire  _T_1616 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 711:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 713:26]
  reg [2:0] inflight_1; // @[Monitor.scala 725:35]
  reg [23:0] inflight_sizes_1; // @[Monitor.scala 727:35]
  reg [8:0] c_first_counter_1; // @[Edges.scala 228:27]
  wire [8:0] c_first_counter1_1 = c_first_counter_1 - 9'h1; // @[Edges.scala 229:28]
  wire  c_first_1 = c_first_counter_1 == 9'h0; // @[Edges.scala 230:25]
  reg [8:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_2 = d_first_counter_2 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 9'h0; // @[Edges.scala 230:25]
  wire [23:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 749:42]
  wire [23:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_91; // @[Monitor.scala 749:93]
  wire [23:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[23:1]}; // @[Monitor.scala 749:146]
  wire  _T_1626 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 67:40]
  wire  _T_1627 = io_in_c_valid & c_first_1 & _T_1626; // @[Monitor.scala 758:37]
  wire [3:0] _c_set_wo_ready_T = 4'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35]
  wire [3:0] _GEN_72 = io_in_c_valid & c_first_1 & _T_1626 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 758:71 Monitor.scala 759:22]
  wire  _T_1633 = _c_first_T & c_first_1 & _T_1626; // @[Monitor.scala 762:38]
  wire [4:0] _c_sizes_set_interm_T = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 765:51]
  wire [4:0] _c_sizes_set_interm_T_1 = _c_sizes_set_interm_T | 5'h1; // @[Monitor.scala 765:59]
  wire [4:0] _c_sizes_set_T = {io_in_c_bits_source, 3'h0}; // @[Monitor.scala 767:77]
  wire [4:0] c_sizes_set_interm = _c_first_T & c_first_1 & _T_1626 ? _c_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 762:72 Monitor.scala 765:28]
  wire [35:0] _GEN_107 = {{31'd0}, c_sizes_set_interm}; // @[Monitor.scala 767:52]
  wire [35:0] _c_sizes_set_T_1 = _GEN_107 << _c_sizes_set_T; // @[Monitor.scala 767:52]
  wire [2:0] _T_1634 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 768:26]
  wire  _T_1636 = ~_T_1634[0]; // @[Monitor.scala 768:17]
  wire [3:0] _GEN_73 = _c_first_T & c_first_1 & _T_1626 ? _c_set_wo_ready_T : 4'h0; // @[Monitor.scala 762:72 Monitor.scala 763:28]
  wire [35:0] _GEN_77 = _c_first_T & c_first_1 & _T_1626 ? _c_sizes_set_T_1 : 36'h0; // @[Monitor.scala 762:72 Monitor.scala 767:28]
  wire  _T_1640 = io_in_d_valid & d_first_2; // @[Monitor.scala 781:26]
  wire  _T_1642 = io_in_d_valid & d_first_2 & _T_754; // @[Monitor.scala 781:71]
  wire [3:0] _GEN_78 = io_in_d_valid & d_first_2 & _T_754 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 781:89 Monitor.scala 782:22]
  wire [3:0] _GEN_79 = _d_first_T & d_first_2 & _T_754 ? _d_clr_wo_ready_T : 4'h0; // @[Monitor.scala 785:90 Monitor.scala 786:21]
  wire [46:0] _GEN_81 = _d_first_T & d_first_2 & _T_754 ? _d_sizes_clr_T_5 : 47'h0; // @[Monitor.scala 785:90 Monitor.scala 788:21]
  wire  _same_cycle_resp_T_8 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 792:113]
  wire  same_cycle_resp_1 = _T_1627 & io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 792:88]
  wire [2:0] _T_1650 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25]
  wire  _T_1652 = _T_1650[0] | same_cycle_resp_1; // @[Monitor.scala 793:49]
  wire  _T_1656 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 795:36]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_1660 = _GEN_99 == c_size_lookup; // @[Monitor.scala 797:36]
  wire  _T_1669 = _T_1640 & c_first_1 & io_in_c_valid & _same_cycle_resp_T_8 & _T_754; // @[Monitor.scala 801:116]
  wire  _T_1671 = _T_1599 | io_in_c_ready; // @[Monitor.scala 802:32]
  wire [2:0] c_set_wo_ready = _GEN_72[2:0];
  wire  _T_1675 = |c_set_wo_ready; // @[Monitor.scala 806:28]
  wire [2:0] d_clr_wo_ready_1 = _GEN_78[2:0];
  wire  _T_1676 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 807:31]
  wire [2:0] c_set = _GEN_73[2:0];
  wire [2:0] _inflight_T_3 = inflight_1 | c_set; // @[Monitor.scala 811:35]
  wire [2:0] d_clr_1 = _GEN_79[2:0];
  wire [2:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 811:46]
  wire [2:0] _inflight_T_5 = _inflight_T_3 & _inflight_T_4; // @[Monitor.scala 811:44]
  wire [23:0] c_sizes_set = _GEN_77[23:0];
  wire [23:0] _inflight_sizes_T_3 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 813:41]
  wire [23:0] d_sizes_clr_1 = _GEN_81[23:0];
  wire [23:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 813:58]
  wire [23:0] _inflight_sizes_T_5 = _inflight_sizes_T_3 & _inflight_sizes_T_4; // @[Monitor.scala 813:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 815:27]
  wire  _T_1685 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 818:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 820:26]
  reg [3:0] inflight_2; // @[Monitor.scala 825:27]
  reg [8:0] d_first_counter_3; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1_3 = d_first_counter_3 - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_3 = d_first_counter_3 == 9'h0; // @[Edges.scala 230:25]
  wire  _T_1697 = io_in_d_bits_opcode[2] & ~io_in_d_bits_opcode[1]; // @[Edges.scala 70:40]
  wire  _T_1698 = _d_first_T & d_first_3 & _T_1697; // @[Monitor.scala 831:38]
  wire [3:0] _d_set_T = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_1699 = inflight_2 >> io_in_d_bits_sink; // @[Monitor.scala 833:23]
  wire  _T_1701 = ~_T_1699[0]; // @[Monitor.scala 833:14]
  wire [3:0] d_set = _d_first_T & d_first_3 & _T_1697 ? _d_set_T : 4'h0; // @[Monitor.scala 831:72 Monitor.scala 832:13]
  wire [3:0] _e_clr_T = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35]
  wire [3:0] _T_1708 = d_set | inflight_2; // @[Monitor.scala 839:24]
  wire [3:0] _T_1709 = _T_1708 >> io_in_e_bits_sink; // @[Monitor.scala 839:35]
  wire [3:0] e_clr = io_in_e_valid ? _e_clr_T : 4'h0; // @[Monitor.scala 837:73 Monitor.scala 838:13]
  wire [3:0] _inflight_T_6 = inflight_2 | d_set; // @[Monitor.scala 844:27]
  wire [3:0] _inflight_T_7 = ~e_clr; // @[Monitor.scala 844:38]
  wire [3:0] _inflight_T_8 = _inflight_T_6 & _inflight_T_7; // @[Monitor.scala 844:36]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 401:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 402:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 403:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      param_1 <= io_in_d_bits_param; // @[Monitor.scala 553:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 555:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      sink <= io_in_d_bits_sink; // @[Monitor.scala 556:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 557:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      b_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (b_first_done) begin // @[Edges.scala 234:17]
      if (b_first) begin // @[Edges.scala 235:21]
        b_first_counter <= 9'h0;
      end else begin
        b_first_counter <= b_first_counter1;
      end
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 421:32]
      param_2 <= io_in_b_bits_param; // @[Monitor.scala 423:15]
    end
    if (b_first_done & b_first) begin // @[Monitor.scala 421:32]
      address_1 <= io_in_b_bits_address; // @[Monitor.scala 426:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter <= c_first_beats1_decode;
        end else begin
          c_first_counter <= 9'h0;
        end
      end else begin
        c_first_counter <= c_first_counter1;
      end
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      opcode_3 <= io_in_c_bits_opcode; // @[Monitor.scala 527:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      param_3 <= io_in_c_bits_param; // @[Monitor.scala 528:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      size_3 <= io_in_c_bits_size; // @[Monitor.scala 529:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      source_3 <= io_in_c_bits_source; // @[Monitor.scala 530:15]
    end
    if (_c_first_T & c_first) begin // @[Monitor.scala 526:32]
      address_2 <= io_in_c_bits_address; // @[Monitor.scala 531:15]
    end
    if (reset) begin // @[Monitor.scala 613:27]
      inflight <= 3'h0; // @[Monitor.scala 613:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 704:14]
    end
    if (reset) begin // @[Monitor.scala 615:35]
      inflight_opcodes <= 12'h0; // @[Monitor.scala 615:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 705:22]
    end
    if (reset) begin // @[Monitor.scala 617:33]
      inflight_sizes <= 24'h0; // @[Monitor.scala 617:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 706:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 9'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 9'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 708:27]
      watchdog <= 32'h0; // @[Monitor.scala 708:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 714:47]
      watchdog <= 32'h0; // @[Monitor.scala 714:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 713:14]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_1 <= 3'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Monitor.scala 727:35]
      inflight_sizes_1 <= 24'h0; // @[Monitor.scala 727:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 813:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      c_first_counter_1 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_c_first_T) begin // @[Edges.scala 234:17]
      if (c_first_1) begin // @[Edges.scala 235:21]
        if (c_first_beats1_opdata) begin // @[Edges.scala 220:14]
          c_first_counter_1 <= c_first_beats1_decode;
        end else begin
          c_first_counter_1 <= 9'h0;
        end
      end else begin
        c_first_counter_1 <= c_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 9'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 815:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 815:27]
    end else if (_c_first_T | _d_first_T) begin // @[Monitor.scala 821:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 821:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 820:14]
    end
    if (reset) begin // @[Monitor.scala 825:27]
      inflight_2 <= 4'h0; // @[Monitor.scala 825:27]
    end else begin
      inflight_2 <= _inflight_T_8; // @[Monitor.scala 844:14]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_3 <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_3) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_3 <= d_first_beats1_decode;
        end else begin
          d_first_counter_3 <= 9'h0;
        end
      end else begin
        d_first_counter_3 <= d_first_counter1_3;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_63 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_63 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_87 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_87 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_33 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_63 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_63 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_87 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_87 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_101 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_186 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_186 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_106 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_114 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_42 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_42 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_276 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_276 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_286 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_199 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_380 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_380 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_286 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_298 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_380 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_380 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_286 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_286 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_496 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_398 & ~(_T_496 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_570 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_570 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_500 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_560 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_648 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_648 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_578 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_728 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_728 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_738 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_738 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_290 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_290 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_110 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_656 & ~(_T_110 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_750 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_750 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_758 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_758 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_770 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_754 & ~(_T_770 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_758 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_758 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_785 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_785 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_789 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_789 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_774 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_758 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_758 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_785 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_785 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_789 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_789 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_822 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_802 & ~(_T_822 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_831 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_822 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_848 & ~(_T_822 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_762 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_762 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_766 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_866 & ~(_T_766 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(address_ok | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(is_aligned_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_950 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel Probe carries invalid cap param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & ~(_T_950 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1199 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1221 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1269 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release type unsupported by manager (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1269 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel Release is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1239 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1269 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1269 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1293 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1293 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1206 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1206 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1213 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel ReleaseData carries invalid report param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1315 & ~(_T_1213 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1397 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1397 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1387 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(_T_1397 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel AccessAckData carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1405 & ~(_T_1397 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(address_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries unmanaged address (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(address_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(source_ok_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(source_ok_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(is_aligned_2 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck address not aligned to size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(is_aligned_2 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1397 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck carries invalid param (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1397 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1217 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel HintAck is corrupt (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_c_valid & _T_1419 & ~(_T_1217 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1442 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1442 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1446 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1446 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1450 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1450 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1454 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1454 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1441 & ~(_T_1458 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1441 & ~(_T_1458 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1466 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1466 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1470 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1470 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1474 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1474 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1478 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1478 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1482 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1482 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1465 & ~(_T_1486 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1465 & ~(_T_1486 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1493 & ~(_T_1498 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1493 & ~(_T_1498 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1493 & ~(_T_1510 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'B' channel addresss changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1493 & ~(_T_1510 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1518 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel opcode changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1518 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1522 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel param changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1522 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1526 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel size changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1526 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1530 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel source changed within multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1530 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1517 & ~(_T_1534 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel address changed with multibeat operation (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1517 & ~(_T_1534 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1543 & ~(_T_1547 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1543 & ~(_T_1547 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & ~(_T_1566 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & ~(_T_1566 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1572 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1572 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1576 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & same_cycle_resp & ~(_T_1576 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1584 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1584 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1588 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1554 & ~same_cycle_resp & ~(_T_1588 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1598 & ~(_T_1600 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1598 & ~(_T_1600 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1607 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1607 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1616 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1616 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1633 & ~(_T_1636 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' channel re-used a source ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1633 & ~(_T_1636 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1642 & ~(_T_1652 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1642 & ~(_T_1652 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1642 & same_cycle_resp_1 & ~(_T_1656 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1642 & same_cycle_resp_1 & ~(_T_1656 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1642 & ~same_cycle_resp_1 & ~(_T_1660 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1642 & ~same_cycle_resp_1 & ~(_T_1660 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1669 & ~(_T_1671 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1669 & ~(_T_1671 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1675 & ~(_T_1676 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'C' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1675 & ~(_T_1676 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_1685 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_1685 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1698 & ~(_T_1701 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel re-used a sink ID (connected at SystemBus.scala:41:96)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1698 & ~(_T_1701 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_e_valid & ~(_T_1709[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'E' channel acknowledged for nothing inflight (connected at SystemBus.scala:41:96)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_e_valid & ~(_T_1709[0] | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  param_1 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  size_1 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  source_1 = _RAND_10[1:0];
  _RAND_11 = {1{`RANDOM}};
  sink = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  denied = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  b_first_counter = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  param_2 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  address_1 = _RAND_15[31:0];
  _RAND_16 = {1{`RANDOM}};
  c_first_counter = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  opcode_3 = _RAND_17[2:0];
  _RAND_18 = {1{`RANDOM}};
  param_3 = _RAND_18[2:0];
  _RAND_19 = {1{`RANDOM}};
  size_3 = _RAND_19[3:0];
  _RAND_20 = {1{`RANDOM}};
  source_3 = _RAND_20[1:0];
  _RAND_21 = {1{`RANDOM}};
  address_2 = _RAND_21[31:0];
  _RAND_22 = {1{`RANDOM}};
  inflight = _RAND_22[2:0];
  _RAND_23 = {1{`RANDOM}};
  inflight_opcodes = _RAND_23[11:0];
  _RAND_24 = {1{`RANDOM}};
  inflight_sizes = _RAND_24[23:0];
  _RAND_25 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_25[8:0];
  _RAND_26 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_26[8:0];
  _RAND_27 = {1{`RANDOM}};
  watchdog = _RAND_27[31:0];
  _RAND_28 = {1{`RANDOM}};
  inflight_1 = _RAND_28[2:0];
  _RAND_29 = {1{`RANDOM}};
  inflight_sizes_1 = _RAND_29[23:0];
  _RAND_30 = {1{`RANDOM}};
  c_first_counter_1 = _RAND_30[8:0];
  _RAND_31 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  watchdog_1 = _RAND_32[31:0];
  _RAND_33 = {1{`RANDOM}};
  inflight_2 = _RAND_33[3:0];
  _RAND_34 = {1{`RANDOM}};
  d_first_counter_3 = _RAND_34[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module TLFIFOFixer(
  input         clock,
  input         reset,
  output        auto_in_1_a_ready,
  input         auto_in_1_a_valid,
  input  [2:0]  auto_in_1_a_bits_opcode,
  input  [2:0]  auto_in_1_a_bits_param,
  input  [3:0]  auto_in_1_a_bits_size,
  input  [1:0]  auto_in_1_a_bits_source,
  input  [31:0] auto_in_1_a_bits_address,
  input         auto_in_1_a_bits_user_amba_prot_bufferable,
  input         auto_in_1_a_bits_user_amba_prot_modifiable,
  input         auto_in_1_a_bits_user_amba_prot_readalloc,
  input         auto_in_1_a_bits_user_amba_prot_writealloc,
  input         auto_in_1_a_bits_user_amba_prot_privileged,
  input         auto_in_1_a_bits_user_amba_prot_secure,
  input         auto_in_1_a_bits_user_amba_prot_fetch,
  input  [7:0]  auto_in_1_a_bits_mask,
  input  [63:0] auto_in_1_a_bits_data,
  input         auto_in_1_a_bits_corrupt,
  input         auto_in_1_b_ready,
  output        auto_in_1_b_valid,
  output [1:0]  auto_in_1_b_bits_param,
  output [31:0] auto_in_1_b_bits_address,
  output        auto_in_1_c_ready,
  input         auto_in_1_c_valid,
  input  [2:0]  auto_in_1_c_bits_opcode,
  input  [2:0]  auto_in_1_c_bits_param,
  input  [3:0]  auto_in_1_c_bits_size,
  input  [1:0]  auto_in_1_c_bits_source,
  input  [31:0] auto_in_1_c_bits_address,
  input  [63:0] auto_in_1_c_bits_data,
  input         auto_in_1_c_bits_corrupt,
  input         auto_in_1_d_ready,
  output        auto_in_1_d_valid,
  output [2:0]  auto_in_1_d_bits_opcode,
  output [1:0]  auto_in_1_d_bits_param,
  output [3:0]  auto_in_1_d_bits_size,
  output [1:0]  auto_in_1_d_bits_source,
  output [1:0]  auto_in_1_d_bits_sink,
  output        auto_in_1_d_bits_denied,
  output [63:0] auto_in_1_d_bits_data,
  output        auto_in_1_d_bits_corrupt,
  input         auto_in_1_e_valid,
  input  [1:0]  auto_in_1_e_bits_sink,
  output        auto_in_0_a_ready,
  input         auto_in_0_a_valid,
  input  [2:0]  auto_in_0_a_bits_opcode,
  input  [2:0]  auto_in_0_a_bits_param,
  input  [3:0]  auto_in_0_a_bits_size,
  input  [3:0]  auto_in_0_a_bits_source,
  input  [31:0] auto_in_0_a_bits_address,
  input         auto_in_0_a_bits_user_amba_prot_bufferable,
  input         auto_in_0_a_bits_user_amba_prot_modifiable,
  input         auto_in_0_a_bits_user_amba_prot_readalloc,
  input         auto_in_0_a_bits_user_amba_prot_writealloc,
  input         auto_in_0_a_bits_user_amba_prot_privileged,
  input         auto_in_0_a_bits_user_amba_prot_secure,
  input         auto_in_0_a_bits_user_amba_prot_fetch,
  input  [7:0]  auto_in_0_a_bits_mask,
  input  [63:0] auto_in_0_a_bits_data,
  input         auto_in_0_a_bits_corrupt,
  input         auto_in_0_d_ready,
  output        auto_in_0_d_valid,
  output [2:0]  auto_in_0_d_bits_opcode,
  output [1:0]  auto_in_0_d_bits_param,
  output [3:0]  auto_in_0_d_bits_size,
  output [3:0]  auto_in_0_d_bits_source,
  output [1:0]  auto_in_0_d_bits_sink,
  output        auto_in_0_d_bits_denied,
  output [63:0] auto_in_0_d_bits_data,
  output        auto_in_0_d_bits_corrupt,
  input         auto_out_1_a_ready,
  output        auto_out_1_a_valid,
  output [2:0]  auto_out_1_a_bits_opcode,
  output [2:0]  auto_out_1_a_bits_param,
  output [3:0]  auto_out_1_a_bits_size,
  output [1:0]  auto_out_1_a_bits_source,
  output [31:0] auto_out_1_a_bits_address,
  output        auto_out_1_a_bits_user_amba_prot_bufferable,
  output        auto_out_1_a_bits_user_amba_prot_modifiable,
  output        auto_out_1_a_bits_user_amba_prot_readalloc,
  output        auto_out_1_a_bits_user_amba_prot_writealloc,
  output        auto_out_1_a_bits_user_amba_prot_privileged,
  output        auto_out_1_a_bits_user_amba_prot_secure,
  output        auto_out_1_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_1_a_bits_mask,
  output [63:0] auto_out_1_a_bits_data,
  output        auto_out_1_a_bits_corrupt,
  output        auto_out_1_b_ready,
  input         auto_out_1_b_valid,
  input  [1:0]  auto_out_1_b_bits_param,
  input  [31:0] auto_out_1_b_bits_address,
  input         auto_out_1_c_ready,
  output        auto_out_1_c_valid,
  output [2:0]  auto_out_1_c_bits_opcode,
  output [2:0]  auto_out_1_c_bits_param,
  output [3:0]  auto_out_1_c_bits_size,
  output [1:0]  auto_out_1_c_bits_source,
  output [31:0] auto_out_1_c_bits_address,
  output [63:0] auto_out_1_c_bits_data,
  output        auto_out_1_c_bits_corrupt,
  output        auto_out_1_d_ready,
  input         auto_out_1_d_valid,
  input  [2:0]  auto_out_1_d_bits_opcode,
  input  [1:0]  auto_out_1_d_bits_param,
  input  [3:0]  auto_out_1_d_bits_size,
  input  [1:0]  auto_out_1_d_bits_source,
  input  [1:0]  auto_out_1_d_bits_sink,
  input         auto_out_1_d_bits_denied,
  input  [63:0] auto_out_1_d_bits_data,
  input         auto_out_1_d_bits_corrupt,
  output        auto_out_1_e_valid,
  output [1:0]  auto_out_1_e_bits_sink,
  input         auto_out_0_a_ready,
  output        auto_out_0_a_valid,
  output [2:0]  auto_out_0_a_bits_opcode,
  output [2:0]  auto_out_0_a_bits_param,
  output [3:0]  auto_out_0_a_bits_size,
  output [3:0]  auto_out_0_a_bits_source,
  output [31:0] auto_out_0_a_bits_address,
  output        auto_out_0_a_bits_user_amba_prot_bufferable,
  output        auto_out_0_a_bits_user_amba_prot_modifiable,
  output        auto_out_0_a_bits_user_amba_prot_readalloc,
  output        auto_out_0_a_bits_user_amba_prot_writealloc,
  output        auto_out_0_a_bits_user_amba_prot_privileged,
  output        auto_out_0_a_bits_user_amba_prot_secure,
  output        auto_out_0_a_bits_user_amba_prot_fetch,
  output [7:0]  auto_out_0_a_bits_mask,
  output [63:0] auto_out_0_a_bits_data,
  output        auto_out_0_a_bits_corrupt,
  output        auto_out_0_d_ready,
  input         auto_out_0_d_valid,
  input  [2:0]  auto_out_0_d_bits_opcode,
  input  [1:0]  auto_out_0_d_bits_param,
  input  [3:0]  auto_out_0_d_bits_size,
  input  [3:0]  auto_out_0_d_bits_source,
  input  [1:0]  auto_out_0_d_bits_sink,
  input         auto_out_0_d_bits_denied,
  input  [63:0] auto_out_0_d_bits_data,
  input         auto_out_0_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
`endif // RANDOMIZE_REG_INIT
  wire  monitor_clock; // @[Nodes.scala 24:25]
  wire  monitor_reset; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [3:0] monitor_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_clock; // @[Nodes.scala 24:25]
  wire  monitor_1_reset; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_a_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_a_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_a_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_a_bits_address; // @[Nodes.scala 24:25]
  wire [7:0] monitor_1_io_in_a_bits_mask; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_a_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_b_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_b_bits_param; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_b_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_opcode; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_c_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_c_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_c_bits_source; // @[Nodes.scala 24:25]
  wire [31:0] monitor_1_io_in_c_bits_address; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_c_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_ready; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_valid; // @[Nodes.scala 24:25]
  wire [2:0] monitor_1_io_in_d_bits_opcode; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_param; // @[Nodes.scala 24:25]
  wire [3:0] monitor_1_io_in_d_bits_size; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_source; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_d_bits_sink; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_denied; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_d_bits_corrupt; // @[Nodes.scala 24:25]
  wire  monitor_1_io_in_e_valid; // @[Nodes.scala 24:25]
  wire [1:0] monitor_1_io_in_e_bits_sink; // @[Nodes.scala 24:25]
  wire [32:0] _a_notFIFO_T_1 = {1'b0,$signed(auto_in_0_a_bits_address)}; // @[Parameters.scala 137:49]
  wire [31:0] _a_notFIFO_T_5 = auto_in_0_a_bits_address ^ 32'h80000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_notFIFO_T_6 = {1'b0,$signed(_a_notFIFO_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_notFIFO_T_8 = $signed(_a_notFIFO_T_6) & 33'sh80000000; // @[Parameters.scala 137:52]
  wire  a_notFIFO = $signed(_a_notFIFO_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [32:0] _a_id_T_3 = $signed(_a_notFIFO_T_1) & 33'sh70000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_4 = $signed(_a_id_T_3) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _a_id_T_5 = auto_in_0_a_bits_address ^ 32'h10000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_id_T_6 = {1'b0,$signed(_a_id_T_5)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_id_T_8 = $signed(_a_id_T_6) & 33'sh70000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_9 = $signed(_a_id_T_8) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _a_id_T_10 = auto_in_0_a_bits_address ^ 32'h20000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_id_T_11 = {1'b0,$signed(_a_id_T_10)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_id_T_13 = $signed(_a_id_T_11) & 33'sh60000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_14 = $signed(_a_id_T_13) == 33'sh0; // @[Parameters.scala 137:67]
  wire [31:0] _a_id_T_15 = auto_in_0_a_bits_address ^ 32'h40000000; // @[Parameters.scala 137:31]
  wire [32:0] _a_id_T_16 = {1'b0,$signed(_a_id_T_15)}; // @[Parameters.scala 137:49]
  wire [32:0] _a_id_T_18 = $signed(_a_id_T_16) & 33'sh40000000; // @[Parameters.scala 137:52]
  wire  _a_id_T_19 = $signed(_a_id_T_18) == 33'sh0; // @[Parameters.scala 137:67]
  wire  _a_id_T_21 = _a_id_T_9 | _a_id_T_14 | _a_id_T_19; // @[Parameters.scala 615:89]
  wire [1:0] _a_id_T_23 = _a_id_T_21 ? 2'h2 : 2'h0; // @[Mux.scala 27:72]
  wire [1:0] _GEN_86 = {{1'd0}, _a_id_T_4}; // @[Mux.scala 27:72]
  wire [1:0] a_id = _GEN_86 | _a_id_T_23; // @[Mux.scala 27:72]
  wire  a_noDomain = a_id == 2'h0; // @[FIFOFixer.scala 55:29]
  wire  stalls_a_sel = ~auto_in_0_a_bits_source[3]; // @[Parameters.scala 54:32]
  reg [8:0] a_first_counter; // @[Edges.scala 228:27]
  wire  a_first = a_first_counter == 9'h0; // @[Edges.scala 230:25]
  reg  flight__0; // @[FIFOFixer.scala 71:27]
  reg  flight__1; // @[FIFOFixer.scala 71:27]
  reg  flight__2; // @[FIFOFixer.scala 71:27]
  reg  flight__3; // @[FIFOFixer.scala 71:27]
  reg  flight__4; // @[FIFOFixer.scala 71:27]
  reg  flight__5; // @[FIFOFixer.scala 71:27]
  reg  flight__6; // @[FIFOFixer.scala 71:27]
  reg  flight__7; // @[FIFOFixer.scala 71:27]
  reg [1:0] stalls_id; // @[Reg.scala 15:16]
  wire  stalls_0 = stalls_a_sel & a_first & (flight__0 | flight__1 | flight__2 | flight__3 | flight__4 | flight__5 |
    flight__6 | flight__7) & (a_noDomain | stalls_id != a_id); // @[FIFOFixer.scala 80:50]
  reg  flight__8; // @[FIFOFixer.scala 71:27]
  reg  flight__9; // @[FIFOFixer.scala 71:27]
  reg  flight__10; // @[FIFOFixer.scala 71:27]
  reg  flight__11; // @[FIFOFixer.scala 71:27]
  reg  flight__12; // @[FIFOFixer.scala 71:27]
  reg  flight__13; // @[FIFOFixer.scala 71:27]
  reg  flight__14; // @[FIFOFixer.scala 71:27]
  reg  flight__15; // @[FIFOFixer.scala 71:27]
  reg [1:0] stalls_id_1; // @[Reg.scala 15:16]
  wire  stalls_1 = auto_in_0_a_bits_source[3] & a_first & (flight__8 | flight__9 | flight__10 | flight__11 | flight__12
     | flight__13 | flight__14 | flight__15) & (a_noDomain | stalls_id_1 != a_id); // @[FIFOFixer.scala 80:50]
  wire  stall = stalls_0 | stalls_1; // @[FIFOFixer.scala 83:49]
  wire  _data_a_ready_T_1 = a_notFIFO | ~stall; // @[FIFOFixer.scala 88:47]
  wire  auto_data_a_ready = auto_out_0_a_ready & (a_notFIFO | ~stall); // @[FIFOFixer.scala 88:33]
  wire  _a_first_T = auto_data_a_ready & auto_in_0_a_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _a_first_beats1_decode_T_1 = 27'hfff << auto_in_0_a_bits_size; // @[package.scala 234:77]
  wire [11:0] _a_first_beats1_decode_T_3 = ~_a_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] a_first_beats1_decode = _a_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~auto_in_0_a_bits_opcode[2]; // @[Edges.scala 91:28]
  wire [8:0] a_first_counter1 = a_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  _d_first_T = auto_in_0_d_ready & auto_out_0_d_valid; // @[Decoupled.scala 40:37]
  wire [26:0] _d_first_beats1_decode_T_1 = 27'hfff << auto_out_0_d_bits_size; // @[package.scala 234:77]
  wire [11:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[11:0]; // @[package.scala 234:46]
  wire [8:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[11:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = auto_out_0_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [8:0] d_first_counter; // @[Edges.scala 228:27]
  wire [8:0] d_first_counter1 = d_first_counter - 9'h1; // @[Edges.scala 229:28]
  wire  d_first_first = d_first_counter == 9'h0; // @[Edges.scala 230:25]
  wire  d_first = d_first_first & auto_out_0_d_bits_opcode != 3'h6; // @[FIFOFixer.scala 67:42]
  wire  _flight_T = ~a_notFIFO; // @[FIFOFixer.scala 72:67]
  wire  _GEN_2 = 4'h0 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__0; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_3 = 4'h1 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__1; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_4 = 4'h2 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__2; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_5 = 4'h3 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__3; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_6 = 4'h4 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__4; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_7 = 4'h5 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__5; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_8 = 4'h6 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__6; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_9 = 4'h7 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__7; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_10 = 4'h8 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__8; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_11 = 4'h9 == auto_in_0_a_bits_source ? ~a_notFIFO : flight__9; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_12 = 4'ha == auto_in_0_a_bits_source ? ~a_notFIFO : flight__10; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_13 = 4'hb == auto_in_0_a_bits_source ? ~a_notFIFO : flight__11; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_14 = 4'hc == auto_in_0_a_bits_source ? ~a_notFIFO : flight__12; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_15 = 4'hd == auto_in_0_a_bits_source ? ~a_notFIFO : flight__13; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_16 = 4'he == auto_in_0_a_bits_source ? ~a_notFIFO : flight__14; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_17 = 4'hf == auto_in_0_a_bits_source ? ~a_notFIFO : flight__15; // @[FIFOFixer.scala 72:64 FIFOFixer.scala 72:64 FIFOFixer.scala 71:27]
  wire  _GEN_18 = a_first & _a_first_T ? _GEN_2 : flight__0; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_19 = a_first & _a_first_T ? _GEN_3 : flight__1; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_20 = a_first & _a_first_T ? _GEN_4 : flight__2; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_21 = a_first & _a_first_T ? _GEN_5 : flight__3; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_22 = a_first & _a_first_T ? _GEN_6 : flight__4; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_23 = a_first & _a_first_T ? _GEN_7 : flight__5; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_24 = a_first & _a_first_T ? _GEN_8 : flight__6; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_25 = a_first & _a_first_T ? _GEN_9 : flight__7; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_26 = a_first & _a_first_T ? _GEN_10 : flight__8; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_27 = a_first & _a_first_T ? _GEN_11 : flight__9; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_28 = a_first & _a_first_T ? _GEN_12 : flight__10; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_29 = a_first & _a_first_T ? _GEN_13 : flight__11; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_30 = a_first & _a_first_T ? _GEN_14 : flight__12; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_31 = a_first & _a_first_T ? _GEN_15 : flight__13; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_32 = a_first & _a_first_T ? _GEN_16 : flight__14; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _GEN_33 = a_first & _a_first_T ? _GEN_17 : flight__15; // @[FIFOFixer.scala 72:37 FIFOFixer.scala 71:27]
  wire  _stalls_id_T_3 = _a_first_T & stalls_a_sel & _flight_T; // @[FIFOFixer.scala 77:58]
  wire  _stalls_id_T_7 = _a_first_T & auto_in_0_a_bits_source[3] & _flight_T; // @[FIFOFixer.scala 77:58]
  TLMonitor_2 monitor ( // @[Nodes.scala 24:25]
    .clock(monitor_clock),
    .reset(monitor_reset),
    .io_in_a_ready(monitor_io_in_a_ready),
    .io_in_a_valid(monitor_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_io_in_a_bits_corrupt),
    .io_in_d_ready(monitor_io_in_d_ready),
    .io_in_d_valid(monitor_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_io_in_d_bits_corrupt)
  );
  TLMonitor_3 monitor_1 ( // @[Nodes.scala 24:25]
    .clock(monitor_1_clock),
    .reset(monitor_1_reset),
    .io_in_a_ready(monitor_1_io_in_a_ready),
    .io_in_a_valid(monitor_1_io_in_a_valid),
    .io_in_a_bits_opcode(monitor_1_io_in_a_bits_opcode),
    .io_in_a_bits_param(monitor_1_io_in_a_bits_param),
    .io_in_a_bits_size(monitor_1_io_in_a_bits_size),
    .io_in_a_bits_source(monitor_1_io_in_a_bits_source),
    .io_in_a_bits_address(monitor_1_io_in_a_bits_address),
    .io_in_a_bits_mask(monitor_1_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(monitor_1_io_in_a_bits_corrupt),
    .io_in_b_ready(monitor_1_io_in_b_ready),
    .io_in_b_valid(monitor_1_io_in_b_valid),
    .io_in_b_bits_param(monitor_1_io_in_b_bits_param),
    .io_in_b_bits_address(monitor_1_io_in_b_bits_address),
    .io_in_c_ready(monitor_1_io_in_c_ready),
    .io_in_c_valid(monitor_1_io_in_c_valid),
    .io_in_c_bits_opcode(monitor_1_io_in_c_bits_opcode),
    .io_in_c_bits_param(monitor_1_io_in_c_bits_param),
    .io_in_c_bits_size(monitor_1_io_in_c_bits_size),
    .io_in_c_bits_source(monitor_1_io_in_c_bits_source),
    .io_in_c_bits_address(monitor_1_io_in_c_bits_address),
    .io_in_c_bits_corrupt(monitor_1_io_in_c_bits_corrupt),
    .io_in_d_ready(monitor_1_io_in_d_ready),
    .io_in_d_valid(monitor_1_io_in_d_valid),
    .io_in_d_bits_opcode(monitor_1_io_in_d_bits_opcode),
    .io_in_d_bits_param(monitor_1_io_in_d_bits_param),
    .io_in_d_bits_size(monitor_1_io_in_d_bits_size),
    .io_in_d_bits_source(monitor_1_io_in_d_bits_source),
    .io_in_d_bits_sink(monitor_1_io_in_d_bits_sink),
    .io_in_d_bits_denied(monitor_1_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(monitor_1_io_in_d_bits_corrupt),
    .io_in_e_valid(monitor_1_io_in_e_valid),
    .io_in_e_bits_sink(monitor_1_io_in_e_bits_sink)
  );
  assign auto_in_1_a_ready = auto_out_1_a_ready; // @[FIFOFixer.scala 88:33]
  assign auto_in_1_b_valid = auto_out_1_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_c_ready = auto_out_1_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_valid = auto_out_1_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_opcode = auto_out_1_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_param = auto_out_1_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_size = auto_out_1_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_source = auto_out_1_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_sink = auto_out_1_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_denied = auto_out_1_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_data = auto_out_1_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_1_d_bits_corrupt = auto_out_1_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_a_ready = auto_out_0_a_ready & (a_notFIFO | ~stall); // @[FIFOFixer.scala 88:33]
  assign auto_in_0_d_valid = auto_out_0_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_opcode = auto_out_0_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_param = auto_out_0_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_size = auto_out_0_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_source = auto_out_0_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_sink = auto_out_0_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_denied = auto_out_0_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_data = auto_out_0_d_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_0_d_bits_corrupt = auto_out_0_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_out_1_a_valid = auto_in_1_a_valid; // @[FIFOFixer.scala 87:33]
  assign auto_out_1_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_bufferable = auto_in_1_a_bits_user_amba_prot_bufferable; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_modifiable = auto_in_1_a_bits_user_amba_prot_modifiable; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_readalloc = auto_in_1_a_bits_user_amba_prot_readalloc; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_writealloc = auto_in_1_a_bits_user_amba_prot_writealloc; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_privileged = auto_in_1_a_bits_user_amba_prot_privileged; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_secure = auto_in_1_a_bits_user_amba_prot_secure; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_user_amba_prot_fetch = auto_in_1_a_bits_user_amba_prot_fetch; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_data = auto_in_1_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_b_ready = auto_in_1_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_valid = auto_in_1_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_data = auto_in_1_c_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_d_ready = auto_in_1_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_e_valid = auto_in_1_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_1_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_valid = auto_in_0_a_valid & _data_a_ready_T_1; // @[FIFOFixer.scala 87:33]
  assign auto_out_0_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_bufferable = auto_in_0_a_bits_user_amba_prot_bufferable; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_modifiable = auto_in_0_a_bits_user_amba_prot_modifiable; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_readalloc = auto_in_0_a_bits_user_amba_prot_readalloc; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_writealloc = auto_in_0_a_bits_user_amba_prot_writealloc; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_privileged = auto_in_0_a_bits_user_amba_prot_privileged; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_secure = auto_in_0_a_bits_user_amba_prot_secure; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_user_amba_prot_fetch = auto_in_0_a_bits_user_amba_prot_fetch; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_data = auto_in_0_a_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_0_d_ready = auto_in_0_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_clock = clock;
  assign monitor_reset = reset;
  assign monitor_io_in_a_ready = auto_out_0_a_ready & (a_notFIFO | ~stall); // @[FIFOFixer.scala 88:33]
  assign monitor_io_in_a_valid = auto_in_0_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_ready = auto_in_0_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_io_in_d_valid = auto_out_0_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_opcode = auto_out_0_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_param = auto_out_0_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_size = auto_out_0_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_source = auto_out_0_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_sink = auto_out_0_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_denied = auto_out_0_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_io_in_d_bits_corrupt = auto_out_0_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_clock = clock;
  assign monitor_1_reset = reset;
  assign monitor_1_io_in_a_ready = auto_out_1_a_ready; // @[FIFOFixer.scala 88:33]
  assign monitor_1_io_in_a_valid = auto_in_1_a_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_ready = auto_in_1_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_b_valid = auto_out_1_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_c_ready = auto_out_1_c_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_c_valid = auto_in_1_c_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_ready = auto_in_1_d_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_d_valid = auto_out_1_d_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_opcode = auto_out_1_d_bits_opcode; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_param = auto_out_1_d_bits_param; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_size = auto_out_1_d_bits_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_source = auto_out_1_d_bits_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_sink = auto_out_1_d_bits_sink; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_denied = auto_out_1_d_bits_denied; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_d_bits_corrupt = auto_out_1_d_bits_corrupt; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign monitor_1_io_in_e_valid = auto_in_1_e_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign monitor_1_io_in_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 9'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__0 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h0 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__0 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__0 <= _GEN_18;
      end
    end else begin
      flight__0 <= _GEN_18;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__1 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h1 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__1 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__1 <= _GEN_19;
      end
    end else begin
      flight__1 <= _GEN_19;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__2 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h2 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__2 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__2 <= _GEN_20;
      end
    end else begin
      flight__2 <= _GEN_20;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__3 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h3 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__3 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__3 <= _GEN_21;
      end
    end else begin
      flight__3 <= _GEN_21;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__4 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h4 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__4 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__4 <= _GEN_22;
      end
    end else begin
      flight__4 <= _GEN_22;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__5 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h5 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__5 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__5 <= _GEN_23;
      end
    end else begin
      flight__5 <= _GEN_23;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__6 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h6 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__6 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__6 <= _GEN_24;
      end
    end else begin
      flight__6 <= _GEN_24;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__7 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h7 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__7 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__7 <= _GEN_25;
      end
    end else begin
      flight__7 <= _GEN_25;
    end
    if (_stalls_id_T_3) begin // @[Reg.scala 16:19]
      stalls_id <= a_id; // @[Reg.scala 16:23]
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__8 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h8 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__8 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__8 <= _GEN_26;
      end
    end else begin
      flight__8 <= _GEN_26;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__9 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'h9 == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__9 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__9 <= _GEN_27;
      end
    end else begin
      flight__9 <= _GEN_27;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__10 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'ha == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__10 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__10 <= _GEN_28;
      end
    end else begin
      flight__10 <= _GEN_28;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__11 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hb == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__11 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__11 <= _GEN_29;
      end
    end else begin
      flight__11 <= _GEN_29;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__12 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hc == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__12 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__12 <= _GEN_30;
      end
    end else begin
      flight__12 <= _GEN_30;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__13 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hd == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__13 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__13 <= _GEN_31;
      end
    end else begin
      flight__13 <= _GEN_31;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__14 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'he == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__14 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__14 <= _GEN_32;
      end
    end else begin
      flight__14 <= _GEN_32;
    end
    if (reset) begin // @[FIFOFixer.scala 71:27]
      flight__15 <= 1'h0; // @[FIFOFixer.scala 71:27]
    end else if (d_first & _d_first_T) begin // @[FIFOFixer.scala 73:37]
      if (4'hf == auto_out_0_d_bits_source) begin // @[FIFOFixer.scala 73:64]
        flight__15 <= 1'h0; // @[FIFOFixer.scala 73:64]
      end else begin
        flight__15 <= _GEN_33;
      end
    end else begin
      flight__15 <= _GEN_33;
    end
    if (_stalls_id_T_7) begin // @[Reg.scala 16:19]
      stalls_id_1 <= a_id; // @[Reg.scala 16:23]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 9'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 9'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  flight__0 = _RAND_1[0:0];
  _RAND_2 = {1{`RANDOM}};
  flight__1 = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  flight__2 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  flight__3 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  flight__4 = _RAND_5[0:0];
  _RAND_6 = {1{`RANDOM}};
  flight__5 = _RAND_6[0:0];
  _RAND_7 = {1{`RANDOM}};
  flight__6 = _RAND_7[0:0];
  _RAND_8 = {1{`RANDOM}};
  flight__7 = _RAND_8[0:0];
  _RAND_9 = {1{`RANDOM}};
  stalls_id = _RAND_9[1:0];
  _RAND_10 = {1{`RANDOM}};
  flight__8 = _RAND_10[0:0];
  _RAND_11 = {1{`RANDOM}};
  flight__9 = _RAND_11[0:0];
  _RAND_12 = {1{`RANDOM}};
  flight__10 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  flight__11 = _RAND_13[0:0];
  _RAND_14 = {1{`RANDOM}};
  flight__12 = _RAND_14[0:0];
  _RAND_15 = {1{`RANDOM}};
  flight__13 = _RAND_15[0:0];
  _RAND_16 = {1{`RANDOM}};
  flight__14 = _RAND_16[0:0];
  _RAND_17 = {1{`RANDOM}};
  flight__15 = _RAND_17[0:0];
  _RAND_18 = {1{`RANDOM}};
  stalls_id_1 = _RAND_18[1:0];
  _RAND_19 = {1{`RANDOM}};
  d_first_counter = _RAND_19[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module Queue(
  input         clock,
  input         reset,
  output        io_enq_ready,
  input         io_enq_valid,
  input  [3:0]  io_enq_bits_id,
  input  [30:0] io_enq_bits_addr,
  input  [7:0]  io_enq_bits_len,
  input  [2:0]  io_enq_bits_size,
  input  [1:0]  io_enq_bits_burst,
  input         io_enq_bits_lock,
  input  [3:0]  io_enq_bits_cache,
  input  [2:0]  io_enq_bits_prot,
  input  [3:0]  io_enq_bits_qos,
  input         io_deq_ready,
  output        io_deq_valid,
  output [3:0]  io_deq_bits_id,
  output [30:0] io_deq_bits_addr,
  output [7:0]  io_deq_bits_len,
  output [2:0]  io_deq_bits_size,
  output [1:0]  io_deq_bits_burst,
  output        io_deq_bits_lock,
  output [3:0]  io_deq_bits_cache,
  output [2:0]  io_deq_bits_prot,
  output [3:0]  io_deq_bits_qos
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
`endif // RANDOMIZE_REG_INIT
  reg [3:0] ram_id [0:1]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_en; // @[Decoupled.scala 218:16]
  reg [30:0] ram_addr [0:1]; // @[Decoupled.scala 218:16]
  wire [30:0] ram_addr_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_addr_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [30:0] ram_addr_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_addr_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_addr_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_addr_MPORT_en; // @[Decoupled.scala 218:16]
  reg [7:0] ram_len [0:1]; // @[Decoupled.scala 218:16]
  wire [7:0] ram_len_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_len_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [7:0] ram_len_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_len_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_len_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_len_MPORT_en; // @[Decoupled.scala 218:16]
  reg [2:0] ram_size [0:1]; // @[Decoupled.scala 218:16]
  wire [2:0] ram_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_size_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [2:0] ram_size_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_size_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_size_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_size_MPORT_en; // @[Decoupled.scala 218:16]
  reg [1:0] ram_burst [0:1]; // @[Decoupled.scala 218:16]
  wire [1:0] ram_burst_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_burst_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [1:0] ram_burst_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_burst_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_burst_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_burst_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_lock [0:1]; // @[Decoupled.scala 218:16]
  wire  ram_lock_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_lock_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_en; // @[Decoupled.scala 218:16]
  reg [3:0] ram_cache [0:1]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_cache_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_cache_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_cache_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_cache_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_cache_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_cache_MPORT_en; // @[Decoupled.scala 218:16]
  reg [2:0] ram_prot [0:1]; // @[Decoupled.scala 218:16]
  wire [2:0] ram_prot_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_prot_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [2:0] ram_prot_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_prot_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_prot_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_prot_MPORT_en; // @[Decoupled.scala 218:16]
  reg [3:0] ram_qos [0:1]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_qos_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_qos_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_qos_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_qos_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_qos_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_qos_MPORT_en; // @[Decoupled.scala 218:16]
  reg  value; // @[Counter.scala 60:40]
  reg  value_1; // @[Counter.scala 60:40]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  ptr_match = value == value_1; // @[Decoupled.scala 223:33]
  wire  empty = ptr_match & ~maybe_full; // @[Decoupled.scala 224:25]
  wire  full = ptr_match & maybe_full; // @[Decoupled.scala 225:24]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  assign ram_id_io_deq_bits_MPORT_addr = value_1;
  assign ram_id_io_deq_bits_MPORT_data = ram_id[ram_id_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_id_MPORT_data = io_enq_bits_id;
  assign ram_id_MPORT_addr = value;
  assign ram_id_MPORT_mask = 1'h1;
  assign ram_id_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_addr_io_deq_bits_MPORT_addr = value_1;
  assign ram_addr_io_deq_bits_MPORT_data = ram_addr[ram_addr_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_addr_MPORT_data = io_enq_bits_addr;
  assign ram_addr_MPORT_addr = value;
  assign ram_addr_MPORT_mask = 1'h1;
  assign ram_addr_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_len_io_deq_bits_MPORT_addr = value_1;
  assign ram_len_io_deq_bits_MPORT_data = ram_len[ram_len_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_len_MPORT_data = io_enq_bits_len;
  assign ram_len_MPORT_addr = value;
  assign ram_len_MPORT_mask = 1'h1;
  assign ram_len_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_size_io_deq_bits_MPORT_addr = value_1;
  assign ram_size_io_deq_bits_MPORT_data = ram_size[ram_size_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_size_MPORT_data = io_enq_bits_size;
  assign ram_size_MPORT_addr = value;
  assign ram_size_MPORT_mask = 1'h1;
  assign ram_size_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_burst_io_deq_bits_MPORT_addr = value_1;
  assign ram_burst_io_deq_bits_MPORT_data = ram_burst[ram_burst_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_burst_MPORT_data = io_enq_bits_burst;
  assign ram_burst_MPORT_addr = value;
  assign ram_burst_MPORT_mask = 1'h1;
  assign ram_burst_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_lock_io_deq_bits_MPORT_addr = value_1;
  assign ram_lock_io_deq_bits_MPORT_data = ram_lock[ram_lock_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_lock_MPORT_data = io_enq_bits_lock;
  assign ram_lock_MPORT_addr = value;
  assign ram_lock_MPORT_mask = 1'h1;
  assign ram_lock_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_cache_io_deq_bits_MPORT_addr = value_1;
  assign ram_cache_io_deq_bits_MPORT_data = ram_cache[ram_cache_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_cache_MPORT_data = io_enq_bits_cache;
  assign ram_cache_MPORT_addr = value;
  assign ram_cache_MPORT_mask = 1'h1;
  assign ram_cache_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_prot_io_deq_bits_MPORT_addr = value_1;
  assign ram_prot_io_deq_bits_MPORT_data = ram_prot[ram_prot_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_prot_MPORT_data = io_enq_bits_prot;
  assign ram_prot_MPORT_addr = value;
  assign ram_prot_MPORT_mask = 1'h1;
  assign ram_prot_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_qos_io_deq_bits_MPORT_addr = value_1;
  assign ram_qos_io_deq_bits_MPORT_data = ram_qos[ram_qos_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_qos_MPORT_data = io_enq_bits_qos;
  assign ram_qos_MPORT_addr = value;
  assign ram_qos_MPORT_mask = 1'h1;
  assign ram_qos_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_id = ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_addr = ram_addr_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_len = ram_len_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_size = ram_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_burst = ram_burst_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_lock = ram_lock_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_cache = ram_cache_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_prot = ram_prot_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_qos = ram_qos_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_id_MPORT_en & ram_id_MPORT_mask) begin
      ram_id[ram_id_MPORT_addr] <= ram_id_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_addr_MPORT_en & ram_addr_MPORT_mask) begin
      ram_addr[ram_addr_MPORT_addr] <= ram_addr_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_len_MPORT_en & ram_len_MPORT_mask) begin
      ram_len[ram_len_MPORT_addr] <= ram_len_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_size_MPORT_en & ram_size_MPORT_mask) begin
      ram_size[ram_size_MPORT_addr] <= ram_size_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_burst_MPORT_en & ram_burst_MPORT_mask) begin
      ram_burst[ram_burst_MPORT_addr] <= ram_burst_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_lock_MPORT_en & ram_lock_MPORT_mask) begin
      ram_lock[ram_lock_MPORT_addr] <= ram_lock_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_cache_MPORT_en & ram_cache_MPORT_mask) begin
      ram_cache[ram_cache_MPORT_addr] <= ram_cache_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_prot_MPORT_en & ram_prot_MPORT_mask) begin
      ram_prot[ram_prot_MPORT_addr] <= ram_prot_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_qos_MPORT_en & ram_qos_MPORT_mask) begin
      ram_qos[ram_qos_MPORT_addr] <= ram_qos_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_enq) begin // @[Decoupled.scala 229:17]
      value <= value + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value_1 <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_deq) begin // @[Decoupled.scala 233:17]
      value_1 <= value_1 + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_id[initvar] = _RAND_0[3:0];
  _RAND_1 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_addr[initvar] = _RAND_1[30:0];
  _RAND_2 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_len[initvar] = _RAND_2[7:0];
  _RAND_3 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_size[initvar] = _RAND_3[2:0];
  _RAND_4 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_burst[initvar] = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_lock[initvar] = _RAND_5[0:0];
  _RAND_6 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_cache[initvar] = _RAND_6[3:0];
  _RAND_7 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_prot[initvar] = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_qos[initvar] = _RAND_8[3:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_9 = {1{`RANDOM}};
  value = _RAND_9[0:0];
  _RAND_10 = {1{`RANDOM}};
  value_1 = _RAND_10[0:0];
  _RAND_11 = {1{`RANDOM}};
  maybe_full = _RAND_11[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module Queue_1(
  input         clock,
  input         reset,
  output        io_enq_ready,
  input         io_enq_valid,
  input  [63:0] io_enq_bits_data,
  input  [7:0]  io_enq_bits_strb,
  input         io_enq_bits_last,
  input         io_deq_ready,
  output        io_deq_valid,
  output [63:0] io_deq_bits_data,
  output [7:0]  io_deq_bits_strb,
  output        io_deq_bits_last
);
`ifdef RANDOMIZE_MEM_INIT
  reg [63:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
`endif // RANDOMIZE_REG_INIT
  reg [63:0] ram_data [0:1]; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_data_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_en; // @[Decoupled.scala 218:16]
  reg [7:0] ram_strb [0:1]; // @[Decoupled.scala 218:16]
  wire [7:0] ram_strb_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_strb_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [7:0] ram_strb_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_strb_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_strb_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_strb_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_last [0:1]; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_en; // @[Decoupled.scala 218:16]
  reg  value; // @[Counter.scala 60:40]
  reg  value_1; // @[Counter.scala 60:40]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  ptr_match = value == value_1; // @[Decoupled.scala 223:33]
  wire  empty = ptr_match & ~maybe_full; // @[Decoupled.scala 224:25]
  wire  full = ptr_match & maybe_full; // @[Decoupled.scala 225:24]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  assign ram_data_io_deq_bits_MPORT_addr = value_1;
  assign ram_data_io_deq_bits_MPORT_data = ram_data[ram_data_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_data_MPORT_data = io_enq_bits_data;
  assign ram_data_MPORT_addr = value;
  assign ram_data_MPORT_mask = 1'h1;
  assign ram_data_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_strb_io_deq_bits_MPORT_addr = value_1;
  assign ram_strb_io_deq_bits_MPORT_data = ram_strb[ram_strb_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_strb_MPORT_data = io_enq_bits_strb;
  assign ram_strb_MPORT_addr = value;
  assign ram_strb_MPORT_mask = 1'h1;
  assign ram_strb_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_last_io_deq_bits_MPORT_addr = value_1;
  assign ram_last_io_deq_bits_MPORT_data = ram_last[ram_last_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_last_MPORT_data = io_enq_bits_last;
  assign ram_last_MPORT_addr = value;
  assign ram_last_MPORT_mask = 1'h1;
  assign ram_last_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_data = ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_strb = ram_strb_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_last = ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_data_MPORT_en & ram_data_MPORT_mask) begin
      ram_data[ram_data_MPORT_addr] <= ram_data_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_strb_MPORT_en & ram_strb_MPORT_mask) begin
      ram_strb[ram_strb_MPORT_addr] <= ram_strb_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_last_MPORT_en & ram_last_MPORT_mask) begin
      ram_last[ram_last_MPORT_addr] <= ram_last_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_enq) begin // @[Decoupled.scala 229:17]
      value <= value + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value_1 <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_deq) begin // @[Decoupled.scala 233:17]
      value_1 <= value_1 + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {2{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_data[initvar] = _RAND_0[63:0];
  _RAND_1 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_strb[initvar] = _RAND_1[7:0];
  _RAND_2 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_last[initvar] = _RAND_2[0:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_3 = {1{`RANDOM}};
  value = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  value_1 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  maybe_full = _RAND_5[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module Queue_2(
  input        clock,
  input        reset,
  output       io_enq_ready,
  input        io_enq_valid,
  input  [3:0] io_enq_bits_id,
  input  [1:0] io_enq_bits_resp,
  input        io_deq_ready,
  output       io_deq_valid,
  output [3:0] io_deq_bits_id,
  output [1:0] io_deq_bits_resp
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
`endif // RANDOMIZE_REG_INIT
  reg [3:0] ram_id [0:1]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_en; // @[Decoupled.scala 218:16]
  reg [1:0] ram_resp [0:1]; // @[Decoupled.scala 218:16]
  wire [1:0] ram_resp_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_resp_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [1:0] ram_resp_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_en; // @[Decoupled.scala 218:16]
  reg  value; // @[Counter.scala 60:40]
  reg  value_1; // @[Counter.scala 60:40]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  ptr_match = value == value_1; // @[Decoupled.scala 223:33]
  wire  empty = ptr_match & ~maybe_full; // @[Decoupled.scala 224:25]
  wire  full = ptr_match & maybe_full; // @[Decoupled.scala 225:24]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  assign ram_id_io_deq_bits_MPORT_addr = value_1;
  assign ram_id_io_deq_bits_MPORT_data = ram_id[ram_id_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_id_MPORT_data = io_enq_bits_id;
  assign ram_id_MPORT_addr = value;
  assign ram_id_MPORT_mask = 1'h1;
  assign ram_id_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_resp_io_deq_bits_MPORT_addr = value_1;
  assign ram_resp_io_deq_bits_MPORT_data = ram_resp[ram_resp_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_resp_MPORT_data = io_enq_bits_resp;
  assign ram_resp_MPORT_addr = value;
  assign ram_resp_MPORT_mask = 1'h1;
  assign ram_resp_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_id = ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_resp = ram_resp_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_id_MPORT_en & ram_id_MPORT_mask) begin
      ram_id[ram_id_MPORT_addr] <= ram_id_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_resp_MPORT_en & ram_resp_MPORT_mask) begin
      ram_resp[ram_resp_MPORT_addr] <= ram_resp_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_enq) begin // @[Decoupled.scala 229:17]
      value <= value + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value_1 <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_deq) begin // @[Decoupled.scala 233:17]
      value_1 <= value_1 + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_id[initvar] = _RAND_0[3:0];
  _RAND_1 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_resp[initvar] = _RAND_1[1:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_2 = {1{`RANDOM}};
  value = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  value_1 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  maybe_full = _RAND_4[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module Queue_4(
  input         clock,
  input         reset,
  output        io_enq_ready,
  input         io_enq_valid,
  input  [3:0]  io_enq_bits_id,
  input  [63:0] io_enq_bits_data,
  input  [1:0]  io_enq_bits_resp,
  input         io_enq_bits_last,
  input         io_deq_ready,
  output        io_deq_valid,
  output [3:0]  io_deq_bits_id,
  output [63:0] io_deq_bits_data,
  output [1:0]  io_deq_bits_resp,
  output        io_deq_bits_last
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [63:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
`endif // RANDOMIZE_REG_INIT
  reg [3:0] ram_id [0:1]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_en; // @[Decoupled.scala 218:16]
  reg [63:0] ram_data [0:1]; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_data_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_en; // @[Decoupled.scala 218:16]
  reg [1:0] ram_resp [0:1]; // @[Decoupled.scala 218:16]
  wire [1:0] ram_resp_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_resp_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [1:0] ram_resp_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_last [0:1]; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_en; // @[Decoupled.scala 218:16]
  reg  value; // @[Counter.scala 60:40]
  reg  value_1; // @[Counter.scala 60:40]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  ptr_match = value == value_1; // @[Decoupled.scala 223:33]
  wire  empty = ptr_match & ~maybe_full; // @[Decoupled.scala 224:25]
  wire  full = ptr_match & maybe_full; // @[Decoupled.scala 225:24]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  assign ram_id_io_deq_bits_MPORT_addr = value_1;
  assign ram_id_io_deq_bits_MPORT_data = ram_id[ram_id_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_id_MPORT_data = io_enq_bits_id;
  assign ram_id_MPORT_addr = value;
  assign ram_id_MPORT_mask = 1'h1;
  assign ram_id_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_data_io_deq_bits_MPORT_addr = value_1;
  assign ram_data_io_deq_bits_MPORT_data = ram_data[ram_data_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_data_MPORT_data = io_enq_bits_data;
  assign ram_data_MPORT_addr = value;
  assign ram_data_MPORT_mask = 1'h1;
  assign ram_data_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_resp_io_deq_bits_MPORT_addr = value_1;
  assign ram_resp_io_deq_bits_MPORT_data = ram_resp[ram_resp_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_resp_MPORT_data = io_enq_bits_resp;
  assign ram_resp_MPORT_addr = value;
  assign ram_resp_MPORT_mask = 1'h1;
  assign ram_resp_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_last_io_deq_bits_MPORT_addr = value_1;
  assign ram_last_io_deq_bits_MPORT_data = ram_last[ram_last_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_last_MPORT_data = io_enq_bits_last;
  assign ram_last_MPORT_addr = value;
  assign ram_last_MPORT_mask = 1'h1;
  assign ram_last_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_id = ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_data = ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_resp = ram_resp_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_last = ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_id_MPORT_en & ram_id_MPORT_mask) begin
      ram_id[ram_id_MPORT_addr] <= ram_id_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_data_MPORT_en & ram_data_MPORT_mask) begin
      ram_data[ram_data_MPORT_addr] <= ram_data_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_resp_MPORT_en & ram_resp_MPORT_mask) begin
      ram_resp[ram_resp_MPORT_addr] <= ram_resp_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_last_MPORT_en & ram_last_MPORT_mask) begin
      ram_last[ram_last_MPORT_addr] <= ram_last_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_enq) begin // @[Decoupled.scala 229:17]
      value <= value + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Counter.scala 60:40]
      value_1 <= 1'h0; // @[Counter.scala 60:40]
    end else if (do_deq) begin // @[Decoupled.scala 233:17]
      value_1 <= value_1 + 1'h1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_id[initvar] = _RAND_0[3:0];
  _RAND_1 = {2{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_data[initvar] = _RAND_1[63:0];
  _RAND_2 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_resp[initvar] = _RAND_2[1:0];
  _RAND_3 = {1{`RANDOM}};
  for (initvar = 0; initvar < 2; initvar = initvar+1)
    ram_last[initvar] = _RAND_3[0:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_4 = {1{`RANDOM}};
  value = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  value_1 = _RAND_5[0:0];
  _RAND_6 = {1{`RANDOM}};
  maybe_full = _RAND_6[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module AXI4Buffer(
  input         clock,
  input         reset,
  output        auto_in_aw_ready,
  input         auto_in_aw_valid,
  input  [3:0]  auto_in_aw_bits_id,
  input  [30:0] auto_in_aw_bits_addr,
  input  [7:0]  auto_in_aw_bits_len,
  input  [2:0]  auto_in_aw_bits_size,
  input  [1:0]  auto_in_aw_bits_burst,
  input         auto_in_aw_bits_lock,
  input  [3:0]  auto_in_aw_bits_cache,
  input  [2:0]  auto_in_aw_bits_prot,
  input  [3:0]  auto_in_aw_bits_qos,
  output        auto_in_w_ready,
  input         auto_in_w_valid,
  input  [63:0] auto_in_w_bits_data,
  input  [7:0]  auto_in_w_bits_strb,
  input         auto_in_w_bits_last,
  input         auto_in_b_ready,
  output        auto_in_b_valid,
  output [3:0]  auto_in_b_bits_id,
  output [1:0]  auto_in_b_bits_resp,
  output        auto_in_ar_ready,
  input         auto_in_ar_valid,
  input  [3:0]  auto_in_ar_bits_id,
  input  [30:0] auto_in_ar_bits_addr,
  input  [7:0]  auto_in_ar_bits_len,
  input  [2:0]  auto_in_ar_bits_size,
  input  [1:0]  auto_in_ar_bits_burst,
  input         auto_in_ar_bits_lock,
  input  [3:0]  auto_in_ar_bits_cache,
  input  [2:0]  auto_in_ar_bits_prot,
  input  [3:0]  auto_in_ar_bits_qos,
  input         auto_in_r_ready,
  output        auto_in_r_valid,
  output [3:0]  auto_in_r_bits_id,
  output [63:0] auto_in_r_bits_data,
  output [1:0]  auto_in_r_bits_resp,
  output        auto_in_r_bits_last,
  input         auto_out_aw_ready,
  output        auto_out_aw_valid,
  output [3:0]  auto_out_aw_bits_id,
  output [30:0] auto_out_aw_bits_addr,
  output [7:0]  auto_out_aw_bits_len,
  output [2:0]  auto_out_aw_bits_size,
  output [1:0]  auto_out_aw_bits_burst,
  output        auto_out_aw_bits_lock,
  output [3:0]  auto_out_aw_bits_cache,
  output [2:0]  auto_out_aw_bits_prot,
  output [3:0]  auto_out_aw_bits_qos,
  input         auto_out_w_ready,
  output        auto_out_w_valid,
  output [63:0] auto_out_w_bits_data,
  output [7:0]  auto_out_w_bits_strb,
  output        auto_out_w_bits_last,
  output        auto_out_b_ready,
  input         auto_out_b_valid,
  input  [3:0]  auto_out_b_bits_id,
  input  [1:0]  auto_out_b_bits_resp,
  input         auto_out_ar_ready,
  output        auto_out_ar_valid,
  output [3:0]  auto_out_ar_bits_id,
  output [30:0] auto_out_ar_bits_addr,
  output [7:0]  auto_out_ar_bits_len,
  output [2:0]  auto_out_ar_bits_size,
  output [1:0]  auto_out_ar_bits_burst,
  output        auto_out_ar_bits_lock,
  output [3:0]  auto_out_ar_bits_cache,
  output [2:0]  auto_out_ar_bits_prot,
  output [3:0]  auto_out_ar_bits_qos,
  output        auto_out_r_ready,
  input         auto_out_r_valid,
  input  [3:0]  auto_out_r_bits_id,
  input  [63:0] auto_out_r_bits_data,
  input  [1:0]  auto_out_r_bits_resp,
  input         auto_out_r_bits_last
);
  wire  data_aw_deq_clock; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_reset; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_io_enq_ready; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_io_enq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_aw_deq_io_enq_bits_id; // @[Decoupled.scala 296:21]
  wire [30:0] data_aw_deq_io_enq_bits_addr; // @[Decoupled.scala 296:21]
  wire [7:0] data_aw_deq_io_enq_bits_len; // @[Decoupled.scala 296:21]
  wire [2:0] data_aw_deq_io_enq_bits_size; // @[Decoupled.scala 296:21]
  wire [1:0] data_aw_deq_io_enq_bits_burst; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_io_enq_bits_lock; // @[Decoupled.scala 296:21]
  wire [3:0] data_aw_deq_io_enq_bits_cache; // @[Decoupled.scala 296:21]
  wire [2:0] data_aw_deq_io_enq_bits_prot; // @[Decoupled.scala 296:21]
  wire [3:0] data_aw_deq_io_enq_bits_qos; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_io_deq_ready; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_io_deq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_aw_deq_io_deq_bits_id; // @[Decoupled.scala 296:21]
  wire [30:0] data_aw_deq_io_deq_bits_addr; // @[Decoupled.scala 296:21]
  wire [7:0] data_aw_deq_io_deq_bits_len; // @[Decoupled.scala 296:21]
  wire [2:0] data_aw_deq_io_deq_bits_size; // @[Decoupled.scala 296:21]
  wire [1:0] data_aw_deq_io_deq_bits_burst; // @[Decoupled.scala 296:21]
  wire  data_aw_deq_io_deq_bits_lock; // @[Decoupled.scala 296:21]
  wire [3:0] data_aw_deq_io_deq_bits_cache; // @[Decoupled.scala 296:21]
  wire [2:0] data_aw_deq_io_deq_bits_prot; // @[Decoupled.scala 296:21]
  wire [3:0] data_aw_deq_io_deq_bits_qos; // @[Decoupled.scala 296:21]
  wire  data_w_deq_clock; // @[Decoupled.scala 296:21]
  wire  data_w_deq_reset; // @[Decoupled.scala 296:21]
  wire  data_w_deq_io_enq_ready; // @[Decoupled.scala 296:21]
  wire  data_w_deq_io_enq_valid; // @[Decoupled.scala 296:21]
  wire [63:0] data_w_deq_io_enq_bits_data; // @[Decoupled.scala 296:21]
  wire [7:0] data_w_deq_io_enq_bits_strb; // @[Decoupled.scala 296:21]
  wire  data_w_deq_io_enq_bits_last; // @[Decoupled.scala 296:21]
  wire  data_w_deq_io_deq_ready; // @[Decoupled.scala 296:21]
  wire  data_w_deq_io_deq_valid; // @[Decoupled.scala 296:21]
  wire [63:0] data_w_deq_io_deq_bits_data; // @[Decoupled.scala 296:21]
  wire [7:0] data_w_deq_io_deq_bits_strb; // @[Decoupled.scala 296:21]
  wire  data_w_deq_io_deq_bits_last; // @[Decoupled.scala 296:21]
  wire  data_b_deq_clock; // @[Decoupled.scala 296:21]
  wire  data_b_deq_reset; // @[Decoupled.scala 296:21]
  wire  data_b_deq_io_enq_ready; // @[Decoupled.scala 296:21]
  wire  data_b_deq_io_enq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_b_deq_io_enq_bits_id; // @[Decoupled.scala 296:21]
  wire [1:0] data_b_deq_io_enq_bits_resp; // @[Decoupled.scala 296:21]
  wire  data_b_deq_io_deq_ready; // @[Decoupled.scala 296:21]
  wire  data_b_deq_io_deq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_b_deq_io_deq_bits_id; // @[Decoupled.scala 296:21]
  wire [1:0] data_b_deq_io_deq_bits_resp; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_clock; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_reset; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_io_enq_ready; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_io_enq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_ar_deq_io_enq_bits_id; // @[Decoupled.scala 296:21]
  wire [30:0] data_ar_deq_io_enq_bits_addr; // @[Decoupled.scala 296:21]
  wire [7:0] data_ar_deq_io_enq_bits_len; // @[Decoupled.scala 296:21]
  wire [2:0] data_ar_deq_io_enq_bits_size; // @[Decoupled.scala 296:21]
  wire [1:0] data_ar_deq_io_enq_bits_burst; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_io_enq_bits_lock; // @[Decoupled.scala 296:21]
  wire [3:0] data_ar_deq_io_enq_bits_cache; // @[Decoupled.scala 296:21]
  wire [2:0] data_ar_deq_io_enq_bits_prot; // @[Decoupled.scala 296:21]
  wire [3:0] data_ar_deq_io_enq_bits_qos; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_io_deq_ready; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_io_deq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_ar_deq_io_deq_bits_id; // @[Decoupled.scala 296:21]
  wire [30:0] data_ar_deq_io_deq_bits_addr; // @[Decoupled.scala 296:21]
  wire [7:0] data_ar_deq_io_deq_bits_len; // @[Decoupled.scala 296:21]
  wire [2:0] data_ar_deq_io_deq_bits_size; // @[Decoupled.scala 296:21]
  wire [1:0] data_ar_deq_io_deq_bits_burst; // @[Decoupled.scala 296:21]
  wire  data_ar_deq_io_deq_bits_lock; // @[Decoupled.scala 296:21]
  wire [3:0] data_ar_deq_io_deq_bits_cache; // @[Decoupled.scala 296:21]
  wire [2:0] data_ar_deq_io_deq_bits_prot; // @[Decoupled.scala 296:21]
  wire [3:0] data_ar_deq_io_deq_bits_qos; // @[Decoupled.scala 296:21]
  wire  data_r_deq_clock; // @[Decoupled.scala 296:21]
  wire  data_r_deq_reset; // @[Decoupled.scala 296:21]
  wire  data_r_deq_io_enq_ready; // @[Decoupled.scala 296:21]
  wire  data_r_deq_io_enq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_r_deq_io_enq_bits_id; // @[Decoupled.scala 296:21]
  wire [63:0] data_r_deq_io_enq_bits_data; // @[Decoupled.scala 296:21]
  wire [1:0] data_r_deq_io_enq_bits_resp; // @[Decoupled.scala 296:21]
  wire  data_r_deq_io_enq_bits_last; // @[Decoupled.scala 296:21]
  wire  data_r_deq_io_deq_ready; // @[Decoupled.scala 296:21]
  wire  data_r_deq_io_deq_valid; // @[Decoupled.scala 296:21]
  wire [3:0] data_r_deq_io_deq_bits_id; // @[Decoupled.scala 296:21]
  wire [63:0] data_r_deq_io_deq_bits_data; // @[Decoupled.scala 296:21]
  wire [1:0] data_r_deq_io_deq_bits_resp; // @[Decoupled.scala 296:21]
  wire  data_r_deq_io_deq_bits_last; // @[Decoupled.scala 296:21]
  Queue data_aw_deq ( // @[Decoupled.scala 296:21]
    .clock(data_aw_deq_clock),
    .reset(data_aw_deq_reset),
    .io_enq_ready(data_aw_deq_io_enq_ready),
    .io_enq_valid(data_aw_deq_io_enq_valid),
    .io_enq_bits_id(data_aw_deq_io_enq_bits_id),
    .io_enq_bits_addr(data_aw_deq_io_enq_bits_addr),
    .io_enq_bits_len(data_aw_deq_io_enq_bits_len),
    .io_enq_bits_size(data_aw_deq_io_enq_bits_size),
    .io_enq_bits_burst(data_aw_deq_io_enq_bits_burst),
    .io_enq_bits_lock(data_aw_deq_io_enq_bits_lock),
    .io_enq_bits_cache(data_aw_deq_io_enq_bits_cache),
    .io_enq_bits_prot(data_aw_deq_io_enq_bits_prot),
    .io_enq_bits_qos(data_aw_deq_io_enq_bits_qos),
    .io_deq_ready(data_aw_deq_io_deq_ready),
    .io_deq_valid(data_aw_deq_io_deq_valid),
    .io_deq_bits_id(data_aw_deq_io_deq_bits_id),
    .io_deq_bits_addr(data_aw_deq_io_deq_bits_addr),
    .io_deq_bits_len(data_aw_deq_io_deq_bits_len),
    .io_deq_bits_size(data_aw_deq_io_deq_bits_size),
    .io_deq_bits_burst(data_aw_deq_io_deq_bits_burst),
    .io_deq_bits_lock(data_aw_deq_io_deq_bits_lock),
    .io_deq_bits_cache(data_aw_deq_io_deq_bits_cache),
    .io_deq_bits_prot(data_aw_deq_io_deq_bits_prot),
    .io_deq_bits_qos(data_aw_deq_io_deq_bits_qos)
  );
  Queue_1 data_w_deq ( // @[Decoupled.scala 296:21]
    .clock(data_w_deq_clock),
    .reset(data_w_deq_reset),
    .io_enq_ready(data_w_deq_io_enq_ready),
    .io_enq_valid(data_w_deq_io_enq_valid),
    .io_enq_bits_data(data_w_deq_io_enq_bits_data),
    .io_enq_bits_strb(data_w_deq_io_enq_bits_strb),
    .io_enq_bits_last(data_w_deq_io_enq_bits_last),
    .io_deq_ready(data_w_deq_io_deq_ready),
    .io_deq_valid(data_w_deq_io_deq_valid),
    .io_deq_bits_data(data_w_deq_io_deq_bits_data),
    .io_deq_bits_strb(data_w_deq_io_deq_bits_strb),
    .io_deq_bits_last(data_w_deq_io_deq_bits_last)
  );
  Queue_2 data_b_deq ( // @[Decoupled.scala 296:21]
    .clock(data_b_deq_clock),
    .reset(data_b_deq_reset),
    .io_enq_ready(data_b_deq_io_enq_ready),
    .io_enq_valid(data_b_deq_io_enq_valid),
    .io_enq_bits_id(data_b_deq_io_enq_bits_id),
    .io_enq_bits_resp(data_b_deq_io_enq_bits_resp),
    .io_deq_ready(data_b_deq_io_deq_ready),
    .io_deq_valid(data_b_deq_io_deq_valid),
    .io_deq_bits_id(data_b_deq_io_deq_bits_id),
    .io_deq_bits_resp(data_b_deq_io_deq_bits_resp)
  );
  Queue data_ar_deq ( // @[Decoupled.scala 296:21]
    .clock(data_ar_deq_clock),
    .reset(data_ar_deq_reset),
    .io_enq_ready(data_ar_deq_io_enq_ready),
    .io_enq_valid(data_ar_deq_io_enq_valid),
    .io_enq_bits_id(data_ar_deq_io_enq_bits_id),
    .io_enq_bits_addr(data_ar_deq_io_enq_bits_addr),
    .io_enq_bits_len(data_ar_deq_io_enq_bits_len),
    .io_enq_bits_size(data_ar_deq_io_enq_bits_size),
    .io_enq_bits_burst(data_ar_deq_io_enq_bits_burst),
    .io_enq_bits_lock(data_ar_deq_io_enq_bits_lock),
    .io_enq_bits_cache(data_ar_deq_io_enq_bits_cache),
    .io_enq_bits_prot(data_ar_deq_io_enq_bits_prot),
    .io_enq_bits_qos(data_ar_deq_io_enq_bits_qos),
    .io_deq_ready(data_ar_deq_io_deq_ready),
    .io_deq_valid(data_ar_deq_io_deq_valid),
    .io_deq_bits_id(data_ar_deq_io_deq_bits_id),
    .io_deq_bits_addr(data_ar_deq_io_deq_bits_addr),
    .io_deq_bits_len(data_ar_deq_io_deq_bits_len),
    .io_deq_bits_size(data_ar_deq_io_deq_bits_size),
    .io_deq_bits_burst(data_ar_deq_io_deq_bits_burst),
    .io_deq_bits_lock(data_ar_deq_io_deq_bits_lock),
    .io_deq_bits_cache(data_ar_deq_io_deq_bits_cache),
    .io_deq_bits_prot(data_ar_deq_io_deq_bits_prot),
    .io_deq_bits_qos(data_ar_deq_io_deq_bits_qos)
  );
  Queue_4 data_r_deq ( // @[Decoupled.scala 296:21]
    .clock(data_r_deq_clock),
    .reset(data_r_deq_reset),
    .io_enq_ready(data_r_deq_io_enq_ready),
    .io_enq_valid(data_r_deq_io_enq_valid),
    .io_enq_bits_id(data_r_deq_io_enq_bits_id),
    .io_enq_bits_data(data_r_deq_io_enq_bits_data),
    .io_enq_bits_resp(data_r_deq_io_enq_bits_resp),
    .io_enq_bits_last(data_r_deq_io_enq_bits_last),
    .io_deq_ready(data_r_deq_io_deq_ready),
    .io_deq_valid(data_r_deq_io_deq_valid),
    .io_deq_bits_id(data_r_deq_io_deq_bits_id),
    .io_deq_bits_data(data_r_deq_io_deq_bits_data),
    .io_deq_bits_resp(data_r_deq_io_deq_bits_resp),
    .io_deq_bits_last(data_r_deq_io_deq_bits_last)
  );
  assign auto_in_aw_ready = data_aw_deq_io_enq_ready; // @[Nodes.scala 1210:84 Decoupled.scala 299:17]
  assign auto_in_w_ready = data_w_deq_io_enq_ready; // @[Nodes.scala 1210:84 Decoupled.scala 299:17]
  assign auto_in_b_valid = data_b_deq_io_deq_valid; // @[Decoupled.scala 317:19 Decoupled.scala 319:15]
  assign auto_in_b_bits_id = data_b_deq_io_deq_bits_id; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_in_b_bits_resp = data_b_deq_io_deq_bits_resp; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_in_ar_ready = data_ar_deq_io_enq_ready; // @[Nodes.scala 1210:84 Decoupled.scala 299:17]
  assign auto_in_r_valid = data_r_deq_io_deq_valid; // @[Decoupled.scala 317:19 Decoupled.scala 319:15]
  assign auto_in_r_bits_id = data_r_deq_io_deq_bits_id; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_in_r_bits_data = data_r_deq_io_deq_bits_data; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_in_r_bits_resp = data_r_deq_io_deq_bits_resp; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_in_r_bits_last = data_r_deq_io_deq_bits_last; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_valid = data_aw_deq_io_deq_valid; // @[Decoupled.scala 317:19 Decoupled.scala 319:15]
  assign auto_out_aw_bits_id = data_aw_deq_io_deq_bits_id; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_addr = data_aw_deq_io_deq_bits_addr; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_len = data_aw_deq_io_deq_bits_len; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_size = data_aw_deq_io_deq_bits_size; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_burst = data_aw_deq_io_deq_bits_burst; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_lock = data_aw_deq_io_deq_bits_lock; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_cache = data_aw_deq_io_deq_bits_cache; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_prot = data_aw_deq_io_deq_bits_prot; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_aw_bits_qos = data_aw_deq_io_deq_bits_qos; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_w_valid = data_w_deq_io_deq_valid; // @[Decoupled.scala 317:19 Decoupled.scala 319:15]
  assign auto_out_w_bits_data = data_w_deq_io_deq_bits_data; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_w_bits_strb = data_w_deq_io_deq_bits_strb; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_w_bits_last = data_w_deq_io_deq_bits_last; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_b_ready = data_b_deq_io_enq_ready; // @[Nodes.scala 1207:84 Decoupled.scala 299:17]
  assign auto_out_ar_valid = data_ar_deq_io_deq_valid; // @[Decoupled.scala 317:19 Decoupled.scala 319:15]
  assign auto_out_ar_bits_id = data_ar_deq_io_deq_bits_id; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_addr = data_ar_deq_io_deq_bits_addr; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_len = data_ar_deq_io_deq_bits_len; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_size = data_ar_deq_io_deq_bits_size; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_burst = data_ar_deq_io_deq_bits_burst; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_lock = data_ar_deq_io_deq_bits_lock; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_cache = data_ar_deq_io_deq_bits_cache; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_prot = data_ar_deq_io_deq_bits_prot; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_ar_bits_qos = data_ar_deq_io_deq_bits_qos; // @[Decoupled.scala 317:19 Decoupled.scala 318:14]
  assign auto_out_r_ready = data_r_deq_io_enq_ready; // @[Nodes.scala 1207:84 Decoupled.scala 299:17]
  assign data_aw_deq_clock = clock;
  assign data_aw_deq_reset = reset;
  assign data_aw_deq_io_enq_valid = auto_in_aw_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_id = auto_in_aw_bits_id; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_addr = auto_in_aw_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_len = auto_in_aw_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_size = auto_in_aw_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_burst = auto_in_aw_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_lock = auto_in_aw_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_cache = auto_in_aw_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_prot = auto_in_aw_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_enq_bits_qos = auto_in_aw_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_aw_deq_io_deq_ready = auto_out_aw_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_w_deq_clock = clock;
  assign data_w_deq_reset = reset;
  assign data_w_deq_io_enq_valid = auto_in_w_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_w_deq_io_enq_bits_data = auto_in_w_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_w_deq_io_enq_bits_strb = auto_in_w_bits_strb; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_w_deq_io_enq_bits_last = auto_in_w_bits_last; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_w_deq_io_deq_ready = auto_out_w_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_b_deq_clock = clock;
  assign data_b_deq_reset = reset;
  assign data_b_deq_io_enq_valid = auto_out_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_b_deq_io_enq_bits_id = auto_out_b_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_b_deq_io_enq_bits_resp = auto_out_b_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_b_deq_io_deq_ready = auto_in_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_clock = clock;
  assign data_ar_deq_reset = reset;
  assign data_ar_deq_io_enq_valid = auto_in_ar_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_id = auto_in_ar_bits_id; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_addr = auto_in_ar_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_len = auto_in_ar_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_size = auto_in_ar_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_burst = auto_in_ar_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_lock = auto_in_ar_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_cache = auto_in_ar_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_prot = auto_in_ar_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_enq_bits_qos = auto_in_ar_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign data_ar_deq_io_deq_ready = auto_out_ar_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_r_deq_clock = clock;
  assign data_r_deq_reset = reset;
  assign data_r_deq_io_enq_valid = auto_out_r_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_r_deq_io_enq_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_r_deq_io_enq_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_r_deq_io_enq_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_r_deq_io_enq_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign data_r_deq_io_deq_ready = auto_in_r_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
endmodule
module QueueCompatibility(
  input        clock,
  input        reset,
  output       io_enq_ready,
  input        io_enq_valid,
  input  [3:0] io_enq_bits_tl_state_size,
  input  [4:0] io_enq_bits_tl_state_source,
  input        io_deq_ready,
  output       io_deq_valid,
  output [3:0] io_deq_bits_tl_state_size,
  output [4:0] io_deq_bits_tl_state_source
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_2;
`endif // RANDOMIZE_REG_INIT
  reg [3:0] ram_tl_state_size [0:0]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_size_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_size_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_size_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_size_MPORT_en; // @[Decoupled.scala 218:16]
  reg [4:0] ram_tl_state_source [0:0]; // @[Decoupled.scala 218:16]
  wire [4:0] ram_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_source_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [4:0] ram_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_source_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_source_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_source_MPORT_en; // @[Decoupled.scala 218:16]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  empty = ~maybe_full; // @[Decoupled.scala 224:28]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  assign ram_tl_state_size_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_tl_state_size_io_deq_bits_MPORT_data = ram_tl_state_size[ram_tl_state_size_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_tl_state_size_MPORT_data = io_enq_bits_tl_state_size;
  assign ram_tl_state_size_MPORT_addr = 1'h0;
  assign ram_tl_state_size_MPORT_mask = 1'h1;
  assign ram_tl_state_size_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_tl_state_source_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_tl_state_source_io_deq_bits_MPORT_data = ram_tl_state_source[ram_tl_state_source_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_tl_state_source_MPORT_data = io_enq_bits_tl_state_source;
  assign ram_tl_state_source_MPORT_addr = 1'h0;
  assign ram_tl_state_source_MPORT_mask = 1'h1;
  assign ram_tl_state_source_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~maybe_full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_tl_state_size = ram_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_tl_state_source = ram_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_tl_state_size_MPORT_en & ram_tl_state_size_MPORT_mask) begin
      ram_tl_state_size[ram_tl_state_size_MPORT_addr] <= ram_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_tl_state_source_MPORT_en & ram_tl_state_source_MPORT_mask) begin
      ram_tl_state_source[ram_tl_state_source_MPORT_addr] <= ram_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {1{`RANDOM}};
  for (initvar = 0; initvar < 1; initvar = initvar+1)
    ram_tl_state_size[initvar] = _RAND_0[3:0];
  _RAND_1 = {1{`RANDOM}};
  for (initvar = 0; initvar < 1; initvar = initvar+1)
    ram_tl_state_source[initvar] = _RAND_1[4:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_2 = {1{`RANDOM}};
  maybe_full = _RAND_2[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module QueueCompatibility_1(
  input        clock,
  input        reset,
  output       io_enq_ready,
  input        io_enq_valid,
  input  [3:0] io_enq_bits_tl_state_size,
  input  [4:0] io_enq_bits_tl_state_source,
  input        io_deq_ready,
  output       io_deq_valid,
  output [3:0] io_deq_bits_tl_state_size,
  output [4:0] io_deq_bits_tl_state_source
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
`endif // RANDOMIZE_REG_INIT
  reg [3:0] ram_tl_state_size [0:7]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_tl_state_size_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_tl_state_size_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_size_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_size_MPORT_en; // @[Decoupled.scala 218:16]
  reg [4:0] ram_tl_state_source [0:7]; // @[Decoupled.scala 218:16]
  wire [4:0] ram_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_tl_state_source_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [4:0] ram_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_tl_state_source_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_source_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_tl_state_source_MPORT_en; // @[Decoupled.scala 218:16]
  reg [2:0] enq_ptr_value; // @[Counter.scala 60:40]
  reg [2:0] deq_ptr_value; // @[Counter.scala 60:40]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  ptr_match = enq_ptr_value == deq_ptr_value; // @[Decoupled.scala 223:33]
  wire  empty = ptr_match & ~maybe_full; // @[Decoupled.scala 224:25]
  wire  full = ptr_match & maybe_full; // @[Decoupled.scala 225:24]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  wire [2:0] _value_T_1 = enq_ptr_value + 3'h1; // @[Counter.scala 76:24]
  wire [2:0] _value_T_3 = deq_ptr_value + 3'h1; // @[Counter.scala 76:24]
  assign ram_tl_state_size_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_tl_state_size_io_deq_bits_MPORT_data = ram_tl_state_size[ram_tl_state_size_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_tl_state_size_MPORT_data = io_enq_bits_tl_state_size;
  assign ram_tl_state_size_MPORT_addr = enq_ptr_value;
  assign ram_tl_state_size_MPORT_mask = 1'h1;
  assign ram_tl_state_size_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_tl_state_source_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_tl_state_source_io_deq_bits_MPORT_data = ram_tl_state_source[ram_tl_state_source_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_tl_state_source_MPORT_data = io_enq_bits_tl_state_source;
  assign ram_tl_state_source_MPORT_addr = enq_ptr_value;
  assign ram_tl_state_source_MPORT_mask = 1'h1;
  assign ram_tl_state_source_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_tl_state_size = ram_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_tl_state_source = ram_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_tl_state_size_MPORT_en & ram_tl_state_size_MPORT_mask) begin
      ram_tl_state_size[ram_tl_state_size_MPORT_addr] <= ram_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_tl_state_source_MPORT_en & ram_tl_state_source_MPORT_mask) begin
      ram_tl_state_source[ram_tl_state_source_MPORT_addr] <= ram_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Counter.scala 60:40]
      enq_ptr_value <= 3'h0; // @[Counter.scala 60:40]
    end else if (do_enq) begin // @[Decoupled.scala 229:17]
      enq_ptr_value <= _value_T_1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Counter.scala 60:40]
      deq_ptr_value <= 3'h0; // @[Counter.scala 60:40]
    end else if (do_deq) begin // @[Decoupled.scala 233:17]
      deq_ptr_value <= _value_T_3; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_tl_state_size[initvar] = _RAND_0[3:0];
  _RAND_1 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_tl_state_source[initvar] = _RAND_1[4:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_2 = {1{`RANDOM}};
  enq_ptr_value = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  deq_ptr_value = _RAND_3[2:0];
  _RAND_4 = {1{`RANDOM}};
  maybe_full = _RAND_4[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module AXI4UserYanker(
  input         clock,
  input         reset,
  output        auto_in_aw_ready,
  input         auto_in_aw_valid,
  input  [3:0]  auto_in_aw_bits_id,
  input  [30:0] auto_in_aw_bits_addr,
  input  [7:0]  auto_in_aw_bits_len,
  input  [2:0]  auto_in_aw_bits_size,
  input  [1:0]  auto_in_aw_bits_burst,
  input         auto_in_aw_bits_lock,
  input  [3:0]  auto_in_aw_bits_cache,
  input  [2:0]  auto_in_aw_bits_prot,
  input  [3:0]  auto_in_aw_bits_qos,
  input  [3:0]  auto_in_aw_bits_echo_tl_state_size,
  input  [4:0]  auto_in_aw_bits_echo_tl_state_source,
  output        auto_in_w_ready,
  input         auto_in_w_valid,
  input  [63:0] auto_in_w_bits_data,
  input  [7:0]  auto_in_w_bits_strb,
  input         auto_in_w_bits_last,
  input         auto_in_b_ready,
  output        auto_in_b_valid,
  output [3:0]  auto_in_b_bits_id,
  output [1:0]  auto_in_b_bits_resp,
  output [3:0]  auto_in_b_bits_echo_tl_state_size,
  output [4:0]  auto_in_b_bits_echo_tl_state_source,
  output        auto_in_ar_ready,
  input         auto_in_ar_valid,
  input  [3:0]  auto_in_ar_bits_id,
  input  [30:0] auto_in_ar_bits_addr,
  input  [7:0]  auto_in_ar_bits_len,
  input  [2:0]  auto_in_ar_bits_size,
  input  [1:0]  auto_in_ar_bits_burst,
  input         auto_in_ar_bits_lock,
  input  [3:0]  auto_in_ar_bits_cache,
  input  [2:0]  auto_in_ar_bits_prot,
  input  [3:0]  auto_in_ar_bits_qos,
  input  [3:0]  auto_in_ar_bits_echo_tl_state_size,
  input  [4:0]  auto_in_ar_bits_echo_tl_state_source,
  input         auto_in_r_ready,
  output        auto_in_r_valid,
  output [3:0]  auto_in_r_bits_id,
  output [63:0] auto_in_r_bits_data,
  output [1:0]  auto_in_r_bits_resp,
  output [3:0]  auto_in_r_bits_echo_tl_state_size,
  output [4:0]  auto_in_r_bits_echo_tl_state_source,
  output        auto_in_r_bits_last,
  input         auto_out_aw_ready,
  output        auto_out_aw_valid,
  output [3:0]  auto_out_aw_bits_id,
  output [30:0] auto_out_aw_bits_addr,
  output [7:0]  auto_out_aw_bits_len,
  output [2:0]  auto_out_aw_bits_size,
  output [1:0]  auto_out_aw_bits_burst,
  output        auto_out_aw_bits_lock,
  output [3:0]  auto_out_aw_bits_cache,
  output [2:0]  auto_out_aw_bits_prot,
  output [3:0]  auto_out_aw_bits_qos,
  input         auto_out_w_ready,
  output        auto_out_w_valid,
  output [63:0] auto_out_w_bits_data,
  output [7:0]  auto_out_w_bits_strb,
  output        auto_out_w_bits_last,
  output        auto_out_b_ready,
  input         auto_out_b_valid,
  input  [3:0]  auto_out_b_bits_id,
  input  [1:0]  auto_out_b_bits_resp,
  input         auto_out_ar_ready,
  output        auto_out_ar_valid,
  output [3:0]  auto_out_ar_bits_id,
  output [30:0] auto_out_ar_bits_addr,
  output [7:0]  auto_out_ar_bits_len,
  output [2:0]  auto_out_ar_bits_size,
  output [1:0]  auto_out_ar_bits_burst,
  output        auto_out_ar_bits_lock,
  output [3:0]  auto_out_ar_bits_cache,
  output [2:0]  auto_out_ar_bits_prot,
  output [3:0]  auto_out_ar_bits_qos,
  output        auto_out_r_ready,
  input         auto_out_r_valid,
  input  [3:0]  auto_out_r_bits_id,
  input  [63:0] auto_out_r_bits_data,
  input  [1:0]  auto_out_r_bits_resp,
  input         auto_out_r_bits_last
);
  wire  QueueCompatibility_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_1_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_1_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_1_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_1_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_1_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_1_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_1_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_1_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_1_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_1_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_2_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_2_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_2_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_2_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_2_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_2_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_2_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_2_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_2_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_2_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_3_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_3_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_3_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_3_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_3_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_3_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_3_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_3_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_3_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_3_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_4_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_4_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_4_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_4_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_4_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_4_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_4_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_4_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_4_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_4_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_5_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_5_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_5_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_5_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_5_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_5_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_5_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_5_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_5_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_5_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_6_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_6_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_6_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_6_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_6_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_6_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_6_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_6_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_6_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_6_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_7_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_7_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_7_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_7_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_7_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_7_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_7_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_7_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_7_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_7_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_8_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_8_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_8_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_8_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_8_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_8_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_8_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_8_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_8_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_8_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_9_clock; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_9_reset; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_9_io_enq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_9_io_enq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_9_io_enq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_9_io_enq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_9_io_deq_ready; // @[UserYanker.scala 47:17]
  wire  QueueCompatibility_9_io_deq_valid; // @[UserYanker.scala 47:17]
  wire [3:0] QueueCompatibility_9_io_deq_bits_tl_state_size; // @[UserYanker.scala 47:17]
  wire [4:0] QueueCompatibility_9_io_deq_bits_tl_state_source; // @[UserYanker.scala 47:17]
  wire  _ar_ready_WIRE_0 = QueueCompatibility_io_enq_ready; // @[UserYanker.scala 55:25 UserYanker.scala 55:25]
  wire  _ar_ready_WIRE_1 = QueueCompatibility_1_io_enq_ready; // @[UserYanker.scala 55:25 UserYanker.scala 55:25]
  wire  _GEN_1 = 4'h1 == auto_in_ar_bits_id ? _ar_ready_WIRE_1 : _ar_ready_WIRE_0; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _ar_ready_WIRE_2 = QueueCompatibility_2_io_enq_ready; // @[UserYanker.scala 55:25 UserYanker.scala 55:25]
  wire  _GEN_2 = 4'h2 == auto_in_ar_bits_id ? _ar_ready_WIRE_2 : _GEN_1; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _ar_ready_WIRE_3 = QueueCompatibility_3_io_enq_ready; // @[UserYanker.scala 55:25 UserYanker.scala 55:25]
  wire  _GEN_3 = 4'h3 == auto_in_ar_bits_id ? _ar_ready_WIRE_3 : _GEN_2; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _ar_ready_WIRE_4 = QueueCompatibility_4_io_enq_ready; // @[UserYanker.scala 55:25 UserYanker.scala 55:25]
  wire  _GEN_4 = 4'h4 == auto_in_ar_bits_id ? _ar_ready_WIRE_4 : _GEN_3; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_5 = 4'h5 == auto_in_ar_bits_id ? 1'h0 : _GEN_4; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_6 = 4'h6 == auto_in_ar_bits_id ? 1'h0 : _GEN_5; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_7 = 4'h7 == auto_in_ar_bits_id ? 1'h0 : _GEN_6; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_8 = 4'h8 == auto_in_ar_bits_id ? 1'h0 : _GEN_7; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_9 = 4'h9 == auto_in_ar_bits_id ? 1'h0 : _GEN_8; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_10 = 4'ha == auto_in_ar_bits_id ? 1'h0 : _GEN_9; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_11 = 4'hb == auto_in_ar_bits_id ? 1'h0 : _GEN_10; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_12 = 4'hc == auto_in_ar_bits_id ? 1'h0 : _GEN_11; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_13 = 4'hd == auto_in_ar_bits_id ? 1'h0 : _GEN_12; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_14 = 4'he == auto_in_ar_bits_id ? 1'h0 : _GEN_13; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _GEN_15 = 4'hf == auto_in_ar_bits_id ? 1'h0 : _GEN_14; // @[UserYanker.scala 56:36 UserYanker.scala 56:36]
  wire  _r_valid_WIRE_0 = QueueCompatibility_io_deq_valid; // @[UserYanker.scala 61:24 UserYanker.scala 61:24]
  wire  _r_valid_WIRE_1 = QueueCompatibility_1_io_deq_valid; // @[UserYanker.scala 61:24 UserYanker.scala 61:24]
  wire  _GEN_17 = 4'h1 == auto_out_r_bits_id ? _r_valid_WIRE_1 : _r_valid_WIRE_0; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _r_valid_WIRE_2 = QueueCompatibility_2_io_deq_valid; // @[UserYanker.scala 61:24 UserYanker.scala 61:24]
  wire  _GEN_18 = 4'h2 == auto_out_r_bits_id ? _r_valid_WIRE_2 : _GEN_17; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _r_valid_WIRE_3 = QueueCompatibility_3_io_deq_valid; // @[UserYanker.scala 61:24 UserYanker.scala 61:24]
  wire  _GEN_19 = 4'h3 == auto_out_r_bits_id ? _r_valid_WIRE_3 : _GEN_18; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _r_valid_WIRE_4 = QueueCompatibility_4_io_deq_valid; // @[UserYanker.scala 61:24 UserYanker.scala 61:24]
  wire  _GEN_20 = 4'h4 == auto_out_r_bits_id ? _r_valid_WIRE_4 : _GEN_19; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_21 = 4'h5 == auto_out_r_bits_id ? 1'h0 : _GEN_20; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_22 = 4'h6 == auto_out_r_bits_id ? 1'h0 : _GEN_21; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_23 = 4'h7 == auto_out_r_bits_id ? 1'h0 : _GEN_22; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_24 = 4'h8 == auto_out_r_bits_id ? 1'h0 : _GEN_23; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_25 = 4'h9 == auto_out_r_bits_id ? 1'h0 : _GEN_24; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_26 = 4'ha == auto_out_r_bits_id ? 1'h0 : _GEN_25; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_27 = 4'hb == auto_out_r_bits_id ? 1'h0 : _GEN_26; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_28 = 4'hc == auto_out_r_bits_id ? 1'h0 : _GEN_27; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_29 = 4'hd == auto_out_r_bits_id ? 1'h0 : _GEN_28; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_30 = 4'he == auto_out_r_bits_id ? 1'h0 : _GEN_29; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire  _GEN_31 = 4'hf == auto_out_r_bits_id ? 1'h0 : _GEN_30; // @[UserYanker.scala 63:28 UserYanker.scala 63:28]
  wire [3:0] _r_bits_WIRE_0_tl_state_size = QueueCompatibility_io_deq_bits_tl_state_size; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [4:0] _r_bits_WIRE_0_tl_state_source = QueueCompatibility_io_deq_bits_tl_state_source; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [3:0] _r_bits_WIRE_1_tl_state_size = QueueCompatibility_1_io_deq_bits_tl_state_size; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [3:0] _GEN_34 = 4'h1 == auto_out_r_bits_id ? _r_bits_WIRE_1_tl_state_size : _r_bits_WIRE_0_tl_state_size; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _r_bits_WIRE_1_tl_state_source = QueueCompatibility_1_io_deq_bits_tl_state_source; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [4:0] _GEN_35 = 4'h1 == auto_out_r_bits_id ? _r_bits_WIRE_1_tl_state_source : _r_bits_WIRE_0_tl_state_source; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _r_bits_WIRE_2_tl_state_size = QueueCompatibility_2_io_deq_bits_tl_state_size; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [3:0] _GEN_36 = 4'h2 == auto_out_r_bits_id ? _r_bits_WIRE_2_tl_state_size : _GEN_34; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _r_bits_WIRE_2_tl_state_source = QueueCompatibility_2_io_deq_bits_tl_state_source; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [4:0] _GEN_37 = 4'h2 == auto_out_r_bits_id ? _r_bits_WIRE_2_tl_state_source : _GEN_35; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _r_bits_WIRE_3_tl_state_size = QueueCompatibility_3_io_deq_bits_tl_state_size; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [3:0] _GEN_38 = 4'h3 == auto_out_r_bits_id ? _r_bits_WIRE_3_tl_state_size : _GEN_36; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _r_bits_WIRE_3_tl_state_source = QueueCompatibility_3_io_deq_bits_tl_state_source; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [4:0] _GEN_39 = 4'h3 == auto_out_r_bits_id ? _r_bits_WIRE_3_tl_state_source : _GEN_37; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _r_bits_WIRE_4_tl_state_size = QueueCompatibility_4_io_deq_bits_tl_state_size; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [3:0] _GEN_40 = 4'h4 == auto_out_r_bits_id ? _r_bits_WIRE_4_tl_state_size : _GEN_38; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _r_bits_WIRE_4_tl_state_source = QueueCompatibility_4_io_deq_bits_tl_state_source; // @[UserYanker.scala 62:23 UserYanker.scala 62:23]
  wire [4:0] _GEN_41 = 4'h4 == auto_out_r_bits_id ? _r_bits_WIRE_4_tl_state_source : _GEN_39; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_42 = 4'h5 == auto_out_r_bits_id ? 4'h0 : _GEN_40; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_43 = 4'h5 == auto_out_r_bits_id ? 5'h0 : _GEN_41; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_44 = 4'h6 == auto_out_r_bits_id ? 4'h0 : _GEN_42; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_45 = 4'h6 == auto_out_r_bits_id ? 5'h0 : _GEN_43; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_46 = 4'h7 == auto_out_r_bits_id ? 4'h0 : _GEN_44; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_47 = 4'h7 == auto_out_r_bits_id ? 5'h0 : _GEN_45; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_48 = 4'h8 == auto_out_r_bits_id ? 4'h0 : _GEN_46; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_49 = 4'h8 == auto_out_r_bits_id ? 5'h0 : _GEN_47; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_50 = 4'h9 == auto_out_r_bits_id ? 4'h0 : _GEN_48; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_51 = 4'h9 == auto_out_r_bits_id ? 5'h0 : _GEN_49; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_52 = 4'ha == auto_out_r_bits_id ? 4'h0 : _GEN_50; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_53 = 4'ha == auto_out_r_bits_id ? 5'h0 : _GEN_51; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_54 = 4'hb == auto_out_r_bits_id ? 4'h0 : _GEN_52; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_55 = 4'hb == auto_out_r_bits_id ? 5'h0 : _GEN_53; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_56 = 4'hc == auto_out_r_bits_id ? 4'h0 : _GEN_54; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_57 = 4'hc == auto_out_r_bits_id ? 5'h0 : _GEN_55; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_58 = 4'hd == auto_out_r_bits_id ? 4'h0 : _GEN_56; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_59 = 4'hd == auto_out_r_bits_id ? 5'h0 : _GEN_57; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_60 = 4'he == auto_out_r_bits_id ? 4'h0 : _GEN_58; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_61 = 4'he == auto_out_r_bits_id ? 5'h0 : _GEN_59; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [15:0] _arsel_T = 16'h1 << auto_in_ar_bits_id; // @[OneHot.scala 65:12]
  wire  arsel_0 = _arsel_T[0]; // @[UserYanker.scala 67:55]
  wire  arsel_1 = _arsel_T[1]; // @[UserYanker.scala 67:55]
  wire  arsel_2 = _arsel_T[2]; // @[UserYanker.scala 67:55]
  wire  arsel_3 = _arsel_T[3]; // @[UserYanker.scala 67:55]
  wire  arsel_4 = _arsel_T[4]; // @[UserYanker.scala 67:55]
  wire [15:0] _rsel_T = 16'h1 << auto_out_r_bits_id; // @[OneHot.scala 65:12]
  wire  rsel_0 = _rsel_T[0]; // @[UserYanker.scala 68:55]
  wire  rsel_1 = _rsel_T[1]; // @[UserYanker.scala 68:55]
  wire  rsel_2 = _rsel_T[2]; // @[UserYanker.scala 68:55]
  wire  rsel_3 = _rsel_T[3]; // @[UserYanker.scala 68:55]
  wire  rsel_4 = _rsel_T[4]; // @[UserYanker.scala 68:55]
  wire  _aw_ready_WIRE_0 = QueueCompatibility_5_io_enq_ready; // @[UserYanker.scala 76:25 UserYanker.scala 76:25]
  wire  _aw_ready_WIRE_1 = QueueCompatibility_6_io_enq_ready; // @[UserYanker.scala 76:25 UserYanker.scala 76:25]
  wire  _GEN_65 = 4'h1 == auto_in_aw_bits_id ? _aw_ready_WIRE_1 : _aw_ready_WIRE_0; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _aw_ready_WIRE_2 = QueueCompatibility_7_io_enq_ready; // @[UserYanker.scala 76:25 UserYanker.scala 76:25]
  wire  _GEN_66 = 4'h2 == auto_in_aw_bits_id ? _aw_ready_WIRE_2 : _GEN_65; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _aw_ready_WIRE_3 = QueueCompatibility_8_io_enq_ready; // @[UserYanker.scala 76:25 UserYanker.scala 76:25]
  wire  _GEN_67 = 4'h3 == auto_in_aw_bits_id ? _aw_ready_WIRE_3 : _GEN_66; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _aw_ready_WIRE_4 = QueueCompatibility_9_io_enq_ready; // @[UserYanker.scala 76:25 UserYanker.scala 76:25]
  wire  _GEN_68 = 4'h4 == auto_in_aw_bits_id ? _aw_ready_WIRE_4 : _GEN_67; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_69 = 4'h5 == auto_in_aw_bits_id ? 1'h0 : _GEN_68; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_70 = 4'h6 == auto_in_aw_bits_id ? 1'h0 : _GEN_69; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_71 = 4'h7 == auto_in_aw_bits_id ? 1'h0 : _GEN_70; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_72 = 4'h8 == auto_in_aw_bits_id ? 1'h0 : _GEN_71; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_73 = 4'h9 == auto_in_aw_bits_id ? 1'h0 : _GEN_72; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_74 = 4'ha == auto_in_aw_bits_id ? 1'h0 : _GEN_73; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_75 = 4'hb == auto_in_aw_bits_id ? 1'h0 : _GEN_74; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_76 = 4'hc == auto_in_aw_bits_id ? 1'h0 : _GEN_75; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_77 = 4'hd == auto_in_aw_bits_id ? 1'h0 : _GEN_76; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_78 = 4'he == auto_in_aw_bits_id ? 1'h0 : _GEN_77; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _GEN_79 = 4'hf == auto_in_aw_bits_id ? 1'h0 : _GEN_78; // @[UserYanker.scala 77:36 UserYanker.scala 77:36]
  wire  _b_valid_WIRE_0 = QueueCompatibility_5_io_deq_valid; // @[UserYanker.scala 82:24 UserYanker.scala 82:24]
  wire  _b_valid_WIRE_1 = QueueCompatibility_6_io_deq_valid; // @[UserYanker.scala 82:24 UserYanker.scala 82:24]
  wire  _GEN_81 = 4'h1 == auto_out_b_bits_id ? _b_valid_WIRE_1 : _b_valid_WIRE_0; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _b_valid_WIRE_2 = QueueCompatibility_7_io_deq_valid; // @[UserYanker.scala 82:24 UserYanker.scala 82:24]
  wire  _GEN_82 = 4'h2 == auto_out_b_bits_id ? _b_valid_WIRE_2 : _GEN_81; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _b_valid_WIRE_3 = QueueCompatibility_8_io_deq_valid; // @[UserYanker.scala 82:24 UserYanker.scala 82:24]
  wire  _GEN_83 = 4'h3 == auto_out_b_bits_id ? _b_valid_WIRE_3 : _GEN_82; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _b_valid_WIRE_4 = QueueCompatibility_9_io_deq_valid; // @[UserYanker.scala 82:24 UserYanker.scala 82:24]
  wire  _GEN_84 = 4'h4 == auto_out_b_bits_id ? _b_valid_WIRE_4 : _GEN_83; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_85 = 4'h5 == auto_out_b_bits_id ? 1'h0 : _GEN_84; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_86 = 4'h6 == auto_out_b_bits_id ? 1'h0 : _GEN_85; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_87 = 4'h7 == auto_out_b_bits_id ? 1'h0 : _GEN_86; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_88 = 4'h8 == auto_out_b_bits_id ? 1'h0 : _GEN_87; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_89 = 4'h9 == auto_out_b_bits_id ? 1'h0 : _GEN_88; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_90 = 4'ha == auto_out_b_bits_id ? 1'h0 : _GEN_89; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_91 = 4'hb == auto_out_b_bits_id ? 1'h0 : _GEN_90; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_92 = 4'hc == auto_out_b_bits_id ? 1'h0 : _GEN_91; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_93 = 4'hd == auto_out_b_bits_id ? 1'h0 : _GEN_92; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_94 = 4'he == auto_out_b_bits_id ? 1'h0 : _GEN_93; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire  _GEN_95 = 4'hf == auto_out_b_bits_id ? 1'h0 : _GEN_94; // @[UserYanker.scala 84:28 UserYanker.scala 84:28]
  wire [3:0] _b_bits_WIRE_0_tl_state_size = QueueCompatibility_5_io_deq_bits_tl_state_size; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [4:0] _b_bits_WIRE_0_tl_state_source = QueueCompatibility_5_io_deq_bits_tl_state_source; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [3:0] _b_bits_WIRE_1_tl_state_size = QueueCompatibility_6_io_deq_bits_tl_state_size; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [3:0] _GEN_98 = 4'h1 == auto_out_b_bits_id ? _b_bits_WIRE_1_tl_state_size : _b_bits_WIRE_0_tl_state_size; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _b_bits_WIRE_1_tl_state_source = QueueCompatibility_6_io_deq_bits_tl_state_source; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [4:0] _GEN_99 = 4'h1 == auto_out_b_bits_id ? _b_bits_WIRE_1_tl_state_source : _b_bits_WIRE_0_tl_state_source; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _b_bits_WIRE_2_tl_state_size = QueueCompatibility_7_io_deq_bits_tl_state_size; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [3:0] _GEN_100 = 4'h2 == auto_out_b_bits_id ? _b_bits_WIRE_2_tl_state_size : _GEN_98; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _b_bits_WIRE_2_tl_state_source = QueueCompatibility_7_io_deq_bits_tl_state_source; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [4:0] _GEN_101 = 4'h2 == auto_out_b_bits_id ? _b_bits_WIRE_2_tl_state_source : _GEN_99; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _b_bits_WIRE_3_tl_state_size = QueueCompatibility_8_io_deq_bits_tl_state_size; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [3:0] _GEN_102 = 4'h3 == auto_out_b_bits_id ? _b_bits_WIRE_3_tl_state_size : _GEN_100; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _b_bits_WIRE_3_tl_state_source = QueueCompatibility_8_io_deq_bits_tl_state_source; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [4:0] _GEN_103 = 4'h3 == auto_out_b_bits_id ? _b_bits_WIRE_3_tl_state_source : _GEN_101; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _b_bits_WIRE_4_tl_state_size = QueueCompatibility_9_io_deq_bits_tl_state_size; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [3:0] _GEN_104 = 4'h4 == auto_out_b_bits_id ? _b_bits_WIRE_4_tl_state_size : _GEN_102; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _b_bits_WIRE_4_tl_state_source = QueueCompatibility_9_io_deq_bits_tl_state_source; // @[UserYanker.scala 83:23 UserYanker.scala 83:23]
  wire [4:0] _GEN_105 = 4'h4 == auto_out_b_bits_id ? _b_bits_WIRE_4_tl_state_source : _GEN_103; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_106 = 4'h5 == auto_out_b_bits_id ? 4'h0 : _GEN_104; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_107 = 4'h5 == auto_out_b_bits_id ? 5'h0 : _GEN_105; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_108 = 4'h6 == auto_out_b_bits_id ? 4'h0 : _GEN_106; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_109 = 4'h6 == auto_out_b_bits_id ? 5'h0 : _GEN_107; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_110 = 4'h7 == auto_out_b_bits_id ? 4'h0 : _GEN_108; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_111 = 4'h7 == auto_out_b_bits_id ? 5'h0 : _GEN_109; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_112 = 4'h8 == auto_out_b_bits_id ? 4'h0 : _GEN_110; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_113 = 4'h8 == auto_out_b_bits_id ? 5'h0 : _GEN_111; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_114 = 4'h9 == auto_out_b_bits_id ? 4'h0 : _GEN_112; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_115 = 4'h9 == auto_out_b_bits_id ? 5'h0 : _GEN_113; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_116 = 4'ha == auto_out_b_bits_id ? 4'h0 : _GEN_114; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_117 = 4'ha == auto_out_b_bits_id ? 5'h0 : _GEN_115; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_118 = 4'hb == auto_out_b_bits_id ? 4'h0 : _GEN_116; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_119 = 4'hb == auto_out_b_bits_id ? 5'h0 : _GEN_117; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_120 = 4'hc == auto_out_b_bits_id ? 4'h0 : _GEN_118; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_121 = 4'hc == auto_out_b_bits_id ? 5'h0 : _GEN_119; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_122 = 4'hd == auto_out_b_bits_id ? 4'h0 : _GEN_120; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_123 = 4'hd == auto_out_b_bits_id ? 5'h0 : _GEN_121; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [3:0] _GEN_124 = 4'he == auto_out_b_bits_id ? 4'h0 : _GEN_122; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [4:0] _GEN_125 = 4'he == auto_out_b_bits_id ? 5'h0 : _GEN_123; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  wire [15:0] _awsel_T = 16'h1 << auto_in_aw_bits_id; // @[OneHot.scala 65:12]
  wire  awsel_0 = _awsel_T[0]; // @[UserYanker.scala 88:55]
  wire  awsel_1 = _awsel_T[1]; // @[UserYanker.scala 88:55]
  wire  awsel_2 = _awsel_T[2]; // @[UserYanker.scala 88:55]
  wire  awsel_3 = _awsel_T[3]; // @[UserYanker.scala 88:55]
  wire  awsel_4 = _awsel_T[4]; // @[UserYanker.scala 88:55]
  wire [15:0] _bsel_T = 16'h1 << auto_out_b_bits_id; // @[OneHot.scala 65:12]
  wire  bsel_0 = _bsel_T[0]; // @[UserYanker.scala 89:55]
  wire  bsel_1 = _bsel_T[1]; // @[UserYanker.scala 89:55]
  wire  bsel_2 = _bsel_T[2]; // @[UserYanker.scala 89:55]
  wire  bsel_3 = _bsel_T[3]; // @[UserYanker.scala 89:55]
  wire  bsel_4 = _bsel_T[4]; // @[UserYanker.scala 89:55]
  QueueCompatibility QueueCompatibility ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_clock),
    .reset(QueueCompatibility_reset),
    .io_enq_ready(QueueCompatibility_io_enq_ready),
    .io_enq_valid(QueueCompatibility_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_io_deq_ready),
    .io_deq_valid(QueueCompatibility_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_io_deq_bits_tl_state_source)
  );
  QueueCompatibility_1 QueueCompatibility_1 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_1_clock),
    .reset(QueueCompatibility_1_reset),
    .io_enq_ready(QueueCompatibility_1_io_enq_ready),
    .io_enq_valid(QueueCompatibility_1_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_1_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_1_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_1_io_deq_ready),
    .io_deq_valid(QueueCompatibility_1_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_1_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_1_io_deq_bits_tl_state_source)
  );
  QueueCompatibility_1 QueueCompatibility_2 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_2_clock),
    .reset(QueueCompatibility_2_reset),
    .io_enq_ready(QueueCompatibility_2_io_enq_ready),
    .io_enq_valid(QueueCompatibility_2_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_2_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_2_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_2_io_deq_ready),
    .io_deq_valid(QueueCompatibility_2_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_2_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_2_io_deq_bits_tl_state_source)
  );
  QueueCompatibility QueueCompatibility_3 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_3_clock),
    .reset(QueueCompatibility_3_reset),
    .io_enq_ready(QueueCompatibility_3_io_enq_ready),
    .io_enq_valid(QueueCompatibility_3_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_3_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_3_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_3_io_deq_ready),
    .io_deq_valid(QueueCompatibility_3_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_3_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_3_io_deq_bits_tl_state_source)
  );
  QueueCompatibility QueueCompatibility_4 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_4_clock),
    .reset(QueueCompatibility_4_reset),
    .io_enq_ready(QueueCompatibility_4_io_enq_ready),
    .io_enq_valid(QueueCompatibility_4_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_4_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_4_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_4_io_deq_ready),
    .io_deq_valid(QueueCompatibility_4_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_4_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_4_io_deq_bits_tl_state_source)
  );
  QueueCompatibility QueueCompatibility_5 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_5_clock),
    .reset(QueueCompatibility_5_reset),
    .io_enq_ready(QueueCompatibility_5_io_enq_ready),
    .io_enq_valid(QueueCompatibility_5_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_5_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_5_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_5_io_deq_ready),
    .io_deq_valid(QueueCompatibility_5_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_5_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_5_io_deq_bits_tl_state_source)
  );
  QueueCompatibility_1 QueueCompatibility_6 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_6_clock),
    .reset(QueueCompatibility_6_reset),
    .io_enq_ready(QueueCompatibility_6_io_enq_ready),
    .io_enq_valid(QueueCompatibility_6_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_6_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_6_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_6_io_deq_ready),
    .io_deq_valid(QueueCompatibility_6_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_6_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_6_io_deq_bits_tl_state_source)
  );
  QueueCompatibility_1 QueueCompatibility_7 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_7_clock),
    .reset(QueueCompatibility_7_reset),
    .io_enq_ready(QueueCompatibility_7_io_enq_ready),
    .io_enq_valid(QueueCompatibility_7_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_7_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_7_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_7_io_deq_ready),
    .io_deq_valid(QueueCompatibility_7_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_7_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_7_io_deq_bits_tl_state_source)
  );
  QueueCompatibility QueueCompatibility_8 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_8_clock),
    .reset(QueueCompatibility_8_reset),
    .io_enq_ready(QueueCompatibility_8_io_enq_ready),
    .io_enq_valid(QueueCompatibility_8_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_8_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_8_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_8_io_deq_ready),
    .io_deq_valid(QueueCompatibility_8_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_8_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_8_io_deq_bits_tl_state_source)
  );
  QueueCompatibility QueueCompatibility_9 ( // @[UserYanker.scala 47:17]
    .clock(QueueCompatibility_9_clock),
    .reset(QueueCompatibility_9_reset),
    .io_enq_ready(QueueCompatibility_9_io_enq_ready),
    .io_enq_valid(QueueCompatibility_9_io_enq_valid),
    .io_enq_bits_tl_state_size(QueueCompatibility_9_io_enq_bits_tl_state_size),
    .io_enq_bits_tl_state_source(QueueCompatibility_9_io_enq_bits_tl_state_source),
    .io_deq_ready(QueueCompatibility_9_io_deq_ready),
    .io_deq_valid(QueueCompatibility_9_io_deq_valid),
    .io_deq_bits_tl_state_size(QueueCompatibility_9_io_deq_bits_tl_state_size),
    .io_deq_bits_tl_state_source(QueueCompatibility_9_io_deq_bits_tl_state_source)
  );
  assign auto_in_aw_ready = auto_out_aw_ready & _GEN_79; // @[UserYanker.scala 77:36]
  assign auto_in_w_ready = auto_out_w_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_valid = auto_out_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_id = auto_out_b_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_resp = auto_out_b_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_echo_tl_state_size = 4'hf == auto_out_b_bits_id ? 4'h0 : _GEN_124; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  assign auto_in_b_bits_echo_tl_state_source = 4'hf == auto_out_b_bits_id ? 5'h0 : _GEN_125; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  assign auto_in_ar_ready = auto_out_ar_ready & _GEN_15; // @[UserYanker.scala 56:36]
  assign auto_in_r_valid = auto_out_r_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_echo_tl_state_size = 4'hf == auto_out_r_bits_id ? 4'h0 : _GEN_60; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  assign auto_in_r_bits_echo_tl_state_source = 4'hf == auto_out_r_bits_id ? 5'h0 : _GEN_61; // @[BundleMap.scala 247:19 BundleMap.scala 247:19]
  assign auto_in_r_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_out_aw_valid = auto_in_aw_valid & _GEN_79; // @[UserYanker.scala 78:36]
  assign auto_out_aw_bits_id = auto_in_aw_bits_id; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_addr = auto_in_aw_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_len = auto_in_aw_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_size = auto_in_aw_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_burst = auto_in_aw_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_lock = auto_in_aw_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_cache = auto_in_aw_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_prot = auto_in_aw_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_qos = auto_in_aw_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_valid = auto_in_w_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_data = auto_in_w_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_strb = auto_in_w_bits_strb; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_last = auto_in_w_bits_last; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_b_ready = auto_in_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_valid = auto_in_ar_valid & _GEN_15; // @[UserYanker.scala 57:36]
  assign auto_out_ar_bits_id = auto_in_ar_bits_id; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_addr = auto_in_ar_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_len = auto_in_ar_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_size = auto_in_ar_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_burst = auto_in_ar_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_lock = auto_in_ar_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_cache = auto_in_ar_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_prot = auto_in_ar_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_qos = auto_in_ar_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_r_ready = auto_in_r_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_clock = clock;
  assign QueueCompatibility_reset = reset;
  assign QueueCompatibility_io_enq_valid = auto_in_ar_valid & auto_out_ar_ready & arsel_0; // @[UserYanker.scala 71:53]
  assign QueueCompatibility_io_enq_bits_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_io_enq_bits_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_io_deq_ready = auto_out_r_valid & auto_in_r_ready & rsel_0 & auto_out_r_bits_last; // @[UserYanker.scala 70:58]
  assign QueueCompatibility_1_clock = clock;
  assign QueueCompatibility_1_reset = reset;
  assign QueueCompatibility_1_io_enq_valid = auto_in_ar_valid & auto_out_ar_ready & arsel_1; // @[UserYanker.scala 71:53]
  assign QueueCompatibility_1_io_enq_bits_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_1_io_enq_bits_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_1_io_deq_ready = auto_out_r_valid & auto_in_r_ready & rsel_1 & auto_out_r_bits_last; // @[UserYanker.scala 70:58]
  assign QueueCompatibility_2_clock = clock;
  assign QueueCompatibility_2_reset = reset;
  assign QueueCompatibility_2_io_enq_valid = auto_in_ar_valid & auto_out_ar_ready & arsel_2; // @[UserYanker.scala 71:53]
  assign QueueCompatibility_2_io_enq_bits_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_2_io_enq_bits_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_2_io_deq_ready = auto_out_r_valid & auto_in_r_ready & rsel_2 & auto_out_r_bits_last; // @[UserYanker.scala 70:58]
  assign QueueCompatibility_3_clock = clock;
  assign QueueCompatibility_3_reset = reset;
  assign QueueCompatibility_3_io_enq_valid = auto_in_ar_valid & auto_out_ar_ready & arsel_3; // @[UserYanker.scala 71:53]
  assign QueueCompatibility_3_io_enq_bits_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_3_io_enq_bits_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_3_io_deq_ready = auto_out_r_valid & auto_in_r_ready & rsel_3 & auto_out_r_bits_last; // @[UserYanker.scala 70:58]
  assign QueueCompatibility_4_clock = clock;
  assign QueueCompatibility_4_reset = reset;
  assign QueueCompatibility_4_io_enq_valid = auto_in_ar_valid & auto_out_ar_ready & arsel_4; // @[UserYanker.scala 71:53]
  assign QueueCompatibility_4_io_enq_bits_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_4_io_enq_bits_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_4_io_deq_ready = auto_out_r_valid & auto_in_r_ready & rsel_4 & auto_out_r_bits_last; // @[UserYanker.scala 70:58]
  assign QueueCompatibility_5_clock = clock;
  assign QueueCompatibility_5_reset = reset;
  assign QueueCompatibility_5_io_enq_valid = auto_in_aw_valid & auto_out_aw_ready & awsel_0; // @[UserYanker.scala 92:53]
  assign QueueCompatibility_5_io_enq_bits_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_5_io_enq_bits_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_5_io_deq_ready = auto_out_b_valid & auto_in_b_ready & bsel_0; // @[UserYanker.scala 91:53]
  assign QueueCompatibility_6_clock = clock;
  assign QueueCompatibility_6_reset = reset;
  assign QueueCompatibility_6_io_enq_valid = auto_in_aw_valid & auto_out_aw_ready & awsel_1; // @[UserYanker.scala 92:53]
  assign QueueCompatibility_6_io_enq_bits_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_6_io_enq_bits_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_6_io_deq_ready = auto_out_b_valid & auto_in_b_ready & bsel_1; // @[UserYanker.scala 91:53]
  assign QueueCompatibility_7_clock = clock;
  assign QueueCompatibility_7_reset = reset;
  assign QueueCompatibility_7_io_enq_valid = auto_in_aw_valid & auto_out_aw_ready & awsel_2; // @[UserYanker.scala 92:53]
  assign QueueCompatibility_7_io_enq_bits_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_7_io_enq_bits_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_7_io_deq_ready = auto_out_b_valid & auto_in_b_ready & bsel_2; // @[UserYanker.scala 91:53]
  assign QueueCompatibility_8_clock = clock;
  assign QueueCompatibility_8_reset = reset;
  assign QueueCompatibility_8_io_enq_valid = auto_in_aw_valid & auto_out_aw_ready & awsel_3; // @[UserYanker.scala 92:53]
  assign QueueCompatibility_8_io_enq_bits_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_8_io_enq_bits_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_8_io_deq_ready = auto_out_b_valid & auto_in_b_ready & bsel_3; // @[UserYanker.scala 91:53]
  assign QueueCompatibility_9_clock = clock;
  assign QueueCompatibility_9_reset = reset;
  assign QueueCompatibility_9_io_enq_valid = auto_in_aw_valid & auto_out_aw_ready & awsel_4; // @[UserYanker.scala 92:53]
  assign QueueCompatibility_9_io_enq_bits_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_9_io_enq_bits_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign QueueCompatibility_9_io_deq_ready = auto_out_b_valid & auto_in_b_ready & bsel_4; // @[UserYanker.scala 91:53]
  always @(posedge clock) begin
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~auto_out_r_valid | _GEN_31 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at UserYanker.scala:63 assert (!out.r.valid || r_valid) // Q must be ready faster than the response\n"
            ); // @[UserYanker.scala 63:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~auto_out_r_valid | _GEN_31 | reset)) begin
          $fatal; // @[UserYanker.scala 63:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~auto_out_b_valid | _GEN_95 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed\n    at UserYanker.scala:84 assert (!out.b.valid || b_valid) // Q must be ready faster than the response\n"
            ); // @[UserYanker.scala 84:14]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~auto_out_b_valid | _GEN_95 | reset)) begin
          $fatal; // @[UserYanker.scala 84:14]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
endmodule
module Queue_5(
  input         clock,
  input         reset,
  output        io_enq_ready,
  input         io_enq_valid,
  input  [3:0]  io_enq_bits_id,
  input  [63:0] io_enq_bits_data,
  input  [1:0]  io_enq_bits_resp,
  input  [3:0]  io_enq_bits_echo_tl_state_size,
  input  [4:0]  io_enq_bits_echo_tl_state_source,
  input         io_enq_bits_last,
  input         io_deq_ready,
  output        io_deq_valid,
  output [3:0]  io_deq_bits_id,
  output [63:0] io_deq_bits_data,
  output [1:0]  io_deq_bits_resp,
  output [3:0]  io_deq_bits_echo_tl_state_size,
  output [4:0]  io_deq_bits_echo_tl_state_source,
  output        io_deq_bits_last
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [63:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
`endif // RANDOMIZE_REG_INIT
  reg [3:0] ram_id [0:7]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_id_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_id_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_id_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_en; // @[Decoupled.scala 218:16]
  reg [63:0] ram_data [0:7]; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_data_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_data_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_en; // @[Decoupled.scala 218:16]
  reg [1:0] ram_resp [0:7]; // @[Decoupled.scala 218:16]
  wire [1:0] ram_resp_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_resp_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [1:0] ram_resp_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_resp_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_resp_MPORT_en; // @[Decoupled.scala 218:16]
  reg [3:0] ram_echo_tl_state_size [0:7]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_echo_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_echo_tl_state_size_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_echo_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_echo_tl_state_size_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_size_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_size_MPORT_en; // @[Decoupled.scala 218:16]
  reg [4:0] ram_echo_tl_state_source [0:7]; // @[Decoupled.scala 218:16]
  wire [4:0] ram_echo_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_echo_tl_state_source_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [4:0] ram_echo_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_echo_tl_state_source_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_source_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_source_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_last [0:7]; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_last_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_data; // @[Decoupled.scala 218:16]
  wire [2:0] ram_last_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_en; // @[Decoupled.scala 218:16]
  reg [2:0] enq_ptr_value; // @[Counter.scala 60:40]
  reg [2:0] deq_ptr_value; // @[Counter.scala 60:40]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  ptr_match = enq_ptr_value == deq_ptr_value; // @[Decoupled.scala 223:33]
  wire  empty = ptr_match & ~maybe_full; // @[Decoupled.scala 224:25]
  wire  full = ptr_match & maybe_full; // @[Decoupled.scala 225:24]
  wire  do_enq = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  do_deq = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  wire [2:0] _value_T_1 = enq_ptr_value + 3'h1; // @[Counter.scala 76:24]
  wire [2:0] _value_T_3 = deq_ptr_value + 3'h1; // @[Counter.scala 76:24]
  assign ram_id_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_id_io_deq_bits_MPORT_data = ram_id[ram_id_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_id_MPORT_data = io_enq_bits_id;
  assign ram_id_MPORT_addr = enq_ptr_value;
  assign ram_id_MPORT_mask = 1'h1;
  assign ram_id_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_data_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_data_io_deq_bits_MPORT_data = ram_data[ram_data_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_data_MPORT_data = io_enq_bits_data;
  assign ram_data_MPORT_addr = enq_ptr_value;
  assign ram_data_MPORT_mask = 1'h1;
  assign ram_data_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_resp_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_resp_io_deq_bits_MPORT_data = ram_resp[ram_resp_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_resp_MPORT_data = io_enq_bits_resp;
  assign ram_resp_MPORT_addr = enq_ptr_value;
  assign ram_resp_MPORT_mask = 1'h1;
  assign ram_resp_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_echo_tl_state_size_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_echo_tl_state_size_io_deq_bits_MPORT_data =
    ram_echo_tl_state_size[ram_echo_tl_state_size_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_echo_tl_state_size_MPORT_data = io_enq_bits_echo_tl_state_size;
  assign ram_echo_tl_state_size_MPORT_addr = enq_ptr_value;
  assign ram_echo_tl_state_size_MPORT_mask = 1'h1;
  assign ram_echo_tl_state_size_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_echo_tl_state_source_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_echo_tl_state_source_io_deq_bits_MPORT_data =
    ram_echo_tl_state_source[ram_echo_tl_state_source_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_echo_tl_state_source_MPORT_data = io_enq_bits_echo_tl_state_source;
  assign ram_echo_tl_state_source_MPORT_addr = enq_ptr_value;
  assign ram_echo_tl_state_source_MPORT_mask = 1'h1;
  assign ram_echo_tl_state_source_MPORT_en = io_enq_ready & io_enq_valid;
  assign ram_last_io_deq_bits_MPORT_addr = deq_ptr_value;
  assign ram_last_io_deq_bits_MPORT_data = ram_last[ram_last_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_last_MPORT_data = io_enq_bits_last;
  assign ram_last_MPORT_addr = enq_ptr_value;
  assign ram_last_MPORT_mask = 1'h1;
  assign ram_last_MPORT_en = io_enq_ready & io_enq_valid;
  assign io_enq_ready = ~full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = ~empty; // @[Decoupled.scala 240:19]
  assign io_deq_bits_id = ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_data = ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_resp = ram_resp_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_echo_tl_state_size = ram_echo_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_echo_tl_state_source = ram_echo_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  assign io_deq_bits_last = ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_id_MPORT_en & ram_id_MPORT_mask) begin
      ram_id[ram_id_MPORT_addr] <= ram_id_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_data_MPORT_en & ram_data_MPORT_mask) begin
      ram_data[ram_data_MPORT_addr] <= ram_data_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_resp_MPORT_en & ram_resp_MPORT_mask) begin
      ram_resp[ram_resp_MPORT_addr] <= ram_resp_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_echo_tl_state_size_MPORT_en & ram_echo_tl_state_size_MPORT_mask) begin
      ram_echo_tl_state_size[ram_echo_tl_state_size_MPORT_addr] <= ram_echo_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_echo_tl_state_source_MPORT_en & ram_echo_tl_state_source_MPORT_mask) begin
      ram_echo_tl_state_source[ram_echo_tl_state_source_MPORT_addr] <= ram_echo_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_last_MPORT_en & ram_last_MPORT_mask) begin
      ram_last[ram_last_MPORT_addr] <= ram_last_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Counter.scala 60:40]
      enq_ptr_value <= 3'h0; // @[Counter.scala 60:40]
    end else if (do_enq) begin // @[Decoupled.scala 229:17]
      enq_ptr_value <= _value_T_1; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Counter.scala 60:40]
      deq_ptr_value <= 3'h0; // @[Counter.scala 60:40]
    end else if (do_deq) begin // @[Decoupled.scala 233:17]
      deq_ptr_value <= _value_T_3; // @[Counter.scala 76:15]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      maybe_full <= do_enq; // @[Decoupled.scala 237:16]
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_id[initvar] = _RAND_0[3:0];
  _RAND_1 = {2{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_data[initvar] = _RAND_1[63:0];
  _RAND_2 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_resp[initvar] = _RAND_2[1:0];
  _RAND_3 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_echo_tl_state_size[initvar] = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_echo_tl_state_source[initvar] = _RAND_4[4:0];
  _RAND_5 = {1{`RANDOM}};
  for (initvar = 0; initvar < 8; initvar = initvar+1)
    ram_last[initvar] = _RAND_5[0:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_6 = {1{`RANDOM}};
  enq_ptr_value = _RAND_6[2:0];
  _RAND_7 = {1{`RANDOM}};
  deq_ptr_value = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  maybe_full = _RAND_8[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module AXI4Deinterleaver(
  input         clock,
  input         reset,
  output        auto_in_aw_ready,
  input         auto_in_aw_valid,
  input  [3:0]  auto_in_aw_bits_id,
  input  [30:0] auto_in_aw_bits_addr,
  input  [7:0]  auto_in_aw_bits_len,
  input  [2:0]  auto_in_aw_bits_size,
  input  [1:0]  auto_in_aw_bits_burst,
  input         auto_in_aw_bits_lock,
  input  [3:0]  auto_in_aw_bits_cache,
  input  [2:0]  auto_in_aw_bits_prot,
  input  [3:0]  auto_in_aw_bits_qos,
  input  [3:0]  auto_in_aw_bits_echo_tl_state_size,
  input  [4:0]  auto_in_aw_bits_echo_tl_state_source,
  output        auto_in_w_ready,
  input         auto_in_w_valid,
  input  [63:0] auto_in_w_bits_data,
  input  [7:0]  auto_in_w_bits_strb,
  input         auto_in_w_bits_last,
  input         auto_in_b_ready,
  output        auto_in_b_valid,
  output [3:0]  auto_in_b_bits_id,
  output [1:0]  auto_in_b_bits_resp,
  output [3:0]  auto_in_b_bits_echo_tl_state_size,
  output [4:0]  auto_in_b_bits_echo_tl_state_source,
  output        auto_in_ar_ready,
  input         auto_in_ar_valid,
  input  [3:0]  auto_in_ar_bits_id,
  input  [30:0] auto_in_ar_bits_addr,
  input  [7:0]  auto_in_ar_bits_len,
  input  [2:0]  auto_in_ar_bits_size,
  input  [1:0]  auto_in_ar_bits_burst,
  input         auto_in_ar_bits_lock,
  input  [3:0]  auto_in_ar_bits_cache,
  input  [2:0]  auto_in_ar_bits_prot,
  input  [3:0]  auto_in_ar_bits_qos,
  input  [3:0]  auto_in_ar_bits_echo_tl_state_size,
  input  [4:0]  auto_in_ar_bits_echo_tl_state_source,
  input         auto_in_r_ready,
  output        auto_in_r_valid,
  output [3:0]  auto_in_r_bits_id,
  output [63:0] auto_in_r_bits_data,
  output [1:0]  auto_in_r_bits_resp,
  output [3:0]  auto_in_r_bits_echo_tl_state_size,
  output [4:0]  auto_in_r_bits_echo_tl_state_source,
  output        auto_in_r_bits_last,
  input         auto_out_aw_ready,
  output        auto_out_aw_valid,
  output [3:0]  auto_out_aw_bits_id,
  output [30:0] auto_out_aw_bits_addr,
  output [7:0]  auto_out_aw_bits_len,
  output [2:0]  auto_out_aw_bits_size,
  output [1:0]  auto_out_aw_bits_burst,
  output        auto_out_aw_bits_lock,
  output [3:0]  auto_out_aw_bits_cache,
  output [2:0]  auto_out_aw_bits_prot,
  output [3:0]  auto_out_aw_bits_qos,
  output [3:0]  auto_out_aw_bits_echo_tl_state_size,
  output [4:0]  auto_out_aw_bits_echo_tl_state_source,
  input         auto_out_w_ready,
  output        auto_out_w_valid,
  output [63:0] auto_out_w_bits_data,
  output [7:0]  auto_out_w_bits_strb,
  output        auto_out_w_bits_last,
  output        auto_out_b_ready,
  input         auto_out_b_valid,
  input  [3:0]  auto_out_b_bits_id,
  input  [1:0]  auto_out_b_bits_resp,
  input  [3:0]  auto_out_b_bits_echo_tl_state_size,
  input  [4:0]  auto_out_b_bits_echo_tl_state_source,
  input         auto_out_ar_ready,
  output        auto_out_ar_valid,
  output [3:0]  auto_out_ar_bits_id,
  output [30:0] auto_out_ar_bits_addr,
  output [7:0]  auto_out_ar_bits_len,
  output [2:0]  auto_out_ar_bits_size,
  output [1:0]  auto_out_ar_bits_burst,
  output        auto_out_ar_bits_lock,
  output [3:0]  auto_out_ar_bits_cache,
  output [2:0]  auto_out_ar_bits_prot,
  output [3:0]  auto_out_ar_bits_qos,
  output [3:0]  auto_out_ar_bits_echo_tl_state_size,
  output [4:0]  auto_out_ar_bits_echo_tl_state_source,
  output        auto_out_r_ready,
  input         auto_out_r_valid,
  input  [3:0]  auto_out_r_bits_id,
  input  [63:0] auto_out_r_bits_data,
  input  [1:0]  auto_out_r_bits_resp,
  input  [3:0]  auto_out_r_bits_echo_tl_state_size,
  input  [4:0]  auto_out_r_bits_echo_tl_state_source,
  input         auto_out_r_bits_last
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
`endif // RANDOMIZE_REG_INIT
  wire  qs_queue_0_clock; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_reset; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_io_enq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_io_enq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_0_io_enq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_0_io_enq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_0_io_enq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_0_io_enq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_0_io_enq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_io_enq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_io_deq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_io_deq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_0_io_deq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_0_io_deq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_0_io_deq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_0_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_0_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_0_io_deq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_clock; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_reset; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_io_enq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_io_enq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_1_io_enq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_1_io_enq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_1_io_enq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_1_io_enq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_1_io_enq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_io_enq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_io_deq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_io_deq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_1_io_deq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_1_io_deq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_1_io_deq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_1_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_1_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_1_io_deq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_clock; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_reset; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_io_enq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_io_enq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_2_io_enq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_2_io_enq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_2_io_enq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_2_io_enq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_2_io_enq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_io_enq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_io_deq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_io_deq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_2_io_deq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_2_io_deq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_2_io_deq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_2_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_2_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_2_io_deq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_clock; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_reset; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_io_enq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_io_enq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_3_io_enq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_3_io_enq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_3_io_enq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_3_io_enq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_3_io_enq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_io_enq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_io_deq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_io_deq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_3_io_deq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_3_io_deq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_3_io_deq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_3_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_3_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_3_io_deq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_clock; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_reset; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_io_enq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_io_enq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_4_io_enq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_4_io_enq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_4_io_enq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_4_io_enq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_4_io_enq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_io_enq_bits_last; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_io_deq_ready; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_io_deq_valid; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_4_io_deq_bits_id; // @[Deinterleaver.scala 66:27]
  wire [63:0] qs_queue_4_io_deq_bits_data; // @[Deinterleaver.scala 66:27]
  wire [1:0] qs_queue_4_io_deq_bits_resp; // @[Deinterleaver.scala 66:27]
  wire [3:0] qs_queue_4_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 66:27]
  wire [4:0] qs_queue_4_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 66:27]
  wire  qs_queue_4_io_deq_bits_last; // @[Deinterleaver.scala 66:27]
  wire [15:0] enq_OH = 16'h1 << auto_out_r_bits_id; // @[OneHot.scala 65:12]
  wire  enq_OH_bools_5 = enq_OH[5]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_5_enq_valid = enq_OH_bools_5 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_6 = enq_OH[6]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_6_enq_valid = enq_OH_bools_6 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_7 = enq_OH[7]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_7_enq_valid = enq_OH_bools_7 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_8 = enq_OH[8]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_8_enq_valid = enq_OH_bools_8 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_9 = enq_OH[9]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_9_enq_valid = enq_OH_bools_9 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_10 = enq_OH[10]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_10_enq_valid = enq_OH_bools_10 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_11 = enq_OH[11]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_11_enq_valid = enq_OH_bools_11 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_12 = enq_OH[12]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_12_enq_valid = enq_OH_bools_12 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_13 = enq_OH[13]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_13_enq_valid = enq_OH_bools_13 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_14 = enq_OH[14]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_14_enq_valid = enq_OH_bools_14 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  wire  enq_OH_bools_15 = enq_OH[15]; // @[Deinterleaver.scala 122:35]
  wire  queue_wire_15_enq_valid = enq_OH_bools_15 & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  reg  locked; // @[Deinterleaver.scala 82:29]
  reg [3:0] deq_id; // @[Deinterleaver.scala 83:25]
  wire [15:0] deq_OH = 16'h1 << deq_id; // @[OneHot.scala 65:12]
  reg [3:0] pending_count; // @[Deinterleaver.scala 92:32]
  wire  enq_readys_4 = qs_queue_4_io_enq_ready; // @[Deinterleaver.scala 125:33 Deinterleaver.scala 125:33]
  wire  enq_readys_3 = qs_queue_3_io_enq_ready; // @[Deinterleaver.scala 125:33 Deinterleaver.scala 125:33]
  wire  enq_readys_2 = qs_queue_2_io_enq_ready; // @[Deinterleaver.scala 125:33 Deinterleaver.scala 125:33]
  wire  enq_readys_1 = qs_queue_1_io_enq_ready; // @[Deinterleaver.scala 125:33 Deinterleaver.scala 125:33]
  wire  enq_readys_0 = qs_queue_0_io_enq_ready; // @[Deinterleaver.scala 125:33 Deinterleaver.scala 125:33]
  wire  _GEN_99 = 4'h1 == auto_out_r_bits_id ? enq_readys_1 : enq_readys_0; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_100 = 4'h2 == auto_out_r_bits_id ? enq_readys_2 : _GEN_99; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_101 = 4'h3 == auto_out_r_bits_id ? enq_readys_3 : _GEN_100; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_102 = 4'h4 == auto_out_r_bits_id ? enq_readys_4 : _GEN_101; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_103 = 4'h5 == auto_out_r_bits_id ? 1'h0 : _GEN_102; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_104 = 4'h6 == auto_out_r_bits_id ? 1'h0 : _GEN_103; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_105 = 4'h7 == auto_out_r_bits_id ? 1'h0 : _GEN_104; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_106 = 4'h8 == auto_out_r_bits_id ? 1'h0 : _GEN_105; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_107 = 4'h9 == auto_out_r_bits_id ? 1'h0 : _GEN_106; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_108 = 4'ha == auto_out_r_bits_id ? 1'h0 : _GEN_107; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_109 = 4'hb == auto_out_r_bits_id ? 1'h0 : _GEN_108; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_110 = 4'hc == auto_out_r_bits_id ? 1'h0 : _GEN_109; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_111 = 4'hd == auto_out_r_bits_id ? 1'h0 : _GEN_110; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _GEN_112 = 4'he == auto_out_r_bits_id ? 1'h0 : _GEN_111; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  auto_data_1_r_ready = 4'hf == auto_out_r_bits_id ? 1'h0 : _GEN_112; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  wire  _pending_inc_T_1 = auto_data_1_r_ready & auto_out_r_valid; // @[Decoupled.scala 40:37]
  wire  pending_inc = enq_OH[0] & _pending_inc_T_1 & auto_out_r_bits_last; // @[Deinterleaver.scala 94:49]
  wire  _pending_dec_T_1 = auto_in_r_ready & locked; // @[Decoupled.scala 40:37]
  wire  deq_bits_4_last = qs_queue_4_io_deq_bits_last; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire  deq_bits_3_last = qs_queue_3_io_deq_bits_last; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire  deq_bits_2_last = qs_queue_2_io_deq_bits_last; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire  deq_bits_1_last = qs_queue_1_io_deq_bits_last; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire  deq_bits_0_last = qs_queue_0_io_deq_bits_last; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire  _GEN_13 = 4'h1 == deq_id ? deq_bits_1_last : deq_bits_0_last; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_19 = 4'h2 == deq_id ? deq_bits_2_last : _GEN_13; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_25 = 4'h3 == deq_id ? deq_bits_3_last : _GEN_19; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_31 = 4'h4 == deq_id ? deq_bits_4_last : _GEN_25; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_37 = 4'h5 == deq_id ? 1'h0 : _GEN_31; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_43 = 4'h6 == deq_id ? 1'h0 : _GEN_37; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_49 = 4'h7 == deq_id ? 1'h0 : _GEN_43; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_55 = 4'h8 == deq_id ? 1'h0 : _GEN_49; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_61 = 4'h9 == deq_id ? 1'h0 : _GEN_55; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_67 = 4'ha == deq_id ? 1'h0 : _GEN_61; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_73 = 4'hb == deq_id ? 1'h0 : _GEN_67; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_79 = 4'hc == deq_id ? 1'h0 : _GEN_73; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_85 = 4'hd == deq_id ? 1'h0 : _GEN_79; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  _GEN_91 = 4'he == deq_id ? 1'h0 : _GEN_85; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  auto_data_r_bits_last = 4'hf == deq_id ? 1'h0 : _GEN_91; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire  pending_dec = deq_OH[0] & _pending_dec_T_1 & auto_data_r_bits_last; // @[Deinterleaver.scala 95:48]
  wire [3:0] _GEN_114 = {{3'd0}, pending_inc}; // @[Deinterleaver.scala 96:27]
  wire [3:0] _pending_next_T_1 = pending_count + _GEN_114; // @[Deinterleaver.scala 96:27]
  wire [3:0] _GEN_115 = {{3'd0}, pending_dec}; // @[Deinterleaver.scala 96:40]
  wire [3:0] pending_next = _pending_next_T_1 - _GEN_115; // @[Deinterleaver.scala 96:40]
  wire  pending_lo_lo_lo_lo = pending_next != 4'h0; // @[Deinterleaver.scala 101:18]
  reg [3:0] pending_count_1; // @[Deinterleaver.scala 92:32]
  wire  pending_inc_1 = enq_OH[1] & _pending_inc_T_1 & auto_out_r_bits_last; // @[Deinterleaver.scala 94:49]
  wire  pending_dec_1 = deq_OH[1] & _pending_dec_T_1 & auto_data_r_bits_last; // @[Deinterleaver.scala 95:48]
  wire [3:0] _GEN_116 = {{3'd0}, pending_inc_1}; // @[Deinterleaver.scala 96:27]
  wire [3:0] _pending_next_T_5 = pending_count_1 + _GEN_116; // @[Deinterleaver.scala 96:27]
  wire [3:0] _GEN_117 = {{3'd0}, pending_dec_1}; // @[Deinterleaver.scala 96:40]
  wire [3:0] pending_next_1 = _pending_next_T_5 - _GEN_117; // @[Deinterleaver.scala 96:40]
  wire  pending_lo_lo_lo_hi = pending_next_1 != 4'h0; // @[Deinterleaver.scala 101:18]
  reg [3:0] pending_count_2; // @[Deinterleaver.scala 92:32]
  wire  pending_inc_2 = enq_OH[2] & _pending_inc_T_1 & auto_out_r_bits_last; // @[Deinterleaver.scala 94:49]
  wire  pending_dec_2 = deq_OH[2] & _pending_dec_T_1 & auto_data_r_bits_last; // @[Deinterleaver.scala 95:48]
  wire [3:0] _GEN_118 = {{3'd0}, pending_inc_2}; // @[Deinterleaver.scala 96:27]
  wire [3:0] _pending_next_T_9 = pending_count_2 + _GEN_118; // @[Deinterleaver.scala 96:27]
  wire [3:0] _GEN_119 = {{3'd0}, pending_dec_2}; // @[Deinterleaver.scala 96:40]
  wire [3:0] pending_next_2 = _pending_next_T_9 - _GEN_119; // @[Deinterleaver.scala 96:40]
  wire  pending_lo_lo_hi_lo = pending_next_2 != 4'h0; // @[Deinterleaver.scala 101:18]
  reg [3:0] pending_count_3; // @[Deinterleaver.scala 92:32]
  wire  pending_inc_3 = enq_OH[3] & _pending_inc_T_1 & auto_out_r_bits_last; // @[Deinterleaver.scala 94:49]
  wire  pending_dec_3 = deq_OH[3] & _pending_dec_T_1 & auto_data_r_bits_last; // @[Deinterleaver.scala 95:48]
  wire [3:0] _GEN_120 = {{3'd0}, pending_inc_3}; // @[Deinterleaver.scala 96:27]
  wire [3:0] _pending_next_T_13 = pending_count_3 + _GEN_120; // @[Deinterleaver.scala 96:27]
  wire [3:0] _GEN_121 = {{3'd0}, pending_dec_3}; // @[Deinterleaver.scala 96:40]
  wire [3:0] pending_next_3 = _pending_next_T_13 - _GEN_121; // @[Deinterleaver.scala 96:40]
  wire  pending_lo_lo_hi_hi = pending_next_3 != 4'h0; // @[Deinterleaver.scala 101:18]
  reg [3:0] pending_count_4; // @[Deinterleaver.scala 92:32]
  wire  pending_inc_4 = enq_OH[4] & _pending_inc_T_1 & auto_out_r_bits_last; // @[Deinterleaver.scala 94:49]
  wire  pending_dec_4 = deq_OH[4] & _pending_dec_T_1 & auto_data_r_bits_last; // @[Deinterleaver.scala 95:48]
  wire [3:0] _GEN_122 = {{3'd0}, pending_inc_4}; // @[Deinterleaver.scala 96:27]
  wire [3:0] _pending_next_T_17 = pending_count_4 + _GEN_122; // @[Deinterleaver.scala 96:27]
  wire [3:0] _GEN_123 = {{3'd0}, pending_dec_4}; // @[Deinterleaver.scala 96:40]
  wire [3:0] pending_next_4 = _pending_next_T_17 - _GEN_123; // @[Deinterleaver.scala 96:40]
  wire  pending_lo_hi_lo_lo = pending_next_4 != 4'h0; // @[Deinterleaver.scala 101:18]
  wire [15:0] pending = {8'h0,2'h0,1'h0,pending_lo_hi_lo_lo,pending_lo_lo_hi_hi,pending_lo_lo_hi_lo,pending_lo_lo_lo_hi,
    pending_lo_lo_lo_lo}; // @[Cat.scala 30:58]
  wire [16:0] _winner_T = {pending, 1'h0}; // @[package.scala 244:48]
  wire [15:0] _winner_T_2 = pending | _winner_T[15:0]; // @[package.scala 244:43]
  wire [17:0] _winner_T_3 = {_winner_T_2, 2'h0}; // @[package.scala 244:48]
  wire [15:0] _winner_T_5 = _winner_T_2 | _winner_T_3[15:0]; // @[package.scala 244:43]
  wire [19:0] _winner_T_6 = {_winner_T_5, 4'h0}; // @[package.scala 244:48]
  wire [15:0] _winner_T_8 = _winner_T_5 | _winner_T_6[15:0]; // @[package.scala 244:43]
  wire [23:0] _winner_T_9 = {_winner_T_8, 8'h0}; // @[package.scala 244:48]
  wire [15:0] _winner_T_11 = _winner_T_8 | _winner_T_9[15:0]; // @[package.scala 244:43]
  wire [16:0] _winner_T_13 = {_winner_T_11, 1'h0}; // @[Deinterleaver.scala 106:51]
  wire [16:0] _winner_T_14 = ~_winner_T_13; // @[Deinterleaver.scala 106:33]
  wire [16:0] _GEN_124 = {{1'd0}, pending}; // @[Deinterleaver.scala 106:31]
  wire [16:0] winner = _GEN_124 & _winner_T_14; // @[Deinterleaver.scala 106:31]
  wire  deq_id_hi = winner[16]; // @[OneHot.scala 30:18]
  wire [15:0] deq_id_lo = winner[15:0]; // @[OneHot.scala 31:18]
  wire  deq_id_hi_1 = |deq_id_hi; // @[OneHot.scala 32:14]
  wire [15:0] _GEN_125 = {{15'd0}, deq_id_hi}; // @[OneHot.scala 32:28]
  wire [15:0] _deq_id_T = _GEN_125 | deq_id_lo; // @[OneHot.scala 32:28]
  wire [7:0] deq_id_hi_2 = _deq_id_T[15:8]; // @[OneHot.scala 30:18]
  wire [7:0] deq_id_lo_1 = _deq_id_T[7:0]; // @[OneHot.scala 31:18]
  wire  deq_id_hi_3 = |deq_id_hi_2; // @[OneHot.scala 32:14]
  wire [7:0] _deq_id_T_1 = deq_id_hi_2 | deq_id_lo_1; // @[OneHot.scala 32:28]
  wire [3:0] deq_id_hi_4 = _deq_id_T_1[7:4]; // @[OneHot.scala 30:18]
  wire [3:0] deq_id_lo_2 = _deq_id_T_1[3:0]; // @[OneHot.scala 31:18]
  wire  deq_id_hi_5 = |deq_id_hi_4; // @[OneHot.scala 32:14]
  wire [3:0] _deq_id_T_2 = deq_id_hi_4 | deq_id_lo_2; // @[OneHot.scala 32:28]
  wire [1:0] deq_id_hi_6 = _deq_id_T_2[3:2]; // @[OneHot.scala 30:18]
  wire [1:0] deq_id_lo_3 = _deq_id_T_2[1:0]; // @[OneHot.scala 31:18]
  wire  deq_id_hi_7 = |deq_id_hi_6; // @[OneHot.scala 32:14]
  wire [1:0] _deq_id_T_3 = deq_id_hi_6 | deq_id_lo_3; // @[OneHot.scala 32:28]
  wire  deq_id_lo_4 = _deq_id_T_3[1]; // @[CircuitMath.scala 30:8]
  wire [4:0] _deq_id_T_4 = {deq_id_hi_1,deq_id_hi_3,deq_id_hi_5,deq_id_hi_7,deq_id_lo_4}; // @[Cat.scala 30:58]
  wire [4:0] _GEN_1 = ~locked | _pending_dec_T_1 & auto_data_r_bits_last ? _deq_id_T_4 : {{1'd0}, deq_id}; // @[Deinterleaver.scala 107:59 Deinterleaver.scala 109:18 Deinterleaver.scala 83:25]
  wire [3:0] deq_bits_0_id = qs_queue_0_io_deq_bits_id; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [63:0] deq_bits_0_data = qs_queue_0_io_deq_bits_data; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [1:0] deq_bits_0_resp = qs_queue_0_io_deq_bits_resp; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] deq_bits_0_echo_tl_state_size = qs_queue_0_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [4:0] deq_bits_0_echo_tl_state_source = qs_queue_0_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] deq_bits_1_id = qs_queue_1_io_deq_bits_id; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_8 = 4'h1 == deq_id ? deq_bits_1_id : deq_bits_0_id; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] deq_bits_1_data = qs_queue_1_io_deq_bits_data; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [63:0] _GEN_9 = 4'h1 == deq_id ? deq_bits_1_data : deq_bits_0_data; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] deq_bits_1_resp = qs_queue_1_io_deq_bits_resp; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [1:0] _GEN_10 = 4'h1 == deq_id ? deq_bits_1_resp : deq_bits_0_resp; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_1_echo_tl_state_size = qs_queue_1_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_11 = 4'h1 == deq_id ? deq_bits_1_echo_tl_state_size : deq_bits_0_echo_tl_state_size; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] deq_bits_1_echo_tl_state_source = qs_queue_1_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [4:0] _GEN_12 = 4'h1 == deq_id ? deq_bits_1_echo_tl_state_source : deq_bits_0_echo_tl_state_source; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_2_id = qs_queue_2_io_deq_bits_id; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_14 = 4'h2 == deq_id ? deq_bits_2_id : _GEN_8; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] deq_bits_2_data = qs_queue_2_io_deq_bits_data; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [63:0] _GEN_15 = 4'h2 == deq_id ? deq_bits_2_data : _GEN_9; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] deq_bits_2_resp = qs_queue_2_io_deq_bits_resp; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [1:0] _GEN_16 = 4'h2 == deq_id ? deq_bits_2_resp : _GEN_10; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_2_echo_tl_state_size = qs_queue_2_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_17 = 4'h2 == deq_id ? deq_bits_2_echo_tl_state_size : _GEN_11; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] deq_bits_2_echo_tl_state_source = qs_queue_2_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [4:0] _GEN_18 = 4'h2 == deq_id ? deq_bits_2_echo_tl_state_source : _GEN_12; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_3_id = qs_queue_3_io_deq_bits_id; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_20 = 4'h3 == deq_id ? deq_bits_3_id : _GEN_14; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] deq_bits_3_data = qs_queue_3_io_deq_bits_data; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [63:0] _GEN_21 = 4'h3 == deq_id ? deq_bits_3_data : _GEN_15; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] deq_bits_3_resp = qs_queue_3_io_deq_bits_resp; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [1:0] _GEN_22 = 4'h3 == deq_id ? deq_bits_3_resp : _GEN_16; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_3_echo_tl_state_size = qs_queue_3_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_23 = 4'h3 == deq_id ? deq_bits_3_echo_tl_state_size : _GEN_17; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] deq_bits_3_echo_tl_state_source = qs_queue_3_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [4:0] _GEN_24 = 4'h3 == deq_id ? deq_bits_3_echo_tl_state_source : _GEN_18; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_4_id = qs_queue_4_io_deq_bits_id; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_26 = 4'h4 == deq_id ? deq_bits_4_id : _GEN_20; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] deq_bits_4_data = qs_queue_4_io_deq_bits_data; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [63:0] _GEN_27 = 4'h4 == deq_id ? deq_bits_4_data : _GEN_21; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] deq_bits_4_resp = qs_queue_4_io_deq_bits_resp; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [1:0] _GEN_28 = 4'h4 == deq_id ? deq_bits_4_resp : _GEN_22; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] deq_bits_4_echo_tl_state_size = qs_queue_4_io_deq_bits_echo_tl_state_size; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [3:0] _GEN_29 = 4'h4 == deq_id ? deq_bits_4_echo_tl_state_size : _GEN_23; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] deq_bits_4_echo_tl_state_source = qs_queue_4_io_deq_bits_echo_tl_state_source; // @[Deinterleaver.scala 114:31 Deinterleaver.scala 114:31]
  wire [4:0] _GEN_30 = 4'h4 == deq_id ? deq_bits_4_echo_tl_state_source : _GEN_24; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_32 = 4'h5 == deq_id ? 4'h0 : _GEN_26; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_33 = 4'h5 == deq_id ? 64'h0 : _GEN_27; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_34 = 4'h5 == deq_id ? 2'h0 : _GEN_28; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_35 = 4'h5 == deq_id ? 4'h0 : _GEN_29; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_36 = 4'h5 == deq_id ? 5'h0 : _GEN_30; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_38 = 4'h6 == deq_id ? 4'h0 : _GEN_32; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_39 = 4'h6 == deq_id ? 64'h0 : _GEN_33; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_40 = 4'h6 == deq_id ? 2'h0 : _GEN_34; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_41 = 4'h6 == deq_id ? 4'h0 : _GEN_35; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_42 = 4'h6 == deq_id ? 5'h0 : _GEN_36; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_44 = 4'h7 == deq_id ? 4'h0 : _GEN_38; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_45 = 4'h7 == deq_id ? 64'h0 : _GEN_39; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_46 = 4'h7 == deq_id ? 2'h0 : _GEN_40; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_47 = 4'h7 == deq_id ? 4'h0 : _GEN_41; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_48 = 4'h7 == deq_id ? 5'h0 : _GEN_42; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_50 = 4'h8 == deq_id ? 4'h0 : _GEN_44; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_51 = 4'h8 == deq_id ? 64'h0 : _GEN_45; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_52 = 4'h8 == deq_id ? 2'h0 : _GEN_46; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_53 = 4'h8 == deq_id ? 4'h0 : _GEN_47; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_54 = 4'h8 == deq_id ? 5'h0 : _GEN_48; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_56 = 4'h9 == deq_id ? 4'h0 : _GEN_50; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_57 = 4'h9 == deq_id ? 64'h0 : _GEN_51; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_58 = 4'h9 == deq_id ? 2'h0 : _GEN_52; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_59 = 4'h9 == deq_id ? 4'h0 : _GEN_53; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_60 = 4'h9 == deq_id ? 5'h0 : _GEN_54; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_62 = 4'ha == deq_id ? 4'h0 : _GEN_56; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_63 = 4'ha == deq_id ? 64'h0 : _GEN_57; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_64 = 4'ha == deq_id ? 2'h0 : _GEN_58; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_65 = 4'ha == deq_id ? 4'h0 : _GEN_59; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_66 = 4'ha == deq_id ? 5'h0 : _GEN_60; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_68 = 4'hb == deq_id ? 4'h0 : _GEN_62; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_69 = 4'hb == deq_id ? 64'h0 : _GEN_63; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_70 = 4'hb == deq_id ? 2'h0 : _GEN_64; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_71 = 4'hb == deq_id ? 4'h0 : _GEN_65; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_72 = 4'hb == deq_id ? 5'h0 : _GEN_66; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_74 = 4'hc == deq_id ? 4'h0 : _GEN_68; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_75 = 4'hc == deq_id ? 64'h0 : _GEN_69; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_76 = 4'hc == deq_id ? 2'h0 : _GEN_70; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_77 = 4'hc == deq_id ? 4'h0 : _GEN_71; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_78 = 4'hc == deq_id ? 5'h0 : _GEN_72; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_80 = 4'hd == deq_id ? 4'h0 : _GEN_74; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_81 = 4'hd == deq_id ? 64'h0 : _GEN_75; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_82 = 4'hd == deq_id ? 2'h0 : _GEN_76; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_83 = 4'hd == deq_id ? 4'h0 : _GEN_77; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_84 = 4'hd == deq_id ? 5'h0 : _GEN_78; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_86 = 4'he == deq_id ? 4'h0 : _GEN_80; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [63:0] _GEN_87 = 4'he == deq_id ? 64'h0 : _GEN_81; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [1:0] _GEN_88 = 4'he == deq_id ? 2'h0 : _GEN_82; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [3:0] _GEN_89 = 4'he == deq_id ? 4'h0 : _GEN_83; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  wire [4:0] _GEN_90 = 4'he == deq_id ? 5'h0 : _GEN_84; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  Queue_5 qs_queue_0 ( // @[Deinterleaver.scala 66:27]
    .clock(qs_queue_0_clock),
    .reset(qs_queue_0_reset),
    .io_enq_ready(qs_queue_0_io_enq_ready),
    .io_enq_valid(qs_queue_0_io_enq_valid),
    .io_enq_bits_id(qs_queue_0_io_enq_bits_id),
    .io_enq_bits_data(qs_queue_0_io_enq_bits_data),
    .io_enq_bits_resp(qs_queue_0_io_enq_bits_resp),
    .io_enq_bits_echo_tl_state_size(qs_queue_0_io_enq_bits_echo_tl_state_size),
    .io_enq_bits_echo_tl_state_source(qs_queue_0_io_enq_bits_echo_tl_state_source),
    .io_enq_bits_last(qs_queue_0_io_enq_bits_last),
    .io_deq_ready(qs_queue_0_io_deq_ready),
    .io_deq_valid(qs_queue_0_io_deq_valid),
    .io_deq_bits_id(qs_queue_0_io_deq_bits_id),
    .io_deq_bits_data(qs_queue_0_io_deq_bits_data),
    .io_deq_bits_resp(qs_queue_0_io_deq_bits_resp),
    .io_deq_bits_echo_tl_state_size(qs_queue_0_io_deq_bits_echo_tl_state_size),
    .io_deq_bits_echo_tl_state_source(qs_queue_0_io_deq_bits_echo_tl_state_source),
    .io_deq_bits_last(qs_queue_0_io_deq_bits_last)
  );
  Queue_5 qs_queue_1 ( // @[Deinterleaver.scala 66:27]
    .clock(qs_queue_1_clock),
    .reset(qs_queue_1_reset),
    .io_enq_ready(qs_queue_1_io_enq_ready),
    .io_enq_valid(qs_queue_1_io_enq_valid),
    .io_enq_bits_id(qs_queue_1_io_enq_bits_id),
    .io_enq_bits_data(qs_queue_1_io_enq_bits_data),
    .io_enq_bits_resp(qs_queue_1_io_enq_bits_resp),
    .io_enq_bits_echo_tl_state_size(qs_queue_1_io_enq_bits_echo_tl_state_size),
    .io_enq_bits_echo_tl_state_source(qs_queue_1_io_enq_bits_echo_tl_state_source),
    .io_enq_bits_last(qs_queue_1_io_enq_bits_last),
    .io_deq_ready(qs_queue_1_io_deq_ready),
    .io_deq_valid(qs_queue_1_io_deq_valid),
    .io_deq_bits_id(qs_queue_1_io_deq_bits_id),
    .io_deq_bits_data(qs_queue_1_io_deq_bits_data),
    .io_deq_bits_resp(qs_queue_1_io_deq_bits_resp),
    .io_deq_bits_echo_tl_state_size(qs_queue_1_io_deq_bits_echo_tl_state_size),
    .io_deq_bits_echo_tl_state_source(qs_queue_1_io_deq_bits_echo_tl_state_source),
    .io_deq_bits_last(qs_queue_1_io_deq_bits_last)
  );
  Queue_5 qs_queue_2 ( // @[Deinterleaver.scala 66:27]
    .clock(qs_queue_2_clock),
    .reset(qs_queue_2_reset),
    .io_enq_ready(qs_queue_2_io_enq_ready),
    .io_enq_valid(qs_queue_2_io_enq_valid),
    .io_enq_bits_id(qs_queue_2_io_enq_bits_id),
    .io_enq_bits_data(qs_queue_2_io_enq_bits_data),
    .io_enq_bits_resp(qs_queue_2_io_enq_bits_resp),
    .io_enq_bits_echo_tl_state_size(qs_queue_2_io_enq_bits_echo_tl_state_size),
    .io_enq_bits_echo_tl_state_source(qs_queue_2_io_enq_bits_echo_tl_state_source),
    .io_enq_bits_last(qs_queue_2_io_enq_bits_last),
    .io_deq_ready(qs_queue_2_io_deq_ready),
    .io_deq_valid(qs_queue_2_io_deq_valid),
    .io_deq_bits_id(qs_queue_2_io_deq_bits_id),
    .io_deq_bits_data(qs_queue_2_io_deq_bits_data),
    .io_deq_bits_resp(qs_queue_2_io_deq_bits_resp),
    .io_deq_bits_echo_tl_state_size(qs_queue_2_io_deq_bits_echo_tl_state_size),
    .io_deq_bits_echo_tl_state_source(qs_queue_2_io_deq_bits_echo_tl_state_source),
    .io_deq_bits_last(qs_queue_2_io_deq_bits_last)
  );
  Queue_5 qs_queue_3 ( // @[Deinterleaver.scala 66:27]
    .clock(qs_queue_3_clock),
    .reset(qs_queue_3_reset),
    .io_enq_ready(qs_queue_3_io_enq_ready),
    .io_enq_valid(qs_queue_3_io_enq_valid),
    .io_enq_bits_id(qs_queue_3_io_enq_bits_id),
    .io_enq_bits_data(qs_queue_3_io_enq_bits_data),
    .io_enq_bits_resp(qs_queue_3_io_enq_bits_resp),
    .io_enq_bits_echo_tl_state_size(qs_queue_3_io_enq_bits_echo_tl_state_size),
    .io_enq_bits_echo_tl_state_source(qs_queue_3_io_enq_bits_echo_tl_state_source),
    .io_enq_bits_last(qs_queue_3_io_enq_bits_last),
    .io_deq_ready(qs_queue_3_io_deq_ready),
    .io_deq_valid(qs_queue_3_io_deq_valid),
    .io_deq_bits_id(qs_queue_3_io_deq_bits_id),
    .io_deq_bits_data(qs_queue_3_io_deq_bits_data),
    .io_deq_bits_resp(qs_queue_3_io_deq_bits_resp),
    .io_deq_bits_echo_tl_state_size(qs_queue_3_io_deq_bits_echo_tl_state_size),
    .io_deq_bits_echo_tl_state_source(qs_queue_3_io_deq_bits_echo_tl_state_source),
    .io_deq_bits_last(qs_queue_3_io_deq_bits_last)
  );
  Queue_5 qs_queue_4 ( // @[Deinterleaver.scala 66:27]
    .clock(qs_queue_4_clock),
    .reset(qs_queue_4_reset),
    .io_enq_ready(qs_queue_4_io_enq_ready),
    .io_enq_valid(qs_queue_4_io_enq_valid),
    .io_enq_bits_id(qs_queue_4_io_enq_bits_id),
    .io_enq_bits_data(qs_queue_4_io_enq_bits_data),
    .io_enq_bits_resp(qs_queue_4_io_enq_bits_resp),
    .io_enq_bits_echo_tl_state_size(qs_queue_4_io_enq_bits_echo_tl_state_size),
    .io_enq_bits_echo_tl_state_source(qs_queue_4_io_enq_bits_echo_tl_state_source),
    .io_enq_bits_last(qs_queue_4_io_enq_bits_last),
    .io_deq_ready(qs_queue_4_io_deq_ready),
    .io_deq_valid(qs_queue_4_io_deq_valid),
    .io_deq_bits_id(qs_queue_4_io_deq_bits_id),
    .io_deq_bits_data(qs_queue_4_io_deq_bits_data),
    .io_deq_bits_resp(qs_queue_4_io_deq_bits_resp),
    .io_deq_bits_echo_tl_state_size(qs_queue_4_io_deq_bits_echo_tl_state_size),
    .io_deq_bits_echo_tl_state_source(qs_queue_4_io_deq_bits_echo_tl_state_source),
    .io_deq_bits_last(qs_queue_4_io_deq_bits_last)
  );
  assign auto_in_aw_ready = auto_out_aw_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_w_ready = auto_out_w_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_valid = auto_out_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_id = auto_out_b_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_resp = auto_out_b_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_echo_tl_state_size = auto_out_b_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_echo_tl_state_source = auto_out_b_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_ar_ready = auto_out_ar_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_valid = locked; // @[Nodes.scala 1210:84 Deinterleaver.scala 113:20]
  assign auto_in_r_bits_id = 4'hf == deq_id ? 4'h0 : _GEN_86; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  assign auto_in_r_bits_data = 4'hf == deq_id ? 64'h0 : _GEN_87; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  assign auto_in_r_bits_resp = 4'hf == deq_id ? 2'h0 : _GEN_88; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  assign auto_in_r_bits_echo_tl_state_size = 4'hf == deq_id ? 4'h0 : _GEN_89; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  assign auto_in_r_bits_echo_tl_state_source = 4'hf == deq_id ? 5'h0 : _GEN_90; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  assign auto_in_r_bits_last = 4'hf == deq_id ? 1'h0 : _GEN_91; // @[Deinterleaver.scala 115:20 Deinterleaver.scala 115:20]
  assign auto_out_aw_valid = auto_in_aw_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_id = auto_in_aw_bits_id; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_addr = auto_in_aw_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_len = auto_in_aw_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_size = auto_in_aw_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_burst = auto_in_aw_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_lock = auto_in_aw_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_cache = auto_in_aw_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_prot = auto_in_aw_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_qos = auto_in_aw_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_echo_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_echo_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_valid = auto_in_w_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_data = auto_in_w_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_strb = auto_in_w_bits_strb; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_last = auto_in_w_bits_last; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_b_ready = auto_in_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_valid = auto_in_ar_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_id = auto_in_ar_bits_id; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_addr = auto_in_ar_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_len = auto_in_ar_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_size = auto_in_ar_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_burst = auto_in_ar_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_lock = auto_in_ar_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_cache = auto_in_ar_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_prot = auto_in_ar_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_qos = auto_in_ar_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_echo_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_echo_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_r_ready = 4'hf == auto_out_r_bits_id ? 1'h0 : _GEN_112; // @[Deinterleaver.scala 126:21 Deinterleaver.scala 126:21]
  assign qs_queue_0_clock = clock;
  assign qs_queue_0_reset = reset;
  assign qs_queue_0_io_enq_valid = enq_OH[0] & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  assign qs_queue_0_io_enq_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_0_io_enq_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_0_io_enq_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_0_io_enq_bits_echo_tl_state_size = auto_out_r_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_0_io_enq_bits_echo_tl_state_source = auto_out_r_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_0_io_enq_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_0_io_deq_ready = deq_OH[0] & _pending_dec_T_1; // @[Deinterleaver.scala 119:28]
  assign qs_queue_1_clock = clock;
  assign qs_queue_1_reset = reset;
  assign qs_queue_1_io_enq_valid = enq_OH[1] & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  assign qs_queue_1_io_enq_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_1_io_enq_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_1_io_enq_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_1_io_enq_bits_echo_tl_state_size = auto_out_r_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_1_io_enq_bits_echo_tl_state_source = auto_out_r_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_1_io_enq_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_1_io_deq_ready = deq_OH[1] & _pending_dec_T_1; // @[Deinterleaver.scala 119:28]
  assign qs_queue_2_clock = clock;
  assign qs_queue_2_reset = reset;
  assign qs_queue_2_io_enq_valid = enq_OH[2] & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  assign qs_queue_2_io_enq_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_2_io_enq_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_2_io_enq_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_2_io_enq_bits_echo_tl_state_size = auto_out_r_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_2_io_enq_bits_echo_tl_state_source = auto_out_r_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_2_io_enq_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_2_io_deq_ready = deq_OH[2] & _pending_dec_T_1; // @[Deinterleaver.scala 119:28]
  assign qs_queue_3_clock = clock;
  assign qs_queue_3_reset = reset;
  assign qs_queue_3_io_enq_valid = enq_OH[3] & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  assign qs_queue_3_io_enq_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_3_io_enq_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_3_io_enq_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_3_io_enq_bits_echo_tl_state_size = auto_out_r_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_3_io_enq_bits_echo_tl_state_source = auto_out_r_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_3_io_enq_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_3_io_deq_ready = deq_OH[3] & _pending_dec_T_1; // @[Deinterleaver.scala 119:28]
  assign qs_queue_4_clock = clock;
  assign qs_queue_4_reset = reset;
  assign qs_queue_4_io_enq_valid = enq_OH[4] & auto_out_r_valid; // @[Deinterleaver.scala 128:28]
  assign qs_queue_4_io_enq_bits_id = auto_out_r_bits_id; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_4_io_enq_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_4_io_enq_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_4_io_enq_bits_echo_tl_state_size = auto_out_r_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_4_io_enq_bits_echo_tl_state_source = auto_out_r_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_4_io_enq_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign qs_queue_4_io_deq_ready = deq_OH[4] & _pending_dec_T_1; // @[Deinterleaver.scala 119:28]
  always @(posedge clock) begin
    if (reset) begin // @[Deinterleaver.scala 82:29]
      locked <= 1'h0; // @[Deinterleaver.scala 82:29]
    end else if (~locked | _pending_dec_T_1 & auto_data_r_bits_last) begin // @[Deinterleaver.scala 107:59]
      locked <= |pending; // @[Deinterleaver.scala 108:18]
    end
    deq_id <= _GEN_1[3:0];
    if (reset) begin // @[Deinterleaver.scala 92:32]
      pending_count <= 4'h0; // @[Deinterleaver.scala 92:32]
    end else begin
      pending_count <= pending_next; // @[Deinterleaver.scala 97:19]
    end
    if (reset) begin // @[Deinterleaver.scala 92:32]
      pending_count_1 <= 4'h0; // @[Deinterleaver.scala 92:32]
    end else begin
      pending_count_1 <= pending_next_1; // @[Deinterleaver.scala 97:19]
    end
    if (reset) begin // @[Deinterleaver.scala 92:32]
      pending_count_2 <= 4'h0; // @[Deinterleaver.scala 92:32]
    end else begin
      pending_count_2 <= pending_next_2; // @[Deinterleaver.scala 97:19]
    end
    if (reset) begin // @[Deinterleaver.scala 92:32]
      pending_count_3 <= 4'h0; // @[Deinterleaver.scala 92:32]
    end else begin
      pending_count_3 <= pending_next_3; // @[Deinterleaver.scala 97:19]
    end
    if (reset) begin // @[Deinterleaver.scala 92:32]
      pending_count_4 <= 4'h0; // @[Deinterleaver.scala 92:32]
    end else begin
      pending_count_4 <= pending_next_4; // @[Deinterleaver.scala 97:19]
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_5_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 5 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_5_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_6_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 6 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_6_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_7_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 7 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_7_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_8_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 8 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_8_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_9_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 9 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_9_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_10_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 10 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_10_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_11_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 11 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_11_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_12_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 12 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_12_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_13_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 13 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_13_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_14_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 14 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_14_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~queue_wire_15_enq_valid | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: ID 15 should not be used\n    at Deinterleaver.scala:75 assert(!q.enq.valid, s\"ID ${i} should not be used\")\n"
            ); // @[Deinterleaver.scala 75:19]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~queue_wire_15_enq_valid | reset)) begin
          $fatal; // @[Deinterleaver.scala 75:19]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_dec | pending_count != 4'h0 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:99 assert (!dec || count =/= 0.U)\n"); // @[Deinterleaver.scala 99:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_dec | pending_count != 4'h0 | reset)) begin
          $fatal; // @[Deinterleaver.scala 99:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_inc | pending_count != 4'h8 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:100 assert (!inc || count =/= beats.U)\n"); // @[Deinterleaver.scala 100:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_inc | pending_count != 4'h8 | reset)) begin
          $fatal; // @[Deinterleaver.scala 100:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_dec_1 | pending_count_1 != 4'h0 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:99 assert (!dec || count =/= 0.U)\n"); // @[Deinterleaver.scala 99:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_dec_1 | pending_count_1 != 4'h0 | reset)) begin
          $fatal; // @[Deinterleaver.scala 99:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_inc_1 | pending_count_1 != 4'h8 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:100 assert (!inc || count =/= beats.U)\n"); // @[Deinterleaver.scala 100:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_inc_1 | pending_count_1 != 4'h8 | reset)) begin
          $fatal; // @[Deinterleaver.scala 100:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_dec_2 | pending_count_2 != 4'h0 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:99 assert (!dec || count =/= 0.U)\n"); // @[Deinterleaver.scala 99:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_dec_2 | pending_count_2 != 4'h0 | reset)) begin
          $fatal; // @[Deinterleaver.scala 99:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_inc_2 | pending_count_2 != 4'h8 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:100 assert (!inc || count =/= beats.U)\n"); // @[Deinterleaver.scala 100:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_inc_2 | pending_count_2 != 4'h8 | reset)) begin
          $fatal; // @[Deinterleaver.scala 100:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_dec_3 | pending_count_3 != 4'h0 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:99 assert (!dec || count =/= 0.U)\n"); // @[Deinterleaver.scala 99:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_dec_3 | pending_count_3 != 4'h0 | reset)) begin
          $fatal; // @[Deinterleaver.scala 99:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_inc_3 | pending_count_3 != 4'h8 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:100 assert (!inc || count =/= beats.U)\n"); // @[Deinterleaver.scala 100:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_inc_3 | pending_count_3 != 4'h8 | reset)) begin
          $fatal; // @[Deinterleaver.scala 100:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_dec_4 | pending_count_4 != 4'h0 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:99 assert (!dec || count =/= 0.U)\n"); // @[Deinterleaver.scala 99:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_dec_4 | pending_count_4 != 4'h0 | reset)) begin
          $fatal; // @[Deinterleaver.scala 99:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(~pending_inc_4 | pending_count_4 != 4'h8 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Deinterleaver.scala:100 assert (!inc || count =/= beats.U)\n"); // @[Deinterleaver.scala 100:20]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(~pending_inc_4 | pending_count_4 != 4'h8 | reset)) begin
          $fatal; // @[Deinterleaver.scala 100:20]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  locked = _RAND_0[0:0];
  _RAND_1 = {1{`RANDOM}};
  deq_id = _RAND_1[3:0];
  _RAND_2 = {1{`RANDOM}};
  pending_count = _RAND_2[3:0];
  _RAND_3 = {1{`RANDOM}};
  pending_count_1 = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  pending_count_2 = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  pending_count_3 = _RAND_5[3:0];
  _RAND_6 = {1{`RANDOM}};
  pending_count_4 = _RAND_6[3:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module AXI4IdIndexer(
  output        auto_in_aw_ready,
  input         auto_in_aw_valid,
  input  [2:0]  auto_in_aw_bits_id,
  input  [30:0] auto_in_aw_bits_addr,
  input  [7:0]  auto_in_aw_bits_len,
  input  [2:0]  auto_in_aw_bits_size,
  input  [1:0]  auto_in_aw_bits_burst,
  input         auto_in_aw_bits_lock,
  input  [3:0]  auto_in_aw_bits_cache,
  input  [2:0]  auto_in_aw_bits_prot,
  input  [3:0]  auto_in_aw_bits_qos,
  input  [3:0]  auto_in_aw_bits_echo_tl_state_size,
  input  [4:0]  auto_in_aw_bits_echo_tl_state_source,
  output        auto_in_w_ready,
  input         auto_in_w_valid,
  input  [63:0] auto_in_w_bits_data,
  input  [7:0]  auto_in_w_bits_strb,
  input         auto_in_w_bits_last,
  input         auto_in_b_ready,
  output        auto_in_b_valid,
  output [2:0]  auto_in_b_bits_id,
  output [1:0]  auto_in_b_bits_resp,
  output [3:0]  auto_in_b_bits_echo_tl_state_size,
  output [4:0]  auto_in_b_bits_echo_tl_state_source,
  output        auto_in_ar_ready,
  input         auto_in_ar_valid,
  input  [2:0]  auto_in_ar_bits_id,
  input  [30:0] auto_in_ar_bits_addr,
  input  [7:0]  auto_in_ar_bits_len,
  input  [2:0]  auto_in_ar_bits_size,
  input  [1:0]  auto_in_ar_bits_burst,
  input         auto_in_ar_bits_lock,
  input  [3:0]  auto_in_ar_bits_cache,
  input  [2:0]  auto_in_ar_bits_prot,
  input  [3:0]  auto_in_ar_bits_qos,
  input  [3:0]  auto_in_ar_bits_echo_tl_state_size,
  input  [4:0]  auto_in_ar_bits_echo_tl_state_source,
  input         auto_in_r_ready,
  output        auto_in_r_valid,
  output [2:0]  auto_in_r_bits_id,
  output [63:0] auto_in_r_bits_data,
  output [1:0]  auto_in_r_bits_resp,
  output [3:0]  auto_in_r_bits_echo_tl_state_size,
  output [4:0]  auto_in_r_bits_echo_tl_state_source,
  output        auto_in_r_bits_last,
  input         auto_out_aw_ready,
  output        auto_out_aw_valid,
  output [3:0]  auto_out_aw_bits_id,
  output [30:0] auto_out_aw_bits_addr,
  output [7:0]  auto_out_aw_bits_len,
  output [2:0]  auto_out_aw_bits_size,
  output [1:0]  auto_out_aw_bits_burst,
  output        auto_out_aw_bits_lock,
  output [3:0]  auto_out_aw_bits_cache,
  output [2:0]  auto_out_aw_bits_prot,
  output [3:0]  auto_out_aw_bits_qos,
  output [3:0]  auto_out_aw_bits_echo_tl_state_size,
  output [4:0]  auto_out_aw_bits_echo_tl_state_source,
  input         auto_out_w_ready,
  output        auto_out_w_valid,
  output [63:0] auto_out_w_bits_data,
  output [7:0]  auto_out_w_bits_strb,
  output        auto_out_w_bits_last,
  output        auto_out_b_ready,
  input         auto_out_b_valid,
  input  [3:0]  auto_out_b_bits_id,
  input  [1:0]  auto_out_b_bits_resp,
  input  [3:0]  auto_out_b_bits_echo_tl_state_size,
  input  [4:0]  auto_out_b_bits_echo_tl_state_source,
  input         auto_out_ar_ready,
  output        auto_out_ar_valid,
  output [3:0]  auto_out_ar_bits_id,
  output [30:0] auto_out_ar_bits_addr,
  output [7:0]  auto_out_ar_bits_len,
  output [2:0]  auto_out_ar_bits_size,
  output [1:0]  auto_out_ar_bits_burst,
  output        auto_out_ar_bits_lock,
  output [3:0]  auto_out_ar_bits_cache,
  output [2:0]  auto_out_ar_bits_prot,
  output [3:0]  auto_out_ar_bits_qos,
  output [3:0]  auto_out_ar_bits_echo_tl_state_size,
  output [4:0]  auto_out_ar_bits_echo_tl_state_source,
  output        auto_out_r_ready,
  input         auto_out_r_valid,
  input  [3:0]  auto_out_r_bits_id,
  input  [63:0] auto_out_r_bits_data,
  input  [1:0]  auto_out_r_bits_resp,
  input  [3:0]  auto_out_r_bits_echo_tl_state_size,
  input  [4:0]  auto_out_r_bits_echo_tl_state_source,
  input         auto_out_r_bits_last
);
  assign auto_in_aw_ready = auto_out_aw_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_w_ready = auto_out_w_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_valid = auto_out_b_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_id = auto_out_b_bits_id[2:0]; // @[Nodes.scala 1210:84 BundleMap.scala 247:19]
  assign auto_in_b_bits_resp = auto_out_b_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_echo_tl_state_size = auto_out_b_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_b_bits_echo_tl_state_source = auto_out_b_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_ar_ready = auto_out_ar_ready; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_valid = auto_out_r_valid; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_id = auto_out_r_bits_id[2:0]; // @[Nodes.scala 1210:84 BundleMap.scala 247:19]
  assign auto_in_r_bits_data = auto_out_r_bits_data; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_resp = auto_out_r_bits_resp; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_echo_tl_state_size = auto_out_r_bits_echo_tl_state_size; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_echo_tl_state_source = auto_out_r_bits_echo_tl_state_source; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_in_r_bits_last = auto_out_r_bits_last; // @[Nodes.scala 1207:84 LazyModule.scala 311:12]
  assign auto_out_aw_valid = auto_in_aw_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_id = {{1'd0}, auto_in_aw_bits_id}; // @[Nodes.scala 1207:84 BundleMap.scala 247:19]
  assign auto_out_aw_bits_addr = auto_in_aw_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_len = auto_in_aw_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_size = auto_in_aw_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_burst = auto_in_aw_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_lock = auto_in_aw_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_cache = auto_in_aw_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_prot = auto_in_aw_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_qos = auto_in_aw_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_echo_tl_state_size = auto_in_aw_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_aw_bits_echo_tl_state_source = auto_in_aw_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_valid = auto_in_w_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_data = auto_in_w_bits_data; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_strb = auto_in_w_bits_strb; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_w_bits_last = auto_in_w_bits_last; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_b_ready = auto_in_b_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_valid = auto_in_ar_valid; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_id = {{1'd0}, auto_in_ar_bits_id}; // @[Nodes.scala 1207:84 BundleMap.scala 247:19]
  assign auto_out_ar_bits_addr = auto_in_ar_bits_addr; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_len = auto_in_ar_bits_len; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_size = auto_in_ar_bits_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_burst = auto_in_ar_bits_burst; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_lock = auto_in_ar_bits_lock; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_cache = auto_in_ar_bits_cache; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_prot = auto_in_ar_bits_prot; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_qos = auto_in_ar_bits_qos; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_echo_tl_state_size = auto_in_ar_bits_echo_tl_state_size; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_ar_bits_echo_tl_state_source = auto_in_ar_bits_echo_tl_state_source; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
  assign auto_out_r_ready = auto_in_r_ready; // @[Nodes.scala 1210:84 LazyModule.scala 309:16]
endmodule
module TLMonitor_4(
  input         clock,
  input         reset,
  input         io_in_a_ready,
  input         io_in_a_valid,
  input  [2:0]  io_in_a_bits_opcode,
  input  [2:0]  io_in_a_bits_param,
  input  [3:0]  io_in_a_bits_size,
  input  [4:0]  io_in_a_bits_source,
  input  [30:0] io_in_a_bits_address,
  input  [7:0]  io_in_a_bits_mask,
  input         io_in_a_bits_corrupt,
  input         io_in_d_ready,
  input         io_in_d_valid,
  input  [2:0]  io_in_d_bits_opcode,
  input  [3:0]  io_in_d_bits_size,
  input  [4:0]  io_in_d_bits_source,
  input         io_in_d_bits_denied,
  input         io_in_d_bits_corrupt
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [95:0] _RAND_12;
  reg [159:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [159:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11]
  wire  _source_ok_T_1 = io_in_a_bits_source[4:3] == 2'h0; // @[Parameters.scala 54:32]
  wire  _source_ok_T_7 = io_in_a_bits_source[4:3] == 2'h1; // @[Parameters.scala 54:32]
  wire  _source_ok_T_12 = io_in_a_bits_source == 5'h10; // @[Parameters.scala 46:9]
  wire  _source_ok_T_13 = io_in_a_bits_source == 5'h11; // @[Parameters.scala 46:9]
  wire  _source_ok_T_14 = io_in_a_bits_source == 5'h12; // @[Parameters.scala 46:9]
  wire  source_ok = _source_ok_T_1 | _source_ok_T_7 | _source_ok_T_12 | _source_ok_T_13 | _source_ok_T_14; // @[Parameters.scala 1163:46]
  wire [22:0] _is_aligned_mask_T_1 = 23'hff << io_in_a_bits_size; // @[package.scala 234:77]
  wire [7:0] is_aligned_mask = ~_is_aligned_mask_T_1[7:0]; // @[package.scala 234:46]
  wire [30:0] _GEN_71 = {{23'd0}, is_aligned_mask}; // @[Edges.scala 20:16]
  wire [30:0] _is_aligned_T = io_in_a_bits_address & _GEN_71; // @[Edges.scala 20:16]
  wire  is_aligned = _is_aligned_T == 31'h0; // @[Edges.scala 20:24]
  wire [1:0] mask_sizeOH_shiftAmount = io_in_a_bits_size[1:0]; // @[OneHot.scala 64:49]
  wire [3:0] _mask_sizeOH_T_1 = 4'h1 << mask_sizeOH_shiftAmount; // @[OneHot.scala 65:12]
  wire [2:0] mask_sizeOH = _mask_sizeOH_T_1[2:0] | 3'h1; // @[Misc.scala 201:81]
  wire  mask_sub_acc = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21]
  wire  mask_size = mask_sizeOH[2]; // @[Misc.scala 208:26]
  wire  mask_bit = io_in_a_bits_address[2]; // @[Misc.scala 209:26]
  wire  mask_nbit = ~mask_bit; // @[Misc.scala 210:20]
  wire  mask_sub_acc_1 = mask_sub_acc | mask_size & mask_nbit; // @[Misc.scala 214:29]
  wire  mask_sub_acc_2 = mask_sub_acc | mask_size & mask_bit; // @[Misc.scala 214:29]
  wire  mask_size_1 = mask_sizeOH[1]; // @[Misc.scala 208:26]
  wire  mask_bit_1 = io_in_a_bits_address[1]; // @[Misc.scala 209:26]
  wire  mask_nbit_1 = ~mask_bit_1; // @[Misc.scala 210:20]
  wire  mask_sub_eq_2 = mask_nbit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_3 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_2; // @[Misc.scala 214:29]
  wire  mask_sub_eq_3 = mask_nbit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_4 = mask_sub_acc_1 | mask_size_1 & mask_sub_eq_3; // @[Misc.scala 214:29]
  wire  mask_sub_eq_4 = mask_bit & mask_nbit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_5 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_4; // @[Misc.scala 214:29]
  wire  mask_sub_eq_5 = mask_bit & mask_bit_1; // @[Misc.scala 213:27]
  wire  mask_sub_acc_6 = mask_sub_acc_2 | mask_size_1 & mask_sub_eq_5; // @[Misc.scala 214:29]
  wire  mask_size_2 = mask_sizeOH[0]; // @[Misc.scala 208:26]
  wire  mask_bit_2 = io_in_a_bits_address[0]; // @[Misc.scala 209:26]
  wire  mask_nbit_2 = ~mask_bit_2; // @[Misc.scala 210:20]
  wire  mask_eq = mask_sub_eq_2 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_lo = mask_sub_acc_3 | mask_size_2 & mask_eq; // @[Misc.scala 214:29]
  wire  mask_eq_1 = mask_sub_eq_2 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_lo_hi = mask_sub_acc_3 | mask_size_2 & mask_eq_1; // @[Misc.scala 214:29]
  wire  mask_eq_2 = mask_sub_eq_3 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_lo = mask_sub_acc_4 | mask_size_2 & mask_eq_2; // @[Misc.scala 214:29]
  wire  mask_eq_3 = mask_sub_eq_3 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_lo_hi_hi = mask_sub_acc_4 | mask_size_2 & mask_eq_3; // @[Misc.scala 214:29]
  wire  mask_eq_4 = mask_sub_eq_4 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_lo = mask_sub_acc_5 | mask_size_2 & mask_eq_4; // @[Misc.scala 214:29]
  wire  mask_eq_5 = mask_sub_eq_4 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_lo_hi = mask_sub_acc_5 | mask_size_2 & mask_eq_5; // @[Misc.scala 214:29]
  wire  mask_eq_6 = mask_sub_eq_5 & mask_nbit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_lo = mask_sub_acc_6 | mask_size_2 & mask_eq_6; // @[Misc.scala 214:29]
  wire  mask_eq_7 = mask_sub_eq_5 & mask_bit_2; // @[Misc.scala 213:27]
  wire  mask_hi_hi_hi = mask_sub_acc_6 | mask_size_2 & mask_eq_7; // @[Misc.scala 214:29]
  wire [7:0] mask = {mask_hi_hi_hi,mask_hi_hi_lo,mask_hi_lo_hi,mask_hi_lo_lo,mask_lo_hi_hi,mask_lo_hi_lo,mask_lo_lo_hi,
    mask_lo_lo_lo}; // @[Cat.scala 30:58]
  wire  _T_61 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25]
  wire  _T_63 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 92:42]
  wire  _T_84 = _T_63 & source_ok; // @[Parameters.scala 1213:30]
  wire  _T_97 = ~reset; // @[Monitor.scala 44:11]
  wire  _T_113 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 91:48]
  wire  _T_116 = _source_ok_T_12 & _T_113; // @[Mux.scala 27:72]
  wire  _T_134 = _T_116 & _T_63; // @[Parameters.scala 1437:195]
  wire  _T_148 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 108:27]
  wire [7:0] _T_152 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18]
  wire  _T_153 = _T_152 == 8'h0; // @[Monitor.scala 90:31]
  wire  _T_157 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18]
  wire  _T_161 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25]
  wire  _T_252 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31]
  wire  _T_265 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25]
  wire  _T_294 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 92:42]
  wire  _T_313 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31]
  wire  _T_317 = io_in_a_bits_mask == mask; // @[Monitor.scala 112:30]
  wire  _T_325 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25]
  wire  _T_351 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 92:42]
  wire  _T_361 = _T_84 & _T_351; // @[Parameters.scala 1426:195]
  wire  _T_379 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25]
  wire [7:0] _T_429 = ~mask; // @[Monitor.scala 129:33]
  wire [7:0] _T_430 = io_in_a_bits_mask & _T_429; // @[Monitor.scala 129:31]
  wire  _T_431 = _T_430 == 8'h0; // @[Monitor.scala 129:40]
  wire  _T_435 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25]
  wire  _T_478 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 138:33]
  wire  _T_486 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25]
  wire  _T_529 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 145:30]
  wire  _T_537 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25]
  wire  _T_580 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 158:28]
  wire  _T_592 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 42:24]
  wire  _source_ok_T_19 = io_in_d_bits_source[4:3] == 2'h0; // @[Parameters.scala 54:32]
  wire  _source_ok_T_25 = io_in_d_bits_source[4:3] == 2'h1; // @[Parameters.scala 54:32]
  wire  _source_ok_T_30 = io_in_d_bits_source == 5'h10; // @[Parameters.scala 46:9]
  wire  _source_ok_T_31 = io_in_d_bits_source == 5'h11; // @[Parameters.scala 46:9]
  wire  _source_ok_T_32 = io_in_d_bits_source == 5'h12; // @[Parameters.scala 46:9]
  wire  source_ok_1 = _source_ok_T_19 | _source_ok_T_25 | _source_ok_T_30 | _source_ok_T_31 | _source_ok_T_32; // @[Parameters.scala 1163:46]
  wire  _T_596 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25]
  wire  _T_600 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27]
  wire  _T_608 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15]
  wire  _T_612 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15]
  wire  _T_616 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25]
  wire  _T_644 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25]
  wire  _T_664 = _T_612 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30]
  wire  _T_673 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25]
  wire  _T_690 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25]
  wire  _T_708 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25]
  wire  _a_first_T = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37]
  wire [4:0] a_first_beats1_decode = is_aligned_mask[7:3]; // @[Edges.scala 219:59]
  wire  a_first_beats1_opdata = ~io_in_a_bits_opcode[2]; // @[Edges.scala 91:28]
  reg [4:0] a_first_counter; // @[Edges.scala 228:27]
  wire [4:0] a_first_counter1 = a_first_counter - 5'h1; // @[Edges.scala 229:28]
  wire  a_first = a_first_counter == 5'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode; // @[Monitor.scala 386:22]
  reg [2:0] param; // @[Monitor.scala 387:22]
  reg [3:0] size; // @[Monitor.scala 388:22]
  reg [4:0] source; // @[Monitor.scala 389:22]
  reg [30:0] address; // @[Monitor.scala 390:22]
  wire  _T_738 = io_in_a_valid & ~a_first; // @[Monitor.scala 391:19]
  wire  _T_739 = io_in_a_bits_opcode == opcode; // @[Monitor.scala 392:32]
  wire  _T_743 = io_in_a_bits_param == param; // @[Monitor.scala 393:32]
  wire  _T_747 = io_in_a_bits_size == size; // @[Monitor.scala 394:32]
  wire  _T_751 = io_in_a_bits_source == source; // @[Monitor.scala 395:32]
  wire  _T_755 = io_in_a_bits_address == address; // @[Monitor.scala 396:32]
  wire  _d_first_T = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37]
  wire [22:0] _d_first_beats1_decode_T_1 = 23'hff << io_in_d_bits_size; // @[package.scala 234:77]
  wire [7:0] _d_first_beats1_decode_T_3 = ~_d_first_beats1_decode_T_1[7:0]; // @[package.scala 234:46]
  wire [4:0] d_first_beats1_decode = _d_first_beats1_decode_T_3[7:3]; // @[Edges.scala 219:59]
  wire  d_first_beats1_opdata = io_in_d_bits_opcode[0]; // @[Edges.scala 105:36]
  reg [4:0] d_first_counter; // @[Edges.scala 228:27]
  wire [4:0] d_first_counter1 = d_first_counter - 5'h1; // @[Edges.scala 229:28]
  wire  d_first = d_first_counter == 5'h0; // @[Edges.scala 230:25]
  reg [2:0] opcode_1; // @[Monitor.scala 537:22]
  reg [3:0] size_1; // @[Monitor.scala 539:22]
  reg [4:0] source_1; // @[Monitor.scala 540:22]
  reg  denied; // @[Monitor.scala 542:22]
  wire  _T_762 = io_in_d_valid & ~d_first; // @[Monitor.scala 543:19]
  wire  _T_763 = io_in_d_bits_opcode == opcode_1; // @[Monitor.scala 544:29]
  wire  _T_771 = io_in_d_bits_size == size_1; // @[Monitor.scala 546:29]
  wire  _T_775 = io_in_d_bits_source == source_1; // @[Monitor.scala 547:29]
  wire  _T_783 = io_in_d_bits_denied == denied; // @[Monitor.scala 549:29]
  reg [18:0] inflight; // @[Monitor.scala 613:27]
  reg [75:0] inflight_opcodes; // @[Monitor.scala 615:35]
  reg [151:0] inflight_sizes; // @[Monitor.scala 617:33]
  reg [4:0] a_first_counter_1; // @[Edges.scala 228:27]
  wire [4:0] a_first_counter1_1 = a_first_counter_1 - 5'h1; // @[Edges.scala 229:28]
  wire  a_first_1 = a_first_counter_1 == 5'h0; // @[Edges.scala 230:25]
  reg [4:0] d_first_counter_1; // @[Edges.scala 228:27]
  wire [4:0] d_first_counter1_1 = d_first_counter_1 - 5'h1; // @[Edges.scala 229:28]
  wire  d_first_1 = d_first_counter_1 == 5'h0; // @[Edges.scala 230:25]
  wire [6:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69]
  wire [7:0] _a_opcode_lookup_T = {{1'd0}, _GEN_72}; // @[Monitor.scala 636:69]
  wire [75:0] _a_opcode_lookup_T_1 = inflight_opcodes >> _a_opcode_lookup_T; // @[Monitor.scala 636:44]
  wire [15:0] _a_opcode_lookup_T_5 = 16'h10 - 16'h1; // @[Monitor.scala 611:57]
  wire [75:0] _GEN_73 = {{60'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 636:97]
  wire [75:0] _a_opcode_lookup_T_6 = _a_opcode_lookup_T_1 & _GEN_73; // @[Monitor.scala 636:97]
  wire [75:0] _a_opcode_lookup_T_7 = {{1'd0}, _a_opcode_lookup_T_6[75:1]}; // @[Monitor.scala 636:152]
  wire [7:0] _a_size_lookup_T = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65]
  wire [151:0] _a_size_lookup_T_1 = inflight_sizes >> _a_size_lookup_T; // @[Monitor.scala 640:40]
  wire [15:0] _a_size_lookup_T_5 = 16'h100 - 16'h1; // @[Monitor.scala 611:57]
  wire [151:0] _GEN_75 = {{136'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 640:91]
  wire [151:0] _a_size_lookup_T_6 = _a_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 640:91]
  wire [151:0] _a_size_lookup_T_7 = {{1'd0}, _a_size_lookup_T_6[151:1]}; // @[Monitor.scala 640:144]
  wire  _T_789 = io_in_a_valid & a_first_1; // @[Monitor.scala 650:26]
  wire [31:0] _a_set_wo_ready_T = 32'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35]
  wire [31:0] _GEN_15 = io_in_a_valid & a_first_1 ? _a_set_wo_ready_T : 32'h0; // @[Monitor.scala 650:71 Monitor.scala 651:22]
  wire  _T_792 = _a_first_T & a_first_1; // @[Monitor.scala 654:27]
  wire [3:0] _a_opcodes_set_interm_T = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53]
  wire [3:0] _a_opcodes_set_interm_T_1 = _a_opcodes_set_interm_T | 4'h1; // @[Monitor.scala 656:61]
  wire [4:0] _a_sizes_set_interm_T = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51]
  wire [4:0] _a_sizes_set_interm_T_1 = _a_sizes_set_interm_T | 5'h1; // @[Monitor.scala 657:59]
  wire [6:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79]
  wire [7:0] _a_opcodes_set_T = {{1'd0}, _GEN_77}; // @[Monitor.scala 658:79]
  wire [3:0] a_opcodes_set_interm = _a_first_T & a_first_1 ? _a_opcodes_set_interm_T_1 : 4'h0; // @[Monitor.scala 654:72 Monitor.scala 656:28]
  wire [258:0] _GEN_78 = {{255'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54]
  wire [258:0] _a_opcodes_set_T_1 = _GEN_78 << _a_opcodes_set_T; // @[Monitor.scala 658:54]
  wire [7:0] _a_sizes_set_T = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77]
  wire [4:0] a_sizes_set_interm = _a_first_T & a_first_1 ? _a_sizes_set_interm_T_1 : 5'h0; // @[Monitor.scala 654:72 Monitor.scala 657:28]
  wire [259:0] _GEN_79 = {{255'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52]
  wire [259:0] _a_sizes_set_T_1 = _GEN_79 << _a_sizes_set_T; // @[Monitor.scala 659:52]
  wire [18:0] _T_794 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26]
  wire  _T_796 = ~_T_794[0]; // @[Monitor.scala 660:17]
  wire [31:0] _GEN_16 = _a_first_T & a_first_1 ? _a_set_wo_ready_T : 32'h0; // @[Monitor.scala 654:72 Monitor.scala 655:28]
  wire [258:0] _GEN_19 = _a_first_T & a_first_1 ? _a_opcodes_set_T_1 : 259'h0; // @[Monitor.scala 654:72 Monitor.scala 658:28]
  wire [259:0] _GEN_20 = _a_first_T & a_first_1 ? _a_sizes_set_T_1 : 260'h0; // @[Monitor.scala 654:72 Monitor.scala 659:28]
  wire  _T_800 = io_in_d_valid & d_first_1; // @[Monitor.scala 673:26]
  wire  _T_802 = ~_T_596; // @[Monitor.scala 673:74]
  wire  _T_803 = io_in_d_valid & d_first_1 & ~_T_596; // @[Monitor.scala 673:71]
  wire [31:0] _d_clr_wo_ready_T = 32'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35]
  wire [31:0] _GEN_21 = io_in_d_valid & d_first_1 & ~_T_596 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 673:90 Monitor.scala 674:22]
  wire [270:0] _GEN_81 = {{255'd0}, _a_opcode_lookup_T_5}; // @[Monitor.scala 679:76]
  wire [270:0] _d_opcodes_clr_T_5 = _GEN_81 << _a_opcode_lookup_T; // @[Monitor.scala 679:76]
  wire [270:0] _GEN_82 = {{255'd0}, _a_size_lookup_T_5}; // @[Monitor.scala 680:74]
  wire [270:0] _d_sizes_clr_T_5 = _GEN_82 << _a_size_lookup_T; // @[Monitor.scala 680:74]
  wire [31:0] _GEN_22 = _d_first_T & d_first_1 & _T_802 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 677:91 Monitor.scala 678:21]
  wire [270:0] _GEN_23 = _d_first_T & d_first_1 & _T_802 ? _d_opcodes_clr_T_5 : 271'h0; // @[Monitor.scala 677:91 Monitor.scala 679:21]
  wire [270:0] _GEN_24 = _d_first_T & d_first_1 & _T_802 ? _d_sizes_clr_T_5 : 271'h0; // @[Monitor.scala 677:91 Monitor.scala 680:21]
  wire  _same_cycle_resp_T_2 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113]
  wire  same_cycle_resp = _T_789 & io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:88]
  wire [18:0] _T_813 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25]
  wire  _T_815 = _T_813[0] | same_cycle_resp; // @[Monitor.scala 684:49]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 687:38 Monitor.scala 687:38]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 688:39 Monitor.scala 688:39]
  wire  _T_820 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 688:39]
  wire  _T_821 = io_in_d_bits_opcode == _GEN_32 | _T_820; // @[Monitor.scala 687:77]
  wire  _T_825 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36]
  wire [3:0] a_opcode_lookup = _a_opcode_lookup_T_7[3:0];
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 691:38 Monitor.scala 691:38]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 692:38 Monitor.scala 692:38]
  wire  _T_832 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 692:38]
  wire  _T_833 = io_in_d_bits_opcode == _GEN_48 | _T_832; // @[Monitor.scala 691:72]
  wire [7:0] a_size_lookup = _a_size_lookup_T_7[7:0];
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36]
  wire  _T_837 = _GEN_83 == a_size_lookup; // @[Monitor.scala 693:36]
  wire  _T_847 = _T_800 & a_first_1 & io_in_a_valid & _same_cycle_resp_T_2 & _T_802; // @[Monitor.scala 696:116]
  wire  _T_849 = ~io_in_d_ready | io_in_a_ready; // @[Monitor.scala 697:32]
  wire [18:0] a_set_wo_ready = _GEN_15[18:0];
  wire [18:0] d_clr_wo_ready = _GEN_21[18:0];
  wire  _T_856 = a_set_wo_ready != d_clr_wo_ready | ~(|a_set_wo_ready); // @[Monitor.scala 701:48]
  wire [18:0] a_set = _GEN_16[18:0];
  wire [18:0] _inflight_T = inflight | a_set; // @[Monitor.scala 704:27]
  wire [18:0] d_clr = _GEN_22[18:0];
  wire [18:0] _inflight_T_1 = ~d_clr; // @[Monitor.scala 704:38]
  wire [18:0] _inflight_T_2 = _inflight_T & _inflight_T_1; // @[Monitor.scala 704:36]
  wire [75:0] a_opcodes_set = _GEN_19[75:0];
  wire [75:0] _inflight_opcodes_T = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43]
  wire [75:0] d_opcodes_clr = _GEN_23[75:0];
  wire [75:0] _inflight_opcodes_T_1 = ~d_opcodes_clr; // @[Monitor.scala 705:62]
  wire [75:0] _inflight_opcodes_T_2 = _inflight_opcodes_T & _inflight_opcodes_T_1; // @[Monitor.scala 705:60]
  wire [151:0] a_sizes_set = _GEN_20[151:0];
  wire [151:0] _inflight_sizes_T = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39]
  wire [151:0] d_sizes_clr = _GEN_24[151:0];
  wire [151:0] _inflight_sizes_T_1 = ~d_sizes_clr; // @[Monitor.scala 706:56]
  wire [151:0] _inflight_sizes_T_2 = _inflight_sizes_T & _inflight_sizes_T_1; // @[Monitor.scala 706:54]
  reg [31:0] watchdog; // @[Monitor.scala 708:27]
  wire  _T_865 = ~(|inflight) | plusarg_reader_out == 32'h0 | watchdog < plusarg_reader_out; // @[Monitor.scala 711:47]
  wire [31:0] _watchdog_T_1 = watchdog + 32'h1; // @[Monitor.scala 713:26]
  reg [18:0] inflight_1; // @[Monitor.scala 725:35]
  reg [151:0] inflight_sizes_1; // @[Monitor.scala 727:35]
  reg [4:0] d_first_counter_2; // @[Edges.scala 228:27]
  wire [4:0] d_first_counter1_2 = d_first_counter_2 - 5'h1; // @[Edges.scala 229:28]
  wire  d_first_2 = d_first_counter_2 == 5'h0; // @[Edges.scala 230:25]
  wire [151:0] _c_size_lookup_T_1 = inflight_sizes_1 >> _a_size_lookup_T; // @[Monitor.scala 749:42]
  wire [151:0] _c_size_lookup_T_6 = _c_size_lookup_T_1 & _GEN_75; // @[Monitor.scala 749:93]
  wire [151:0] _c_size_lookup_T_7 = {{1'd0}, _c_size_lookup_T_6[151:1]}; // @[Monitor.scala 749:146]
  wire  _T_891 = io_in_d_valid & d_first_2 & _T_596; // @[Monitor.scala 781:71]
  wire [31:0] _GEN_67 = _d_first_T & d_first_2 & _T_596 ? _d_clr_wo_ready_T : 32'h0; // @[Monitor.scala 785:90 Monitor.scala 786:21]
  wire [270:0] _GEN_69 = _d_first_T & d_first_2 & _T_596 ? _d_sizes_clr_T_5 : 271'h0; // @[Monitor.scala 785:90 Monitor.scala 788:21]
  wire [18:0] _T_899 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25]
  wire [7:0] c_size_lookup = _c_size_lookup_T_7[7:0];
  wire  _T_909 = _GEN_83 == c_size_lookup; // @[Monitor.scala 797:36]
  wire [18:0] d_clr_1 = _GEN_67[18:0];
  wire [18:0] _inflight_T_4 = ~d_clr_1; // @[Monitor.scala 811:46]
  wire [18:0] _inflight_T_5 = inflight_1 & _inflight_T_4; // @[Monitor.scala 811:44]
  wire [151:0] d_sizes_clr_1 = _GEN_69[151:0];
  wire [151:0] _inflight_sizes_T_4 = ~d_sizes_clr_1; // @[Monitor.scala 813:58]
  wire [151:0] _inflight_sizes_T_5 = inflight_sizes_1 & _inflight_sizes_T_4; // @[Monitor.scala 813:56]
  reg [31:0] watchdog_1; // @[Monitor.scala 815:27]
  wire  _T_934 = ~(|inflight_1) | plusarg_reader_1_out == 32'h0 | watchdog_1 < plusarg_reader_1_out; // @[Monitor.scala 818:47]
  wire [31:0] _watchdog_T_3 = watchdog_1 + 32'h1; // @[Monitor.scala 820:26]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11]
    .out(plusarg_reader_1_out)
  );
  always @(posedge clock) begin
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter <= 5'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter <= a_first_beats1_decode;
        end else begin
          a_first_counter <= 5'h0;
        end
      end else begin
        a_first_counter <= a_first_counter1;
      end
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      opcode <= io_in_a_bits_opcode; // @[Monitor.scala 399:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      param <= io_in_a_bits_param; // @[Monitor.scala 400:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      size <= io_in_a_bits_size; // @[Monitor.scala 401:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      source <= io_in_a_bits_source; // @[Monitor.scala 402:15]
    end
    if (_a_first_T & a_first) begin // @[Monitor.scala 398:32]
      address <= io_in_a_bits_address; // @[Monitor.scala 403:15]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter <= 5'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter <= d_first_beats1_decode;
        end else begin
          d_first_counter <= 5'h0;
        end
      end else begin
        d_first_counter <= d_first_counter1;
      end
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      opcode_1 <= io_in_d_bits_opcode; // @[Monitor.scala 552:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      size_1 <= io_in_d_bits_size; // @[Monitor.scala 554:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      source_1 <= io_in_d_bits_source; // @[Monitor.scala 555:15]
    end
    if (_d_first_T & d_first) begin // @[Monitor.scala 551:32]
      denied <= io_in_d_bits_denied; // @[Monitor.scala 557:15]
    end
    if (reset) begin // @[Monitor.scala 613:27]
      inflight <= 19'h0; // @[Monitor.scala 613:27]
    end else begin
      inflight <= _inflight_T_2; // @[Monitor.scala 704:14]
    end
    if (reset) begin // @[Monitor.scala 615:35]
      inflight_opcodes <= 76'h0; // @[Monitor.scala 615:35]
    end else begin
      inflight_opcodes <= _inflight_opcodes_T_2; // @[Monitor.scala 705:22]
    end
    if (reset) begin // @[Monitor.scala 617:33]
      inflight_sizes <= 152'h0; // @[Monitor.scala 617:33]
    end else begin
      inflight_sizes <= _inflight_sizes_T_2; // @[Monitor.scala 706:20]
    end
    if (reset) begin // @[Edges.scala 228:27]
      a_first_counter_1 <= 5'h0; // @[Edges.scala 228:27]
    end else if (_a_first_T) begin // @[Edges.scala 234:17]
      if (a_first_1) begin // @[Edges.scala 235:21]
        if (a_first_beats1_opdata) begin // @[Edges.scala 220:14]
          a_first_counter_1 <= a_first_beats1_decode;
        end else begin
          a_first_counter_1 <= 5'h0;
        end
      end else begin
        a_first_counter_1 <= a_first_counter1_1;
      end
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_1 <= 5'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_1) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_1 <= d_first_beats1_decode;
        end else begin
          d_first_counter_1 <= 5'h0;
        end
      end else begin
        d_first_counter_1 <= d_first_counter1_1;
      end
    end
    if (reset) begin // @[Monitor.scala 708:27]
      watchdog <= 32'h0; // @[Monitor.scala 708:27]
    end else if (_a_first_T | _d_first_T) begin // @[Monitor.scala 714:47]
      watchdog <= 32'h0; // @[Monitor.scala 714:58]
    end else begin
      watchdog <= _watchdog_T_1; // @[Monitor.scala 713:14]
    end
    if (reset) begin // @[Monitor.scala 725:35]
      inflight_1 <= 19'h0; // @[Monitor.scala 725:35]
    end else begin
      inflight_1 <= _inflight_T_5; // @[Monitor.scala 811:22]
    end
    if (reset) begin // @[Monitor.scala 727:35]
      inflight_sizes_1 <= 152'h0; // @[Monitor.scala 727:35]
    end else begin
      inflight_sizes_1 <= _inflight_sizes_T_5; // @[Monitor.scala 813:22]
    end
    if (reset) begin // @[Edges.scala 228:27]
      d_first_counter_2 <= 5'h0; // @[Edges.scala 228:27]
    end else if (_d_first_T) begin // @[Edges.scala 234:17]
      if (d_first_2) begin // @[Edges.scala 235:21]
        if (d_first_beats1_opdata) begin // @[Edges.scala 220:14]
          d_first_counter_2 <= d_first_beats1_decode;
        end else begin
          d_first_counter_2 <= 5'h0;
        end
      end else begin
        d_first_counter_2 <= d_first_counter1_2;
      end
    end
    if (reset) begin // @[Monitor.scala 815:27]
      watchdog_1 <= 32'h0; // @[Monitor.scala 815:27]
    end else if (_d_first_T) begin // @[Monitor.scala 821:47]
      watchdog_1 <= 32'h0; // @[Monitor.scala 821:58]
    end else begin
      watchdog_1 <= _watchdog_T_3; // @[Monitor.scala 820:14]
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_134 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_134 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_148 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_148 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_153 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_153 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_157 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquireBlock is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_61 & ~(_T_157 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_134 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_134 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(mask_sub_acc | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(mask_sub_acc | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_148 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_148 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_252 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_252 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_153 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_153 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_157 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel AcquirePerm is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_161 & ~(_T_157 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_84 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_84 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_294 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_294 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_313 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get carries invalid param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_313 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_317 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_317 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_157 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Get is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_265 & ~(_T_157 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(_T_361 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(_T_361 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(_T_313 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull carries invalid param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(_T_313 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(_T_317 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutFull contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_325 & ~(_T_317 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_361 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_361 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_313 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial carries invalid param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_313 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_431 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel PutPartial contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_379 & ~(_T_431 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(_T_478 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(_T_478 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(_T_317 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_435 & ~(_T_317 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(_T_529 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical carries invalid opcode param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(_T_529 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(_T_317 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Logical contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_486 & ~(_T_317 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~reset) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~reset) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(source_ok | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(source_ok | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(is_aligned | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint address not aligned to size (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(is_aligned | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(_T_580 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint carries invalid opcode param (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(_T_580 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(_T_317 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint contains invalid mask (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(_T_317 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(_T_157 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel Hint is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_a_valid & _T_537 & ~(_T_157 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_592 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel has invalid opcode (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & ~(_T_592 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(_T_600 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(_T_600 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(_T_608 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(_T_608 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(_T_612 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel ReleaseAck is denied (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_596 & ~(_T_612 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & _T_97) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant carries invalid sink ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & _T_97) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & ~(_T_600 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant smaller than a beat (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & ~(_T_600 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & ~(_T_608 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel Grant is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_616 & ~(_T_608 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & _T_97) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData carries invalid sink ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & _T_97) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & ~(_T_600 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData smaller than a beat (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & ~(_T_600 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & ~(_T_664 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_644 & ~(_T_664 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_673 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_673 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_673 & ~(_T_608 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAck is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_673 & ~(_T_608 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_690 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_690 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_690 & ~(_T_664 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_690 & ~(_T_664 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_708 & ~(source_ok_1 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck carries invalid source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_708 & ~(source_ok_1 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_708 & ~(_T_608 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel HintAck is corrupt (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_708 & ~(_T_608 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_738 & ~(_T_739 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel opcode changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_738 & ~(_T_739 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_738 & ~(_T_743 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel param changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_738 & ~(_T_743 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_738 & ~(_T_747 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel size changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_738 & ~(_T_747 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_738 & ~(_T_751 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel source changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_738 & ~(_T_751 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_738 & ~(_T_755 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel address changed with multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_738 & ~(_T_755 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_762 & ~(_T_763 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel opcode changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_762 & ~(_T_763 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_762 & ~(_T_771 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel size changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_762 & ~(_T_771 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_762 & ~(_T_775 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel source changed within multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_762 & ~(_T_775 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_762 & ~(_T_783 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel denied changed with multibeat operation (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_762 & ~(_T_783 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_792 & ~(_T_796 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' channel re-used a source ID (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_792 & ~(_T_796 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_803 & ~(_T_815 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_803 & ~(_T_815 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_803 & same_cycle_resp & ~(_T_821 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_803 & same_cycle_resp & ~(_T_821 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_803 & same_cycle_resp & ~(_T_825 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_803 & same_cycle_resp & ~(_T_825 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_803 & ~same_cycle_resp & ~(_T_833 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper opcode response (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_803 & ~same_cycle_resp & ~(_T_833 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_803 & ~same_cycle_resp & ~(_T_837 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_803 & ~same_cycle_resp & ~(_T_837 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_847 & ~(_T_849 | reset)) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_847 & ~(_T_849 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_856 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'A' and 'D' concurrent, despite minlatency 3 (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_856 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_865 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_865 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_891 & ~(_T_899[0] | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel acknowledged for nothing inflight (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_891 & ~(_T_899[0] | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_891 & ~(_T_909 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: 'D' channel contains improper response size (connected at Ports.scala:91:9)\n    at Monitor.scala:51 assert(cond, message)\n"
            ); // @[Monitor.scala 51:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_891 & ~(_T_909 | reset)) begin
          $fatal; // @[Monitor.scala 51:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (~(_T_934 | reset)) begin
          $fwrite(32'h80000002,
            "Assertion failed: TileLink timeout expired (connected at Ports.scala:91:9)\n    at Monitor.scala:44 assert(cond, message)\n"
            ); // @[Monitor.scala 44:11]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (~(_T_934 | reset)) begin
          $fatal; // @[Monitor.scala 44:11]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  a_first_counter = _RAND_0[4:0];
  _RAND_1 = {1{`RANDOM}};
  opcode = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  param = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  size = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  source = _RAND_4[4:0];
  _RAND_5 = {1{`RANDOM}};
  address = _RAND_5[30:0];
  _RAND_6 = {1{`RANDOM}};
  d_first_counter = _RAND_6[4:0];
  _RAND_7 = {1{`RANDOM}};
  opcode_1 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  size_1 = _RAND_8[3:0];
  _RAND_9 = {1{`RANDOM}};
  source_1 = _RAND_9[4:0];
  _RAND_10 = {1{`RANDOM}};
  denied = _RAND_10[0:0];
  _RAND_11 = {1{`RANDOM}};
  inflight = _RAND_11[18:0];
  _RAND_12 = {3{`RANDOM}};
  inflight_opcodes = _RAND_12[75:0];
  _RAND_13 = {5{`RANDOM}};
  inflight_sizes = _RAND_13[151:0];
  _RAND_14 = {1{`RANDOM}};
  a_first_counter_1 = _RAND_14[4:0];
  _RAND_15 = {1{`RANDOM}};
  d_first_counter_1 = _RAND_15[4:0];
  _RAND_16 = {1{`RANDOM}};
  watchdog = _RAND_16[31:0];
  _RAND_17 = {1{`RANDOM}};
  inflight_1 = _RAND_17[18:0];
  _RAND_18 = {5{`RANDOM}};
  inflight_sizes_1 = _RAND_18[151:0];
  _RAND_19 = {1{`RANDOM}};
  d_first_counter_2 = _RAND_19[4:0];
  _RAND_20 = {1{`RANDOM}};
  watchdog_1 = _RAND_20[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module Queue_10(
  input         clock,
  input         reset,
  output        io_enq_ready,
  input         io_enq_valid,
  input  [63:0] io_enq_bits_data,
  input  [7:0]  io_enq_bits_strb,
  input         io_enq_bits_last,
  input         io_deq_ready,
  output        io_deq_valid,
  output [63:0] io_deq_bits_data,
  output [7:0]  io_deq_bits_strb,
  output        io_deq_bits_last
);
`ifdef RANDOMIZE_MEM_INIT
  reg [63:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_3;
`endif // RANDOMIZE_REG_INIT
  reg [63:0] ram_data [0:0]; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_data_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [63:0] ram_data_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_data_MPORT_en; // @[Decoupled.scala 218:16]
  reg [7:0] ram_strb [0:0]; // @[Decoupled.scala 218:16]
  wire [7:0] ram_strb_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_strb_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [7:0] ram_strb_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_strb_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_strb_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_strb_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_last [0:0]; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_last_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_last_MPORT_en; // @[Decoupled.scala 218:16]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  empty = ~maybe_full; // @[Decoupled.scala 224:28]
  wire  _do_enq_T = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  _do_deq_T = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  wire  _GEN_9 = io_deq_ready ? 1'h0 : _do_enq_T; // @[Decoupled.scala 249:27 Decoupled.scala 249:36]
  wire  do_enq = empty ? _GEN_9 : _do_enq_T; // @[Decoupled.scala 246:18]
  wire  do_deq = empty ? 1'h0 : _do_deq_T; // @[Decoupled.scala 246:18 Decoupled.scala 248:14]
  assign ram_data_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_data_io_deq_bits_MPORT_data = ram_data[ram_data_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_data_MPORT_data = io_enq_bits_data;
  assign ram_data_MPORT_addr = 1'h0;
  assign ram_data_MPORT_mask = 1'h1;
  assign ram_data_MPORT_en = empty ? _GEN_9 : _do_enq_T;
  assign ram_strb_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_strb_io_deq_bits_MPORT_data = ram_strb[ram_strb_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_strb_MPORT_data = io_enq_bits_strb;
  assign ram_strb_MPORT_addr = 1'h0;
  assign ram_strb_MPORT_mask = 1'h1;
  assign ram_strb_MPORT_en = empty ? _GEN_9 : _do_enq_T;
  assign ram_last_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_last_io_deq_bits_MPORT_data = ram_last[ram_last_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_last_MPORT_data = io_enq_bits_last;
  assign ram_last_MPORT_addr = 1'h0;
  assign ram_last_MPORT_mask = 1'h1;
  assign ram_last_MPORT_en = empty ? _GEN_9 : _do_enq_T;
  assign io_enq_ready = ~maybe_full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = io_enq_valid | ~empty; // @[Decoupled.scala 245:25 Decoupled.scala 245:40 Decoupled.scala 240:16]
  assign io_deq_bits_data = empty ? io_enq_bits_data : ram_data_io_deq_bits_MPORT_data; // @[Decoupled.scala 246:18 Decoupled.scala 247:19 Decoupled.scala 242:15]
  assign io_deq_bits_strb = empty ? io_enq_bits_strb : ram_strb_io_deq_bits_MPORT_data; // @[Decoupled.scala 246:18 Decoupled.scala 247:19 Decoupled.scala 242:15]
  assign io_deq_bits_last = empty ? io_enq_bits_last : ram_last_io_deq_bits_MPORT_data; // @[Decoupled.scala 246:18 Decoupled.scala 247:19 Decoupled.scala 242:15]
  always @(posedge clock) begin
    if(ram_data_MPORT_en & ram_data_MPORT_mask) begin
      ram_data[ram_data_MPORT_addr] <= ram_data_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_strb_MPORT_en & ram_strb_MPORT_mask) begin
      ram_strb[ram_strb_MPORT_addr] <= ram_strb_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if(ram_last_MPORT_en & ram_last_MPORT_mask) begin
      ram_last[ram_last_MPORT_addr] <= ram_last_MPORT_data; // @[Decoupled.scala 218:16]
    end
    if (reset) begin // @[Decoupled.scala 221:27]
      maybe_full <= 1'h0; // @[Decoupled.scala 221:27]
    end else if (do_enq != do_deq) begin // @[Decoupled.scala 236:28]
      if (empty) begin // @[Decoupled.scala 246:18]
        if (io_deq_ready) begin // @[Decoupled.scala 249:27]
          maybe_full <= 1'h0; // @[Decoupled.scala 249:36]
        end else begin
          maybe_full <= _do_enq_T;
        end
      end else begin
        maybe_full <= _do_enq_T;
      end
    end
  end
// Register and memory initialization
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_MEM_INIT
  _RAND_0 = {2{`RANDOM}};
  for (initvar = 0; initvar < 1; initvar = initvar+1)
    ram_data[initvar] = _RAND_0[63:0];
  _RAND_1 = {1{`RANDOM}};
  for (initvar = 0; initvar < 1; initvar = initvar+1)
    ram_strb[initvar] = _RAND_1[7:0];
  _RAND_2 = {1{`RANDOM}};
  for (initvar = 0; initvar < 1; initvar = initvar+1)
    ram_last[initvar] = _RAND_2[0:0];
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  _RAND_3 = {1{`RANDOM}};
  maybe_full = _RAND_3[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
endmodule
module Queue_11(
  input         clock,
  input         reset,
  output        io_enq_ready,
  input         io_enq_valid,
  input  [2:0]  io_enq_bits_id,
  input  [30:0] io_enq_bits_addr,
  input  [7:0]  io_enq_bits_len,
  input  [2:0]  io_enq_bits_size,
  input  [3:0]  io_enq_bits_cache,
  input  [2:0]  io_enq_bits_prot,
  input  [3:0]  io_enq_bits_echo_tl_state_size,
  input  [4:0]  io_enq_bits_echo_tl_state_source,
  input         io_enq_bits_wen,
  input         io_deq_ready,
  output        io_deq_valid,
  output [2:0]  io_deq_bits_id,
  output [30:0] io_deq_bits_addr,
  output [7:0]  io_deq_bits_len,
  output [2:0]  io_deq_bits_size,
  output [1:0]  io_deq_bits_burst,
  output        io_deq_bits_lock,
  output [3:0]  io_deq_bits_cache,
  output [2:0]  io_deq_bits_prot,
  output [3:0]  io_deq_bits_qos,
  output [3:0]  io_deq_bits_echo_tl_state_size,
  output [4:0]  io_deq_bits_echo_tl_state_source,
  output        io_deq_bits_wen
);
`ifdef RANDOMIZE_MEM_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
`endif // RANDOMIZE_MEM_INIT
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_12;
`endif // RANDOMIZE_REG_INIT
  reg [2:0] ram_id [0:0]; // @[Decoupled.scala 218:16]
  wire [2:0] ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [2:0] ram_id_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_id_MPORT_en; // @[Decoupled.scala 218:16]
  reg [30:0] ram_addr [0:0]; // @[Decoupled.scala 218:16]
  wire [30:0] ram_addr_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_addr_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [30:0] ram_addr_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_addr_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_addr_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_addr_MPORT_en; // @[Decoupled.scala 218:16]
  reg [7:0] ram_len [0:0]; // @[Decoupled.scala 218:16]
  wire [7:0] ram_len_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_len_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [7:0] ram_len_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_len_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_len_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_len_MPORT_en; // @[Decoupled.scala 218:16]
  reg [2:0] ram_size [0:0]; // @[Decoupled.scala 218:16]
  wire [2:0] ram_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_size_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [2:0] ram_size_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_size_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_size_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_size_MPORT_en; // @[Decoupled.scala 218:16]
  reg [1:0] ram_burst [0:0]; // @[Decoupled.scala 218:16]
  wire [1:0] ram_burst_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_burst_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [1:0] ram_burst_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_burst_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_burst_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_burst_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_lock [0:0]; // @[Decoupled.scala 218:16]
  wire  ram_lock_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_lock_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_lock_MPORT_en; // @[Decoupled.scala 218:16]
  reg [3:0] ram_cache [0:0]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_cache_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_cache_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_cache_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_cache_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_cache_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_cache_MPORT_en; // @[Decoupled.scala 218:16]
  reg [2:0] ram_prot [0:0]; // @[Decoupled.scala 218:16]
  wire [2:0] ram_prot_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_prot_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [2:0] ram_prot_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_prot_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_prot_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_prot_MPORT_en; // @[Decoupled.scala 218:16]
  reg [3:0] ram_qos [0:0]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_qos_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_qos_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_qos_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_qos_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_qos_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_qos_MPORT_en; // @[Decoupled.scala 218:16]
  reg [3:0] ram_echo_tl_state_size [0:0]; // @[Decoupled.scala 218:16]
  wire [3:0] ram_echo_tl_state_size_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_size_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [3:0] ram_echo_tl_state_size_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_size_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_size_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_size_MPORT_en; // @[Decoupled.scala 218:16]
  reg [4:0] ram_echo_tl_state_source [0:0]; // @[Decoupled.scala 218:16]
  wire [4:0] ram_echo_tl_state_source_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_source_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire [4:0] ram_echo_tl_state_source_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_source_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_source_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_echo_tl_state_source_MPORT_en; // @[Decoupled.scala 218:16]
  reg  ram_wen [0:0]; // @[Decoupled.scala 218:16]
  wire  ram_wen_io_deq_bits_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_wen_io_deq_bits_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_wen_MPORT_data; // @[Decoupled.scala 218:16]
  wire  ram_wen_MPORT_addr; // @[Decoupled.scala 218:16]
  wire  ram_wen_MPORT_mask; // @[Decoupled.scala 218:16]
  wire  ram_wen_MPORT_en; // @[Decoupled.scala 218:16]
  reg  maybe_full; // @[Decoupled.scala 221:27]
  wire  empty = ~maybe_full; // @[Decoupled.scala 224:28]
  wire  _do_enq_T = io_enq_ready & io_enq_valid; // @[Decoupled.scala 40:37]
  wire  _do_deq_T = io_deq_ready & io_deq_valid; // @[Decoupled.scala 40:37]
  wire  _GEN_18 = io_deq_ready ? 1'h0 : _do_enq_T; // @[Decoupled.scala 249:27 Decoupled.scala 249:36]
  wire  do_enq = empty ? _GEN_18 : _do_enq_T; // @[Decoupled.scala 246:18]
  wire  do_deq = empty ? 1'h0 : _do_deq_T; // @[Decoupled.scala 246:18 Decoupled.scala 248:14]
  assign ram_id_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_id_io_deq_bits_MPORT_data = ram_id[ram_id_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_id_MPORT_data = io_enq_bits_id;
  assign ram_id_MPORT_addr = 1'h0;
  assign ram_id_MPORT_mask = 1'h1;
  assign ram_id_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_addr_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_addr_io_deq_bits_MPORT_data = ram_addr[ram_addr_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_addr_MPORT_data = io_enq_bits_addr;
  assign ram_addr_MPORT_addr = 1'h0;
  assign ram_addr_MPORT_mask = 1'h1;
  assign ram_addr_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_len_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_len_io_deq_bits_MPORT_data = ram_len[ram_len_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_len_MPORT_data = io_enq_bits_len;
  assign ram_len_MPORT_addr = 1'h0;
  assign ram_len_MPORT_mask = 1'h1;
  assign ram_len_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_size_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_size_io_deq_bits_MPORT_data = ram_size[ram_size_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_size_MPORT_data = io_enq_bits_size;
  assign ram_size_MPORT_addr = 1'h0;
  assign ram_size_MPORT_mask = 1'h1;
  assign ram_size_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_burst_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_burst_io_deq_bits_MPORT_data = ram_burst[ram_burst_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_burst_MPORT_data = 2'h1;
  assign ram_burst_MPORT_addr = 1'h0;
  assign ram_burst_MPORT_mask = 1'h1;
  assign ram_burst_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_lock_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_lock_io_deq_bits_MPORT_data = ram_lock[ram_lock_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_lock_MPORT_data = 1'h0;
  assign ram_lock_MPORT_addr = 1'h0;
  assign ram_lock_MPORT_mask = 1'h1;
  assign ram_lock_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_cache_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_cache_io_deq_bits_MPORT_data = ram_cache[ram_cache_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_cache_MPORT_data = io_enq_bits_cache;
  assign ram_cache_MPORT_addr = 1'h0;
  assign ram_cache_MPORT_mask = 1'h1;
  assign ram_cache_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_prot_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_prot_io_deq_bits_MPORT_data = ram_prot[ram_prot_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_prot_MPORT_data = io_enq_bits_prot;
  assign ram_prot_MPORT_addr = 1'h0;
  assign ram_prot_MPORT_mask = 1'h1;
  assign ram_prot_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_qos_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_qos_io_deq_bits_MPORT_data = ram_qos[ram_qos_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_qos_MPORT_data = 4'h0;
  assign ram_qos_MPORT_addr = 1'h0;
  assign ram_qos_MPORT_mask = 1'h1;
  assign ram_qos_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_echo_tl_state_size_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_echo_tl_state_size_io_deq_bits_MPORT_data =
    ram_echo_tl_state_size[ram_echo_tl_state_size_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_echo_tl_state_size_MPORT_data = io_enq_bits_echo_tl_state_size;
  assign ram_echo_tl_state_size_MPORT_addr = 1'h0;
  assign ram_echo_tl_state_size_MPORT_mask = 1'h1;
  assign ram_echo_tl_state_size_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_echo_tl_state_source_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_echo_tl_state_source_io_deq_bits_MPORT_data =
    ram_echo_tl_state_source[ram_echo_tl_state_source_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_echo_tl_state_source_MPORT_data = io_enq_bits_echo_tl_state_source;
  assign ram_echo_tl_state_source_MPORT_addr = 1'h0;
  assign ram_echo_tl_state_source_MPORT_mask = 1'h1;
  assign ram_echo_tl_state_source_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign ram_wen_io_deq_bits_MPORT_addr = 1'h0;
  assign ram_wen_io_deq_bits_MPORT_data = ram_wen[ram_wen_io_deq_bits_MPORT_addr]; // @[Decoupled.scala 218:16]
  assign ram_wen_MPORT_data = io_enq_bits_wen;
  assign ram_wen_MPORT_addr = 1'h0;
  assign ram_wen_MPORT_mask = 1'h1;
  assign ram_wen_MPORT_en = empty ? _GEN_18 : _do_enq_T;
  assign io_enq_ready = ~maybe_full; // @[Decoupled.scala 241:19]
  assign io_deq_valid = io_enq_valid | ~empty; // @[Decoupled.scala 245:25 Decoupled.scala 245:40 Decoupled.scala 240:16]
  assign io_deq_bits_id = empty ? io_enq_bits_id : ram_id_io_deq_bits_MPORT_data; // @[Decoupled.scala 246:18 Decoupled.scala 247:19 Decoupled.scala 242:15]
  assign io_deq_bits_addr = empty ? io_enq