"""
Modified state columns in executions table

Revision ID: a472b5ad50b7
Revises: e1a50dae1ac9
Create Date: 2021-01-21 13:25:45.815775

"""
import sqlalchemy as sa
from alembic import op

# TODO: import DEFAULT EXECUTION CODE HERE

# revision identifiers, used by Alembic.
revision = "a472b5ad50b7"
down_revision = "e1a50dae1ac9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "executions",
        sa.Column(
            "state",
            sa.SmallInteger(),
            nullable=False,
            server_default=sa.text(str(0)),
        ),
    )

    op.add_column("executions", sa.Column("state_message", sa.TEXT(), nullable=True))
    # workaround to make migration work in sqlite:
    with op.batch_alter_table("executions") as batch_op:
        batch_op.drop_column("finished")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("executions", "state_message")
    op.drop_column("executions", "state")
    op.add_column(
        "executions",
        sa.Column(
            "finished",
            sa.BOOLEAN(),
            server_default=sa.text("false"),
            autoincrement=False,
            nullable=False,
        ),
    )
    # ### end Alembic commands ###
