"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plone = exports.PloneVariant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-24");
const constructs_1 = require("constructs");
const deployment_1 = require("./deployment");
const k8s_1 = require("./imports/k8s");
const service_1 = require("./service");
var PloneVariant;
(function (PloneVariant) {
    PloneVariant["VOLTO"] = "volto";
    PloneVariant["CLASSICUI"] = "classicui";
})(PloneVariant || (exports.PloneVariant = PloneVariant = {}));
class Plone extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        this.frontendServiceName = undefined;
        this.siteId = options.siteId ?? 'Plone';
        this.variant = options.variant ?? PloneVariant.VOLTO;
        // ------------------------------------------------------------------------
        // Backend
        const backend = options.backend ?? {};
        const backendLabels = {
            'app.kubernetes.io/name': 'plone-backend',
            'app.kubernetes.io/component': 'backend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        const backendPort = 8080;
        // Probing
        const backendActionHttpGet = {
            path: '/',
            port: k8s_1.IntOrString.fromNumber(backendPort),
        };
        var backendLivenessProbe = undefined;
        if (backend.livenessEnabled ?? false) {
            backendLivenessProbe = {
                httpGet: backendActionHttpGet,
                initialDelaySeconds: backend.livenessInitialDelaySeconds ?? 30,
                timeoutSeconds: backend.livenessIimeoutSeconds ?? 5,
                periodSeconds: backend.livenessPeriodSeconds ?? 10,
                successThreshold: backend.livenessSuccessThreshold ?? 1,
                failureThreshold: backend.livenessFailureThreshold ?? 3,
            };
        }
        var backendReadinessProbe = undefined;
        if (backend.readinessEnabled ?? true) {
            backendReadinessProbe = {
                httpGet: backendActionHttpGet,
                initialDelaySeconds: backend.readinessInitialDelaySeconds ?? 10,
                timeoutSeconds: backend.readinessIimeoutSeconds ?? 15,
                periodSeconds: backend.readinessPeriodSeconds ?? 10,
                successThreshold: backend.readinessSuccessThreshold ?? 1,
                failureThreshold: backend.readinessFailureThreshold ?? 3,
            };
        }
        // Deployment
        const backendDeployment = new deployment_1.PloneDeployment(this, 'backend', {
            labels: backendLabels,
            image: {
                image: backend.image ?? 'plone/plone-backend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: backend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: backend.replicas,
            limitCpu: backend.limitCpu ?? '500m',
            limitMemory: backend.limitMemory ?? '512Mi',
            requestCpu: backend.requestCpu ?? '200m',
            requestMemory: backend.requestMemory ?? '256Mi',
            pdb: {
                maxUnavailable: backend.maxUnavailable ?? undefined,
                minAvailable: backend.minAvailable ?? undefined,
            },
            port: backendPort,
            environment: backend.environment,
            livenessProbe: backendLivenessProbe,
            readinessProbe: backendReadinessProbe,
        });
        // Service
        const backendService = new service_1.PloneService(backendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-backend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: backendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(backendDeployment) },
        });
        this.backendServiceName = backendService.name;
        // ------------------------------------------------------------------------
        // Frontend
        if (this.variant == PloneVariant.VOLTO) {
            const frontend = options.frontend ?? {};
            const frontendPort = 3000;
            const frontendLabels = {
                'app.kubernetes.io/name': 'plone-frontend',
                'app.kubernetes.io/component': 'frontend',
                'app.kubernetes.io/version': options.version ?? 'undefined',
            };
            // Probing
            const frontendActionHttpGet = {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            };
            var frontendLivenessProbe = undefined;
            if (frontend.livenessEnabled ?? false) {
                frontendLivenessProbe = {
                    httpGet: frontendActionHttpGet,
                    initialDelaySeconds: frontend.livenessInitialDelaySeconds ?? 30,
                    timeoutSeconds: frontend.livenessIimeoutSeconds ?? 5,
                    periodSeconds: frontend.livenessPeriodSeconds ?? 10,
                    successThreshold: frontend.livenessSuccessThreshold ?? 1,
                    failureThreshold: frontend.livenessFailureThreshold ?? 3,
                };
            }
            var frontendReadinessProbe = undefined;
            if (frontend.readinessEnabled ?? true) {
                frontendReadinessProbe = {
                    httpGet: frontendActionHttpGet,
                    initialDelaySeconds: frontend.readinessInitialDelaySeconds ?? 10,
                    timeoutSeconds: frontend.readinessIimeoutSeconds ?? 15,
                    periodSeconds: frontend.readinessPeriodSeconds ?? 10,
                    successThreshold: frontend.readinessSuccessThreshold ?? 1,
                    failureThreshold: frontend.readinessFailureThreshold ?? 3,
                };
            }
            // Environment for RAZZLE
            var frontendEnvironment = frontend.environment ?? new kplus.Env([], {});
            if (frontendEnvironment.variables.RAZZLE_INTERNAL_API_PATH === undefined) {
                // connect with backend service
                frontendEnvironment?.addVariable('RAZZLE_INTERNAL_API_PATH', kplus.EnvValue.fromValue(`http://${backendService.name}:${backendPort}/${this.siteId}`));
            }
            // Deployment
            const frontendDeployment = new deployment_1.PloneDeployment(this, 'frontend', {
                labels: frontendLabels,
                image: {
                    image: frontend.image ?? 'plone/plone-frontend:latest',
                    imagePullSecrets: options.imagePullSecrets ?? [],
                    imagePullPolicy: frontend.imagePullPolicy ?? 'IfNotPresent',
                },
                replicas: frontend.replicas,
                limitCpu: frontend.limitCpu ?? '500m',
                limitMemory: frontend.limitMemory ?? '1Gi',
                requestCpu: backend.requestCpu ?? '200m',
                requestMemory: backend.requestMemory ?? '256Mi',
                pdb: {
                    maxUnavailable: frontend.maxUnavailable ?? undefined,
                    minAvailable: frontend.minAvailable ?? undefined,
                },
                port: frontendPort,
                environment: frontendEnvironment,
                livenessProbe: frontendLivenessProbe,
                readinessProbe: frontendReadinessProbe,
            });
            // Service
            const frontendService = new service_1.PloneService(frontendDeployment, 'service', {
                labels: {
                    'app.kubernetes.io/name': 'plone-frontend-service',
                    'app.kubernetes.io/component': 'service',
                },
                targetPort: frontendPort,
                selectorLabel: { app: cdk8s_1.Names.toLabelValue(frontendDeployment) },
            });
            this.frontendServiceName = frontendService.name;
        }
    }
}
exports.Plone = Plone;
_a = JSII_RTTI_SYMBOL_1;
Plone[_a] = { fqn: "@bluedynamics/cdk8s-plone.Plone", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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