# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.notification_preference import NotificationPreference
from empire_platform_api_public_client.models.notification_preference_with_sms import NotificationPreferenceWithSms

class UserPreferencesGeneralNotifications(BaseModel):
    """
    UserPreferencesGeneralNotifications
    """
    critical_alert: NotificationPreferenceWithSms = Field(..., alias="criticalAlert")
    critical: NotificationPreference = Field(...)
    major: NotificationPreference = Field(...)
    normal: NotificationPreference = Field(...)
    __properties = ["criticalAlert", "critical", "major", "normal"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserPreferencesGeneralNotifications:
        """Create an instance of UserPreferencesGeneralNotifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of critical_alert
        if self.critical_alert:
            _dict['criticalAlert'] = self.critical_alert.to_dict()
        # override the default output from pydantic by calling `to_dict()` of critical
        if self.critical:
            _dict['critical'] = self.critical.to_dict()
        # override the default output from pydantic by calling `to_dict()` of major
        if self.major:
            _dict['major'] = self.major.to_dict()
        # override the default output from pydantic by calling `to_dict()` of normal
        if self.normal:
            _dict['normal'] = self.normal.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserPreferencesGeneralNotifications:
        """Create an instance of UserPreferencesGeneralNotifications from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UserPreferencesGeneralNotifications.parse_obj(obj)

        _obj = UserPreferencesGeneralNotifications.parse_obj({
            "critical_alert": NotificationPreferenceWithSms.from_dict(obj.get("criticalAlert")) if obj.get("criticalAlert") is not None else None,
            "critical": NotificationPreference.from_dict(obj.get("critical")) if obj.get("critical") is not None else None,
            "major": NotificationPreference.from_dict(obj.get("major")) if obj.get("major") is not None else None,
            "normal": NotificationPreference.from_dict(obj.get("normal")) if obj.get("normal") is not None else None
        })
        return _obj


