# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.bid_value import BidValue

class SubmitLongTermBidsRequestBids(BaseModel):
    """
    SubmitLongTermBidsRequestBids
    """
    id: Optional[StrictStr] = Field(None, description="Unique (at least locally) identifier for the record in UUID4 format  * records received nullable identifiers through GET requests should have the property filled out * records sent to PUT endpoints:   - if property is filled out => backend is expected to update the record   - if property is null or missing => backend is expected to create a new record   - if list of records does not contain the record identifier => backend is expected to delete the record ")
    external_id: Optional[StrictStr] = Field(None, alias="externalId", description="Optional external identifier for the bid, for example to differentiate between traders ")
    value: BidValue = Field(...)
    __properties = ["id", "externalId", "value"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SubmitLongTermBidsRequestBids:
        """Create an instance of SubmitLongTermBidsRequestBids from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SubmitLongTermBidsRequestBids:
        """Create an instance of SubmitLongTermBidsRequestBids from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SubmitLongTermBidsRequestBids.parse_obj(obj)

        _obj = SubmitLongTermBidsRequestBids.parse_obj({
            "id": obj.get("id"),
            "external_id": obj.get("externalId"),
            "value": BidValue.from_dict(obj.get("value")) if obj.get("value") is not None else None
        })
        return _obj


