# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictInt, StrictStr, confloat, conint
from empire_platform_api_public_client.models.return_auction import ReturnAuction
from empire_platform_api_public_client.models.secondary_market_return_request_status import SecondaryMarketReturnRequestStatus
from empire_platform_api_public_client.models.source_auction_display_data import SourceAuctionDisplayData

class SecondaryMarketReturnRequest(BaseModel):
    """
    SecondaryMarketReturnRequest
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    source_auction: SourceAuctionDisplayData = Field(..., alias="sourceAuction")
    return_auction: ReturnAuction = Field(..., alias="returnAuction")
    returned_capacity: StrictInt = Field(..., alias="returnedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    successfully_allocated_capacity: Optional[StrictInt] = Field(None, alias="successfullyAllocatedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    price: Optional[Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)]] = Field(None, description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    status: SecondaryMarketReturnRequestStatus = Field(...)
    __properties = ["id", "sourceAuction", "returnAuction", "returnedCapacity", "successfullyAllocatedCapacity", "price", "status"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketReturnRequest:
        """Create an instance of SecondaryMarketReturnRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of source_auction
        if self.source_auction:
            _dict['sourceAuction'] = self.source_auction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_auction
        if self.return_auction:
            _dict['returnAuction'] = self.return_auction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketReturnRequest:
        """Create an instance of SecondaryMarketReturnRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketReturnRequest.parse_obj(obj)

        _obj = SecondaryMarketReturnRequest.parse_obj({
            "id": obj.get("id"),
            "source_auction": SourceAuctionDisplayData.from_dict(obj.get("sourceAuction")) if obj.get("sourceAuction") is not None else None,
            "return_auction": ReturnAuction.from_dict(obj.get("returnAuction")) if obj.get("returnAuction") is not None else None,
            "returned_capacity": obj.get("returnedCapacity"),
            "successfully_allocated_capacity": obj.get("successfullyAllocatedCapacity"),
            "price": obj.get("price"),
            "status": obj.get("status")
        })
        return _obj


