# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_entry_response_mtus import SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponseMtus

class SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse(BaseModel):
    """
    SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse
    """
    mtus: conlist(SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponseMtus) = Field(...)
    contact_name: StrictStr = Field(..., alias="contactName")
    phone_number: constr(strict=True) = Field(..., alias="phoneNumber")
    email: constr(strict=True) = Field(...)
    comment: Optional[StrictStr] = None
    responded_at: datetime = Field(..., alias="respondedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    __properties = ["mtus", "contactName", "phoneNumber", "email", "comment", "respondedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in mtus (list)
        _items = []
        if self.mtus:
            for _item in self.mtus:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtus'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse.parse_obj(obj)

        _obj = SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse.parse_obj({
            "mtus": [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponseMtus.from_dict(_item) for _item in obj.get("mtus")] if obj.get("mtus") is not None else None,
            "contact_name": obj.get("contactName"),
            "phone_number": obj.get("phoneNumber"),
            "email": obj.get("email"),
            "comment": obj.get("comment"),
            "responded_at": obj.get("respondedAt")
        })
        return _obj


