# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field

class MtuPeriod(BaseModel):
    """
    Period of MTUs in **absolute date and time** aligned to MTU borders in a natural way, meaning:  * with 60 min MTUs if start is 10:00 and end is 11:00 => it means a single MTU between 10:00 and 11:00 * with 30 min MTUs if start is 10:00 and end is 11:00 => it means the two MTUs between 10:00-10:30 and 10:30-11:00   # noqa: E501
    """
    from_mtu_start: datetime = Field(..., alias="fromMtuStart", description="The first moment (inclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    to_mtu_end: datetime = Field(..., alias="toMtuEnd", description="The last moment (exclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    __properties = ["fromMtuStart", "toMtuEnd"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MtuPeriod:
        """Create an instance of MtuPeriod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MtuPeriod:
        """Create an instance of MtuPeriod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MtuPeriod.parse_obj(obj)

        _obj = MtuPeriod.parse_obj({
            "from_mtu_start": obj.get("fromMtuStart"),
            "to_mtu_end": obj.get("toMtuEnd")
        })
        return _obj


