# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional, Union
from pydantic import BaseModel, Field, confloat, conint
from empire_platform_api_public_client.models.border_direction import BorderDirection

class InvoiceSummary(BaseModel):
    """
    InvoiceSummary
    """
    direction: BorderDirection = Field(...)
    net_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="netAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    net_amount_gbp: Optional[Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)]] = Field(None, alias="netAmountGbp", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    vat_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="vatAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    vat_amount_gbp: Optional[Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)]] = Field(None, alias="vatAmountGbp", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    exchange_rate: Optional[Union[confloat(multiple_of=0.00010, strict=True), conint(strict=True)]] = Field(None, alias="exchangeRate", description="Decimal numbers, accepted with a precision of maximum 4 decimal places")
    exchange_rate_day: Optional[date] = Field(None, alias="exchangeRateDay", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    __properties = ["direction", "netAmount", "netAmountGbp", "vatAmount", "vatAmountGbp", "exchangeRate", "exchangeRateDay"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvoiceSummary:
        """Create an instance of InvoiceSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvoiceSummary:
        """Create an instance of InvoiceSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvoiceSummary.parse_obj(obj)

        _obj = InvoiceSummary.parse_obj({
            "direction": obj.get("direction"),
            "net_amount": obj.get("netAmount"),
            "net_amount_gbp": obj.get("netAmountGbp"),
            "vat_amount": obj.get("vatAmount"),
            "vat_amount_gbp": obj.get("vatAmountGbp"),
            "exchange_rate": obj.get("exchangeRate"),
            "exchange_rate_day": obj.get("exchangeRateDay")
        })
        return _obj


