# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.dashboard_next_nomination_gate_window import DashboardNextNominationGateWindow
from empire_platform_api_public_client.models.dashboard_next_nomination_window_status import DashboardNextNominationWindowStatus
from empire_platform_api_public_client.models.mtu_period import MtuPeriod

class DashboardNextNominationGate(BaseModel):
    """
    DashboardNextNominationGate
    """
    timescale: AuctionTimescale = Field(...)
    window: DashboardNextNominationGateWindow = Field(...)
    delivery_period: MtuPeriod = Field(..., alias="deliveryPeriod")
    status: DashboardNextNominationWindowStatus = Field(...)
    next_action_at: datetime = Field(..., alias="nextActionAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    __properties = ["timescale", "window", "deliveryPeriod", "status", "nextActionAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DashboardNextNominationGate:
        """Create an instance of DashboardNextNominationGate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of window
        if self.window:
            _dict['window'] = self.window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DashboardNextNominationGate:
        """Create an instance of DashboardNextNominationGate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DashboardNextNominationGate.parse_obj(obj)

        _obj = DashboardNextNominationGate.parse_obj({
            "timescale": obj.get("timescale"),
            "window": DashboardNextNominationGateWindow.from_dict(obj.get("window")) if obj.get("window") is not None else None,
            "delivery_period": MtuPeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "status": obj.get("status"),
            "next_action_at": obj.get("nextActionAt")
        })
        return _obj


