# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from datetime import date

from pydantic import Field, StrictStr, conint, conlist

from typing import Optional

from empire_platform_api_public_client.models.create_organisation_document_request import CreateOrganisationDocumentRequest
from empire_platform_api_public_client.models.created_organisation_document import CreatedOrganisationDocument
from empire_platform_api_public_client.models.organisation_document_batch import OrganisationDocumentBatch
from empire_platform_api_public_client.models.organisation_document_file_type import OrganisationDocumentFileType
from empire_platform_api_public_client.models.organisation_document_options import OrganisationDocumentOptions
from empire_platform_api_public_client.models.organisation_document_sort_by import OrganisationDocumentSortBy

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrganisationDocumentApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_organisation_document(self, x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], create_organisation_document_request : CreateOrganisationDocumentRequest, **kwargs) -> CreatedOrganisationDocument:  # noqa: E501
        """create_organisation_document  # noqa: E501

        Create new Organisation Document for a given Organisation  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_ORGANISATION_DOCUMENTS`   * `MANAGE_ANY_ORGANISATION_DOCUMENTS`  __Generates Audit Log Entry:__ `CREATE_ORGANISATION_DOCUMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_organisation_document(x_organisation_id, create_organisation_document_request, async_req=True)
        >>> result = thread.get()

        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param create_organisation_document_request: (required)
        :type create_organisation_document_request: CreateOrganisationDocumentRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedOrganisationDocument
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_organisation_document_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_organisation_document_with_http_info(x_organisation_id, create_organisation_document_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_organisation_document_with_http_info(self, x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], create_organisation_document_request : CreateOrganisationDocumentRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """create_organisation_document  # noqa: E501

        Create new Organisation Document for a given Organisation  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_ORGANISATION_DOCUMENTS`   * `MANAGE_ANY_ORGANISATION_DOCUMENTS`  __Generates Audit Log Entry:__ `CREATE_ORGANISATION_DOCUMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_organisation_document_with_http_info(x_organisation_id, create_organisation_document_request, async_req=True)
        >>> result = thread.get()

        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param create_organisation_document_request: (required)
        :type create_organisation_document_request: CreateOrganisationDocumentRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedOrganisationDocument, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_organisation_id',
            'create_organisation_document_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organisation_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_organisation_id']:
            _header_params['X-Organisation-Id'] = _params['x_organisation_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_organisation_document_request'] is not None:
            _body_params = _params['create_organisation_document_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedOrganisationDocument",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/organisation-documents', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organisation_document(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> None:  # noqa: E501
        """delete_organisation_document  # noqa: E501

        Delete an existing Organisation Document by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_ORGANISATION_DOCUMENTS`   * `MANAGE_ANY_ORGANISATION_DOCUMENTS`  __Generates Audit Log Entry:__ `DELETE_ORGANISATION_DOCUMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_organisation_document(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_organisation_document_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_organisation_document_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_organisation_document_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """delete_organisation_document  # noqa: E501

        Delete an existing Organisation Document by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_ORGANISATION_DOCUMENTS`   * `MANAGE_ANY_ORGANISATION_DOCUMENTS`  __Generates Audit Log Entry:__ `DELETE_ORGANISATION_DOCUMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_organisation_document_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organisation_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/organisation-documents/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organisation_document_options(self, x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], **kwargs) -> OrganisationDocumentOptions:  # noqa: E501
        """get_organisation_document_options  # noqa: E501

        Fetch options for Organisation Documents for a given Organisation  Implementation notes:   - `fileTypes` - the uploaded files' MIME Types grouped to the defined categories   - `organisations` - Organisation that have uploaded files     - `users` - Users in the given Organisation that have uploaded files  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_ORGANISATION_DOCUMENTS`   * `VIEW_ANY_ORGANISATION_DOCUMENTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisation_document_options(x_organisation_id, async_req=True)
        >>> result = thread.get()

        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrganisationDocumentOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_organisation_document_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_organisation_document_options_with_http_info(x_organisation_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_organisation_document_options_with_http_info(self, x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_organisation_document_options  # noqa: E501

        Fetch options for Organisation Documents for a given Organisation  Implementation notes:   - `fileTypes` - the uploaded files' MIME Types grouped to the defined categories   - `organisations` - Organisation that have uploaded files     - `users` - Users in the given Organisation that have uploaded files  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_ORGANISATION_DOCUMENTS`   * `VIEW_ANY_ORGANISATION_DOCUMENTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisation_document_options_with_http_info(x_organisation_id, async_req=True)
        >>> result = thread.get()

        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrganisationDocumentOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_organisation_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organisation_document_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_organisation_id']:
            _header_params['X-Organisation-Id'] = _params['x_organisation_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "OrganisationDocumentOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/organisation-documents/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organisation_documents(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[OrganisationDocumentSortBy, Field(..., description="Sort list by given attribute and direction")], x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], query : Annotated[Optional[StrictStr], Field(description="Free text search in fileName and description")] = None, file_types : Optional[conlist(OrganisationDocumentFileType)] = None, uploaded_at_from : Optional[date] = None, uploaded_at_to : Optional[date] = None, uploaded_by_org_id : Optional[StrictStr] = None, uploaded_by_user_ids : Optional[conlist(StrictStr)] = None, **kwargs) -> OrganisationDocumentBatch:  # noqa: E501
        """get_organisation_documents  # noqa: E501

        Fetch a paginated, filterable list of Organisation Documents for a given Organisation  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_ORGANISATION_DOCUMENTS`   * `VIEW_ANY_ORGANISATION_DOCUMENTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisation_documents(limit, offset, sort_by, x_organisation_id, query, file_types, uploaded_at_from, uploaded_at_to, uploaded_by_org_id, uploaded_by_user_ids, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: OrganisationDocumentSortBy
        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param query: Free text search in fileName and description
        :type query: str
        :param file_types:
        :type file_types: List[OrganisationDocumentFileType]
        :param uploaded_at_from:
        :type uploaded_at_from: date
        :param uploaded_at_to:
        :type uploaded_at_to: date
        :param uploaded_by_org_id:
        :type uploaded_by_org_id: str
        :param uploaded_by_user_ids:
        :type uploaded_by_user_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrganisationDocumentBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_organisation_documents_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_organisation_documents_with_http_info(limit, offset, sort_by, x_organisation_id, query, file_types, uploaded_at_from, uploaded_at_to, uploaded_by_org_id, uploaded_by_user_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_organisation_documents_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[OrganisationDocumentSortBy, Field(..., description="Sort list by given attribute and direction")], x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], query : Annotated[Optional[StrictStr], Field(description="Free text search in fileName and description")] = None, file_types : Optional[conlist(OrganisationDocumentFileType)] = None, uploaded_at_from : Optional[date] = None, uploaded_at_to : Optional[date] = None, uploaded_by_org_id : Optional[StrictStr] = None, uploaded_by_user_ids : Optional[conlist(StrictStr)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_organisation_documents  # noqa: E501

        Fetch a paginated, filterable list of Organisation Documents for a given Organisation  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_ORGANISATION_DOCUMENTS`   * `VIEW_ANY_ORGANISATION_DOCUMENTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisation_documents_with_http_info(limit, offset, sort_by, x_organisation_id, query, file_types, uploaded_at_from, uploaded_at_to, uploaded_by_org_id, uploaded_by_user_ids, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: OrganisationDocumentSortBy
        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param query: Free text search in fileName and description
        :type query: str
        :param file_types:
        :type file_types: List[OrganisationDocumentFileType]
        :param uploaded_at_from:
        :type uploaded_at_from: date
        :param uploaded_at_to:
        :type uploaded_at_to: date
        :param uploaded_by_org_id:
        :type uploaded_by_org_id: str
        :param uploaded_by_user_ids:
        :type uploaded_by_user_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrganisationDocumentBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'x_organisation_id',
            'query',
            'file_types',
            'uploaded_at_from',
            'uploaded_at_to',
            'uploaded_by_org_id',
            'uploaded_by_user_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organisation_documents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        if _params.get('file_types') is not None:  # noqa: E501
            _query_params.append(('fileTypes', _params['file_types']))
            _collection_formats['fileTypes'] = 'multi'

        if _params.get('uploaded_at_from') is not None:  # noqa: E501
            if isinstance(_params['uploaded_at_from'], date):
                _query_params.append(('uploadedAtFrom', _params['uploaded_at_from'].isoformat()))
            else:
                _query_params.append(('uploadedAtFrom', _params['uploaded_at_from']))

        if _params.get('uploaded_at_to') is not None:  # noqa: E501
            if isinstance(_params['uploaded_at_to'], date):
                _query_params.append(('uploadedAtTo', _params['uploaded_at_to'].isoformat()))
            else:
                _query_params.append(('uploadedAtTo', _params['uploaded_at_to']))

        if _params.get('uploaded_by_org_id') is not None:  # noqa: E501
            _query_params.append(('uploadedByOrgId', _params['uploaded_by_org_id']))

        if _params.get('uploaded_by_user_ids') is not None:  # noqa: E501
            _query_params.append(('uploadedByUserIds', _params['uploaded_by_user_ids']))
            _collection_formats['uploadedByUserIds'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_organisation_id']:
            _header_params['X-Organisation-Id'] = _params['x_organisation_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "OrganisationDocumentBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/organisation-documents', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
