# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.bid_value import BidValue

class UpdateLongTermDefaultBidRequest(BaseModel):
    """
    UpdateLongTermDefaultBidRequest
    """
    delivery_period_start: datetime = Field(..., alias="deliveryPeriodStart", description="The first moment (inclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    delivery_period_end: Optional[datetime] = Field(None, alias="deliveryPeriodEnd", description="The last moment (exclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    validity_period_start: datetime = Field(..., alias="validityPeriodStart", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    validity_period_end: Optional[datetime] = Field(None, alias="validityPeriodEnd", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    bids: conlist(BidValue) = Field(...)
    __properties = ["deliveryPeriodStart", "deliveryPeriodEnd", "validityPeriodStart", "validityPeriodEnd", "bids"]

    # @validator('delivery_period_start')
    def delivery_period_start_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    # @validator('delivery_period_end')
    def delivery_period_end_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateLongTermDefaultBidRequest:
        """Create an instance of UpdateLongTermDefaultBidRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bids (list)
        _items = []
        if self.bids:
            for _item in self.bids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bids'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateLongTermDefaultBidRequest:
        """Create an instance of UpdateLongTermDefaultBidRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateLongTermDefaultBidRequest.parse_obj(obj)

        _obj = UpdateLongTermDefaultBidRequest.parse_obj({
            "delivery_period_start": obj.get("deliveryPeriodStart"),
            "delivery_period_end": obj.get("deliveryPeriodEnd"),
            "validity_period_start": obj.get("validityPeriodStart"),
            "validity_period_end": obj.get("validityPeriodEnd"),
            "bids": [BidValue.from_dict(_item) for _item in obj.get("bids")] if obj.get("bids") is not None else None
        })
        return _obj

