# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt
from empire_platform_api_public_client.models.timescale_nomination_mtu_status import TimescaleNominationMtuStatus
from empire_platform_api_public_client.models.timescale_nominations_mtus_inner_current_nomination import TimescaleNominationsMtusInnerCurrentNomination

class TimescaleNominationsMtusInner(BaseModel):
    """
    * `mtuStatus`   - LOCKED => if either of the following cases are true for the MTU:     - the MTU nomination window for the selected timescale is closed     - the MTU was curtailed     - every MTU is by definition LOCKED if       - the specified Participant has `ableToNominate = FALSE` AND       - does not have an `onBehalfParticipantId` specified       - **in eihter markets**   - EDITABLE => if either of the following cases are true for the MTU:     - MTU nom window for the selected timescale is either not yet open or currently open     - There was no curtailment for the MTU   - NO_TR => if either of the following cases are true for the MTU:     - the user has no TR for the specific MTU, therefore there is nothing to nominate * `totalTrs` - Total value of Transmission Rights in kilowatts * `currentNomination.value` - Current value of Nominations in kilowatts * `notNominatedTrs` - Difference between total TRs and currentNomination.value 
    """
    mtu: datetime = Field(..., description="The first moment (inclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    mtu_status: TimescaleNominationMtuStatus = Field(..., alias="mtuStatus")
    total_trs: StrictInt = Field(..., alias="totalTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    current_nomination: Optional[TimescaleNominationsMtusInnerCurrentNomination] = Field(None, alias="currentNomination")
    not_nominated_trs: StrictInt = Field(..., alias="notNominatedTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["mtu", "mtuStatus", "totalTrs", "currentNomination", "notNominatedTrs"]

    # @validator('mtu')
    def mtu_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimescaleNominationsMtusInner:
        """Create an instance of TimescaleNominationsMtusInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of current_nomination
        if self.current_nomination:
            _dict['currentNomination'] = self.current_nomination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimescaleNominationsMtusInner:
        """Create an instance of TimescaleNominationsMtusInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimescaleNominationsMtusInner.parse_obj(obj)

        _obj = TimescaleNominationsMtusInner.parse_obj({
            "mtu": obj.get("mtu"),
            "mtu_status": obj.get("mtuStatus"),
            "total_trs": obj.get("totalTrs"),
            "current_nomination": TimescaleNominationsMtusInnerCurrentNomination.from_dict(obj.get("currentNomination")) if obj.get("currentNomination") is not None else None,
            "not_nominated_trs": obj.get("notNominatedTrs")
        })
        return _obj

