# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.market import Market
from empire_platform_api_public_client.models.vat_rate_type import VatRateType

class FinanceInformationMarketVatDetails(BaseModel):
    """
    FinanceInformationMarketVatDetails
    """
    market: Market = Field(...)
    vat_number: StrictStr = Field(..., alias="vatNumber")
    vat_rate: VatRateType = Field(..., alias="vatRate")
    __properties = ["market", "vatNumber", "vatRate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FinanceInformationMarketVatDetails:
        """Create an instance of FinanceInformationMarketVatDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FinanceInformationMarketVatDetails:
        """Create an instance of FinanceInformationMarketVatDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FinanceInformationMarketVatDetails.parse_obj(obj)

        _obj = FinanceInformationMarketVatDetails.parse_obj({
            "market": obj.get("market"),
            "vat_number": obj.get("vatNumber"),
            "vat_rate": obj.get("vatRate")
        })
        return _obj

