# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt

class DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue(BaseModel):
    """
    * `requestedCapacity` - Sum of ALL bids for the given MTU and Participant in kilowatts * `allocatedTrs` - The SUM AC for the given MTU and Participant for the Auction in kilowatts 
    """
    requested_capacity: Optional[StrictInt] = Field(None, alias="requestedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    allocated_trs: StrictInt = Field(..., alias="allocatedTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["requestedCapacity", "allocatedTrs"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue:
        """Create an instance of DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue:
        """Create an instance of DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue.parse_obj(obj)

        _obj = DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue.parse_obj({
            "requested_capacity": obj.get("requestedCapacity"),
            "allocated_trs": obj.get("allocatedTrs")
        })
        return _obj

