# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictInt, StrictStr, confloat, conint
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.mtu_period import MtuPeriod

class AllocatedAuction(BaseModel):
    """
    AllocatedAuction
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(..., alias="displayId", description="Generated display identifier")
    name: StrictStr = Field(..., description="Human readable name")
    product_type: AuctionProductType = Field(..., alias="productType")
    border_direction: BorderDirection = Field(..., alias="borderDirection")
    delivery_period: MtuPeriod = Field(..., alias="deliveryPeriod")
    participant_requested_count: conint(strict=True, ge=0) = Field(..., alias="participantRequestedCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    participant_allocated_count: conint(strict=True, ge=0) = Field(..., alias="participantAllocatedCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    offered_capacity: Optional[StrictInt] = Field(None, alias="offeredCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    total_requested_capacity: Optional[StrictInt] = Field(None, alias="totalRequestedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    total_allocated_capacity: Optional[StrictInt] = Field(None, alias="totalAllocatedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    marginal_clearing_price: Optional[Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)]] = Field(None, alias="marginalClearingPrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    __properties = ["id", "displayId", "name", "productType", "borderDirection", "deliveryPeriod", "participantRequestedCount", "participantAllocatedCount", "offeredCapacity", "totalRequestedCapacity", "totalAllocatedCapacity", "marginalClearingPrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AllocatedAuction:
        """Create an instance of AllocatedAuction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AllocatedAuction:
        """Create an instance of AllocatedAuction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AllocatedAuction.parse_obj(obj)

        _obj = AllocatedAuction.parse_obj({
            "id": obj.get("id"),
            "display_id": obj.get("displayId"),
            "name": obj.get("name"),
            "product_type": obj.get("productType"),
            "border_direction": obj.get("borderDirection"),
            "delivery_period": MtuPeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "participant_requested_count": obj.get("participantRequestedCount"),
            "participant_allocated_count": obj.get("participantAllocatedCount"),
            "offered_capacity": obj.get("offeredCapacity"),
            "total_requested_capacity": obj.get("totalRequestedCapacity"),
            "total_allocated_capacity": obj.get("totalAllocatedCapacity"),
            "marginal_clearing_price": obj.get("marginalClearingPrice")
        })
        return _obj

