# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, conlist
from empire_platform_api_public_client.models.aggregated_nomination_options_nominee_participants_inner import AggregatedNominationOptionsNomineeParticipantsInner

class AggregatedNominationOptions(BaseModel):
    """
    AggregatedNominationOptions
    """
    nominator_on_behalf: StrictBool = Field(..., alias="nominatorOnBehalf")
    nominee_participants: Optional[conlist(AggregatedNominationOptionsNomineeParticipantsInner)] = Field(None, alias="nomineeParticipants")
    __properties = ["nominatorOnBehalf", "nomineeParticipants"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AggregatedNominationOptions:
        """Create an instance of AggregatedNominationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in nominee_participants (list)
        _items = []
        if self.nominee_participants:
            for _item in self.nominee_participants:
                if _item:
                    _items.append(_item.to_dict())
            _dict['nomineeParticipants'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AggregatedNominationOptions:
        """Create an instance of AggregatedNominationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AggregatedNominationOptions.parse_obj(obj)

        _obj = AggregatedNominationOptions.parse_obj({
            "nominator_on_behalf": obj.get("nominatorOnBehalf"),
            "nominee_participants": [AggregatedNominationOptionsNomineeParticipantsInner.from_dict(_item) for _item in obj.get("nomineeParticipants")] if obj.get("nomineeParticipants") is not None else None
        })
        return _obj

