# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conlist

from typing import Optional, Union

from empire_platform_api_public_client.models.aggregated_nomination_type import AggregatedNominationType
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_status import AuctionStatus
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.audit_log_domain import AuditLogDomain
from empire_platform_api_public_client.models.border_direction_with_both import BorderDirectionWithBoth
from empire_platform_api_public_client.models.buy_now_offer_status import BuyNowOfferStatus
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.sage_code import SageCode
from empire_platform_api_public_client.models.user_role import UserRole
from empire_platform_api_public_client.models.user_status import UserStatus

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ReportingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_auction_allocation_results_report(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], **kwargs) -> str:  # noqa: E501
        """get_auction_allocation_results_report  # noqa: E501

        Fetch Auction Allocation Results Report in \"ECAN Allocation Results Document v4.0\" format  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_allocation_results_report(id, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_auction_allocation_results_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_auction_allocation_results_report_with_http_info(id, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_auction_allocation_results_report_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_auction_allocation_results_report  # noqa: E501

        Fetch Auction Allocation Results Report in \"ECAN Allocation Results Document v4.0\" format  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_allocation_results_report_with_http_info(id, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_allocation_results_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/auctions/{id}/allocation-results', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_auctions_schedule_report(self, product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], statuses : conlist(AuctionStatus), delivery_period_start : date, delivery_period_end : date, bidding_period_start : Optional[date] = None, bidding_period_end : Optional[date] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_auctions_schedule_report  # noqa: E501

        Fetch Auction Schedule Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auctions_schedule_report(product_types, border_direction, statuses, delivery_period_start, delivery_period_end, bidding_period_start, bidding_period_end, async_req=True)
        >>> result = thread.get()

        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_auctions_schedule_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_auctions_schedule_report_with_http_info(product_types, border_direction, statuses, delivery_period_start, delivery_period_end, bidding_period_start, bidding_period_end, **kwargs)  # noqa: E501

    @validate_arguments
    def get_auctions_schedule_report_with_http_info(self, product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], statuses : conlist(AuctionStatus), delivery_period_start : date, delivery_period_end : date, bidding_period_start : Optional[date] = None, bidding_period_end : Optional[date] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_auctions_schedule_report  # noqa: E501

        Fetch Auction Schedule Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auctions_schedule_report_with_http_info(product_types, border_direction, statuses, delivery_period_start, delivery_period_end, bidding_period_start, bidding_period_end, async_req=True)
        >>> result = thread.get()

        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'product_types',
            'border_direction',
            'statuses',
            'delivery_period_start',
            'delivery_period_end',
            'bidding_period_start',
            'bidding_period_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auctions_schedule_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('product_types') is not None:  # noqa: E501
            _query_params.append(('productTypes', _params['product_types']))
            _collection_formats['productTypes'] = 'multi'

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('statuses') is not None:  # noqa: E501
            _query_params.append(('statuses', _params['statuses']))
            _collection_formats['statuses'] = 'multi'

        if _params.get('bidding_period_start') is not None:  # noqa: E501
            if isinstance(_params['bidding_period_start'], datetime):
                _query_params.append(('biddingPeriodStart', _params['bidding_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('biddingPeriodStart', _params['bidding_period_start']))

        if _params.get('bidding_period_end') is not None:  # noqa: E501
            if isinstance(_params['bidding_period_end'], datetime):
                _query_params.append(('biddingPeriodEnd', _params['bidding_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('biddingPeriodEnd', _params['bidding_period_end']))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/auctions/schedule', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_auction_results_settlement_report(self, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : date, delivery_period_end : date, accounting_codes : conlist(SageCode), final_results_published_from : Optional[date] = None, final_results_published_to : Optional[date] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_finance_auction_results_settlement_report  # noqa: E501

        Fetch Finance Auction Results Settlement Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_auction_results_settlement_report(border_direction, delivery_period_start, delivery_period_end, accounting_codes, final_results_published_from, final_results_published_to, async_req=True)
        >>> result = thread.get()

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param final_results_published_from:
        :type final_results_published_from: date
        :param final_results_published_to:
        :type final_results_published_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_auction_results_settlement_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_auction_results_settlement_report_with_http_info(border_direction, delivery_period_start, delivery_period_end, accounting_codes, final_results_published_from, final_results_published_to, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_auction_results_settlement_report_with_http_info(self, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : date, delivery_period_end : date, accounting_codes : conlist(SageCode), final_results_published_from : Optional[date] = None, final_results_published_to : Optional[date] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_auction_results_settlement_report  # noqa: E501

        Fetch Finance Auction Results Settlement Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_auction_results_settlement_report_with_http_info(border_direction, delivery_period_start, delivery_period_end, accounting_codes, final_results_published_from, final_results_published_to, async_req=True)
        >>> result = thread.get()

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param final_results_published_from:
        :type final_results_published_from: date
        :param final_results_published_to:
        :type final_results_published_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'border_direction',
            'delivery_period_start',
            'delivery_period_end',
            'accounting_codes',
            'final_results_published_from',
            'final_results_published_to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_auction_results_settlement_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('final_results_published_from') is not None:  # noqa: E501
            if isinstance(_params['final_results_published_from'], datetime):
                _query_params.append(('finalResultsPublishedFrom', _params['final_results_published_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('finalResultsPublishedFrom', _params['final_results_published_from']))

        if _params.get('final_results_published_to') is not None:  # noqa: E501
            if isinstance(_params['final_results_published_to'], datetime):
                _query_params.append(('finalResultsPublishedTo', _params['final_results_published_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('finalResultsPublishedTo', _params['final_results_published_to']))

        if _params.get('accounting_codes') is not None:  # noqa: E501
            _query_params.append(('accountingCodes', _params['accounting_codes']))
            _collection_formats['accountingCodes'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/finance/auction-results-settlement', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_billing_report(self, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], invoice_period : date, accounting_codes : conlist(SageCode), delivery_period_start : Optional[date] = None, delivery_period_end : Optional[date] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_finance_billing_report  # noqa: E501

        Fetch Finance Billing Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_billing_report(x_participant_ids, border_direction, invoice_period, accounting_codes, delivery_period_start, delivery_period_end, async_req=True)
        >>> result = thread.get()

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param invoice_period: (required)
        :type invoice_period: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param delivery_period_start:
        :type delivery_period_start: date
        :param delivery_period_end:
        :type delivery_period_end: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_billing_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_billing_report_with_http_info(x_participant_ids, border_direction, invoice_period, accounting_codes, delivery_period_start, delivery_period_end, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_billing_report_with_http_info(self, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], invoice_period : date, accounting_codes : conlist(SageCode), delivery_period_start : Optional[date] = None, delivery_period_end : Optional[date] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_billing_report  # noqa: E501

        Fetch Finance Billing Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_billing_report_with_http_info(x_participant_ids, border_direction, invoice_period, accounting_codes, delivery_period_start, delivery_period_end, async_req=True)
        >>> result = thread.get()

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param invoice_period: (required)
        :type invoice_period: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param delivery_period_start:
        :type delivery_period_start: date
        :param delivery_period_end:
        :type delivery_period_end: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_participant_ids',
            'border_direction',
            'invoice_period',
            'accounting_codes',
            'delivery_period_start',
            'delivery_period_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_billing_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('invoice_period') is not None:  # noqa: E501
            if isinstance(_params['invoice_period'], datetime):
                _query_params.append(('invoicePeriod', _params['invoice_period'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('invoicePeriod', _params['invoice_period']))

        if _params.get('accounting_codes') is not None:  # noqa: E501
            _query_params.append(('accountingCodes', _params['accounting_codes']))
            _collection_formats['accountingCodes'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/finance/billing', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_invoice_details_report(self, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], generation_month : date, **kwargs) -> bytearray:  # noqa: E501
        """get_finance_invoice_details_report  # noqa: E501

        Fetch Finance Invoice Details Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoice_details_report(x_participant_id, generation_month, async_req=True)
        >>> result = thread.get()

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param generation_month: (required)
        :type generation_month: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_invoice_details_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_invoice_details_report_with_http_info(x_participant_id, generation_month, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_invoice_details_report_with_http_info(self, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], generation_month : date, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_invoice_details_report  # noqa: E501

        Fetch Finance Invoice Details Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoice_details_report_with_http_info(x_participant_id, generation_month, async_req=True)
        >>> result = thread.get()

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param generation_month: (required)
        :type generation_month: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_participant_id',
            'generation_month'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_invoice_details_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('generation_month') is not None:  # noqa: E501
            if isinstance(_params['generation_month'], datetime):
                _query_params.append(('generationMonth', _params['generation_month'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('generationMonth', _params['generation_month']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/finance/invoice-details', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_invoice_status_report(self, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], invoice_period_from : date, invoice_period_to : date, statuses : conlist(InvoiceStatus), **kwargs) -> bytearray:  # noqa: E501
        """get_finance_invoice_status_report  # noqa: E501

        Fetch Finance Invoice Status Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoice_status_report(x_participant_ids, invoice_period_from, invoice_period_to, statuses, async_req=True)
        >>> result = thread.get()

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_invoice_status_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_invoice_status_report_with_http_info(x_participant_ids, invoice_period_from, invoice_period_to, statuses, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_invoice_status_report_with_http_info(self, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], invoice_period_from : date, invoice_period_to : date, statuses : conlist(InvoiceStatus), **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_invoice_status_report  # noqa: E501

        Fetch Finance Invoice Status Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoice_status_report_with_http_info(x_participant_ids, invoice_period_from, invoice_period_to, statuses, async_req=True)
        >>> result = thread.get()

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_participant_ids',
            'invoice_period_from',
            'invoice_period_to',
            'statuses'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_invoice_status_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('invoice_period_from') is not None:  # noqa: E501
            if isinstance(_params['invoice_period_from'], datetime):
                _query_params.append(('invoicePeriodFrom', _params['invoice_period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('invoicePeriodFrom', _params['invoice_period_from']))

        if _params.get('invoice_period_to') is not None:  # noqa: E501
            if isinstance(_params['invoice_period_to'], datetime):
                _query_params.append(('invoicePeriodTo', _params['invoice_period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('invoicePeriodTo', _params['invoice_period_to']))

        if _params.get('statuses') is not None:  # noqa: E501
            _query_params.append(('statuses', _params['statuses']))
            _collection_formats['statuses'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/finance/invoice-status', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_single_invoice_details_report(self, invoice_display_id : StrictStr, **kwargs) -> bytearray:  # noqa: E501
        """get_finance_single_invoice_details_report  # noqa: E501

        Fetch Finance Single Invoice Details  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_single_invoice_details_report(invoice_display_id, async_req=True)
        >>> result = thread.get()

        :param invoice_display_id: (required)
        :type invoice_display_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_single_invoice_details_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_single_invoice_details_report_with_http_info(invoice_display_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_single_invoice_details_report_with_http_info(self, invoice_display_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_single_invoice_details_report  # noqa: E501

        Fetch Finance Single Invoice Details  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_single_invoice_details_report_with_http_info(invoice_display_id, async_req=True)
        >>> result = thread.get()

        :param invoice_display_id: (required)
        :type invoice_display_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'invoice_display_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_single_invoice_details_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('invoice_display_id') is not None:  # noqa: E501
            _query_params.append(('invoiceDisplayId', _params['invoice_display_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/finance/single-invoice-details', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_uiosi_report(self, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : date, delivery_period_end : date, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], timescale : Annotated[AuctionTimescale, Field(..., description="Auction Timescale")], **kwargs) -> bytearray:  # noqa: E501
        """get_finance_uiosi_report  # noqa: E501

        Fetch Finance UIoSI Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_uiosi_report(border_direction, delivery_period_start, delivery_period_end, x_participant_ids, timescale, async_req=True)
        >>> result = thread.get()

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_uiosi_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_uiosi_report_with_http_info(border_direction, delivery_period_start, delivery_period_end, x_participant_ids, timescale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_uiosi_report_with_http_info(self, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : date, delivery_period_end : date, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], timescale : Annotated[AuctionTimescale, Field(..., description="Auction Timescale")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_uiosi_report  # noqa: E501

        Fetch Finance UIoSI Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_uiosi_report_with_http_info(border_direction, delivery_period_start, delivery_period_end, x_participant_ids, timescale, async_req=True)
        >>> result = thread.get()

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'border_direction',
            'delivery_period_start',
            'delivery_period_end',
            'x_participant_ids',
            'timescale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_uiosi_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/finance/uiosi', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organisations_audit_logs_report(self, x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], period_start : date, period_end : date, domains : Optional[conlist(AuditLogDomain)] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_organisations_audit_logs_report  # noqa: E501

        Fetch Audit Logs Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisations_audit_logs_report(x_organisation_id, period_start, period_end, domains, async_req=True)
        >>> result = thread.get()

        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param domains:
        :type domains: List[AuditLogDomain]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_organisations_audit_logs_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_organisations_audit_logs_report_with_http_info(x_organisation_id, period_start, period_end, domains, **kwargs)  # noqa: E501

    @validate_arguments
    def get_organisations_audit_logs_report_with_http_info(self, x_organisation_id : Annotated[StrictStr, Field(..., description="Internal ID of an Organisation")], period_start : date, period_end : date, domains : Optional[conlist(AuditLogDomain)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_organisations_audit_logs_report  # noqa: E501

        Fetch Audit Logs Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisations_audit_logs_report_with_http_info(x_organisation_id, period_start, period_end, domains, async_req=True)
        >>> result = thread.get()

        :param x_organisation_id: Internal ID of an Organisation (required)
        :type x_organisation_id: str
        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param domains:
        :type domains: List[AuditLogDomain]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_organisation_id',
            'period_start',
            'period_end',
            'domains'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organisations_audit_logs_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('period_start') is not None:  # noqa: E501
            if isinstance(_params['period_start'], datetime):
                _query_params.append(('periodStart', _params['period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodStart', _params['period_start']))

        if _params.get('period_end') is not None:  # noqa: E501
            if isinstance(_params['period_end'], datetime):
                _query_params.append(('periodEnd', _params['period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodEnd', _params['period_end']))

        if _params.get('domains') is not None:  # noqa: E501
            _query_params.append(('domains', _params['domains']))
            _collection_formats['domains'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_organisation_id']:
            _header_params['X-Organisation-Id'] = _params['x_organisation_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/organisations/audit-logs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organisations_users_report(self, x_organisation_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Organisations")], statuses : Optional[conlist(UserStatus)] = None, roles : Optional[conlist(UserRole)] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_organisations_users_report  # noqa: E501

        Fetch Users Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_USERS`   * `VIEW_ANY_USERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisations_users_report(x_organisation_ids, statuses, roles, async_req=True)
        >>> result = thread.get()

        :param x_organisation_ids: List of internal IDs of Organisations (required)
        :type x_organisation_ids: List[str]
        :param statuses:
        :type statuses: List[UserStatus]
        :param roles:
        :type roles: List[UserRole]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_organisations_users_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_organisations_users_report_with_http_info(x_organisation_ids, statuses, roles, **kwargs)  # noqa: E501

    @validate_arguments
    def get_organisations_users_report_with_http_info(self, x_organisation_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Organisations")], statuses : Optional[conlist(UserStatus)] = None, roles : Optional[conlist(UserRole)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_organisations_users_report  # noqa: E501

        Fetch Users Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_USERS`   * `VIEW_ANY_USERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organisations_users_report_with_http_info(x_organisation_ids, statuses, roles, async_req=True)
        >>> result = thread.get()

        :param x_organisation_ids: List of internal IDs of Organisations (required)
        :type x_organisation_ids: List[str]
        :param statuses:
        :type statuses: List[UserStatus]
        :param roles:
        :type roles: List[UserRole]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_organisation_ids',
            'statuses',
            'roles'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organisations_users_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('statuses') is not None:  # noqa: E501
            _query_params.append(('statuses', _params['statuses']))
            _collection_formats['statuses'] = 'multi'

        if _params.get('roles') is not None:  # noqa: E501
            _query_params.append(('roles', _params['roles']))
            _collection_formats['roles'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_organisation_ids']:
            _header_params['X-Organisation-Ids'] = _params['x_organisation_ids']
            _collection_formats['X-Organisation-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/organisations/users', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_outages_curtailment_report(self, delivery_period_start : date, delivery_period_end : date, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], **kwargs) -> bytearray:  # noqa: E501
        """get_outages_curtailment_report  # noqa: E501

        Fetch Curtailment Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`   * `VIEW_CRISIS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_outages_curtailment_report(delivery_period_start, delivery_period_end, x_participant_ids, async_req=True)
        >>> result = thread.get()

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_outages_curtailment_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_outages_curtailment_report_with_http_info(delivery_period_start, delivery_period_end, x_participant_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_outages_curtailment_report_with_http_info(self, delivery_period_start : date, delivery_period_end : date, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_outages_curtailment_report  # noqa: E501

        Fetch Curtailment Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`   * `VIEW_CRISIS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_outages_curtailment_report_with_http_info(delivery_period_start, delivery_period_end, x_participant_ids, async_req=True)
        >>> result = thread.get()

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_period_start',
            'delivery_period_end',
            'x_participant_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outages_curtailment_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/outages/curtailment', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_trs_and_nominations_buy_now_report(self, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], statuses : conlist(BuyNowOfferStatus), delivery_period_start : date, delivery_period_end : date, validity_period_start : Optional[date] = None, validity_period_end : Optional[date] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_trs_and_nominations_buy_now_report  # noqa: E501

        Fetch Buy-Now Offers Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trs_and_nominations_buy_now_report(border_direction, timescales, statuses, delivery_period_start, delivery_period_end, validity_period_start, validity_period_end, async_req=True)
        >>> result = thread.get()

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param validity_period_start:
        :type validity_period_start: date
        :param validity_period_end:
        :type validity_period_end: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_trs_and_nominations_buy_now_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_trs_and_nominations_buy_now_report_with_http_info(border_direction, timescales, statuses, delivery_period_start, delivery_period_end, validity_period_start, validity_period_end, **kwargs)  # noqa: E501

    @validate_arguments
    def get_trs_and_nominations_buy_now_report_with_http_info(self, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], statuses : conlist(BuyNowOfferStatus), delivery_period_start : date, delivery_period_end : date, validity_period_start : Optional[date] = None, validity_period_end : Optional[date] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_trs_and_nominations_buy_now_report  # noqa: E501

        Fetch Buy-Now Offers Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trs_and_nominations_buy_now_report_with_http_info(border_direction, timescales, statuses, delivery_period_start, delivery_period_end, validity_period_start, validity_period_end, async_req=True)
        >>> result = thread.get()

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param validity_period_start:
        :type validity_period_start: date
        :param validity_period_end:
        :type validity_period_end: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'border_direction',
            'timescales',
            'statuses',
            'delivery_period_start',
            'delivery_period_end',
            'validity_period_start',
            'validity_period_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trs_and_nominations_buy_now_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescales') is not None:  # noqa: E501
            _query_params.append(('timescales', _params['timescales']))
            _collection_formats['timescales'] = 'multi'

        if _params.get('statuses') is not None:  # noqa: E501
            _query_params.append(('statuses', _params['statuses']))
            _collection_formats['statuses'] = 'multi'

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('validity_period_start') is not None:  # noqa: E501
            if isinstance(_params['validity_period_start'], datetime):
                _query_params.append(('validityPeriodStart', _params['validity_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('validityPeriodStart', _params['validity_period_start']))

        if _params.get('validity_period_end') is not None:  # noqa: E501
            if isinstance(_params['validity_period_end'], datetime):
                _query_params.append(('validityPeriodEnd', _params['validity_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('validityPeriodEnd', _params['validity_period_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/trs-and-nominations/buy-now', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_trs_and_nominations_overview_report(self, mtu_size : Annotated[MtuSize, Field(..., description="MTU Size definition")], type : AggregatedNominationType, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : date, delivery_period_end : date, x_participant_ids : Annotated[Optional[conlist(StrictStr)], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None, **kwargs) -> bytearray:  # noqa: E501
        """get_trs_and_nominations_overview_report  # noqa: E501

        Fetch Transmission Rights & Nominations Overview Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trs_and_nominations_overview_report(mtu_size, type, border_direction, delivery_period_start, delivery_period_end, x_participant_ids, async_req=True)
        >>> result = thread.get()

        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param type: (required)
        :type type: AggregatedNominationType
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_trs_and_nominations_overview_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_trs_and_nominations_overview_report_with_http_info(mtu_size, type, border_direction, delivery_period_start, delivery_period_end, x_participant_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_trs_and_nominations_overview_report_with_http_info(self, mtu_size : Annotated[MtuSize, Field(..., description="MTU Size definition")], type : AggregatedNominationType, border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : date, delivery_period_end : date, x_participant_ids : Annotated[Optional[conlist(StrictStr)], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_trs_and_nominations_overview_report  # noqa: E501

        Fetch Transmission Rights & Nominations Overview Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trs_and_nominations_overview_report_with_http_info(mtu_size, type, border_direction, delivery_period_start, delivery_period_end, x_participant_ids, async_req=True)
        >>> result = thread.get()

        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param type: (required)
        :type type: AggregatedNominationType
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'mtu_size',
            'type',
            'border_direction',
            'delivery_period_start',
            'delivery_period_end',
            'x_participant_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trs_and_nominations_overview_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('mtu_size') is not None:  # noqa: E501
            _query_params.append(('mtuSize', _params['mtu_size'].value))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type'].value))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/trs-and-nominations/overview', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_trs_and_nominations_proof_report(self, delivery_period_start : date, delivery_period_end : date, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], **kwargs) -> bytearray:  # noqa: E501
        """get_trs_and_nominations_proof_report  # noqa: E501

        Fetch Transmission Rights & Nominations Proof Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trs_and_nominations_proof_report(delivery_period_start, delivery_period_end, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_trs_and_nominations_proof_report_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_trs_and_nominations_proof_report_with_http_info(delivery_period_start, delivery_period_end, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_trs_and_nominations_proof_report_with_http_info(self, delivery_period_start : date, delivery_period_end : date, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_trs_and_nominations_proof_report  # noqa: E501

        Fetch Transmission Rights & Nominations Proof Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trs_and_nominations_proof_report_with_http_info(delivery_period_start, delivery_period_end, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_period_start',
            'delivery_period_end',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trs_and_nominations_proof_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/pdf', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/reporting/trs-and-nominations/proof', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
