# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint

from typing import List, Optional

from empire_platform_api_public_client.models.auction_batch import AuctionBatch
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_reduction_period import AuctionReductionPeriod
from empire_platform_api_public_client.models.auction_sort_by import AuctionSortBy
from empire_platform_api_public_client.models.auction_status import AuctionStatus
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.bidding_configuration_per_direction import BiddingConfigurationPerDirection
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.day_ahead_auction import DayAheadAuction
from empire_platform_api_public_client.models.day_ahead_or_intra_day_auction_bid_group import DayAheadOrIntraDayAuctionBidGroup
from empire_platform_api_public_client.models.day_ahead_or_intra_day_auction_bid_group_result_batch import DayAheadOrIntraDayAuctionBidGroupResultBatch
from empire_platform_api_public_client.models.day_ahead_or_intra_day_auction_mtu_results import DayAheadOrIntraDayAuctionMtuResults
from empire_platform_api_public_client.models.day_ahead_or_intra_day_auction_participant_results import DayAheadOrIntraDayAuctionParticipantResults
from empire_platform_api_public_client.models.day_ahead_or_intra_day_auction_results import DayAheadOrIntraDayAuctionResults
from empire_platform_api_public_client.models.intra_day_auction import IntraDayAuction
from empire_platform_api_public_client.models.long_term_auction import LongTermAuction
from empire_platform_api_public_client.models.long_term_auction_bid import LongTermAuctionBid
from empire_platform_api_public_client.models.long_term_auction_bid_result_batch import LongTermAuctionBidResultBatch
from empire_platform_api_public_client.models.long_term_auction_bid_sort_by import LongTermAuctionBidSortBy
from empire_platform_api_public_client.models.long_term_auction_results import LongTermAuctionResults
from empire_platform_api_public_client.models.submit_day_ahead_or_intra_day_bids_request import SubmitDayAheadOrIntraDayBidsRequest
from empire_platform_api_public_client.models.submit_long_term_bids_request import SubmitLongTermBidsRequest

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuctionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_auction_bidding_configuration(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> BiddingConfigurationPerDirection:  # noqa: E501
        """get_auction_bidding_configuration  # noqa: E501

        Fetch the Participant's Bidding Configuration for the given Auction's direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_LT_AUCTION_BIDS`   * `MANAGE_DA_ID_AUCTION_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_bidding_configuration(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BiddingConfigurationPerDirection
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_auction_bidding_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_auction_bidding_configuration_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_auction_bidding_configuration_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_auction_bidding_configuration  # noqa: E501

        Fetch the Participant's Bidding Configuration for the given Auction's direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_LT_AUCTION_BIDS`   * `MANAGE_DA_ID_AUCTION_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_bidding_configuration_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BiddingConfigurationPerDirection, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_bidding_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "BiddingConfigurationPerDirection",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/{id}/bidding-configuration', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_auction_reduction_periods(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> List[AuctionReductionPeriod]:  # noqa: E501
        """get_auction_reduction_periods  # noqa: E501

        Fetch reduction periods that possibly affects the Auction  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_reduction_periods(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[AuctionReductionPeriod]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_auction_reduction_periods_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_auction_reduction_periods_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_auction_reduction_periods_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_auction_reduction_periods  # noqa: E501

        Fetch reduction periods that possibly affects the Auction  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_reduction_periods_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[AuctionReductionPeriod], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_reduction_periods" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[AuctionReductionPeriod]",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/{id}/reduction-periods', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_auctions(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[AuctionSortBy, Field(..., description="Sort list by given attribute and direction")], border_direction : Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Auction Timescale (optional)")] = None, product_type : Annotated[Optional[AuctionProductType], Field(description="Auction Product Type (optional)")] = None, status : Annotated[Optional[AuctionStatus], Field(description="Filter for given status")] = None, bidding_period_start : Annotated[Optional[datetime], Field(description="Filter for start of bidding period")] = None, bidding_period_end : Annotated[Optional[datetime], Field(description="Filter for end of bidding period")] = None, delivery_period_start : Annotated[Optional[datetime], Field(description="Filter for start of delivery period (aligned to MTUs)")] = None, delivery_period_end : Annotated[Optional[datetime], Field(description="Filter for end of delivery period (aligned to MTUs)")] = None, query : Annotated[Optional[StrictStr], Field(description="Free text search in name")] = None, **kwargs) -> AuctionBatch:  # noqa: E501
        """get_auctions  # noqa: E501

        Paginated, sortable, filterable list of Auctions  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auctions(limit, offset, sort_by, border_direction, timescale, product_type, status, bidding_period_start, bidding_period_end, delivery_period_start, delivery_period_end, query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: AuctionSortBy
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (optional)
        :type timescale: AuctionTimescale
        :param product_type: Auction Product Type (optional)
        :type product_type: AuctionProductType
        :param status: Filter for given status
        :type status: AuctionStatus
        :param bidding_period_start: Filter for start of bidding period
        :type bidding_period_start: datetime
        :param bidding_period_end: Filter for end of bidding period
        :type bidding_period_end: datetime
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs)
        :type delivery_period_end: datetime
        :param query: Free text search in name
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuctionBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_auctions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_auctions_with_http_info(limit, offset, sort_by, border_direction, timescale, product_type, status, bidding_period_start, bidding_period_end, delivery_period_start, delivery_period_end, query, **kwargs)  # noqa: E501

    @validate_arguments
    def get_auctions_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[AuctionSortBy, Field(..., description="Sort list by given attribute and direction")], border_direction : Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Auction Timescale (optional)")] = None, product_type : Annotated[Optional[AuctionProductType], Field(description="Auction Product Type (optional)")] = None, status : Annotated[Optional[AuctionStatus], Field(description="Filter for given status")] = None, bidding_period_start : Annotated[Optional[datetime], Field(description="Filter for start of bidding period")] = None, bidding_period_end : Annotated[Optional[datetime], Field(description="Filter for end of bidding period")] = None, delivery_period_start : Annotated[Optional[datetime], Field(description="Filter for start of delivery period (aligned to MTUs)")] = None, delivery_period_end : Annotated[Optional[datetime], Field(description="Filter for end of delivery period (aligned to MTUs)")] = None, query : Annotated[Optional[StrictStr], Field(description="Free text search in name")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_auctions  # noqa: E501

        Paginated, sortable, filterable list of Auctions  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auctions_with_http_info(limit, offset, sort_by, border_direction, timescale, product_type, status, bidding_period_start, bidding_period_end, delivery_period_start, delivery_period_end, query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: AuctionSortBy
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (optional)
        :type timescale: AuctionTimescale
        :param product_type: Auction Product Type (optional)
        :type product_type: AuctionProductType
        :param status: Filter for given status
        :type status: AuctionStatus
        :param bidding_period_start: Filter for start of bidding period
        :type bidding_period_start: datetime
        :param bidding_period_end: Filter for end of bidding period
        :type bidding_period_end: datetime
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs)
        :type delivery_period_end: datetime
        :param query: Free text search in name
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuctionBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'border_direction',
            'timescale',
            'product_type',
            'status',
            'bidding_period_start',
            'bidding_period_end',
            'delivery_period_start',
            'delivery_period_end',
            'query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auctions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        if _params.get('product_type') is not None:  # noqa: E501
            _query_params.append(('productType', _params['product_type'].value))

        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status'].value))

        if _params.get('bidding_period_start') is not None:  # noqa: E501
            if isinstance(_params['bidding_period_start'], datetime):
                _query_params.append(('biddingPeriodStart', _params['bidding_period_start'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('biddingPeriodStart', _params['bidding_period_start']))

        if _params.get('bidding_period_end') is not None:  # noqa: E501
            if isinstance(_params['bidding_period_end'], datetime):
                _query_params.append(('biddingPeriodEnd', _params['bidding_period_end'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('biddingPeriodEnd', _params['bidding_period_end']))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "AuctionBatch",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_auction(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> DayAheadAuction:  # noqa: E501
        """get_day_ahead_auction  # noqa: E501

        Fetch a Day Ahead Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_auction(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DayAheadAuction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_auction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_auction_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_auction_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_auction  # noqa: E501

        Fetch a Day Ahead Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_auction_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DayAheadAuction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_auction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DayAheadAuction",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/day-ahead/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_bidding_results(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> DayAheadOrIntraDayAuctionBidGroupResultBatch:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_bidding_results  # noqa: E501

        Fetch Bidding Results for a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_bidding_results(id, limit, offset, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DayAheadOrIntraDayAuctionBidGroupResultBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_auction_bidding_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_auction_bidding_results_with_http_info(id, limit, offset, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_bidding_results_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_bidding_results  # noqa: E501

        Fetch Bidding Results for a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_bidding_results_with_http_info(id, limit, offset, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DayAheadOrIntraDayAuctionBidGroupResultBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'limit',
            'offset',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_auction_bidding_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DayAheadOrIntraDayAuctionBidGroupResultBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/day-ahead-or-intra-day/{id}/results/bidding', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_bids(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> List[DayAheadOrIntraDayAuctionBidGroup]:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_bids  # noqa: E501

        Fetch Bids for a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_DA_ID_AUCTION_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_bids(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[DayAheadOrIntraDayAuctionBidGroup]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_auction_bids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_auction_bids_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_bids_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_bids  # noqa: E501

        Fetch Bids for a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_DA_ID_AUCTION_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_bids_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[DayAheadOrIntraDayAuctionBidGroup], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_auction_bids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[DayAheadOrIntraDayAuctionBidGroup]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/day-ahead-or-intra-day/{id}/bids', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_mtu_results(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], mtu : datetime, **kwargs) -> DayAheadOrIntraDayAuctionMtuResults:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_mtu_results  # noqa: E501

        Fetch results for a given MTU in a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_mtu_results(id, mtu, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param mtu: (required)
        :type mtu: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DayAheadOrIntraDayAuctionMtuResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_auction_mtu_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_auction_mtu_results_with_http_info(id, mtu, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_mtu_results_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], mtu : datetime, **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_mtu_results  # noqa: E501

        Fetch results for a given MTU in a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_mtu_results_with_http_info(id, mtu, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param mtu: (required)
        :type mtu: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DayAheadOrIntraDayAuctionMtuResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'mtu'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_auction_mtu_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('mtu') is not None:  # noqa: E501
            if isinstance(_params['mtu'], datetime):
                _query_params.append(('mtu', _params['mtu'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('mtu', _params['mtu']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DayAheadOrIntraDayAuctionMtuResults",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/day-ahead-or-intra-day/{id}/results/mtus', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_participant_results(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], participant_id : StrictStr, **kwargs) -> DayAheadOrIntraDayAuctionParticipantResults:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_participant_results  # noqa: E501

        Fetch results for a given Participant in a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_participant_results(id, participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param participant_id: (required)
        :type participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DayAheadOrIntraDayAuctionParticipantResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_auction_participant_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_auction_participant_results_with_http_info(id, participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_participant_results_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], participant_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_participant_results  # noqa: E501

        Fetch results for a given Participant in a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_participant_results_with_http_info(id, participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param participant_id: (required)
        :type participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DayAheadOrIntraDayAuctionParticipantResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_auction_participant_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']

        if _params['participant_id']:
            _path_params['participantId'] = _params['participant_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DayAheadOrIntraDayAuctionParticipantResults",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/day-ahead-or-intra-day/{id}/results/participants/{participantId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_results(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> DayAheadOrIntraDayAuctionResults:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_results  # noqa: E501

        Fetch results for a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_results(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DayAheadOrIntraDayAuctionResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_auction_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_auction_results_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_auction_results_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_auction_results  # noqa: E501

        Fetch results for a Day Ahead or an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_auction_results_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DayAheadOrIntraDayAuctionResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_auction_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DayAheadOrIntraDayAuctionResults",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/day-ahead-or-intra-day/{id}/results', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_intra_day_auction(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> IntraDayAuction:  # noqa: E501
        """get_intra_day_auction  # noqa: E501

        Fetch an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_intra_day_auction(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IntraDayAuction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_intra_day_auction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_intra_day_auction_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_intra_day_auction_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_intra_day_auction  # noqa: E501

        Fetch an Intra Day Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_intra_day_auction_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IntraDayAuction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_intra_day_auction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "IntraDayAuction",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/intra-day/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_auction(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> LongTermAuction:  # noqa: E501
        """get_long_term_auction  # noqa: E501

        Fetch a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LongTermAuction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_auction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_auction_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_auction_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_auction  # noqa: E501

        Fetch a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LongTermAuction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_auction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "LongTermAuction",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/long-term/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_auction_bidding_results(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[LongTermAuctionBidSortBy, Field(..., description="Sort list by given attribute and direction")], x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> LongTermAuctionBidResultBatch:  # noqa: E501
        """get_long_term_auction_bidding_results  # noqa: E501

        Fetch Bidding Results for a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_bidding_results(id, limit, offset, sort_by, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: LongTermAuctionBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LongTermAuctionBidResultBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_auction_bidding_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_auction_bidding_results_with_http_info(id, limit, offset, sort_by, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_auction_bidding_results_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[LongTermAuctionBidSortBy, Field(..., description="Sort list by given attribute and direction")], x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_auction_bidding_results  # noqa: E501

        Fetch Bidding Results for a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_bidding_results_with_http_info(id, limit, offset, sort_by, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: LongTermAuctionBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LongTermAuctionBidResultBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'limit',
            'offset',
            'sort_by',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_auction_bidding_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "LongTermAuctionBidResultBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/long-term/{id}/results/bidding', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_auction_bids(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> List[LongTermAuctionBid]:  # noqa: E501
        """get_long_term_auction_bids  # noqa: E501

        Fetch Bids for a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_LT_AUCTION_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_bids(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[LongTermAuctionBid]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_auction_bids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_auction_bids_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_auction_bids_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_auction_bids  # noqa: E501

        Fetch Bids for a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_LT_AUCTION_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_bids_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[LongTermAuctionBid], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_auction_bids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[LongTermAuctionBid]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/long-term/{id}/bids', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_auction_results(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> LongTermAuctionResults:  # noqa: E501
        """get_long_term_auction_results  # noqa: E501

        Fetch results for a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_results(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LongTermAuctionResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_auction_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_auction_results_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_auction_results_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_auction_results  # noqa: E501

        Fetch results for a Long Term Auction by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_auction_results_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LongTermAuctionResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_auction_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "LongTermAuctionResults",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/auctions/long-term/{id}/results', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def submit_day_ahead_or_intra_day_auction_bids(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], submit_day_ahead_or_intra_day_bids_request : SubmitDayAheadOrIntraDayBidsRequest, **kwargs) -> None:  # noqa: E501
        """submit_day_ahead_or_intra_day_auction_bids  # noqa: E501

        Submit a collection of Bids for Day Ahead or Intra Day Auctions  Rules for creating/updating/deleting Bids:   - a full list of every valid bid need to be always submitted   - Bids that are not yet present in the system need to be sent with NULL identifiers   - Bids to be edited need to be sent with their respective identifiers   - Bids to be deleted need to be left out from the list to be submitted  ---  __Requires Permission:__ (at least one)   * `MANAGE_DA_ID_AUCTION_BIDS`  __Generates Audit Log Entry:__ `SUBMIT_DAY_AHEAD_OR_INTRA_DAY_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_day_ahead_or_intra_day_auction_bids(id, submit_day_ahead_or_intra_day_bids_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param submit_day_ahead_or_intra_day_bids_request: (required)
        :type submit_day_ahead_or_intra_day_bids_request: SubmitDayAheadOrIntraDayBidsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the submit_day_ahead_or_intra_day_auction_bids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.submit_day_ahead_or_intra_day_auction_bids_with_http_info(id, submit_day_ahead_or_intra_day_bids_request, **kwargs)  # noqa: E501

    @validate_arguments
    def submit_day_ahead_or_intra_day_auction_bids_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], submit_day_ahead_or_intra_day_bids_request : SubmitDayAheadOrIntraDayBidsRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """submit_day_ahead_or_intra_day_auction_bids  # noqa: E501

        Submit a collection of Bids for Day Ahead or Intra Day Auctions  Rules for creating/updating/deleting Bids:   - a full list of every valid bid need to be always submitted   - Bids that are not yet present in the system need to be sent with NULL identifiers   - Bids to be edited need to be sent with their respective identifiers   - Bids to be deleted need to be left out from the list to be submitted  ---  __Requires Permission:__ (at least one)   * `MANAGE_DA_ID_AUCTION_BIDS`  __Generates Audit Log Entry:__ `SUBMIT_DAY_AHEAD_OR_INTRA_DAY_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_day_ahead_or_intra_day_auction_bids_with_http_info(id, submit_day_ahead_or_intra_day_bids_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param submit_day_ahead_or_intra_day_bids_request: (required)
        :type submit_day_ahead_or_intra_day_bids_request: SubmitDayAheadOrIntraDayBidsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id',
            'submit_day_ahead_or_intra_day_bids_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_day_ahead_or_intra_day_auction_bids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['submit_day_ahead_or_intra_day_bids_request'] is not None:
            _body_params = _params['submit_day_ahead_or_intra_day_bids_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/auctions/day-ahead-or-intra-day/{id}/bids', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def submit_long_term_auction_bids(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], submit_long_term_bids_request : SubmitLongTermBidsRequest, **kwargs) -> None:  # noqa: E501
        """submit_long_term_auction_bids  # noqa: E501

        Submit a collection of Bids for Long Term Auctions  Rules for creating/updating/deleting Bids:   - a full list of every valid bid need to be always submitted   - Bids that are not yet present in the system need to be sent with NULL identifiers   - Bids to be edited need to be sent with their respective identifiers   - Bids to be deleted need to be left out from the list to be submitted  ---  __Requires Permission:__ (at least one)   * `MANAGE_LT_AUCTION_BIDS`  __Generates Audit Log Entry:__ `SUBMIT_LONG_TERM_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_long_term_auction_bids(id, submit_long_term_bids_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param submit_long_term_bids_request: (required)
        :type submit_long_term_bids_request: SubmitLongTermBidsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the submit_long_term_auction_bids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.submit_long_term_auction_bids_with_http_info(id, submit_long_term_bids_request, **kwargs)  # noqa: E501

    @validate_arguments
    def submit_long_term_auction_bids_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], submit_long_term_bids_request : SubmitLongTermBidsRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """submit_long_term_auction_bids  # noqa: E501

        Submit a collection of Bids for Long Term Auctions  Rules for creating/updating/deleting Bids:   - a full list of every valid bid need to be always submitted   - Bids that are not yet present in the system need to be sent with NULL identifiers   - Bids to be edited need to be sent with their respective identifiers   - Bids to be deleted need to be left out from the list to be submitted  ---  __Requires Permission:__ (at least one)   * `MANAGE_LT_AUCTION_BIDS`  __Generates Audit Log Entry:__ `SUBMIT_LONG_TERM_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_long_term_auction_bids_with_http_info(id, submit_long_term_bids_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param submit_long_term_bids_request: (required)
        :type submit_long_term_bids_request: SubmitLongTermBidsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id',
            'submit_long_term_bids_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_long_term_auction_bids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['submit_long_term_bids_request'] is not None:
            _body_params = _params['submit_long_term_bids_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/auctions/long-term/{id}/bids', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
