# coding: utf-8

"""
    Fox API

     Warning: Please add a custom user agent header to your requests. This would help us fighting against DDoS attacks in future, while keeping your application's access to the API. In future, this may be a mandatory requirement.  To reduce the system load, the API endpoints are rate limited. The default limit is 30 requests per minute. Contact admin@orangefox.tech if you need a higher limit.  The requests may be logged for analytics and development purposes. 

    The version of the OpenAPI document: 5.3.0
    Contact: admin@orangefox.tech
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PasteOutput(BaseModel):
    """
    PasteOutput
    """ # noqa: E501
    id: StrictStr = Field(description="Paste ID")
    content: StrictStr = Field(description="The text content of the paste")
    created_at: datetime = Field(description="When the paste was created")
    is_owner: Optional[StrictBool] = Field(default=None, alias="isOwner")
    __properties: ClassVar[List[str]] = ["id", "content", "created_at", "isOwner"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PasteOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if is_owner (nullable) is None
        # and model_fields_set contains the field
        if self.is_owner is None and "is_owner" in self.model_fields_set:
            _dict['isOwner'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PasteOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "content": obj.get("content"),
            "created_at": obj.get("created_at"),
            "isOwner": obj.get("isOwner")
        })
        return _obj


