# generated by datamodel-codegen:
#   filename:  api_constrained.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from pydantic import AnyUrl, BaseModel, Field, RootModel, confloat, conint, constr


class Pet(BaseModel):
    id: conint(ge=0, le=9223372036854775807)
    name: constr(max_length=256)
    tag: constr(max_length=64) | None = None


class Pets(RootModel[list[Pet]]):
    root: list[Pet] = Field(..., max_length=10, min_length=1)


class UID(RootModel[conint(ge=0)]):
    root: conint(ge=0)


class Phone(RootModel[constr(min_length=3)]):
    root: constr(min_length=3)


class User(BaseModel):
    id: conint(ge=0)
    name: constr(max_length=256)
    tag: constr(max_length=64) | None = None
    uid: UID
    phones: list[Phone] | None = Field(None, max_length=10)
    fax: list[constr(min_length=3)] | None = None
    height: conint(ge=1, le=300) | confloat(ge=1.0, le=300.0) | None = None
    weight: confloat(ge=1.0, le=1000.0) | conint(ge=1, le=1000) | None = None
    age: conint(le=200, gt=0) | None = None
    rating: confloat(le=5.0, gt=0.0) | None = None


class Users(RootModel[list[User]]):
    root: list[User]


class Id(RootModel[str]):
    root: str


class Rules(RootModel[list[str]]):
    root: list[str]


class Error(BaseModel):
    code: int
    message: str


class Api(BaseModel):
    apiKey: str | None = Field(
        None, description='To be used as a dataset parameter value'
    )
    apiVersionNumber: str | None = Field(
        None, description='To be used as a version parameter value'
    )
    apiUrl: AnyUrl | None = Field(
        None, description="The URL describing the dataset's fields"
    )
    apiDocumentationUrl: AnyUrl | None = Field(
        None, description='A URL to the API console for each API'
    )


class Apis(RootModel[list[Api]]):
    root: list[Api]


class Event(BaseModel):
    name: str | None = None


class Result(BaseModel):
    event: Event | None = None
