# generated by datamodel-codegen:
#   filename:  api_constrained.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from pydantic import AnyUrl, BaseModel, Field


class Pet(BaseModel):
    id: int = Field(..., ge=0, le=9223372036854775807)
    name: str = Field(..., max_length=256)
    tag: str | None = Field(None, max_length=64)


class Pets(BaseModel):
    __root__: list[Pet] = Field(..., max_items=10, min_items=1, unique_items=True)


class UID(BaseModel):
    __root__: int = Field(..., ge=0)


class Phone(BaseModel):
    __root__: str = Field(..., min_length=3)


class FaxItem(BaseModel):
    __root__: str = Field(..., min_length=3)


class User(BaseModel):
    id: int = Field(..., ge=0)
    name: str = Field(..., max_length=256)
    tag: str | None = Field(None, max_length=64)
    uid: UID
    phones: list[Phone] | None = Field(None, max_items=10)
    fax: list[FaxItem] | None = None
    height: int | float | None = Field(None, ge=1.0, le=300.0)
    weight: float | int | None = Field(None, ge=1.0, le=1000.0)
    age: int | None = Field(None, gt=0, le=200)
    rating: float | None = Field(None, gt=0.0, le=5.0)


class Users(BaseModel):
    __root__: list[User]


class Id(BaseModel):
    __root__: str


class Rules(BaseModel):
    __root__: list[str]


class Error(BaseModel):
    code: int
    message: str


class Api(BaseModel):
    apiKey: str | None = Field(
        None, description='To be used as a dataset parameter value'
    )
    apiVersionNumber: str | None = Field(
        None, description='To be used as a version parameter value'
    )
    apiUrl: AnyUrl | None = Field(
        None, description="The URL describing the dataset's fields"
    )
    apiDocumentationUrl: AnyUrl | None = Field(
        None, description='A URL to the API console for each API'
    )


class Apis(BaseModel):
    __root__: list[Api]


class Event(BaseModel):
    name: str | None = None


class Result(BaseModel):
    event: Event | None = None
