# generated by datamodel-codegen:
#   filename:  api_constrained.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Annotated, TypeAlias

from msgspec import UNSET, Meta, Struct, UnsetType


class Pet(Struct):
    id: Annotated[int, Meta(ge=0, le=9223372036854775807)]
    name: Annotated[str, Meta(max_length=256)]
    tag: Annotated[str, Meta(max_length=64)] | UnsetType = UNSET


Pets: TypeAlias = list[Pet]


UID: TypeAlias = Annotated[int, Meta(ge=0)]


Phone: TypeAlias = Annotated[str, Meta(min_length=3)]


FaxItem: TypeAlias = Annotated[str, Meta(min_length=3)]


class User(Struct):
    id: Annotated[int, Meta(ge=0)]
    name: Annotated[str, Meta(max_length=256)]
    uid: UID
    tag: Annotated[str, Meta(max_length=64)] | UnsetType = UNSET
    phones: list[Phone] | UnsetType = UNSET
    fax: list[FaxItem] | UnsetType = UNSET
    height: Annotated[int | float, Meta(ge=1.0, le=300.0)] | UnsetType = UNSET
    weight: Annotated[float | int, Meta(ge=1.0, le=1000.0)] | UnsetType = UNSET
    age: Annotated[int, Meta(gt=0, le=200)] | UnsetType = UNSET
    rating: Annotated[float, Meta(gt=0.0, le=5.0)] | UnsetType = UNSET


Users: TypeAlias = list[User]


Id: TypeAlias = str


Rules: TypeAlias = list[str]


class Error(Struct):
    code: int
    message: str


class Api(Struct):
    apiKey: (
        Annotated[str, Meta(description='To be used as a dataset parameter value')]
        | UnsetType
    ) = UNSET
    apiVersionNumber: (
        Annotated[str, Meta(description='To be used as a version parameter value')]
        | UnsetType
    ) = UNSET
    apiUrl: (
        Annotated[
            str,
            Meta(description="The URL describing the dataset's fields", min_length=1),
        ]
        | UnsetType
    ) = UNSET
    apiDocumentationUrl: (
        Annotated[str, Meta(description='A URL to the API console for each API')]
        | UnsetType
    ) = UNSET


Apis: TypeAlias = list[Api]


class Event(Struct):
    name: str | UnsetType = UNSET


class Result(Struct):
    event: Event | UnsetType = UNSET
