# generated by datamodel-codegen:
#   filename:  api.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from pydantic import AnyUrl, Field

from custom_module import Base


class Pet(Base):
    id: int
    name: str
    tag: str | None = None


class Pets(Base):
    __root__: list[Pet]


class User(Base):
    id: int
    name: str
    tag: str | None = None


class Users(Base):
    __root__: list[User]


class Id(Base):
    __root__: str


class Rules(Base):
    __root__: list[str]


class Error(Base):
    code: int
    message: str


class Api(Base):
    apiKey: str | None = Field(
        None, description='To be used as a dataset parameter value'
    )
    apiVersionNumber: str | None = Field(
        None, description='To be used as a version parameter value'
    )
    apiUrl: AnyUrl | None = Field(
        None, description="The URL describing the dataset's fields"
    )
    apiDocumentationUrl: AnyUrl | None = Field(
        None, description='A URL to the API console for each API'
    )


class Apis(Base):
    __root__: list[Api]


class Event(Base):
    name: str | None = None


class Result(Base):
    event: Event | None = None
