# generated by datamodel-codegen:
#   filename:  allof_with_required_inherited_comprehensive.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from enum import Enum
from typing import Any

from pydantic import BaseModel, constr


class Status(Enum):
    active = 'active'
    inactive = 'inactive'


class BaseType(BaseModel):
    id: int | None = None


class ObjectWithProps(BaseModel):
    nested: str | None = None


class AllofPrimitivesWithConstraints(BaseModel):
    pass


class AllofWithPattern(BaseModel):
    pass


class AllofWithUnique(BaseModel):
    pass


class Level2(BaseModel):
    level3: str | None = None


class Level1(BaseModel):
    level2: Level2 | None = None


class DeepNested(BaseModel):
    level1: Level1 | None = None


class ProjectedEntity(BaseModel):
    primitive_string: str | None = None
    primitive_int: int | None = None
    primitive_number: float | None = None
    primitive_bool: bool | None = None
    ref_field: BaseType | None = None
    enum_field: Status | None = None
    array_with_ref: list[BaseType] | None = None
    array_with_primitive: list[str] | None = None
    object_with_props: ObjectWithProps | None = None
    object_with_additional: dict[str, int] | None = None
    anyof_field: str | int | None = None
    oneof_field: bool | float | None = None
    allof_single_ref: BaseType | None = None
    allof_multiple_refs: BaseType | None = None
    allof_primitives_with_constraints: AllofPrimitivesWithConstraints | None = None
    allof_with_pattern: AllofWithPattern | None = None
    allof_with_unique: AllofWithUnique | None = None
    type_list: str | None = None
    deep_nested: DeepNested | None = None


class Entity(ProjectedEntity):
    extra: str | None = None
    primitive_string: str
    primitive_int: int
    primitive_number: float
    primitive_bool: bool
    ref_field: BaseType
    enum_field: Status
    array_with_ref: list[BaseType]
    array_with_primitive: list[str]
    object_with_props: dict[str, Any]
    object_with_additional: dict[str, int]
    anyof_field: str | int
    oneof_field: bool | float
    allof_single_ref: BaseType
    allof_multiple_refs: BaseType
    allof_primitives_with_constraints: constr(min_length=5, max_length=100)
    allof_with_pattern: constr(regex=r'(?=^[a-z]+)(?=[0-9]$)')
    allof_with_unique: list[str]
    type_list: str | None
    deep_nested: dict[str, Any]
