# generated by datamodel-codegen:
#   filename:  pydantic_v2_dataclass_field.json
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Any

from pydantic import Field, confloat, conint, constr
from pydantic.dataclasses import dataclass


@dataclass
class Product:
    price: confloat(ge=0.0, multiple_of=0.01, lt=1000000.0)
    id: int = Field(..., description='Product identifier')
    name: constr(min_length=1, max_length=100) = Field(..., title='Product Name')
    quantity: conint(ge=0) | None = 0
    discount_rate: confloat(ge=0.0, le=1.0) | None = 0.0
    tags: list[str] | None = []
    metadata: dict[str, Any] | None = {}
