# generated by datamodel-codegen:
#   filename:  allof_root_model_constraints.json
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Any

from pydantic import BaseModel, ConfigDict, EmailStr, Field, RootModel, conint, constr


class StringDatatype(RootModel[constr(pattern=r'^\S(.*\S)?$')]):
    root: constr(pattern=r'^\S(.*\S)?$') = Field(..., description='A base string type.')


class ConstrainedStringDatatype(RootModel[str]):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    root: constr(pattern=r'(?=^\S(.*\S)?$)(?=^[A-Z].*)', min_length=1) = Field(
        ..., description='A constrained string.'
    )


class IntegerDatatype(RootModel[int]):
    root: int = Field(..., description='A whole number.')


class NonNegativeIntegerDatatype(RootModel[conint(ge=0)]):
    root: conint(ge=0) = Field(..., description='Non-negative integer.')


class BoundedIntegerDatatype(RootModel[conint(ge=0, le=100)]):
    root: conint(ge=0, le=100) = Field(..., description='Integer between 0 and 100.')


class EmailDatatype(RootModel[EmailStr]):
    root: EmailStr = Field(..., description='Email with format.')


class FormattedStringDatatype(RootModel[EmailStr]):
    root: EmailStr = Field(..., description='A string with email format.')


class ObjectBase(BaseModel):
    id: int | None = None


class ObjectWithAllOf(ObjectBase):
    name: str | None = None


class MultiRefAllOf(BaseModel):
    pass


class NoConstraintAllOf(BaseModel):
    pass


class IncompatibleTypeAllOf(BaseModel):
    pass


class ConstraintWithProperties(BaseModel):
    extra: str | None = None


class ConstraintWithItems(BaseModel):
    pass


class NumberIntegerCompatible(RootModel[conint(ge=0)]):
    root: conint(ge=0) = Field(..., description='Number and integer are compatible.')


class RefWithSchemaKeywords(
    RootModel[constr(pattern=r'^\S(.*\S)?$', min_length=5, max_length=100)]
):
    root: constr(pattern=r'^\S(.*\S)?$', min_length=5, max_length=100) = Field(
        ..., description='Ref with additional schema keywords.'
    )


class ArrayDatatype(RootModel[list[str]]):
    root: list[str]


class RefToArrayAllOf(BaseModel):
    pass


class ObjectNoPropsDatatype(BaseModel):
    pass


class RefToObjectNoPropsAllOf(ObjectNoPropsDatatype):
    pass


class PatternPropsDatatype(RootModel[dict[constr(pattern=r'^S_'), str]]):
    root: dict[constr(pattern=r'^S_'), str]


class RefToPatternPropsAllOf(BaseModel):
    pass


class NestedAllOfDatatype(BaseModel):
    pass


class RefToNestedAllOfAllOf(NestedAllOfDatatype):
    pass


class ConstraintsOnlyDatatype(RootModel[Any]):
    root: Any = Field(..., description='Constraints only, no type.')


class RefToConstraintsOnlyAllOf(RootModel[Any]):
    root: Any = Field(..., description='Ref to constraints-only schema.')


class NoDescriptionAllOf(RootModel[constr(pattern=r'^\S(.*\S)?$', min_length=5)]):
    root: constr(pattern=r'^\S(.*\S)?$', min_length=5) = Field(
        ..., description='A base string type.'
    )


class EmptyConstraintItemAllOf(
    RootModel[constr(pattern=r'^\S(.*\S)?$', max_length=50)]
):
    root: constr(pattern=r'^\S(.*\S)?$', max_length=50) = Field(
        ..., description='AllOf with empty constraint item.'
    )


class ConflictingFormatAllOf(BaseModel):
    pass


class Model(BaseModel):
    name: ConstrainedStringDatatype | None = None
    count: NonNegativeIntegerDatatype | None = None
    percentage: BoundedIntegerDatatype | None = None
    email: EmailDatatype | None = None
    obj: ObjectWithAllOf | None = None
    multi: MultiRefAllOf | None = None
    noconstraint: NoConstraintAllOf | None = None
    incompatible: IncompatibleTypeAllOf | None = None
    withprops: ConstraintWithProperties | None = None
    withitems: ConstraintWithItems | None = None
    numint: NumberIntegerCompatible | None = None
    refwithkw: RefWithSchemaKeywords | None = None
    refarr: RefToArrayAllOf | None = None
    refobjnoprops: RefToObjectNoPropsAllOf | None = None
    refpatternprops: RefToPatternPropsAllOf | None = None
    refnestedallof: RefToNestedAllOfAllOf | None = None
    refconstraintsonly: RefToConstraintsOnlyAllOf | None = None
    nodescription: NoDescriptionAllOf | None = None
    emptyconstraint: EmptyConstraintItemAllOf | None = None
    conflictingformat: ConflictingFormatAllOf | None = None
