# generated by datamodel-codegen:
#   filename:  union.graphql
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Literal, Union

from pydantic import BaseModel, Field
from typing_extensions import TypeAliasType

Boolean = TypeAliasType("Boolean", bool)
"""
The `Boolean` scalar type represents `true` or `false`.
"""


ID = TypeAliasType("ID", str)
"""
The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
"""


Int = TypeAliasType("Int", int)
"""
The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.
"""


String = TypeAliasType("String", str)
"""
The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
"""


class IResource(BaseModel):
    id: ID
    typename__: Literal['IResource'] | None = Field('IResource', alias='__typename')


class Car(IResource):
    id: ID
    passenger_capacity: Int = Field(..., alias='passengerCapacity')
    typename__: Literal['Car'] | None = Field('Car', alias='__typename')


class Employee(IResource):
    first_name: String | None = Field(None, alias='firstName')
    id: ID
    last_name: String | None = Field(None, alias='lastName')
    typename__: Literal['Employee'] | None = Field('Employee', alias='__typename')


Resource = TypeAliasType(
    "Resource",
    Union[
        'Car',
        'Employee',
    ],
)


TechnicalResource = TypeAliasType("TechnicalResource", Car)
