# generated by datamodel-codegen:
#   filename:  simple-star-wars.graphql
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from dataclasses import dataclass
from typing import Literal, TypeAlias

Boolean: TypeAlias = bool
"""
The `Boolean` scalar type represents `true` or `false`.
"""


ID: TypeAlias = str
"""
The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
"""


Int: TypeAlias = int
"""
The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.
"""


String: TypeAlias = str
"""
The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
"""


@dataclass(frozen=True, kw_only=True)
class Film:
    characters: list[Person]
    characters_ids: list[ID]
    director: String
    episode_id: Int
    id: ID
    opening_crawl: String
    planets: list[Planet]
    planets_ids: list[ID]
    release_date: String
    species: list[Species]
    species_ids: list[ID]
    starships: list[Starship]
    starships_ids: list[ID]
    title: String
    vehicles: list[Vehicle]
    vehicles_ids: list[ID]
    producer: String | None = None
    typename__: Literal['Film'] | None = 'Film'


@dataclass(frozen=True, kw_only=True)
class Person:
    films: list[Film]
    films_ids: list[ID]
    id: ID
    name: String
    species: list[Species]
    species_ids: list[ID]
    starships: list[Starship]
    starships_ids: list[ID]
    vehicles: list[Vehicle]
    vehicles_ids: list[ID]
    birth_year: String | None = None
    eye_color: String | None = None
    gender: String | None = None
    hair_color: String | None = None
    height: Int | None = None
    homeworld: Planet | None = None
    homeworld_id: ID | None = None
    mass: Int | None = None
    skin_color: String | None = None
    typename__: Literal['Person'] | None = 'Person'


@dataclass(frozen=True, kw_only=True)
class Planet:
    films: list[Film]
    films_ids: list[ID]
    id: ID
    name: String
    residents: list[Person]
    residents_ids: list[ID]
    climate: String | None = None
    diameter: String | None = None
    gravity: String | None = None
    orbital_period: String | None = None
    population: String | None = None
    rotation_period: String | None = None
    surface_water: String | None = None
    terrain: String | None = None
    typename__: Literal['Planet'] | None = 'Planet'


@dataclass(frozen=True, kw_only=True)
class Species:
    films: list[Film]
    films_ids: list[ID]
    id: ID
    name: String
    people: list[Person]
    people_ids: list[ID]
    average_height: String | None = None
    average_lifespan: String | None = None
    classification: String | None = None
    designation: String | None = None
    eye_colors: String | None = None
    hair_colors: String | None = None
    language: String | None = None
    skin_colors: String | None = None
    typename__: Literal['Species'] | None = 'Species'


@dataclass(frozen=True, kw_only=True)
class Starship:
    films: list[Film]
    films_ids: list[ID]
    id: ID
    name: String
    pilots: list[Person]
    pilots_ids: list[ID]
    MGLT: String | None = None
    cargo_capacity: String | None = None
    consumables: String | None = None
    cost_in_credits: String | None = None
    crew: String | None = None
    hyperdrive_rating: String | None = None
    length: String | None = None
    manufacturer: String | None = None
    max_atmosphering_speed: String | None = None
    model: String | None = None
    passengers: String | None = None
    starship_class: String | None = None
    typename__: Literal['Starship'] | None = 'Starship'


@dataclass(frozen=True, kw_only=True)
class Vehicle:
    films: list[Film]
    films_ids: list[ID]
    id: ID
    name: String
    pilots: list[Person]
    pilots_ids: list[ID]
    cargo_capacity: String | None = None
    consumables: String | None = None
    cost_in_credits: String | None = None
    crew: String | None = None
    length: String | None = None
    manufacturer: String | None = None
    max_atmosphering_speed: String | None = None
    model: String | None = None
    passengers: String | None = None
    vehicle_class: String | None = None
    typename__: Literal['Vehicle'] | None = 'Vehicle'
