"""Auto-generated prompt data from cli_doc collection.

DO NOT EDIT MANUALLY. Run: python scripts/build_prompt_data.py
"""

from __future__ import annotations

# Option descriptions extracted from cli_doc markers
OPTION_DESCRIPTIONS: dict[str, str] = {
    "--additional-imports": "Add custom imports to generated output files.",
    "--aliases": "Apply custom field and class name aliases from JSON file.",
    "--all-exports-collision-strategy": "Handle name collisions when exporting recursive module hierarchies.",
    "--all-exports-scope": "Generate __all__ exports for child modules in __init__.py files.",
    "--allof-class-hierarchy": "Controls how allOf schemas are represented in the generated class hierarchy.",
    "--allof-merge-mode": "Merge constraints from root model references in allOf schemas.",
    "--allow-extra-fields": "Allow extra fields in generated Pydantic models (extra='allow').",
    "--allow-population-by-field-name": "Allow Pydantic model population by field name (not just alias).",
    "--base-class": "Specify a custom base class for generated models.",
    "--base-class-map": "Specify different base classes for specific models via JSON mapping.",
    "--capitalize-enum-members": "Capitalize enum member names to UPPER_CASE format.",
    "--check": "Verify generated code matches existing output without modifying files.",
    "--class-decorators": "Add custom decorators to generated model classes.",
    "--class-name": "Override the auto-generated class name with a custom name.",
    "--class-name-affix-scope": "Control which classes receive the prefix/suffix.",
    "--class-name-prefix": "Add a prefix to all generated class names.",
    "--class-name-suffix": "Add a suffix to all generated class names.",
    "--collapse-reuse-models": "Collapse duplicate models by replacing references instead of inheritance.",
    "--collapse-root-models": "Inline root model definitions instead of creating separate wrapper classes.",
    "--collapse-root-models-name-strategy": "Select which name to keep when collapsing root models with object refe...",
    "--custom-file-header": "Add custom header text to the generated file.",
    "--custom-file-header-path": "Add custom header content from file to generated code.",
    "--custom-formatters": "Apply custom Python code formatters to generated output.",
    "--custom-formatters-kwargs": "Pass custom arguments to custom formatters via JSON file.",
    "--custom-template-dir": "Use custom Jinja2 templates for model generation.",
    "--dataclass-arguments": "Customize dataclass decorator arguments via JSON dictionary.",
    "--default-values": "Override field default values from external JSON file.",
    "--disable-appending-item-suffix": "Disable appending 'Item' suffix to array item types.",
    "--disable-future-imports": "Prevent automatic addition of __future__ imports in generated code.",
    "--disable-timestamp": "Disable timestamp in generated file header for reproducible output.",
    "--disable-warnings": "Suppress warning messages during code generation.",
    "--duplicate-name-suffix": "Customize suffix for duplicate model names.",
    "--empty-enum-field-name": "Name for empty string enum field values.",
    "--enable-command-header": "Include command-line options in file header for reproducibility.",
    "--enable-faux-immutability": "Enable faux immutability in Pydantic v1 models (allow_mutation=False).",
    "--enable-version-header": "Include tool version information in file header.",
    "--encoding": "Specify character encoding for input and output files.",
    "--enum-field-as-literal": "Convert all enum fields to Literal types instead of Enum classes.",
    "--enum-field-as-literal-map": "Override enum/literal generation per-field via JSON mapping.",
    "--extra-fields": "Configure how generated models handle extra fields not defined in schema.",
    "--extra-template-data": "Pass custom template variables from JSON file for code generation.",
    "--field-constraints": "Generate Field() with validation constraints from schema.",
    "--field-extra-keys": "Include specific extra keys in Field() definitions.",
    "--field-extra-keys-without-x-prefix": "Include schema extension keys in Field() without requiring 'x-' prefix.",
    "--field-include-all-keys": "Include all schema keys in Field() json_schema_extra.",
    "--field-type-collision-strategy": "Rename type class instead of field when names collide (Pydantic v2 only).",
    "--force-optional": "Force all fields to be Optional regardless of required status.",
    "--formatters": "Specify code formatters to apply to generated output.",
    "--frozen-dataclasses": "Generate frozen dataclasses with optional keyword-only fields.",
    "--generate-cli-command": "Generate CLI command from pyproject.toml configuration.",
    "--generate-pyproject-config": "Generate pyproject.toml configuration from CLI arguments.",
    "--graphql-no-typename": "Exclude __typename field from generated GraphQL models.",
    "--http-headers": "Fetch schema from URL with custom HTTP headers.",
    "--http-ignore-tls": "Disable TLS certificate verification for HTTPS requests.",
    "--http-query-parameters": "Add query parameters to HTTP requests for remote schemas.",
    "--http-timeout": "Set timeout for HTTP requests to remote hosts.",
    "--ignore-enum-constraints": "Ignore enum constraints and use base string type instead of Enum classes.",
    "--ignore-pyproject": "Ignore pyproject.toml configuration file.",
    "--include-path-parameters": "Include OpenAPI path parameters in generated parameter models.",
    "--input": "Specify the input schema file path.",
    "--input-file-type": "Specify the input file type for code generation.",
    "--input-model": "Import a Python type or dict schema from a module.",
    "--input-model-ref-strategy": "Strategy for referenced types when using --input-model.",
    "--keep-model-order": "Keep model definition order as specified in schema.",
    "--keyword-only": "Generate dataclasses with keyword-only fields (Python 3.10+).",
    "--model-extra-keys": "Add model-level schema extensions to ConfigDict json_schema_extra.",
    "--model-extra-keys-without-x-prefix": "Strip x- prefix from model-level schema extensions and add to ConfigDic...",
    "--module-split-mode": "Split generated models into separate files, one per model class.",
    "--naming-strategy": "Use parent-prefixed naming strategy for duplicate model names.",
    "--no-alias": "Disable Field alias generation for non-Python-safe property names.",
    "--no-treat-dot-as-module": "Keep dots in schema names as underscores for flat output.",
    "--no-use-specialized-enum": "Disable specialized Enum classes for Python 3.11+ code generation.",
    "--no-use-standard-collections": "Use typing.Dict/List instead of built-in dict/list for container types.",
    "--no-use-union-operator": "Use Union[X, Y] / Optional[X] instead of X | Y union operator.",
    "--openapi-include-paths": "Filter OpenAPI paths to include in model generation.",
    "--openapi-scopes": "Specify OpenAPI scopes to generate (schemas, paths, parameters).",
    "--original-field-name-delimiter": "Specify delimiter for original field names when using snake-case conversion.",
    "--output": "Specify the destination path for generated Python code.",
    "--output-date-class": "Specify date class type for date schema fields.",
    "--output-datetime-class": "Specify datetime class type for date-time schema fields.",
    "--output-model-type": "Generate models from GraphQL with different output model types.",
    "--parent-scoped-naming": "Namespace models by their parent scope to avoid naming conflicts.",
    "--read-only-write-only-model-type": "Generate separate request and response models for readOnly/writeOnly fields.",
    "--remove-special-field-name-prefix": "Remove the special prefix from field names.",
    "--reuse-model": "Reuse identical model definitions instead of generating duplicates.",
    "--reuse-scope": "Scope for model reuse detection (root or tree).",
    "--set-default-enum-member": "Set the first enum member as the default value for enum fields.",
    "--shared-module-name": "Customize the name of the shared module for deduplicated models.",
    "--skip-root-model": "Skip generation of root model when schema contains nested definitions.",
    "--snake-case-field": "Convert field names to snake_case format.",
    "--special-field-name-prefix": "Prefix to add to special field names (like reserved keywords).",
    "--strict-nullable": "Treat default field as a non-nullable field.",
    "--strict-types": "Enable strict type validation for specified Python types.",
    "--strip-default-none": "Remove fields with None as default value from generated models.",
    "--target-pydantic-version": "Target Pydantic version for generated code compatibility.",
    "--target-python-version": "Target Python version for generated code syntax and imports.",
    "--treat-dot-as-module": "Treat dots in schema names as module separators.",
    "--type-mappings": "Override default type mappings for schema formats.",
    "--type-overrides": "Replace schema model types with custom Python types via JSON mapping.",
    "--union-mode": "Union mode for combining anyOf/oneOf schemas (smart or left_to_right).",
    "--url": "Fetch schema from URL with custom HTTP headers.",
    "--use-annotated": "Use typing.Annotated for Field() with constraints.",
    "--use-attribute-docstrings": "Generate field descriptions as attribute docstrings instead of Field descriptions.",
    "--use-decimal-for-multiple-of": "Generate Decimal types for fields with multipleOf constraint.",
    "--use-default": "Use default values from schema in generated models.",
    "--use-default-factory-for-optional-nested-models": "Generate default_factory for optional nested model fields.",
    "--use-default-kwarg": "Use default= keyword argument instead of positional argument for fields with defaults.",
    "--use-double-quotes": "Use double quotes for string literals in generated code.",
    "--use-enum-values-in-discriminator": "Use enum values in discriminator mappings for union types.",
    "--use-exact-imports": "Import exact types instead of modules.",
    "--use-field-description": "Include schema descriptions as Field docstrings.",
    "--use-field-description-example": "Add field examples to docstrings.",
    "--use-frozen-field": "Generate frozen (immutable) field definitions for readOnly properties.",
    "--use-generic-base-class": "Generate a shared base class with model configuration to avoid repetition (DRY).",
    "--use-generic-container-types": "Use generic container types (Sequence, Mapping) for type hinting.",
    "--use-inline-field-description": "Add field descriptions as inline comments.",
    "--use-non-positive-negative-number-constrained-types": "Use NonPositive/NonNegative types for number constraints.",
    "--use-one-literal-as-default": "Use single literal value as default when enum has only one option.",
    "--use-operation-id-as-name": "Use OpenAPI operationId as the generated function/class name.",
    "--use-pendulum": "Use pendulum types for date/time fields instead of datetime module.",
    "--use-root-model-type-alias": "Generate RootModel as type alias format for better mypy support.",
    "--use-schema-description": "Use schema description as class docstring.",
    "--use-serialization-alias": "Use serialization_alias instead of alias for field aliasing (Pydantic v2 only).",
    "--use-serialize-as-any": "Wrap fields with subtypes in Pydantic's SerializeAsAny.",
    "--use-specialized-enum": "Generate StrEnum/IntEnum for string/integer enums (Python 3.11+).",
    "--use-standard-collections": "Use built-in dict/list instead of typing.Dict/List.",
    "--use-standard-primitive-types": "Use Python standard library types for string formats instead of str.",
    "--use-status-code-in-response-name": "Include HTTP status code in response model names.",
    "--use-subclass-enum": "Generate typed Enum subclasses for enums with specific field types.",
    "--use-title-as-name": "Use schema title as the generated class name.",
    "--use-tuple-for-fixed-items": "Generate tuple types for arrays with items array syntax.",
    "--use-type-alias": "Use TypeAlias instead of root models for type definitions (experimental).",
    "--use-union-operator": "Use | operator for Union types (PEP 604).",
    "--use-unique-items-as-set": "Generate set types for arrays with uniqueItems constraint.",
    "--validation": "Enable validation constraints (deprecated, use --field-constraints).",
    "--watch": "Watch input file(s) for changes and regenerate output automatically.",
    "--watch-delay": "Set debounce delay in seconds for watch mode.",
    "--wrap-string-literal": "Wrap long string literals across multiple lines.",
}
