# generated by datamodel-codegen:
#   filename:  <stdin>

from __future__ import annotations

from typing import TYPE_CHECKING, Any, TypeAlias, TypedDict

from typing_extensions import NotRequired

if TYPE_CHECKING:
    from collections import defaultdict
    from collections.abc import Callable, Iterable, Mapping, Sequence
    from pathlib import Path

    from datamodel_code_generator.enums import (
        AllOfClassHierarchy,
        AllOfMergeMode,
        ClassNameAffixScope,
        CollapseRootModelsNameStrategy,
        DataclassArguments,
        FieldTypeCollisionStrategy,
        NamingStrategy,
        OpenAPIScope,
        ReadOnlyWriteOnlyModelType,
        ReuseScope,
        StrictTypes,
        TargetPydanticVersion,
    )
    from datamodel_code_generator.format import DateClassType, DatetimeClassType, Formatter, PythonVersion
    from datamodel_code_generator.model.base import DataModel, DataModelFieldBase
    from datamodel_code_generator.parser import DefaultPutDict, LiteralType
    from datamodel_code_generator.types import DataTypeManager


class ParserConfigDict(TypedDict):
    data_model_type: NotRequired[type[DataModel]]
    data_model_root_type: NotRequired[type[DataModel]]
    data_type_manager_type: NotRequired[type[DataTypeManager]]
    data_model_field_type: NotRequired[type[DataModelFieldBase]]
    base_class: NotRequired[str | None]
    base_class_map: NotRequired[dict[str, str] | None]
    additional_imports: NotRequired[list[str] | None]
    class_decorators: NotRequired[list[str] | None]
    custom_template_dir: NotRequired[Path | None]
    extra_template_data: NotRequired[defaultdict[str, dict[str, Any]] | None]
    target_python_version: NotRequired[PythonVersion]
    dump_resolve_reference_action: NotRequired[Callable[[Iterable[str]], str] | None]
    validation: NotRequired[bool]
    field_constraints: NotRequired[bool]
    snake_case_field: NotRequired[bool]
    strip_default_none: NotRequired[bool]
    aliases: NotRequired[Mapping[str, str | list[str]] | None]
    allow_population_by_field_name: NotRequired[bool]
    apply_default_values_for_required_fields: NotRequired[bool]
    allow_extra_fields: NotRequired[bool]
    extra_fields: NotRequired[str | None]
    use_generic_base_class: NotRequired[bool]
    force_optional_for_required_fields: NotRequired[bool]
    class_name: NotRequired[str | None]
    class_name_prefix: NotRequired[str | None]
    class_name_suffix: NotRequired[str | None]
    class_name_affix_scope: NotRequired[ClassNameAffixScope]
    use_standard_collections: NotRequired[bool]
    base_path: NotRequired[Path | None]
    use_schema_description: NotRequired[bool]
    use_field_description: NotRequired[bool]
    use_field_description_example: NotRequired[bool]
    use_attribute_docstrings: NotRequired[bool]
    use_inline_field_description: NotRequired[bool]
    use_default_kwarg: NotRequired[bool]
    reuse_model: NotRequired[bool]
    reuse_scope: NotRequired[ReuseScope | None]
    shared_module_name: NotRequired[str]
    encoding: NotRequired[str]
    enum_field_as_literal: NotRequired[LiteralType | None]
    enum_field_as_literal_map: NotRequired[dict[str, str] | None]
    ignore_enum_constraints: NotRequired[bool]
    set_default_enum_member: NotRequired[bool]
    use_subclass_enum: NotRequired[bool]
    use_specialized_enum: NotRequired[bool]
    strict_nullable: NotRequired[bool]
    use_generic_container_types: NotRequired[bool]
    enable_faux_immutability: NotRequired[bool]
    remote_text_cache: NotRequired[DefaultPutDict[str, str] | None]
    disable_appending_item_suffix: NotRequired[bool]
    strict_types: NotRequired[Sequence[StrictTypes] | None]
    empty_enum_field_name: NotRequired[str | None]
    custom_class_name_generator: NotRequired[Callable[[str], str] | None]
    field_extra_keys: NotRequired[set[str] | None]
    field_include_all_keys: NotRequired[bool]
    field_extra_keys_without_x_prefix: NotRequired[set[str] | None]
    model_extra_keys: NotRequired[set[str] | None]
    model_extra_keys_without_x_prefix: NotRequired[set[str] | None]
    wrap_string_literal: NotRequired[bool | None]
    use_title_as_name: NotRequired[bool]
    use_operation_id_as_name: NotRequired[bool]
    use_unique_items_as_set: NotRequired[bool]
    use_tuple_for_fixed_items: NotRequired[bool]
    allof_merge_mode: NotRequired[AllOfMergeMode]
    allof_class_hierarchy: NotRequired[AllOfClassHierarchy]
    http_headers: NotRequired[Sequence[tuple[str, str]] | None]
    http_ignore_tls: NotRequired[bool]
    http_timeout: NotRequired[float | None]
    use_annotated: NotRequired[bool]
    use_serialize_as_any: NotRequired[bool]
    use_non_positive_negative_number_constrained_types: NotRequired[bool]
    use_decimal_for_multiple_of: NotRequired[bool]
    original_field_name_delimiter: NotRequired[str | None]
    use_double_quotes: NotRequired[bool]
    use_union_operator: NotRequired[bool]
    allow_responses_without_content: NotRequired[bool]
    collapse_root_models: NotRequired[bool]
    collapse_root_models_name_strategy: NotRequired[CollapseRootModelsNameStrategy | None]
    collapse_reuse_models: NotRequired[bool]
    skip_root_model: NotRequired[bool]
    use_type_alias: NotRequired[bool]
    special_field_name_prefix: NotRequired[str | None]
    remove_special_field_name_prefix: NotRequired[bool]
    capitalise_enum_members: NotRequired[bool]
    keep_model_order: NotRequired[bool]
    use_one_literal_as_default: NotRequired[bool]
    use_enum_values_in_discriminator: NotRequired[bool]
    known_third_party: NotRequired[list[str] | None]
    custom_formatters: NotRequired[list[str] | None]
    custom_formatters_kwargs: NotRequired[dict[str, Any] | None]
    use_pendulum: NotRequired[bool]
    use_standard_primitive_types: NotRequired[bool]
    http_query_parameters: NotRequired[Sequence[tuple[str, str]] | None]
    treat_dot_as_module: NotRequired[bool | None]
    use_exact_imports: NotRequired[bool]
    default_field_extras: NotRequired[dict[str, Any] | None]
    target_datetime_class: NotRequired[DatetimeClassType | None]
    target_date_class: NotRequired[DateClassType | None]
    keyword_only: NotRequired[bool]
    frozen_dataclasses: NotRequired[bool]
    no_alias: NotRequired[bool]
    use_serialization_alias: NotRequired[bool]
    use_frozen_field: NotRequired[bool]
    use_default_factory_for_optional_nested_models: NotRequired[bool]
    formatters: NotRequired[list[Formatter] | None]
    defer_formatting: NotRequired[bool]
    parent_scoped_naming: NotRequired[bool]
    naming_strategy: NotRequired[NamingStrategy | None]
    duplicate_name_suffix: NotRequired[dict[str, str] | None]
    dataclass_arguments: NotRequired[DataclassArguments | None]
    type_mappings: NotRequired[list[str] | None]
    type_overrides: NotRequired[dict[str, str] | None]
    read_only_write_only_model_type: NotRequired[ReadOnlyWriteOnlyModelType | None]
    field_type_collision_strategy: NotRequired[FieldTypeCollisionStrategy | None]
    target_pydantic_version: NotRequired[TargetPydanticVersion | None]
    default_value_overrides: NotRequired[Mapping[str, Any] | None]


class GraphQLParserConfigDict(ParserConfigDict):
    data_model_scalar_type: NotRequired[type[DataModel]]
    data_model_union_type: NotRequired[type[DataModel]]
    graphql_no_typename: NotRequired[bool]


class JSONSchemaParserConfigDict(ParserConfigDict):
    pass


class OpenAPIParserConfigDict(JSONSchemaParserConfigDict):
    openapi_scopes: NotRequired[list[OpenAPIScope] | None]
    include_path_parameters: NotRequired[bool]
    use_status_code_in_response_name: NotRequired[bool]
    openapi_include_paths: NotRequired[list[str] | None]


ModelDict: TypeAlias = ParserConfigDict | GraphQLParserConfigDict | JSONSchemaParserConfigDict | OpenAPIParserConfigDict
