import setuptools

setuptools.setup(
    name="pyCDM4F",
    version="0.0.7",
    data_files=[('examples', [
        'examples/daily_temperature_data.csv',
        'examples/monthly_meteorological_data.csv',
        'examples/Prunus_phenology_data.csv'
    ])],
    license='MIT',
    author="Songwon Kim",
    author_email="kimsongwon10@korea.ac.kr",
    description="Package for Predicting Plant Phenology with ChillDay-Model(CDM), which has Parameter Examination, Visualization, Clustering and so on... with Phenology & Meteorological Data.",
    long_description=open('README.md', encoding='utf-8').read(),
    long_description_content_type='text/markdown',
    url="https://github.com/CSBL-urap/2024-summer-swkim",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent"
    ],
    python_requires='>=3.6',
    install_requires=[
        'backports.tarfile==1.2.0',
        'beautifulsoup4==4.12.3',
        'bs4==0.0.2',
        'certifi==2024.6.2',
        'charset-normalizer==3.3.2',
        'colorama==0.4.6',
        'contourpy==1.1.1',
        'cycler==0.12.1',
        'docutils==0.20.1',
        'et-xmlfile==1.1.0',
        'fonttools==4.53.1',
        'idna==3.7',
        'importlib_metadata==8.5.0',
        'importlib_resources==6.4.0',
        'jaraco.classes==3.4.0',
        'jaraco.context==6.0.1',
        'jaraco.functools==4.1.0',
        'joblib==1.4.2',
        'keyring==25.5.0',
        'kiwisolver==1.4.5',
        'lxml==5.3.0',
        'markdown-it-py==3.0.0',
        'matplotlib==3.7.5',
        'mdurl==0.1.2',
        'more-itertools==10.5.0',
        'nh3==0.2.20',
        'numpy==1.24.4',
        'openpyxl==3.1.5',
        'packaging==24.1',
        'pandas==2.0.3',
        'patsy==0.5.6',
        'pillow==10.4.0',
        'pkginfo==1.12.0',
        'Pygments==2.19.0',
        'pyparsing==3.1.2',
        'python-dateutil==2.9.0.post0',
        'pytz==2024.1',
        'pywin32-ctypes==0.2.3',
        'readme_renderer==43.0',
        'requests==2.32.3',
        'requests-toolbelt==1.0.0',
        'rfc3986==2.0.0',
        'rich==13.9.4',
        'scikit-learn==1.3.2',
        'scipy==1.10.1',
        'seaborn==0.13.2',
        'six==1.16.0',
        'soupsieve==2.5',
        'statsmodels==0.14.1',
        'threadpoolctl==3.5.0',
        'tqdm==4.67.1',
        'twine==6.0.1',
        'typing_extensions==4.12.2',
        'tzdata==2024.1',
        'urllib3==2.2.2',
        'zipp==3.20.2'
    ]

)
