(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("vue"));
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["AgGrid"] = factory(require("vue"));
	else
		root["AgGrid"] = factory(root["Vue"]);
})((typeof self !== 'undefined' ? self : this), function(__WEBPACK_EXTERNAL_MODULE__8bbf__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "fb15");
/******/ })
/************************************************************************/
/******/ ({

/***/ "00ee":
/***/ (function(module, exports, __webpack_require__) {

var wellKnownSymbol = __webpack_require__("b622");

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};

test[TO_STRING_TAG] = 'z';

module.exports = String(test) === '[object z]';


/***/ }),

/***/ "0366":
/***/ (function(module, exports, __webpack_require__) {

var aCallable = __webpack_require__("59ed");

// optional / simple context binding
module.exports = function (fn, that, length) {
  aCallable(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 0: return function () {
      return fn.call(that);
    };
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ "036c":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ScrollVisibleService; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ad5d");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var ScrollVisibleService = /** @class */ (function (_super) {
    __extends(ScrollVisibleService, _super);
    function ScrollVisibleService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ScrollVisibleService.prototype.postConstruct = function () {
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_DISPLAYED_COLUMNS_CHANGED, this.onDisplayedColumnsChanged.bind(this));
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED, this.onDisplayedColumnsWidthChanged.bind(this));
    };
    ScrollVisibleService.prototype.onDisplayedColumnsChanged = function () {
        this.update();
    };
    ScrollVisibleService.prototype.onDisplayedColumnsWidthChanged = function () {
        this.update();
    };
    ScrollVisibleService.prototype.update = function () {
        // because of column animation (which takes 200ms), we have to do this twice.
        // eg if user removes cols anywhere except at the RHS, then the cols on the RHS
        // will animate to the left to fill the gap. this animation means just after
        // the cols are removed, the remaining cols are still in the original location
        // at the start of the animation, so pre animation the H scrollbar is still needed,
        // but post animation it is not.
        this.updateImpl();
        setTimeout(this.updateImpl.bind(this), 500);
    };
    ScrollVisibleService.prototype.updateImpl = function () {
        var centerRowCtrl = this.ctrlsService.getCenterRowContainerCtrl();
        if (!centerRowCtrl) {
            return;
        }
        var params = {
            horizontalScrollShowing: centerRowCtrl.isHorizontalScrollShowing(),
            verticalScrollShowing: this.isVerticalScrollShowing()
        };
        this.setScrollsVisible(params);
    };
    ScrollVisibleService.prototype.setScrollsVisible = function (params) {
        var atLeastOneDifferent = this.horizontalScrollShowing !== params.horizontalScrollShowing ||
            this.verticalScrollShowing !== params.verticalScrollShowing;
        if (atLeastOneDifferent) {
            this.horizontalScrollShowing = params.horizontalScrollShowing;
            this.verticalScrollShowing = params.verticalScrollShowing;
            var event_1 = {
                type: _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_SCROLL_VISIBILITY_CHANGED,
                api: this.gridApi,
                columnApi: this.columnApi
            };
            this.eventService.dispatchEvent(event_1);
        }
    };
    // used by pagination service - to know page height
    ScrollVisibleService.prototype.isHorizontalScrollShowing = function () {
        return this.horizontalScrollShowing;
    };
    // used by header container
    ScrollVisibleService.prototype.isVerticalScrollShowing = function () {
        return this.verticalScrollShowing;
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('columnApi')
    ], ScrollVisibleService.prototype, "columnApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('gridApi')
    ], ScrollVisibleService.prototype, "gridApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('ctrlsService')
    ], ScrollVisibleService.prototype, "ctrlsService", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_0__[/* PostConstruct */ "e"]
    ], ScrollVisibleService.prototype, "postConstruct", null);
    ScrollVisibleService = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('scrollVisibleService')
    ], ScrollVisibleService);
    return ScrollVisibleService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "0450":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ValueFormatterService; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var ValueFormatterService = /** @class */ (function (_super) {
    __extends(ValueFormatterService, _super);
    function ValueFormatterService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ValueFormatterService.prototype.formatValue = function (column, node, $scope, value, suppliedFormatter, useFormatterFromColumn) {
        if (useFormatterFromColumn === void 0) { useFormatterFromColumn = true; }
        var result = null;
        var formatter;
        var colDef = column.getColDef();
        if (suppliedFormatter) {
            // use supplied formatter if provided, e.g. set filter items can have their own value formatters
            formatter = suppliedFormatter;
        }
        else if (useFormatterFromColumn) {
            // if row is pinned, give preference to the pinned formatter
            formatter = node && node.rowPinned && colDef.pinnedRowValueFormatter ?
                colDef.pinnedRowValueFormatter : colDef.valueFormatter;
        }
        if (formatter) {
            var params = {
                value: value,
                node: node,
                data: node ? node.data : null,
                colDef: colDef,
                column: column,
                api: this.gridOptionsWrapper.getApi(),
                columnApi: this.gridOptionsWrapper.getColumnApi(),
                context: this.gridOptionsWrapper.getContext()
            };
            // originally we put the angular 1 scope here, but we don't want the scope
            // in the params interface, as other frameworks will see the interface, and
            // angular 1 is not cool any more. so we hack the scope in here (we cannot
            // include it above, as it's not in the interface, so would cause a compile error).
            // in the future, when we stop supporting angular 1, we can take this out.
            params.$scope = $scope;
            result = this.expressionService.evaluate(formatter, params);
        }
        else if (colDef.refData) {
            return colDef.refData[value] || '';
        }
        // if we don't do this, then arrays get displayed as 1,2,3, but we want 1, 2, 3 (i.e. with spaces)
        if (result == null && Array.isArray(value)) {
            result = value.join(', ');
        }
        return result;
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('expressionService')
    ], ValueFormatterService.prototype, "expressionService", void 0);
    ValueFormatterService = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('valueFormatterService')
    ], ValueFormatterService);
    return ValueFormatterService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "0632":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return VanillaFrameworkOverrides; });
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("348a");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("7347");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */


var OUTSIDE_ANGULAR_EVENTS = ['mouseover', 'mouseout', 'mouseenter', 'mouseleave'];
/** The base frameworks, eg React & Angular 2, override this bean with implementations specific to their requirement. */
var VanillaFrameworkOverrides = /** @class */ (function () {
    function VanillaFrameworkOverrides() {
        this.isOutsideAngular = function (eventType) { return Object(_utils_array__WEBPACK_IMPORTED_MODULE_0__["includes"])(OUTSIDE_ANGULAR_EVENTS, eventType); };
    }
    // for Vanilla JS, we use simple timeout
    VanillaFrameworkOverrides.prototype.setTimeout = function (action, timeout) {
        window.setTimeout(action, timeout);
    };
    VanillaFrameworkOverrides.prototype.setInterval = function (action, timeout) {
        return new _utils__WEBPACK_IMPORTED_MODULE_1__[/* AgPromise */ "a"](function (resolve) {
            resolve(window.setInterval(action, timeout));
        });
    };
    // for Vanilla JS, we just add the event to the element
    VanillaFrameworkOverrides.prototype.addEventListener = function (element, type, listener, useCapture) {
        element.addEventListener(type, listener, useCapture);
    };
    // for Vanilla JS, we just execute the listener
    VanillaFrameworkOverrides.prototype.dispatchEvent = function (eventType, listener, global) {
        if (global === void 0) { global = false; }
        listener();
    };
    VanillaFrameworkOverrides.prototype.frameworkComponent = function (name) {
        return null;
    };
    return VanillaFrameworkOverrides;
}());



/***/ }),

/***/ "06cf":
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__("83ab");
var propertyIsEnumerableModule = __webpack_require__("d1e7");
var createPropertyDescriptor = __webpack_require__("5c6c");
var toIndexedObject = __webpack_require__("fc6a");
var toPropertyKey = __webpack_require__("a04b");
var hasOwn = __webpack_require__("1a2d");
var IE8_DOM_DEFINE = __webpack_require__("0cfb");

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPropertyKey(P);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn(O, P)) return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
};


/***/ }),

/***/ "073f":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fuzzyCheckStrings", function() { return fuzzyCheckStrings; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fuzzySuggestions", function() { return fuzzySuggestions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "get_bigrams", function() { return get_bigrams; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "string_distances", function() { return string_distances; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "string_weighted_distances", function() { return string_weighted_distances; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
function fuzzyCheckStrings(inputValues, validValues, allSuggestions) {
    var fuzzyMatches = {};
    var invalidInputs = inputValues.filter(function (inputValue) {
        return !validValues.some(function (validValue) { return validValue === inputValue; });
    });
    if (invalidInputs.length > 0) {
        invalidInputs.forEach(function (invalidInput) {
            return fuzzyMatches[invalidInput] = fuzzySuggestions(invalidInput, allSuggestions);
        });
    }
    return fuzzyMatches;
}
/**
 *
 * @param {String} inputValue The value to be compared against a list of strings
 * @param allSuggestions The list of strings to be compared against
 * @param hideIrrelevant By default, fuzzy suggestions will just sort the allSuggestions list, set this to true
 *        to filter out the irrelevant values
 * @param weighted Set this to true, to make letters matched in the order they were typed have priority in the results.
 */
function fuzzySuggestions(inputValue, allSuggestions, hideIrrelevant, weighted) {
    var search = weighted ? string_weighted_distances : string_distances;
    var thisSuggestions = allSuggestions.map(function (text) { return ({
        value: text,
        relevance: search(inputValue.toLowerCase(), text.toLocaleLowerCase())
    }); });
    thisSuggestions.sort(function (a, b) { return b.relevance - a.relevance; });
    if (hideIrrelevant) {
        thisSuggestions = thisSuggestions.filter(function (suggestion) { return suggestion.relevance !== 0; });
    }
    return thisSuggestions.map(function (suggestion) { return suggestion.value; });
}
/**
 * Algorithm to do fuzzy search
 * from https://stackoverflow.com/questions/23305000/javascript-fuzzy-search-that-makes-sense
 * @param {string} from
 * @return {[]}
 */
function get_bigrams(from) {
    var s = from.toLowerCase();
    var v = new Array(s.length - 1);
    var i;
    var j;
    var ref;
    for (i = j = 0, ref = v.length; j <= ref; i = j += 1) {
        v[i] = s.slice(i, i + 2);
    }
    return v;
}
function string_distances(str1, str2) {
    if (str1.length === 0 && str2.length === 0) {
        return 0;
    }
    var pairs1 = get_bigrams(str1);
    var pairs2 = get_bigrams(str2);
    var union = pairs1.length + pairs2.length;
    var hit_count = 0;
    var j;
    var len;
    for (j = 0, len = pairs1.length; j < len; j++) {
        var x = pairs1[j];
        var k = void 0;
        var len1 = void 0;
        for (k = 0, len1 = pairs2.length; k < len1; k++) {
            var y = pairs2[k];
            if (x === y) {
                hit_count++;
            }
        }
    }
    return hit_count > 0 ? (2 * hit_count) / union : 0;
}
function string_weighted_distances(str1, str2) {
    var a = str1.replace(/\s/g, '');
    var b = str2.replace(/\s/g, '');
    var weight = 0;
    var lastIndex = 0;
    for (var i = 0; i < a.length; i++) {
        var idx = b.indexOf(a[i], lastIndex);
        if (idx === -1) {
            continue;
        }
        lastIndex = idx;
        weight += (100 - (lastIndex * 100 / 10000) * 100);
    }
    return weight;
}


/***/ }),

/***/ "07fa":
/***/ (function(module, exports, __webpack_require__) {

var toLength = __webpack_require__("50c4");

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
module.exports = function (obj) {
  return toLength(obj.length);
};


/***/ }),

/***/ "080f":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "normalizeWheel", function() { return normalizeWheel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isLeftClick", function() { return isLeftClick; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "areEventsNear", function() { return areEventsNear; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
/**
 * @deprecated
 * Mouse wheel (and 2-finger trackpad) support on the web sucks.  It is
 * complicated, thus this doc is long and (hopefully) detailed enough to answer
 * your questions.
 *
 * If you need to react to the mouse wheel in a predictable way, this code is
 * like your bestest friend. * hugs *
 *
 * As of today, there are 4 DOM event types you can listen to:
 *
 *   'wheel'                -- Chrome(31+), FF(17+), IE(9+)
 *   'mousewheel'           -- Chrome, IE(6+), Opera, Safari
 *   'MozMousePixelScroll'  -- FF(3.5 only!) (2010-2013) -- don't bother!
 *   'DOMMouseScroll'       -- FF(0.9.7+) since 2003
 *
 * So what to do?  The is the best:
 *
 *   normalizeWheel.getEventType();
 *
 * In your event callback, use this code to get sane interpretation of the
 * deltas.  This code will return an object with properties:
 *
 *   spinX   -- normalized spin speed (use for zoom) - x plane
 *   spinY   -- " - y plane
 *   pixelX  -- normalized distance (to pixels) - x plane
 *   pixelY  -- " - y plane
 *
 * Wheel values are provided by the browser assuming you are using the wheel to
 * scroll a web page by a number of lines or pixels (or pages).  Values can vary
 * significantly on different platforms and browsers, forgetting that you can
 * scroll at different speeds.  Some devices (like trackpads) emit more events
 * at smaller increments with fine granularity, and some emit massive jumps with
 * linear speed or acceleration.
 *
 * This code does its best to normalize the deltas for you:
 *
 *   - spin is trying to normalize how far the wheel was spun (or trackpad
 *     dragged).  This is super useful for zoom support where you want to
 *     throw away the chunky scroll steps on the PC and make those equal to
 *     the slow and smooth tiny steps on the Mac. Key data: This code tries to
 *     resolve a single slow step on a wheel to 1.
 *
 *   - pixel is normalizing the desired scroll delta in pixel units.  You'll
 *     get the crazy differences between browsers, but at least it'll be in
 *     pixels!
 *
 *   - positive value indicates scrolling DOWN/RIGHT, negative UP/LEFT.  This
 *     should translate to positive value zooming IN, negative zooming OUT.
 *     This matches the newer 'wheel' event.
 *
 * Why are there spinX, spinY (or pixels)?
 *
 *   - spinX is a 2-finger side drag on the trackpad, and a shift + wheel turn
 *     with a mouse.  It results in side-scrolling in the browser by default.
 *
 *   - spinY is what you expect -- it's the classic axis of a mouse wheel.
 *
 *   - I dropped spinZ/pixelZ.  It is supported by the DOM 3 'wheel' event and
 *     probably is by browsers in conjunction with fancy 3D controllers .. but
 *     you know.
 *
 * Implementation info:
 *
 * Examples of 'wheel' event if you scroll slowly (down) by one step with an
 * average mouse:
 *
 *   OS X + Chrome  (mouse)     -    4   pixel delta  (wheelDelta -120)
 *   OS X + Safari  (mouse)     -  N/A   pixel delta  (wheelDelta  -12)
 *   OS X + Firefox (mouse)     -    0.1 line  delta  (wheelDelta  N/A)
 *   Win8 + Chrome  (mouse)     -  100   pixel delta  (wheelDelta -120)
 *   Win8 + Firefox (mouse)     -    3   line  delta  (wheelDelta -120)
 *
 * On the trackpad:
 *
 *   OS X + Chrome  (trackpad)  -    2   pixel delta  (wheelDelta   -6)
 *   OS X + Firefox (trackpad)  -    1   pixel delta  (wheelDelta  N/A)
 *
 * On other/older browsers.. it's more complicated as there can be multiple and
 * also missing delta values.
 *
 * The 'wheel' event is more standard:
 *
 * http://www.w3.org/TR/DOM-Level-3-Events/#events-wheelevents
 *
 * The basics is that it includes a unit, deltaMode (pixels, lines, pages), and
 * deltaX, deltaY and deltaZ.  Some browsers provide other values to maintain
 * backward compatibility with older events.  Those other values help us
 * better normalize spin speed.  Example of what the browsers provide:
 *
 *                          | event.wheelDelta | event.detail
 *        ------------------+------------------+--------------
 *          Safari v5/OS X  |       -120       |       0
 *          Safari v5/Win7  |       -120       |       0
 *         Chrome v17/OS X  |       -120       |       0
 *         Chrome v17/Win7  |       -120       |       0
 *                IE9/Win7  |       -120       |   undefined
 *         Firefox v4/OS X  |     undefined    |       1
 *         Firefox v4/Win7  |     undefined    |       3
 *
 * from: https://github.com/facebook/fixed-data-table/blob/master/src/vendor_upstream/dom/normalizeWheel.js
 * @param {any} event
 * @return {any}
 */
function normalizeWheel(event) {
    var PIXEL_STEP = 10;
    var LINE_HEIGHT = 40;
    var PAGE_HEIGHT = 800;
    // spinX, spinY
    var sX = 0;
    var sY = 0;
    // pixelX, pixelY
    var pX = 0;
    var pY = 0;
    // Legacy
    if ('detail' in event) {
        sY = event.detail;
    }
    if ('wheelDelta' in event) {
        sY = -event.wheelDelta / 120;
    }
    if ('wheelDeltaY' in event) {
        sY = -event.wheelDeltaY / 120;
    }
    if ('wheelDeltaX' in event) {
        sX = -event.wheelDeltaX / 120;
    }
    // side scrolling on FF with DOMMouseScroll
    if ('axis' in event && event.axis === event.HORIZONTAL_AXIS) {
        sX = sY;
        sY = 0;
    }
    pX = sX * PIXEL_STEP;
    pY = sY * PIXEL_STEP;
    if ('deltaY' in event) {
        pY = event.deltaY;
    }
    if ('deltaX' in event) {
        pX = event.deltaX;
    }
    if ((pX || pY) && event.deltaMode) {
        if (event.deltaMode == 1) { // delta in LINE units
            pX *= LINE_HEIGHT;
            pY *= LINE_HEIGHT;
        }
        else { // delta in PAGE units
            pX *= PAGE_HEIGHT;
            pY *= PAGE_HEIGHT;
        }
    }
    // Fall-back if spin cannot be determined
    if (pX && !sX) {
        sX = (pX < 1) ? -1 : 1;
    }
    if (pY && !sY) {
        sY = (pY < 1) ? -1 : 1;
    }
    return {
        spinX: sX,
        spinY: sY,
        pixelX: pX,
        pixelY: pY
    };
}
/**
 * @deprecated
 * Checks if event was issued by a left click
 * from https://stackoverflow.com/questions/3944122/detect-left-mouse-button-press
 * @param {MouseEvent} mouseEvent
 * @returns {boolean}
 */
function isLeftClick(mouseEvent) {
    if ('buttons' in mouseEvent) {
        return mouseEvent.buttons == 1;
    }
    var button = mouseEvent.which || mouseEvent.button;
    return button == 1;
}
/**
 * `True` if the event is close to the original event by X pixels either vertically or horizontally.
 * we only start dragging after X pixels so this allows us to know if we should start dragging yet.
 * @param {MouseEvent | TouchEvent} e1
 * @param {MouseEvent | TouchEvent} e2
 * @param {number} pixelCount
 * @returns {boolean}
 */
function areEventsNear(e1, e2, pixelCount) {
    // by default, we wait 4 pixels before starting the drag
    if (pixelCount === 0) {
        return false;
    }
    var diffX = Math.abs(e1.clientX - e2.clientX);
    var diffY = Math.abs(e1.clientY - e2.clientY);
    return Math.max(diffX, diffY) <= pixelCount;
}


/***/ }),

/***/ "0b0e":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FocusService; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ad5d");
/* harmony import */ var _widgets_managedFocusFeature__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("8453");
/* harmony import */ var _utils_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("b8d2");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("348a");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("a74a");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("59ec");
/* harmony import */ var _rendering_cell_cellCtrl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("8912");
/* harmony import */ var _headerRendering_cells_abstractCell_abstractHeaderCellCtrl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("22b5");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __spreadArrays = (undefined && undefined.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};










var FocusService = /** @class */ (function (_super) {
    __extends(FocusService, _super);
    function FocusService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FocusService_1 = FocusService;
    /**
     * Adds a gridCore to the list of the gridCores monitoring Keyboard Mode
     * in a specific HTMLDocument.
     *
     * @param doc {Document} - The Document containing the gridCore.
     * @param gridCore {GridComp} - The GridCore to be monitored.
     */
    FocusService.addKeyboardModeEvents = function (doc, controller) {
        var docControllers = FocusService_1.instancesMonitored.get(doc);
        if (docControllers && docControllers.length > 0) {
            if (docControllers.indexOf(controller) === -1) {
                docControllers.push(controller);
            }
        }
        else {
            FocusService_1.instancesMonitored.set(doc, [controller]);
            doc.addEventListener('keydown', FocusService_1.toggleKeyboardMode);
            doc.addEventListener('mousedown', FocusService_1.toggleKeyboardMode);
        }
    };
    /**
     * Removes a gridCore from the list of the gridCores monitoring Keyboard Mode
     * in a specific HTMLDocument.
     *
     * @param doc {Document} - The Document containing the gridCore.
     * @param gridCore {GridComp} - The GridCore to be removed.
     */
    FocusService.removeKeyboardModeEvents = function (doc, controller) {
        var docControllers = FocusService_1.instancesMonitored.get(doc);
        var newControllers = [];
        if (docControllers && docControllers.length) {
            newControllers = __spreadArrays(docControllers).filter(function (currentGridCore) { return currentGridCore !== controller; });
            FocusService_1.instancesMonitored.set(doc, newControllers);
        }
        if (newControllers.length === 0) {
            doc.removeEventListener('keydown', FocusService_1.toggleKeyboardMode);
            doc.removeEventListener('mousedown', FocusService_1.toggleKeyboardMode);
        }
    };
    /**
     * This method will be called by `keydown` and `mousedown` events on all Documents monitoring
     * KeyboardMode. It will then fire a KEYBOARD_FOCUS, MOUSE_FOCUS on each gridCore present in
     * the Document allowing each gridCore to maintain a state for KeyboardMode.
     *
     * @param event {KeyboardEvent | MouseEvent | TouchEvent} - The event triggered.
     */
    FocusService.toggleKeyboardMode = function (event) {
        var isKeyboardActive = FocusService_1.keyboardModeActive;
        var isKeyboardEvent = event.type === 'keydown';
        if (isKeyboardEvent) {
            // the following keys should not toggle keyboard mode.
            if (event.ctrlKey || event.metaKey || event.altKey) {
                return;
            }
        }
        if (isKeyboardActive && isKeyboardEvent || !isKeyboardActive && !isKeyboardEvent) {
            return;
        }
        FocusService_1.keyboardModeActive = isKeyboardEvent;
        var doc = event.target.ownerDocument;
        if (!doc) {
            return;
        }
        var controllersForDoc = FocusService_1.instancesMonitored.get(doc);
        if (controllersForDoc) {
            controllersForDoc.forEach(function (controller) {
                controller.dispatchEvent({ type: isKeyboardEvent ? _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_KEYBOARD_FOCUS : _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_MOUSE_FOCUS });
            });
        }
    };
    FocusService.prototype.init = function () {
        var _this = this;
        var clearFocusedCellListener = this.clearFocusedCell.bind(this);
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_COLUMN_PIVOT_MODE_CHANGED, clearFocusedCellListener);
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_NEW_COLUMNS_LOADED, this.onColumnEverythingChanged.bind(this));
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_COLUMN_GROUP_OPENED, clearFocusedCellListener);
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_COLUMN_ROW_GROUP_CHANGED, clearFocusedCellListener);
        this.ctrlsService.whenReady(function (p) {
            _this.gridCtrl = p.gridCtrl;
            var doc = _this.gridOptionsWrapper.getDocument();
            FocusService_1.addKeyboardModeEvents(doc, _this.gridCtrl);
            _this.addDestroyFunc(function () { return _this.unregisterGridCompController(_this.gridCtrl); });
        });
    };
    FocusService.prototype.unregisterGridCompController = function (gridCompController) {
        var doc = this.gridOptionsWrapper.getDocument();
        FocusService_1.removeKeyboardModeEvents(doc, gridCompController);
    };
    FocusService.prototype.onColumnEverythingChanged = function () {
        // if the columns change, check and see if this column still exists. if it does, then
        // we can keep the focused cell. if it doesn't, then we need to drop the focused cell.
        if (!this.focusedCellPosition) {
            return;
        }
        var col = this.focusedCellPosition.column;
        var colFromColumnModel = this.columnModel.getGridColumn(col.getId());
        if (col !== colFromColumnModel) {
            this.clearFocusedCell();
        }
    };
    FocusService.prototype.isKeyboardMode = function () {
        return FocusService_1.keyboardModeActive;
    };
    // we check if the browser is focusing something, and if it is, and
    // it's the cell we think is focused, then return the cell. so this
    // methods returns the cell if a) we think it has focus and b) the
    // browser thinks it has focus. this then returns nothing if we
    // first focus a cell, then second click outside the grid, as then the
    // grid cell will still be focused as far as the grid is concerned,
    // however the browser focus will have moved somewhere else.
    FocusService.prototype.getFocusCellToUseAfterRefresh = function () {
        if (this.gridOptionsWrapper.isSuppressFocusAfterRefresh() || !this.focusedCellPosition) {
            return null;
        }
        // we check that the browser is actually focusing on the grid, if it is not, then
        // we have nothing to worry about
        if (this.isDomDataMissingInHierarchy(document.activeElement, _rendering_cell_cellCtrl__WEBPACK_IMPORTED_MODULE_8__[/* CellCtrl */ "a"].DOM_DATA_KEY_CELL_CTRL)) {
            return null;
        }
        return this.focusedCellPosition;
    };
    FocusService.prototype.getFocusHeaderToUseAfterRefresh = function () {
        if (this.gridOptionsWrapper.isSuppressFocusAfterRefresh() || !this.focusedHeaderPosition) {
            return null;
        }
        // we check that the browser is actually focusing on the grid, if it is not, then
        // we have nothing to worry about
        if (this.isDomDataMissingInHierarchy(document.activeElement, _headerRendering_cells_abstractCell_abstractHeaderCellCtrl__WEBPACK_IMPORTED_MODULE_9__[/* AbstractHeaderCellCtrl */ "a"].DOM_DATA_KEY_HEADER_CTRL)) {
            return null;
        }
        return this.focusedHeaderPosition;
    };
    FocusService.prototype.isDomDataMissingInHierarchy = function (eBrowserCell, key) {
        var ePointer = eBrowserCell;
        while (ePointer) {
            var data = this.gridOptionsWrapper.getDomData(ePointer, key);
            if (data) {
                return false;
            }
            ePointer = ePointer.parentNode;
        }
        return true;
    };
    FocusService.prototype.clearFocusedCell = function () {
        this.focusedCellPosition = null;
        this.onCellFocused(false);
    };
    FocusService.prototype.getFocusedCell = function () {
        return this.focusedCellPosition;
    };
    FocusService.prototype.setFocusedCell = function (rowIndex, colKey, floating, forceBrowserFocus) {
        if (forceBrowserFocus === void 0) { forceBrowserFocus = false; }
        var gridColumn = this.columnModel.getGridColumn(colKey);
        // if column doesn't exist, then blank the focused cell and return. this can happen when user sets new columns,
        // and the focused cell is in a column that no longer exists. after columns change, the grid refreshes and tries
        // to re-focus the focused cell.
        if (!gridColumn) {
            this.focusedCellPosition = null;
            return;
        }
        this.focusedCellPosition = gridColumn ? { rowIndex: rowIndex, rowPinned: Object(_utils_generic__WEBPACK_IMPORTED_MODULE_6__["makeNull"])(floating), column: gridColumn } : null;
        this.onCellFocused(forceBrowserFocus);
    };
    FocusService.prototype.isCellFocused = function (cellPosition) {
        if (this.focusedCellPosition == null) {
            return false;
        }
        return this.focusedCellPosition.column === cellPosition.column &&
            this.isRowFocused(cellPosition.rowIndex, cellPosition.rowPinned);
    };
    FocusService.prototype.isRowNodeFocused = function (rowNode) {
        return this.isRowFocused(rowNode.rowIndex, rowNode.rowPinned);
    };
    FocusService.prototype.isHeaderWrapperFocused = function (headerCtrl) {
        if (this.focusedHeaderPosition == null) {
            return false;
        }
        var column = headerCtrl.getColumnGroupChild();
        var headerRowIndex = headerCtrl.getRowIndex();
        var pinned = headerCtrl.getPinned();
        var _a = this.focusedHeaderPosition, focusedColumn = _a.column, focusedHeaderRowIndex = _a.headerRowIndex;
        return column === focusedColumn &&
            headerRowIndex === focusedHeaderRowIndex &&
            pinned == focusedColumn.getPinned();
    };
    FocusService.prototype.clearFocusedHeader = function () {
        this.focusedHeaderPosition = null;
    };
    FocusService.prototype.getFocusedHeader = function () {
        return this.focusedHeaderPosition;
    };
    FocusService.prototype.setFocusedHeader = function (headerRowIndex, column) {
        this.focusedHeaderPosition = { headerRowIndex: headerRowIndex, column: column };
    };
    FocusService.prototype.focusHeaderPosition = function (headerPosition, direction, fromTab, allowUserOverride, event) {
        if (direction === void 0) { direction = null; }
        if (fromTab === void 0) { fromTab = false; }
        if (allowUserOverride === void 0) { allowUserOverride = false; }
        if (allowUserOverride) {
            var gridOptionsWrapper = this.gridOptionsWrapper;
            var currentPosition = this.getFocusedHeader();
            var headerRowCount = this.headerNavigationService.getHeaderRowCount();
            if (fromTab) {
                var userFunc = gridOptionsWrapper.getTabToNextHeaderFunc();
                if (userFunc) {
                    var params = {
                        backwards: direction === 'Before',
                        previousHeaderPosition: currentPosition,
                        nextHeaderPosition: headerPosition,
                        headerRowCount: headerRowCount,
                        api: gridOptionsWrapper.getApi(),
                        columnApi: gridOptionsWrapper.getColumnApi()
                    };
                    headerPosition = userFunc(params);
                }
            }
            else {
                var userFunc = gridOptionsWrapper.getNavigateToNextHeaderFunc();
                if (userFunc && event) {
                    var params = {
                        key: event.key,
                        previousHeaderPosition: currentPosition,
                        nextHeaderPosition: headerPosition,
                        headerRowCount: headerRowCount,
                        event: event,
                        api: gridOptionsWrapper.getApi(),
                        columnApi: gridOptionsWrapper.getColumnApi()
                    };
                    headerPosition = userFunc(params);
                }
            }
        }
        if (!headerPosition) {
            return false;
        }
        if (headerPosition.headerRowIndex === -1) {
            return this.focusGridView(headerPosition.column);
        }
        this.headerNavigationService.scrollToColumn(headerPosition.column, direction);
        var headerRowContainerCtrl = this.ctrlsService.getHeaderRowContainerCtrl(headerPosition.column.getPinned());
        // this will automatically call the setFocusedHeader method above
        var focusSuccess = headerRowContainerCtrl.focusHeader(headerPosition.headerRowIndex, headerPosition.column);
        return focusSuccess;
    };
    FocusService.prototype.isAnyCellFocused = function () {
        return !!this.focusedCellPosition;
    };
    FocusService.prototype.isRowFocused = function (rowIndex, floating) {
        if (this.focusedCellPosition == null) {
            return false;
        }
        return this.focusedCellPosition.rowIndex === rowIndex && this.focusedCellPosition.rowPinned === Object(_utils_generic__WEBPACK_IMPORTED_MODULE_6__["makeNull"])(floating);
    };
    FocusService.prototype.findFocusableElements = function (rootNode, exclude, onlyUnmanaged) {
        if (onlyUnmanaged === void 0) { onlyUnmanaged = false; }
        var focusableString = _constants_constants__WEBPACK_IMPORTED_MODULE_7__[/* Constants */ "a"].FOCUSABLE_SELECTOR;
        var excludeString = _constants_constants__WEBPACK_IMPORTED_MODULE_7__[/* Constants */ "a"].FOCUSABLE_EXCLUDE;
        if (exclude) {
            excludeString += ', ' + exclude;
        }
        if (onlyUnmanaged) {
            excludeString += ', [tabindex="-1"]';
        }
        var nodes = Array.prototype.slice.apply(rootNode.querySelectorAll(focusableString));
        var excludeNodes = Array.prototype.slice.apply(rootNode.querySelectorAll(excludeString));
        if (!excludeNodes.length) {
            return nodes;
        }
        var diff = function (a, b) { return a.filter(function (element) { return b.indexOf(element) === -1; }); };
        return diff(nodes, excludeNodes);
    };
    FocusService.prototype.focusInto = function (rootNode, up, onlyUnmanaged) {
        if (up === void 0) { up = false; }
        if (onlyUnmanaged === void 0) { onlyUnmanaged = false; }
        var focusableElements = this.findFocusableElements(rootNode, null, onlyUnmanaged);
        var toFocus = up ? Object(_utils_array__WEBPACK_IMPORTED_MODULE_5__["last"])(focusableElements) : focusableElements[0];
        if (toFocus) {
            toFocus.focus();
            return true;
        }
        return false;
    };
    FocusService.prototype.findNextFocusableElement = function (rootNode, onlyManaged, backwards) {
        var focusable = this.findFocusableElements(rootNode, onlyManaged ? ':not([tabindex="-1"])' : null);
        var currentIndex;
        if (onlyManaged) {
            currentIndex = Object(_utils_array__WEBPACK_IMPORTED_MODULE_5__["findIndex"])(focusable, function (el) { return el.contains(document.activeElement); });
        }
        else {
            currentIndex = focusable.indexOf(document.activeElement);
        }
        var nextIndex = currentIndex + (backwards ? -1 : 1);
        if (nextIndex < 0 || nextIndex >= focusable.length) {
            return null;
        }
        return focusable[nextIndex];
    };
    FocusService.prototype.isFocusUnderManagedComponent = function (rootNode) {
        var managedContainers = rootNode.querySelectorAll("." + _widgets_managedFocusFeature__WEBPACK_IMPORTED_MODULE_3__[/* ManagedFocusFeature */ "a"].FOCUS_MANAGED_CLASS);
        if (!managedContainers.length) {
            return false;
        }
        for (var i = 0; i < managedContainers.length; i++) {
            if (managedContainers[i].contains(document.activeElement)) {
                return true;
            }
        }
        return false;
    };
    FocusService.prototype.findTabbableParent = function (node, limit) {
        if (limit === void 0) { limit = 5; }
        var counter = 0;
        while (node && Object(_utils_browser__WEBPACK_IMPORTED_MODULE_4__["getTabIndex"])(node) === null && ++counter <= limit) {
            node = node.parentElement;
        }
        if (Object(_utils_browser__WEBPACK_IMPORTED_MODULE_4__["getTabIndex"])(node) === null) {
            return null;
        }
        return node;
    };
    FocusService.prototype.onCellFocused = function (forceBrowserFocus) {
        var event = {
            type: _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_CELL_FOCUSED,
            forceBrowserFocus: forceBrowserFocus,
            rowIndex: null,
            column: null,
            floating: null,
            api: this.gridApi,
            columnApi: this.columnApi,
            rowPinned: null,
            isFullWidthCell: false
        };
        if (this.focusedCellPosition) {
            var rowIndex = event.rowIndex = this.focusedCellPosition.rowIndex;
            var rowPinned = event.rowPinned = this.focusedCellPosition.rowPinned;
            event.column = this.focusedCellPosition.column;
            var rowCtrl = this.rowRenderer.getRowByPosition({ rowIndex: rowIndex, rowPinned: rowPinned });
            if (rowCtrl) {
                event.isFullWidthCell = rowCtrl.isFullWidth();
            }
        }
        this.eventService.dispatchEvent(event);
    };
    FocusService.prototype.focusGridView = function (column, backwards) {
        var nextRow = backwards
            ? this.rowPositionUtils.getLastRow()
            : this.rowPositionUtils.getFirstRow();
        if (!nextRow) {
            return false;
        }
        var rowIndex = nextRow.rowIndex, rowPinned = nextRow.rowPinned;
        var focusedHeader = this.getFocusedHeader();
        if (!column && focusedHeader) {
            column = focusedHeader.column;
        }
        if (rowIndex == null || !column) {
            return false;
        }
        this.navigationService.ensureCellVisible({ rowIndex: rowIndex, column: column, rowPinned: rowPinned });
        this.setFocusedCell(rowIndex, column, Object(_utils_generic__WEBPACK_IMPORTED_MODULE_6__["makeNull"])(rowPinned), true);
        if (this.rangeService) {
            var cellPosition = { rowIndex: rowIndex, rowPinned: rowPinned, column: column };
            this.rangeService.setRangeToCell(cellPosition);
        }
        return true;
    };
    FocusService.prototype.focusNextGridCoreContainer = function (backwards) {
        if (this.gridCtrl.focusNextInnerContainer(backwards)) {
            return true;
        }
        if (!backwards) {
            this.gridCtrl.forceFocusOutOfContainer();
        }
        return false;
    };
    var FocusService_1;
    FocusService.AG_KEYBOARD_FOCUS = 'ag-keyboard-focus';
    FocusService.keyboardModeActive = false;
    FocusService.instancesMonitored = new Map();
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('columnModel')
    ], FocusService.prototype, "columnModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('headerNavigationService')
    ], FocusService.prototype, "headerNavigationService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('columnApi')
    ], FocusService.prototype, "columnApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('gridApi')
    ], FocusService.prototype, "gridApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('rowRenderer')
    ], FocusService.prototype, "rowRenderer", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('rowPositionUtils')
    ], FocusService.prototype, "rowPositionUtils", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Optional */ "d"])('rangeService')
    ], FocusService.prototype, "rangeService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('navigationService')
    ], FocusService.prototype, "navigationService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('ctrlsService')
    ], FocusService.prototype, "ctrlsService", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_0__[/* PostConstruct */ "e"]
    ], FocusService.prototype, "init", null);
    FocusService = FocusService_1 = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('focusService')
    ], FocusService);
    return FocusService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "0b42":
/***/ (function(module, exports, __webpack_require__) {

var isArray = __webpack_require__("e8b5");
var isConstructor = __webpack_require__("68ee");
var isObject = __webpack_require__("861d");
var wellKnownSymbol = __webpack_require__("b622");

var SPECIES = wellKnownSymbol('species');

// a part of `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
module.exports = function (originalArray) {
  var C;
  if (isArray(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (isConstructor(C) && (C === Array || isArray(C.prototype))) C = undefined;
    else if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return C === undefined ? Array : C;
};


/***/ }),

/***/ "0cfb":
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__("83ab");
var fails = __webpack_require__("d039");
var createElement = __webpack_require__("cc12");

// Thank's IE8 for his funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- requied for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});


/***/ }),

/***/ "0d51":
/***/ (function(module, exports) {

module.exports = function (argument) {
  try {
    return String(argument);
  } catch (error) {
    return 'Object';
  }
};


/***/ }),

/***/ "0e94":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "utf8_encode", function() { return utf8_encode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stringRepeat", function() { return stringRepeat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "padStart", function() { return padStart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "camelCaseToHyphen", function() { return camelCaseToHyphen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hyphenToCamelCase", function() { return hyphenToCamelCase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "capitalise", function() { return capitalise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "escapeString", function() { return escapeString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "camelCaseToHumanText", function() { return camelCaseToHumanText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "startsWith", function() { return startsWith; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var reUnescapedHtml = /[&<>"']/g;
/**
 * HTML Escapes.
 */
var HTML_ESCAPES = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;'
};
/**
 * It encodes any string in UTF-8 format
 * taken from https://github.com/mathiasbynens/utf8.js
 * @param {string} s
 * @returns {string}
 */
function utf8_encode(s) {
    var stringFromCharCode = String.fromCharCode;
    function ucs2decode(string) {
        var output = [];
        if (!string) {
            return [];
        }
        var len = string.length;
        var counter = 0;
        var value;
        var extra;
        while (counter < len) {
            value = string.charCodeAt(counter++);
            if (value >= 0xD800 && value <= 0xDBFF && counter < len) {
                // high surrogate, and there is a next character
                extra = string.charCodeAt(counter++);
                if ((extra & 0xFC00) == 0xDC00) { // low surrogate
                    output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
                }
                else {
                    // unmatched surrogate; only append this code unit, in case the next
                    // code unit is the high surrogate of a surrogate pair
                    output.push(value);
                    counter--;
                }
            }
            else {
                output.push(value);
            }
        }
        return output;
    }
    function checkScalarValue(point) {
        if (point >= 0xD800 && point <= 0xDFFF) {
            throw Error('Lone surrogate U+' + point.toString(16).toUpperCase() +
                ' is not a scalar value');
        }
    }
    function createByte(point, shift) {
        return stringFromCharCode(((point >> shift) & 0x3F) | 0x80);
    }
    function encodeCodePoint(point) {
        if ((point >= 0 && point <= 31 && point !== 10)) {
            var convertedCode = point.toString(16).toUpperCase();
            var paddedCode = padStart(convertedCode, 4, '0');
            return "_x" + paddedCode + "_";
        }
        if ((point & 0xFFFFFF80) == 0) { // 1-byte sequence
            return stringFromCharCode(point);
        }
        var symbol = '';
        if ((point & 0xFFFFF800) == 0) { // 2-byte sequence
            symbol = stringFromCharCode(((point >> 6) & 0x1F) | 0xC0);
        }
        else if ((point & 0xFFFF0000) == 0) { // 3-byte sequence
            checkScalarValue(point);
            symbol = stringFromCharCode(((point >> 12) & 0x0F) | 0xE0);
            symbol += createByte(point, 6);
        }
        else if ((point & 0xFFE00000) == 0) { // 4-byte sequence
            symbol = stringFromCharCode(((point >> 18) & 0x07) | 0xF0);
            symbol += createByte(point, 12);
            symbol += createByte(point, 6);
        }
        symbol += stringFromCharCode((point & 0x3F) | 0x80);
        return symbol;
    }
    var codePoints = ucs2decode(s);
    var length = codePoints.length;
    var index = -1;
    var codePoint;
    var byteString = '';
    while (++index < length) {
        codePoint = codePoints[index];
        byteString += encodeCodePoint(codePoint);
    }
    return byteString;
}
/**
 * @param str The string to be repeated
 * @param len The size of the output string
 * @returns A string with size len created from repeated `str`.
 */
function stringRepeat(str, len) {
    len = Math.floor(len);
    if (str.length === 0 || len === 0) {
        return '';
    }
    var maxCount = str.length * len;
    len = Math.floor(Math.log(len) / Math.log(2));
    while (len) {
        str += str;
        len--;
    }
    str += str.substring(0, maxCount - str.length);
    return str;
}
/**
 * @param str The string to be padded
 * @param totalLength The final length needed
 * @param padStr The string to generate the padding
 * @returns The padded string
 */
function padStart(str, totalLength, padStr) {
    if (str.length > totalLength) {
        return str;
    }
    totalLength -= str.length;
    if (totalLength > padStr.length) {
        padStr += stringRepeat(padStr, totalLength / padStr.length);
    }
    return padStr.slice(0, totalLength) + str;
}
/**
 * Converts a camelCase string into hyphenated string
 * from https://gist.github.com/youssman/745578062609e8acac9f
 * @param {string} str
 * @return {string}
 */
function camelCaseToHyphen(str) {
    if (str === null || str === undefined) {
        return null;
    }
    return str.replace(/([A-Z])/g, function (g) { return '-' + g[0].toLowerCase(); });
}
/**
 * Converts a hyphenated string into camelCase string
 * from https://stackoverflow.com/questions/6660977/convert-hyphens-to-camel-case-camelcase
 * @param {string} str
 * @return {string}
 */
function hyphenToCamelCase(str) {
    if (str === null || str === undefined) {
        return null;
    }
    return str.replace(/-([a-z])/g, function (g) { return g[1].toUpperCase(); });
}
function capitalise(str) {
    return str[0].toUpperCase() + str.substr(1).toLowerCase();
}
function escapeString(toEscape) {
    // we call toString() twice, in case value is an object, where user provides
    // a toString() method, and first call to toString() returns back something other
    // than a string (eg a number to render)
    return toEscape == null ? null : toEscape.toString().toString().replace(reUnescapedHtml, function (chr) { return HTML_ESCAPES[chr]; });
}
/**
 * Converts a camelCase string into regular text
 * from: https://stackoverflow.com/questions/15369566/putting-space-in-camel-case-string-using-regular-expression
 * @param {string} camelCase
 * @return {string}
 */
function camelCaseToHumanText(camelCase) {
    if (!camelCase || camelCase == null) {
        return null;
    }
    var rex = /([A-Z])([A-Z])([a-z])|([a-z])([A-Z])/g;
    var words = camelCase.replace(rex, '$1$4 $2$3$5').replace('.', ' ').split(' ');
    return words.map(function (word) { return word.substring(0, 1).toUpperCase() + ((word.length > 1) ? word.substring(1, word.length) : ''); }).join(' ');
}
function startsWith(str, matchStart) {
    if (str === matchStart) {
        return true;
    }
    return str != null && str.slice(0, matchStart.length) === matchStart;
}


/***/ }),

/***/ "102e":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CtrlsService; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("59ec");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var CtrlsService = /** @class */ (function (_super) {
    __extends(CtrlsService, _super);
    function CtrlsService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.ready = false;
        _this.readyCallbacks = [];
        return _this;
    }
    CtrlsService.prototype.checkReady = function () {
        this.ready =
            this.gridCtrl != null
                && this.gridBodyCtrl != null
                && this.centerRowContainerCtrl != null
                && this.leftRowContainerCtrl != null
                && this.rightRowContainerCtrl != null
                && this.bottomCenterRowContainerCtrl != null
                && this.bottomLeftRowContainerCtrl != null
                && this.bottomRightRowContainerCtrl != null
                && this.topCenterRowContainerCtrl != null
                && this.topLeftRowContainerCtrl != null
                && this.topRightRowContainerCtrl != null
                && this.centerHeaderRowContainerCtrl != null
                && this.leftHeaderRowContainerCtrl != null
                && this.rightHeaderRowContainerCtrl != null
                && this.fakeHScrollCtrl != null
                && this.gridHeaderCtrl != null;
        if (this.ready) {
            var p_1 = this.createReadyParams();
            this.readyCallbacks.forEach(function (c) { return c(p_1); });
            this.readyCallbacks.length = 0;
        }
    };
    CtrlsService.prototype.whenReady = function (callback) {
        if (this.ready) {
            callback(this.createReadyParams());
        }
        else {
            this.readyCallbacks.push(callback);
        }
    };
    CtrlsService.prototype.createReadyParams = function () {
        return {
            centerRowContainerCtrl: this.centerRowContainerCtrl,
            leftRowContainerCtrl: this.leftRowContainerCtrl,
            rightRowContainerCtrl: this.rightRowContainerCtrl,
            bottomCenterRowContainerCtrl: this.bottomCenterRowContainerCtrl,
            bottomLeftRowContainerCtrl: this.bottomLeftRowContainerCtrl,
            bottomRightRowContainerCtrl: this.bottomRightRowContainerCtrl,
            topCenterRowContainerCtrl: this.topCenterRowContainerCtrl,
            topLeftRowContainerCtrl: this.topLeftRowContainerCtrl,
            topRightRowContainerCtrl: this.topRightRowContainerCtrl,
            centerHeaderRowContainerCtrl: this.centerHeaderRowContainerCtrl,
            leftHeaderRowContainerCtrl: this.leftHeaderRowContainerCtrl,
            rightHeaderRowContainerCtrl: this.rightHeaderRowContainerCtrl,
            fakeHScrollCtrl: this.fakeHScrollCtrl,
            gridBodyCtrl: this.gridBodyCtrl,
            gridCtrl: this.gridCtrl,
            gridHeaderCtrl: this.gridHeaderCtrl,
        };
    };
    CtrlsService.prototype.registerFakeHScrollCtrl = function (ctrl) {
        this.fakeHScrollCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerGridHeaderCtrl = function (gridHeaderCtrl) {
        this.gridHeaderCtrl = gridHeaderCtrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerCenterRowContainerCtrl = function (ctrl) {
        this.centerRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerLeftRowContainerCtrl = function (ctrl) {
        this.leftRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerRightRowContainerCtrl = function (ctrl) {
        this.rightRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerTopCenterRowContainerCtrl = function (ctrl) {
        this.topCenterRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerTopLeftRowContainerCon = function (ctrl) {
        this.topLeftRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerTopRightRowContainerCtrl = function (ctrl) {
        this.topRightRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerBottomCenterRowContainerCtrl = function (ctrl) {
        this.bottomCenterRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerBottomLeftRowContainerCtrl = function (ctrl) {
        this.bottomLeftRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerBottomRightRowContainerCtrl = function (ctrl) {
        this.bottomRightRowContainerCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerHeaderContainer = function (ctrl, pinned) {
        switch (pinned) {
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_LEFT:
                this.leftHeaderRowContainerCtrl = ctrl;
                break;
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_RIGHT:
                this.rightHeaderRowContainerCtrl = ctrl;
                break;
            default:
                this.centerHeaderRowContainerCtrl = ctrl;
                break;
        }
        this.checkReady();
    };
    CtrlsService.prototype.registerGridBodyCtrl = function (ctrl) {
        this.gridBodyCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.registerGridCtrl = function (ctrl) {
        this.gridCtrl = ctrl;
        this.checkReady();
    };
    CtrlsService.prototype.getFakeHScrollCtrl = function () {
        return this.fakeHScrollCtrl;
    };
    CtrlsService.prototype.getGridHeaderCtrl = function () {
        return this.gridHeaderCtrl;
    };
    CtrlsService.prototype.getGridCtrl = function () {
        return this.gridCtrl;
    };
    CtrlsService.prototype.getCenterRowContainerCtrl = function () {
        return this.centerRowContainerCtrl;
    };
    CtrlsService.prototype.getTopCenterRowContainerCtrl = function () {
        return this.topCenterRowContainerCtrl;
    };
    CtrlsService.prototype.getBottomCenterRowContainerCtrl = function () {
        return this.bottomCenterRowContainerCtrl;
    };
    CtrlsService.prototype.getGridBodyCtrl = function () {
        return this.gridBodyCtrl;
    };
    CtrlsService.prototype.getHeaderRowContainerCtrls = function () {
        return [this.leftHeaderRowContainerCtrl, this.rightHeaderRowContainerCtrl, this.centerHeaderRowContainerCtrl];
    };
    CtrlsService.prototype.getHeaderRowContainerCtrl = function (pinned) {
        switch (pinned) {
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_LEFT: return this.leftHeaderRowContainerCtrl;
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_RIGHT: return this.rightHeaderRowContainerCtrl;
            default: return this.centerHeaderRowContainerCtrl;
        }
    };
    CtrlsService = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('ctrlsService')
    ], CtrlsService);
    return CtrlsService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "103b":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return GroupCellRendererCtrl; });
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("59ec");
/* harmony import */ var _constants_keyCode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("7a66");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("dc3a");
/* harmony import */ var _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fb19");
/* harmony import */ var _utils_event__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ac61");
/* harmony import */ var _utils_function__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("e900");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("a74a");
/* harmony import */ var _utils_icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("781c");
/* harmony import */ var _utils_keyboard__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("756a");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("562d");
/* harmony import */ var _checkboxSelectionComponent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("35c3");
/* harmony import */ var _row_rowDragComp__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("7cd7");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};













var GroupCellRendererCtrl = /** @class */ (function (_super) {
    __extends(GroupCellRendererCtrl, _super);
    function GroupCellRendererCtrl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GroupCellRendererCtrl.prototype.init = function (comp, eGui, eCheckbox, eExpanded, eContracted, compClass, params) {
        this.params = params;
        this.eGui = eGui;
        this.eCheckbox = eCheckbox;
        this.eExpanded = eExpanded;
        this.eContracted = eContracted;
        this.comp = comp;
        this.compClass = compClass;
        var topLevelFooter = this.isTopLevelFooter();
        var embeddedRowMismatch = this.isEmbeddedRowMismatch();
        // This allows for empty strings to appear as groups since
        // it will only return for null or undefined.
        var nullValue = params.value == null;
        var skipCell = false;
        // if the groupCellRenderer is inside of a footer and groupHideOpenParents is true
        // we should only display the groupCellRenderer if the current column is the rowGroupedColumn
        if (this.gridOptionsWrapper.isGroupIncludeFooter() && this.gridOptionsWrapper.isGroupHideOpenParents()) {
            var node = params.node;
            if (node.footer) {
                var showRowGroup = params.colDef && params.colDef.showRowGroup;
                var rowGroupColumnId = node.rowGroupColumn && node.rowGroupColumn.getColId();
                skipCell = showRowGroup !== rowGroupColumnId;
            }
        }
        this.cellIsBlank = topLevelFooter ? false : (embeddedRowMismatch || nullValue || skipCell);
        if (this.cellIsBlank) {
            return;
        }
        this.setupShowingValueForOpenedParent();
        this.findDisplayedGroupNode();
        this.addFullWidthRowDraggerIfNeeded();
        this.addExpandAndContract();
        this.addCheckboxIfNeeded();
        this.addValueElement();
        this.setupIndent();
    };
    GroupCellRendererCtrl.prototype.isTopLevelFooter = function () {
        if (!this.gridOptionsWrapper.isGroupIncludeTotalFooter()) {
            return false;
        }
        if (this.params.value != null || this.params.node.level != -1) {
            return false;
        }
        // at this point, we know it's the root node and there is no value present, so it's a footer cell.
        // the only thing to work out is if we are displaying groups  across multiple
        // columns (groupMultiAutoColumn=true), we only want 'total' to appear in the first column.
        var colDef = this.params.colDef;
        var doingFullWidth = colDef == null;
        if (doingFullWidth) {
            return true;
        }
        if (colDef.showRowGroup === true) {
            return true;
        }
        var rowGroupCols = this.columnModel.getRowGroupColumns();
        // this is a sanity check, rowGroupCols should always be present
        if (!rowGroupCols || rowGroupCols.length === 0) {
            return true;
        }
        var firstRowGroupCol = rowGroupCols[0];
        return firstRowGroupCol.getId() === colDef.showRowGroup;
    };
    // if we are doing embedded full width rows, we only show the renderer when
    // in the body, or if pinning in the pinned section, or if pinning and RTL,
    // in the right section. otherwise we would have the cell repeated in each section.
    GroupCellRendererCtrl.prototype.isEmbeddedRowMismatch = function () {
        if (!this.params.fullWidth || !this.gridOptionsWrapper.isEmbedFullWidthRows()) {
            return false;
        }
        var pinnedLeftCell = this.params.pinned === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].PINNED_LEFT;
        var pinnedRightCell = this.params.pinned === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].PINNED_RIGHT;
        var bodyCell = !pinnedLeftCell && !pinnedRightCell;
        if (this.gridOptionsWrapper.isEnableRtl()) {
            if (this.columnModel.isPinningLeft()) {
                return !pinnedRightCell;
            }
            return !bodyCell;
        }
        if (this.columnModel.isPinningLeft()) {
            return !pinnedLeftCell;
        }
        return !bodyCell;
    };
    GroupCellRendererCtrl.prototype.findDisplayedGroupNode = function () {
        var column = this.params.column;
        var rowNode = this.params.node;
        if (this.showingValueForOpenedParent) {
            var pointer = rowNode.parent;
            while (pointer != null) {
                if (pointer.rowGroupColumn && column.isRowGroupDisplayed(pointer.rowGroupColumn.getId())) {
                    this.displayedGroupNode = pointer;
                    break;
                }
                pointer = pointer.parent;
            }
        }
        // if we didn't find a displayed group, set it to the row node
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_7__["missing"])(this.displayedGroupNode)) {
            this.displayedGroupNode = rowNode;
        }
    };
    GroupCellRendererCtrl.prototype.setupShowingValueForOpenedParent = function () {
        // note - this code depends on sortService.updateGroupDataForHiddenOpenParents, where group data
        // is updated to reflect the dragged down parents
        var rowNode = this.params.node;
        var column = this.params.column;
        if (!this.gridOptionsWrapper.isGroupHideOpenParents()) {
            this.showingValueForOpenedParent = false;
            return;
        }
        // hideOpenParents means rowNode.groupData can have data for the group this column is displaying, even though
        // this rowNode isn't grouping by the column we are displaying
        // if no groupData at all, we are not showing a parent value
        if (!rowNode.groupData) {
            this.showingValueForOpenedParent = false;
            return;
        }
        // this is the normal case, in that we are showing a group for which this column is configured. note that
        // this means the Row Group is closed (if it was open, we would not be displaying it)
        var showingGroupNode = rowNode.rowGroupColumn != null;
        if (showingGroupNode) {
            var keyOfGroupingColumn = rowNode.rowGroupColumn.getId();
            var configuredToShowThisGroupLevel = column.isRowGroupDisplayed(keyOfGroupingColumn);
            // if showing group as normal, we didn't take group info from parent
            if (configuredToShowThisGroupLevel) {
                this.showingValueForOpenedParent = false;
                return;
            }
        }
        // see if we are showing a Group Value for the Displayed Group. if we are showing a group value, and this Row Node
        // is not grouping by this Displayed Group, we must of gotten the value from a parent node
        var valPresent = rowNode.groupData[column.getId()] != null;
        this.showingValueForOpenedParent = valPresent;
    };
    GroupCellRendererCtrl.prototype.addValueElement = function () {
        if (this.displayedGroupNode.footer) {
            this.addFooterValue();
        }
        else {
            this.addGroupValue();
            this.addChildCount();
        }
    };
    GroupCellRendererCtrl.prototype.addGroupValue = function () {
        // we try and use the cellRenderer of the column used for the grouping if we can
        var paramsAdjusted = this.adjustParamsWithDetailsFromRelatedColumn();
        var innerCompDetails = this.getInnerCompDetails(paramsAdjusted);
        var valueFormatted = paramsAdjusted.valueFormatted, value = paramsAdjusted.value;
        var valueWhenNoRenderer = valueFormatted != null ? valueFormatted : value;
        this.comp.setInnerRenderer(innerCompDetails, valueWhenNoRenderer);
    };
    GroupCellRendererCtrl.prototype.adjustParamsWithDetailsFromRelatedColumn = function () {
        var relatedColumn = this.displayedGroupNode.rowGroupColumn;
        var column = this.params.column;
        if (!relatedColumn) {
            return this.params;
        }
        var notFullWidth = column != null;
        if (notFullWidth) {
            var showingThisRowGroup = column.isRowGroupDisplayed(relatedColumn.getId());
            if (!showingThisRowGroup) {
                return this.params;
            }
        }
        var params = this.params;
        var _a = this.params, value = _a.value, scope = _a.scope, node = _a.node;
        var valueFormatted = this.valueFormatterService.formatValue(relatedColumn, node, scope, value);
        // we don't update the original params, as they could of come through React,
        // as react has RowGroupCellRenderer, which means the params could be props which
        // would be read only
        var paramsAdjusted = __assign(__assign({}, params), { valueFormatted: valueFormatted });
        return paramsAdjusted;
    };
    GroupCellRendererCtrl.prototype.addFooterValue = function () {
        var footerValueGetter = this.params.footerValueGetter;
        var footerValue = '';
        if (footerValueGetter) {
            // params is same as we were given, except we set the value as the item to display
            var paramsClone = Object(_utils_object__WEBPACK_IMPORTED_MODULE_10__["cloneObject"])(this.params);
            paramsClone.value = this.params.value;
            if (typeof footerValueGetter === 'function') {
                footerValue = footerValueGetter(paramsClone);
            }
            else if (typeof footerValueGetter === 'string') {
                footerValue = this.expressionService.evaluate(footerValueGetter, paramsClone);
            }
            else {
                console.warn('AG Grid: footerValueGetter should be either a function or a string (expression)');
            }
        }
        else {
            footerValue = 'Total ' + (this.params.value != null ? this.params.value : '');
        }
        var innerCompDetails = this.getInnerCompDetails(this.params);
        this.comp.setInnerRenderer(innerCompDetails, footerValue);
    };
    GroupCellRendererCtrl.prototype.getInnerCompDetails = function (params) {
        var _this = this;
        // for full width rows, we don't do any of the below
        if (params.fullWidth) {
            return this.userComponentFactory.getFullWidthGroupRowInnerCellRenderer(this.gridOptions.groupRowRendererParams, params);
        }
        // when grouping, the normal case is we use the cell renderer of the grouped column. eg if grouping by country
        // and then rating, we will use the country cell renderer for each country group row and likewise the rating
        // cell renderer for each rating group row.
        //
        // however if the user has innerCellRenderer defined, this gets preference and we don't use cell renderers
        // of the grouped columns.
        //
        // so we check and use in the following order:
        //
        // 1) thisColDef.cellRendererParams.innerRenderer of the column showing the groups (eg auto group column)
        // 2) groupedColDef.cellRenderer of the grouped column
        // 3) groupedColDef.cellRendererParams.innerRenderer
        // we check if cell renderer provided for the group cell renderer, eg colDef.cellRendererParams.innerRenderer
        var innerCompDetails = this.userComponentFactory
            .getInnerRendererDetails(params, params);
        // avoid using GroupCellRenderer again, otherwise stack overflow, as we insert same renderer again and again.
        // this covers off chance user is grouping by a column that is also configured with GroupCellRenderer
        var isGroupRowRenderer = function (details) { return details && details.componentClass == _this.compClass; };
        if (innerCompDetails && !isGroupRowRenderer(innerCompDetails)) {
            // use the renderer defined in cellRendererParams.innerRenderer
            return innerCompDetails;
        }
        var relatedColumn = this.displayedGroupNode.rowGroupColumn;
        var relatedColDef = relatedColumn ? relatedColumn.getColDef() : undefined;
        if (!relatedColDef) {
            return;
        }
        // otherwise see if we can use the cellRenderer of the column we are grouping by
        var relatedCompDetails = this.userComponentFactory
            .getCellRendererDetails(relatedColDef, params);
        if (relatedCompDetails && !isGroupRowRenderer(relatedCompDetails)) {
            // Only if the original column is using a specific renderer, it it is a using a DEFAULT one ignore it
            return relatedCompDetails;
        }
        if (isGroupRowRenderer(relatedCompDetails) &&
            relatedColDef.cellRendererParams &&
            relatedColDef.cellRendererParams.innerRenderer) {
            // edge case - this comes from a column which has been grouped dynamically, that has a renderer 'group'
            // and has an inner cell renderer
            var res = this.userComponentFactory.getInnerRendererDetails(relatedColDef.cellRendererParams, params);
            return res;
        }
    };
    GroupCellRendererCtrl.prototype.addChildCount = function () {
        // only include the child count if it's included, eg if user doing custom aggregation,
        // then this could be left out, or set to -1, ie no child count
        if (this.params.suppressCount) {
            return;
        }
        this.addManagedListener(this.displayedGroupNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_ALL_CHILDREN_COUNT_CHANGED, this.updateChildCount.bind(this));
        // filtering changes the child count, so need to cater for it
        this.updateChildCount();
    };
    GroupCellRendererCtrl.prototype.updateChildCount = function () {
        var allChildrenCount = this.displayedGroupNode.allChildrenCount;
        var showingGroupForThisNode = this.isShowRowGroupForThisRow();
        var showCount = showingGroupForThisNode && allChildrenCount != null && allChildrenCount >= 0;
        var countString = showCount ? "(" + allChildrenCount + ")" : "";
        this.comp.setChildCount(countString);
    };
    GroupCellRendererCtrl.prototype.isShowRowGroupForThisRow = function () {
        if (this.gridOptionsWrapper.isTreeData()) {
            return true;
        }
        var rowGroupColumn = this.displayedGroupNode.rowGroupColumn;
        if (!rowGroupColumn) {
            return false;
        }
        // column is null for fullWidthRows
        var column = this.params.column;
        var thisColumnIsInterested = column == null || column.isRowGroupDisplayed(rowGroupColumn.getId());
        return thisColumnIsInterested;
    };
    GroupCellRendererCtrl.prototype.addExpandAndContract = function () {
        var params = this.params;
        var eExpandedIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_8__["createIconNoSpan"])('groupExpanded', this.gridOptionsWrapper, null);
        var eContractedIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_8__["createIconNoSpan"])('groupContracted', this.gridOptionsWrapper, null);
        if (eExpandedIcon) {
            this.eExpanded.appendChild(eExpandedIcon);
        }
        if (eContractedIcon) {
            this.eContracted.appendChild(eContractedIcon);
        }
        var eGroupCell = params.eGridCell;
        // if editing groups, then double click is to start editing
        if (!this.gridOptionsWrapper.isEnableGroupEdit() && this.isExpandable() && !params.suppressDoubleClickExpand) {
            this.addManagedListener(eGroupCell, 'dblclick', this.onCellDblClicked.bind(this));
        }
        this.addManagedListener(this.eExpanded, 'click', this.onExpandClicked.bind(this));
        this.addManagedListener(this.eContracted, 'click', this.onExpandClicked.bind(this));
        // expand / contract as the user hits enter
        this.addManagedListener(eGroupCell, 'keydown', this.onKeyDown.bind(this));
        this.addManagedListener(params.node, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_EXPANDED_CHANGED, this.showExpandAndContractIcons.bind(this));
        this.showExpandAndContractIcons();
        // because we don't show the expand / contract when there are no children, we need to check every time
        // the number of children change.
        var expandableChangedListener = this.onRowNodeIsExpandableChanged.bind(this);
        this.addManagedListener(this.displayedGroupNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_ALL_CHILDREN_COUNT_CHANGED, expandableChangedListener);
        this.addManagedListener(this.displayedGroupNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_MASTER_CHANGED, expandableChangedListener);
        this.addManagedListener(this.displayedGroupNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_HAS_CHILDREN_CHANGED, expandableChangedListener);
    };
    GroupCellRendererCtrl.prototype.onExpandClicked = function (mouseEvent) {
        if (Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["isStopPropagationForAgGrid"])(mouseEvent)) {
            return;
        }
        // so if we expand a node, it does not also get selected.
        Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["stopPropagationForAgGrid"])(mouseEvent);
        this.onExpandOrContract();
    };
    GroupCellRendererCtrl.prototype.onExpandOrContract = function () {
        // must use the displayedGroup, so if data was dragged down, we expand the parent, not this row
        var rowNode = this.displayedGroupNode;
        var nextExpandState = !rowNode.expanded;
        rowNode.setExpanded(nextExpandState);
    };
    GroupCellRendererCtrl.prototype.isExpandable = function () {
        if (this.showingValueForOpenedParent) {
            return true;
        }
        var rowNode = this.displayedGroupNode;
        var reducedLeafNode = this.columnModel.isPivotMode() && rowNode.leafGroup;
        var expandableGroup = rowNode.isExpandable() && !rowNode.footer && !reducedLeafNode;
        if (!expandableGroup) {
            return false;
        }
        // column is null for fullWidthRows
        var column = this.params.column;
        var displayingForOneColumnOnly = column != null && typeof column.getColDef().showRowGroup === 'string';
        if (displayingForOneColumnOnly) {
            var showing = this.isShowRowGroupForThisRow();
            return showing;
        }
        return true;
    };
    GroupCellRendererCtrl.prototype.showExpandAndContractIcons = function () {
        var _a = this, params = _a.params, displayedGroup = _a.displayedGroupNode, columnModel = _a.columnModel;
        var node = params.node;
        var isExpandable = this.isExpandable();
        if (isExpandable) {
            // if expandable, show one based on expand state.
            // if we were dragged down, means our parent is always expanded
            var expanded = this.showingValueForOpenedParent ? true : node.expanded;
            this.comp.setExpandedDisplayed(expanded);
            this.comp.setContractedDisplayed(!expanded);
        }
        else {
            // it not expandable, show neither
            this.comp.setExpandedDisplayed(false);
            this.comp.setContractedDisplayed(false);
        }
        // compensation padding for leaf nodes, so there is blank space instead of the expand icon
        var pivotMode = columnModel.isPivotMode();
        var pivotModeAndLeafGroup = pivotMode && displayedGroup.leafGroup;
        var addExpandableCss = isExpandable && !pivotModeAndLeafGroup;
        var isTotalFooterNode = node.footer && node.level === -1;
        this.comp.addOrRemoveCssClass('ag-cell-expandable', addExpandableCss);
        this.comp.addOrRemoveCssClass('ag-row-group', addExpandableCss);
        if (pivotMode) {
            this.comp.addOrRemoveCssClass('ag-pivot-leaf-group', pivotModeAndLeafGroup);
        }
        else if (!isTotalFooterNode) {
            this.comp.addOrRemoveCssClass('ag-row-group-leaf-indent', !addExpandableCss);
        }
    };
    GroupCellRendererCtrl.prototype.onRowNodeIsExpandableChanged = function () {
        // maybe if no children now, we should hide the expand / contract icons
        this.showExpandAndContractIcons();
        // if we have no children, this impacts the indent
        this.setIndent();
    };
    GroupCellRendererCtrl.prototype.setupIndent = function () {
        // only do this if an indent - as this overwrites the padding that
        // the theme set, which will make things look 'not aligned' for the
        // first group level.
        var node = this.params.node;
        var suppressPadding = this.params.suppressPadding;
        if (!suppressPadding) {
            this.addManagedListener(node, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_UI_LEVEL_CHANGED, this.setIndent.bind(this));
            this.setIndent();
        }
    };
    GroupCellRendererCtrl.prototype.setIndent = function () {
        if (this.gridOptionsWrapper.isGroupHideOpenParents()) {
            return;
        }
        var params = this.params;
        var rowNode = params.node;
        // if we are only showing one group column, we don't want to be indenting based on level
        var fullWithRow = !!params.colDef;
        var treeData = this.gridOptionsWrapper.isTreeData();
        var manyDimensionThisColumn = !fullWithRow || treeData || params.colDef.showRowGroup === true;
        var paddingCount = manyDimensionThisColumn ? rowNode.uiLevel : 0;
        var userProvidedPaddingPixelsTheDeprecatedWay = params.padding >= 0;
        if (userProvidedPaddingPixelsTheDeprecatedWay) {
            Object(_utils_function__WEBPACK_IMPORTED_MODULE_6__["doOnce"])(function () { return console.warn('AG Grid: cellRendererParams.padding no longer works, it was deprecated in since v14.2 and removed in v26, configuring padding for groupCellRenderer should be done with Sass variables and themes. Please see the AG Grid documentation page for Themes, in particular the property $row-group-indent-size.'); }, 'groupCellRenderer->doDeprecatedWay');
        }
        if (this.indentClass) {
            this.comp.addOrRemoveCssClass(this.indentClass, false);
        }
        this.indentClass = 'ag-row-group-indent-' + paddingCount;
        this.comp.addOrRemoveCssClass(this.indentClass, true);
    };
    GroupCellRendererCtrl.prototype.addFullWidthRowDraggerIfNeeded = function () {
        var _this = this;
        if (!this.params.fullWidth || !this.params.rowDrag) {
            return;
        }
        var rowDragComp = new _row_rowDragComp__WEBPACK_IMPORTED_MODULE_12__[/* RowDragComp */ "a"](function () { return _this.params.value; }, this.params.node);
        this.createManagedBean(rowDragComp, this.context);
        this.eGui.insertAdjacentElement('afterbegin', rowDragComp.getGui());
    };
    GroupCellRendererCtrl.prototype.isUserWantsSelected = function () {
        var paramsCheckbox = this.params.checkbox;
        if (typeof paramsCheckbox === 'function') {
            return paramsCheckbox(this.params);
        }
        return paramsCheckbox === true;
    };
    GroupCellRendererCtrl.prototype.addCheckboxIfNeeded = function () {
        var _this = this;
        var rowNode = this.displayedGroupNode;
        var checkboxNeeded = this.isUserWantsSelected() &&
            // footers cannot be selected
            !rowNode.footer &&
            // pinned rows cannot be selected
            !rowNode.rowPinned &&
            // details cannot be selected
            !rowNode.detail;
        if (checkboxNeeded) {
            var cbSelectionComponent_1 = new _checkboxSelectionComponent__WEBPACK_IMPORTED_MODULE_11__[/* CheckboxSelectionComponent */ "a"]();
            this.getContext().createBean(cbSelectionComponent_1);
            cbSelectionComponent_1.init({ rowNode: rowNode, column: this.params.column });
            this.eCheckbox.appendChild(cbSelectionComponent_1.getGui());
            this.addDestroyFunc(function () { return _this.getContext().destroyBean(cbSelectionComponent_1); });
        }
        this.comp.setCheckboxVisible(checkboxNeeded);
    };
    GroupCellRendererCtrl.prototype.onKeyDown = function (event) {
        var enterKeyPressed = Object(_utils_keyboard__WEBPACK_IMPORTED_MODULE_9__["isKeyPressed"])(event, _constants_keyCode__WEBPACK_IMPORTED_MODULE_1__[/* KeyCode */ "a"].ENTER);
        if (!enterKeyPressed || this.params.suppressEnterExpand) {
            return;
        }
        var cellEditable = this.params.column && this.params.column.isCellEditable(this.params.node);
        if (cellEditable) {
            return;
        }
        this.onExpandOrContract();
    };
    GroupCellRendererCtrl.prototype.onCellDblClicked = function (mouseEvent) {
        if (Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["isStopPropagationForAgGrid"])(mouseEvent)) {
            return;
        }
        // we want to avoid acting on double click events on the expand / contract icon,
        // as that icons already has expand / collapse functionality on it. otherwise if
        // the icon was double clicked, we would get 'click', 'click', 'dblclick' which
        // is open->close->open, however double click should be open->close only.
        var targetIsExpandIcon = Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["isElementInEventPath"])(this.eExpanded, mouseEvent)
            || Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["isElementInEventPath"])(this.eContracted, mouseEvent);
        if (!targetIsExpandIcon) {
            this.onExpandOrContract();
        }
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_3__[/* Autowired */ "a"])('expressionService')
    ], GroupCellRendererCtrl.prototype, "expressionService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_3__[/* Autowired */ "a"])('valueFormatterService')
    ], GroupCellRendererCtrl.prototype, "valueFormatterService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_3__[/* Autowired */ "a"])('columnModel')
    ], GroupCellRendererCtrl.prototype, "columnModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_3__[/* Autowired */ "a"])('userComponentFactory')
    ], GroupCellRendererCtrl.prototype, "userComponentFactory", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_3__[/* Autowired */ "a"])('gridOptions')
    ], GroupCellRendererCtrl.prototype, "gridOptions", void 0);
    return GroupCellRendererCtrl;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_2__[/* BeanStub */ "a"]));



/***/ }),

/***/ "1071":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DisplayedGroupCreator; });
/* harmony import */ var _entities_columnGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("64bd");
/* harmony import */ var _entities_providedColumnGroup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("d78e");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("bc71");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("348a");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






// takes in a list of columns, as specified by the column definitions, and returns column groups
var DisplayedGroupCreator = /** @class */ (function (_super) {
    __extends(DisplayedGroupCreator, _super);
    function DisplayedGroupCreator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DisplayedGroupCreator.prototype.createDisplayedGroups = function (
    // all displayed columns sorted - this is the columns the grid should show
    sortedVisibleColumns, 
    // the tree of columns, as provided by the users, used to know what groups columns roll up into
    balancedColumnTree, 
    // creates unique id's for the group
    groupInstanceIdCreator, 
    // whether it's left, right or center col
    pinned, 
    // we try to reuse old groups if we can, to allow gui to do animation
    oldDisplayedGroups) {
        var _this = this;
        var result = [];
        var previousRealPath;
        var previousOriginalPath;
        var oldColumnsMapped = this.mapOldGroupsById(oldDisplayedGroups);
        // go through each column, then do a bottom up comparison to the previous column, and start
        // to share groups if they converge at any point.
        sortedVisibleColumns.forEach(function (currentColumn) {
            var currentOriginalPath = _this.getOriginalPathForColumn(balancedColumnTree, currentColumn);
            var currentRealPath = [];
            var firstColumn = !previousOriginalPath;
            for (var i = 0; i < currentOriginalPath.length; i++) {
                if (firstColumn || currentOriginalPath[i] !== previousOriginalPath[i]) {
                    // new group needed
                    var newGroup = _this.createColumnGroup(currentOriginalPath[i], groupInstanceIdCreator, oldColumnsMapped, pinned);
                    currentRealPath[i] = newGroup;
                    // if top level, add to result, otherwise add to parent
                    if (i == 0) {
                        result.push(newGroup);
                    }
                    else {
                        currentRealPath[i - 1].addChild(newGroup);
                    }
                }
                else {
                    // reuse old group
                    currentRealPath[i] = previousRealPath[i];
                }
            }
            var noColumnGroups = currentRealPath.length === 0;
            if (noColumnGroups) {
                // if we are not grouping, then the result of the above is an empty
                // path (no groups), and we just add the column to the root list.
                result.push(currentColumn);
            }
            else {
                var leafGroup = Object(_utils_array__WEBPACK_IMPORTED_MODULE_4__["last"])(currentRealPath);
                leafGroup.addChild(currentColumn);
            }
            previousRealPath = currentRealPath;
            previousOriginalPath = currentOriginalPath;
        });
        this.setupParentsIntoColumns(result, null);
        return result;
    };
    DisplayedGroupCreator.prototype.createColumnGroup = function (originalGroup, groupInstanceIdCreator, oldColumnsMapped, pinned) {
        var groupId = originalGroup.getGroupId();
        var instanceId = groupInstanceIdCreator.getInstanceIdForKey(groupId);
        var uniqueId = _entities_columnGroup__WEBPACK_IMPORTED_MODULE_0__[/* ColumnGroup */ "a"].createUniqueId(groupId, instanceId);
        var columnGroup = oldColumnsMapped[uniqueId];
        // if the user is setting new colDefs, it is possible that the id's overlap, and we
        // would have a false match from above. so we double check we are talking about the
        // same original column group.
        if (columnGroup && columnGroup.getOriginalColumnGroup() !== originalGroup) {
            columnGroup = null;
        }
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_5__["exists"])(columnGroup)) {
            // clean out the old column group here, as we will be adding children into it again
            columnGroup.reset();
        }
        else {
            columnGroup = new _entities_columnGroup__WEBPACK_IMPORTED_MODULE_0__[/* ColumnGroup */ "a"](originalGroup, groupId, instanceId, pinned);
            this.context.createBean(columnGroup);
        }
        return columnGroup;
    };
    // returns back a 2d map of ColumnGroup as follows: groupId -> instanceId -> ColumnGroup
    DisplayedGroupCreator.prototype.mapOldGroupsById = function (displayedGroups) {
        var result = {};
        var recursive = function (columnsOrGroups) {
            columnsOrGroups.forEach(function (columnOrGroup) {
                if (columnOrGroup instanceof _entities_columnGroup__WEBPACK_IMPORTED_MODULE_0__[/* ColumnGroup */ "a"]) {
                    var columnGroup = columnOrGroup;
                    result[columnOrGroup.getUniqueId()] = columnGroup;
                    recursive(columnGroup.getChildren());
                }
            });
        };
        if (displayedGroups) {
            recursive(displayedGroups);
        }
        return result;
    };
    DisplayedGroupCreator.prototype.setupParentsIntoColumns = function (columnsOrGroups, parent) {
        var _this = this;
        columnsOrGroups.forEach(function (columnsOrGroup) {
            columnsOrGroup.setParent(parent);
            if (columnsOrGroup instanceof _entities_columnGroup__WEBPACK_IMPORTED_MODULE_0__[/* ColumnGroup */ "a"]) {
                var columnGroup = columnsOrGroup;
                _this.setupParentsIntoColumns(columnGroup.getChildren(), columnGroup);
            }
        });
    };
    DisplayedGroupCreator.prototype.getOriginalPathForColumn = function (balancedColumnTree, column) {
        var result = [];
        var found = false;
        var recursePath = function (columnTree, dept) {
            for (var i = 0; i < columnTree.length; i++) {
                // quit the search, so 'result' is kept with the found result
                if (found) {
                    return;
                }
                var node = columnTree[i];
                if (node instanceof _entities_providedColumnGroup__WEBPACK_IMPORTED_MODULE_1__[/* ProvidedColumnGroup */ "a"]) {
                    var nextNode = node;
                    recursePath(nextNode.getChildren(), dept + 1);
                    result[dept] = node;
                }
                else if (node === column) {
                    found = true;
                }
            }
        };
        recursePath(balancedColumnTree, 0);
        // it's possible we didn't find a path. this happens if the column is generated
        // by the grid (auto-group), in that the definition didn't come from the client. in this case,
        // we create a fake original path.
        if (found) {
            return result;
        }
        console.warn('could not get path');
        return null;
    };
    DisplayedGroupCreator = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Bean */ "b"])('displayedGroupCreator')
    ], DisplayedGroupCreator);
    return DisplayedGroupCreator;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_3__[/* BeanStub */ "a"]));



/***/ }),

/***/ "1294":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TextFilter; });
/* harmony import */ var _widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6835");
/* harmony import */ var _simpleFilter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("cf29");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("a74a");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("6352");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("348a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var TextFilter = /** @class */ (function (_super) {
    __extends(TextFilter, _super);
    function TextFilter() {
        return _super.call(this, 'textFilter') || this;
    }
    TextFilter.trimInput = function (value) {
        var trimmedInput = value && value.trim();
        // trim the input, unless it is all whitespace (this is consistent with Excel behaviour)
        return trimmedInput === '' ? value : trimmedInput;
    };
    TextFilter.prototype.getDefaultDebounceMs = function () {
        return 500;
    };
    TextFilter.prototype.getCleanValue = function (inputField) {
        var value = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_2__["makeNull"])(inputField.getValue());
        return this.textFilterParams.trimInput ? TextFilter.trimInput(value) : value;
    };
    TextFilter.prototype.addValueChangedListeners = function () {
        var _this = this;
        var listener = function () { return _this.onUiChanged(); };
        this.eValue1.onValueChange(listener);
        this.eValue2.onValueChange(listener);
    };
    TextFilter.prototype.setParams = function (params) {
        _super.prototype.setParams.call(this, params);
        this.textFilterParams = params;
        this.comparator = this.textFilterParams.textCustomComparator || TextFilter.DEFAULT_COMPARATOR;
        this.formatter = this.textFilterParams.textFormatter ||
            (this.textFilterParams.caseSensitive ? TextFilter.DEFAULT_FORMATTER : TextFilter.DEFAULT_LOWERCASE_FORMATTER);
        this.addValueChangedListeners();
    };
    TextFilter.prototype.setConditionIntoUi = function (model, position) {
        var positionOne = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One;
        var eValue = positionOne ? this.eValue1 : this.eValue2;
        eValue.setValue(model ? model.filter : null);
    };
    TextFilter.prototype.createCondition = function (position) {
        var positionOne = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One;
        var type = positionOne ? this.getCondition1Type() : this.getCondition2Type();
        var eValue = positionOne ? this.eValue1 : this.eValue2;
        var value = this.getCleanValue(eValue);
        eValue.setValue(value, true); // ensure clean value is visible
        var model = {
            filterType: this.getFilterType(),
            type: type
        };
        if (!this.doesFilterHaveHiddenInput(type)) {
            model.filter = value;
        }
        return model;
    };
    TextFilter.prototype.getFilterType = function () {
        return 'text';
    };
    TextFilter.prototype.areSimpleModelsEqual = function (aSimple, bSimple) {
        return aSimple.filter === bSimple.filter && aSimple.type === bSimple.type;
    };
    TextFilter.prototype.resetUiToDefaults = function (silent) {
        var _this = this;
        return _super.prototype.resetUiToDefaults.call(this, silent).then(function () {
            _this.forEachInput(function (field) { return field.setValue(null, silent); });
            _this.resetPlaceholder();
        });
    };
    TextFilter.prototype.resetPlaceholder = function () {
        var globalTranslate = this.gridOptionsWrapper.getLocaleTextFunc();
        var placeholder = this.translate('filterOoo');
        this.forEachInput(function (field) {
            field.setInputPlaceholder(placeholder);
            field.setInputAriaLabel(globalTranslate('ariaFilterValue', 'Filter Value'));
        });
    };
    TextFilter.prototype.forEachInput = function (action) {
        Object(_utils_array__WEBPACK_IMPORTED_MODULE_4__["forEach"])([this.eValue1, this.eValue2], action);
    };
    TextFilter.prototype.setValueFromFloatingFilter = function (value) {
        this.eValue1.setValue(value);
        this.eValue2.setValue(null);
    };
    TextFilter.prototype.getDefaultFilterOptions = function () {
        return TextFilter.DEFAULT_FILTER_OPTIONS;
    };
    TextFilter.prototype.createValueTemplate = function (position) {
        var pos = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One ? '1' : '2';
        return /* html */ "\n            <div class=\"ag-filter-body\" ref=\"eCondition" + pos + "Body\" role=\"presentation\">\n                <ag-input-text-field class=\"ag-filter-filter\" ref=\"eValue" + pos + "\"></ag-input-text-field>\n            </div>";
    };
    TextFilter.prototype.updateUiVisibility = function () {
        _super.prototype.updateUiVisibility.call(this);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["setDisplayed"])(this.eCondition1Body, this.showValueFrom(this.getCondition1Type()));
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["setDisplayed"])(this.eCondition2Body, this.isCondition2Enabled() && this.showValueFrom(this.getCondition2Type()));
    };
    TextFilter.prototype.afterGuiAttached = function (params) {
        _super.prototype.afterGuiAttached.call(this, params);
        this.resetPlaceholder();
        if (!params || !params.suppressFocus) {
            this.eValue1.getInputElement().focus();
        }
    };
    TextFilter.prototype.isConditionUiComplete = function (position) {
        var positionOne = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One;
        var option = positionOne ? this.getCondition1Type() : this.getCondition2Type();
        if (option === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].EMPTY) {
            return false;
        }
        if (this.doesFilterHaveHiddenInput(option)) {
            return true;
        }
        return this.getCleanValue(positionOne ? this.eValue1 : this.eValue2) != null;
    };
    TextFilter.prototype.individualConditionPasses = function (params, filterModel) {
        var filterText = filterModel.filter;
        var filterOption = filterModel.type;
        var cellValue = this.textFilterParams.valueGetter(params.node);
        var cellValueFormatted = this.formatter(cellValue);
        var customFilterOption = this.optionsFactory.getCustomOption(filterOption);
        if (customFilterOption) {
            // only execute the custom filter if a value exists or a value isn't required, i.e. input is hidden
            if (filterText != null || customFilterOption.hideFilterInput) {
                return customFilterOption.test(filterText, cellValueFormatted);
            }
        }
        if (cellValue == null) {
            return filterOption === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].NOT_EQUAL || filterOption === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].NOT_CONTAINS;
        }
        var filterTextFormatted = this.formatter(filterText);
        return this.comparator(filterOption, cellValueFormatted, filterTextFormatted);
    };
    TextFilter.DEFAULT_FILTER_OPTIONS = [
        _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].CONTAINS,
        _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].NOT_CONTAINS,
        _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].EQUALS,
        _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].NOT_EQUAL,
        _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].STARTS_WITH,
        _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].ENDS_WITH
    ];
    TextFilter.DEFAULT_FORMATTER = function (from) { return from; };
    TextFilter.DEFAULT_LOWERCASE_FORMATTER = function (from) { return from == null ? null : from.toString().toLowerCase(); };
    TextFilter.DEFAULT_COMPARATOR = function (filter, value, filterText) {
        switch (filter) {
            case TextFilter.CONTAINS:
                return value.indexOf(filterText) >= 0;
            case TextFilter.NOT_CONTAINS:
                return value.indexOf(filterText) < 0;
            case TextFilter.EQUALS:
                return value === filterText;
            case TextFilter.NOT_EQUAL:
                return value != filterText;
            case TextFilter.STARTS_WITH:
                return value.indexOf(filterText) === 0;
            case TextFilter.ENDS_WITH:
                var index = value.lastIndexOf(filterText);
                return index >= 0 && index === (value.length - filterText.length);
            default:
                // should never happen
                console.warn('AG Grid: Unexpected type of filter "' + filter + '", it looks like the filter was configured with incorrect Filter Options');
                return false;
        }
    };
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eValue1')
    ], TextFilter.prototype, "eValue1", void 0);
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eValue2')
    ], TextFilter.prototype, "eValue2", void 0);
    return TextFilter;
}(_simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"]));



/***/ }),

/***/ "1438":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractHeaderCellComp; });
/* harmony import */ var _utils_keyboard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("756a");
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9cc8");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var AbstractHeaderCellComp = /** @class */ (function (_super) {
    __extends(AbstractHeaderCellComp, _super);
    function AbstractHeaderCellComp(template, ctrl) {
        var _this = _super.call(this, template) || this;
        _this.ctrl = ctrl;
        return _this;
    }
    /// temp - this is in the AbstractHeaderCellCtrl also, once all comps refactored, this can be removed
    AbstractHeaderCellComp.prototype.shouldStopEventPropagation = function (e) {
        var _a = this.focusService.getFocusedHeader(), headerRowIndex = _a.headerRowIndex, column = _a.column;
        return Object(_utils_keyboard__WEBPACK_IMPORTED_MODULE_0__["isUserSuppressingHeaderKeyboardEvent"])(this.gridOptionsWrapper, e, headerRowIndex, column);
    };
    AbstractHeaderCellComp.prototype.getCtrl = function () {
        return this.ctrl;
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('focusService')
    ], AbstractHeaderCellComp.prototype, "focusService", void 0);
    return AbstractHeaderCellComp;
}(_widgets_component__WEBPACK_IMPORTED_MODULE_1__[/* Component */ "a"]));



/***/ }),

/***/ "159b":
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__("da84");
var DOMIterables = __webpack_require__("fdbc");
var DOMTokenListPrototype = __webpack_require__("785a");
var forEach = __webpack_require__("17c2");
var createNonEnumerableProperty = __webpack_require__("9112");

var handlePrototype = function (CollectionPrototype) {
  // some Chrome versions have non-configurable methods on DOMTokenList
  if (CollectionPrototype && CollectionPrototype.forEach !== forEach) try {
    createNonEnumerableProperty(CollectionPrototype, 'forEach', forEach);
  } catch (error) {
    CollectionPrototype.forEach = forEach;
  }
};

for (var COLLECTION_NAME in DOMIterables) {
  if (DOMIterables[COLLECTION_NAME]) {
    handlePrototype(global[COLLECTION_NAME] && global[COLLECTION_NAME].prototype);
  }
}

handlePrototype(DOMTokenListPrototype);


/***/ }),

/***/ "1626":
/***/ (function(module, exports) {

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
module.exports = function (argument) {
  return typeof argument === 'function';
};


/***/ }),

/***/ "166a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgAbstractInputField; });
/* harmony import */ var _componentAnnotations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6835");
/* harmony import */ var _agAbstractField__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1d31");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("6352");
/* harmony import */ var _utils_aria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3348");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var AgAbstractInputField = /** @class */ (function (_super) {
    __extends(AgAbstractInputField, _super);
    function AgAbstractInputField(config, className, inputType, displayFieldTag) {
        if (inputType === void 0) { inputType = 'text'; }
        if (displayFieldTag === void 0) { displayFieldTag = 'input'; }
        var _this = _super.call(this, config, /* html */ "\n            <div role=\"presentation\">\n                <div ref=\"eLabel\" class=\"ag-input-field-label\"></div>\n                <div ref=\"eWrapper\" class=\"ag-wrapper ag-input-wrapper\" role=\"presentation\">\n                    <" + displayFieldTag + " ref=\"eInput\" class=\"ag-input-field-input\"></" + displayFieldTag + ">\n                </div>\n            </div>", className) || this;
        _this.inputType = inputType;
        _this.displayFieldTag = displayFieldTag;
        return _this;
    }
    AgAbstractInputField.prototype.postConstruct = function () {
        _super.prototype.postConstruct.call(this);
        this.setInputType();
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.eLabel, this.className + "-label");
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.eWrapper, this.className + "-input-wrapper");
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.eInput, this.className + "-input");
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.getGui(), 'ag-input-field');
        this.eInput.id = this.eInput.id || "ag-" + this.getCompId() + "-input";
        var _a = this.config, width = _a.width, value = _a.value;
        if (width != null) {
            this.setWidth(width);
        }
        if (value != null) {
            this.setValue(value);
        }
        this.addInputListeners();
    };
    AgAbstractInputField.prototype.refreshLabel = function () {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_4__["exists"])(this.getLabel())) {
            Object(_utils_aria__WEBPACK_IMPORTED_MODULE_3__["setAriaLabelledBy"])(this.eInput, this.getLabelId());
        }
        else {
            this.eInput.removeAttribute('aria-labelledby');
        }
        _super.prototype.refreshLabel.call(this);
    };
    AgAbstractInputField.prototype.addInputListeners = function () {
        var _this = this;
        this.addManagedListener(this.eInput, 'input', function (e) { return _this.setValue(e.target.value); });
    };
    AgAbstractInputField.prototype.setInputType = function () {
        if (this.displayFieldTag === 'input') {
            this.eInput.setAttribute('type', this.inputType);
        }
    };
    AgAbstractInputField.prototype.getInputElement = function () {
        return this.eInput;
    };
    AgAbstractInputField.prototype.setInputWidth = function (width) {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setElementWidth"])(this.eWrapper, width);
        return this;
    };
    AgAbstractInputField.prototype.setInputName = function (name) {
        this.getInputElement().setAttribute('name', name);
        return this;
    };
    AgAbstractInputField.prototype.getFocusableElement = function () {
        return this.eInput;
    };
    AgAbstractInputField.prototype.setMaxLength = function (length) {
        var eInput = this.eInput;
        eInput.maxLength = length;
        return this;
    };
    AgAbstractInputField.prototype.setInputPlaceholder = function (placeholder) {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addOrRemoveAttribute"])(this.eInput, 'placeholder', placeholder);
        return this;
    };
    AgAbstractInputField.prototype.setInputAriaLabel = function (label) {
        Object(_utils_aria__WEBPACK_IMPORTED_MODULE_3__["setAriaLabel"])(this.eInput, label);
        return this;
    };
    AgAbstractInputField.prototype.setDisabled = function (disabled) {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setDisabled"])(this.eInput, disabled);
        return _super.prototype.setDisabled.call(this, disabled);
    };
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eLabel')
    ], AgAbstractInputField.prototype, "eLabel", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eWrapper')
    ], AgAbstractInputField.prototype, "eWrapper", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eInput')
    ], AgAbstractInputField.prototype, "eInput", void 0);
    return AgAbstractInputField;
}(_agAbstractField__WEBPACK_IMPORTED_MODULE_1__[/* AgAbstractField */ "a"]));



/***/ }),

/***/ "16a5":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ headerFilterCellComp_HeaderFilterCellComp; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/constants/keyCode.js
var keyCode = __webpack_require__("7a66");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/column.js
var column = __webpack_require__("70d4");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/events.js
var events = __webpack_require__("ad5d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/floating/floatingFilterMapper.js
var floatingFilterMapper = __webpack_require__("a664");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/componentAnnotations.js
var componentAnnotations = __webpack_require__("6835");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/floating/provided/readOnlyFloatingFilter.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



// optional floating filter for user provided filters - instead of providing a floating filter,
// they can provide a getModelAsString() method on the filter instead. this class just displays
// the string returned from getModelAsString()
var readOnlyFloatingFilter_ReadOnlyFloatingFilter = /** @class */ (function (_super) {
    __extends(ReadOnlyFloatingFilter, _super);
    function ReadOnlyFloatingFilter() {
        return _super.call(this, /* html */ "\n            <div class=\"ag-floating-filter-input\" role=\"presentation\">\n                <ag-input-text-field ref=\"eFloatingFilterText\"></ag-input-text-field>\n            </div>") || this;
    }
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    ReadOnlyFloatingFilter.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    ReadOnlyFloatingFilter.prototype.init = function (params) {
        this.params = params;
        var displayName = this.columnModel.getDisplayNameForColumn(params.column, 'header', true);
        var translate = this.gridOptionsWrapper.getLocaleTextFunc();
        this.eFloatingFilterText
            .setDisabled(true)
            .setInputAriaLabel(displayName + " " + translate('ariaFilterInput', 'Filter Input'));
    };
    ReadOnlyFloatingFilter.prototype.onParentModelChanged = function (parentModel) {
        var _this = this;
        if (!parentModel) {
            this.eFloatingFilterText.setValue('');
            return;
        }
        this.params.parentFilterInstance(function (filterInstance) {
            // it would be nice to check if getModelAsString was present before creating this component,
            // however that is not possible, as React Hooks and VueJS don't attached the methods to the Filter until
            // AFTER the filter is created, not allowing inspection before this (we create floating filters as columns
            // are drawn, but the parent filters are only created when needed).
            if (filterInstance.getModelAsString) {
                var modelAsString = filterInstance.getModelAsString(parentModel);
                _this.eFloatingFilterText.setValue(modelAsString);
            }
        });
    };
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eFloatingFilterText')
    ], ReadOnlyFloatingFilter.prototype, "eFloatingFilterText", void 0);
    __decorate([
        Object(context["a" /* Autowired */])('columnModel')
    ], ReadOnlyFloatingFilter.prototype, "columnModel", void 0);
    return ReadOnlyFloatingFilter;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/modules/moduleNames.js
var moduleNames = __webpack_require__("b5fb");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/modules/moduleRegistry.js
var moduleRegistry = __webpack_require__("2c7d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/features/setLeftFeature.js
var features_setLeftFeature = __webpack_require__("6420");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/index.js + 8 modules
var utils = __webpack_require__("7347");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/icon.js
var icon = __webpack_require__("781c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/managedFocusFeature.js
var managedFocusFeature = __webpack_require__("8453");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/abstractCell/abstractHeaderCellComp.js
var abstractHeaderCellComp = __webpack_require__("1438");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/hoverFeature.js
var hoverFeature = __webpack_require__("98d0");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/floatingFilter/headerFilterCellComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var headerFilterCellComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var headerFilterCellComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
















var headerFilterCellComp_HeaderFilterCellComp = /** @class */ (function (_super) {
    headerFilterCellComp_extends(HeaderFilterCellComp, _super);
    function HeaderFilterCellComp(ctrl) {
        var _this = _super.call(this, HeaderFilterCellComp.TEMPLATE, ctrl) || this;
        _this.column = ctrl.getColumnGroupChild();
        _this.pinned = ctrl.getPinned();
        return _this;
    }
    HeaderFilterCellComp.prototype.postConstruct = function () {
        this.setupFloatingFilter();
        this.setupWidth();
        this.setupLeftPositioning();
        this.setupColumnHover();
        this.createManagedBean(new hoverFeature["a" /* HoverFeature */]([this.column], this.getGui()));
        this.createManagedBean(new managedFocusFeature["a" /* ManagedFocusFeature */](this.getFocusableElement(), {
            shouldStopEventPropagation: this.shouldStopEventPropagation.bind(this),
            onTabKeyDown: this.onTabKeyDown.bind(this),
            handleKeyDown: this.handleKeyDown.bind(this),
            onFocusIn: this.onFocusIn.bind(this)
        }));
        this.addManagedListener(this.eButtonShowMainFilter, 'click', this.showParentFilter.bind(this));
        var compProxy = {};
        this.ctrl.setComp(compProxy, this.getGui());
    };
    HeaderFilterCellComp.prototype.getColumn = function () {
        return this.column;
    };
    HeaderFilterCellComp.prototype.onTabKeyDown = function (e) {
        var activeEl = document.activeElement;
        var eGui = this.getGui();
        var wrapperHasFocus = activeEl === eGui;
        if (wrapperHasFocus) {
            return;
        }
        e.preventDefault();
        var nextFocusableEl = this.focusService.findNextFocusableElement(eGui, null, e.shiftKey);
        if (nextFocusableEl) {
            nextFocusableEl.focus();
        }
        else {
            eGui.focus();
        }
    };
    HeaderFilterCellComp.prototype.handleKeyDown = function (e) {
        var activeEl = document.activeElement;
        var eGui = this.getGui();
        var wrapperHasFocus = activeEl === eGui;
        switch (e.keyCode) {
            case keyCode["a" /* KeyCode */].UP:
            case keyCode["a" /* KeyCode */].DOWN:
                if (!wrapperHasFocus) {
                    e.preventDefault();
                }
            case keyCode["a" /* KeyCode */].LEFT:
            case keyCode["a" /* KeyCode */].RIGHT:
                if (wrapperHasFocus) {
                    return;
                }
                e.stopPropagation();
            case keyCode["a" /* KeyCode */].ENTER:
                if (wrapperHasFocus) {
                    if (this.focusService.focusInto(eGui)) {
                        e.preventDefault();
                    }
                }
                break;
            case keyCode["a" /* KeyCode */].ESCAPE:
                if (!wrapperHasFocus) {
                    this.getGui().focus();
                }
        }
    };
    HeaderFilterCellComp.prototype.onFocusIn = function (e) {
        var eGui = this.getGui();
        if (!eGui.contains(e.relatedTarget)) {
            var rowIndex = this.ctrl.getRowIndex();
            this.beans.focusService.setFocusedHeader(rowIndex, this.getColumn());
        }
    };
    HeaderFilterCellComp.prototype.setupFloatingFilter = function () {
        var _this = this;
        var colDef = this.column.getColDef();
        if ((!colDef.filter || !colDef.floatingFilter) && (!colDef.filterFramework || !colDef.floatingFilterComponentFramework)) {
            return;
        }
        this.floatingFilterCompPromise = this.getFloatingFilterInstance();
        if (!this.floatingFilterCompPromise) {
            return;
        }
        this.floatingFilterCompPromise.then(function (compInstance) {
            if (compInstance) {
                _this.setupWithFloatingFilter(compInstance);
                _this.setupSyncWithFilter();
            }
        });
    };
    HeaderFilterCellComp.prototype.setupLeftPositioning = function () {
        var setLeftFeature = new features_setLeftFeature["a" /* SetLeftFeature */](this.column, this.getGui(), this.beans);
        this.createManagedBean(setLeftFeature);
    };
    HeaderFilterCellComp.prototype.setupSyncWithFilter = function () {
        var _this = this;
        var syncWithFilter = function (filterChangedEvent) {
            _this.onParentModelChanged(_this.currentParentModel(), filterChangedEvent);
        };
        this.addManagedListener(this.column, column["a" /* Column */].EVENT_FILTER_CHANGED, syncWithFilter);
        if (this.filterManager.isFilterActive(this.column)) {
            syncWithFilter(null);
        }
    };
    // linked to event listener in template
    HeaderFilterCellComp.prototype.showParentFilter = function () {
        var eventSource = this.suppressFilterButton ? this.eFloatingFilterBody : this.eButtonShowMainFilter;
        this.menuFactory.showMenuAfterButtonClick(this.column, eventSource, 'floatingFilter', 'filterMenuTab', ['filterMenuTab']);
    };
    HeaderFilterCellComp.prototype.setupColumnHover = function () {
        this.addManagedListener(this.eventService, events["a" /* Events */].EVENT_COLUMN_HOVER_CHANGED, this.onColumnHover.bind(this));
        this.onColumnHover();
    };
    HeaderFilterCellComp.prototype.onColumnHover = function () {
        if (!this.gridOptionsWrapper.isColumnHoverHighlight()) {
            return;
        }
        Object(dom["addOrRemoveCssClass"])(this.getGui(), 'ag-column-hover', this.columnHoverService.isHovered(this.column));
    };
    HeaderFilterCellComp.prototype.setupWidth = function () {
        this.addManagedListener(this.column, column["a" /* Column */].EVENT_WIDTH_CHANGED, this.onColumnWidthChanged.bind(this));
        this.onColumnWidthChanged();
    };
    HeaderFilterCellComp.prototype.onColumnWidthChanged = function () {
        this.getGui().style.width = this.column.getActualWidth() + "px";
    };
    HeaderFilterCellComp.prototype.setupWithFloatingFilter = function (floatingFilterComp) {
        var _this = this;
        var disposeFunc = function () {
            _this.getContext().destroyBean(floatingFilterComp);
        };
        if (!this.isAlive()) {
            disposeFunc();
            return;
        }
        this.addDestroyFunc(disposeFunc);
        var floatingFilterCompUi = floatingFilterComp.getGui();
        Object(dom["addOrRemoveCssClass"])(this.eFloatingFilterBody, 'ag-floating-filter-full-body', this.suppressFilterButton);
        Object(dom["addOrRemoveCssClass"])(this.eFloatingFilterBody, 'ag-floating-filter-body', !this.suppressFilterButton);
        Object(dom["setDisplayed"])(this.eButtonWrapper, !this.suppressFilterButton);
        var eIcon = Object(icon["createIconNoSpan"])('filter', this.gridOptionsWrapper, this.column);
        this.eButtonShowMainFilter.appendChild(eIcon);
        this.eFloatingFilterBody.appendChild(floatingFilterCompUi);
        if (floatingFilterComp.afterGuiAttached) {
            floatingFilterComp.afterGuiAttached();
        }
    };
    HeaderFilterCellComp.prototype.parentFilterInstance = function (callback) {
        var filterComponent = this.getFilterComponent();
        if (filterComponent) {
            filterComponent.then(callback);
        }
    };
    HeaderFilterCellComp.prototype.getFilterComponent = function (createIfDoesNotExist) {
        if (createIfDoesNotExist === void 0) { createIfDoesNotExist = true; }
        return this.filterManager.getFilterComponent(this.column, 'NO_UI', createIfDoesNotExist);
    };
    HeaderFilterCellComp.getDefaultFloatingFilterType = function (def) {
        if (def == null) {
            return null;
        }
        var defaultFloatingFilterType = null;
        if (typeof def.filter === 'string') {
            // will be undefined if not in the map
            defaultFloatingFilterType = floatingFilterMapper["a" /* FloatingFilterMapper */].getFloatingFilterType(def.filter);
        }
        else if (def.filterFramework) {
            // If filterFramework, then grid is NOT using one of the provided filters, hence no default.
            // Note: We could combine this with another part of the 'if' statement, however explicitly
            // having this section makes the code easier to read.
        }
        else if (def.filter === true) {
            var setFilterModuleLoaded = moduleRegistry["a" /* ModuleRegistry */].isRegistered(moduleNames["a" /* ModuleNames */].SetFilterModule);
            defaultFloatingFilterType = setFilterModuleLoaded ? 'agSetColumnFloatingFilter' : 'agTextColumnFloatingFilter';
        }
        return defaultFloatingFilterType;
    };
    HeaderFilterCellComp.prototype.getFloatingFilterInstance = function () {
        var colDef = this.column.getColDef();
        var defaultFloatingFilterType = HeaderFilterCellComp.getDefaultFloatingFilterType(colDef);
        var filterParams = this.filterManager.createFilterParams(this.column, colDef);
        var finalFilterParams = this.userComponentFactory.mergeParamsWithApplicationProvidedParams(colDef, 'filter', filterParams);
        var params = {
            api: this.gridApi,
            column: this.column,
            filterParams: finalFilterParams,
            currentParentModel: this.currentParentModel.bind(this),
            parentFilterInstance: this.parentFilterInstance.bind(this),
            showParentFilter: this.showParentFilter.bind(this),
            onFloatingFilterChanged: this.onFloatingFilterChanged.bind(this),
            suppressFilterButton: false // This one might be overridden from the colDef
        };
        // this is unusual - we need a params value OUTSIDE the component the params are for.
        // the params are for the floating filter component, but this property is actually for the wrapper.
        this.suppressFilterButton = colDef.floatingFilterComponentParams ? !!colDef.floatingFilterComponentParams.suppressFilterButton : false;
        var promise = this.userComponentFactory.newFloatingFilterComponent(colDef, params, defaultFloatingFilterType);
        if (!promise) {
            var compInstance = this.userComponentFactory.createUserComponentFromConcreteClass(readOnlyFloatingFilter_ReadOnlyFloatingFilter, params);
            promise = utils["a" /* AgPromise */].resolve(compInstance);
        }
        return promise;
    };
    HeaderFilterCellComp.prototype.currentParentModel = function () {
        var filterComponent = this.getFilterComponent(false);
        return filterComponent ? filterComponent.resolveNow(null, function (filter) { return filter && filter.getModel(); }) : null;
    };
    HeaderFilterCellComp.prototype.onParentModelChanged = function (model, filterChangedEvent) {
        if (!this.floatingFilterCompPromise) {
            return;
        }
        this.floatingFilterCompPromise.then(function (comp) { return comp && comp.onParentModelChanged(model, filterChangedEvent); });
    };
    HeaderFilterCellComp.prototype.onFloatingFilterChanged = function () {
        console.warn('AG Grid: since version 21.x, how floating filters are implemented has changed. ' +
            'Instead of calling params.onFloatingFilterChanged(), get a reference to the main filter via ' +
            'params.parentFilterInstance() and then set a value on the parent filter directly.');
    };
    HeaderFilterCellComp.TEMPLATE = "<div class=\"ag-header-cell ag-floating-filter\" role=\"gridcell\" tabindex=\"-1\">\n            <div class=\"ag-floating-filter-full-body\" ref=\"eFloatingFilterBody\" role=\"presentation\"></div>\n            <div class=\"ag-floating-filter-button ag-hidden\" ref=\"eButtonWrapper\" role=\"presentation\">\n                <button type=\"button\" aria-label=\"Open Filter Menu\" class=\"ag-floating-filter-button-button\" ref=\"eButtonShowMainFilter\" tabindex=\"-1\"></button>\n            </div>\n        </div>";
    headerFilterCellComp_decorate([
        Object(context["a" /* Autowired */])('columnHoverService')
    ], HeaderFilterCellComp.prototype, "columnHoverService", void 0);
    headerFilterCellComp_decorate([
        Object(context["a" /* Autowired */])('userComponentFactory')
    ], HeaderFilterCellComp.prototype, "userComponentFactory", void 0);
    headerFilterCellComp_decorate([
        Object(context["a" /* Autowired */])('gridApi')
    ], HeaderFilterCellComp.prototype, "gridApi", void 0);
    headerFilterCellComp_decorate([
        Object(context["a" /* Autowired */])('filterManager')
    ], HeaderFilterCellComp.prototype, "filterManager", void 0);
    headerFilterCellComp_decorate([
        Object(context["a" /* Autowired */])('menuFactory')
    ], HeaderFilterCellComp.prototype, "menuFactory", void 0);
    headerFilterCellComp_decorate([
        Object(context["a" /* Autowired */])('beans')
    ], HeaderFilterCellComp.prototype, "beans", void 0);
    headerFilterCellComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eFloatingFilterBody')
    ], HeaderFilterCellComp.prototype, "eFloatingFilterBody", void 0);
    headerFilterCellComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eButtonWrapper')
    ], HeaderFilterCellComp.prototype, "eButtonWrapper", void 0);
    headerFilterCellComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eButtonShowMainFilter')
    ], HeaderFilterCellComp.prototype, "eButtonShowMainFilter", void 0);
    headerFilterCellComp_decorate([
        context["e" /* PostConstruct */]
    ], HeaderFilterCellComp.prototype, "postConstruct", null);
    return HeaderFilterCellComp;
}(abstractHeaderCellComp["a" /* AbstractHeaderCellComp */]));



/***/ }),

/***/ "17c2":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $forEach = __webpack_require__("b727").forEach;
var arrayMethodIsStrict = __webpack_require__("a640");

var STRICT_METHOD = arrayMethodIsStrict('forEach');

// `Array.prototype.forEach` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.foreach
module.exports = !STRICT_METHOD ? function forEach(callbackfn /* , thisArg */) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
} : [].forEach;


/***/ }),

/***/ "1946":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TabGuardComp; });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("9cc8");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("6352");
/* harmony import */ var _tabGuardCtrl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("8e65");
/* harmony import */ var _utils_aria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3348");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var TabGuardComp = /** @class */ (function (_super) {
    __extends(TabGuardComp, _super);
    function TabGuardComp() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TabGuardComp.prototype.initialiseTabGuard = function (params) {
        this.eTopGuard = this.createTabGuard('top');
        this.eBottomGuard = this.createTabGuard('bottom');
        this.eFocusableElement = this.getFocusableElement();
        var tabGuards = [this.eTopGuard, this.eBottomGuard];
        var compProxy = {
            setTabIndex: function (tabIndex) {
                tabGuards.forEach(function (tabGuard) { return tabIndex != null ? tabGuard.setAttribute('tabIndex', tabIndex) : tabGuard.removeAttribute('tabIndex'); });
            }
        };
        this.addTabGuards(this.eTopGuard, this.eBottomGuard);
        this.tabGuardCtrl = this.createManagedBean(new _tabGuardCtrl__WEBPACK_IMPORTED_MODULE_2__[/* TabGuardCtrl */ "a"]({
            comp: compProxy,
            eTopGuard: this.eTopGuard,
            eBottomGuard: this.eBottomGuard,
            eFocusableElement: this.eFocusableElement,
            onFocusIn: params.onFocusIn,
            onFocusOut: params.onFocusOut,
            focusInnerElement: params.focusInnerElement,
            handleKeyDown: params.handleKeyDown,
            onTabKeyDown: params.onTabKeyDown,
            shouldStopEventPropagation: params.shouldStopEventPropagation
        }));
    };
    TabGuardComp.prototype.createTabGuard = function (side) {
        var tabGuard = document.createElement('div');
        tabGuard.classList.add('ag-tab-guard');
        tabGuard.classList.add("ag-tab-guard-" + side);
        Object(_utils_aria__WEBPACK_IMPORTED_MODULE_3__["setAriaRole"])(tabGuard, 'presentation');
        return tabGuard;
    };
    TabGuardComp.prototype.addTabGuards = function (topTabGuard, bottomTabGuard) {
        this.eFocusableElement.insertAdjacentElement('afterbegin', topTabGuard);
        this.eFocusableElement.insertAdjacentElement('beforeend', bottomTabGuard);
    };
    TabGuardComp.prototype.removeAllChildrenExceptTabGuards = function () {
        var tabGuards = [this.eTopGuard, this.eBottomGuard];
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["clearElement"])(this.getFocusableElement());
        this.addTabGuards.apply(this, tabGuards);
    };
    TabGuardComp.prototype.forceFocusOutOfContainer = function (up) {
        if (up === void 0) { up = false; }
        this.tabGuardCtrl.forceFocusOutOfContainer(up);
    };
    TabGuardComp.prototype.appendChild = function (newChild, container) {
        if (!Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["isNodeOrElement"])(newChild)) {
            newChild = newChild.getGui();
        }
        var bottomTabGuard = this.eBottomGuard;
        if (bottomTabGuard) {
            bottomTabGuard.insertAdjacentElement('beforebegin', newChild);
        }
        else {
            _super.prototype.appendChild.call(this, newChild, container);
        }
    };
    return TabGuardComp;
}(_component__WEBPACK_IMPORTED_MODULE_0__[/* Component */ "a"]));



/***/ }),

/***/ "1a2d":
/***/ (function(module, exports, __webpack_require__) {

var toObject = __webpack_require__("7b0b");

var hasOwnProperty = {}.hasOwnProperty;

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
module.exports = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty.call(toObject(it), key);
};


/***/ }),

/***/ "1d31":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgAbstractField; });
/* harmony import */ var _agAbstractLabel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6321");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("6352");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var AgAbstractField = /** @class */ (function (_super) {
    __extends(AgAbstractField, _super);
    function AgAbstractField(config, template, className) {
        var _this = _super.call(this, config, template) || this;
        _this.className = className;
        _this.disabled = false;
        return _this;
    }
    AgAbstractField.prototype.postConstruct = function () {
        _super.prototype.postConstruct.call(this);
        if (this.className) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["addCssClass"])(this.getGui(), this.className);
        }
    };
    AgAbstractField.prototype.onValueChange = function (callbackFn) {
        var _this = this;
        this.addManagedListener(this, AgAbstractField.EVENT_CHANGED, function () { return callbackFn(_this.getValue()); });
        return this;
    };
    AgAbstractField.prototype.getWidth = function () {
        return this.getGui().clientWidth;
    };
    AgAbstractField.prototype.setWidth = function (width) {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["setFixedWidth"])(this.getGui(), width);
        return this;
    };
    AgAbstractField.prototype.getPreviousValue = function () {
        return this.previousValue;
    };
    AgAbstractField.prototype.getValue = function () {
        return this.value;
    };
    AgAbstractField.prototype.setValue = function (value, silent) {
        if (this.value === value) {
            return this;
        }
        this.previousValue = this.value;
        this.value = value;
        if (!silent) {
            this.dispatchEvent({ type: AgAbstractField.EVENT_CHANGED });
        }
        return this;
    };
    AgAbstractField.prototype.setDisabled = function (disabled) {
        disabled = !!disabled;
        var element = this.getGui();
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["setDisabled"])(element, disabled);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["addOrRemoveCssClass"])(element, 'ag-disabled', disabled);
        this.disabled = disabled;
        return this;
    };
    AgAbstractField.prototype.isDisabled = function () {
        return !!this.disabled;
    };
    AgAbstractField.EVENT_CHANGED = 'valueChange';
    return AgAbstractField;
}(_agAbstractLabel__WEBPACK_IMPORTED_MODULE_0__[/* AgAbstractLabel */ "a"]));



/***/ }),

/***/ "1d80":
/***/ (function(module, exports) {

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};


/***/ }),

/***/ "1de3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ClientSideRowModelSteps; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var ClientSideRowModelSteps;
(function (ClientSideRowModelSteps) {
    ClientSideRowModelSteps["EVERYTHING"] = "group";
    ClientSideRowModelSteps["FILTER"] = "filter";
    ClientSideRowModelSteps["SORT"] = "sort";
    ClientSideRowModelSteps["MAP"] = "map";
    ClientSideRowModelSteps["AGGREGATE"] = "aggregate";
    ClientSideRowModelSteps["PIVOT"] = "pivot";
    ClientSideRowModelSteps["NOTHING"] = "nothing";
})(ClientSideRowModelSteps || (ClientSideRowModelSteps = {}));


/***/ }),

/***/ "1e85":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgToggleButton; });
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6352");
/* harmony import */ var _agCheckbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("b678");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var AgToggleButton = /** @class */ (function (_super) {
    __extends(AgToggleButton, _super);
    function AgToggleButton(config) {
        return _super.call(this, config, 'ag-toggle-button') || this;
    }
    AgToggleButton.prototype.setValue = function (value, silent) {
        _super.prototype.setValue.call(this, value, silent);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_0__["addOrRemoveCssClass"])(this.getGui(), 'ag-selected', this.getValue());
        return this;
    };
    return AgToggleButton;
}(_agCheckbox__WEBPACK_IMPORTED_MODULE_1__[/* AgCheckbox */ "a"]));



/***/ }),

/***/ "1f74":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AutoScrollService; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var AutoScrollService = /** @class */ (function () {
    function AutoScrollService(params) {
        this.tickingInterval = null;
        this.onScrollCallback = null;
        this.scrollContainer = params.scrollContainer;
        this.scrollHorizontally = params.scrollAxis.indexOf('x') !== -1;
        this.scrollVertically = params.scrollAxis.indexOf('y') !== -1;
        this.scrollByTick = params.scrollByTick != null ? params.scrollByTick : 20;
        if (params.onScrollCallback) {
            this.onScrollCallback = params.onScrollCallback;
        }
        if (this.scrollVertically) {
            this.getVerticalPosition = params.getVerticalPosition;
            this.setVerticalPosition = params.setVerticalPosition;
        }
        if (this.scrollHorizontally) {
            this.getHorizontalPosition = params.getHorizontalPosition;
            this.setHorizontalPosition = params.setHorizontalPosition;
        }
        this.shouldSkipVerticalScroll = params.shouldSkipVerticalScroll || (function () { return false; });
        this.shouldSkipHorizontalScroll = params.shouldSkipHorizontalScroll || (function () { return false; });
    }
    AutoScrollService.prototype.check = function (mouseEvent, forceSkipVerticalScroll) {
        if (forceSkipVerticalScroll === void 0) { forceSkipVerticalScroll = false; }
        var skipVerticalScroll = forceSkipVerticalScroll || this.shouldSkipVerticalScroll();
        if (skipVerticalScroll && this.shouldSkipHorizontalScroll()) {
            return;
        }
        var rect = this.scrollContainer.getBoundingClientRect();
        var scrollTick = this.scrollByTick;
        this.tickLeft = mouseEvent.clientX < (rect.left + scrollTick);
        this.tickRight = mouseEvent.clientX > (rect.right - scrollTick);
        this.tickUp = mouseEvent.clientY < (rect.top + scrollTick) && !skipVerticalScroll;
        this.tickDown = mouseEvent.clientY > (rect.bottom - scrollTick) && !skipVerticalScroll;
        if (this.tickLeft || this.tickRight || this.tickUp || this.tickDown) {
            this.ensureTickingStarted();
        }
        else {
            this.ensureCleared();
        }
    };
    AutoScrollService.prototype.ensureTickingStarted = function () {
        if (this.tickingInterval === null) {
            this.tickingInterval = window.setInterval(this.doTick.bind(this), 100);
            this.tickCount = 0;
        }
    };
    AutoScrollService.prototype.doTick = function () {
        this.tickCount++;
        var tickAmount;
        tickAmount = this.tickCount > 20 ? 200 : (this.tickCount > 10 ? 80 : 40);
        if (this.scrollVertically) {
            var vScrollPosition = this.getVerticalPosition();
            if (this.tickUp) {
                this.setVerticalPosition(vScrollPosition - tickAmount);
            }
            if (this.tickDown) {
                this.setVerticalPosition(vScrollPosition + tickAmount);
            }
        }
        if (this.scrollHorizontally) {
            var hScrollPosition = this.getHorizontalPosition();
            if (this.tickLeft) {
                this.setHorizontalPosition(hScrollPosition - tickAmount);
            }
            if (this.tickRight) {
                this.setHorizontalPosition(hScrollPosition + tickAmount);
            }
        }
        if (this.onScrollCallback) {
            this.onScrollCallback();
        }
    };
    AutoScrollService.prototype.ensureCleared = function () {
        if (this.tickingInterval) {
            window.clearInterval(this.tickingInterval);
            this.tickingInterval = null;
        }
    };
    return AutoScrollService;
}());



/***/ }),

/***/ "20ba":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AnimateShowChangeCellRenderer; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9cc8");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("a74a");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("6352");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var ARROW_UP = '\u2191';
var ARROW_DOWN = '\u2193';
var AnimateShowChangeCellRenderer = /** @class */ (function (_super) {
    __extends(AnimateShowChangeCellRenderer, _super);
    function AnimateShowChangeCellRenderer() {
        var _this = _super.call(this, AnimateShowChangeCellRenderer.TEMPLATE) || this;
        _this.refreshCount = 0;
        return _this;
    }
    AnimateShowChangeCellRenderer.prototype.init = function (params) {
        // this.params = params;
        this.eValue = this.queryForHtmlElement('.ag-value-change-value');
        this.eDelta = this.queryForHtmlElement('.ag-value-change-delta');
        this.refresh(params);
    };
    AnimateShowChangeCellRenderer.prototype.showDelta = function (params, delta) {
        var absDelta = Math.abs(delta);
        var valueFormatted = params.formatValue(absDelta);
        var valueToUse = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_2__["exists"])(valueFormatted) ? valueFormatted : absDelta;
        var deltaUp = (delta >= 0);
        if (deltaUp) {
            this.eDelta.innerHTML = ARROW_UP + valueToUse;
        }
        else {
            // because negative, use ABS to remove sign
            this.eDelta.innerHTML = ARROW_DOWN + valueToUse;
        }
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["addOrRemoveCssClass"])(this.eDelta, 'ag-value-change-delta-up', deltaUp);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["addOrRemoveCssClass"])(this.eDelta, 'ag-value-change-delta-down', !deltaUp);
    };
    AnimateShowChangeCellRenderer.prototype.setTimerToRemoveDelta = function () {
        var _this = this;
        // the refreshCount makes sure that if the value updates again while
        // the below timer is waiting, then the below timer will realise it
        // is not the most recent and will not try to remove the delta value.
        this.refreshCount++;
        var refreshCountCopy = this.refreshCount;
        window.setTimeout(function () {
            if (refreshCountCopy === _this.refreshCount) {
                _this.hideDeltaValue();
            }
        }, 2000);
    };
    AnimateShowChangeCellRenderer.prototype.hideDeltaValue = function () {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["removeCssClass"])(this.eValue, 'ag-value-change-value-highlight');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["clearElement"])(this.eDelta);
    };
    AnimateShowChangeCellRenderer.prototype.refresh = function (params) {
        var value = params.value;
        if (value === this.lastValue) {
            return false;
        }
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_2__["exists"])(params.valueFormatted)) {
            this.eValue.innerHTML = params.valueFormatted;
        }
        else if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_2__["exists"])(params.value)) {
            this.eValue.innerHTML = value;
        }
        else {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["clearElement"])(this.eValue);
        }
        // we don't show the delta if we are in the middle of a filter. see comment on FilterManager
        // with regards processingFilterChange
        if (this.filterManager.isSuppressFlashingCellsBecauseFiltering()) {
            return false;
        }
        if (typeof value === 'number' && typeof this.lastValue === 'number') {
            var delta = value - this.lastValue;
            this.showDelta(params, delta);
        }
        // highlight the current value, but only if it's not new, otherwise it
        // would get highlighted first time the value is shown
        if (this.lastValue) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["addCssClass"])(this.eValue, 'ag-value-change-value-highlight');
        }
        this.setTimerToRemoveDelta();
        this.lastValue = value;
        return true;
    };
    AnimateShowChangeCellRenderer.TEMPLATE = '<span>' +
        '<span class="ag-value-change-delta"></span>' +
        '<span class="ag-value-change-value"></span>' +
        '</span>';
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('filterManager')
    ], AnimateShowChangeCellRenderer.prototype, "filterManager", void 0);
    return AnimateShowChangeCellRenderer;
}(_widgets_component__WEBPACK_IMPORTED_MODULE_1__[/* Component */ "a"]));



/***/ }),

/***/ "217a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HeaderPositionUtils; });
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _entities_columnGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("64bd");
/* harmony import */ var _row_headerRowComp__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("2ce1");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var HeaderPositionUtils = /** @class */ (function (_super) {
    __extends(HeaderPositionUtils, _super);
    function HeaderPositionUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    HeaderPositionUtils.prototype.findHeader = function (focusedHeader, direction) {
        var nextColumn;
        var getGroupMethod;
        var getColMethod;
        if (focusedHeader.column instanceof _entities_columnGroup__WEBPACK_IMPORTED_MODULE_2__[/* ColumnGroup */ "a"]) {
            getGroupMethod = "getDisplayedGroup" + direction;
            nextColumn = this.columnModel[getGroupMethod](focusedHeader.column);
        }
        else {
            getColMethod = "getDisplayedCol" + direction;
            nextColumn = this.columnModel[getColMethod](focusedHeader.column);
        }
        if (nextColumn) {
            return {
                column: nextColumn,
                headerRowIndex: focusedHeader.headerRowIndex
            };
        }
    };
    HeaderPositionUtils.prototype.findColAtEdgeForHeaderRow = function (level, position) {
        var displayedColumns = this.columnModel.getAllDisplayedColumns();
        var column = displayedColumns[position === 'start' ? 0 : displayedColumns.length - 1];
        if (!column) {
            return;
        }
        var childContainer = this.ctrlsService.getHeaderRowContainerCtrl(column.getPinned());
        var type = childContainer.getRowType(level);
        console.log("level=" + level + " type = " + type);
        if (type == _row_headerRowComp__WEBPACK_IMPORTED_MODULE_3__[/* HeaderRowType */ "b"].COLUMN_GROUP) {
            var columnGroup = this.columnModel.getColumnGroupAtLevel(column, level);
            return {
                headerRowIndex: level,
                column: columnGroup
            };
        }
        return {
            // if type==null, means the header level didn't exist
            headerRowIndex: type == null ? -1 : level,
            column: column
        };
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('columnModel')
    ], HeaderPositionUtils.prototype, "columnModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('ctrlsService')
    ], HeaderPositionUtils.prototype, "ctrlsService", void 0);
    HeaderPositionUtils = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Bean */ "b"])('headerPositionUtils')
    ], HeaderPositionUtils);
    return HeaderPositionUtils;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_0__[/* BeanStub */ "a"]));



/***/ }),

/***/ "228c":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
__export(__webpack_require__("71a7"));



/***/ }),

/***/ "22b5":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractHeaderCellCtrl; });
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_keyboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("756a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var instanceIdSequence = 0;
var AbstractHeaderCellCtrl = /** @class */ (function (_super) {
    __extends(AbstractHeaderCellCtrl, _super);
    function AbstractHeaderCellCtrl(columnGroupChild, parentRowCtrl) {
        var _this = _super.call(this) || this;
        _this.columnGroupChild = columnGroupChild;
        _this.parentRowCtrl = parentRowCtrl;
        // unique id to this instance, including the column ID to help with debugging in React as it's used in 'key'
        _this.instanceId = columnGroupChild.getUniqueId() + '-' + instanceIdSequence++;
        return _this;
    }
    AbstractHeaderCellCtrl.prototype.shouldStopEventPropagation = function (e) {
        var _a = this.focusService.getFocusedHeader(), headerRowIndex = _a.headerRowIndex, column = _a.column;
        return Object(_utils_keyboard__WEBPACK_IMPORTED_MODULE_2__["isUserSuppressingHeaderKeyboardEvent"])(this.gridOptionsWrapper, e, headerRowIndex, column);
    };
    AbstractHeaderCellCtrl.prototype.setGui = function (eGui) {
        this.eGui = eGui;
        this.addDomData();
    };
    AbstractHeaderCellCtrl.prototype.addDomData = function () {
        var _this = this;
        var key = AbstractHeaderCellCtrl.DOM_DATA_KEY_HEADER_CTRL;
        this.gridOptionsWrapper.setDomData(this.eGui, key, this);
        this.addDestroyFunc(function () { return _this.gridOptionsWrapper.setDomData(_this.eGui, key, null); });
    };
    AbstractHeaderCellCtrl.prototype.focus = function () {
        if (!this.eGui) {
            return false;
        }
        this.eGui.focus();
        return true;
    };
    AbstractHeaderCellCtrl.prototype.getRowIndex = function () {
        return this.parentRowCtrl.getRowIndex();
    };
    AbstractHeaderCellCtrl.prototype.getParentRowCtrl = function () {
        return this.parentRowCtrl;
    };
    AbstractHeaderCellCtrl.prototype.getPinned = function () {
        return this.parentRowCtrl.getPinned();
    };
    AbstractHeaderCellCtrl.prototype.getInstanceId = function () {
        return this.instanceId;
    };
    AbstractHeaderCellCtrl.prototype.getColumnGroupChild = function () {
        return this.columnGroupChild;
    };
    AbstractHeaderCellCtrl.DOM_DATA_KEY_HEADER_CTRL = 'headerCtrl';
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('focusService')
    ], AbstractHeaderCellCtrl.prototype, "focusService", void 0);
    return AbstractHeaderCellCtrl;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_0__[/* BeanStub */ "a"]));



/***/ }),

/***/ "2377":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Events; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var Events = /** @class */ (function () {
    function Events() {
    }
    /** Everything has changed with the columns. Either complete new set of columns set, or user called setState() */
    /** @deprecated - grid no longer uses this, and setSate() also fires individual events */
    Events.EVENT_COLUMN_EVERYTHING_CHANGED = 'columnEverythingChanged';
    /** User has set in new columns. */
    Events.EVENT_NEW_COLUMNS_LOADED = 'newColumnsLoaded';
    /** The pivot mode flag was changed */
    Events.EVENT_COLUMN_PIVOT_MODE_CHANGED = 'columnPivotModeChanged';
    /** A row group column was added, removed or order changed. */
    Events.EVENT_COLUMN_ROW_GROUP_CHANGED = 'columnRowGroupChanged';
    /** expandAll / collapseAll was called from the api. */
    Events.EVENT_EXPAND_COLLAPSE_ALL = 'expandOrCollapseAll';
    /** A pivot column was added, removed or order changed. */
    Events.EVENT_COLUMN_PIVOT_CHANGED = 'columnPivotChanged';
    /** The list of grid columns has changed. */
    Events.EVENT_GRID_COLUMNS_CHANGED = 'gridColumnsChanged';
    /** A value column was added, removed or agg function was changed. */
    Events.EVENT_COLUMN_VALUE_CHANGED = 'columnValueChanged';
    /** A column was moved */
    Events.EVENT_COLUMN_MOVED = 'columnMoved';
    /** One or more columns was shown / hidden */
    Events.EVENT_COLUMN_VISIBLE = 'columnVisible';
    /** One or more columns was pinned / unpinned*/
    Events.EVENT_COLUMN_PINNED = 'columnPinned';
    /** A column group was opened / closed */
    Events.EVENT_COLUMN_GROUP_OPENED = 'columnGroupOpened';
    /** One or more columns was resized. If just one, the column in the event is set. */
    Events.EVENT_COLUMN_RESIZED = 'columnResized';
    /** The list of displayed columns has changed, can result from columns open / close, column move, pivot, group, etc */
    Events.EVENT_DISPLAYED_COLUMNS_CHANGED = 'displayedColumnsChanged';
    /** The list of virtual columns has changed, results from viewport changing */
    Events.EVENT_VIRTUAL_COLUMNS_CHANGED = 'virtualColumnsChanged';
    /** Async Transactions Executed */
    Events.EVENT_ASYNC_TRANSACTIONS_FLUSHED = 'asyncTransactionsFlushed';
    /** A row group was opened / closed */
    Events.EVENT_ROW_GROUP_OPENED = 'rowGroupOpened';
    /** The client has set new data into the grid */
    Events.EVENT_ROW_DATA_CHANGED = 'rowDataChanged';
    /** The client has updated data for the grid */
    Events.EVENT_ROW_DATA_UPDATED = 'rowDataUpdated';
    /** The client has set new floating data into the grid */
    Events.EVENT_PINNED_ROW_DATA_CHANGED = 'pinnedRowDataChanged';
    /** Range selection has changed */
    Events.EVENT_RANGE_SELECTION_CHANGED = 'rangeSelectionChanged';
    /** Chart was created */
    Events.EVENT_CHART_CREATED = 'chartCreated';
    /** Chart Range selection has changed */
    Events.EVENT_CHART_RANGE_SELECTION_CHANGED = 'chartRangeSelectionChanged';
    /** Chart Options have changed */
    Events.EVENT_CHART_OPTIONS_CHANGED = 'chartOptionsChanged';
    /** Chart was destroyed */
    Events.EVENT_CHART_DESTROYED = 'chartDestroyed';
    /** For when the tool panel is shown / hidden */
    Events.EVENT_TOOL_PANEL_VISIBLE_CHANGED = 'toolPanelVisibleChanged';
    Events.EVENT_COLUMN_PANEL_ITEM_DRAG_START = 'columnPanelItemDragStart';
    Events.EVENT_COLUMN_PANEL_ITEM_DRAG_END = 'columnPanelItemDragEnd';
    /** Model was updated - grid updates the drawn rows when this happens */
    Events.EVENT_MODEL_UPDATED = 'modelUpdated';
    Events.EVENT_PASTE_START = 'pasteStart';
    Events.EVENT_PASTE_END = 'pasteEnd';
    Events.EVENT_FILL_START = 'fillStart';
    Events.EVENT_FILL_END = 'fillEnd';
    Events.EVENT_CELL_CLICKED = 'cellClicked';
    Events.EVENT_CELL_DOUBLE_CLICKED = 'cellDoubleClicked';
    Events.EVENT_CELL_MOUSE_DOWN = 'cellMouseDown';
    Events.EVENT_CELL_CONTEXT_MENU = 'cellContextMenu';
    Events.EVENT_CELL_VALUE_CHANGED = 'cellValueChanged';
    Events.EVENT_ROW_VALUE_CHANGED = 'rowValueChanged';
    Events.EVENT_CELL_FOCUSED = 'cellFocused';
    Events.EVENT_ROW_SELECTED = 'rowSelected';
    Events.EVENT_SELECTION_CHANGED = 'selectionChanged';
    Events.EVENT_CELL_KEY_DOWN = 'cellKeyDown';
    Events.EVENT_CELL_KEY_PRESS = 'cellKeyPress';
    Events.EVENT_CELL_MOUSE_OVER = 'cellMouseOver';
    Events.EVENT_CELL_MOUSE_OUT = 'cellMouseOut';
    /** 2 events for filtering. The grid LISTENS for filterChanged and afterFilterChanged */
    Events.EVENT_FILTER_CHANGED = 'filterChanged';
    /** Filter was change but not applied. Only useful if apply buttons are used in filters. */
    Events.EVENT_FILTER_MODIFIED = 'filterModified';
    Events.EVENT_FILTER_OPENED = 'filterOpened';
    Events.EVENT_SORT_CHANGED = 'sortChanged';
    /** A row was removed from the dom, for any reason. Use to clean up resources (if any) used by the row. */
    Events.EVENT_VIRTUAL_ROW_REMOVED = 'virtualRowRemoved';
    Events.EVENT_ROW_CLICKED = 'rowClicked';
    Events.EVENT_ROW_DOUBLE_CLICKED = 'rowDoubleClicked';
    /** Gets called once after the grid has finished initialising. */
    Events.EVENT_GRID_READY = 'gridReady';
    /** Width of height of the main grid div has changed. Grid listens for this and does layout of grid if it's
     * changed, so always filling the space it was given. */
    Events.EVENT_GRID_SIZE_CHANGED = 'gridSizeChanged';
    /** The indexes of the rows rendered has changed, eg user has scrolled to a new vertical position. */
    Events.EVENT_VIEWPORT_CHANGED = 'viewportChanged';
    /* The width of the scrollbar has been calculated */
    Events.EVENT_SCROLLBAR_WIDTH_CHANGED = 'scrollbarWidthChanged';
    /** Rows were rendered for the first time (ie on async data load). */
    Events.EVENT_FIRST_DATA_RENDERED = 'firstDataRendered';
    /** A column drag has started, either resizing a column or moving a column. */
    Events.EVENT_DRAG_STARTED = 'dragStarted';
    /** A column drag has stopped */
    Events.EVENT_DRAG_STOPPED = 'dragStopped';
    Events.EVENT_CHECKBOX_CHANGED = 'checkboxChanged';
    Events.EVENT_ROW_EDITING_STARTED = 'rowEditingStarted';
    Events.EVENT_ROW_EDITING_STOPPED = 'rowEditingStopped';
    Events.EVENT_CELL_EDITING_STARTED = 'cellEditingStarted';
    Events.EVENT_CELL_EDITING_STOPPED = 'cellEditingStopped';
    /** Main body of grid has scrolled, either horizontally or vertically */
    Events.EVENT_BODY_SCROLL = 'bodyScroll';
    /** Main body of the grid has stopped scrolling, either horizontally or vertically */
    Events.EVENT_BODY_SCROLL_END = 'bodyScrollEnd';
    Events.EVENT_HEIGHT_SCALE_CHANGED = 'heightScaleChanged';
    /** The displayed page for pagination has changed. For example the data was filtered or sorted,
     * or the user has moved to a different page. */
    Events.EVENT_PAGINATION_CHANGED = 'paginationChanged';
    /** Only used by React, Angular 2+, Web Components and VueJS AG Grid components
     * (not used if doing plain JavaScript or Angular 1.x). If the grid receives changes due
     * to bound properties, this event fires after the grid has finished processing the change. */
    Events.EVENT_COMPONENT_STATE_CHANGED = 'componentStateChanged';
    /*****************************  INTERNAL EVENTS: START ******************************************* */
    /** Please remember to add to ComponentUtil.EXCLUDED_INTERNAL_EVENTS to not have these events exposed to framework components. */
    /** All items from here down are used internally by the grid, not intended for external use. */
    // not documented, either experimental, or we just don't want users using an depending on them
    Events.EVENT_BODY_HEIGHT_CHANGED = 'bodyHeightChanged';
    Events.EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED = 'displayedColumnsWidthChanged';
    Events.EVENT_SCROLL_VISIBILITY_CHANGED = 'scrollVisibilityChanged';
    Events.EVENT_COLUMN_HOVER_CHANGED = 'columnHoverChanged';
    Events.EVENT_FLASH_CELLS = 'flashCells';
    Events.EVENT_PAGINATION_PIXEL_OFFSET_CHANGED = 'paginationPixelOffsetChanged';
    Events.EVENT_DISPLAYED_ROWS_CHANGED = 'displayedRowsChanged';
    Events.EVENT_LEFT_PINNED_WIDTH_CHANGED = 'leftPinnedWidthChanged';
    Events.EVENT_RIGHT_PINNED_WIDTH_CHANGED = 'rightPinnedWidthChanged';
    Events.EVENT_ROW_CONTAINER_HEIGHT_CHANGED = 'rowContainerHeightChanged';
    Events.EVENT_ROW_DRAG_ENTER = 'rowDragEnter';
    Events.EVENT_ROW_DRAG_MOVE = 'rowDragMove';
    Events.EVENT_ROW_DRAG_LEAVE = 'rowDragLeave';
    Events.EVENT_ROW_DRAG_END = 'rowDragEnd';
    // primarily for charts
    Events.EVENT_POPUP_TO_FRONT = 'popupToFront';
    // these are used for server side group and agg - only used by CS with Viewport Row Model - intention is
    // to design these better around server side functions and then release to general public when fully working with
    // all the row models.
    Events.EVENT_COLUMN_ROW_GROUP_CHANGE_REQUEST = 'columnRowGroupChangeRequest';
    Events.EVENT_COLUMN_PIVOT_CHANGE_REQUEST = 'columnPivotChangeRequest';
    Events.EVENT_COLUMN_VALUE_CHANGE_REQUEST = 'columnValueChangeRequest';
    Events.EVENT_COLUMN_AGG_FUNC_CHANGE_REQUEST = 'columnAggFuncChangeRequest';
    Events.EVENT_KEYBOARD_FOCUS = 'keyboardFocus';
    Events.EVENT_MOUSE_FOCUS = 'mouseFocus';
    Events.EVENT_STORE_UPDATED = 'storeUpdated';
    return Events;
}());



/***/ }),

/***/ "23cb":
/***/ (function(module, exports, __webpack_require__) {

var toIntegerOrInfinity = __webpack_require__("5926");

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
module.exports = function (index, length) {
  var integer = toIntegerOrInfinity(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),

/***/ "23e7":
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__("da84");
var getOwnPropertyDescriptor = __webpack_require__("06cf").f;
var createNonEnumerableProperty = __webpack_require__("9112");
var redefine = __webpack_require__("6eeb");
var setGlobal = __webpack_require__("ce4e");
var copyConstructorProperties = __webpack_require__("e893");
var isForced = __webpack_require__("94ca");

/*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
  options.name        - the .name of the function if it does not match the key
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global;
  } else if (STATIC) {
    target = global[TARGET] || setGlobal(TARGET, {});
  } else {
    target = (global[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.noTargetGet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty === typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(sourceProperty, 'sham', true);
    }
    // extend global
    redefine(target, key, sourceProperty, options);
  }
};


/***/ }),

/***/ "241c":
/***/ (function(module, exports, __webpack_require__) {

var internalObjectKeys = __webpack_require__("ca84");
var enumBugKeys = __webpack_require__("7839");

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ "255a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return DragSourceType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return VerticalDirection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return HorizontalDirection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DragAndDropService; });
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("0e94");
/* harmony import */ var _utils_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("781c");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("348a");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("a74a");
/* harmony import */ var _utils_browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("b8d2");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("6352");
/* harmony import */ var _utils_function__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("e900");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};









var DragSourceType;
(function (DragSourceType) {
    DragSourceType[DragSourceType["ToolPanel"] = 0] = "ToolPanel";
    DragSourceType[DragSourceType["HeaderCell"] = 1] = "HeaderCell";
    DragSourceType[DragSourceType["RowDrag"] = 2] = "RowDrag";
    DragSourceType[DragSourceType["ChartPanel"] = 3] = "ChartPanel";
})(DragSourceType || (DragSourceType = {}));
var VerticalDirection;
(function (VerticalDirection) {
    VerticalDirection[VerticalDirection["Up"] = 0] = "Up";
    VerticalDirection[VerticalDirection["Down"] = 1] = "Down";
})(VerticalDirection || (VerticalDirection = {}));
var HorizontalDirection;
(function (HorizontalDirection) {
    HorizontalDirection[HorizontalDirection["Left"] = 0] = "Left";
    HorizontalDirection[HorizontalDirection["Right"] = 1] = "Right";
})(HorizontalDirection || (HorizontalDirection = {}));
var DragAndDropService = /** @class */ (function (_super) {
    __extends(DragAndDropService, _super);
    function DragAndDropService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dragSourceAndParamsList = [];
        _this.dropTargets = [];
        return _this;
    }
    DragAndDropService_1 = DragAndDropService;
    DragAndDropService.prototype.init = function () {
        this.ePinnedIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMovePin', this.gridOptionsWrapper, null);
        this.eHideIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMoveHide', this.gridOptionsWrapper, null);
        this.eMoveIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMoveMove', this.gridOptionsWrapper, null);
        this.eLeftIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMoveLeft', this.gridOptionsWrapper, null);
        this.eRightIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMoveRight', this.gridOptionsWrapper, null);
        this.eGroupIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMoveGroup', this.gridOptionsWrapper, null);
        this.eAggregateIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMoveValue', this.gridOptionsWrapper, null);
        this.ePivotIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnMovePivot', this.gridOptionsWrapper, null);
        this.eDropNotAllowedIcon = Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('dropNotAllowed', this.gridOptionsWrapper, null);
    };
    DragAndDropService.prototype.addDragSource = function (dragSource, allowTouch) {
        if (allowTouch === void 0) { allowTouch = false; }
        var params = {
            eElement: dragSource.eElement,
            dragStartPixels: dragSource.dragStartPixels,
            onDragStart: this.onDragStart.bind(this, dragSource),
            onDragStop: this.onDragStop.bind(this),
            onDragging: this.onDragging.bind(this)
        };
        this.dragSourceAndParamsList.push({ params: params, dragSource: dragSource });
        this.dragService.addDragSource(params, allowTouch);
    };
    DragAndDropService.prototype.removeDragSource = function (dragSource) {
        var sourceAndParams = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_5__["find"])(this.dragSourceAndParamsList, function (item) { return item.dragSource === dragSource; });
        if (sourceAndParams) {
            this.dragService.removeDragSource(sourceAndParams.params);
            Object(_utils_array__WEBPACK_IMPORTED_MODULE_4__["removeFromArray"])(this.dragSourceAndParamsList, sourceAndParams);
        }
    };
    DragAndDropService.prototype.clearDragSourceParamsList = function () {
        var _this = this;
        this.dragSourceAndParamsList.forEach(function (sourceAndParams) { return _this.dragService.removeDragSource(sourceAndParams.params); });
        this.dragSourceAndParamsList.length = 0;
    };
    DragAndDropService.prototype.nudge = function () {
        if (this.dragging) {
            this.onDragging(this.eventLastTime, true);
        }
    };
    DragAndDropService.prototype.onDragStart = function (dragSource, mouseEvent) {
        this.dragging = true;
        this.dragSource = dragSource;
        this.eventLastTime = mouseEvent;
        this.dragItem = this.dragSource.getDragItem();
        this.lastDropTarget = this.dragSource.dragSourceDropTarget;
        if (this.dragSource.onDragStarted) {
            this.dragSource.onDragStarted();
        }
        this.createGhost();
    };
    DragAndDropService.prototype.onDragStop = function (mouseEvent) {
        this.eventLastTime = null;
        this.dragging = false;
        if (this.dragSource.onDragStopped) {
            this.dragSource.onDragStopped();
        }
        if (this.lastDropTarget && this.lastDropTarget.onDragStop) {
            var draggingEvent = this.createDropTargetEvent(this.lastDropTarget, mouseEvent, null, null, false);
            this.lastDropTarget.onDragStop(draggingEvent);
        }
        this.lastDropTarget = null;
        this.dragItem = null;
        this.removeGhost();
    };
    DragAndDropService.prototype.onDragging = function (mouseEvent, fromNudge) {
        var _this = this;
        var hDirection = this.getHorizontalDirection(mouseEvent);
        var vDirection = this.getVerticalDirection(mouseEvent);
        this.eventLastTime = mouseEvent;
        this.positionGhost(mouseEvent);
        // check if mouseEvent intersects with any of the drop targets
        var validDropTargets = this.dropTargets.filter(function (target) { return _this.isMouseOnDropTarget(mouseEvent, target); });
        var len = validDropTargets.length;
        var dropTarget = null;
        if (len > 0) {
            dropTarget = len === 1
                ? validDropTargets[0]
                // the current mouse position could intersect with more than 1 element
                // if they are nested. In that case we need to get the most specific
                // container, which is the one that does not contain any other targets.
                : validDropTargets.reduce(function (prevTarget, currTarget) {
                    if (!prevTarget) {
                        return currTarget;
                    }
                    var prevContainer = prevTarget.getContainer();
                    var currContainer = currTarget.getContainer();
                    if (prevContainer.contains(currContainer)) {
                        return currTarget;
                    }
                    return prevTarget;
                });
        }
        if (dropTarget !== this.lastDropTarget) {
            this.leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge);
            this.enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            this.lastDropTarget = dropTarget;
        }
        else if (dropTarget && dropTarget.onDragging) {
            var draggingEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            dropTarget.onDragging(draggingEvent);
        }
    };
    DragAndDropService.prototype.enterDragTargetIfExists = function (dropTarget, mouseEvent, hDirection, vDirection, fromNudge) {
        if (!dropTarget) {
            return;
        }
        if (dropTarget.onDragEnter) {
            var dragEnterEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            dropTarget.onDragEnter(dragEnterEvent);
        }
        this.setGhostIcon(dropTarget.getIconName ? dropTarget.getIconName() : null);
    };
    DragAndDropService.prototype.leaveLastTargetIfExists = function (mouseEvent, hDirection, vDirection, fromNudge) {
        if (!this.lastDropTarget) {
            return;
        }
        if (this.lastDropTarget.onDragLeave) {
            var dragLeaveEvent = this.createDropTargetEvent(this.lastDropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            this.lastDropTarget.onDragLeave(dragLeaveEvent);
        }
        this.setGhostIcon(null);
    };
    DragAndDropService.prototype.getAllContainersFromDropTarget = function (dropTarget) {
        var secondaryContainers = dropTarget.getSecondaryContainers ? dropTarget.getSecondaryContainers() : null;
        var containers = [[dropTarget.getContainer()]];
        return secondaryContainers ? containers.concat(secondaryContainers) : containers;
    };
    DragAndDropService.prototype.allContainersIntersect = function (mouseEvent, containers) {
        for (var _i = 0, containers_1 = containers; _i < containers_1.length; _i++) {
            var container = containers_1[_i];
            var rect = container.getBoundingClientRect();
            // if element is not visible, then width and height are zero
            if (rect.width === 0 || rect.height === 0) {
                return false;
            }
            var horizontalFit = mouseEvent.clientX >= rect.left && mouseEvent.clientX < rect.right;
            var verticalFit = mouseEvent.clientY >= rect.top && mouseEvent.clientY < rect.bottom;
            if (!horizontalFit || !verticalFit) {
                return false;
            }
        }
        return true;
    };
    // checks if the mouse is on the drop target. it checks eContainer and eSecondaryContainers
    DragAndDropService.prototype.isMouseOnDropTarget = function (mouseEvent, dropTarget) {
        var allContainersFromDropTarget = this.getAllContainersFromDropTarget(dropTarget);
        var mouseOverTarget = false;
        for (var _i = 0, allContainersFromDropTarget_1 = allContainersFromDropTarget; _i < allContainersFromDropTarget_1.length; _i++) {
            var currentContainers = allContainersFromDropTarget_1[_i];
            if (this.allContainersIntersect(mouseEvent, currentContainers)) {
                mouseOverTarget = true;
                break;
            }
        }
        return mouseOverTarget && dropTarget.isInterestedIn(this.dragSource.type);
    };
    DragAndDropService.prototype.addDropTarget = function (dropTarget) {
        this.dropTargets.push(dropTarget);
    };
    DragAndDropService.prototype.removeDropTarget = function (dropTarget) {
        this.dropTargets = this.dropTargets.filter(function (target) { return target.getContainer() !== dropTarget.getContainer(); });
    };
    DragAndDropService.prototype.hasExternalDropZones = function () {
        return this.dropTargets.some(function (zones) { return zones.external; });
    };
    DragAndDropService.prototype.findExternalZone = function (params) {
        var externalTargets = this.dropTargets.filter(function (target) { return target.external; });
        return Object(_utils_generic__WEBPACK_IMPORTED_MODULE_5__["find"])(externalTargets, function (zone) { return zone.getContainer() === params.getContainer(); });
    };
    DragAndDropService.prototype.getHorizontalDirection = function (event) {
        var clientX = this.eventLastTime && this.eventLastTime.clientX;
        var eClientX = event.clientX;
        if (clientX === eClientX) {
            return null;
        }
        return clientX > eClientX ? HorizontalDirection.Left : HorizontalDirection.Right;
    };
    DragAndDropService.prototype.getVerticalDirection = function (event) {
        var clientY = this.eventLastTime && this.eventLastTime.clientY;
        var eClientY = event.clientY;
        if (clientY === eClientY) {
            return null;
        }
        return clientY > eClientY ? VerticalDirection.Up : VerticalDirection.Down;
    };
    DragAndDropService.prototype.createDropTargetEvent = function (dropTarget, event, hDirection, vDirection, fromNudge) {
        // localise x and y to the target
        var dropZoneTarget = dropTarget.getContainer();
        var rect = dropZoneTarget.getBoundingClientRect();
        var _a = this, api = _a.gridApi, columnApi = _a.columnApi, dragItem = _a.dragItem, dragSource = _a.dragSource;
        var x = event.clientX - rect.left;
        var y = event.clientY - rect.top;
        return { event: event, x: x, y: y, vDirection: vDirection, hDirection: hDirection, dragSource: dragSource, fromNudge: fromNudge, dragItem: dragItem, api: api, columnApi: columnApi, dropZoneTarget: dropZoneTarget };
    };
    DragAndDropService.prototype.positionGhost = function (event) {
        var ghost = this.eGhost;
        if (!ghost) {
            return;
        }
        var ghostRect = ghost.getBoundingClientRect();
        var ghostHeight = ghostRect.height;
        // for some reason, without the '-2', it still overlapped by 1 or 2 pixels, which
        // then brought in scrollbars to the browser. no idea why, but putting in -2 here
        // works around it which is good enough for me.
        var browserWidth = Object(_utils_browser__WEBPACK_IMPORTED_MODULE_6__["getBodyWidth"])() - 2;
        var browserHeight = Object(_utils_browser__WEBPACK_IMPORTED_MODULE_6__["getBodyHeight"])() - 2;
        var top = event.pageY - (ghostHeight / 2);
        var left = event.pageX - 10;
        var usrDocument = this.gridOptionsWrapper.getDocument();
        var windowScrollY = window.pageYOffset || usrDocument.documentElement.scrollTop;
        var windowScrollX = window.pageXOffset || usrDocument.documentElement.scrollLeft;
        // check ghost is not positioned outside of the browser
        if (browserWidth > 0 && ((left + ghost.clientWidth) > (browserWidth + windowScrollX))) {
            left = browserWidth + windowScrollX - ghost.clientWidth;
        }
        if (left < 0) {
            left = 0;
        }
        if (browserHeight > 0 && ((top + ghost.clientHeight) > (browserHeight + windowScrollY))) {
            top = browserHeight + windowScrollY - ghost.clientHeight;
        }
        if (top < 0) {
            top = 0;
        }
        ghost.style.left = left + "px";
        ghost.style.top = top + "px";
    };
    DragAndDropService.prototype.removeGhost = function () {
        if (this.eGhost && this.eGhostParent) {
            this.eGhostParent.removeChild(this.eGhost);
        }
        this.eGhost = null;
    };
    DragAndDropService.prototype.createGhost = function () {
        this.eGhost = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_7__["loadTemplate"])(DragAndDropService_1.GHOST_TEMPLATE);
        var theme = this.environment.getTheme().theme;
        if (theme) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_7__["addCssClass"])(this.eGhost, theme);
        }
        this.eGhostIcon = this.eGhost.querySelector('.ag-dnd-ghost-icon');
        this.setGhostIcon(null);
        var eText = this.eGhost.querySelector('.ag-dnd-ghost-label');
        var dragItemName = this.dragSource.dragItemName;
        if (Object(_utils_function__WEBPACK_IMPORTED_MODULE_8__["isFunction"])(dragItemName)) {
            dragItemName = dragItemName();
        }
        eText.innerHTML = Object(_utils_string__WEBPACK_IMPORTED_MODULE_2__["escapeString"])(dragItemName) || '';
        this.eGhost.style.height = '25px';
        this.eGhost.style.top = '20px';
        this.eGhost.style.left = '20px';
        var usrDocument = this.gridOptionsWrapper.getDocument();
        var targetEl = usrDocument.fullscreenElement || usrDocument.querySelector('body');
        this.eGhostParent = targetEl;
        if (!this.eGhostParent) {
            console.warn('AG Grid: could not find document body, it is needed for dragging columns');
        }
        else {
            this.eGhostParent.appendChild(this.eGhost);
        }
    };
    DragAndDropService.prototype.setGhostIcon = function (iconName, shake) {
        if (shake === void 0) { shake = false; }
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_7__["clearElement"])(this.eGhostIcon);
        var eIcon = null;
        if (!iconName) {
            iconName = this.dragSource.defaultIconName || DragAndDropService_1.ICON_NOT_ALLOWED;
        }
        switch (iconName) {
            case DragAndDropService_1.ICON_PINNED:
                eIcon = this.ePinnedIcon;
                break;
            case DragAndDropService_1.ICON_MOVE:
                eIcon = this.eMoveIcon;
                break;
            case DragAndDropService_1.ICON_LEFT:
                eIcon = this.eLeftIcon;
                break;
            case DragAndDropService_1.ICON_RIGHT:
                eIcon = this.eRightIcon;
                break;
            case DragAndDropService_1.ICON_GROUP:
                eIcon = this.eGroupIcon;
                break;
            case DragAndDropService_1.ICON_AGGREGATE:
                eIcon = this.eAggregateIcon;
                break;
            case DragAndDropService_1.ICON_PIVOT:
                eIcon = this.ePivotIcon;
                break;
            case DragAndDropService_1.ICON_NOT_ALLOWED:
                eIcon = this.eDropNotAllowedIcon;
                break;
            case DragAndDropService_1.ICON_HIDE:
                eIcon = this.eHideIcon;
                break;
        }
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_7__["addOrRemoveCssClass"])(this.eGhostIcon, 'ag-shake-left-to-right', shake);
        if (eIcon === this.eHideIcon && this.gridOptionsWrapper.isSuppressDragLeaveHidesColumns()) {
            return;
        }
        if (eIcon) {
            this.eGhostIcon.appendChild(eIcon);
        }
    };
    var DragAndDropService_1;
    DragAndDropService.ICON_PINNED = 'pinned';
    DragAndDropService.ICON_MOVE = 'move';
    DragAndDropService.ICON_LEFT = 'left';
    DragAndDropService.ICON_RIGHT = 'right';
    DragAndDropService.ICON_GROUP = 'group';
    DragAndDropService.ICON_AGGREGATE = 'aggregate';
    DragAndDropService.ICON_PIVOT = 'pivot';
    DragAndDropService.ICON_NOT_ALLOWED = 'notAllowed';
    DragAndDropService.ICON_HIDE = 'hide';
    DragAndDropService.GHOST_TEMPLATE = "<div class=\"ag-dnd-ghost ag-unselectable\">\n            <span class=\"ag-dnd-ghost-icon ag-shake-left-to-right\"></span>\n            <div class=\"ag-dnd-ghost-label\"></div>\n        </div>";
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('dragService')
    ], DragAndDropService.prototype, "dragService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('environment')
    ], DragAndDropService.prototype, "environment", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('columnApi')
    ], DragAndDropService.prototype, "columnApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('gridApi')
    ], DragAndDropService.prototype, "gridApi", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], DragAndDropService.prototype, "init", null);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PreDestroy */ "g"]
    ], DragAndDropService.prototype, "clearDragSourceParamsList", null);
    DragAndDropService = DragAndDropService_1 = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Bean */ "b"])('dragAndDropService')
    ], DragAndDropService);
    return DragAndDropService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_0__[/* BeanStub */ "a"]));



/***/ }),

/***/ "2b8e":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ grid_Grid; });

// UNUSED EXPORTS: GridCoreCreator

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridOptionsWrapper.js
var gridOptionsWrapper = __webpack_require__("648b");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/selectionService.js
var selectionService = __webpack_require__("fb7e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/columnApi.js
var columnApi = __webpack_require__("d206");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/columnModel.js
var columnModel = __webpack_require__("f76c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/rowRenderer.js
var rowRenderer = __webpack_require__("8eef");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/gridHeaderComp.js
var gridHeaderComp = __webpack_require__("613b");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/filterManager.js
var filterManager = __webpack_require__("cbde");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/valueService/valueService.js
var valueService = __webpack_require__("a7ec");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/eventService.js
var eventService = __webpack_require__("896f");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/gridBodyComp.js
var gridBodyComp = __webpack_require__("db4b");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridApi.js
var gridApi = __webpack_require__("634e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/columnFactory.js + 1 modules
var columnFactory = __webpack_require__("860a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/displayedGroupCreator.js
var displayedGroupCreator = __webpack_require__("1071");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/valueService/expressionService.js
var expressionService = __webpack_require__("843e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/templateService.js
var templateService = __webpack_require__("a4ec");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/popupService.js
var popupService = __webpack_require__("c7f0");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/logger.js
var es6_logger = __webpack_require__("98cb");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/columnUtils.js
var columnUtils = __webpack_require__("c98a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/autoWidthCalculator.js
var autoWidthCalculator = __webpack_require__("4c9d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/common/horizontalResizeService.js
var horizontalResizeService = __webpack_require__("7512");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context_context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridComp/gridComp.js
var gridComp_gridComp = __webpack_require__("f4f1");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/dragAndDrop/dragAndDropService.js
var dragAndDropService = __webpack_require__("255a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/dragAndDrop/dragService.js
var dragService = __webpack_require__("95b8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/sortController.js
var sortController = __webpack_require__("735a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/focusService.js
var focusService = __webpack_require__("0b0e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/mouseEventService.js
var mouseEventService = __webpack_require__("fe3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/cellNavigationService.js
var cellNavigationService = __webpack_require__("ec31");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/events.js
var events = __webpack_require__("ad5d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/valueFormatterService.js
var valueFormatterService = __webpack_require__("0450");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agCheckbox.js
var agCheckbox = __webpack_require__("b678");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agRadioButton.js
var agRadioButton = __webpack_require__("8783");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/vanillaFrameworkOverrides.js
var vanillaFrameworkOverrides = __webpack_require__("0632");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/scrollVisibleService.js
var scrollVisibleService = __webpack_require__("036c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/styling/stylingService.js
var stylingService = __webpack_require__("d28c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/beanStub.js
var beanStub = __webpack_require__("bc71");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/columnHoverService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var columnHoverService_ColumnHoverService = /** @class */ (function (_super) {
    __extends(ColumnHoverService, _super);
    function ColumnHoverService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ColumnHoverService.prototype.setMouseOver = function (columns) {
        this.selectedColumns = columns;
        var event = {
            type: events["a" /* Events */].EVENT_COLUMN_HOVER_CHANGED,
            api: this.gridApi,
            columnApi: this.columnApi
        };
        this.eventService.dispatchEvent(event);
    };
    ColumnHoverService.prototype.clearMouseOver = function () {
        this.selectedColumns = null;
        var event = {
            type: events["a" /* Events */].EVENT_COLUMN_HOVER_CHANGED,
            api: this.gridApi,
            columnApi: this.columnApi
        };
        this.eventService.dispatchEvent(event);
    };
    ColumnHoverService.prototype.isHovered = function (column) {
        return !!this.selectedColumns && this.selectedColumns.indexOf(column) >= 0;
    };
    __decorate([
        Object(context_context["a" /* Autowired */])('columnApi')
    ], ColumnHoverService.prototype, "columnApi", void 0);
    __decorate([
        Object(context_context["a" /* Autowired */])('gridApi')
    ], ColumnHoverService.prototype, "gridApi", void 0);
    ColumnHoverService = __decorate([
        Object(context_context["b" /* Bean */])('columnHoverService')
    ], ColumnHoverService);
    return ColumnHoverService;
}(beanStub["a" /* BeanStub */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/columnAnimationService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var columnAnimationService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var columnAnimationService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var columnAnimationService_ColumnAnimationService = /** @class */ (function (_super) {
    columnAnimationService_extends(ColumnAnimationService, _super);
    function ColumnAnimationService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.executeNextFuncs = [];
        _this.executeLaterFuncs = [];
        _this.active = false;
        _this.animationThreadCount = 0;
        return _this;
    }
    ColumnAnimationService.prototype.postConstruct = function () {
        var _this = this;
        this.ctrlsService.whenReady(function (p) { return _this.gridBodyCtrl = p.gridBodyCtrl; });
    };
    ColumnAnimationService.prototype.isActive = function () {
        return this.active;
    };
    ColumnAnimationService.prototype.start = function () {
        if (this.active) {
            return;
        }
        if (this.gridOptionsWrapper.isSuppressColumnMoveAnimation()) {
            return;
        }
        // if doing RTL, we don't animate open / close as due to how the pixels are inverted,
        // the animation moves all the row the the right rather than to the left (ie it's the static
        // columns that actually get their coordinates updated)
        if (this.gridOptionsWrapper.isEnableRtl()) {
            return;
        }
        this.ensureAnimationCssClassPresent();
        this.active = true;
    };
    ColumnAnimationService.prototype.finish = function () {
        if (!this.active) {
            return;
        }
        this.flush();
        this.active = false;
    };
    ColumnAnimationService.prototype.executeNextVMTurn = function (func) {
        if (this.active) {
            this.executeNextFuncs.push(func);
        }
        else {
            func();
        }
    };
    ColumnAnimationService.prototype.executeLaterVMTurn = function (func) {
        if (this.active) {
            this.executeLaterFuncs.push(func);
        }
        else {
            func();
        }
    };
    ColumnAnimationService.prototype.ensureAnimationCssClassPresent = function () {
        var _this = this;
        // up the count, so we can tell if someone else has updated the count
        // by the time the 'wait' func executes
        this.animationThreadCount++;
        var animationThreadCountCopy = this.animationThreadCount;
        this.gridBodyCtrl.setColumnMovingCss(true);
        this.executeLaterFuncs.push(function () {
            // only remove the class if this thread was the last one to update it
            if (_this.animationThreadCount === animationThreadCountCopy) {
                _this.gridBodyCtrl.setColumnMovingCss(false);
            }
        });
    };
    ColumnAnimationService.prototype.flush = function () {
        var nowFuncs = this.executeNextFuncs;
        this.executeNextFuncs = [];
        var waitFuncs = this.executeLaterFuncs;
        this.executeLaterFuncs = [];
        if (nowFuncs.length === 0 && waitFuncs.length === 0) {
            return;
        }
        window.setTimeout(function () { return nowFuncs.forEach(function (func) { return func(); }); }, 0);
        window.setTimeout(function () { return waitFuncs.forEach(function (func) { return func(); }); }, 300);
    };
    columnAnimationService_decorate([
        Object(context_context["a" /* Autowired */])('ctrlsService')
    ], ColumnAnimationService.prototype, "ctrlsService", void 0);
    columnAnimationService_decorate([
        context_context["e" /* PostConstruct */]
    ], ColumnAnimationService.prototype, "postConstruct", null);
    ColumnAnimationService = columnAnimationService_decorate([
        Object(context_context["b" /* Bean */])('columnAnimationService')
    ], ColumnAnimationService);
    return ColumnAnimationService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/column.js
var entities_column = __webpack_require__("70d4");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/constants/constants.js
var constants = __webpack_require__("59ec");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/object.js
var object = __webpack_require__("562d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/generic.js
var generic = __webpack_require__("a74a");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/autoGroupColService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var autoGroupColService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var autoGroupColService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var autoGroupColService_AutoGroupColService = /** @class */ (function (_super) {
    autoGroupColService_extends(AutoGroupColService, _super);
    function AutoGroupColService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoGroupColService_1 = AutoGroupColService;
    AutoGroupColService.prototype.createAutoGroupColumns = function (rowGroupColumns) {
        var _this = this;
        var groupAutoColumns = [];
        var doingTreeData = this.gridOptionsWrapper.isTreeData();
        var doingMultiAutoColumn = this.gridOptionsWrapper.isGroupMultiAutoColumn();
        if (doingTreeData && doingMultiAutoColumn) {
            console.warn('AG Grid: you cannot mix groupMultiAutoColumn with treeData, only one column can be used to display groups when doing tree data');
            doingMultiAutoColumn = false;
        }
        // if doing groupMultiAutoColumn, then we call the method multiple times, once
        // for each column we are grouping by
        if (doingMultiAutoColumn) {
            rowGroupColumns.forEach(function (rowGroupCol, index) {
                groupAutoColumns.push(_this.createOneAutoGroupColumn(rowGroupCol, index));
            });
        }
        else {
            groupAutoColumns.push(this.createOneAutoGroupColumn());
        }
        return groupAutoColumns;
    };
    // rowGroupCol and index are missing if groupMultiAutoColumn=false
    AutoGroupColService.prototype.createOneAutoGroupColumn = function (rowGroupCol, index) {
        // if one provided by user, use it, otherwise create one
        var defaultAutoColDef = this.generateDefaultColDef(rowGroupCol);
        // if doing multi, set the field
        var colId;
        if (rowGroupCol) {
            colId = constants["a" /* Constants */].GROUP_AUTO_COLUMN_ID + "-" + rowGroupCol.getId();
        }
        else {
            colId = AutoGroupColService_1.GROUP_AUTO_COLUMN_BUNDLE_ID;
        }
        var userAutoColDef = this.gridOptionsWrapper.getAutoGroupColumnDef();
        Object(object["mergeDeep"])(defaultAutoColDef, userAutoColDef);
        defaultAutoColDef = this.columnFactory.mergeColDefs(defaultAutoColDef);
        defaultAutoColDef.colId = colId;
        // For tree data the filter is always allowed
        if (!this.gridOptionsWrapper.isTreeData()) {
            // we would only allow filter if the user has provided field or value getter. otherwise the filter
            // would not be able to work.
            var noFieldOrValueGetter = Object(generic["missing"])(defaultAutoColDef.field) && Object(generic["missing"])(defaultAutoColDef.valueGetter) && Object(generic["missing"])(defaultAutoColDef.filterValueGetter);
            if (noFieldOrValueGetter) {
                defaultAutoColDef.filter = false;
            }
        }
        // if showing many cols, we don't want to show more than one with a checkbox for selection
        if (index && index > 0) {
            defaultAutoColDef.headerCheckboxSelection = false;
        }
        var newCol = new entities_column["a" /* Column */](defaultAutoColDef, null, colId, true);
        this.context.createBean(newCol);
        return newCol;
    };
    AutoGroupColService.prototype.generateDefaultColDef = function (rowGroupCol) {
        var userDef = this.gridOptionsWrapper.getAutoGroupColumnDef();
        var localeTextFunc = this.gridOptionsWrapper.getLocaleTextFunc();
        var res = {
            headerName: localeTextFunc('group', 'Group')
        };
        var userHasProvidedGroupCellRenderer = userDef &&
            (userDef.cellRenderer || userDef.cellRendererFramework || userDef.cellRendererSelector);
        // only add the default group cell renderer if user hasn't provided one
        if (!userHasProvidedGroupCellRenderer) {
            res.cellRenderer = 'agGroupCellRenderer';
        }
        // we never allow moving the group column
        // defaultAutoColDef.suppressMovable = true;
        if (rowGroupCol) {
            var colDef = rowGroupCol.getColDef();
            Object(object["assign"])(res, {
                // cellRendererParams.groupKey: colDefToCopy.field;
                headerName: this.columnModel.getDisplayNameForColumn(rowGroupCol, 'header'),
                headerValueGetter: colDef.headerValueGetter
            });
            if (colDef.cellRenderer) {
                Object(object["assign"])(res, {
                    cellRendererParams: {
                        innerRenderer: colDef.cellRenderer,
                        innerRendererParams: colDef.cellRendererParams
                    }
                });
            }
            res.showRowGroup = rowGroupCol.getColId();
        }
        else {
            res.showRowGroup = true;
        }
        return res;
    };
    var AutoGroupColService_1;
    AutoGroupColService.GROUP_AUTO_COLUMN_BUNDLE_ID = constants["a" /* Constants */].GROUP_AUTO_COLUMN_ID;
    autoGroupColService_decorate([
        Object(context_context["a" /* Autowired */])('columnModel')
    ], AutoGroupColService.prototype, "columnModel", void 0);
    autoGroupColService_decorate([
        Object(context_context["a" /* Autowired */])('columnFactory')
    ], AutoGroupColService.prototype, "columnFactory", void 0);
    AutoGroupColService = AutoGroupColService_1 = autoGroupColService_decorate([
        Object(context_context["b" /* Bean */])('autoGroupColService')
    ], AutoGroupColService);
    return AutoGroupColService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/pagination/paginationProxy.js
var paginationProxy = __webpack_require__("37c1");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/pagination/paginationAutoPageSizeService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var paginationAutoPageSizeService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var paginationAutoPageSizeService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var paginationAutoPageSizeService_PaginationAutoPageSizeService = /** @class */ (function (_super) {
    paginationAutoPageSizeService_extends(PaginationAutoPageSizeService, _super);
    function PaginationAutoPageSizeService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PaginationAutoPageSizeService.prototype.postConstruct = function () {
        var _this = this;
        this.ctrlsService.whenReady(function (p) {
            _this.centerRowContainerCon = p.centerRowContainerCtrl;
            _this.addManagedListener(_this.eventService, events["a" /* Events */].EVENT_BODY_HEIGHT_CHANGED, _this.onBodyHeightChanged.bind(_this));
            _this.addManagedListener(_this.eventService, events["a" /* Events */].EVENT_SCROLL_VISIBILITY_CHANGED, _this.onScrollVisibilityChanged.bind(_this));
            _this.checkPageSize();
        });
    };
    PaginationAutoPageSizeService.prototype.notActive = function () {
        return !this.gridOptionsWrapper.isPaginationAutoPageSize();
    };
    PaginationAutoPageSizeService.prototype.onScrollVisibilityChanged = function () {
        this.checkPageSize();
    };
    PaginationAutoPageSizeService.prototype.onBodyHeightChanged = function () {
        this.checkPageSize();
    };
    PaginationAutoPageSizeService.prototype.checkPageSize = function () {
        if (this.notActive()) {
            return;
        }
        var rowHeight = this.gridOptionsWrapper.getRowHeightAsNumber();
        var bodyHeight = this.centerRowContainerCon.getViewportSizeFeature().getBodyHeight();
        if (bodyHeight > 0) {
            var newPageSize = Math.floor(bodyHeight / rowHeight);
            this.gridOptionsWrapper.setProperty('paginationPageSize', newPageSize);
        }
    };
    paginationAutoPageSizeService_decorate([
        Object(context_context["a" /* Autowired */])('ctrlsService')
    ], PaginationAutoPageSizeService.prototype, "ctrlsService", void 0);
    paginationAutoPageSizeService_decorate([
        context_context["e" /* PostConstruct */]
    ], PaginationAutoPageSizeService.prototype, "postConstruct", null);
    PaginationAutoPageSizeService = paginationAutoPageSizeService_decorate([
        Object(context_context["b" /* Bean */])('paginationAutoPageSizeService')
    ], PaginationAutoPageSizeService);
    return PaginationAutoPageSizeService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/valueService/valueCache.js
var valueCache = __webpack_require__("acf8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/changedPath.js
var utils_changedPath = __webpack_require__("528f");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/valueService/changeDetectionService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var changeDetectionService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var changeDetectionService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var changeDetectionService_ChangeDetectionService = /** @class */ (function (_super) {
    changeDetectionService_extends(ChangeDetectionService, _super);
    function ChangeDetectionService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeDetectionService.prototype.init = function () {
        if (this.rowModel.getType() === constants["a" /* Constants */].ROW_MODEL_TYPE_CLIENT_SIDE) {
            this.clientSideRowModel = this.rowModel;
        }
        this.addManagedListener(this.eventService, events["a" /* Events */].EVENT_CELL_VALUE_CHANGED, this.onCellValueChanged.bind(this));
    };
    ChangeDetectionService.prototype.onCellValueChanged = function (event) {
        // Clipboard service manages its own change detection, so no need to do it here.
        // The clipboard manages its own as otherwise this would happen once for every cell
        // that got updated as part of a paste operation, so e.g. if 100 cells in a paste operation,
        // this doChangeDetection would get called 100 times (once for each cell), instead clipboard
        // service executes the logic we have here once (in essence batching up all cell changes
        // into one change detection).
        if (event.source === constants["a" /* Constants */].SOURCE_PASTE) {
            return;
        }
        this.doChangeDetection(event.node, event.column);
    };
    ChangeDetectionService.prototype.doChangeDetection = function (rowNode, column) {
        if (this.gridOptionsWrapper.isSuppressChangeDetection()) {
            return;
        }
        // step 1 of change detection is to update the aggregated values
        if (this.clientSideRowModel && !rowNode.isRowPinned()) {
            var onlyChangedColumns = this.gridOptionsWrapper.isAggregateOnlyChangedColumns();
            var changedPath = new utils_changedPath["a" /* ChangedPath */](onlyChangedColumns, this.clientSideRowModel.getRootNode());
            changedPath.addParentNode(rowNode.parent, [column]);
            this.clientSideRowModel.doAggregate(changedPath);
        }
        // step 2 of change detection is to refresh the cells
        this.rowRenderer.refreshCells();
    };
    changeDetectionService_decorate([
        Object(context_context["a" /* Autowired */])('rowModel')
    ], ChangeDetectionService.prototype, "rowModel", void 0);
    changeDetectionService_decorate([
        Object(context_context["a" /* Autowired */])('rowRenderer')
    ], ChangeDetectionService.prototype, "rowRenderer", void 0);
    changeDetectionService_decorate([
        context_context["e" /* PostConstruct */]
    ], ChangeDetectionService.prototype, "init", null);
    ChangeDetectionService = changeDetectionService_decorate([
        Object(context_context["b" /* Bean */])('changeDetectionService')
    ], ChangeDetectionService);
    return ChangeDetectionService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/alignedGridsService.js
var alignedGridsService = __webpack_require__("6deb");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/userComponentFactory.js + 1 modules
var userComponentFactory = __webpack_require__("2ebc");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/userComponentRegistry.js + 9 modules
var userComponentRegistry = __webpack_require__("3522");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/agComponentUtils.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var agComponentUtils_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var agComponentUtils_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var agComponentUtils_AgComponentUtils = /** @class */ (function (_super) {
    agComponentUtils_extends(AgComponentUtils, _super);
    function AgComponentUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AgComponentUtils.prototype.adaptFunction = function (propertyName, jsCompFunc) {
        var metadata = this.componentMetadataProvider.retrieve(propertyName);
        if (metadata && metadata.functionAdapter) {
            return metadata.functionAdapter(jsCompFunc);
        }
        return null;
    };
    AgComponentUtils.prototype.adaptCellRendererFunction = function (callback) {
        var Adapter = /** @class */ (function () {
            function Adapter() {
            }
            Adapter.prototype.refresh = function (params) {
                return false;
            };
            Adapter.prototype.getGui = function () {
                var callbackResult = callback(this.params);
                var type = typeof callbackResult;
                if (type === 'string' || type === 'number' || type === 'boolean') {
                    return Object(dom["loadTemplate"])('<span>' + callbackResult + '</span>');
                }
                if (callbackResult == null) {
                    return Object(dom["loadTemplate"])('<span></span>');
                }
                return callbackResult;
            };
            Adapter.prototype.init = function (params) {
                this.params = params;
            };
            return Adapter;
        }());
        return Adapter;
    };
    AgComponentUtils.prototype.doesImplementIComponent = function (candidate) {
        if (!candidate) {
            return false;
        }
        return candidate.prototype && 'getGui' in candidate.prototype;
    };
    agComponentUtils_decorate([
        Object(context_context["a" /* Autowired */])("componentMetadataProvider")
    ], AgComponentUtils.prototype, "componentMetadataProvider", void 0);
    AgComponentUtils = agComponentUtils_decorate([
        Object(context_context["b" /* Bean */])("agComponentUtils")
    ], AgComponentUtils);
    return AgComponentUtils;
}(beanStub["a" /* BeanStub */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/componentMetadataProvider.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var componentMetadataProvider_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var componentMetadataProvider_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var componentMetadataProvider_ComponentMetadataProvider = /** @class */ (function (_super) {
    componentMetadataProvider_extends(ComponentMetadataProvider, _super);
    function ComponentMetadataProvider() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ComponentMetadataProvider.prototype.postConstruct = function () {
        this.componentMetaData = {
            dateComponent: {
                mandatoryMethodList: ['getDate', 'setDate'],
                optionalMethodList: ['afterGuiAttached', 'setInputPlaceholder', 'setInputAriaLabel']
            },
            detailCellRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: ['refresh'],
                functionAdapter: this.agComponentUtils.adaptCellRendererFunction.bind(this.agComponentUtils)
            },
            headerComponent: {
                mandatoryMethodList: [],
                optionalMethodList: ['refresh']
            },
            headerGroupComponent: {
                mandatoryMethodList: [],
                optionalMethodList: []
            },
            loadingCellRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: []
            },
            loadingOverlayComponent: {
                mandatoryMethodList: [],
                optionalMethodList: []
            },
            noRowsOverlayComponent: {
                mandatoryMethodList: [],
                optionalMethodList: []
            },
            floatingFilterComponent: {
                mandatoryMethodList: ['onParentModelChanged'],
                optionalMethodList: ['afterGuiAttached']
            },
            floatingFilterWrapperComponent: {
                mandatoryMethodList: [],
                optionalMethodList: []
            },
            cellRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: ['refresh', 'afterGuiAttached'],
                functionAdapter: this.agComponentUtils.adaptCellRendererFunction.bind(this.agComponentUtils)
            },
            cellEditor: {
                mandatoryMethodList: ['getValue'],
                optionalMethodList: ['isPopup', 'isCancelBeforeStart', 'isCancelAfterEnd', 'getPopupPosition', 'focusIn', 'focusOut', 'afterGuiAttached']
            },
            innerRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: ['afterGuiAttached'],
                functionAdapter: this.agComponentUtils.adaptCellRendererFunction.bind(this.agComponentUtils)
            },
            fullWidthCellRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: ['refresh', 'afterGuiAttached'],
                functionAdapter: this.agComponentUtils.adaptCellRendererFunction.bind(this.agComponentUtils)
            },
            pinnedRowCellRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: ['refresh', 'afterGuiAttached'],
                functionAdapter: this.agComponentUtils.adaptCellRendererFunction.bind(this.agComponentUtils)
            },
            groupRowRenderer: {
                mandatoryMethodList: [],
                optionalMethodList: ['afterGuiAttached'],
                functionAdapter: this.agComponentUtils.adaptCellRendererFunction.bind(this.agComponentUtils)
            },
            filter: {
                mandatoryMethodList: ['isFilterActive', 'doesFilterPass', 'getModel', 'setModel'],
                optionalMethodList: ['afterGuiAttached', 'onNewRowsLoaded', 'getModelAsString', 'onFloatingFilterChanged']
            },
            filterComponent: {
                mandatoryMethodList: ['isFilterActive', 'doesFilterPass', 'getModel', 'setModel'],
                optionalMethodList: ['afterGuiAttached', 'onNewRowsLoaded', 'getModelAsString', 'onFloatingFilterChanged']
            },
            statusPanel: {
                mandatoryMethodList: [],
                optionalMethodList: ['afterGuiAttached'],
            },
            toolPanel: {
                mandatoryMethodList: [],
                optionalMethodList: ['refresh', 'afterGuiAttached']
            },
            tooltipComponent: {
                mandatoryMethodList: [],
                optionalMethodList: []
            }
        };
    };
    ComponentMetadataProvider.prototype.retrieve = function (name) {
        return this.componentMetaData[name];
    };
    componentMetadataProvider_decorate([
        Object(context_context["a" /* Autowired */])("agComponentUtils")
    ], ComponentMetadataProvider.prototype, "agComponentUtils", void 0);
    componentMetadataProvider_decorate([
        context_context["e" /* PostConstruct */]
    ], ComponentMetadataProvider.prototype, "postConstruct", null);
    ComponentMetadataProvider = componentMetadataProvider_decorate([
        Object(context_context["b" /* Bean */])("componentMetadataProvider")
    ], ComponentMetadataProvider);
    return ComponentMetadataProvider;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/beans.js
var rendering_beans = __webpack_require__("c8d4");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/environment.js
var environment = __webpack_require__("6838");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/misc/animationFrameService.js
var animationFrameService = __webpack_require__("b636");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/navigationService.js
var navigationService = __webpack_require__("6e5a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/eventKeys.js
var eventKeys = __webpack_require__("2377");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/browser.js
var browser = __webpack_require__("b8d2");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/rowContainerHeightService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var rowContainerHeightService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var rowContainerHeightService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (undefined && undefined.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};




/**
 * This class solves the 'max height' problem, where the user might want to show more data than
 * the max div height actually allows.
 */
var rowContainerHeightService_RowContainerHeightService = /** @class */ (function (_super) {
    rowContainerHeightService_extends(RowContainerHeightService, _super);
    function RowContainerHeightService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // the scrollY position
        _this.scrollY = 0;
        // how tall the body is
        _this.uiBodyHeight = 0;
        return _this;
    }
    RowContainerHeightService.prototype.agWire = function (loggerFactory) {
        this.logger = loggerFactory.create("RowContainerHeightService");
    };
    RowContainerHeightService.prototype.postConstruct = function () {
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_BODY_HEIGHT_CHANGED, this.updateOffset.bind(this));
        this.maxDivHeight = Object(browser["getMaxDivHeight"])();
        this.logger.log('maxDivHeight = ' + this.maxDivHeight);
    };
    RowContainerHeightService.prototype.isStretching = function () {
        return this.stretching;
    };
    RowContainerHeightService.prototype.getDivStretchOffset = function () {
        return this.divStretchOffset;
    };
    RowContainerHeightService.prototype.updateOffset = function () {
        if (!this.stretching) {
            return;
        }
        var gridBodyCon = this.ctrlsService.getGridBodyCtrl();
        var newScrollY = gridBodyCon.getScrollFeature().getVScrollPosition().top;
        var newBodyHeight = this.getUiBodyHeight();
        var atLeastOneChanged = newScrollY !== this.scrollY || newBodyHeight !== this.uiBodyHeight;
        if (atLeastOneChanged) {
            this.scrollY = newScrollY;
            this.uiBodyHeight = newBodyHeight;
            this.calculateOffset();
        }
    };
    RowContainerHeightService.prototype.calculateOffset = function () {
        this.setUiContainerHeight(this.maxDivHeight);
        this.pixelsToShave = this.modelHeight - this.uiContainerHeight;
        this.maxScrollY = this.uiContainerHeight - this.uiBodyHeight;
        var scrollPercent = this.scrollY / this.maxScrollY;
        var divStretchOffset = scrollPercent * this.pixelsToShave;
        this.logger.log("Div Stretch Offset = " + divStretchOffset + " (" + this.pixelsToShave + " * " + scrollPercent + ")");
        this.setDivStretchOffset(divStretchOffset);
    };
    RowContainerHeightService.prototype.setUiContainerHeight = function (height) {
        if (height !== this.uiContainerHeight) {
            this.uiContainerHeight = height;
            this.eventService.dispatchEvent({ type: eventKeys["a" /* Events */].EVENT_ROW_CONTAINER_HEIGHT_CHANGED });
        }
    };
    RowContainerHeightService.prototype.clearOffset = function () {
        this.setUiContainerHeight(this.modelHeight);
        this.pixelsToShave = 0;
        this.setDivStretchOffset(0);
    };
    RowContainerHeightService.prototype.setDivStretchOffset = function (newOffset) {
        // because we are talking pixels, no point in confusing things with half numbers
        var newOffsetFloor = typeof newOffset === 'number' ? Math.floor(newOffset) : null;
        if (this.divStretchOffset === newOffsetFloor) {
            return;
        }
        this.divStretchOffset = newOffsetFloor;
        this.eventService.dispatchEvent({ type: eventKeys["a" /* Events */].EVENT_HEIGHT_SCALE_CHANGED });
    };
    RowContainerHeightService.prototype.setModelHeight = function (modelHeight) {
        this.modelHeight = modelHeight;
        this.stretching = modelHeight != null // null happens when in print layout
            && this.maxDivHeight > 0
            && modelHeight > this.maxDivHeight;
        if (this.stretching) {
            this.calculateOffset();
        }
        else {
            this.clearOffset();
        }
    };
    RowContainerHeightService.prototype.getUiContainerHeight = function () {
        return this.uiContainerHeight;
    };
    RowContainerHeightService.prototype.getRealPixelPosition = function (modelPixel) {
        return modelPixel - this.divStretchOffset;
    };
    RowContainerHeightService.prototype.getUiBodyHeight = function () {
        var gridBodyCon = this.ctrlsService.getGridBodyCtrl();
        var pos = gridBodyCon.getScrollFeature().getVScrollPosition();
        return pos.bottom - pos.top;
    };
    RowContainerHeightService.prototype.getScrollPositionForPixel = function (rowTop) {
        if (this.pixelsToShave <= 0) {
            return rowTop;
        }
        var modelMaxScroll = this.modelHeight - this.getUiBodyHeight();
        var scrollPercent = rowTop / modelMaxScroll;
        var scrollPixel = this.maxScrollY * scrollPercent;
        return scrollPixel;
    };
    rowContainerHeightService_decorate([
        Object(context_context["a" /* Autowired */])('ctrlsService')
    ], RowContainerHeightService.prototype, "ctrlsService", void 0);
    rowContainerHeightService_decorate([
        __param(0, Object(context_context["h" /* Qualifier */])("loggerFactory"))
    ], RowContainerHeightService.prototype, "agWire", null);
    rowContainerHeightService_decorate([
        context_context["e" /* PostConstruct */]
    ], RowContainerHeightService.prototype, "postConstruct", null);
    RowContainerHeightService = rowContainerHeightService_decorate([
        Object(context_context["b" /* Bean */])('rowContainerHeightService')
    ], RowContainerHeightService);
    return RowContainerHeightService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rowNodes/selectableService.js
var selectableService = __webpack_require__("377f");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/componentAnnotations.js
var componentAnnotations = __webpack_require__("6835");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/icon.js
var icon = __webpack_require__("781c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/number.js
var number = __webpack_require__("866e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/aria.js
var aria = __webpack_require__("3348");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/constants/keyCode.js
var keyCode = __webpack_require__("7a66");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/pagination/paginationComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var paginationComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var paginationComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};









var paginationComp_PaginationComp = /** @class */ (function (_super) {
    paginationComp_extends(PaginationComp, _super);
    function PaginationComp() {
        var _this = _super.call(this) || this;
        _this.previousAndFirstButtonsDisabled = false;
        _this.nextButtonDisabled = false;
        _this.lastButtonDisabled = false;
        return _this;
    }
    PaginationComp.prototype.postConstruct = function () {
        var _this = this;
        var isRtl = this.gridOptionsWrapper.isEnableRtl();
        this.setTemplate(this.getTemplate());
        this.btFirst.insertAdjacentElement('afterbegin', Object(icon["createIconNoSpan"])(isRtl ? 'last' : 'first', this.gridOptionsWrapper));
        this.btPrevious.insertAdjacentElement('afterbegin', Object(icon["createIconNoSpan"])(isRtl ? 'next' : 'previous', this.gridOptionsWrapper));
        this.btNext.insertAdjacentElement('afterbegin', Object(icon["createIconNoSpan"])(isRtl ? 'previous' : 'next', this.gridOptionsWrapper));
        this.btLast.insertAdjacentElement('afterbegin', Object(icon["createIconNoSpan"])(isRtl ? 'first' : 'last', this.gridOptionsWrapper));
        var isPaging = this.gridOptionsWrapper.isPagination();
        var paginationPanelEnabled = isPaging && !this.gridOptionsWrapper.isSuppressPaginationPanel();
        if (!paginationPanelEnabled) {
            this.setDisplayed(false);
            return;
        }
        this.addManagedListener(this.eventService, events["a" /* Events */].EVENT_PAGINATION_CHANGED, this.onPaginationChanged.bind(this));
        [
            { el: this.btFirst, fn: this.onBtFirst.bind(this) },
            { el: this.btPrevious, fn: this.onBtPrevious.bind(this) },
            { el: this.btNext, fn: this.onBtNext.bind(this) },
            { el: this.btLast, fn: this.onBtLast.bind(this) }
        ].forEach(function (item) {
            var el = item.el, fn = item.fn;
            _this.addManagedListener(el, 'click', fn);
            _this.addManagedListener(el, 'keydown', function (e) {
                if (e.keyCode === keyCode["a" /* KeyCode */].ENTER || e.keyCode === keyCode["a" /* KeyCode */].SPACE) {
                    e.preventDefault();
                    fn();
                }
            });
        });
        this.onPaginationChanged();
    };
    PaginationComp.prototype.onPaginationChanged = function () {
        this.enableOrDisableButtons();
        this.updateRowLabels();
        this.setCurrentPageLabel();
        this.setTotalLabels();
    };
    PaginationComp.prototype.onBtFirst = function () {
        if (!this.previousAndFirstButtonsDisabled) {
            this.paginationProxy.goToFirstPage();
        }
    };
    PaginationComp.prototype.setCurrentPageLabel = function () {
        var pagesExist = this.paginationProxy.getTotalPages() > 0;
        var currentPage = this.paginationProxy.getCurrentPage();
        var toDisplay = pagesExist ? currentPage + 1 : 0;
        this.lbCurrent.innerHTML = this.formatNumber(toDisplay);
    };
    PaginationComp.prototype.formatNumber = function (value) {
        var userFunc = this.gridOptionsWrapper.getPaginationNumberFormatterFunc();
        if (userFunc) {
            return userFunc({ value: value });
        }
        return Object(number["formatNumberCommas"])(value);
    };
    PaginationComp.prototype.getTemplate = function () {
        var localeTextFunc = this.gridOptionsWrapper.getLocaleTextFunc();
        var strPage = localeTextFunc('page', 'Page');
        var strTo = localeTextFunc('to', 'to');
        var strOf = localeTextFunc('of', 'of');
        var strFirst = localeTextFunc('firstPage', 'First Page');
        var strPrevious = localeTextFunc('previousPage', 'Previous Page');
        var strNext = localeTextFunc('nextPage', 'Next Page');
        var strLast = localeTextFunc('lastPage', 'Last Page');
        var compId = this.getCompId();
        return /* html */ "<div class=\"ag-paging-panel ag-unselectable\" id=\"ag-" + compId + "\">\n                <span class=\"ag-paging-row-summary-panel\" role=\"status\">\n                    <span id=\"ag-" + compId + "-first-row\" ref=\"lbFirstRowOnPage\" class=\"ag-paging-row-summary-panel-number\"></span>\n                    <span id=\"ag-" + compId + "-to\">" + strTo + "</span>\n                    <span id=\"ag-" + compId + "-last-row\" ref=\"lbLastRowOnPage\" class=\"ag-paging-row-summary-panel-number\"></span>\n                    <span id=\"ag-" + compId + "-of\">" + strOf + "</span>\n                    <span id=\"ag-" + compId + "-row-count\" ref=\"lbRecordCount\" class=\"ag-paging-row-summary-panel-number\"></span>\n                </span>\n                <span class=\"ag-paging-page-summary-panel\" role=\"presentation\">\n                    <div ref=\"btFirst\" class=\"ag-paging-button\" role=\"button\" aria-label=\"" + strFirst + "\" tabindex=\"0\"></div>\n                    <div ref=\"btPrevious\" class=\"ag-paging-button\" role=\"button\" aria-label=\"" + strPrevious + "\" tabindex=\"0\"></div>\n                    <span class=\"ag-paging-description\" role=\"status\">\n                        <span id=\"ag-" + compId + "-start-page\">" + strPage + "</span>\n                        <span id=\"ag-" + compId + "-start-page-number\" ref=\"lbCurrent\" class=\"ag-paging-number\"></span>\n                        <span id=\"ag-" + compId + "-of-page\">" + strOf + "</span>\n                        <span id=\"ag-" + compId + "-of-page-number\" ref=\"lbTotal\" class=\"ag-paging-number\"></span>\n                    </span>\n                    <div ref=\"btNext\" class=\"ag-paging-button\" role=\"button\" aria-label=\"" + strNext + "\" tabindex=\"0\"></div>\n                    <div ref=\"btLast\" class=\"ag-paging-button\" role=\"button\" aria-label=\"" + strLast + "\" tabindex=\"0\"></div>\n                </span>\n            </div>";
    };
    PaginationComp.prototype.onBtNext = function () {
        if (!this.nextButtonDisabled) {
            this.paginationProxy.goToNextPage();
        }
    };
    PaginationComp.prototype.onBtPrevious = function () {
        if (!this.previousAndFirstButtonsDisabled) {
            this.paginationProxy.goToPreviousPage();
        }
    };
    PaginationComp.prototype.onBtLast = function () {
        if (!this.lastButtonDisabled) {
            this.paginationProxy.goToLastPage();
        }
    };
    PaginationComp.prototype.enableOrDisableButtons = function () {
        var currentPage = this.paginationProxy.getCurrentPage();
        var maxRowFound = this.paginationProxy.isLastPageFound();
        var totalPages = this.paginationProxy.getTotalPages();
        this.previousAndFirstButtonsDisabled = currentPage === 0;
        Object(dom["addOrRemoveCssClass"])(this.btFirst, 'ag-disabled', this.previousAndFirstButtonsDisabled);
        Object(aria["setAriaDisabled"])(this.btFirst, this.previousAndFirstButtonsDisabled);
        Object(dom["addOrRemoveCssClass"])(this.btPrevious, 'ag-disabled', this.previousAndFirstButtonsDisabled);
        Object(aria["setAriaDisabled"])(this.btPrevious, this.previousAndFirstButtonsDisabled);
        var zeroPagesToDisplay = this.isZeroPagesToDisplay();
        var onLastPage = maxRowFound && currentPage === (totalPages - 1);
        this.nextButtonDisabled = onLastPage || zeroPagesToDisplay;
        Object(dom["addOrRemoveCssClass"])(this.btNext, 'ag-disabled', this.nextButtonDisabled);
        Object(aria["setAriaDisabled"])(this.btNext, this.nextButtonDisabled);
        this.lastButtonDisabled = !maxRowFound || zeroPagesToDisplay || currentPage === (totalPages - 1);
        Object(dom["addOrRemoveCssClass"])(this.btLast, 'ag-disabled', this.lastButtonDisabled);
        Object(aria["setAriaDisabled"])(this.btLast, this.lastButtonDisabled);
    };
    PaginationComp.prototype.updateRowLabels = function () {
        var currentPage = this.paginationProxy.getCurrentPage();
        var pageSize = this.paginationProxy.getPageSize();
        var maxRowFound = this.paginationProxy.isLastPageFound();
        var rowCount = this.paginationProxy.isLastPageFound() ?
            this.paginationProxy.getMasterRowCount() : null;
        var startRow;
        var endRow;
        if (this.isZeroPagesToDisplay()) {
            startRow = endRow = 0;
        }
        else {
            startRow = (pageSize * currentPage) + 1;
            endRow = startRow + pageSize - 1;
            if (maxRowFound && endRow > rowCount) {
                endRow = rowCount;
            }
        }
        this.lbFirstRowOnPage.innerHTML = this.formatNumber(startRow);
        if (this.rowNodeBlockLoader.isLoading()) {
            this.lbLastRowOnPage.innerHTML = '?';
        }
        else {
            this.lbLastRowOnPage.innerHTML = this.formatNumber(endRow);
        }
    };
    PaginationComp.prototype.isZeroPagesToDisplay = function () {
        var maxRowFound = this.paginationProxy.isLastPageFound();
        var totalPages = this.paginationProxy.getTotalPages();
        return maxRowFound && totalPages === 0;
    };
    PaginationComp.prototype.setTotalLabels = function () {
        var lastPageFound = this.paginationProxy.isLastPageFound();
        var totalPages = this.paginationProxy.getTotalPages();
        var rowCount = lastPageFound ?
            this.paginationProxy.getMasterRowCount() : null;
        if (lastPageFound) {
            this.lbTotal.innerHTML = this.formatNumber(totalPages);
            this.lbRecordCount.innerHTML = this.formatNumber(rowCount);
        }
        else {
            var moreText = this.gridOptionsWrapper.getLocaleTextFunc()('more', 'more');
            this.lbTotal.innerHTML = moreText;
            this.lbRecordCount.innerHTML = moreText;
        }
    };
    paginationComp_decorate([
        Object(context_context["a" /* Autowired */])('paginationProxy')
    ], PaginationComp.prototype, "paginationProxy", void 0);
    paginationComp_decorate([
        Object(context_context["a" /* Autowired */])('rowNodeBlockLoader')
    ], PaginationComp.prototype, "rowNodeBlockLoader", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('btFirst')
    ], PaginationComp.prototype, "btFirst", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('btPrevious')
    ], PaginationComp.prototype, "btPrevious", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('btNext')
    ], PaginationComp.prototype, "btNext", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('btLast')
    ], PaginationComp.prototype, "btLast", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('lbRecordCount')
    ], PaginationComp.prototype, "lbRecordCount", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('lbFirstRowOnPage')
    ], PaginationComp.prototype, "lbFirstRowOnPage", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('lbLastRowOnPage')
    ], PaginationComp.prototype, "lbLastRowOnPage", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('lbCurrent')
    ], PaginationComp.prototype, "lbCurrent", void 0);
    paginationComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('lbTotal')
    ], PaginationComp.prototype, "lbTotal", void 0);
    paginationComp_decorate([
        context_context["e" /* PostConstruct */]
    ], PaginationComp.prototype, "postConstruct", null);
    return PaginationComp;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/misc/resizeObserverService.js
var resizeObserverService = __webpack_require__("5d12");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/styling/layoutFeature.js
var layoutFeature = __webpack_require__("4d89");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/overlays/overlayWrapperComponent.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var overlayWrapperComponent_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var overlayWrapperComponent_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var LoadingType;
(function (LoadingType) {
    LoadingType[LoadingType["Loading"] = 0] = "Loading";
    LoadingType[LoadingType["NoRows"] = 1] = "NoRows";
})(LoadingType || (LoadingType = {}));
var overlayWrapperComponent_OverlayWrapperComponent = /** @class */ (function (_super) {
    overlayWrapperComponent_extends(OverlayWrapperComponent, _super);
    function OverlayWrapperComponent() {
        var _this = _super.call(this, OverlayWrapperComponent.TEMPLATE) || this;
        _this.inProgress = false;
        _this.destroyRequested = false;
        return _this;
    }
    OverlayWrapperComponent.prototype.updateLayoutClasses = function (cssClass, params) {
        Object(dom["addOrRemoveCssClass"])(this.eOverlayWrapper, layoutFeature["a" /* LayoutCssClasses */].AUTO_HEIGHT, params.autoHeight);
        Object(dom["addOrRemoveCssClass"])(this.eOverlayWrapper, layoutFeature["a" /* LayoutCssClasses */].NORMAL, params.normal);
        Object(dom["addOrRemoveCssClass"])(this.eOverlayWrapper, layoutFeature["a" /* LayoutCssClasses */].PRINT, params.print);
    };
    OverlayWrapperComponent.prototype.postConstruct = function () {
        this.createManagedBean(new layoutFeature["b" /* LayoutFeature */](this));
        this.setDisplayed(false);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_ROW_DATA_CHANGED, this.onRowDataChanged.bind(this));
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_ROW_DATA_UPDATED, this.onRowDataChanged.bind(this));
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_NEW_COLUMNS_LOADED, this.onNewColumnsLoaded.bind(this));
        if (this.gridOptionsWrapper.isRowModelDefault() && !this.gridOptionsWrapper.getRowData()) {
            this.showLoadingOverlay();
        }
        this.gridApi.registerOverlayWrapperComp(this);
    };
    OverlayWrapperComponent.prototype.setWrapperTypeClass = function (loadingType) {
        Object(dom["addOrRemoveCssClass"])(this.eOverlayWrapper, 'ag-overlay-loading-wrapper', loadingType === LoadingType.Loading);
        Object(dom["addOrRemoveCssClass"])(this.eOverlayWrapper, 'ag-overlay-no-rows-wrapper', loadingType === LoadingType.NoRows);
    };
    OverlayWrapperComponent.prototype.showLoadingOverlay = function () {
        if (this.gridOptionsWrapper.isSuppressLoadingOverlay()) {
            return;
        }
        var workItem = this.userComponentFactory.newLoadingOverlayComponent({
            api: this.gridOptionsWrapper.getApi()
        });
        this.showOverlay(workItem, LoadingType.Loading);
    };
    OverlayWrapperComponent.prototype.showNoRowsOverlay = function () {
        if (this.gridOptionsWrapper.isSuppressNoRowsOverlay()) {
            return;
        }
        var workItem = this.userComponentFactory.newNoRowsOverlayComponent({
            api: this.gridOptionsWrapper.getApi()
        });
        this.showOverlay(workItem, LoadingType.NoRows);
    };
    OverlayWrapperComponent.prototype.showOverlay = function (workItem, type) {
        var _this = this;
        if (this.inProgress) {
            return;
        }
        this.setWrapperTypeClass(type);
        this.destroyActiveOverlay();
        this.inProgress = true;
        if (workItem) {
            workItem.then(function (comp) {
                _this.inProgress = false;
                _this.eOverlayWrapper.appendChild(comp.getGui());
                _this.activeOverlay = comp;
                if (_this.destroyRequested) {
                    _this.destroyRequested = false;
                    _this.destroyActiveOverlay();
                }
            });
        }
        this.setDisplayed(true);
    };
    OverlayWrapperComponent.prototype.destroyActiveOverlay = function () {
        if (this.inProgress) {
            this.destroyRequested = true;
            return;
        }
        if (!this.activeOverlay) {
            return;
        }
        this.activeOverlay = this.getContext().destroyBean(this.activeOverlay);
        Object(dom["clearElement"])(this.eOverlayWrapper);
    };
    OverlayWrapperComponent.prototype.hideOverlay = function () {
        this.destroyActiveOverlay();
        this.setDisplayed(false);
    };
    OverlayWrapperComponent.prototype.destroy = function () {
        this.destroyActiveOverlay();
        _super.prototype.destroy.call(this);
    };
    OverlayWrapperComponent.prototype.showOrHideOverlay = function () {
        var isEmpty = this.paginationProxy.isEmpty();
        var isSuppressNoRowsOverlay = this.gridOptionsWrapper.isSuppressNoRowsOverlay();
        if (isEmpty && !isSuppressNoRowsOverlay) {
            this.showNoRowsOverlay();
        }
        else {
            this.hideOverlay();
        }
    };
    OverlayWrapperComponent.prototype.onRowDataChanged = function () {
        this.showOrHideOverlay();
    };
    OverlayWrapperComponent.prototype.onNewColumnsLoaded = function () {
        // hide overlay if columns and rows exist, this can happen if columns are loaded after data.
        // this problem exists before of the race condition between the services (column controller in this case)
        // and the view (grid panel). if the model beans were all initialised first, and then the view beans second,
        // this race condition would not happen.
        if (this.columnModel.isReady() && !this.paginationProxy.isEmpty()) {
            this.hideOverlay();
        }
    };
    // wrapping in outer div, and wrapper, is needed to center the loading icon
    // The idea for centering came from here: http://www.vanseodesign.com/css/vertical-centering/
    OverlayWrapperComponent.TEMPLATE = "\n        <div class=\"ag-overlay\" aria-hidden=\"true\">\n            <div class=\"ag-overlay-panel\">\n                <div class=\"ag-overlay-wrapper\" ref=\"eOverlayWrapper\"></div>\n            </div>\n        </div>";
    overlayWrapperComponent_decorate([
        Object(context_context["a" /* Autowired */])('userComponentFactory')
    ], OverlayWrapperComponent.prototype, "userComponentFactory", void 0);
    overlayWrapperComponent_decorate([
        Object(context_context["a" /* Autowired */])('paginationProxy')
    ], OverlayWrapperComponent.prototype, "paginationProxy", void 0);
    overlayWrapperComponent_decorate([
        Object(context_context["a" /* Autowired */])('gridApi')
    ], OverlayWrapperComponent.prototype, "gridApi", void 0);
    overlayWrapperComponent_decorate([
        Object(context_context["a" /* Autowired */])('columnModel')
    ], OverlayWrapperComponent.prototype, "columnModel", void 0);
    overlayWrapperComponent_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eOverlayWrapper')
    ], OverlayWrapperComponent.prototype, "eOverlayWrapper", void 0);
    overlayWrapperComponent_decorate([
        context_context["e" /* PostConstruct */]
    ], OverlayWrapperComponent.prototype, "postConstruct", null);
    return OverlayWrapperComponent;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agGroupComponent.js
var agGroupComponent = __webpack_require__("31bf");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agDialog.js
var agDialog = __webpack_require__("8cfd");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agPanel.js
var agPanel = __webpack_require__("4a00");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agInputTextField.js
var agInputTextField = __webpack_require__("baad");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agInputTextArea.js
var agInputTextArea = __webpack_require__("852c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agSlider.js
var agSlider = __webpack_require__("e620");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agColorPicker.js + 1 modules
var agColorPicker = __webpack_require__("3ad0");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agInputNumberField.js
var agInputNumberField = __webpack_require__("5c04");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agInputRange.js
var agInputRange = __webpack_require__("e06a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agSelect.js + 1 modules
var agSelect = __webpack_require__("56a3");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agAngleSelect.js
var agAngleSelect = __webpack_require__("d0e6");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agToggleButton.js
var agToggleButton = __webpack_require__("1e85");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/rowPosition.js
var rowPosition = __webpack_require__("3483");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/cellPosition.js
var cellPosition = __webpack_require__("5b49");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/pinnedRowModel/pinnedRowModel.js
var pinnedRowModel = __webpack_require__("bf0c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/modules/moduleRegistry.js
var moduleRegistry = __webpack_require__("2c7d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/modules/moduleNames.js
var moduleNames = __webpack_require__("b5fb");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/undoRedo/undoRedoStack.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var undoRedoStack_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var UndoRedoAction = /** @class */ (function () {
    function UndoRedoAction(cellValueChanges) {
        this.cellValueChanges = cellValueChanges;
    }
    return UndoRedoAction;
}());

var FillUndoRedoAction = /** @class */ (function (_super) {
    undoRedoStack_extends(FillUndoRedoAction, _super);
    function FillUndoRedoAction(cellValueChanges, initialRange, finalRange) {
        var _this = _super.call(this, cellValueChanges) || this;
        _this.initialRange = initialRange;
        _this.finalRange = finalRange;
        return _this;
    }
    return FillUndoRedoAction;
}(UndoRedoAction));

var UndoRedoStack = /** @class */ (function () {
    function UndoRedoStack(maxStackSize) {
        this.actionStack = [];
        this.maxStackSize = maxStackSize ? maxStackSize : UndoRedoStack.DEFAULT_STACK_SIZE;
        this.actionStack = new Array(this.maxStackSize);
    }
    UndoRedoStack.prototype.pop = function () {
        return this.actionStack.pop();
    };
    UndoRedoStack.prototype.push = function (item) {
        var shouldAddActions = item.cellValueChanges && item.cellValueChanges.length > 0;
        if (!shouldAddActions) {
            return;
        }
        if (this.actionStack.length === this.maxStackSize) {
            this.actionStack.shift();
        }
        this.actionStack.push(item);
    };
    UndoRedoStack.prototype.clear = function () {
        this.actionStack = [];
    };
    UndoRedoStack.prototype.getCurrentStackSize = function () {
        return this.actionStack.length;
    };
    UndoRedoStack.DEFAULT_STACK_SIZE = 10;
    return UndoRedoStack;
}());


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/undoRedo/undoRedoService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var undoRedoService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var undoRedoService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};







var undoRedoService_UndoRedoService = /** @class */ (function (_super) {
    undoRedoService_extends(UndoRedoService, _super);
    function UndoRedoService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cellValueChanges = [];
        _this.activeCellEdit = null;
        _this.activeRowEdit = null;
        _this.isPasting = false;
        _this.isFilling = false;
        _this.onCellValueChanged = function (event) {
            var eventCell = { column: event.column, rowIndex: event.rowIndex, rowPinned: event.rowPinned };
            var isCellEditing = _this.activeCellEdit !== null && _this.cellPositionUtils.equals(_this.activeCellEdit, eventCell);
            var isRowEditing = _this.activeRowEdit !== null && _this.rowPositionUtils.sameRow(_this.activeRowEdit, eventCell);
            var shouldCaptureAction = isCellEditing || isRowEditing || _this.isPasting || _this.isFilling;
            if (!shouldCaptureAction) {
                return;
            }
            var rowPinned = event.rowPinned, rowIndex = event.rowIndex, column = event.column, oldValue = event.oldValue, value = event.value;
            var cellValueChange = {
                rowPinned: rowPinned,
                rowIndex: rowIndex,
                columnId: column.getColId(),
                newValue: value,
                oldValue: oldValue
            };
            _this.cellValueChanges.push(cellValueChange);
        };
        _this.clearStacks = function () {
            _this.undoStack.clear();
            _this.redoStack.clear();
        };
        return _this;
    }
    UndoRedoService.prototype.init = function () {
        if (!this.gridOptionsWrapper.isUndoRedoCellEditing()) {
            return;
        }
        var undoRedoLimit = this.gridOptionsWrapper.getUndoRedoCellEditingLimit();
        if (undoRedoLimit <= 0) {
            return;
        }
        this.undoStack = new UndoRedoStack(undoRedoLimit);
        this.redoStack = new UndoRedoStack(undoRedoLimit);
        this.addRowEditingListeners();
        this.addCellEditingListeners();
        this.addPasteListeners();
        this.addFillListeners();
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_CELL_VALUE_CHANGED, this.onCellValueChanged);
        // undo / redo is restricted to actual editing so we clear the stacks when other operations are
        // performed that change the order of the row / cols.
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_MODEL_UPDATED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_COLUMN_PIVOT_MODE_CHANGED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_NEW_COLUMNS_LOADED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_COLUMN_GROUP_OPENED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_COLUMN_ROW_GROUP_CHANGED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_COLUMN_MOVED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_COLUMN_PINNED, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_COLUMN_VISIBLE, this.clearStacks);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_ROW_DRAG_END, this.clearStacks);
    };
    UndoRedoService.prototype.getCurrentUndoStackSize = function () {
        return this.undoStack ? this.undoStack.getCurrentStackSize() : 0;
    };
    UndoRedoService.prototype.getCurrentRedoStackSize = function () {
        return this.redoStack ? this.redoStack.getCurrentStackSize() : 0;
    };
    UndoRedoService.prototype.undo = function () {
        if (!this.undoStack) {
            return;
        }
        var undoAction = this.undoStack.pop();
        if (!undoAction || !undoAction.cellValueChanges) {
            return;
        }
        this.processAction(undoAction, function (cellValueChange) { return cellValueChange.oldValue; });
        if (undoAction instanceof FillUndoRedoAction) {
            this.processRangeAndCellFocus(undoAction.cellValueChanges, undoAction.initialRange);
        }
        else {
            this.processRangeAndCellFocus(undoAction.cellValueChanges);
        }
        this.redoStack.push(undoAction);
    };
    UndoRedoService.prototype.redo = function () {
        if (!this.redoStack) {
            return;
        }
        var redoAction = this.redoStack.pop();
        if (!redoAction || !redoAction.cellValueChanges) {
            return;
        }
        this.processAction(redoAction, function (cellValueChange) { return cellValueChange.newValue; });
        if (redoAction instanceof FillUndoRedoAction) {
            this.processRangeAndCellFocus(redoAction.cellValueChanges, redoAction.finalRange);
        }
        else {
            this.processRangeAndCellFocus(redoAction.cellValueChanges);
        }
        this.undoStack.push(redoAction);
    };
    UndoRedoService.prototype.processAction = function (action, valueExtractor) {
        var _this = this;
        action.cellValueChanges.forEach(function (cellValueChange) {
            var rowIndex = cellValueChange.rowIndex, rowPinned = cellValueChange.rowPinned, columnId = cellValueChange.columnId;
            var rowPosition = { rowIndex: rowIndex, rowPinned: rowPinned };
            var currentRow = _this.getRowNode(rowPosition);
            // checks if the row has been filtered out
            if (!currentRow.displayed) {
                return;
            }
            currentRow.setDataValue(columnId, valueExtractor(cellValueChange));
        });
    };
    UndoRedoService.prototype.processRangeAndCellFocus = function (cellValueChanges, range) {
        var lastFocusedCell;
        if (range) {
            var startRow = range.startRow;
            var endRow = range.endRow;
            lastFocusedCell = {
                rowPinned: startRow.rowPinned,
                rowIndex: startRow.rowIndex,
                columnId: range.startColumn.getColId()
            };
            this.setLastFocusedCell(lastFocusedCell);
            var cellRangeParams = {
                rowStartIndex: startRow.rowIndex,
                rowStartPinned: startRow.rowPinned,
                rowEndIndex: endRow.rowIndex,
                rowEndPinned: endRow.rowPinned,
                columnStart: range.startColumn,
                columns: range.columns
            };
            this.gridApi.addCellRange(cellRangeParams);
            return;
        }
        var cellValueChange = cellValueChanges[0];
        var rowIndex = cellValueChange.rowIndex, rowPinned = cellValueChange.rowPinned;
        var rowPosition = { rowIndex: rowIndex, rowPinned: rowPinned };
        var row = this.getRowNode(rowPosition);
        lastFocusedCell = {
            rowPinned: cellValueChange.rowPinned,
            rowIndex: row.rowIndex,
            columnId: cellValueChange.columnId
        };
        this.setLastFocusedCell(lastFocusedCell);
    };
    UndoRedoService.prototype.setLastFocusedCell = function (lastFocusedCell) {
        var rowIndex = lastFocusedCell.rowIndex, columnId = lastFocusedCell.columnId, rowPinned = lastFocusedCell.rowPinned;
        this.gridApi.ensureIndexVisible(rowIndex);
        this.gridApi.ensureColumnVisible(columnId);
        if (moduleRegistry["a" /* ModuleRegistry */].isRegistered(moduleNames["a" /* ModuleNames */].RangeSelectionModule)) {
            this.gridApi.clearRangeSelection();
        }
        this.focusService.setFocusedCell(rowIndex, columnId, rowPinned, true);
    };
    UndoRedoService.prototype.addRowEditingListeners = function () {
        var _this = this;
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_ROW_EDITING_STARTED, function (e) {
            _this.activeRowEdit = { rowIndex: e.rowIndex, rowPinned: e.rowPinned };
        });
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_ROW_EDITING_STOPPED, function () {
            var action = new UndoRedoAction(_this.cellValueChanges);
            _this.pushActionsToUndoStack(action);
            _this.activeRowEdit = null;
        });
    };
    UndoRedoService.prototype.addCellEditingListeners = function () {
        var _this = this;
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_CELL_EDITING_STARTED, function (e) {
            _this.activeCellEdit = { column: e.column, rowIndex: e.rowIndex, rowPinned: e.rowPinned };
        });
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_CELL_EDITING_STOPPED, function () {
            _this.activeCellEdit = null;
            var shouldPushAction = !_this.activeRowEdit && !_this.isPasting && !_this.isFilling;
            if (shouldPushAction) {
                var action = new UndoRedoAction(_this.cellValueChanges);
                _this.pushActionsToUndoStack(action);
            }
        });
    };
    UndoRedoService.prototype.addPasteListeners = function () {
        var _this = this;
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_PASTE_START, function () {
            _this.isPasting = true;
        });
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_PASTE_END, function () {
            var action = new UndoRedoAction(_this.cellValueChanges);
            _this.pushActionsToUndoStack(action);
            _this.isPasting = false;
        });
    };
    UndoRedoService.prototype.addFillListeners = function () {
        var _this = this;
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_FILL_START, function () {
            _this.isFilling = true;
        });
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_FILL_END, function (event) {
            var action = new FillUndoRedoAction(_this.cellValueChanges, event.initialRange, event.finalRange);
            _this.pushActionsToUndoStack(action);
            _this.isFilling = false;
        });
    };
    UndoRedoService.prototype.pushActionsToUndoStack = function (action) {
        this.undoStack.push(action);
        this.cellValueChanges = [];
        this.redoStack.clear();
    };
    UndoRedoService.prototype.getRowNode = function (gridRow) {
        switch (gridRow.rowPinned) {
            case constants["a" /* Constants */].PINNED_TOP:
                return this.pinnedRowModel.getPinnedTopRowData()[gridRow.rowIndex];
            case constants["a" /* Constants */].PINNED_BOTTOM:
                return this.pinnedRowModel.getPinnedBottomRowData()[gridRow.rowIndex];
            default:
                return this.rowModel.getRow(gridRow.rowIndex);
        }
    };
    undoRedoService_decorate([
        Object(context_context["a" /* Autowired */])('focusService')
    ], UndoRedoService.prototype, "focusService", void 0);
    undoRedoService_decorate([
        Object(context_context["a" /* Autowired */])('gridApi')
    ], UndoRedoService.prototype, "gridApi", void 0);
    undoRedoService_decorate([
        Object(context_context["a" /* Autowired */])('rowModel')
    ], UndoRedoService.prototype, "rowModel", void 0);
    undoRedoService_decorate([
        Object(context_context["a" /* Autowired */])('pinnedRowModel')
    ], UndoRedoService.prototype, "pinnedRowModel", void 0);
    undoRedoService_decorate([
        Object(context_context["a" /* Autowired */])('cellPositionUtils')
    ], UndoRedoService.prototype, "cellPositionUtils", void 0);
    undoRedoService_decorate([
        Object(context_context["a" /* Autowired */])('rowPositionUtils')
    ], UndoRedoService.prototype, "rowPositionUtils", void 0);
    undoRedoService_decorate([
        context_context["e" /* PostConstruct */]
    ], UndoRedoService.prototype, "init", null);
    UndoRedoService = undoRedoService_decorate([
        Object(context_context["b" /* Bean */])('undoRedoService')
    ], UndoRedoService);
    return UndoRedoService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/agStackComponentsRegistry.js
var agStackComponentsRegistry = __webpack_require__("8418");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/common/headerPosition.js
var headerPosition = __webpack_require__("217a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/common/headerNavigationService.js
var headerNavigationService = __webpack_require__("35fe");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/columns/columnDefFactory.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var columnDefFactory_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var columnDefFactory_ColumnDefFactory = /** @class */ (function () {
    function ColumnDefFactory() {
    }
    ColumnDefFactory.prototype.buildColumnDefs = function (cols, rowGroupColumns, pivotColumns) {
        var _this = this;
        var res = [];
        var colGroupDefs = {};
        cols.forEach(function (col) {
            var colDef = _this.createDefFromColumn(col, rowGroupColumns, pivotColumns);
            var addToResult = true;
            var childDef = colDef;
            var pointer = col.getOriginalParent();
            while (pointer) {
                var parentDef = null;
                // we don't include padding groups, as the column groups provided
                // by application didn't have these. the whole point of padding groups
                // is to balance the column tree that the user provided.
                if (pointer.isPadding()) {
                    pointer = pointer.getOriginalParent();
                    continue;
                }
                // if colDef for this group already exists, use it
                var existingParentDef = colGroupDefs[pointer.getGroupId()];
                if (existingParentDef) {
                    existingParentDef.children.push(childDef);
                    // if we added to result, it would be the second time we did it
                    addToResult = false;
                    // we don't want to continue up the tree, as it has already been
                    // done for this group
                    break;
                }
                parentDef = _this.createDefFromGroup(pointer);
                if (parentDef) {
                    parentDef.children = [childDef];
                    colGroupDefs[parentDef.groupId] = parentDef;
                    childDef = parentDef;
                    pointer = pointer.getOriginalParent();
                }
            }
            if (addToResult) {
                res.push(childDef);
            }
        });
        return res;
    };
    ColumnDefFactory.prototype.createDefFromGroup = function (group) {
        var defCloned = Object(object["deepCloneDefinition"])(group.getColGroupDef(), ['children']);
        if (defCloned) {
            defCloned.groupId = group.getGroupId();
        }
        return defCloned;
    };
    ColumnDefFactory.prototype.createDefFromColumn = function (col, rowGroupColumns, pivotColumns) {
        var colDefCloned = Object(object["deepCloneDefinition"])(col.getColDef());
        colDefCloned.colId = col.getColId();
        colDefCloned.width = col.getActualWidth();
        colDefCloned.rowGroup = col.isRowGroupActive();
        colDefCloned.rowGroupIndex = col.isRowGroupActive() ? rowGroupColumns.indexOf(col) : null;
        colDefCloned.pivot = col.isPivotActive();
        colDefCloned.pivotIndex = col.isPivotActive() ? pivotColumns.indexOf(col) : null;
        colDefCloned.aggFunc = col.isValueActive() ? col.getAggFunc() : null;
        colDefCloned.hide = col.isVisible() ? undefined : true;
        colDefCloned.pinned = col.isPinned() ? col.getPinned() : null;
        colDefCloned.sort = col.getSort() ? col.getSort() : null;
        colDefCloned.sortIndex = col.getSortIndex() != null ? col.getSortIndex() : null;
        return colDefCloned;
    };
    ColumnDefFactory = columnDefFactory_decorate([
        Object(context_context["b" /* Bean */])('columnDefFactory')
    ], ColumnDefFactory);
    return ColumnDefFactory;
}());


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/array.js
var array = __webpack_require__("348a");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/row/rowCssClassCalculator.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var rowCssClassCalculator_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var rowCssClassCalculator_RowCssClassCalculator = /** @class */ (function () {
    function RowCssClassCalculator() {
    }
    RowCssClassCalculator.prototype.getInitialRowClasses = function (params) {
        var classes = [];
        if (Object(generic["exists"])(params.extraCssClass)) {
            classes.push(params.extraCssClass);
        }
        classes.push('ag-row');
        classes.push(params.rowFocused ? 'ag-row-focus' : 'ag-row-no-focus');
        if (params.fadeRowIn) {
            classes.push('ag-opacity-zero');
        }
        classes.push(params.rowIsEven ? 'ag-row-even' : 'ag-row-odd');
        if (params.rowNode.isRowPinned()) {
            classes.push('ag-row-pinned');
        }
        if (params.rowNode.isSelected()) {
            classes.push('ag-row-selected');
        }
        if (params.rowNode.footer) {
            classes.push('ag-row-footer');
        }
        classes.push('ag-row-level-' + params.rowLevel);
        if (params.rowNode.stub) {
            classes.push('ag-row-loading');
        }
        if (params.fullWidthRow) {
            classes.push('ag-full-width-row');
        }
        if (params.expandable) {
            classes.push('ag-row-group');
            classes.push(params.rowNode.expanded ? 'ag-row-group-expanded' : 'ag-row-group-contracted');
        }
        if (params.rowNode.dragging) {
            classes.push('ag-row-dragging');
        }
        Object(array["pushAll"])(classes, this.processClassesFromGridOptions(params.rowNode, params.scope));
        Object(array["pushAll"])(classes, this.preProcessRowClassRules(params.rowNode, params.scope));
        // we use absolute position unless we are doing print layout
        classes.push(params.printLayout ? 'ag-row-position-relative' : 'ag-row-position-absolute');
        if (params.firstRowOnPage) {
            classes.push('ag-row-first');
        }
        if (params.lastRowOnPage) {
            classes.push('ag-row-last');
        }
        if (params.fullWidthRow) {
            if (params.pinned === constants["a" /* Constants */].PINNED_LEFT) {
                classes.push('ag-cell-last-left-pinned');
            }
            if (params.pinned === constants["a" /* Constants */].PINNED_RIGHT) {
                classes.push('ag-cell-first-right-pinned');
            }
        }
        return classes;
    };
    RowCssClassCalculator.prototype.processClassesFromGridOptions = function (rowNode, scope) {
        var res = [];
        var process = function (rowCls) {
            if (typeof rowCls === 'string') {
                res.push(rowCls);
            }
            else if (Array.isArray(rowCls)) {
                rowCls.forEach(function (e) { return res.push(e); });
            }
        };
        // part 1 - rowClass
        var rowClass = this.gridOptionsWrapper.getRowClass();
        if (rowClass) {
            if (typeof rowClass === 'function') {
                console.warn('AG Grid: rowClass should not be a function, please use getRowClass instead');
                return [];
            }
            process(rowClass);
        }
        // part 2 - rowClassFunc
        var rowClassFunc = this.gridOptionsWrapper.getRowClassFunc();
        if (rowClassFunc) {
            var params = {
                data: rowNode.data,
                node: rowNode,
                rowIndex: rowNode.rowIndex,
                $scope: scope,
                api: this.gridOptionsWrapper.getApi(),
                columnApi: this.gridOptionsWrapper.getColumnApi(),
                context: this.gridOptionsWrapper.getContext()
            };
            var rowClassFuncResult = rowClassFunc(params);
            process(rowClassFuncResult);
        }
        return res;
    };
    RowCssClassCalculator.prototype.preProcessRowClassRules = function (rowNode, scope) {
        var res = [];
        this.processRowClassRules(rowNode, scope, function (className) {
            res.push(className);
        }, function (className) {
            // not catered for, if creating, no need
            // to remove class as it was never there
        });
        return res;
    };
    RowCssClassCalculator.prototype.processRowClassRules = function (rowNode, scope, onApplicableClass, onNotApplicableClass) {
        var rowClassParams = {
            data: rowNode.data,
            node: rowNode,
            rowIndex: rowNode.rowIndex,
            api: this.gridOptionsWrapper.getApi(),
            columnApi: this.gridOptionsWrapper.getColumnApi(),
            $scope: scope,
            context: this.gridOptionsWrapper.getContext()
        };
        this.stylingService.processClassRules(this.gridOptionsWrapper.rowClassRules(), rowClassParams, onApplicableClass, onNotApplicableClass);
    };
    RowCssClassCalculator.prototype.calculateRowLevel = function (rowNode) {
        if (rowNode.group) {
            return rowNode.level;
        }
        // if a leaf, and a parent exists, put a level of the parent, else put level of 0 for top level item
        return rowNode.parent ? (rowNode.parent.level + 1) : 0;
    };
    rowCssClassCalculator_decorate([
        Object(context_context["a" /* Autowired */])('stylingService')
    ], RowCssClassCalculator.prototype, "stylingService", void 0);
    rowCssClassCalculator_decorate([
        Object(context_context["a" /* Autowired */])('gridOptionsWrapper')
    ], RowCssClassCalculator.prototype, "gridOptionsWrapper", void 0);
    RowCssClassCalculator = rowCssClassCalculator_decorate([
        Object(context_context["b" /* Bean */])('rowCssClassCalculator')
    ], RowCssClassCalculator);
    return RowCssClassCalculator;
}());


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rowNodeCache/rowNodeBlockLoader.js
var rowNodeBlockLoader = __webpack_require__("571b");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rowNodes/rowNodeSorter.js
var rowNodeSorter = __webpack_require__("68a7");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/ctrlsService.js
var ctrlsService = __webpack_require__("102e");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/ctrlsFactory.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var ctrlsFactory_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ctrlsFactory_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var ctrlsFactory_CtrlsFactory = /** @class */ (function (_super) {
    ctrlsFactory_extends(CtrlsFactory, _super);
    function CtrlsFactory() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.registry = {};
        return _this;
    }
    CtrlsFactory.prototype.register = function (meta) {
        this.registry[meta.controllerName] = meta.controllerClass;
    };
    CtrlsFactory.prototype.getInstance = function (name) {
        var ControllerClass = this.registry[name];
        if (ControllerClass == null) {
            return undefined;
        }
        return new ControllerClass();
    };
    CtrlsFactory = ctrlsFactory_decorate([
        Object(context_context["b" /* Bean */])('ctrlsFactory')
    ], CtrlsFactory);
    return CtrlsFactory;
}(beanStub["a" /* BeanStub */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/fakeHScrollCtrl.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var fakeHScrollCtrl_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var fakeHScrollCtrl_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var fakeHScrollCtrl_FakeHScrollCtrl = /** @class */ (function (_super) {
    fakeHScrollCtrl_extends(FakeHScrollCtrl, _super);
    function FakeHScrollCtrl() {
        return _super.call(this) || this;
    }
    FakeHScrollCtrl.prototype.setComp = function (view, eGui, eViewport, eContainer) {
        this.view = view;
        this.eViewport = eViewport;
        this.eContainer = eContainer;
        this.eGui = eGui;
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_SCROLL_VISIBILITY_CHANGED, this.onScrollVisibilityChanged.bind(this));
        this.onScrollVisibilityChanged();
        // When doing printing, this changes whether cols are pinned or not
        var spacerWidthsListener = this.setFakeHScrollSpacerWidths.bind(this);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_DISPLAYED_COLUMNS_CHANGED, spacerWidthsListener);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED, spacerWidthsListener);
        this.addManagedListener(this.gridOptionsWrapper, gridOptionsWrapper["a" /* GridOptionsWrapper */].PROP_DOM_LAYOUT, spacerWidthsListener);
        this.setFakeHScrollSpacerWidths();
        if (this.invisibleScrollbar) {
            this.hideAndShowInvisibleScrollAsNeeded();
            this.addActiveListenerToggles();
        }
        this.ctrlsService.registerFakeHScrollCtrl(this);
    };
    FakeHScrollCtrl.prototype.addActiveListenerToggles = function () {
        var _this = this;
        var activateEvents = ['mouseenter', 'mousedown', 'touchstart'];
        var deactivateEvents = ['mouseleave', 'mouseup', 'touchend'];
        activateEvents.forEach(function (eventName) { return _this.addManagedListener(_this.eGui, eventName, function () { return _this.view.addOrRemoveCssClass('ag-scrollbar-active', true); }); });
        deactivateEvents.forEach(function (eventName) { return _this.addManagedListener(_this.eGui, eventName, function () { return _this.view.addOrRemoveCssClass('ag-scrollbar-active', false); }); });
    };
    FakeHScrollCtrl.prototype.postConstruct = function () {
        this.enableRtl = this.gridOptionsWrapper.isEnableRtl();
        this.invisibleScrollbar = Object(browser["isInvisibleScrollbar"])();
    };
    FakeHScrollCtrl.prototype.onScrollVisibilityChanged = function () {
        this.setScrollVisible();
        this.setFakeHScrollSpacerWidths();
    };
    FakeHScrollCtrl.prototype.hideAndShowInvisibleScrollAsNeeded = function () {
        var _this = this;
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_BODY_SCROLL, function (params) {
            if (params.direction === 'horizontal') {
                _this.view.addOrRemoveCssClass('ag-scrollbar-scrolling', true);
            }
        });
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_BODY_SCROLL_END, function () { return _this.view.addOrRemoveCssClass('ag-scrollbar-scrolling', false); });
    };
    FakeHScrollCtrl.prototype.setFakeHScrollSpacerWidths = function () {
        var vScrollShowing = this.scrollVisibleService.isVerticalScrollShowing();
        // we pad the right based on a) if cols are pinned to the right and
        // b) if v scroll is showing on the right (normal position of scroll)
        var rightSpacing = this.columnModel.getDisplayedColumnsRightWidth();
        var scrollOnRight = !this.enableRtl && vScrollShowing;
        var scrollbarWidth = this.gridOptionsWrapper.getScrollbarWidth();
        if (scrollOnRight) {
            rightSpacing += scrollbarWidth;
        }
        this.view.setRightSpacerFixedWidth(rightSpacing);
        this.view.includeRightSpacerScrollerCss('ag-scroller-corner', rightSpacing <= scrollbarWidth);
        // we pad the left based on a) if cols are pinned to the left and
        // b) if v scroll is showing on the left (happens in LTR layout only)
        var leftSpacing = this.columnModel.getDisplayedColumnsLeftWidth();
        var scrollOnLeft = this.enableRtl && vScrollShowing;
        if (scrollOnLeft) {
            leftSpacing += scrollbarWidth;
        }
        this.view.setLeftSpacerFixedWidth(leftSpacing);
        this.view.includeLeftSpacerScrollerCss('ag-scroller-corner', leftSpacing <= scrollbarWidth);
    };
    FakeHScrollCtrl.prototype.setScrollVisible = function () {
        var hScrollShowing = this.scrollVisibleService.isHorizontalScrollShowing();
        var invisibleScrollbar = this.invisibleScrollbar;
        var isSuppressHorizontalScroll = this.gridOptionsWrapper.isSuppressHorizontalScroll();
        var scrollbarWidth = hScrollShowing ? (this.gridOptionsWrapper.getScrollbarWidth() || 0) : 0;
        var adjustedScrollbarWidth = (scrollbarWidth === 0 && invisibleScrollbar) ? 15 : scrollbarWidth;
        var scrollContainerSize = !isSuppressHorizontalScroll ? adjustedScrollbarWidth : 0;
        var addIEPadding = Object(browser["isBrowserIE"])() && hScrollShowing;
        this.view.addOrRemoveCssClass('ag-scrollbar-invisible', invisibleScrollbar);
        this.view.setHeight(scrollContainerSize);
        // we have to add an extra pixel to the scroller viewport on IE because
        // if the container has the same size as the scrollbar, the scroll button won't work
        this.view.setViewportHeight(scrollContainerSize + (addIEPadding ? 1 : 0));
        this.view.setContainerHeight(scrollContainerSize);
    };
    FakeHScrollCtrl.prototype.getViewport = function () {
        return this.eViewport;
    };
    FakeHScrollCtrl.prototype.getContainer = function () {
        return this.eContainer;
    };
    fakeHScrollCtrl_decorate([
        Object(context_context["a" /* Autowired */])('scrollVisibleService')
    ], FakeHScrollCtrl.prototype, "scrollVisibleService", void 0);
    fakeHScrollCtrl_decorate([
        Object(context_context["a" /* Autowired */])('columnModel')
    ], FakeHScrollCtrl.prototype, "columnModel", void 0);
    fakeHScrollCtrl_decorate([
        Object(context_context["a" /* Autowired */])('ctrlsService')
    ], FakeHScrollCtrl.prototype, "ctrlsService", void 0);
    fakeHScrollCtrl_decorate([
        context_context["e" /* PostConstruct */]
    ], FakeHScrollCtrl.prototype, "postConstruct", null);
    return FakeHScrollCtrl;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/centerWidthFeature.js
var centerWidthFeature = __webpack_require__("dae3");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/fakeHScrollComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var fakeHScrollComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var fakeHScrollComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var fakeHScrollComp_FakeHScrollComp = /** @class */ (function (_super) {
    fakeHScrollComp_extends(FakeHScrollComp, _super);
    function FakeHScrollComp() {
        return _super.call(this, FakeHScrollComp.TEMPLATE) || this;
    }
    FakeHScrollComp.prototype.postConstruct = function () {
        var _this = this;
        var compProxy = {
            addOrRemoveCssClass: function (cssClassName, on) { return _this.addOrRemoveCssClass(cssClassName, on); },
            setHeight: function (height) { return Object(dom["setFixedHeight"])(_this.getGui(), height); },
            setContainerHeight: function (height) { return Object(dom["setFixedHeight"])(_this.eContainer, height); },
            setViewportHeight: function (height) { return Object(dom["setFixedHeight"])(_this.eViewport, height); },
            setRightSpacerFixedWidth: function (width) { return Object(dom["setFixedWidth"])(_this.eRightSpacer, width); },
            setLeftSpacerFixedWidth: function (width) { return Object(dom["setFixedWidth"])(_this.eLeftSpacer, width); },
            includeLeftSpacerScrollerCss: function (cssClass, include) {
                return Object(dom["addOrRemoveCssClass"])(_this.eLeftSpacer, cssClass, include);
            },
            includeRightSpacerScrollerCss: function (cssClass, include) {
                return Object(dom["addOrRemoveCssClass"])(_this.eRightSpacer, cssClass, include);
            },
        };
        var ctrl = this.createManagedBean(new fakeHScrollCtrl_FakeHScrollCtrl());
        ctrl.setComp(compProxy, this.getGui(), this.eViewport, this.eContainer);
        this.createManagedBean(new centerWidthFeature["a" /* CenterWidthFeature */](function (width) { return _this.eContainer.style.width = width + "px"; }));
    };
    FakeHScrollComp.TEMPLATE = "<div class=\"ag-body-horizontal-scroll\" aria-hidden=\"true\">\n            <div class=\"ag-horizontal-left-spacer\" ref=\"eLeftSpacer\"></div>\n            <div class=\"ag-body-horizontal-scroll-viewport\" ref=\"eViewport\">\n                <div class=\"ag-body-horizontal-scroll-container\" ref=\"eContainer\"></div>\n            </div>\n            <div class=\"ag-horizontal-right-spacer\" ref=\"eRightSpacer\"></div>\n        </div>";
    fakeHScrollComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eLeftSpacer')
    ], FakeHScrollComp.prototype, "eLeftSpacer", void 0);
    fakeHScrollComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eRightSpacer')
    ], FakeHScrollComp.prototype, "eRightSpacer", void 0);
    fakeHScrollComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eViewport')
    ], FakeHScrollComp.prototype, "eViewport", void 0);
    fakeHScrollComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eContainer')
    ], FakeHScrollComp.prototype, "eContainer", void 0);
    fakeHScrollComp_decorate([
        context_context["e" /* PostConstruct */]
    ], FakeHScrollComp.prototype, "postConstruct", null);
    return FakeHScrollComp;
}(component["a" /* Component */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/pinnedWidthService.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var pinnedWidthService_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var pinnedWidthService_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var pinnedWidthService_PinnedWidthService = /** @class */ (function (_super) {
    pinnedWidthService_extends(PinnedWidthService, _super);
    function PinnedWidthService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PinnedWidthService.prototype.postConstruct = function () {
        var listener = this.checkContainerWidths.bind(this);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_DISPLAYED_COLUMNS_CHANGED, listener);
        this.addManagedListener(this.eventService, eventKeys["a" /* Events */].EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED, listener);
        this.addManagedListener(this.gridOptionsWrapper, gridOptionsWrapper["a" /* GridOptionsWrapper */].PROP_DOM_LAYOUT, listener);
    };
    PinnedWidthService.prototype.checkContainerWidths = function () {
        var printLayout = this.gridOptionsWrapper.getDomLayout() === constants["a" /* Constants */].DOM_LAYOUT_PRINT;
        var newLeftWidth = printLayout ? 0 : this.columnModel.getDisplayedColumnsLeftWidth();
        var newRightWidth = printLayout ? 0 : this.columnModel.getDisplayedColumnsRightWidth();
        if (newLeftWidth != this.leftWidth) {
            this.leftWidth = newLeftWidth;
            this.eventService.dispatchEvent({ type: eventKeys["a" /* Events */].EVENT_LEFT_PINNED_WIDTH_CHANGED });
        }
        if (newRightWidth != this.rightWidth) {
            this.rightWidth = newRightWidth;
            this.eventService.dispatchEvent({ type: eventKeys["a" /* Events */].EVENT_RIGHT_PINNED_WIDTH_CHANGED });
        }
    };
    PinnedWidthService.prototype.getPinnedRightWidth = function () {
        return this.rightWidth;
    };
    PinnedWidthService.prototype.getPinnedLeftWidth = function () {
        return this.leftWidth;
    };
    pinnedWidthService_decorate([
        Object(context_context["a" /* Autowired */])('columnModel')
    ], PinnedWidthService.prototype, "columnModel", void 0);
    pinnedWidthService_decorate([
        context_context["e" /* PostConstruct */]
    ], PinnedWidthService.prototype, "postConstruct", null);
    PinnedWidthService = pinnedWidthService_decorate([
        Object(context_context["b" /* Bean */])('pinnedWidthService')
    ], PinnedWidthService);
    return PinnedWidthService;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/gridBodyComp/rowContainer/rowContainerComp.js + 1 modules
var rowContainerComp = __webpack_require__("f0ea");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/rowNodeEventThrottle.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var rowNodeEventThrottle_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var rowNodeEventThrottle_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var rowNodeEventThrottle_RowNodeEventThrottle = /** @class */ (function (_super) {
    rowNodeEventThrottle_extends(RowNodeEventThrottle, _super);
    function RowNodeEventThrottle() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.events = [];
        return _this;
    }
    RowNodeEventThrottle.prototype.postConstruct = function () {
        if (this.rowModel.getType() == constants["a" /* Constants */].ROW_MODEL_TYPE_CLIENT_SIDE) {
            this.clientSideRowModel = this.rowModel;
        }
    };
    // because the user can call rowNode.setExpanded() many times in one VM turn,
    // we throttle the calls to ClientSideRowModel using animationFrameService. this means for 100
    // row nodes getting expanded, we only update the CSRM once, and then we fire all events after
    // CSRM has updated.
    // 
    // if we did not do this, then the user could call setExpanded on 100+ rows, causing the grid
    // to re-render 100+ times, which would be a performance lag.
    //    
    // we use animationFrameService
    // rather than _.debounce() so this will get done if anyone flushes the animationFrameService
    // (eg user calls api.ensureRowVisible(), which in turn flushes ).
    RowNodeEventThrottle.prototype.dispatchExpanded = function (event) {
        var _this = this;
        this.events.push(event);
        if (this.dispatchExpandedDebounced == null) {
            this.dispatchExpandedDebounced = this.animationFrameService.debounce(function () {
                _this.clientSideRowModel && _this.clientSideRowModel.onRowGroupOpened();
                _this.events.forEach(function (e) { return _this.eventService.dispatchEvent(e); });
                _this.events = [];
            });
        }
        this.dispatchExpandedDebounced();
    };
    rowNodeEventThrottle_decorate([
        Object(context_context["a" /* Autowired */])('animationFrameService')
    ], RowNodeEventThrottle.prototype, "animationFrameService", void 0);
    rowNodeEventThrottle_decorate([
        Object(context_context["a" /* Autowired */])('rowModel')
    ], RowNodeEventThrottle.prototype, "rowModel", void 0);
    rowNodeEventThrottle_decorate([
        context_context["e" /* PostConstruct */]
    ], RowNodeEventThrottle.prototype, "postConstruct", null);
    RowNodeEventThrottle = rowNodeEventThrottle_decorate([
        Object(context_context["b" /* Bean */])('rowNodeEventThrottle')
    ], RowNodeEventThrottle);
    return RowNodeEventThrottle;
}(beanStub["a" /* BeanStub */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/column/standardMenu.js
var standardMenu = __webpack_require__("fc41");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/grid.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */



























































































// creates JavaScript vanilla Grid, including JavaScript (ag-stack) components, which can
// be wrapped by the framework wrappers
var grid_Grid = /** @class */ (function () {
    function Grid(eGridDiv, gridOptions, params) {
        if (!gridOptions) {
            console.error('AG Grid: no gridOptions provided to the grid');
            return;
        }
        this.gridOptions = gridOptions;
        new grid_GridCoreCreator().create(eGridDiv, gridOptions, function (context) {
            var gridComp = new gridComp_gridComp["a" /* GridComp */](eGridDiv);
            context.createBean(gridComp);
        }, params);
    }
    Grid.prototype.destroy = function () {
        if (this.gridOptions && this.gridOptions.api) {
            this.gridOptions.api.destroy();
        }
    };
    return Grid;
}());

// created services of grid only, no UI, so frameworks can use this if providing
// their own UI
var grid_GridCoreCreator = /** @class */ (function () {
    function GridCoreCreator() {
    }
    GridCoreCreator.prototype.create = function (eGridDiv, gridOptions, uiCallback, params) {
        var _this = this;
        var debug = !!gridOptions.debug;
        var registeredModules = this.getRegisteredModules(params);
        var beanClasses = this.createBeansList(gridOptions.rowModelType, registeredModules);
        var providedBeanInstances = this.createProvidedBeans(eGridDiv, gridOptions, params);
        if (!beanClasses) {
            return;
        } // happens when no row model found
        var contextParams = {
            providedBeanInstances: providedBeanInstances,
            beanClasses: beanClasses,
            debug: debug
        };
        var logger = new es6_logger["a" /* Logger */]('AG Grid', function () { return gridOptions.debug; });
        var contextLogger = new es6_logger["a" /* Logger */]('Context', function () { return contextParams.debug; });
        var context = new context_context["c" /* Context */](contextParams, contextLogger);
        var beans = context.getBean('beans');
        this.registerModuleUserComponents(beans, registeredModules);
        this.registerStackComponents(beans, registeredModules);
        this.registerControllers(beans, registeredModules);
        uiCallback(context);
        // we wait until the UI has finished initialising before setting in columns and rows
        beans.ctrlsService.whenReady(function () {
            _this.setColumnsAndData(beans);
            _this.dispatchGridReadyEvent(beans, gridOptions);
            var isEnterprise = moduleRegistry["a" /* ModuleRegistry */].isRegistered(moduleNames["a" /* ModuleNames */].EnterpriseCoreModule);
            logger.log("initialised successfully, enterprise = " + isEnterprise);
        });
    };
    GridCoreCreator.prototype.registerControllers = function (beans, registeredModules) {
        registeredModules.forEach(function (module) {
            module.controllers && module.controllers.forEach(function (meta) { return beans.ctrlsFactory.register(meta); });
        });
    };
    GridCoreCreator.prototype.registerStackComponents = function (beans, registeredModules) {
        var agStackComponents = this.createAgStackComponentsList(registeredModules);
        beans.agStackComponentsRegistry.setupComponents(agStackComponents);
    };
    GridCoreCreator.prototype.getRegisteredModules = function (params) {
        var passedViaConstructor = params ? params.modules : null;
        var registered = moduleRegistry["a" /* ModuleRegistry */].getRegisteredModules();
        var allModules = [];
        var mapNames = {};
        // adds to list and removes duplicates
        function addModule(moduleBased, mod) {
            function addIndividualModule(currentModule) {
                if (!mapNames[currentModule.moduleName]) {
                    mapNames[currentModule.moduleName] = true;
                    allModules.push(currentModule);
                    moduleRegistry["a" /* ModuleRegistry */].register(currentModule, moduleBased);
                }
            }
            addIndividualModule(mod);
            if (mod.dependantModules) {
                mod.dependantModules.forEach(addModule.bind(null, moduleBased));
            }
        }
        if (passedViaConstructor) {
            passedViaConstructor.forEach(addModule.bind(null, true));
        }
        if (registered) {
            registered.forEach(addModule.bind(null, !moduleRegistry["a" /* ModuleRegistry */].isPackageBased()));
        }
        return allModules;
    };
    GridCoreCreator.prototype.registerModuleUserComponents = function (beans, registeredModules) {
        var moduleUserComps = this.extractModuleEntity(registeredModules, function (module) { return module.userComponents ? module.userComponents : []; });
        moduleUserComps.forEach(function (compMeta) {
            beans.userComponentRegistry.registerDefaultComponent(compMeta.componentName, compMeta.componentClass);
        });
    };
    GridCoreCreator.prototype.createProvidedBeans = function (eGridDiv, gridOptions, params) {
        var frameworkOverrides = params ? params.frameworkOverrides : null;
        if (Object(generic["missing"])(frameworkOverrides)) {
            frameworkOverrides = new vanillaFrameworkOverrides["a" /* VanillaFrameworkOverrides */]();
        }
        var seed = {
            gridOptions: gridOptions,
            eGridDiv: eGridDiv,
            $scope: params ? params.$scope : null,
            $compile: params ? params.$compile : null,
            globalEventListener: params ? params.globalEventListener : null,
            frameworkOverrides: frameworkOverrides
        };
        if (params && params.providedBeanInstances) {
            Object(object["assign"])(seed, params.providedBeanInstances);
        }
        return seed;
    };
    GridCoreCreator.prototype.createAgStackComponentsList = function (registeredModules) {
        var components = [
            { componentName: 'AgCheckbox', componentClass: agCheckbox["a" /* AgCheckbox */] },
            { componentName: 'AgRadioButton', componentClass: agRadioButton["a" /* AgRadioButton */] },
            { componentName: 'AgToggleButton', componentClass: agToggleButton["a" /* AgToggleButton */] },
            { componentName: 'AgInputTextField', componentClass: agInputTextField["a" /* AgInputTextField */] },
            { componentName: 'AgInputTextArea', componentClass: agInputTextArea["a" /* AgInputTextArea */] },
            { componentName: 'AgInputNumberField', componentClass: agInputNumberField["a" /* AgInputNumberField */] },
            { componentName: 'AgInputRange', componentClass: agInputRange["a" /* AgInputRange */] },
            { componentName: 'AgSelect', componentClass: agSelect["a" /* AgSelect */] },
            { componentName: 'AgSlider', componentClass: agSlider["a" /* AgSlider */] },
            { componentName: 'AgAngleSelect', componentClass: agAngleSelect["a" /* AgAngleSelect */] },
            { componentName: 'AgColorPicker', componentClass: agColorPicker["a" /* AgColorPicker */] },
            { componentName: 'AgGridBody', componentClass: gridBodyComp["a" /* GridBodyComp */] },
            { componentName: 'AgHeaderRoot', componentClass: gridHeaderComp["a" /* GridHeaderComp */] },
            { componentName: 'AgPagination', componentClass: paginationComp_PaginationComp },
            { componentName: 'AgOverlayWrapper', componentClass: overlayWrapperComponent_OverlayWrapperComponent },
            { componentName: 'AgGroupComponent', componentClass: agGroupComponent["a" /* AgGroupComponent */] },
            { componentName: 'AgPanel', componentClass: agPanel["a" /* AgPanel */] },
            { componentName: 'AgDialog', componentClass: agDialog["a" /* AgDialog */] },
            { componentName: 'AgRowContainer', componentClass: rowContainerComp["a" /* RowContainerComp */] },
            { componentName: 'AgFakeHorizontalScroll', componentClass: fakeHScrollComp_FakeHScrollComp }
        ];
        var moduleAgStackComps = this.extractModuleEntity(registeredModules, function (module) { return module.agStackComponents ? module.agStackComponents : []; });
        components = components.concat(moduleAgStackComps);
        return components;
    };
    GridCoreCreator.prototype.createBeansList = function (rowModelType, registeredModules) {
        var rowModelClass = this.getRowModelClass(rowModelType, registeredModules);
        if (!rowModelClass) {
            return;
        }
        // beans should only contain SERVICES, it should NEVER contain COMPONENTS
        var beans = [
            rowModelClass, rendering_beans["a" /* Beans */], rowPosition["a" /* RowPositionUtils */], cellPosition["a" /* CellPositionUtils */], headerPosition["a" /* HeaderPositionUtils */],
            paginationAutoPageSizeService_PaginationAutoPageSizeService, gridApi["a" /* GridApi */], userComponentRegistry["a" /* UserComponentRegistry */], agComponentUtils_AgComponentUtils,
            componentMetadataProvider_ComponentMetadataProvider, resizeObserverService["a" /* ResizeObserverService */], userComponentFactory["a" /* UserComponentFactory */],
            rowContainerHeightService_RowContainerHeightService, horizontalResizeService["a" /* HorizontalResizeService */],
            pinnedRowModel["a" /* PinnedRowModel */], dragService["a" /* DragService */], displayedGroupCreator["a" /* DisplayedGroupCreator */], eventService["a" /* EventService */], gridOptionsWrapper["a" /* GridOptionsWrapper */],
            popupService["a" /* PopupService */], selectionService["a" /* SelectionService */], filterManager["a" /* FilterManager */], columnModel["a" /* ColumnModel */], headerNavigationService["b" /* HeaderNavigationService */],
            paginationProxy["a" /* PaginationProxy */], rowRenderer["a" /* RowRenderer */], expressionService["a" /* ExpressionService */], columnFactory["a" /* ColumnFactory */], templateService["a" /* TemplateService */],
            alignedGridsService["a" /* AlignedGridsService */], navigationService["a" /* NavigationService */], valueCache["a" /* ValueCache */], valueService["a" /* ValueService */], es6_logger["b" /* LoggerFactory */],
            columnUtils["a" /* ColumnUtils */], autoWidthCalculator["a" /* AutoWidthCalculator */], standardMenu["a" /* StandardMenuFactory */], dragAndDropService["a" /* DragAndDropService */], columnApi["a" /* ColumnApi */],
            focusService["a" /* FocusService */], mouseEventService["a" /* MouseEventService */], environment["a" /* Environment */], cellNavigationService["a" /* CellNavigationService */], valueFormatterService["a" /* ValueFormatterService */],
            stylingService["a" /* StylingService */], scrollVisibleService["a" /* ScrollVisibleService */], sortController["a" /* SortController */], columnHoverService_ColumnHoverService, columnAnimationService_ColumnAnimationService,
            selectableService["a" /* SelectableService */], autoGroupColService_AutoGroupColService, changeDetectionService_ChangeDetectionService, animationFrameService["a" /* AnimationFrameService */],
            undoRedoService_UndoRedoService, agStackComponentsRegistry["a" /* AgStackComponentsRegistry */], columnDefFactory_ColumnDefFactory,
            rowCssClassCalculator_RowCssClassCalculator, rowNodeBlockLoader["a" /* RowNodeBlockLoader */], rowNodeSorter["a" /* RowNodeSorter */], ctrlsService["a" /* CtrlsService */],
            pinnedWidthService_PinnedWidthService, rowNodeEventThrottle_RowNodeEventThrottle, ctrlsFactory_CtrlsFactory
        ];
        var moduleBeans = this.extractModuleEntity(registeredModules, function (module) { return module.beans ? module.beans : []; });
        beans.push.apply(beans, moduleBeans);
        // check for duplicates, as different modules could include the same beans that
        // they depend on, eg ClientSideRowModel in enterprise, and ClientSideRowModel in community
        var beansNoDuplicates = [];
        beans.forEach(function (bean) {
            if (beansNoDuplicates.indexOf(bean) < 0) {
                beansNoDuplicates.push(bean);
            }
        });
        return beansNoDuplicates;
    };
    GridCoreCreator.prototype.extractModuleEntity = function (moduleEntities, extractor) {
        return [].concat.apply([], moduleEntities.map(extractor));
    };
    GridCoreCreator.prototype.setColumnsAndData = function (beans) {
        var columnDefs = beans.gridOptionsWrapper.getColumnDefs();
        beans.columnModel.setColumnDefs(columnDefs || [], "gridInitializing");
        beans.rowModel.start();
    };
    GridCoreCreator.prototype.dispatchGridReadyEvent = function (beans, gridOptions) {
        var readyEvent = {
            type: events["a" /* Events */].EVENT_GRID_READY,
            api: gridOptions.api,
            columnApi: gridOptions.columnApi
        };
        beans.eventService.dispatchEvent(readyEvent);
    };
    GridCoreCreator.prototype.getRowModelClass = function (rowModelType, registeredModules) {
        // default to client side
        if (!rowModelType) {
            rowModelType = constants["a" /* Constants */].ROW_MODEL_TYPE_CLIENT_SIDE;
        }
        var rowModelClasses = {};
        registeredModules.forEach(function (module) {
            Object(object["iterateObject"])(module.rowModels, function (key, value) {
                rowModelClasses[key] = value;
            });
        });
        var rowModelClass = rowModelClasses[rowModelType];
        if (Object(generic["exists"])(rowModelClass)) {
            return rowModelClass;
        }
        if (rowModelType === constants["a" /* Constants */].ROW_MODEL_TYPE_INFINITE) {
            console.error("AG Grid: Row Model \"Infinite\" not found. Please ensure the " + moduleNames["a" /* ModuleNames */].InfiniteRowModelModule + " is registered.';");
        }
        console.error('AG Grid: could not find matching row model for rowModelType ' + rowModelType);
        if (rowModelType === constants["a" /* Constants */].ROW_MODEL_TYPE_VIEWPORT) {
            console.error("AG Grid: Row Model \"Viewport\" not found. Please ensure the AG Grid Enterprise Module " + moduleNames["a" /* ModuleNames */].ViewportRowModelModule + " is registered.';");
        }
        if (rowModelType === constants["a" /* Constants */].ROW_MODEL_TYPE_SERVER_SIDE) {
            console.error("AG Grid: Row Model \"Server Side\" not found. Please ensure the AG Grid Enterprise Module " + moduleNames["a" /* ModuleNames */].ServerSideRowModelModule + " is registered.';");
        }
        if (rowModelType === constants["a" /* Constants */].ROW_MODEL_TYPE_CLIENT_SIDE) {
            console.error("AG Grid: Row Model \"Client Side\" not found. Please ensure the " + moduleNames["a" /* ModuleNames */].ClientSideRowModelModule + " is registered.';");
        }
    };
    return GridCoreCreator;
}());



/***/ }),

/***/ "2c7d":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ModuleRegistry; });
/* harmony import */ var _utils_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("e900");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */


var ModuleRegistry = /** @class */ (function () {
    function ModuleRegistry() {
    }
    ModuleRegistry.register = function (module, moduleBased) {
        if (moduleBased === void 0) { moduleBased = true; }
        ModuleRegistry.modulesMap[module.moduleName] = module;
        if (ModuleRegistry.moduleBased === undefined) {
            ModuleRegistry.moduleBased = moduleBased;
        }
        else {
            if (ModuleRegistry.moduleBased !== moduleBased) {
                Object(_utils_function__WEBPACK_IMPORTED_MODULE_0__["doOnce"])(function () {
                    console.warn("AG Grid: You are mixing modules (i.e. @ag-grid-community/core) and packages (ag-grid-community) - you can only use one or the other of these mechanisms.");
                    console.warn('Please see https://www.ag-grid.com/javascript-grid/packages-modules/ for more information.');
                }, 'ModulePackageCheck');
            }
        }
    };
    // noinspection JSUnusedGlobalSymbols
    ModuleRegistry.registerModules = function (modules, moduleBased) {
        if (moduleBased === void 0) { moduleBased = true; }
        if (!modules) {
            return;
        }
        modules.forEach(function (module) { return ModuleRegistry.register(module, moduleBased); });
    };
    ModuleRegistry.assertRegistered = function (moduleName, reason) {
        if (this.isRegistered(moduleName)) {
            return true;
        }
        var warningKey = reason + moduleName;
        var warningMessage = "AG Grid: unable to use " + reason + " as module " + moduleName + " is not present. Please see: https://www.ag-grid.com/javascript-grid/modules/";
        Object(_utils_function__WEBPACK_IMPORTED_MODULE_0__["doOnce"])(function () {
            console.warn(warningMessage);
        }, warningKey);
        return false;
    };
    ModuleRegistry.isRegistered = function (moduleName) {
        return !!ModuleRegistry.modulesMap[moduleName];
    };
    ModuleRegistry.getRegisteredModules = function () {
        return Object(_utils_generic__WEBPACK_IMPORTED_MODULE_1__["values"])(ModuleRegistry.modulesMap);
    };
    ModuleRegistry.isPackageBased = function () {
        return !ModuleRegistry.moduleBased;
    };
    // having in a map a) removes duplicates and b) allows fast lookup
    ModuleRegistry.modulesMap = {};
    return ModuleRegistry;
}());



/***/ }),

/***/ "2ce1":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ HeaderRowType; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ headerRowComp_HeaderRowComp; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/aria.js
var aria = __webpack_require__("3348");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/object.js
var object = __webpack_require__("562d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/componentAnnotations.js
var componentAnnotations = __webpack_require__("6835");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/abstractCell/abstractHeaderCellComp.js
var abstractHeaderCellComp = __webpack_require__("1438");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/column/headerCellComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var headerCellComp_HeaderCellComp = /** @class */ (function (_super) {
    __extends(HeaderCellComp, _super);
    function HeaderCellComp(ctrl) {
        var _this = _super.call(this, HeaderCellComp.TEMPLATE, ctrl) || this;
        _this.headerCompVersion = 0;
        _this.column = ctrl.getColumnGroupChild();
        _this.pinned = ctrl.getPinned();
        return _this;
    }
    HeaderCellComp.prototype.postConstruct = function () {
        var _this = this;
        var eGui = this.getGui();
        var setAttribute = function (name, value, element) {
            var actualElement = element ? element : eGui;
            if (value != null && value != '') {
                actualElement.setAttribute(name, value);
            }
            else {
                actualElement.removeAttribute(name);
            }
        };
        var compProxy = {
            setWidth: function (width) { return eGui.style.width = width; },
            addOrRemoveCssClass: function (cssClassName, on) { return _this.addOrRemoveCssClass(cssClassName, on); },
            setAriaSort: function (sort) { return sort ? Object(aria["setAriaSort"])(eGui, sort) : Object(aria["removeAriaSort"])(eGui); },
            setColId: function (id) { return setAttribute('col-id', id); },
            setTitle: function (title) { return setAttribute('title', title); },
            setAriaDescribedBy: function (value) { return Object(aria["setAriaDescribedBy"])(eGui, value); },
            setUserCompDetails: function (compDetails) { return _this.setUserCompDetails(compDetails); },
            getUserCompInstance: function () { return _this.headerComp; }
        };
        this.ctrl.setComp(compProxy, this.getGui(), this.eResize);
        var selectAllGui = this.ctrl.getSelectAllGui();
        this.eResize.insertAdjacentElement('afterend', selectAllGui);
    };
    HeaderCellComp.prototype.destroyHeaderComp = function () {
        if (this.headerComp) {
            this.getGui().removeChild(this.headerCompGui);
            this.headerComp = this.destroyBean(this.headerComp);
            this.headerCompGui = undefined;
        }
    };
    HeaderCellComp.prototype.setUserCompDetails = function (compDetails) {
        var _this = this;
        this.headerCompVersion++;
        var versionCopy = this.headerCompVersion;
        var callback = this.afterHeaderCompCreated.bind(this, this.headerCompVersion);
        this.userComponentFactory.createInstanceFromCompDetails(compDetails).then(function (comp) {
            _this.afterHeaderCompCreated(versionCopy, comp);
        });
    };
    HeaderCellComp.prototype.afterHeaderCompCreated = function (version, headerComp) {
        if (version != this.headerCompVersion || !this.isAlive()) {
            this.destroyBean(headerComp);
            return;
        }
        this.destroyHeaderComp();
        this.headerComp = headerComp;
        this.headerCompGui = headerComp.getGui();
        this.getGui().appendChild(this.headerCompGui);
        this.ctrl.setDragSource(this.headerCompGui);
    };
    HeaderCellComp.TEMPLATE = "<div class=\"ag-header-cell\" role=\"columnheader\" unselectable=\"on\" tabindex=\"-1\">\n            <div ref=\"eResize\" class=\"ag-header-cell-resize\" role=\"presentation\"></div>\n        </div>";
    __decorate([
        Object(context["a" /* Autowired */])('userComponentFactory')
    ], HeaderCellComp.prototype, "userComponentFactory", void 0);
    __decorate([
        Object(context["a" /* Autowired */])('beans')
    ], HeaderCellComp.prototype, "beans", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eResize')
    ], HeaderCellComp.prototype, "eResize", void 0);
    __decorate([
        context["e" /* PostConstruct */]
    ], HeaderCellComp.prototype, "postConstruct", null);
    __decorate([
        context["g" /* PreDestroy */]
    ], HeaderCellComp.prototype, "destroyHeaderComp", null);
    return HeaderCellComp;
}(abstractHeaderCellComp["a" /* AbstractHeaderCellComp */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/columnGroup/headerGroupCellComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var headerGroupCellComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var headerGroupCellComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var headerGroupCellComp_HeaderGroupCellComp = /** @class */ (function (_super) {
    headerGroupCellComp_extends(HeaderGroupCellComp, _super);
    function HeaderGroupCellComp(ctrl) {
        return _super.call(this, HeaderGroupCellComp.TEMPLATE, ctrl) || this;
    }
    HeaderGroupCellComp.prototype.postConstruct = function () {
        var _this = this;
        var eGui = this.getGui();
        var setAttribute = function (key, value) {
            return value != undefined ? eGui.setAttribute(key, value) : eGui.removeAttribute(key);
        };
        var compProxy = {
            addOrRemoveCssClass: function (cssClassName, on) { return _this.addOrRemoveCssClass(cssClassName, on); },
            addOrRemoveResizableCssClass: function (cssClassName, on) { return Object(dom["addOrRemoveCssClass"])(_this.eResize, cssClassName, on); },
            setWidth: function (width) { return eGui.style.width = width; },
            setColId: function (id) { return eGui.setAttribute("col-id", id); },
            setAriaExpanded: function (expanded) { return setAttribute('aria-expanded', expanded); },
            setTitle: function (title) { return setAttribute("title", title); },
            setUserCompDetails: function (details) { return _this.setUserCompDetails(details); }
        };
        this.ctrl.setComp(compProxy, eGui, this.eResize);
    };
    HeaderGroupCellComp.prototype.setUserCompDetails = function (details) {
        var _this = this;
        this.userComponentFactory.createInstanceFromCompDetails(details)
            .then(function (comp) { return _this.afterHeaderCompCreated(comp); });
    };
    HeaderGroupCellComp.prototype.afterHeaderCompCreated = function (headerGroupComp) {
        var _this = this;
        var destroyFunc = function () { return _this.destroyBean(headerGroupComp); };
        if (!this.isAlive()) {
            destroyFunc();
            return;
        }
        this.getGui().appendChild(headerGroupComp.getGui());
        this.addDestroyFunc(destroyFunc);
        this.ctrl.setDragSource(headerGroupComp.getGui());
    };
    HeaderGroupCellComp.TEMPLATE = "<div class=\"ag-header-group-cell\" role=\"columnheader\" tabindex=\"-1\">\n            <div ref=\"eResize\" class=\"ag-header-cell-resize\" role=\"presentation\"></div>\n        </div>";
    headerGroupCellComp_decorate([
        Object(context["a" /* Autowired */])('userComponentFactory')
    ], HeaderGroupCellComp.prototype, "userComponentFactory", void 0);
    headerGroupCellComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eResize')
    ], HeaderGroupCellComp.prototype, "eResize", void 0);
    headerGroupCellComp_decorate([
        context["e" /* PostConstruct */]
    ], HeaderGroupCellComp.prototype, "postConstruct", null);
    return HeaderGroupCellComp;
}(abstractHeaderCellComp["a" /* AbstractHeaderCellComp */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/floatingFilter/headerFilterCellComp.js + 1 modules
var headerFilterCellComp = __webpack_require__("16a5");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/row/headerRowComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var headerRowComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var headerRowComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};








var HeaderRowType;
(function (HeaderRowType) {
    HeaderRowType["COLUMN_GROUP"] = "group";
    HeaderRowType["COLUMN"] = "column";
    HeaderRowType["FLOATING_FILTER"] = "filter";
})(HeaderRowType || (HeaderRowType = {}));
var headerRowComp_HeaderRowComp = /** @class */ (function (_super) {
    headerRowComp_extends(HeaderRowComp, _super);
    function HeaderRowComp(ctrl) {
        var _this = _super.call(this) || this;
        _this.headerComps = {};
        var extraClass = ctrl.getType() == HeaderRowType.COLUMN_GROUP ? "ag-header-row-column-group" :
            ctrl.getType() == HeaderRowType.FLOATING_FILTER ? "ag-header-row-column-filter" : "ag-header-row-column";
        _this.setTemplate(/* html */ "<div class=\"ag-header-row " + extraClass + "\" role=\"row\"></div>");
        _this.ctrl = ctrl;
        return _this;
    }
    //noinspection JSUnusedLocalSymbols
    HeaderRowComp.prototype.init = function () {
        var _this = this;
        var compProxy = {
            setTransform: function (transform) { return _this.getGui().style.transform = transform; },
            setHeight: function (height) { return _this.getGui().style.height = height; },
            setTop: function (top) { return _this.getGui().style.top = top; },
            setHeaderCtrls: function (ctrls) { return _this.setHeaderCtrls(ctrls); },
            setWidth: function (width) { return _this.getGui().style.width = width; },
            setAriaRowIndex: function (rowIndex) { return Object(aria["setAriaRowIndex"])(_this.getGui(), rowIndex); }
        };
        this.ctrl.setComp(compProxy);
    };
    HeaderRowComp.prototype.destroyHeaderCtrls = function () {
        this.setHeaderCtrls([]);
    };
    HeaderRowComp.prototype.setHeaderCtrls = function (ctrls) {
        var _this = this;
        if (!this.isAlive()) {
            return;
        }
        var oldComps = this.headerComps;
        this.headerComps = {};
        ctrls.forEach(function (ctrl) {
            var id = ctrl.getInstanceId();
            var comp = oldComps[id];
            delete oldComps[id];
            if (comp == null) {
                comp = _this.createHeaderComp(ctrl);
                _this.getGui().appendChild(comp.getGui());
            }
            _this.headerComps[id] = comp;
        });
        Object(object["iterateObject"])(oldComps, function (id, comp) {
            _this.getGui().removeChild(comp.getGui());
            _this.destroyBean(comp);
        });
        var ensureDomOrder = this.gridOptionsWrapper.isEnsureDomOrder();
        if (ensureDomOrder) {
            var comps = Object(object["getAllValuesInObject"])(this.headerComps);
            // ordering the columns by left position orders them in the order they appear on the screen
            comps.sort(function (a, b) {
                var leftA = a.getCtrl().getColumnGroupChild().getLeft();
                var leftB = b.getCtrl().getColumnGroupChild().getLeft();
                return leftA - leftB;
            });
            var elementsInOrder = comps.map(function (c) { return c.getGui(); });
            Object(dom["setDomChildOrder"])(this.getGui(), elementsInOrder);
        }
    };
    HeaderRowComp.prototype.createHeaderComp = function (headerCtrl) {
        var result;
        switch (this.ctrl.getType()) {
            case HeaderRowType.COLUMN_GROUP:
                result = new headerGroupCellComp_HeaderGroupCellComp(headerCtrl);
                break;
            case HeaderRowType.FLOATING_FILTER:
                result = new headerFilterCellComp["a" /* HeaderFilterCellComp */](headerCtrl);
                break;
            default:
                result = new headerCellComp_HeaderCellComp(headerCtrl);
                break;
        }
        this.createBean(result);
        result.setParentComponent(this);
        return result;
    };
    headerRowComp_decorate([
        context["e" /* PostConstruct */]
    ], HeaderRowComp.prototype, "init", null);
    headerRowComp_decorate([
        context["g" /* PreDestroy */]
    ], HeaderRowComp.prototype, "destroyHeaderCtrls", null);
    return HeaderRowComp;
}(component["a" /* Component */]));



/***/ }),

/***/ "2d00":
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__("da84");
var userAgent = __webpack_require__("342f");

var process = global.process;
var Deno = global.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  version = match[0] < 4 ? 1 : match[0] + match[1];
} else if (userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = match[1];
  }
}

module.exports = version && +version;


/***/ }),

/***/ "2e13":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CellComp; });
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("9cc8");
/* harmony import */ var _cellEditors_popupEditorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("5230");
/* harmony import */ var _utils_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("3348");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("0e94");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("a74a");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("6352");
/* harmony import */ var _utils_browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("b8d2");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};







var CellComp = /** @class */ (function (_super) {
    __extends(CellComp, _super);
    function CellComp(scope, beans, cellCtrl, autoHeightCell, printLayout, eRow, editingRow) {
        var _this = _super.call(this) || this;
        _this.scope = null;
        // every time we go into edit mode, or back again, this gets incremented.
        // it's the components way of dealing with the async nature of framework components,
        // so if a framework component takes a while to be created, we know if the object
        // is still relevant when creating is finished. eg we could click edit / un-edit 20
        // times before the first React edit component comes back - we should discard
        // the first 19.
        _this.rendererVersion = 0;
        _this.editorVersion = 0;
        _this.scope = scope;
        _this.beans = beans;
        _this.column = cellCtrl.getColumn();
        _this.rowNode = cellCtrl.getRowNode();
        _this.rowCtrl = cellCtrl.getRowCtrl();
        _this.autoHeightCell = autoHeightCell;
        _this.eRow = eRow;
        _this.setTemplate(/* html */ "<div comp-id=\"" + _this.getCompId() + "\"/>");
        var eGui = _this.getGui();
        var style = eGui.style;
        _this.eCellValue = eGui;
        var setAttribute = function (name, value, element) {
            var actualElement = element ? element : eGui;
            if (value != null && value != '') {
                actualElement.setAttribute(name, value);
            }
            else {
                actualElement.removeAttribute(name);
            }
        };
        var compProxy = {
            addOrRemoveCssClass: function (cssClassName, on) { return _this.addOrRemoveCssClass(cssClassName, on); },
            setUserStyles: function (styles) { return Object(_utils_dom__WEBPACK_IMPORTED_MODULE_5__["addStylesToElement"])(eGui, styles); },
            setAriaSelected: function (selected) { return Object(_utils_aria__WEBPACK_IMPORTED_MODULE_2__["setAriaSelected"])(eGui, selected); },
            setAriaExpanded: function (selected) { return Object(_utils_aria__WEBPACK_IMPORTED_MODULE_2__["setAriaExpanded"])(eGui, selected); },
            getFocusableElement: function () { return _this.getFocusableElement(); },
            setLeft: function (left) { return style.left = left; },
            setWidth: function (width) { return style.width = width; },
            setAriaColIndex: function (index) { return Object(_utils_aria__WEBPACK_IMPORTED_MODULE_2__["setAriaColIndex"])(_this.getGui(), index); },
            setHeight: function (height) { return style.height = height; },
            setZIndex: function (zIndex) { return style.zIndex = zIndex; },
            setTabIndex: function (tabIndex) { return setAttribute('tabindex', tabIndex.toString()); },
            setRole: function (role) { return Object(_utils_aria__WEBPACK_IMPORTED_MODULE_2__["setAriaRole"])(eGui, role); },
            setColId: function (colId) { return setAttribute('col-id', colId); },
            setTitle: function (title) { return setAttribute('title', title); },
            setUnselectable: function (value) { return setAttribute('unselectable', value, _this.eCellValue); },
            setTransition: function (transition) { return style.transition = transition ? transition : ''; },
            setIncludeSelection: function (include) { return _this.includeSelection = include; },
            setIncludeRowDrag: function (include) { return _this.includeRowDrag = include; },
            setIncludeDndSource: function (include) { return _this.includeDndSource = include; },
            setForceWrapper: function (force) { return _this.forceWrapper = force; },
            setRenderDetails: function (compDetails, valueToDisplay, force) {
                return _this.setRenderDetails(compDetails, valueToDisplay, force);
            },
            setEditDetails: function (compDetails, popup, position) {
                return _this.setEditDetails(compDetails, popup, position);
            },
            getCellEditor: function () { return _this.cellEditor || null; },
            getCellRenderer: function () { return _this.cellRenderer || null; },
            getParentOfValue: function () { return _this.eCellValue; }
        };
        _this.cellCtrl = cellCtrl;
        cellCtrl.setComp(compProxy, _this.scope, _this.getGui(), printLayout, editingRow);
        return _this;
    }
    CellComp.prototype.setRenderDetails = function (compDetails, valueToDisplay, forceNewCellRendererInstance) {
        // this can happen if the users asks for the cell to refresh, but we are not showing the vale as we are editing
        var isInlineEditing = this.cellEditor && !this.cellEditorPopupWrapper;
        if (isInlineEditing) {
            return;
        }
        // this means firstRender will be true for one pass only, as it's initialised to undefined
        this.firstRender = this.firstRender == null;
        var usingAngular1Template = this.isUsingAngular1Template();
        // if display template has changed, means any previous Cell Renderer is in the wrong location
        var controlWrapperChanged = this.setupControlsWrapper();
        // all of these have dependencies on the eGui, so only do them after eGui is set
        if (compDetails) {
            var neverRefresh = forceNewCellRendererInstance || controlWrapperChanged;
            var cellRendererRefreshSuccessful = neverRefresh ? false : this.refreshCellRenderer(compDetails);
            if (!cellRendererRefreshSuccessful) {
                this.destroyRenderer();
                this.createCellRendererInstance(compDetails);
            }
        }
        else {
            this.destroyRenderer();
            if (usingAngular1Template) {
                this.insertValueUsingAngular1Template();
            }
            else {
                this.insertValueWithoutCellRenderer(valueToDisplay);
            }
        }
        this.cellCtrl.setupAutoHeight(this.eCellValue);
    };
    CellComp.prototype.setEditDetails = function (compDetails, popup, position) {
        if (compDetails) {
            this.createCellEditorInstance(compDetails, popup, position);
        }
        else {
            this.destroyEditor();
        }
    };
    CellComp.prototype.removeControlsWrapper = function () {
        this.eCellValue = this.getGui();
        this.eCellWrapper = null;
        this.checkboxSelectionComp = this.beans.context.destroyBean(this.checkboxSelectionComp);
        this.dndSourceComp = this.beans.context.destroyBean(this.dndSourceComp);
        this.rowDraggingComp = this.beans.context.destroyBean(this.rowDraggingComp);
    };
    // returns true if wrapper was changed
    CellComp.prototype.setupControlsWrapper = function () {
        var usingWrapper = this.includeRowDrag || this.includeDndSource || this.includeSelection || this.forceWrapper;
        var changed = true;
        var notChanged = false;
        this.addOrRemoveCssClass('ag-cell-value', !usingWrapper);
        // turn wrapper on
        if (usingWrapper && !this.eCellWrapper) {
            this.addControlsWrapper();
            return changed;
        }
        // turn wrapper off
        if (!usingWrapper && this.eCellWrapper) {
            this.removeControlsWrapper();
            return changed;
        }
        return notChanged;
    };
    CellComp.prototype.addControlsWrapper = function () {
        var eGui = this.getGui();
        eGui.innerHTML = /* html */
            "<div ref=\"eCellWrapper\" class=\"ag-cell-wrapper\" role=\"presentation\">\n                <span ref=\"eCellValue\" class=\"ag-cell-value\" role=\"presentation\"></span>\n            </div>";
        this.eCellValue = this.getRefElement('eCellValue');
        this.eCellWrapper = this.getRefElement('eCellWrapper');
        if (!this.forceWrapper) {
            this.eCellValue.setAttribute('unselectable', 'on');
        }
        var id = this.eCellValue.id = "cell-" + this.getCompId();
        var describedByIds = [];
        if (this.includeRowDrag) {
            this.rowDraggingComp = this.cellCtrl.createRowDragComp();
            if (this.rowDraggingComp) {
                // put the checkbox in before the value
                this.eCellWrapper.insertBefore(this.rowDraggingComp.getGui(), this.eCellValue);
            }
        }
        if (this.includeDndSource) {
            this.dndSourceComp = this.cellCtrl.createDndSource();
            // put the checkbox in before the value
            this.eCellWrapper.insertBefore(this.dndSourceComp.getGui(), this.eCellValue);
        }
        if (this.includeSelection) {
            this.checkboxSelectionComp = this.cellCtrl.createSelectionCheckbox();
            this.eCellWrapper.insertBefore(this.checkboxSelectionComp.getGui(), this.eCellValue);
            describedByIds.push(this.checkboxSelectionComp.getCheckboxId());
        }
        describedByIds.push(id);
        Object(_utils_aria__WEBPACK_IMPORTED_MODULE_2__["setAriaDescribedBy"])(this.getGui(), describedByIds.join(' '));
    };
    CellComp.prototype.createCellEditorInstance = function (compDetails, popup, position) {
        var _this = this;
        var versionCopy = this.editorVersion;
        var cellEditorPromise = this.beans.userComponentFactory.createInstanceFromCompDetails(compDetails);
        if (!cellEditorPromise) {
            return;
        } // if empty, userComponentFactory already did a console message
        var params = compDetails.params;
        cellEditorPromise.then(function (c) { return _this.afterCellEditorCreated(versionCopy, c, params, popup, position); });
        // if we don't do this, and editor component is async, then there will be a period
        // when the component isn't present and keyboard navigation won't work - so example
        // of user hitting tab quickly (more quickly than renderers getting created) won't work
        var cellEditorAsync = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_4__["missing"])(this.cellEditor);
        if (cellEditorAsync && params.cellStartedEdit) {
            this.cellCtrl.focusCell(true);
        }
    };
    CellComp.prototype.insertValueWithoutCellRenderer = function (valueToDisplay) {
        var escapedValue = valueToDisplay != null ? Object(_utils_string__WEBPACK_IMPORTED_MODULE_3__["escapeString"])(valueToDisplay) : null;
        if (escapedValue != null) {
            this.eCellValue.innerHTML = escapedValue;
        }
        else {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_5__["clearElement"])(this.eCellValue);
        }
    };
    CellComp.prototype.insertValueUsingAngular1Template = function () {
        var _this = this;
        var _a = this.column.getColDef(), template = _a.template, templateUrl = _a.templateUrl;
        var templateToInsert = undefined;
        if (template != null) {
            templateToInsert = template;
        }
        else if (templateUrl != null) {
            // first time this happens it will return nothing, as the template will still be loading async,
            // however once loaded it will refresh the cell and second time around it will be returned sync
            // as in cache.
            templateToInsert = this.beans.templateService.getTemplate(templateUrl, function () { return _this.cellCtrl.refreshCell({ forceRefresh: true }); });
        }
        else {
            // should never happen, as we only enter this method when template or templateUrl exist
        }
        if (templateToInsert != null) {
            this.eCellValue.innerHTML = templateToInsert;
            this.updateAngular1ScopeAndCompile();
        }
    };
    CellComp.prototype.destroyEditorAndRenderer = function () {
        this.destroyRenderer();
        this.destroyEditor();
    };
    CellComp.prototype.destroyRenderer = function () {
        var context = this.beans.context;
        this.cellRenderer = context.destroyBean(this.cellRenderer);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_5__["removeFromParent"])(this.cellRendererGui);
        this.cellRendererGui = null;
        this.rendererVersion++;
    };
    CellComp.prototype.destroyEditor = function () {
        var context = this.beans.context;
        if (this.hideEditorPopup) {
            this.hideEditorPopup();
        }
        this.hideEditorPopup = undefined;
        this.cellEditor = context.destroyBean(this.cellEditor);
        this.cellEditorPopupWrapper = context.destroyBean(this.cellEditorPopupWrapper);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_5__["removeFromParent"])(this.cellEditorGui);
        this.cellEditorGui = null;
        this.editorVersion++;
    };
    CellComp.prototype.refreshCellRenderer = function (compClassAndParams) {
        if (this.cellRenderer == null || this.cellRenderer.refresh == null) {
            return false;
        }
        // if different Cell Renderer configured this time (eg user is using selector, and
        // returns different component) then don't refresh, force recreate of Cell Renderer
        if (this.cellRendererClass !== compClassAndParams.componentClass) {
            return false;
        }
        // take any custom params off of the user
        var result = this.cellRenderer.refresh(compClassAndParams.params);
        // NOTE on undefined: previous version of the cellRenderer.refresh() interface
        // returned nothing, if the method existed, we assumed it refreshed. so for
        // backwards compatibility, we assume if method exists and returns nothing,
        // that it was successful.
        return result === true || result === undefined;
    };
    CellComp.prototype.createCellRendererInstance = function (compClassAndParams) {
        var _this = this;
        // never use task service if angularCompileRows=true, as that assume the cell renderers
        // are finished when the row is created. also we never use it if animation frame service
        // is turned off.
        // and lastly we never use it if doing auto-height, as the auto-height service checks the
        // row height directly after the cell is created, it doesn't wait around for the tasks to complete
        var angularCompileRows = this.beans.gridOptionsWrapper.isAngularCompileRows();
        var suppressAnimationFrame = this.beans.gridOptionsWrapper.isSuppressAnimationFrame();
        var useTaskService = !angularCompileRows && !suppressAnimationFrame && !this.autoHeightCell;
        var displayComponentVersionCopy = this.rendererVersion;
        var componentClass = compClassAndParams.componentClass;
        var createCellRendererFunc = function () {
            var staleTask = _this.rendererVersion !== displayComponentVersionCopy || !_this.isAlive();
            if (staleTask) {
                return;
            }
            // this can return null in the event that the user has switched from a renderer component to nothing, for example
            // when using a cellRendererSelect to return a component or null depending on row data etc
            var componentPromise = _this.beans.userComponentFactory.createInstanceFromCompDetails(compClassAndParams);
            var callback = _this.afterCellRendererCreated.bind(_this, displayComponentVersionCopy, componentClass);
            if (componentPromise) {
                componentPromise.then(callback);
            }
        };
        // we only use task service when rendering for first time, which means it is not used when doing edits.
        // if we changed this (always use task service) would make sense, however it would break tests, possibly
        // test of users.
        if (useTaskService && this.firstRender) {
            this.beans.animationFrameService.createTask(createCellRendererFunc, this.rowNode.rowIndex, 'createTasksP2');
        }
        else {
            createCellRendererFunc();
        }
    };
    CellComp.prototype.isUsingAngular1Template = function () {
        var colDef = this.column.getColDef();
        var res = colDef.template != null || colDef.templateUrl != null;
        return res;
    };
    CellComp.prototype.getCtrl = function () {
        return this.cellCtrl;
    };
    CellComp.prototype.getRowCtrl = function () {
        return this.rowCtrl;
    };
    CellComp.prototype.getCellRenderer = function () {
        return this.cellRenderer;
    };
    CellComp.prototype.getCellEditor = function () {
        return this.cellEditor;
    };
    CellComp.prototype.afterCellRendererCreated = function (cellRendererVersion, cellRendererClass, cellRenderer) {
        var staleTask = !this.isAlive() || cellRendererVersion !== this.rendererVersion;
        if (staleTask) {
            this.beans.context.destroyBean(cellRenderer);
            return;
        }
        this.cellRenderer = cellRenderer;
        this.cellRendererClass = cellRendererClass;
        this.cellRendererGui = this.cellRenderer.getGui();
        if (this.cellRendererGui != null) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_5__["clearElement"])(this.eCellValue);
            this.eCellValue.appendChild(this.cellRendererGui);
            this.updateAngular1ScopeAndCompile();
        }
    };
    CellComp.prototype.afterCellEditorCreated = function (requestVersion, cellEditor, params, popup, position) {
        // if editingCell=false, means user cancelled the editor before component was ready.
        // if versionMismatch, then user cancelled the edit, then started the edit again, and this
        //   is the first editor which is now stale.
        var staleComp = requestVersion !== this.editorVersion;
        if (staleComp) {
            this.beans.context.destroyBean(cellEditor);
            return;
        }
        var editingCancelledByUserComp = cellEditor.isCancelBeforeStart && cellEditor.isCancelBeforeStart();
        if (editingCancelledByUserComp) {
            this.beans.context.destroyBean(cellEditor);
            this.cellCtrl.stopEditing();
            return;
        }
        if (!cellEditor.getGui) {
            console.warn("AG Grid: cellEditor for column " + this.column.getId() + " is missing getGui() method");
            this.beans.context.destroyBean(cellEditor);
            return;
        }
        this.cellEditor = cellEditor;
        this.cellEditorGui = cellEditor.getGui();
        var cellEditorInPopup = popup || (cellEditor.isPopup !== undefined && cellEditor.isPopup());
        if (cellEditorInPopup) {
            if (!popup) {
                this.cellCtrl.hackSayEditingInPopup();
            }
            this.addPopupCellEditor(params, position);
        }
        else {
            this.addInCellEditor();
        }
        if (cellEditor.afterGuiAttached) {
            cellEditor.afterGuiAttached();
        }
    };
    CellComp.prototype.addInCellEditor = function () {
        var eGui = this.getGui();
        // if focus is inside the cell, we move focus to the cell itself
        // before removing it's contents, otherwise errors could be thrown.
        if (eGui.contains(document.activeElement)) {
            eGui.focus();
        }
        this.destroyRenderer();
        this.removeControlsWrapper();
        this.clearCellElement();
        if (this.cellEditorGui) {
            eGui.appendChild(this.cellEditorGui);
        }
    };
    CellComp.prototype.addPopupCellEditor = function (params, position) {
        var _this = this;
        if (this.beans.gridOptionsWrapper.isFullRowEdit()) {
            console.warn('AG Grid: popup cellEditor does not work with fullRowEdit - you cannot use them both ' +
                '- either turn off fullRowEdit, or stop using popup editors.');
        }
        var cellEditor = this.cellEditor;
        // if a popup, then we wrap in a popup editor and return the popup
        this.cellEditorPopupWrapper = this.beans.context.createBean(new _cellEditors_popupEditorWrapper__WEBPACK_IMPORTED_MODULE_1__[/* PopupEditorWrapper */ "a"](params));
        var ePopupGui = this.cellEditorPopupWrapper.getGui();
        if (this.cellEditorGui) {
            ePopupGui.appendChild(this.cellEditorGui);
        }
        var popupService = this.beans.popupService;
        var useModelPopup = this.beans.gridOptionsWrapper.isStopEditingWhenCellsLoseFocus();
        // see if position provided by colDef, if not then check old way of method on cellComp
        var positionToUse = position != null ? position : cellEditor.getPopupPosition ? cellEditor.getPopupPosition() : 'over';
        var positionParams = {
            column: this.column,
            rowNode: this.rowNode,
            type: 'popupCellEditor',
            eventSource: this.getGui(),
            ePopup: ePopupGui,
            keepWithinBounds: true
        };
        var positionCallback = position === 'under' ?
            popupService.positionPopupUnderComponent.bind(popupService, positionParams)
            : popupService.positionPopupOverComponent.bind(popupService, positionParams);
        var translate = this.beans.gridOptionsWrapper.getLocaleTextFunc();
        var addPopupRes = popupService.addPopup({
            modal: useModelPopup,
            eChild: ePopupGui,
            closeOnEsc: true,
            closedCallback: function () { _this.cellCtrl.onPopupEditorClosed(); },
            anchorToElement: this.getGui(),
            positionCallback: positionCallback,
            ariaLabel: translate('ariaLabelCellEditor', 'Cell Editor')
        });
        if (addPopupRes) {
            this.hideEditorPopup = addPopupRes.hideFunc;
        }
    };
    CellComp.prototype.detach = function () {
        this.eRow.removeChild(this.getGui());
    };
    // if the row is also getting destroyed, then we don't need to remove from dom,
    // as the row will also get removed, so no need to take out the cells from the row
    // if the row is going (removing is an expensive operation, so only need to remove
    // the top part)
    //
    // note - this is NOT called by context, as we don't wire / unwire the CellComp for performance reasons.
    CellComp.prototype.destroy = function () {
        this.cellCtrl.stopEditing();
        this.destroyEditorAndRenderer();
        this.removeControlsWrapper();
        if (this.angularCompiledElement) {
            this.angularCompiledElement.remove();
            this.angularCompiledElement = undefined;
        }
        _super.prototype.destroy.call(this);
    };
    CellComp.prototype.clearCellElement = function () {
        var eGui = this.getGui();
        // if focus is inside the cell, we move focus to the cell itself
        // before removing it's contents, otherwise errors could be thrown.
        if (eGui.contains(document.activeElement) && !Object(_utils_browser__WEBPACK_IMPORTED_MODULE_6__["isBrowserIE"])()) {
            eGui.focus({
                preventScroll: true
            });
        }
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_5__["clearElement"])(eGui);
    };
    CellComp.prototype.updateAngular1ScopeAndCompile = function () {
        if (this.beans.gridOptionsWrapper.isAngularCompileRows() && this.scope) {
            this.scope.data = __assign({}, this.rowNode.data);
            if (this.angularCompiledElement) {
                this.angularCompiledElement.remove();
            }
            this.angularCompiledElement = this.beans.$compile(this.eCellValue.children)(this.scope);
            // because this.scope is set, we are guaranteed GridBodyComp is vanilla JS, ie it's GridBodyComp.ts from AG Stack and and not react
            this.beans.ctrlsService.getGridBodyCtrl().requestAngularApply();
        }
    };
    return CellComp;
}(_widgets_component__WEBPACK_IMPORTED_MODULE_0__[/* Component */ "a"]));



/***/ }),

/***/ "2ebc":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ userComponentFactory_UserComponentFactory; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/index.js + 8 modules
var utils = __webpack_require__("7347");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/componentTypes.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var DateComponent = {
    propertyName: 'dateComponent',
    isCellRenderer: function () { return false; }
};
var HeaderComponent = {
    propertyName: 'headerComponent',
    isCellRenderer: function () { return false; },
};
var HeaderGroupComponent = {
    propertyName: 'headerGroupComponent',
    isCellRenderer: function () { return false; },
};
var CellRendererComponent = {
    propertyName: 'cellRenderer',
    isCellRenderer: function () { return true; },
};
var PinnedRowCellRendererComponent = {
    propertyName: 'pinnedRowCellRenderer',
    isCellRenderer: function () { return true; },
};
var CellEditorComponent = {
    propertyName: 'cellEditor',
    isCellRenderer: function () { return false; },
};
var InnerRendererComponent = {
    propertyName: 'innerRenderer',
    isCellRenderer: function () { return true; },
};
var LoadingOverlayComponent = {
    propertyName: 'loadingOverlayComponent',
    isCellRenderer: function () { return false; },
};
var NoRowsOverlayComponent = {
    propertyName: 'noRowsOverlayComponent',
    isCellRenderer: function () { return false; },
};
var TooltipComponent = {
    propertyName: 'tooltipComponent',
    isCellRenderer: function () { return false; },
};
var FilterComponent = {
    propertyName: 'filter',
    isCellRenderer: function () { return false; },
};
var FloatingFilterComponent = {
    propertyName: 'floatingFilterComponent',
    isCellRenderer: function () { return false; },
};
var ToolPanelComponent = {
    propertyName: 'toolPanel',
    isCellRenderer: function () { return false; },
};
var StatusPanelComponent = {
    propertyName: 'statusPanel',
    isCellRenderer: function () { return false; },
};

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/beanStub.js
var beanStub = __webpack_require__("bc71");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/object.js
var object = __webpack_require__("562d");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/userComponentFactory.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var userComponentFactory_UserComponentFactory = /** @class */ (function (_super) {
    __extends(UserComponentFactory, _super);
    function UserComponentFactory() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    //////// NEW (after React UI)
    UserComponentFactory.prototype.getHeaderCompDetails = function (colDef, params) {
        return this.getCompDetails(colDef, HeaderComponent, 'agColumnHeader', params);
    };
    UserComponentFactory.prototype.getHeaderGroupCompDetails = function (params) {
        var colGroupDef = params.columnGroup.getColGroupDef();
        return this.getCompDetails(colGroupDef, HeaderGroupComponent, 'agColumnGroupHeader', params);
    };
    // this one is unusual, as it can be LoadingCellRenderer, DetailCellRenderer, FullWidthCellRenderer or GroupRowRenderer.
    // so we have to pass the type in.
    UserComponentFactory.prototype.getFullWidthCellRendererDetails = function (params, cellRendererType, cellRendererName) {
        return this.getCompDetails(this.gridOptions, { propertyName: cellRendererType, isCellRenderer: function () { return true; } }, cellRendererName, params);
    };
    // CELL RENDERER
    UserComponentFactory.prototype.getInnerRendererDetails = function (def, params) {
        return this.getCompDetails(def, InnerRendererComponent, null, params);
    };
    UserComponentFactory.prototype.getFullWidthGroupRowInnerCellRenderer = function (def, params) {
        return this.getCompDetails(def, InnerRendererComponent, null, params);
    };
    UserComponentFactory.prototype.getCellRendererDetails = function (def, params) {
        return this.getCompDetails(def, CellRendererComponent, null, params);
    };
    // CELL EDITOR
    UserComponentFactory.prototype.getCellEditorDetails = function (def, params) {
        return this.getCompDetails(def, CellEditorComponent, 'agCellEditor', params, true);
    };
    //////// OLD (before React UI)
    UserComponentFactory.prototype.newCellRenderer = function (def, params) {
        return this.lookupAndCreateComponent(def, params, CellRendererComponent, null, true);
    };
    UserComponentFactory.prototype.newDateComponent = function (params) {
        return this.lookupAndCreateComponent(this.gridOptions, params, DateComponent, 'agDateInput');
    };
    UserComponentFactory.prototype.newLoadingOverlayComponent = function (params) {
        return this.lookupAndCreateComponent(this.gridOptions, params, LoadingOverlayComponent, 'agLoadingOverlay');
    };
    UserComponentFactory.prototype.newNoRowsOverlayComponent = function (params) {
        return this.lookupAndCreateComponent(this.gridOptions, params, NoRowsOverlayComponent, 'agNoRowsOverlay');
    };
    UserComponentFactory.prototype.newTooltipComponent = function (params) {
        return this.lookupAndCreateComponent(params.colDef, params, TooltipComponent, 'agTooltipComponent');
    };
    UserComponentFactory.prototype.newFilterComponent = function (def, params, defaultFilter) {
        return this.lookupAndCreateComponent(def, params, FilterComponent, defaultFilter, false);
    };
    UserComponentFactory.prototype.newSetFilterCellRenderer = function (def, params) {
        return this.lookupAndCreateComponent(def, params, CellRendererComponent, null, true);
    };
    UserComponentFactory.prototype.newFloatingFilterComponent = function (def, params, defaultFloatingFilter) {
        return this.lookupAndCreateComponent(def, params, FloatingFilterComponent, defaultFloatingFilter, true);
    };
    UserComponentFactory.prototype.newToolPanelComponent = function (toolPanelDef, params) {
        return this.lookupAndCreateComponent(toolPanelDef, params, ToolPanelComponent);
    };
    UserComponentFactory.prototype.newStatusPanelComponent = function (def, params) {
        return this.lookupAndCreateComponent(def, params, StatusPanelComponent);
    };
    UserComponentFactory.prototype.lookupComponent = function (defObject, type, params, defaultComponentName) {
        var _this = this;
        if (params === void 0) { params = null; }
        var propertyName = type.propertyName;
        var paramsFromSelector;
        var comp;
        var frameworkComp;
        // pull from defObject if available
        if (defObject) {
            var defObjectAny = defObject;
            // if selector, use this
            var selectorFunc = defObjectAny[propertyName + 'Selector'];
            var selectorRes = selectorFunc ? selectorFunc(params) : null;
            if (selectorRes) {
                comp = selectorRes.component;
                frameworkComp = selectorRes.frameworkComponent;
                paramsFromSelector = selectorRes.params;
            }
            else {
                // if no selector, or result of selector is empty, take from defObject
                comp = defObjectAny[propertyName];
                frameworkComp = defObjectAny[propertyName + 'Framework'];
            }
            // for filters only, we allow 'true' for the component, which means default filter to be used
            if (comp === true) {
                comp = undefined;
            }
        }
        var lookupFromRegistry = function (key) {
            var item = _this.userComponentRegistry.retrieve(key);
            if (item) {
                comp = !item.componentFromFramework ? item.component : undefined;
                frameworkComp = item.componentFromFramework ? item.component : undefined;
            }
            else {
                comp = undefined;
                frameworkComp = undefined;
            }
        };
        // if compOption is a string, means we need to look the item up
        if (typeof comp === 'string') {
            lookupFromRegistry(comp);
        }
        // if lookup brought nothing back, and we have a default, lookup the default
        if (comp == null && frameworkComp == null && defaultComponentName != null) {
            lookupFromRegistry(defaultComponentName);
        }
        // if we have a comp option, and it's a function, replace it with an object equivalent adaptor
        if (comp && !this.agComponentUtils.doesImplementIComponent(comp)) {
            comp = this.agComponentUtils.adaptFunction(propertyName, comp);
        }
        if (!comp && !frameworkComp) {
            return null;
        }
        return {
            componentFromFramework: comp == null,
            componentClass: comp ? comp : frameworkComp,
            params: paramsFromSelector,
            type: type
        };
    };
    UserComponentFactory.prototype.createInstanceFromCompDetails = function (compDetails, defaultComponentName) {
        if (!compDetails) {
            return null;
        }
        var params = compDetails.params, componentClass = compDetails.componentClass, componentFromFramework = compDetails.componentFromFramework;
        // Create the component instance
        var instance = this.createComponentInstance(compDetails.type, defaultComponentName, componentClass, componentFromFramework);
        if (!instance) {
            return null;
        }
        this.addReactHacks(params);
        var deferredInit = this.initComponent(instance, params);
        if (deferredInit == null) {
            return utils["a" /* AgPromise */].resolve(instance);
        }
        return deferredInit.then(function () { return instance; });
    };
    /**
     * This method creates a component given everything needed to guess what sort of component needs to be instantiated
     * It takes
     *  @param CompClass: The class to instantiate,
     *  @param agGridParams: Params to be passed to the component and passed by AG Grid. This will get merged with any params
     *      specified by the user in the configuration
     *  @param modifyParamsCallback: A chance to customise the params passed to the init method. It receives what the current
     *  params are and the component that init is about to get called for
     */
    UserComponentFactory.prototype.createUserComponentFromConcreteClass = function (CompClass, agGridParams) {
        var internalComponent = new CompClass();
        this.initComponent(internalComponent, agGridParams);
        return internalComponent;
    };
    /**
     * Useful to check what would be the resultant params for a given object
     *  @param definitionObject: This is the context for which this component needs to be created, it can be gridOptions
     *      (global) or columnDef mostly.
     *  @param propertyName: The name of the property used in ag-grid as a convention to refer to the component, it can be:
     *      'floatingFilter', 'cellRenderer', is used to find if the user is specifying a custom component
     *  @param paramsFromGrid: Params to be passed to the component and passed by AG Grid. This will get merged with any params
     *      specified by the user in the configuration
     * @returns {TParams} It merges the user agGridParams with the actual params specified by the user.
     */
    UserComponentFactory.prototype.mergeParamsWithApplicationProvidedParams = function (definitionObject, propertyName, paramsFromGrid, paramsFromSelector) {
        if (paramsFromSelector === void 0) { paramsFromSelector = null; }
        var params = {};
        Object(object["mergeDeep"])(params, paramsFromGrid);
        var userParams = definitionObject ? definitionObject[propertyName + "Params"] : null;
        if (userParams != null) {
            if (typeof userParams === 'function') {
                var userParamsFromFunc = userParams(paramsFromGrid);
                Object(object["mergeDeep"])(params, userParamsFromFunc);
            }
            else if (typeof userParams === 'object') {
                Object(object["mergeDeep"])(params, userParams);
            }
        }
        Object(object["mergeDeep"])(params, paramsFromSelector);
        return params;
    };
    UserComponentFactory.prototype.getCompDetails = function (defObject, type, defaultName, params, mandatory) {
        if (mandatory === void 0) { mandatory = false; }
        var propName = type.propertyName;
        var compDetails = this.lookupComponent(defObject, type, params, defaultName);
        if (!compDetails || !compDetails.componentClass) {
            if (mandatory) {
                this.logComponentMissing(defObject, propName);
            }
            return undefined;
        }
        var paramsMerged = this.mergeParamsWithApplicationProvidedParams(defObject, propName, params, compDetails.params);
        return __assign(__assign({}, compDetails), { params: paramsMerged });
    };
    /**
     * This method creates a component given everything needed to guess what sort of component needs to be instantiated
     * It takes
     *  @param definitionObject: This is the context for which this component needs to be created, it can be gridOptions
     *      (global) or columnDef mostly.
     *  @param paramsFromGrid: Params to be passed to the component and passed by AG Grid. This will get merged with any params
     *      specified by the user in the configuration
     *  @param propertyName: The name of the property used in ag-grid as a convention to refer to the component, it can be:
     *      'floatingFilter', 'cellRenderer', is used to find if the user is specifying a custom component
     *  @param defaultComponentName: The actual name of the component to instantiate, this is usually the same as propertyName, but in
     *      some cases is not, like floatingFilter, if it is the same is not necessary to specify
     *  @param optional: Handy method to tell if this should return a component ALWAYS. if that is the case, but there is no
     *      component found, it throws an error, by default all components are MANDATORY
     */
    UserComponentFactory.prototype.lookupAndCreateComponent = function (def, paramsFromGrid, componentType, defaultComponentName, 
    // optional items are: FloatingFilter, CellComp (for cellRenderer)
    optional) {
        if (optional === void 0) { optional = false; }
        var compDetails = this.getCompDetails(def, componentType, defaultComponentName, paramsFromGrid, !optional);
        if (!compDetails) {
            return null;
        }
        return this.createInstanceFromCompDetails(compDetails, defaultComponentName);
    };
    UserComponentFactory.prototype.addReactHacks = function (params) {
        // a temporary fix for AG-1574
        // AG-1715 raised to do a wider ranging refactor to improve this
        var agGridReact = this.context.getBean('agGridReact');
        if (agGridReact) {
            params.agGridReact = Object(object["cloneObject"])(agGridReact);
        }
        // AG-1716 - directly related to AG-1574 and AG-1715
        var frameworkComponentWrapper = this.context.getBean('frameworkComponentWrapper');
        if (frameworkComponentWrapper) {
            params.frameworkComponentWrapper = frameworkComponentWrapper;
        }
    };
    UserComponentFactory.prototype.logComponentMissing = function (holder, propertyName, defaultComponentName) {
        // to help the user, we print out the name they are looking for, rather than the default name.
        // i don't know why the default name was originally printed out (that doesn't help the user)
        var overrideName = holder ? holder[propertyName] : defaultComponentName;
        var nameToReport = overrideName ? overrideName : defaultComponentName;
        console.error("Could not find component " + nameToReport + ", did you forget to configure this component?");
    };
    UserComponentFactory.prototype.createComponentInstance = function (componentType, defaultComponentName, component, componentFromFramework) {
        var propertyName = componentType.propertyName;
        // using javascript component
        var jsComponent = !componentFromFramework;
        if (jsComponent) {
            return new component();
        }
        if (!this.frameworkComponentWrapper) {
            console.warn("AG Grid - Because you are using our new React UI (property reactUi=true), it is not possible to use a React Component for " + componentType.propertyName + ". This is work in progress and we plan to support this soon. In the meantime, please either set reactUi=false, or replace this component with one written in JavaScript.");
            return null;
        }
        // Using framework component
        var FrameworkComponentRaw = component;
        var thisComponentConfig = this.componentMetadataProvider.retrieve(propertyName);
        return this.frameworkComponentWrapper.wrap(FrameworkComponentRaw, thisComponentConfig.mandatoryMethodList, thisComponentConfig.optionalMethodList, componentType, defaultComponentName);
    };
    UserComponentFactory.prototype.initComponent = function (component, params) {
        this.context.createBean(component);
        if (component.init == null) {
            return;
        }
        return component.init(params);
    };
    __decorate([
        Object(context["a" /* Autowired */])('gridOptions')
    ], UserComponentFactory.prototype, "gridOptions", void 0);
    __decorate([
        Object(context["a" /* Autowired */])('agComponentUtils')
    ], UserComponentFactory.prototype, "agComponentUtils", void 0);
    __decorate([
        Object(context["a" /* Autowired */])('componentMetadataProvider')
    ], UserComponentFactory.prototype, "componentMetadataProvider", void 0);
    __decorate([
        Object(context["a" /* Autowired */])('userComponentRegistry')
    ], UserComponentFactory.prototype, "userComponentRegistry", void 0);
    __decorate([
        Object(context["d" /* Optional */])('frameworkComponentWrapper')
    ], UserComponentFactory.prototype, "frameworkComponentWrapper", void 0);
    UserComponentFactory = __decorate([
        Object(context["b" /* Bean */])('userComponentFactory')
    ], UserComponentFactory);
    return UserComponentFactory;
}(beanStub["a" /* BeanStub */]));



/***/ }),

/***/ "3174":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ExcelFactoryMode; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
// Excel Export
var ExcelFactoryMode;
(function (ExcelFactoryMode) {
    ExcelFactoryMode[ExcelFactoryMode["SINGLE_SHEET"] = 0] = "SINGLE_SHEET";
    ExcelFactoryMode[ExcelFactoryMode["MULTI_SHEET"] = 1] = "MULTI_SHEET";
})(ExcelFactoryMode || (ExcelFactoryMode = {}));


/***/ }),

/***/ "31bf":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgGroupComponent; });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("9cc8");
/* harmony import */ var _componentAnnotations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("6835");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("781c");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("6352");
/* harmony import */ var _constants_keyCode__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("7a66");
/* harmony import */ var _utils_aria__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("3348");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};







var AgGroupComponent = /** @class */ (function (_super) {
    __extends(AgGroupComponent, _super);
    function AgGroupComponent(params) {
        if (params === void 0) { params = {}; }
        var _this = _super.call(this, AgGroupComponent.getTemplate(params)) || this;
        _this.suppressEnabledCheckbox = true;
        _this.suppressOpenCloseIcons = false;
        var title = params.title, enabled = params.enabled, items = params.items, suppressEnabledCheckbox = params.suppressEnabledCheckbox, suppressOpenCloseIcons = params.suppressOpenCloseIcons;
        _this.title = title;
        _this.cssIdentifier = params.cssIdentifier || 'default';
        _this.enabled = enabled != null ? enabled : true;
        _this.items = items || [];
        _this.alignItems = params.alignItems || 'center';
        if (suppressEnabledCheckbox != null) {
            _this.suppressEnabledCheckbox = suppressEnabledCheckbox;
        }
        if (suppressOpenCloseIcons != null) {
            _this.suppressOpenCloseIcons = suppressOpenCloseIcons;
        }
        return _this;
    }
    AgGroupComponent.getTemplate = function (params) {
        var cssIdentifier = params.cssIdentifier || 'default';
        var direction = params.direction || 'vertical';
        return /* html */ "<div class=\"ag-group ag-" + cssIdentifier + "-group\" role=\"presentation\">\n            <div class=\"ag-group-title-bar ag-" + cssIdentifier + "-group-title-bar ag-unselectable\" ref=\"eTitleBar\" role=\"button\">\n                <span class=\"ag-group-title-bar-icon ag-" + cssIdentifier + "-group-title-bar-icon\" ref=\"eGroupOpenedIcon\" role=\"presentation\"></span>\n                <span class=\"ag-group-title-bar-icon ag-" + cssIdentifier + "-group-title-bar-icon\" ref=\"eGroupClosedIcon\" role=\"presentation\"></span>\n                <span ref=\"eTitle\" class=\"ag-group-title ag-" + cssIdentifier + "-group-title\"></span>\n            </div>\n            <div ref=\"eToolbar\" class=\"ag-group-toolbar ag-" + cssIdentifier + "-group-toolbar\">\n                <ag-checkbox ref=\"cbGroupEnabled\"></ag-checkbox>\n            </div>\n            <div ref=\"eContainer\" class=\"ag-group-container ag-group-container-" + direction + " ag-" + cssIdentifier + "-group-container\"></div>\n        </div>";
    };
    AgGroupComponent.prototype.postConstruct = function () {
        if (this.items.length) {
            var initialItems = this.items;
            this.items = [];
            this.addItems(initialItems);
        }
        var localeTextFunc = this.gridOptionsWrapper.getLocaleTextFunc();
        this.cbGroupEnabled.setLabel(localeTextFunc('enabled', 'Enabled'));
        if (this.title) {
            this.setTitle(this.title);
        }
        if (this.enabled) {
            this.setEnabled(this.enabled);
        }
        this.setAlignItems(this.alignItems);
        this.hideEnabledCheckbox(this.suppressEnabledCheckbox);
        this.hideOpenCloseIcons(this.suppressOpenCloseIcons);
        this.setupExpandContract();
        this.refreshAriaStatus();
        this.refreshChildDisplay();
    };
    AgGroupComponent.prototype.setupExpandContract = function () {
        var _this = this;
        this.eGroupClosedIcon.appendChild(Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnSelectClosed', this.gridOptionsWrapper, null));
        this.eGroupOpenedIcon.appendChild(Object(_utils_icon__WEBPACK_IMPORTED_MODULE_3__["createIcon"])('columnSelectOpen', this.gridOptionsWrapper, null));
        this.addManagedListener(this.eTitleBar, 'click', function () { return _this.toggleGroupExpand(); });
        this.addManagedListener(this.eTitleBar, 'keydown', function (e) {
            switch (e.keyCode) {
                case _constants_keyCode__WEBPACK_IMPORTED_MODULE_5__[/* KeyCode */ "a"].ENTER:
                case _constants_keyCode__WEBPACK_IMPORTED_MODULE_5__[/* KeyCode */ "a"].SPACE:
                    e.preventDefault();
                    _this.toggleGroupExpand();
                    break;
                case _constants_keyCode__WEBPACK_IMPORTED_MODULE_5__[/* KeyCode */ "a"].RIGHT:
                case _constants_keyCode__WEBPACK_IMPORTED_MODULE_5__[/* KeyCode */ "a"].LEFT:
                    e.preventDefault();
                    _this.toggleGroupExpand(e.keyCode === _constants_keyCode__WEBPACK_IMPORTED_MODULE_5__[/* KeyCode */ "a"].RIGHT);
                    break;
            }
        });
    };
    AgGroupComponent.prototype.refreshAriaStatus = function () {
        if (!this.suppressOpenCloseIcons) {
            Object(_utils_aria__WEBPACK_IMPORTED_MODULE_6__["setAriaExpanded"])(this.eTitleBar, this.expanded);
        }
    };
    AgGroupComponent.prototype.refreshChildDisplay = function () {
        var showIcon = !this.suppressOpenCloseIcons;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eToolbar, this.expanded && !this.suppressEnabledCheckbox);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eGroupOpenedIcon, showIcon && this.expanded);
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eGroupClosedIcon, showIcon && !this.expanded);
    };
    AgGroupComponent.prototype.isExpanded = function () {
        return this.expanded;
    };
    AgGroupComponent.prototype.setAlignItems = function (alignment) {
        var eGui = this.getGui();
        if (this.alignItems !== alignment) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["removeCssClass"])(eGui, "ag-group-item-alignment-" + this.alignItems);
        }
        this.alignItems = alignment;
        var newCls = "ag-group-item-alignment-" + this.alignItems;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addCssClass"])(eGui, newCls);
        return this;
    };
    AgGroupComponent.prototype.toggleGroupExpand = function (expanded) {
        if (this.suppressOpenCloseIcons) {
            this.expanded = true;
            this.refreshChildDisplay();
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eContainer, true);
            return this;
        }
        expanded = expanded != null ? expanded : !this.expanded;
        if (this.expanded === expanded) {
            return this;
        }
        this.expanded = expanded;
        this.refreshAriaStatus();
        this.refreshChildDisplay();
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eContainer, expanded);
        this.dispatchEvent({ type: this.expanded ? AgGroupComponent.EVENT_EXPANDED : AgGroupComponent.EVENT_COLLAPSED });
        return this;
    };
    AgGroupComponent.prototype.addItems = function (items) {
        var _this = this;
        items.forEach(function (item) { return _this.addItem(item); });
    };
    AgGroupComponent.prototype.addItem = function (item) {
        var container = this.eContainer;
        var el = item instanceof _component__WEBPACK_IMPORTED_MODULE_0__[/* Component */ "a"] ? item.getGui() : item;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addCssClass"])(el, 'ag-group-item');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addCssClass"])(el, "ag-" + this.cssIdentifier + "-group-item");
        container.appendChild(el);
        this.items.push(el);
    };
    AgGroupComponent.prototype.hideItem = function (hide, index) {
        var itemToHide = this.items[index];
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addOrRemoveCssClass"])(itemToHide, 'ag-hidden', hide);
    };
    AgGroupComponent.prototype.setTitle = function (title) {
        this.eTitle.innerText = title;
        return this;
    };
    AgGroupComponent.prototype.addCssClassToTitleBar = function (cssClass) {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addCssClass"])(this.eTitleBar, cssClass);
    };
    AgGroupComponent.prototype.setEnabled = function (enabled, skipToggle) {
        this.enabled = enabled;
        this.refreshDisabledStyles();
        this.toggleGroupExpand(enabled);
        if (!skipToggle) {
            this.cbGroupEnabled.setValue(enabled);
        }
        return this;
    };
    AgGroupComponent.prototype.isEnabled = function () {
        return this.enabled;
    };
    AgGroupComponent.prototype.onEnableChange = function (callbackFn) {
        var _this = this;
        this.cbGroupEnabled.onValueChange(function (newSelection) {
            _this.setEnabled(newSelection, true);
            callbackFn(newSelection);
        });
        return this;
    };
    AgGroupComponent.prototype.hideEnabledCheckbox = function (hide) {
        this.suppressEnabledCheckbox = hide;
        this.refreshChildDisplay();
        this.refreshDisabledStyles();
        return this;
    };
    AgGroupComponent.prototype.hideOpenCloseIcons = function (hide) {
        this.suppressOpenCloseIcons = hide;
        if (hide) {
            this.toggleGroupExpand(true);
        }
        return this;
    };
    AgGroupComponent.prototype.refreshDisabledStyles = function () {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addOrRemoveCssClass"])(this.getGui(), 'ag-disabled', !this.enabled);
        if (this.suppressEnabledCheckbox && !this.enabled) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addCssClass"])(this.eTitleBar, 'ag-disabled-group-title-bar');
            this.eTitleBar.removeAttribute('tabindex');
        }
        else {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["removeCssClass"])(this.eTitleBar, 'ag-disabled-group-title-bar');
            this.eTitleBar.setAttribute('tabindex', '0');
        }
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["addOrRemoveCssClass"])(this.eContainer, 'ag-disabled-group-container', !this.enabled);
    };
    AgGroupComponent.EVENT_EXPANDED = 'expanded';
    AgGroupComponent.EVENT_COLLAPSED = 'collapsed';
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('eTitleBar')
    ], AgGroupComponent.prototype, "eTitleBar", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('eGroupOpenedIcon')
    ], AgGroupComponent.prototype, "eGroupOpenedIcon", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('eGroupClosedIcon')
    ], AgGroupComponent.prototype, "eGroupClosedIcon", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('eToolbar')
    ], AgGroupComponent.prototype, "eToolbar", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('cbGroupEnabled')
    ], AgGroupComponent.prototype, "cbGroupEnabled", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('eTitle')
    ], AgGroupComponent.prototype, "eTitle", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_1__[/* RefSelector */ "a"])('eContainer')
    ], AgGroupComponent.prototype, "eContainer", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_2__[/* PostConstruct */ "e"]
    ], AgGroupComponent.prototype, "postConstruct", null);
    return AgGroupComponent;
}(_component__WEBPACK_IMPORTED_MODULE_0__[/* Component */ "a"]));



/***/ }),

/***/ "3337":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export simpleHttpRequest */
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("7347");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */

function simpleHttpRequest(params) {
    return new _utils__WEBPACK_IMPORTED_MODULE_0__[/* AgPromise */ "a"](function (resolve) {
        var httpRequest = new XMLHttpRequest();
        httpRequest.open('GET', params.url);
        httpRequest.send();
        httpRequest.onreadystatechange = function () {
            if (httpRequest.readyState === 4 && httpRequest.status === 200) {
                resolve(JSON.parse(httpRequest.responseText));
            }
        };
    });
}


/***/ }),

/***/ "3348":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaRole", function() { return setAriaRole; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAriaSortState", function() { return getAriaSortState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAriaLevel", function() { return getAriaLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAriaPosInSet", function() { return getAriaPosInSet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAriaDescribedBy", function() { return getAriaDescribedBy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaLabel", function() { return setAriaLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaLabelledBy", function() { return setAriaLabelledBy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaDescribedBy", function() { return setAriaDescribedBy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaLevel", function() { return setAriaLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaDisabled", function() { return setAriaDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaExpanded", function() { return setAriaExpanded; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeAriaExpanded", function() { return removeAriaExpanded; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaSetSize", function() { return setAriaSetSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaPosInSet", function() { return setAriaPosInSet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaMultiSelectable", function() { return setAriaMultiSelectable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaRowCount", function() { return setAriaRowCount; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaRowIndex", function() { return setAriaRowIndex; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaColCount", function() { return setAriaColCount; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaColIndex", function() { return setAriaColIndex; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaColSpan", function() { return setAriaColSpan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaSort", function() { return setAriaSort; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeAriaSort", function() { return removeAriaSort; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaSelected", function() { return setAriaSelected; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAriaChecked", function() { return setAriaChecked; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
// ARIA HELPER FUNCTIONS
function setAriaAttribute(element, attribute, value) {
    element.setAttribute(ariaAttributeName(attribute), value.toString());
}
function removeAriaAttribute(element, attribute) {
    element.removeAttribute(ariaAttributeName(attribute));
}
function ariaAttributeName(attribute) {
    return "aria-" + attribute;
}
function setAriaRole(element, role) {
    if (role) {
        element.setAttribute('role', role);
    }
    else {
        element.removeAttribute('role');
    }
}
function getAriaSortState(column) {
    var sort;
    if (column.isSortAscending()) {
        sort = 'ascending';
    }
    else if (column.isSortDescending()) {
        sort = 'descending';
    }
    else {
        sort = 'none';
    }
    return sort;
}
// ARIA ATTRIBUTE GETTERS
function getAriaLevel(element) {
    return parseInt(element.getAttribute('aria-level'), 10);
}
function getAriaPosInSet(element) {
    return parseInt(element.getAttribute('aria-posinset'), 10);
}
function getAriaDescribedBy(element) {
    return element.getAttribute('aria-describedby') || '';
}
// ARIA ATTRIBUTE SETTERS
function setAriaLabel(element, label) {
    var key = 'label';
    if (label) {
        setAriaAttribute(element, key, label);
    }
    else {
        removeAriaAttribute(element, key);
    }
}
function setAriaLabelledBy(element, labelledBy) {
    var key = 'labelledby';
    if (labelledBy) {
        setAriaAttribute(element, key, labelledBy);
    }
    else {
        removeAriaAttribute(element, key);
    }
}
function setAriaDescribedBy(element, describedby) {
    var key = 'describedby';
    if (describedby) {
        setAriaAttribute(element, key, describedby);
    }
    else {
        removeAriaAttribute(element, key);
    }
}
function setAriaLevel(element, level) {
    setAriaAttribute(element, 'level', level);
}
function setAriaDisabled(element, disabled) {
    setAriaAttribute(element, 'disabled', disabled);
}
function setAriaExpanded(element, expanded) {
    setAriaAttribute(element, 'expanded', expanded);
}
function removeAriaExpanded(element) {
    removeAriaAttribute(element, 'expanded');
}
function setAriaSetSize(element, setsize) {
    setAriaAttribute(element, 'setsize', setsize);
}
function setAriaPosInSet(element, position) {
    setAriaAttribute(element, 'posinset', position);
}
function setAriaMultiSelectable(element, multiSelectable) {
    setAriaAttribute(element, 'multiselectable', multiSelectable);
}
function setAriaRowCount(element, rowCount) {
    setAriaAttribute(element, 'rowcount', rowCount);
}
function setAriaRowIndex(element, rowIndex) {
    setAriaAttribute(element, 'rowindex', rowIndex);
}
function setAriaColCount(element, colCount) {
    setAriaAttribute(element, 'colcount', colCount);
}
function setAriaColIndex(element, colIndex) {
    setAriaAttribute(element, 'colindex', colIndex);
}
function setAriaColSpan(element, colSpan) {
    setAriaAttribute(element, 'colspan', colSpan);
}
function setAriaSort(element, sort) {
    setAriaAttribute(element, 'sort', sort);
}
function removeAriaSort(element) {
    removeAriaAttribute(element, 'sort');
}
function setAriaSelected(element, selected) {
    var attributeName = 'selected';
    if (selected) {
        setAriaAttribute(element, attributeName, selected);
    }
    else {
        removeAriaAttribute(element, attributeName);
    }
}
function setAriaChecked(element, checked) {
    setAriaAttribute(element, 'checked', checked === undefined ? 'mixed' : checked);
}


/***/ }),

/***/ "342f":
/***/ (function(module, exports, __webpack_require__) {

var getBuiltIn = __webpack_require__("d066");

module.exports = getBuiltIn('navigator', 'userAgent') || '';


/***/ }),

/***/ "3483":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RowPositionUtils; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("59ec");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var RowPositionUtils = /** @class */ (function (_super) {
    __extends(RowPositionUtils, _super);
    function RowPositionUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RowPositionUtils.prototype.getFirstRow = function () {
        var rowIndex = 0;
        var rowPinned;
        if (this.pinnedRowModel.getPinnedTopRowCount()) {
            rowPinned = _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_TOP;
        }
        else if (this.rowModel.getRowCount()) {
            rowPinned = null;
            rowIndex = this.paginationProxy.getPageFirstRow();
        }
        else if (this.pinnedRowModel.getPinnedBottomRowCount()) {
            rowPinned = _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_BOTTOM;
        }
        return rowPinned === undefined ? null : { rowIndex: rowIndex, rowPinned: rowPinned };
    };
    RowPositionUtils.prototype.getLastRow = function () {
        var rowIndex;
        var rowPinned = null;
        var pinnedBottomCount = this.pinnedRowModel.getPinnedBottomRowCount();
        var pinnedTopCount = this.pinnedRowModel.getPinnedTopRowCount();
        if (pinnedBottomCount) {
            rowPinned = _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_BOTTOM;
            rowIndex = pinnedBottomCount - 1;
        }
        else if (this.rowModel.getRowCount()) {
            rowPinned = null;
            rowIndex = this.paginationProxy.getPageLastRow();
        }
        else if (pinnedTopCount) {
            rowPinned = _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_TOP;
            rowIndex = pinnedTopCount - 1;
        }
        return rowIndex === undefined ? null : { rowIndex: rowIndex, rowPinned: rowPinned };
    };
    RowPositionUtils.prototype.getRowNode = function (gridRow) {
        switch (gridRow.rowPinned) {
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_TOP:
                return this.pinnedRowModel.getPinnedTopRowData()[gridRow.rowIndex];
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_BOTTOM:
                return this.pinnedRowModel.getPinnedBottomRowData()[gridRow.rowIndex];
            default:
                return this.rowModel.getRow(gridRow.rowIndex);
        }
    };
    RowPositionUtils.prototype.sameRow = function (rowA, rowB) {
        // if both missing
        if (!rowA && !rowB) {
            return true;
        }
        // if only one missing
        if ((rowA && !rowB) || (!rowA && rowB)) {
            return false;
        }
        // otherwise compare (use == to compare rowPinned because it can be null or undefined)
        return rowA.rowIndex === rowB.rowIndex && rowA.rowPinned == rowB.rowPinned;
    };
    // tests if this row selection is before the other row selection
    RowPositionUtils.prototype.before = function (rowA, rowB) {
        switch (rowA.rowPinned) {
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_TOP:
                // we we are floating top, and other isn't, then we are always before
                if (rowB.rowPinned !== _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_TOP) {
                    return true;
                }
                break;
            case _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_BOTTOM:
                // if we are floating bottom, and the other isn't, then we are never before
                if (rowB.rowPinned !== _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_BOTTOM) {
                    return false;
                }
                break;
            default:
                // if we are not floating, but the other one is floating...
                if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_3__["exists"])(rowB.rowPinned)) {
                    return rowB.rowPinned !== _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_TOP;
                }
                break;
        }
        return rowA.rowIndex < rowB.rowIndex;
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('rowModel')
    ], RowPositionUtils.prototype, "rowModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('pinnedRowModel')
    ], RowPositionUtils.prototype, "pinnedRowModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('paginationProxy')
    ], RowPositionUtils.prototype, "paginationProxy", void 0);
    RowPositionUtils = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('rowPositionUtils')
    ], RowPositionUtils);
    return RowPositionUtils;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "348a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "firstExistingValue", function() { return firstExistingValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "anyExists", function() { return anyExists; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "existsAndNotEmpty", function() { return existsAndNotEmpty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "last", function() { return last; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "areEqual", function() { return areEqual; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "compareArrays", function() { return compareArrays; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shallowCompare", function() { return shallowCompare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sortNumerically", function() { return sortNumerically; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeRepeatsFromArray", function() { return removeRepeatsFromArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeFromArray", function() { return removeFromArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeAllFromArray", function() { return removeAllFromArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertIntoArray", function() { return insertIntoArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertArrayIntoArray", function() { return insertArrayIntoArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "moveInArray", function() { return moveInArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "includes", function() { return includes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "flatten", function() { return flatten; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "pushAll", function() { return pushAll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toStrings", function() { return toStrings; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findIndex", function() { return findIndex; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fill", function() { return fill; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "every", function() { return every; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "some", function() { return some; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "forEach", function() { return forEach; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "forEachReverse", function() { return forEachReverse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "map", function() { return map; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "filter", function() { return filter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reduce", function() { return reduce; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "forEachSnapshotFirst", function() { return forEachSnapshotFirst; });
/* harmony import */ var _generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */

function firstExistingValue() {
    var values = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        values[_i] = arguments[_i];
    }
    for (var i = 0; i < values.length; i++) {
        var value = values[i];
        if (Object(_generic__WEBPACK_IMPORTED_MODULE_0__["exists"])(value)) {
            return value;
        }
    }
    return null;
}
/** @deprecated */
function anyExists(values) {
    return values && firstExistingValue(values) != null;
}
function existsAndNotEmpty(value) {
    return value != null && value.length > 0;
}
function last(arr) {
    if (!arr || !arr.length) {
        return;
    }
    return arr[arr.length - 1];
}
function areEqual(a, b, comparator) {
    if (a == null && b == null) {
        return true;
    }
    return a != null &&
        b != null &&
        a.length === b.length &&
        every(a, function (value, index) { return comparator ? comparator(value, b[index]) : b[index] === value; });
}
/** @deprecated */
function compareArrays(array1, array2) {
    return areEqual(array1, array2);
}
/** @deprecated */
function shallowCompare(arr1, arr2) {
    return areEqual(arr1, arr2);
}
function sortNumerically(array) {
    return array.sort(function (a, b) { return a - b; });
}
function removeRepeatsFromArray(array, object) {
    if (!array) {
        return;
    }
    for (var index = array.length - 2; index >= 0; index--) {
        var thisOneMatches = array[index] === object;
        var nextOneMatches = array[index + 1] === object;
        if (thisOneMatches && nextOneMatches) {
            array.splice(index + 1, 1);
        }
    }
}
function removeFromArray(array, object) {
    var index = array.indexOf(object);
    if (index >= 0) {
        array.splice(index, 1);
    }
}
function removeAllFromArray(array, toRemove) {
    forEach(toRemove, function (item) { return removeFromArray(array, item); });
}
function insertIntoArray(array, object, toIndex) {
    array.splice(toIndex, 0, object);
}
function insertArrayIntoArray(dest, src, toIndex) {
    if (dest == null || src == null) {
        return;
    }
    // put items in backwards, otherwise inserted items end up in reverse order
    for (var i = src.length - 1; i >= 0; i--) {
        var item = src[i];
        insertIntoArray(dest, item, toIndex);
    }
}
function moveInArray(array, objectsToMove, toIndex) {
    // first take out items from the array
    removeAllFromArray(array, objectsToMove);
    // now add the objects, in same order as provided to us, that means we start at the end
    // as the objects will be pushed to the right as they are inserted
    forEach(objectsToMove.slice().reverse(), function (obj) { return insertIntoArray(array, obj, toIndex); });
}
function includes(array, value) {
    return array.indexOf(value) > -1;
}
function flatten(arrayOfArrays) {
    return [].concat.apply([], arrayOfArrays);
}
function pushAll(target, source) {
    if (source == null || target == null) {
        return;
    }
    forEach(source, function (value) { return target.push(value); });
}
function toStrings(array) {
    return map(array, _generic__WEBPACK_IMPORTED_MODULE_0__["toStringOrNull"]);
}
function findIndex(collection, predicate) {
    for (var i = 0; i < collection.length; i++) {
        if (predicate(collection[i], i, collection)) {
            return i;
        }
    }
    return -1;
}
function fill(collection, value, start, end) {
    if (value === void 0) { value = null; }
    if (start === void 0) { start = 0; }
    if (end === void 0) { end = collection.length; }
    for (var i = start; i < end; i++) {
        collection[i] = value;
    }
    return collection;
}
/**
 * The implementation of Array.prototype.every in browsers is always slower than just using a simple for loop, so
 * use this for improved performance.
 * https://jsbench.me/bek91dtit8/
 */
function every(list, predicate) {
    if (list == null) {
        return true;
    }
    for (var i = 0; i < list.length; i++) {
        if (!predicate(list[i], i)) {
            return false;
        }
    }
    return true;
}
/**
 * The implementation of Array.prototype.some in browsers is always slower than just using a simple for loop, so
 * use this for improved performance.
 * https://jsbench.me/5dk91e4tmt/
 */
function some(list, predicate) {
    if (list == null) {
        return false;
    }
    for (var i = 0; i < list.length; i++) {
        if (predicate(list[i], i)) {
            return true;
        }
    }
    return false;
}
/**
 * The implementation of Array.prototype.forEach in browsers is often slower than just using a simple for loop, so
 * use this for improved performance.
 * https://jsbench.me/apk91elt8a/
 */
function forEach(list, action) {
    if (list == null) {
        return;
    }
    for (var i = 0; i < list.length; i++) {
        action(list[i], i);
    }
}
function forEachReverse(list, action) {
    if (list == null) {
        return;
    }
    for (var i = list.length - 1; i >= 0; i--) {
        action(list[i], i);
    }
}
/**
 * The implementation of Array.prototype.map in browsers is generally the same as just using a simple for loop. However,
 * Firefox does exhibit some difference, and this performs no worse in other browsers, so use this if you want improved
 * performance.
 * https://jsbench.me/njk91ez8pc/
 */
function map(list, process) {
    if (list == null) {
        return null;
    }
    var mapped = [];
    for (var i = 0; i < list.length; i++) {
        mapped.push(process(list[i], i));
    }
    return mapped;
}
/**
 * The implementation of Array.prototype.filter in browsers is always slower than just using a simple for loop, so
 * use this for improved performance.
 * https://jsbench.me/7bk91fk08c/
 */
function filter(list, predicate) {
    if (list == null) {
        return null;
    }
    var filtered = [];
    for (var i = 0; i < list.length; i++) {
        if (predicate(list[i], i)) {
            filtered.push(list[i]);
        }
    }
    return filtered;
}
/**
 * The implementation of Array.prototype.reduce in browsers is generally the same as just using a simple for loop. However,
 * Chrome does exhibit some difference, and this performs no worse in other browsers, so use this if you want improved
 * performance.
 * https://jsbench.me/7vk92n6u1f/
 */
function reduce(list, step, initial) {
    if (list == null || initial == null) {
        return null;
    }
    var result = initial;
    for (var i = 0; i < list.length; i++) {
        result = step(result, list[i], i);
    }
    return result;
}
/** @deprecated */
function forEachSnapshotFirst(list, callback) {
    if (!list) {
        return;
    }
    var arrayCopy = list.slice(0);
    arrayCopy.forEach(callback);
}


/***/ }),

/***/ "3522":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ userComponentRegistry_UserComponentRegistry; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/beanStub.js
var beanStub = __webpack_require__("bc71");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/date/dateFilter.js
var dateFilter = __webpack_require__("b09a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/date/dateCompWrapper.js
var dateCompWrapper = __webpack_require__("d0d3");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/componentAnnotations.js
var componentAnnotations = __webpack_require__("6835");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/simpleFilter.js
var simpleFilter = __webpack_require__("cf29");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/floating/provided/simpleFloatingFilter.js
var simpleFloatingFilter = __webpack_require__("532c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/providedFilter.js + 1 modules
var providedFilter = __webpack_require__("5001");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/date.js
var utils_date = __webpack_require__("7aaa");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/function.js
var utils_function = __webpack_require__("e900");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/date/dateFloatingFilter.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};










var dateFloatingFilter_DateFloatingFilter = /** @class */ (function (_super) {
    __extends(DateFloatingFilter, _super);
    function DateFloatingFilter() {
        return _super.call(this, /* html */ "\n            <div class=\"ag-floating-filter-input\" role=\"presentation\">\n                <ag-input-text-field ref=\"eReadOnlyText\"></ag-input-text-field>\n                <div ref=\"eDateWrapper\" style=\"display: flex;\"></div>\n            </div>") || this;
    }
    DateFloatingFilter.prototype.getDefaultFilterOptions = function () {
        return dateFilter["a" /* DateFilter */].DEFAULT_FILTER_OPTIONS;
    };
    DateFloatingFilter.prototype.conditionToString = function (condition) {
        var type = condition.type;
        var dateFrom = Object(utils_date["parseDateTimeFromString"])(condition.dateFrom);
        if (type === simpleFilter["b" /* SimpleFilter */].IN_RANGE) {
            var dateTo = Object(utils_date["parseDateTimeFromString"])(condition.dateTo);
            return Object(utils_date["serialiseDate"])(dateFrom, false) + "-" + Object(utils_date["serialiseDate"])(dateTo, false);
        }
        // cater for when the type doesn't need a value
        return dateFrom == null ? "" + type : "" + Object(utils_date["serialiseDate"])(dateFrom, false);
    };
    DateFloatingFilter.prototype.init = function (params) {
        _super.prototype.init.call(this, params);
        this.params = params;
        this.createDateComponent();
        var translate = this.gridOptionsWrapper.getLocaleTextFunc();
        this.eReadOnlyText
            .setDisabled(true)
            .setInputAriaLabel(translate('ariaDateFilterInput', 'Date Filter Input'));
    };
    DateFloatingFilter.prototype.setEditable = function (editable) {
        Object(dom["setDisplayed"])(this.eDateWrapper, editable);
        Object(dom["setDisplayed"])(this.eReadOnlyText.getGui(), !editable);
    };
    DateFloatingFilter.prototype.onParentModelChanged = function (model, event) {
        // We don't want to update the floating filter if the floating filter caused the change,
        // because the UI is already in sync. if we didn't do this, the UI would behave strangely
        // as it would be updating as the user is typing
        if (this.isEventFromFloatingFilter(event)) {
            return;
        }
        _super.prototype.setLastTypeFromModel.call(this, model);
        var allowEditing = this.canWeEditAfterModelFromParentFilter(model);
        this.setEditable(allowEditing);
        if (allowEditing) {
            if (model) {
                var dateModel = model;
                this.dateComp.setDate(Object(utils_date["parseDateTimeFromString"])(dateModel.dateFrom));
            }
            else {
                this.dateComp.setDate(null);
            }
            this.eReadOnlyText.setValue('');
        }
        else {
            this.eReadOnlyText.setValue(this.getTextFromModel(model));
            this.dateComp.setDate(null);
        }
    };
    DateFloatingFilter.prototype.onDateChanged = function () {
        var _this = this;
        var filterValueDate = this.dateComp.getDate();
        var filterValueText = Object(utils_date["serialiseDate"])(filterValueDate);
        this.params.parentFilterInstance(function (filterInstance) {
            if (filterInstance) {
                var simpleFilter = filterInstance;
                simpleFilter.onFloatingFilterChanged(_this.getLastType(), filterValueText);
            }
        });
    };
    DateFloatingFilter.prototype.createDateComponent = function () {
        var _this = this;
        var debounceMs = providedFilter["a" /* ProvidedFilter */].getDebounceMs(this.params.filterParams, this.getDefaultDebounceMs());
        var dateComponentParams = {
            onDateChanged: Object(utils_function["debounce"])(this.onDateChanged.bind(this), debounceMs),
            filterParams: this.params.column.getColDef().filterParams
        };
        this.dateComp = new dateCompWrapper["a" /* DateCompWrapper */](this.getContext(), this.userComponentFactory, dateComponentParams, this.eDateWrapper);
        this.addDestroyFunc(function () { return _this.dateComp.destroy(); });
    };
    __decorate([
        Object(context["a" /* Autowired */])('userComponentFactory')
    ], DateFloatingFilter.prototype, "userComponentFactory", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eReadOnlyText')
    ], DateFloatingFilter.prototype, "eReadOnlyText", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eDateWrapper')
    ], DateFloatingFilter.prototype, "eDateWrapper", void 0);
    return DateFloatingFilter;
}(simpleFloatingFilter["a" /* SimpleFloatingFilter */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/browser.js
var browser = __webpack_require__("b8d2");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/date/defaultDateComponent.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var defaultDateComponent_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var defaultDateComponent_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var defaultDateComponent_DefaultDateComponent = /** @class */ (function (_super) {
    defaultDateComponent_extends(DefaultDateComponent, _super);
    function DefaultDateComponent() {
        return _super.call(this, /* html */ "\n            <div class=\"ag-filter-filter\">\n                <ag-input-text-field class=\"ag-date-filter\" ref=\"eDateInput\"></ag-input-text-field>\n            </div>") || this;
    }
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    DefaultDateComponent.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    DefaultDateComponent.prototype.init = function (params) {
        var inputElement = this.eDateInput.getInputElement();
        if (this.shouldUseBrowserDatePicker(params)) {
            if (Object(browser["isBrowserIE"])()) {
                console.warn('ag-grid: browserDatePicker is specified to true, but it is not supported in IE 11; reverting to text date picker');
            }
            else {
                inputElement.type = 'date';
            }
        }
        // ensures that the input element is focussed when a clear button is clicked
        this.addManagedListener(inputElement, 'mousedown', function () { return inputElement.focus(); });
        this.addManagedListener(this.eDateInput.getInputElement(), 'input', function (e) {
            if (e.target !== document.activeElement) {
                return;
            }
            params.onDateChanged();
        });
    };
    DefaultDateComponent.prototype.getDate = function () {
        return Object(utils_date["parseDateTimeFromString"])(this.eDateInput.getValue());
    };
    DefaultDateComponent.prototype.setDate = function (date) {
        this.eDateInput.setValue(Object(utils_date["serialiseDate"])(date, false));
    };
    DefaultDateComponent.prototype.setInputPlaceholder = function (placeholder) {
        this.eDateInput.setInputPlaceholder(placeholder);
    };
    DefaultDateComponent.prototype.afterGuiAttached = function (params) {
        if (!params || !params.suppressFocus) {
            this.eDateInput.getInputElement().focus();
        }
    };
    DefaultDateComponent.prototype.shouldUseBrowserDatePicker = function (params) {
        if (params.filterParams && params.filterParams.browserDatePicker != null) {
            return params.filterParams.browserDatePicker;
        }
        return Object(browser["isBrowserChrome"])() || Object(browser["isBrowserFirefox"])();
    };
    defaultDateComponent_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eDateInput')
    ], DefaultDateComponent.prototype, "eDateInput", void 0);
    return DefaultDateComponent;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/number/numberFilter.js
var numberFilter = __webpack_require__("41a1");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/floating/provided/textInputFloatingFilter.js
var textInputFloatingFilter = __webpack_require__("9147");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/number/numberFloatingFilter.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var numberFloatingFilter_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var numberFloatingFilter_NumberFloatingFilter = /** @class */ (function (_super) {
    numberFloatingFilter_extends(NumberFloatingFilter, _super);
    function NumberFloatingFilter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NumberFloatingFilter.prototype.getDefaultFilterOptions = function () {
        return numberFilter["a" /* NumberFilter */].DEFAULT_FILTER_OPTIONS;
    };
    NumberFloatingFilter.prototype.conditionToString = function (condition) {
        var isRange = condition.type == simpleFilter["b" /* SimpleFilter */].IN_RANGE;
        if (isRange) {
            return condition.filter + "-" + condition.filterTo;
        }
        // cater for when the type doesn't need a value
        if (condition.filter != null) {
            return "" + condition.filter;
        }
        return "" + condition.type;
    };
    return NumberFloatingFilter;
}(textInputFloatingFilter["a" /* TextInputFloatingFilter */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/text/textFilter.js
var textFilter = __webpack_require__("1294");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/text/textFloatingFilter.js
var textFloatingFilter = __webpack_require__("d29e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/column.js
var entities_column = __webpack_require__("70d4");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/events.js
var events = __webpack_require__("ad5d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/array.js
var array = __webpack_require__("348a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/generic.js
var generic = __webpack_require__("a74a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/icon.js
var icon = __webpack_require__("781c");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/string.js
var string = __webpack_require__("0e94");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/touchListener.js
var widgets_touchListener = __webpack_require__("ec7d");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/column/headerComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var headerComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var headerComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};












var headerComp_HeaderComp = /** @class */ (function (_super) {
    headerComp_extends(HeaderComp, _super);
    function HeaderComp() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lastMovingChanged = 0;
        return _this;
    }
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    HeaderComp.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    HeaderComp.prototype.refresh = function (params) {
        this.params = params;
        // if template changed, then recreate the whole comp, the code required to manage
        // a changing template is to difficult for what it's worth.
        if (this.workOutTemplate() != this.currentTemplate) {
            return false;
        }
        if (this.workOutShowMenu() != this.currentShowMenu) {
            return false;
        }
        if (this.workOutSort() != this.currentSort) {
            return false;
        }
        this.setDisplayName(params);
        return true;
    };
    HeaderComp.prototype.workOutTemplate = function () {
        var template = Object(array["firstExistingValue"])(this.params.template, HeaderComp.TEMPLATE);
        // take account of any newlines & whitespace before/after the actual template
        template = template && template.trim ? template.trim() : template;
        return template;
    };
    HeaderComp.prototype.init = function (params) {
        this.params = params;
        this.currentTemplate = this.workOutTemplate();
        this.setTemplate(this.currentTemplate);
        this.setupTap();
        this.setupIcons(params.column);
        this.setMenu();
        this.setupSort();
        this.setupFilterIcon();
        this.setDisplayName(params);
    };
    HeaderComp.prototype.setDisplayName = function (params) {
        if (this.currentDisplayName != params.displayName) {
            this.currentDisplayName = params.displayName;
            var displayNameSanitised = Object(string["escapeString"])(this.currentDisplayName);
            if (this.eText) {
                this.eText.innerHTML = displayNameSanitised;
            }
        }
    };
    HeaderComp.prototype.setupIcons = function (column) {
        this.addInIcon('sortAscending', this.eSortAsc, column);
        this.addInIcon('sortDescending', this.eSortDesc, column);
        this.addInIcon('sortUnSort', this.eSortNone, column);
        this.addInIcon('menu', this.eMenu, column);
        this.addInIcon('filter', this.eFilter, column);
    };
    HeaderComp.prototype.addInIcon = function (iconName, eParent, column) {
        if (eParent == null) {
            return;
        }
        var eIcon = Object(icon["createIconNoSpan"])(iconName, this.gridOptionsWrapper, column);
        if (eIcon) {
            eParent.appendChild(eIcon);
        }
    };
    HeaderComp.prototype.setupTap = function () {
        var _this = this;
        var options = this.gridOptionsWrapper;
        if (options.isSuppressTouch()) {
            return;
        }
        var touchListener = new widgets_touchListener["a" /* TouchListener */](this.getGui(), true);
        var suppressMenuHide = options.isSuppressMenuHide();
        var tapMenuButton = suppressMenuHide && Object(generic["exists"])(this.eMenu);
        var menuTouchListener = tapMenuButton ? new widgets_touchListener["a" /* TouchListener */](this.eMenu, true) : touchListener;
        if (this.params.enableMenu) {
            var eventType = tapMenuButton ? 'EVENT_TAP' : 'EVENT_LONG_TAP';
            var showMenuFn = function (event) {
                options.getApi().showColumnMenuAfterMouseClick(_this.params.column, event.touchStart);
            };
            this.addManagedListener(menuTouchListener, widgets_touchListener["a" /* TouchListener */][eventType], showMenuFn);
        }
        if (this.params.enableSorting) {
            var tapListener = function (event) {
                var target = event.touchStart.target;
                // When suppressMenuHide is true, a tap on the menu icon will bubble up
                // to the header container, in that case we should not sort
                if (suppressMenuHide && _this.eMenu.contains(target)) {
                    return;
                }
                _this.sortController.progressSort(_this.params.column, false, "uiColumnSorted");
            };
            this.addManagedListener(touchListener, widgets_touchListener["a" /* TouchListener */].EVENT_TAP, tapListener);
        }
        // if tapMenuButton is true `touchListener` and `menuTouchListener` are different
        // so we need to make sure to destroy both listeners here
        this.addDestroyFunc(function () { return touchListener.destroy(); });
        if (tapMenuButton) {
            this.addDestroyFunc(function () { return menuTouchListener.destroy(); });
        }
    };
    HeaderComp.prototype.workOutShowMenu = function () {
        // we don't show the menu if on an iPad/iPhone, as the user cannot have a pointer device/
        // However if suppressMenuHide is set to true the menu will be displayed alwasys, so it's ok
        // to show it on iPad in this case (as hover isn't needed). If suppressMenuHide
        // is false (default) user will need to use longpress to display the menu.
        var menuHides = !this.gridOptionsWrapper.isSuppressMenuHide();
        var onIpadAndMenuHides = Object(browser["isIOSUserAgent"])() && menuHides;
        var showMenu = this.params.enableMenu && !onIpadAndMenuHides;
        return showMenu;
    };
    HeaderComp.prototype.setMenu = function () {
        var _this = this;
        // if no menu provided in template, do nothing
        if (!this.eMenu) {
            return;
        }
        this.currentShowMenu = this.workOutShowMenu();
        if (!this.currentShowMenu) {
            Object(dom["removeFromParent"])(this.eMenu);
            return;
        }
        var suppressMenuHide = this.gridOptionsWrapper.isSuppressMenuHide();
        this.addManagedListener(this.eMenu, 'click', function () { return _this.showMenu(_this.eMenu); });
        Object(dom["addOrRemoveCssClass"])(this.eMenu, 'ag-header-menu-always-show', suppressMenuHide);
    };
    HeaderComp.prototype.showMenu = function (eventSource) {
        if (!eventSource) {
            eventSource = this.eMenu;
        }
        this.menuFactory.showMenuAfterButtonClick(this.params.column, eventSource, 'columnMenu');
    };
    HeaderComp.prototype.removeSortIcons = function () {
        Object(dom["removeFromParent"])(this.eSortAsc);
        Object(dom["removeFromParent"])(this.eSortDesc);
        Object(dom["removeFromParent"])(this.eSortNone);
        Object(dom["removeFromParent"])(this.eSortOrder);
    };
    HeaderComp.prototype.workOutSort = function () {
        return this.params.enableSorting;
    };
    HeaderComp.prototype.setupSort = function () {
        var _this = this;
        this.currentSort = this.params.enableSorting;
        if (!this.currentSort) {
            this.removeSortIcons();
            return;
        }
        var sortUsingCtrl = this.gridOptionsWrapper.isMultiSortKeyCtrl();
        // keep track of last time the moving changed flag was set
        this.addManagedListener(this.params.column, entities_column["a" /* Column */].EVENT_MOVING_CHANGED, function () {
            _this.lastMovingChanged = new Date().getTime();
        });
        // add the event on the header, so when clicked, we do sorting
        if (this.eLabel) {
            this.addManagedListener(this.eLabel, 'click', function (event) {
                // sometimes when moving a column via dragging, this was also firing a clicked event.
                // here is issue raised by user: https://ag-grid.zendesk.com/agent/tickets/1076
                // this check stops sort if a) column is moving or b) column moved less than 200ms ago (so caters for race condition)
                var moving = _this.params.column.isMoving();
                var nowTime = new Date().getTime();
                // typically there is <2ms if moving flag was set recently, as it would be done in same VM turn
                var movedRecently = (nowTime - _this.lastMovingChanged) < 50;
                var columnMoving = moving || movedRecently;
                if (!columnMoving) {
                    var multiSort = sortUsingCtrl ? (event.ctrlKey || event.metaKey) : event.shiftKey;
                    _this.params.progressSort(multiSort);
                }
            });
        }
        this.addManagedListener(this.params.column, entities_column["a" /* Column */].EVENT_SORT_CHANGED, this.onSortChanged.bind(this));
        this.onSortChanged();
        this.addManagedListener(this.eventService, events["a" /* Events */].EVENT_SORT_CHANGED, this.setMultiSortOrder.bind(this));
        this.setMultiSortOrder();
    };
    HeaderComp.prototype.onSortChanged = function () {
        Object(dom["addOrRemoveCssClass"])(this.getGui(), 'ag-header-cell-sorted-asc', this.params.column.isSortAscending());
        Object(dom["addOrRemoveCssClass"])(this.getGui(), 'ag-header-cell-sorted-desc', this.params.column.isSortDescending());
        Object(dom["addOrRemoveCssClass"])(this.getGui(), 'ag-header-cell-sorted-none', this.params.column.isSortNone());
        if (this.eSortAsc) {
            Object(dom["addOrRemoveCssClass"])(this.eSortAsc, 'ag-hidden', !this.params.column.isSortAscending());
        }
        if (this.eSortDesc) {
            Object(dom["addOrRemoveCssClass"])(this.eSortDesc, 'ag-hidden', !this.params.column.isSortDescending());
        }
        if (this.eSortNone) {
            var alwaysHideNoSort = !this.params.column.getColDef().unSortIcon && !this.gridOptionsWrapper.isUnSortIcon();
            Object(dom["addOrRemoveCssClass"])(this.eSortNone, 'ag-hidden', alwaysHideNoSort || !this.params.column.isSortNone());
        }
    };
    // we listen here for global sort events, NOT column sort events, as we want to do this
    // when sorting has been set on all column (if we listened just for our col (where we
    // set the asc / desc icons) then it's possible other cols are yet to get their sorting state.
    HeaderComp.prototype.setMultiSortOrder = function () {
        if (!this.eSortOrder) {
            return;
        }
        var col = this.params.column;
        var allColumnsWithSorting = this.sortController.getColumnsWithSortingOrdered();
        var indexThisCol = allColumnsWithSorting.indexOf(col);
        var moreThanOneColSorting = allColumnsWithSorting.length > 1;
        var showIndex = col.isSorting() && moreThanOneColSorting;
        Object(dom["setDisplayed"])(this.eSortOrder, showIndex);
        if (indexThisCol >= 0) {
            this.eSortOrder.innerHTML = (indexThisCol + 1).toString();
        }
        else {
            Object(dom["clearElement"])(this.eSortOrder);
        }
    };
    HeaderComp.prototype.setupFilterIcon = function () {
        if (!this.eFilter) {
            return;
        }
        this.addManagedListener(this.params.column, entities_column["a" /* Column */].EVENT_FILTER_CHANGED, this.onFilterChanged.bind(this));
        this.onFilterChanged();
    };
    HeaderComp.prototype.onFilterChanged = function () {
        var filterPresent = this.params.column.isFilterActive();
        Object(dom["addOrRemoveCssClass"])(this.eFilter, 'ag-hidden', !filterPresent);
    };
    HeaderComp.TEMPLATE = "<div class=\"ag-cell-label-container\" role=\"presentation\">\n            <span ref=\"eMenu\" class=\"ag-header-icon ag-header-cell-menu-button\" aria-hidden=\"true\"></span>\n            <div ref=\"eLabel\" class=\"ag-header-cell-label\" role=\"presentation\" unselectable=\"on\">\n                <span ref=\"eText\" class=\"ag-header-cell-text\" unselectable=\"on\"></span>\n                <span ref=\"eFilter\" class=\"ag-header-icon ag-header-label-icon ag-filter-icon\" aria-hidden=\"true\"></span>\n                <span ref=\"eSortOrder\" class=\"ag-header-icon ag-header-label-icon ag-sort-order\" aria-hidden=\"true\"></span>\n                <span ref=\"eSortAsc\" class=\"ag-header-icon ag-header-label-icon ag-sort-ascending-icon\" aria-hidden=\"true\"></span>\n                <span ref=\"eSortDesc\" class=\"ag-header-icon ag-header-label-icon ag-sort-descending-icon\" aria-hidden=\"true\"></span>\n                <span ref=\"eSortNone\" class=\"ag-header-icon ag-header-label-icon ag-sort-none-icon\" aria-hidden=\"true\"></span>\n            </div>\n        </div>";
    headerComp_decorate([
        Object(context["a" /* Autowired */])('sortController')
    ], HeaderComp.prototype, "sortController", void 0);
    headerComp_decorate([
        Object(context["a" /* Autowired */])('menuFactory')
    ], HeaderComp.prototype, "menuFactory", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eFilter')
    ], HeaderComp.prototype, "eFilter", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eSortAsc')
    ], HeaderComp.prototype, "eSortAsc", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eSortDesc')
    ], HeaderComp.prototype, "eSortDesc", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eSortNone')
    ], HeaderComp.prototype, "eSortNone", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eSortOrder')
    ], HeaderComp.prototype, "eSortOrder", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eMenu')
    ], HeaderComp.prototype, "eMenu", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eLabel')
    ], HeaderComp.prototype, "eLabel", void 0);
    headerComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eText')
    ], HeaderComp.prototype, "eText", void 0);
    return HeaderComp;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/entities/providedColumnGroup.js
var providedColumnGroup = __webpack_require__("d78e");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/event.js
var utils_event = __webpack_require__("ac61");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/headerRendering/cells/columnGroup/headerGroupComp.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var headerGroupComp_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var headerGroupComp_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};











var headerGroupComp_HeaderGroupComp = /** @class */ (function (_super) {
    headerGroupComp_extends(HeaderGroupComp, _super);
    function HeaderGroupComp() {
        return _super.call(this, HeaderGroupComp.TEMPLATE) || this;
    }
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    HeaderGroupComp.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    HeaderGroupComp.prototype.init = function (params) {
        this.params = params;
        this.checkWarnings();
        this.setupLabel();
        this.addGroupExpandIcon();
        this.setupExpandIcons();
    };
    HeaderGroupComp.prototype.checkWarnings = function () {
        var paramsAny = this.params;
        if (paramsAny.template) {
            var message_1 = "A template was provided for Header Group Comp - templates are only supported for Header Comps (not groups)";
            Object(utils_function["doOnce"])(function () { return console.warn(message_1); }, 'HeaderGroupComp.templateNotSupported');
        }
    };
    HeaderGroupComp.prototype.setupExpandIcons = function () {
        var _this = this;
        this.addInIcon("columnGroupOpened", "agOpened");
        this.addInIcon("columnGroupClosed", "agClosed");
        var expandAction = function (event) {
            if (Object(utils_event["isStopPropagationForAgGrid"])(event)) {
                return;
            }
            var newExpandedValue = !_this.params.columnGroup.isExpanded();
            _this.columnModel.setColumnGroupOpened(_this.params.columnGroup.getOriginalColumnGroup(), newExpandedValue, "uiColumnExpanded");
        };
        this.addTouchAndClickListeners(this.eCloseIcon, expandAction);
        this.addTouchAndClickListeners(this.eOpenIcon, expandAction);
        var stopPropagationAction = function (event) {
            Object(utils_event["stopPropagationForAgGrid"])(event);
        };
        // adding stopPropagation to the double click for the icons prevents double click action happening
        // when the icons are clicked. if the icons are double clicked, then the groups should open and
        // then close again straight away. if we also listened to double click, then the group would open,
        // close, then open, which is not what we want. double click should only action if the user double
        // clicks outside of the icons.
        this.addManagedListener(this.eCloseIcon, "dblclick", stopPropagationAction);
        this.addManagedListener(this.eOpenIcon, "dblclick", stopPropagationAction);
        this.addManagedListener(this.getGui(), "dblclick", expandAction);
        this.updateIconVisibility();
        var originalColumnGroup = this.params.columnGroup.getOriginalColumnGroup();
        this.addManagedListener(originalColumnGroup, providedColumnGroup["a" /* ProvidedColumnGroup */].EVENT_EXPANDED_CHANGED, this.updateIconVisibility.bind(this));
        this.addManagedListener(originalColumnGroup, providedColumnGroup["a" /* ProvidedColumnGroup */].EVENT_EXPANDABLE_CHANGED, this.updateIconVisibility.bind(this));
    };
    HeaderGroupComp.prototype.addTouchAndClickListeners = function (eElement, action) {
        var touchListener = new widgets_touchListener["a" /* TouchListener */](eElement, true);
        this.addManagedListener(touchListener, widgets_touchListener["a" /* TouchListener */].EVENT_TAP, action);
        this.addDestroyFunc(function () { return touchListener.destroy(); });
        this.addManagedListener(eElement, "click", action);
    };
    HeaderGroupComp.prototype.updateIconVisibility = function () {
        var columnGroup = this.params.columnGroup;
        if (columnGroup.isExpandable()) {
            var expanded = this.params.columnGroup.isExpanded();
            Object(dom["setDisplayed"])(this.eOpenIcon, expanded);
            Object(dom["setDisplayed"])(this.eCloseIcon, !expanded);
        }
        else {
            Object(dom["setDisplayed"])(this.eOpenIcon, false);
            Object(dom["setDisplayed"])(this.eCloseIcon, false);
        }
    };
    HeaderGroupComp.prototype.addInIcon = function (iconName, refName) {
        var eIcon = Object(icon["createIconNoSpan"])(iconName, this.gridOptionsWrapper, null);
        if (eIcon) {
            this.getRefElement(refName).appendChild(eIcon);
        }
    };
    HeaderGroupComp.prototype.addGroupExpandIcon = function () {
        if (!this.params.columnGroup.isExpandable()) {
            Object(dom["setDisplayed"])(this.eOpenIcon, false);
            Object(dom["setDisplayed"])(this.eCloseIcon, false);
            return;
        }
    };
    HeaderGroupComp.prototype.setupLabel = function () {
        // no renderer, default text render
        var displayName = this.params.displayName;
        if (Object(generic["exists"])(displayName)) {
            var displayNameSanitised = Object(string["escapeString"])(displayName);
            this.getRefElement('agLabel').innerHTML = displayNameSanitised;
        }
    };
    HeaderGroupComp.TEMPLATE = "<div class=\"ag-header-group-cell-label\" ref=\"agContainer\" role=\"presentation\">\n            <span ref=\"agLabel\" class=\"ag-header-group-text\" role=\"presentation\"></span>\n            <span ref=\"agOpened\" class=\"ag-header-icon ag-header-expand-icon ag-header-expand-icon-expanded\"></span>\n            <span ref=\"agClosed\" class=\"ag-header-icon ag-header-expand-icon ag-header-expand-icon-collapsed\"></span>\n        </div>";
    headerGroupComp_decorate([
        Object(context["a" /* Autowired */])("columnModel")
    ], HeaderGroupComp.prototype, "columnModel", void 0);
    headerGroupComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])("agOpened")
    ], HeaderGroupComp.prototype, "eOpenIcon", void 0);
    headerGroupComp_decorate([
        Object(componentAnnotations["a" /* RefSelector */])("agClosed")
    ], HeaderGroupComp.prototype, "eCloseIcon", void 0);
    return HeaderGroupComp;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellEditors/largeTextCellEditor.js
var largeTextCellEditor = __webpack_require__("bde0");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellEditors/popupSelectCellEditor.js
var popupSelectCellEditor = __webpack_require__("7548");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellEditors/popupTextCellEditor.js
var popupTextCellEditor = __webpack_require__("d86f");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellEditors/selectCellEditor.js
var selectCellEditor = __webpack_require__("be7d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellEditors/textCellEditor.js
var textCellEditor = __webpack_require__("f1fd");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellRenderers/animateShowChangeCellRenderer.js
var animateShowChangeCellRenderer = __webpack_require__("20ba");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellRenderers/animateSlideCellRenderer.js
var animateSlideCellRenderer = __webpack_require__("cafa");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellRenderers/groupCellRenderer.js
var groupCellRenderer = __webpack_require__("6f6e");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/cellRenderers/loadingCellRenderer.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var loadingCellRenderer_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var loadingCellRenderer_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var loadingCellRenderer_LoadingCellRenderer = /** @class */ (function (_super) {
    loadingCellRenderer_extends(LoadingCellRenderer, _super);
    function LoadingCellRenderer() {
        return _super.call(this, LoadingCellRenderer.TEMPLATE) || this;
    }
    LoadingCellRenderer.prototype.init = function (params) {
        params.node.failedLoad ? this.setupFailed() : this.setupLoading();
    };
    LoadingCellRenderer.prototype.setupFailed = function () {
        this.eLoadingText.innerText = 'ERR';
    };
    LoadingCellRenderer.prototype.setupLoading = function () {
        var eLoadingIcon = Object(icon["createIconNoSpan"])('groupLoading', this.gridOptionsWrapper, null);
        if (eLoadingIcon) {
            this.eLoadingIcon.appendChild(eLoadingIcon);
        }
        var localeTextFunc = this.gridOptionsWrapper.getLocaleTextFunc();
        this.eLoadingText.innerText = localeTextFunc('loadingOoo', 'Loading');
    };
    LoadingCellRenderer.prototype.refresh = function (params) {
        return false;
    };
    LoadingCellRenderer.TEMPLATE = "<div class=\"ag-loading\">\n            <span class=\"ag-loading-icon\" ref=\"eLoadingIcon\"></span>\n            <span class=\"ag-loading-text\" ref=\"eLoadingText\"></span>\n        </div>";
    loadingCellRenderer_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eLoadingIcon')
    ], LoadingCellRenderer.prototype, "eLoadingIcon", void 0);
    loadingCellRenderer_decorate([
        Object(componentAnnotations["a" /* RefSelector */])('eLoadingText')
    ], LoadingCellRenderer.prototype, "eLoadingText", void 0);
    return LoadingCellRenderer;
}(component["a" /* Component */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/overlays/loadingOverlayComponent.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var loadingOverlayComponent_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var LoadingOverlayComponent = /** @class */ (function (_super) {
    loadingOverlayComponent_extends(LoadingOverlayComponent, _super);
    function LoadingOverlayComponent() {
        return _super.call(this) || this;
    }
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    LoadingOverlayComponent.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    LoadingOverlayComponent.prototype.init = function (params) {
        var template = this.gridOptionsWrapper.getOverlayLoadingTemplate() ?
            this.gridOptionsWrapper.getOverlayLoadingTemplate() : LoadingOverlayComponent.DEFAULT_LOADING_OVERLAY_TEMPLATE;
        var localeTextFunc = this.gridOptionsWrapper.getLocaleTextFunc();
        var localisedTemplate = template.replace('[LOADING...]', localeTextFunc('loadingOoo', 'Loading...'));
        this.setTemplate(localisedTemplate);
    };
    LoadingOverlayComponent.DEFAULT_LOADING_OVERLAY_TEMPLATE = '<span class="ag-overlay-loading-center">[LOADING...]</span>';
    return LoadingOverlayComponent;
}(component["a" /* Component */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/overlays/noRowsOverlayComponent.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var noRowsOverlayComponent_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var NoRowsOverlayComponent = /** @class */ (function (_super) {
    noRowsOverlayComponent_extends(NoRowsOverlayComponent, _super);
    function NoRowsOverlayComponent() {
        return _super.call(this) || this;
    }
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    NoRowsOverlayComponent.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    NoRowsOverlayComponent.prototype.init = function (params) {
        var template = this.gridOptionsWrapper.getOverlayNoRowsTemplate() ?
            this.gridOptionsWrapper.getOverlayNoRowsTemplate() : NoRowsOverlayComponent.DEFAULT_NO_ROWS_TEMPLATE;
        var localeTextFunc = this.gridOptionsWrapper.getLocaleTextFunc();
        var localisedTemplate = template.replace('[NO_ROWS_TO_SHOW]', localeTextFunc('noRowsToShow', 'No Rows To Show'));
        this.setTemplate(localisedTemplate);
    };
    NoRowsOverlayComponent.DEFAULT_NO_ROWS_TEMPLATE = '<span class="ag-overlay-no-rows-center">[NO_ROWS_TO_SHOW]</span>';
    return NoRowsOverlayComponent;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/popupComponent.js
var popupComponent = __webpack_require__("bdb9");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/rendering/tooltipComponent.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var tooltipComponent_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var tooltipComponent_TooltipComponent = /** @class */ (function (_super) {
    tooltipComponent_extends(TooltipComponent, _super);
    function TooltipComponent() {
        return _super.call(this, /* html */ "<div class=\"ag-tooltip\"></div>") || this;
    }
    // will need to type params
    TooltipComponent.prototype.init = function (params) {
        var value = params.value;
        this.getGui().innerHTML = Object(string["escapeString"])(value);
    };
    return TooltipComponent;
}(popupComponent["a" /* PopupComponent */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/object.js
var object = __webpack_require__("562d");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/components/framework/userComponentRegistry.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var userComponentRegistry_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var userComponentRegistry_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};

























var userComponentRegistry_UserComponentRegistry = /** @class */ (function (_super) {
    userComponentRegistry_extends(UserComponentRegistry, _super);
    function UserComponentRegistry() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.agGridDefaults = {
            //date
            agDateInput: defaultDateComponent_DefaultDateComponent,
            //header
            agColumnHeader: headerComp_HeaderComp,
            agColumnGroupHeader: headerGroupComp_HeaderGroupComp,
            //floating filters
            agTextColumnFloatingFilter: textFloatingFilter["a" /* TextFloatingFilter */],
            agNumberColumnFloatingFilter: numberFloatingFilter_NumberFloatingFilter,
            agDateColumnFloatingFilter: dateFloatingFilter_DateFloatingFilter,
            // renderers
            agAnimateShowChangeCellRenderer: animateShowChangeCellRenderer["a" /* AnimateShowChangeCellRenderer */],
            agAnimateSlideCellRenderer: animateSlideCellRenderer["a" /* AnimateSlideCellRenderer */],
            agGroupCellRenderer: groupCellRenderer["a" /* GroupCellRenderer */],
            agGroupRowRenderer: groupCellRenderer["a" /* GroupCellRenderer */],
            agLoadingCellRenderer: loadingCellRenderer_LoadingCellRenderer,
            //editors
            agCellEditor: textCellEditor["a" /* TextCellEditor */],
            agTextCellEditor: textCellEditor["a" /* TextCellEditor */],
            agSelectCellEditor: selectCellEditor["a" /* SelectCellEditor */],
            agPopupTextCellEditor: popupTextCellEditor["a" /* PopupTextCellEditor */],
            agPopupSelectCellEditor: popupSelectCellEditor["a" /* PopupSelectCellEditor */],
            agLargeTextCellEditor: largeTextCellEditor["a" /* LargeTextCellEditor */],
            //filter
            agTextColumnFilter: textFilter["a" /* TextFilter */],
            agNumberColumnFilter: numberFilter["a" /* NumberFilter */],
            agDateColumnFilter: dateFilter["a" /* DateFilter */],
            //overlays
            agLoadingOverlay: LoadingOverlayComponent,
            agNoRowsOverlay: NoRowsOverlayComponent,
            // tooltips
            agTooltipComponent: tooltipComponent_TooltipComponent
        };
        _this.agDeprecatedNames = {
            set: {
                newComponentName: 'agSetColumnFilter',
                propertyHolder: 'filter'
            },
            text: {
                newComponentName: 'agTextColumnFilter',
                propertyHolder: 'filter'
            },
            number: {
                newComponentName: 'agNumberColumnFilter',
                propertyHolder: 'filter'
            },
            date: {
                newComponentName: 'agDateColumnFilter',
                propertyHolder: 'filter'
            },
            group: {
                newComponentName: 'agGroupCellRenderer',
                propertyHolder: 'cellRenderer'
            },
            animateShowChange: {
                newComponentName: 'agAnimateShowChangeCellRenderer',
                propertyHolder: 'cellRenderer'
            },
            animateSlide: {
                newComponentName: 'agAnimateSlideCellRenderer',
                propertyHolder: 'cellRenderer'
            },
            select: {
                newComponentName: 'agSelectCellEditor',
                propertyHolder: 'cellEditor'
            },
            largeText: {
                newComponentName: 'agLargeTextCellEditor',
                propertyHolder: 'cellEditor'
            },
            popupSelect: {
                newComponentName: 'agPopupSelectCellEditor',
                propertyHolder: 'cellEditor'
            },
            popupText: {
                newComponentName: 'agPopupTextCellEditor',
                propertyHolder: 'cellEditor'
            },
            richSelect: {
                newComponentName: 'agRichSelectCellEditor',
                propertyHolder: 'cellEditor'
            },
            headerComponent: {
                newComponentName: 'agColumnHeader',
                propertyHolder: 'headerComponent'
            }
        };
        _this.jsComponents = {};
        _this.frameworkComponents = {};
        return _this;
    }
    UserComponentRegistry.prototype.init = function () {
        var _this = this;
        if (this.gridOptions.components != null) {
            Object(object["iterateObject"])(this.gridOptions.components, function (key, component) { return _this.registerComponent(key, component); });
        }
        if (this.gridOptions.frameworkComponents != null) {
            Object(object["iterateObject"])(this.gridOptions.frameworkComponents, function (key, component) { return _this.registerFwComponent(key, component); });
        }
    };
    UserComponentRegistry.prototype.registerDefaultComponent = function (rawName, component) {
        var name = this.translateIfDeprecated(rawName);
        if (this.agGridDefaults[name]) {
            console.error("Trying to overwrite a default component. You should call registerComponent");
            return;
        }
        this.agGridDefaults[name] = component;
    };
    UserComponentRegistry.prototype.registerComponent = function (rawName, component) {
        var name = this.translateIfDeprecated(rawName);
        if (this.frameworkComponents[name]) {
            console.error("Trying to register a component that you have already registered for frameworks: " + name);
            return;
        }
        this.jsComponents[name] = component;
    };
    /**
     * B the business interface (ie IHeader)
     * A the agGridComponent interface (ie IHeaderComp). The final object acceptable by ag-grid
     */
    UserComponentRegistry.prototype.registerFwComponent = function (rawName, component) {
        var name = this.translateIfDeprecated(rawName);
        if (this.jsComponents[name]) {
            console.error("Trying to register a component that you have already registered for plain javascript: " + name);
            return;
        }
        this.frameworkComponents[name] = component;
    };
    UserComponentRegistry.prototype.retrieve = function (rawName) {
        var name = this.translateIfDeprecated(rawName);
        var frameworkComponent = this.frameworkComponents[name] || this.getFrameworkOverrides().frameworkComponent(name);
        if (frameworkComponent) {
            return {
                componentFromFramework: true,
                component: frameworkComponent
            };
        }
        var jsComponent = this.jsComponents[name];
        if (jsComponent) {
            return {
                componentFromFramework: false,
                component: jsComponent
            };
        }
        var defaultComponent = this.agGridDefaults[name];
        if (defaultComponent) {
            return {
                componentFromFramework: false,
                component: defaultComponent
            };
        }
        if (Object.keys(this.agGridDefaults).indexOf(name) < 0) {
            console.warn("AG Grid: Looking for component [" + name + "] but it wasn't found.");
        }
        return null;
    };
    UserComponentRegistry.prototype.translateIfDeprecated = function (raw) {
        var deprecatedInfo = this.agDeprecatedNames[raw];
        if (deprecatedInfo != null) {
            Object(utils_function["doOnce"])(function () {
                console.warn("ag-grid. Since v15.0 component names have been renamed to be namespaced. You should rename " + deprecatedInfo.propertyHolder + ":" + raw + " to " + deprecatedInfo.propertyHolder + ":" + deprecatedInfo.newComponentName);
            }, 'DEPRECATE_COMPONENT_' + raw);
            return deprecatedInfo.newComponentName;
        }
        return raw;
    };
    userComponentRegistry_decorate([
        Object(context["a" /* Autowired */])('gridOptions')
    ], UserComponentRegistry.prototype, "gridOptions", void 0);
    userComponentRegistry_decorate([
        context["e" /* PostConstruct */]
    ], UserComponentRegistry.prototype, "init", null);
    UserComponentRegistry = userComponentRegistry_decorate([
        Object(context["b" /* Bean */])('userComponentRegistry')
    ], UserComponentRegistry);
    return UserComponentRegistry;
}(beanStub["a" /* BeanStub */]));



/***/ }),

/***/ "35c3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CheckboxSelectionComponent; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9cc8");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ad5d");
/* harmony import */ var _widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("6835");
/* harmony import */ var _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fb19");
/* harmony import */ var _utils_event__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ac61");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var CheckboxSelectionComponent = /** @class */ (function (_super) {
    __extends(CheckboxSelectionComponent, _super);
    function CheckboxSelectionComponent() {
        return _super.call(this, /* html*/ "\n            <div class=\"ag-selection-checkbox\" role=\"presentation\">\n                <ag-checkbox role=\"presentation\" ref=\"eCheckbox\"></ag-checkbox>\n            </div>") || this;
    }
    CheckboxSelectionComponent.prototype.postConstruct = function () {
        this.eCheckbox.setPassive(true);
    };
    CheckboxSelectionComponent.prototype.getCheckboxId = function () {
        return this.eCheckbox.getInputElement().id;
    };
    CheckboxSelectionComponent.prototype.onDataChanged = function () {
        // when rows are loaded for the second time, this can impact the selection, as a row
        // could be loaded as already selected (if user scrolls down, and then up again).
        this.onSelectionChanged();
    };
    CheckboxSelectionComponent.prototype.onSelectableChanged = function () {
        this.showOrHideSelect();
    };
    CheckboxSelectionComponent.prototype.onSelectionChanged = function () {
        var translate = this.gridOptionsWrapper.getLocaleTextFunc();
        var state = this.rowNode.isSelected();
        var stateName = state === undefined
            ? translate('ariaIndeterminate', 'indeterminate')
            : (state === true
                ? translate('ariaChecked', 'checked')
                : translate('ariaUnchecked', 'unchecked'));
        var ariaLabel = translate('ariaRowToggleSelection', 'Press Space to toggle row selection');
        this.eCheckbox.setValue(state, true);
        this.eCheckbox.setInputAriaLabel(ariaLabel + " (" + stateName + ")");
    };
    CheckboxSelectionComponent.prototype.onCheckedClicked = function (event) {
        var groupSelectsFiltered = this.gridOptionsWrapper.isGroupSelectsFiltered();
        var updatedCount = this.rowNode.setSelectedParams({ newValue: false, rangeSelect: event.shiftKey, groupSelectsFiltered: groupSelectsFiltered });
        return updatedCount;
    };
    CheckboxSelectionComponent.prototype.onUncheckedClicked = function (event) {
        var groupSelectsFiltered = this.gridOptionsWrapper.isGroupSelectsFiltered();
        var updatedCount = this.rowNode.setSelectedParams({ newValue: true, rangeSelect: event.shiftKey, groupSelectsFiltered: groupSelectsFiltered });
        return updatedCount;
    };
    CheckboxSelectionComponent.prototype.init = function (params) {
        var _this = this;
        this.rowNode = params.rowNode;
        this.column = params.column;
        this.onSelectionChanged();
        // we don't want the row clicked event to fire when selecting the checkbox, otherwise the row
        // would possibly get selected twice
        this.addGuiEventListener('click', function (event) { return Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["stopPropagationForAgGrid"])(event); });
        // likewise we don't want double click on this icon to open a group
        this.addGuiEventListener('dblclick', function (event) { return Object(_utils_event__WEBPACK_IMPORTED_MODULE_5__["stopPropagationForAgGrid"])(event); });
        this.addManagedListener(this.eCheckbox.getInputElement(), 'click', function (event) {
            var isSelected = _this.eCheckbox.getValue();
            var previousValue = _this.eCheckbox.getPreviousValue();
            if (previousValue === undefined) { // indeterminate
                var result = _this.onUncheckedClicked(event || {});
                if (result === 0) {
                    _this.onCheckedClicked(event);
                }
            }
            else if (isSelected) {
                _this.onCheckedClicked(event);
            }
            else {
                _this.onUncheckedClicked(event || {});
            }
        });
        this.addManagedListener(this.rowNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_ROW_SELECTED, this.onSelectionChanged.bind(this));
        this.addManagedListener(this.rowNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_DATA_CHANGED, this.onDataChanged.bind(this));
        this.addManagedListener(this.rowNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_SELECTABLE_CHANGED, this.onSelectableChanged.bind(this));
        var isRowSelectableFunc = this.gridOptionsWrapper.getIsRowSelectableFunc();
        var checkboxVisibleIsDynamic = isRowSelectableFunc || this.checkboxCallbackExists();
        if (checkboxVisibleIsDynamic) {
            var showOrHideSelectListener = this.showOrHideSelect.bind(this);
            this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_2__[/* Events */ "a"].EVENT_DISPLAYED_COLUMNS_CHANGED, showOrHideSelectListener);
            this.addManagedListener(this.rowNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_DATA_CHANGED, showOrHideSelectListener);
            this.addManagedListener(this.rowNode, _entities_rowNode__WEBPACK_IMPORTED_MODULE_4__[/* RowNode */ "b"].EVENT_CELL_CHANGED, showOrHideSelectListener);
            this.showOrHideSelect();
        }
        this.eCheckbox.getInputElement().setAttribute('tabindex', '-1');
    };
    CheckboxSelectionComponent.prototype.showOrHideSelect = function () {
        // if the isRowSelectable() is not provided the row node is selectable by default
        var selectable = this.rowNode.selectable;
        // checkboxSelection callback is deemed a legacy solution however we will still consider it's result.
        // If selectable, then also check the colDef callback. if not selectable, this it short circuits - no need
        // to call the colDef callback.
        if (selectable && this.checkboxCallbackExists()) {
            selectable = this.column.isCellCheckboxSelection(this.rowNode);
        }
        // show checkbox if both conditions are true
        this.setVisible(selectable);
    };
    CheckboxSelectionComponent.prototype.checkboxCallbackExists = function () {
        // column will be missing if groupUseEntireRow=true
        var colDef = this.column ? this.column.getColDef() : null;
        return !!colDef && typeof colDef.checkboxSelection === 'function';
    };
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_3__[/* RefSelector */ "a"])('eCheckbox')
    ], CheckboxSelectionComponent.prototype, "eCheckbox", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_0__[/* PostConstruct */ "e"]
    ], CheckboxSelectionComponent.prototype, "postConstruct", null);
    return CheckboxSelectionComponent;
}(_widgets_component__WEBPACK_IMPORTED_MODULE_1__[/* Component */ "a"]));



/***/ }),

/***/ "35fe":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HeaderNavigationDirection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return HeaderNavigationService; });
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _entities_columnGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("64bd");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("348a");
/* harmony import */ var _row_headerRowComp__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("2ce1");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var HeaderNavigationDirection;
(function (HeaderNavigationDirection) {
    HeaderNavigationDirection[HeaderNavigationDirection["UP"] = 0] = "UP";
    HeaderNavigationDirection[HeaderNavigationDirection["DOWN"] = 1] = "DOWN";
    HeaderNavigationDirection[HeaderNavigationDirection["LEFT"] = 2] = "LEFT";
    HeaderNavigationDirection[HeaderNavigationDirection["RIGHT"] = 3] = "RIGHT";
})(HeaderNavigationDirection || (HeaderNavigationDirection = {}));
var HeaderNavigationService = /** @class */ (function (_super) {
    __extends(HeaderNavigationService, _super);
    function HeaderNavigationService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    HeaderNavigationService.prototype.postConstruct = function () {
        var _this = this;
        this.ctrlsService.whenReady(function (p) {
            _this.gridBodyCon = p.gridBodyCtrl;
        });
    };
    HeaderNavigationService.prototype.getHeaderRowCount = function () {
        var centerHeaderContainer = this.ctrlsService.getHeaderRowContainerCtrl();
        return centerHeaderContainer ? centerHeaderContainer.getRowCount() : 0;
    };
    HeaderNavigationService.prototype.getHeaderRowType = function (rowIndex) {
        var centerHeaderContainer = this.ctrlsService.getHeaderRowContainerCtrl();
        if (centerHeaderContainer) {
            return centerHeaderContainer.getRowType(rowIndex);
        }
    };
    /*
     * This method navigates grid header vertically
     * @return {boolean} true to preventDefault on the event that caused this navigation.
     */
    HeaderNavigationService.prototype.navigateVertically = function (direction, fromHeader, event) {
        if (!fromHeader) {
            fromHeader = this.focusService.getFocusedHeader();
        }
        if (!fromHeader) {
            return false;
        }
        var headerRowIndex = fromHeader.headerRowIndex, column = fromHeader.column;
        var rowLen = this.getHeaderRowCount();
        var isUp = direction === HeaderNavigationDirection.UP;
        var nextRow = isUp ? headerRowIndex - 1 : headerRowIndex + 1;
        var nextFocusColumn = null;
        var skipColumn = false;
        if (nextRow < 0) {
            nextRow = 0;
            nextFocusColumn = column;
            skipColumn = true;
        }
        if (nextRow >= rowLen) {
            nextRow = -1; // -1 indicates the focus should move to grid rows.
        }
        var currentRowType = this.getHeaderRowType(headerRowIndex);
        if (!skipColumn) {
            if (currentRowType === _row_headerRowComp__WEBPACK_IMPORTED_MODULE_4__[/* HeaderRowType */ "b"].COLUMN_GROUP) {
                var currentColumn = column;
                nextFocusColumn = isUp ? column.getParent() : currentColumn.getDisplayedChildren()[0];
            }
            else if (currentRowType === _row_headerRowComp__WEBPACK_IMPORTED_MODULE_4__[/* HeaderRowType */ "b"].FLOATING_FILTER) {
                nextFocusColumn = column;
            }
            else {
                var currentColumn = column;
                nextFocusColumn = isUp ? currentColumn.getParent() : currentColumn;
            }
            if (!nextFocusColumn) {
                return false;
            }
        }
        return this.focusService.focusHeaderPosition({ headerRowIndex: nextRow, column: nextFocusColumn }, undefined, false, true, event);
    };
    /*
     * This method navigates grid header horizontally
     * @return {boolean} true to preventDefault on the event that caused this navigation.
     */
    HeaderNavigationService.prototype.navigateHorizontally = function (direction, fromTab, event) {
        if (fromTab === void 0) { fromTab = false; }
        var focusedHeader = this.focusService.getFocusedHeader();
        var isLeft = direction === HeaderNavigationDirection.LEFT;
        var isRtl = this.gridOptionsWrapper.isEnableRtl();
        var nextHeader;
        var normalisedDirection;
        // either navigating to the left or isRtl (cannot be both)
        if (isLeft !== isRtl) {
            normalisedDirection = 'Before';
            nextHeader = this.headerPositionUtils.findHeader(focusedHeader, normalisedDirection);
        }
        else {
            normalisedDirection = 'After';
            nextHeader = this.headerPositionUtils.findHeader(focusedHeader, normalisedDirection);
        }
        if (nextHeader) {
            return this.focusService.focusHeaderPosition(nextHeader, normalisedDirection, fromTab, true, event);
        }
        if (!fromTab) {
            return true;
        }
        return this.focusNextHeaderRow(focusedHeader, normalisedDirection, event);
    };
    HeaderNavigationService.prototype.focusNextHeaderRow = function (focusedHeader, direction, event) {
        var currentIndex = focusedHeader.headerRowIndex;
        var nextPosition = null;
        var nextRowIndex;
        if (direction === 'Before') {
            if (currentIndex > 0) {
                nextRowIndex = currentIndex - 1;
                nextPosition = this.headerPositionUtils.findColAtEdgeForHeaderRow(nextRowIndex, 'end');
            }
        }
        else {
            nextRowIndex = currentIndex + 1;
            nextPosition = this.headerPositionUtils.findColAtEdgeForHeaderRow(nextRowIndex, 'start');
        }
        return this.focusService.focusHeaderPosition(nextPosition, direction, true, true, event);
    };
    HeaderNavigationService.prototype.scrollToColumn = function (column, direction) {
        if (direction === void 0) { direction = 'After'; }
        if (column.getPinned()) {
            return;
        }
        var columnToScrollTo;
        if (column instanceof _entities_columnGroup__WEBPACK_IMPORTED_MODULE_2__[/* ColumnGroup */ "a"]) {
            var columns = column.getDisplayedLeafColumns();
            columnToScrollTo = direction === 'Before' ? Object(_utils_array__WEBPACK_IMPORTED_MODULE_3__["last"])(columns) : columns[0];
        }
        else {
            columnToScrollTo = column;
        }
        this.gridBodyCon.getScrollFeature().ensureColumnVisible(columnToScrollTo);
        // need to nudge the scrolls for the floating items. otherwise when we set focus on a non-visible
        // floating cell, the scrolls get out of sync
        this.gridBodyCon.getScrollFeature().horizontallyScrollHeaderCenterAndFloatingCenter();
        // need to flush frames, to make sure the correct cells are rendered
        this.animationFrameService.flushAllFrames();
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('focusService')
    ], HeaderNavigationService.prototype, "focusService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('headerPositionUtils')
    ], HeaderNavigationService.prototype, "headerPositionUtils", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('animationFrameService')
    ], HeaderNavigationService.prototype, "animationFrameService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('ctrlsService')
    ], HeaderNavigationService.prototype, "ctrlsService", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], HeaderNavigationService.prototype, "postConstruct", null);
    HeaderNavigationService = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Bean */ "b"])('headerNavigationService')
    ], HeaderNavigationService);
    return HeaderNavigationService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_0__[/* BeanStub */ "a"]));



/***/ }),

/***/ "377f":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SelectableService; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var SelectableService = /** @class */ (function (_super) {
    __extends(SelectableService, _super);
    function SelectableService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SelectableService.prototype.init = function () {
        this.groupSelectsChildren = this.gridOptionsWrapper.isGroupSelectsChildren();
        this.isRowSelectableFunc = this.gridOptionsWrapper.getIsRowSelectableFunc();
    };
    SelectableService.prototype.updateSelectableAfterGrouping = function (rowNode) {
        if (this.isRowSelectableFunc) {
            var nextChildrenFunc = function (node) { return node.childrenAfterGroup; };
            this.recurseDown(rowNode.childrenAfterGroup, nextChildrenFunc);
        }
    };
    SelectableService.prototype.updateSelectableAfterFiltering = function (rowNode) {
        if (this.isRowSelectableFunc) {
            var nextChildrenFunc = function (node) { return node.childrenAfterFilter; };
            this.recurseDown(rowNode.childrenAfterGroup, nextChildrenFunc);
        }
    };
    SelectableService.prototype.recurseDown = function (children, nextChildrenFunc) {
        var _this = this;
        if (!children) {
            return;
        }
        children.forEach(function (child) {
            if (!child.group) {
                return;
            } // only interested in groups
            if (child.hasChildren()) {
                _this.recurseDown(nextChildrenFunc(child), nextChildrenFunc);
            }
            var rowSelectable;
            if (_this.groupSelectsChildren) {
                // have this group selectable if at least one direct child is selectable
                var firstSelectable = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_2__["find"])(nextChildrenFunc(child), 'selectable', true);
                rowSelectable = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_2__["exists"])(firstSelectable);
            }
            else {
                // directly retrieve selectable value from user callback
                rowSelectable = _this.isRowSelectableFunc ? _this.isRowSelectableFunc(child) : false;
            }
            child.setRowSelectable(rowSelectable);
        });
    };
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_0__[/* PostConstruct */ "e"]
    ], SelectableService.prototype, "init", null);
    SelectableService = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('selectableService')
    ], SelectableService);
    return SelectableService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "37c1":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return PaginationProxy; });
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bc71");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("ad5d");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("a74a");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("866e");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var PaginationProxy = /** @class */ (function (_super) {
    __extends(PaginationProxy, _super);
    function PaginationProxy() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.currentPage = 0;
        _this.topDisplayedRowIndex = 0;
        _this.bottomDisplayedRowIndex = 0;
        _this.pixelOffset = 0;
        _this.masterRowCount = 0;
        return _this;
    }
    PaginationProxy.prototype.postConstruct = function () {
        this.active = this.gridOptionsWrapper.isPagination();
        this.paginateChildRows = this.gridOptionsWrapper.isPaginateChildRows();
        this.addManagedListener(this.eventService, _events__WEBPACK_IMPORTED_MODULE_1__[/* Events */ "a"].EVENT_MODEL_UPDATED, this.onModelUpdated.bind(this));
        this.addManagedListener(this.gridOptionsWrapper, 'paginationPageSize', this.onPaginationPageSizeChanged.bind(this));
        this.onModelUpdated();
    };
    PaginationProxy.prototype.ensureRowHeightsValid = function (startPixel, endPixel, startLimitIndex, endLimitIndex) {
        var res = this.rowModel.ensureRowHeightsValid(startPixel, endPixel, this.getPageFirstRow(), this.getPageLastRow());
        if (res) {
            this.calculatePages();
        }
        return res;
    };
    PaginationProxy.prototype.onModelUpdated = function (modelUpdatedEvent) {
        this.calculatePages();
        var paginationChangedEvent = {
            type: _events__WEBPACK_IMPORTED_MODULE_1__[/* Events */ "a"].EVENT_PAGINATION_CHANGED,
            animate: modelUpdatedEvent ? modelUpdatedEvent.animate : false,
            newData: modelUpdatedEvent ? modelUpdatedEvent.newData : false,
            newPage: modelUpdatedEvent ? modelUpdatedEvent.newPage : false,
            keepRenderedRows: modelUpdatedEvent ? modelUpdatedEvent.keepRenderedRows : false,
            api: this.gridApi,
            columnApi: this.columnApi
        };
        this.eventService.dispatchEvent(paginationChangedEvent);
    };
    PaginationProxy.prototype.onPaginationPageSizeChanged = function () {
        this.calculatePages();
        var paginationChangedEvent = {
            type: _events__WEBPACK_IMPORTED_MODULE_1__[/* Events */ "a"].EVENT_PAGINATION_CHANGED,
            animate: false,
            newData: false,
            newPage: false,
            // important to keep rendered rows, otherwise every time grid is resized,
            // we would destroy all the rows.
            keepRenderedRows: true,
            api: this.gridApi,
            columnApi: this.columnApi
        };
        this.eventService.dispatchEvent(paginationChangedEvent);
    };
    PaginationProxy.prototype.goToPage = function (page) {
        if (!this.active || this.currentPage === page) {
            return;
        }
        this.currentPage = page;
        var event = {
            type: _events__WEBPACK_IMPORTED_MODULE_1__[/* Events */ "a"].EVENT_MODEL_UPDATED,
            animate: false,
            keepRenderedRows: false,
            newData: false,
            newPage: true,
            api: this.gridApi,
            columnApi: this.columnApi
        };
        this.onModelUpdated(event);
    };
    PaginationProxy.prototype.getPixelOffset = function () {
        return this.pixelOffset;
    };
    PaginationProxy.prototype.getRow = function (index) {
        return this.rowModel.getRow(index);
    };
    PaginationProxy.prototype.getRowNode = function (id) {
        return this.rowModel.getRowNode(id);
    };
    PaginationProxy.prototype.getRowIndexAtPixel = function (pixel) {
        return this.rowModel.getRowIndexAtPixel(pixel);
    };
    PaginationProxy.prototype.getCurrentPageHeight = function () {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_3__["missing"])(this.topRowBounds) || Object(_utils_generic__WEBPACK_IMPORTED_MODULE_3__["missing"])(this.bottomRowBounds)) {
            return 0;
        }
        return Math.max(this.bottomRowBounds.rowTop + this.bottomRowBounds.rowHeight - this.topRowBounds.rowTop, 0);
    };
    PaginationProxy.prototype.getCurrentPagePixelRange = function () {
        var pageFirstPixel = this.topRowBounds ? this.topRowBounds.rowTop : 0;
        var pageLastPixel = this.bottomRowBounds ? this.bottomRowBounds.rowTop + this.bottomRowBounds.rowHeight : 0;
        return { pageFirstPixel: pageFirstPixel, pageLastPixel: pageLastPixel };
    };
    PaginationProxy.prototype.isRowPresent = function (rowNode) {
        if (!this.rowModel.isRowPresent(rowNode)) {
            return false;
        }
        var nodeIsInPage = rowNode.rowIndex >= this.topDisplayedRowIndex && rowNode.rowIndex <= this.bottomDisplayedRowIndex;
        return nodeIsInPage;
    };
    PaginationProxy.prototype.isEmpty = function () {
        return this.rowModel.isEmpty();
    };
    PaginationProxy.prototype.isRowsToRender = function () {
        return this.rowModel.isRowsToRender();
    };
    PaginationProxy.prototype.getNodesInRangeForSelection = function (firstInRange, lastInRange) {
        return this.rowModel.getNodesInRangeForSelection(firstInRange, lastInRange);
    };
    PaginationProxy.prototype.forEachNode = function (callback) {
        return this.rowModel.forEachNode(callback);
    };
    PaginationProxy.prototype.getType = function () {
        return this.rowModel.getType();
    };
    PaginationProxy.prototype.getRowBounds = function (index) {
        var res = this.rowModel.getRowBounds(index);
        res.rowIndex = index;
        return res;
    };
    PaginationProxy.prototype.getPageFirstRow = function () {
        return this.topRowBounds ? this.topRowBounds.rowIndex : -1;
    };
    PaginationProxy.prototype.getPageLastRow = function () {
        return this.bottomRowBounds ? this.bottomRowBounds.rowIndex : -1;
    };
    PaginationProxy.prototype.getRowCount = function () {
        return this.rowModel.getRowCount();
    };
    PaginationProxy.prototype.getPageForIndex = function (index) {
        return Math.floor(index / this.pageSize);
    };
    PaginationProxy.prototype.goToPageWithIndex = function (index) {
        if (!this.active) {
            return;
        }
        var pageNumber = this.getPageForIndex(index);
        this.goToPage(pageNumber);
    };
    PaginationProxy.prototype.isRowInPage = function (row) {
        if (!this.active) {
            return true;
        }
        var rowPage = this.getPageForIndex(row.rowIndex);
        return rowPage === this.currentPage;
    };
    PaginationProxy.prototype.isLastPageFound = function () {
        return this.rowModel.isLastRowIndexKnown();
    };
    PaginationProxy.prototype.getCurrentPage = function () {
        return this.currentPage;
    };
    PaginationProxy.prototype.goToNextPage = function () {
        this.goToPage(this.currentPage + 1);
    };
    PaginationProxy.prototype.goToPreviousPage = function () {
        this.goToPage(this.currentPage - 1);
    };
    PaginationProxy.prototype.goToFirstPage = function () {
        this.goToPage(0);
    };
    PaginationProxy.prototype.goToLastPage = function () {
        var rowCount = this.rowModel.getRowCount();
        var lastPage = Math.floor(rowCount / this.pageSize);
        this.goToPage(lastPage);
    };
    PaginationProxy.prototype.getPageSize = function () {
        return this.pageSize;
    };
    PaginationProxy.prototype.getTotalPages = function () {
        return this.totalPages;
    };
    PaginationProxy.prototype.setPageSize = function () {
        // show put this into super class
        this.pageSize = this.gridOptionsWrapper.getPaginationPageSize();
        if (this.pageSize == null || this.pageSize < 1) {
            this.pageSize = 100;
        }
    };
    PaginationProxy.prototype.calculatePages = function () {
        if (this.active) {
            this.setPageSize();
            if (this.paginateChildRows) {
                this.calculatePagesAllRows();
            }
            else {
                this.calculatePagesMasterRowsOnly();
            }
        }
        else {
            this.calculatedPagesNotActive();
        }
        this.topRowBounds = this.rowModel.getRowBounds(this.topDisplayedRowIndex);
        if (this.topRowBounds) {
            this.topRowBounds.rowIndex = this.topDisplayedRowIndex;
        }
        this.bottomRowBounds = this.rowModel.getRowBounds(this.bottomDisplayedRowIndex);
        if (this.bottomRowBounds) {
            this.bottomRowBounds.rowIndex = this.bottomDisplayedRowIndex;
        }
        this.setPixelOffset(Object(_utils_generic__WEBPACK_IMPORTED_MODULE_3__["exists"])(this.topRowBounds) ? this.topRowBounds.rowTop : 0);
    };
    PaginationProxy.prototype.setPixelOffset = function (value) {
        if (this.pixelOffset === value) {
            return;
        }
        this.pixelOffset = value;
        this.eventService.dispatchEvent({ type: _events__WEBPACK_IMPORTED_MODULE_1__[/* Events */ "a"].EVENT_PAGINATION_PIXEL_OFFSET_CHANGED });
    };
    PaginationProxy.prototype.setZeroRows = function () {
        this.masterRowCount = 0;
        this.topDisplayedRowIndex = 0;
        this.bottomDisplayedRowIndex = -1;
        this.currentPage = 0;
        this.totalPages = 0;
    };
    PaginationProxy.prototype.calculatePagesMasterRowsOnly = function () {
        // const csrm = <ClientSideRowModel> this.rowModel;
        // const rootNode = csrm.getRootNode();
        // const masterRows = rootNode.childrenAfterSort;
        this.masterRowCount = this.rowModel.getTopLevelRowCount();
        // we say <=0 (rather than =0) as viewport returns -1 when no rows
        if (this.masterRowCount <= 0) {
            this.setZeroRows();
            return;
        }
        var masterLastRowIndex = this.masterRowCount - 1;
        this.totalPages = Math.floor((masterLastRowIndex) / this.pageSize) + 1;
        if (this.currentPage >= this.totalPages) {
            this.currentPage = this.totalPages - 1;
        }
        if (!Object(_utils_number__WEBPACK_IMPORTED_MODULE_4__["isNumeric"])(this.currentPage) || this.currentPage < 0) {
            this.currentPage = 0;
        }
        var masterPageStartIndex = this.pageSize * this.currentPage;
        var masterPageEndIndex = (this.pageSize * (this.currentPage + 1)) - 1;
        if (masterPageEndIndex > masterLastRowIndex) {
            masterPageEndIndex = masterLastRowIndex;
        }
        this.topDisplayedRowIndex = this.rowModel.getTopLevelRowDisplayedIndex(masterPageStartIndex);
        // masterRows[masterPageStartIndex].rowIndex;
        if (masterPageEndIndex === masterLastRowIndex) {
            // if showing the last master row, then we want to show the very last row of the model
            this.bottomDisplayedRowIndex = this.rowModel.getRowCount() - 1;
        }
        else {
            var firstIndexNotToShow = this.rowModel.getTopLevelRowDisplayedIndex(masterPageEndIndex + 1);
            //masterRows[masterPageEndIndex + 1].rowIndex;
            // this gets the index of the last child - eg current row is open, we want to display all children,
            // the index of the last child is one less than the index of the next parent row.
            this.bottomDisplayedRowIndex = firstIndexNotToShow - 1;
        }
    };
    PaginationProxy.prototype.getMasterRowCount = function () {
        return this.masterRowCount;
    };
    PaginationProxy.prototype.calculatePagesAllRows = function () {
        this.masterRowCount = this.rowModel.getRowCount();
        if (this.masterRowCount === 0) {
            this.setZeroRows();
            return;
        }
        var maxRowIndex = this.masterRowCount - 1;
        this.totalPages = Math.floor((maxRowIndex) / this.pageSize) + 1;
        if (this.currentPage >= this.totalPages) {
            this.currentPage = this.totalPages - 1;
        }
        if (!Object(_utils_number__WEBPACK_IMPORTED_MODULE_4__["isNumeric"])(this.currentPage) || this.currentPage < 0) {
            this.currentPage = 0;
        }
        this.topDisplayedRowIndex = this.pageSize * this.currentPage;
        this.bottomDisplayedRowIndex = (this.pageSize * (this.currentPage + 1)) - 1;
        if (this.bottomDisplayedRowIndex > maxRowIndex) {
            this.bottomDisplayedRowIndex = maxRowIndex;
        }
    };
    PaginationProxy.prototype.calculatedPagesNotActive = function () {
        this.pageSize = this.rowModel.getRowCount();
        this.totalPages = 1;
        this.currentPage = 0;
        this.topDisplayedRowIndex = 0;
        this.bottomDisplayedRowIndex = this.rowModel.getRowCount() - 1;
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('rowModel')
    ], PaginationProxy.prototype, "rowModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('columnApi')
    ], PaginationProxy.prototype, "columnApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('gridApi')
    ], PaginationProxy.prototype, "gridApi", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_2__[/* PostConstruct */ "e"]
    ], PaginationProxy.prototype, "postConstruct", null);
    PaginationProxy = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Bean */ "b"])('paginationProxy')
    ], PaginationProxy);
    return PaginationProxy;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_0__[/* BeanStub */ "a"]));



/***/ }),

/***/ "3ad0":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ agColorPicker_AgColorPicker; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/index.js + 8 modules
var utils = __webpack_require__("7347");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/componentAnnotations.js
var componentAnnotations = __webpack_require__("6835");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/generic.js
var generic = __webpack_require__("a74a");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agColorPanel.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var agColorPanel_AgColorPanel = /** @class */ (function (_super) {
    __extends(AgColorPanel, _super);
    function AgColorPanel(config) {
        var _this = _super.call(this, AgColorPanel.TEMPLATE) || this;
        _this.H = 1; // in the [0, 1] range
        _this.S = 1; // in the [0, 1] range
        _this.B = 1; // in the [0, 1] range
        _this.A = 1; // in the [0, 1] range
        _this.isSpectrumDragging = false;
        _this.isSpectrumHueDragging = false;
        _this.isSpectrumAlphaDragging = false;
        _this.colorChanged = false;
        _this.picker = config.picker;
        return _this;
    }
    AgColorPanel.prototype.postConstruct = function () {
        var eGui = this.getGui();
        this.initRecentColors();
        this.addManagedListener(this.spectrumVal, 'mousedown', this.onSpectrumDraggerDown.bind(this));
        this.addManagedListener(eGui, 'mousemove', this.onSpectrumDraggerMove.bind(this));
        this.addManagedListener(this.spectrumHue, 'mousedown', this.onSpectrumHueDown.bind(this));
        this.addManagedListener(eGui, 'mousemove', this.onSpectrumHueMove.bind(this));
        this.addManagedListener(this.spectrumAlpha, 'mousedown', this.onSpectrumAlphaDown.bind(this));
        this.addManagedListener(eGui, 'mousemove', this.onSpectrumAlphaMove.bind(this));
        // Listening to `mouseup` on the document on purpose. The user might release the mouse button
        // outside the UI control. When the mouse returns back to the control's area, the dragging
        // of the thumb is not expected and seen as a bug.
        this.addManagedListener(document, 'mouseup', this.onMouseUp.bind(this));
        this.addManagedListener(this.recentColors, 'click', this.onRecentColorClick.bind(this));
    };
    AgColorPanel.prototype.refreshSpectrumRect = function () {
        return this.spectrumValRect = this.spectrumVal.getBoundingClientRect();
    };
    AgColorPanel.prototype.refreshHueRect = function () {
        return this.spectrumHueRect = this.spectrumHue.getBoundingClientRect();
    };
    AgColorPanel.prototype.refreshAlphaRect = function () {
        return this.spectrumAlphaRect = this.spectrumAlpha.getBoundingClientRect();
    };
    AgColorPanel.prototype.onSpectrumDraggerDown = function (e) {
        this.refreshSpectrumRect();
        this.isSpectrumDragging = true;
        this.moveDragger(e);
    };
    AgColorPanel.prototype.onSpectrumDraggerMove = function (e) {
        if (this.isSpectrumDragging) {
            this.moveDragger(e);
        }
    };
    AgColorPanel.prototype.onSpectrumHueDown = function (e) {
        this.refreshHueRect();
        this.isSpectrumHueDragging = true;
        this.moveHueSlider(e);
    };
    AgColorPanel.prototype.onSpectrumHueMove = function (e) {
        if (this.isSpectrumHueDragging) {
            this.moveHueSlider(e);
        }
    };
    AgColorPanel.prototype.onSpectrumAlphaDown = function (e) {
        this.refreshAlphaRect();
        this.isSpectrumAlphaDragging = true;
        this.moveAlphaSlider(e);
    };
    AgColorPanel.prototype.onSpectrumAlphaMove = function (e) {
        if (this.isSpectrumAlphaDragging) {
            this.moveAlphaSlider(e);
        }
    };
    AgColorPanel.prototype.onMouseUp = function () {
        this.isSpectrumDragging = false;
        this.isSpectrumHueDragging = false;
        this.isSpectrumAlphaDragging = false;
    };
    AgColorPanel.prototype.moveDragger = function (e) {
        var valRect = this.spectrumValRect;
        if (valRect) {
            var x = e.clientX - valRect.left;
            var y = e.clientY - valRect.top;
            x = Math.max(x, 0);
            x = Math.min(x, valRect.width);
            y = Math.max(y, 0);
            y = Math.min(y, valRect.height);
            this.setSpectrumValue(x / valRect.width, 1 - y / valRect.height);
        }
    };
    AgColorPanel.prototype.moveHueSlider = function (e) {
        var hueRect = this.spectrumHueRect;
        if (hueRect) {
            var slider = this.spectrumHueSlider;
            var sliderRect = slider.getBoundingClientRect();
            var x = e.clientX - hueRect.left;
            x = Math.max(x, 0);
            x = Math.min(x, hueRect.width);
            this.H = 1 - x / hueRect.width;
            slider.style.left = (x + sliderRect.width / 2) + 'px';
            this.update();
        }
    };
    AgColorPanel.prototype.moveAlphaSlider = function (e) {
        var alphaRect = this.spectrumAlphaRect;
        if (alphaRect) {
            var slider = this.spectrumAlphaSlider;
            var sliderRect = slider.getBoundingClientRect();
            var x = e.clientX - alphaRect.left;
            x = Math.max(x, 0);
            x = Math.min(x, alphaRect.width);
            this.A = x / alphaRect.width;
            slider.style.left = (x + sliderRect.width / 2) + 'px';
            this.update();
        }
    };
    AgColorPanel.prototype.update = function () {
        var color = utils["b" /* Color */].fromHSB(this.H * 360, this.S, this.B, this.A);
        var spectrumColor = utils["b" /* Color */].fromHSB(this.H * 360, 1, 1);
        var rgbaColor = color.toRgbaString();
        // the recent color list needs to know color has actually changed
        var colorPicker = this.picker;
        var existingColor = utils["b" /* Color */].fromString(colorPicker.getValue());
        if (existingColor.toRgbaString() !== rgbaColor) {
            this.colorChanged = true;
        }
        colorPicker.setValue(rgbaColor);
        this.spectrumColor.style.backgroundColor = spectrumColor.toRgbaString();
        this.spectrumDragger.style.backgroundColor = rgbaColor;
    };
    /**
     * @param saturation In the [0, 1] interval.
     * @param brightness In the [0, 1] interval.
     */
    AgColorPanel.prototype.setSpectrumValue = function (saturation, brightness) {
        var valRect = this.spectrumValRect || this.refreshSpectrumRect();
        if (valRect) {
            var dragger = this.spectrumDragger;
            var draggerRect = dragger.getBoundingClientRect();
            saturation = Math.max(0, saturation);
            saturation = Math.min(1, saturation);
            brightness = Math.max(0, brightness);
            brightness = Math.min(1, brightness);
            this.S = saturation;
            this.B = brightness;
            dragger.style.left = (saturation * valRect.width - draggerRect.width / 2) + 'px';
            dragger.style.top = ((1 - brightness) * valRect.height - draggerRect.height / 2) + 'px';
            this.update();
        }
    };
    AgColorPanel.prototype.initRecentColors = function () {
        var recentColors = AgColorPanel.recentColors;
        var innerHtml = recentColors.map(function (color, index) {
            return "<div class=\"ag-recent-color\" id=" + index + " style=\"background-color: " + color + "; width: 15px; height: 15px;\" recent-color=\"" + color + "\"></div>";
        });
        this.recentColors.innerHTML = innerHtml.join('');
    };
    AgColorPanel.prototype.setValue = function (val) {
        var color = utils["b" /* Color */].fromString(val);
        var _a = color.toHSB(), h = _a[0], s = _a[1], b = _a[2];
        this.H = (isNaN(h) ? 0 : h) / 360;
        this.A = color.a;
        var spectrumHueRect = this.spectrumHueRect || this.refreshHueRect();
        var spectrumAlphaRect = this.spectrumAlphaRect || this.refreshAlphaRect();
        this.spectrumHueSlider.style.left = ((this.H - 1) * -spectrumHueRect.width) + "px";
        this.spectrumAlphaSlider.style.left = (this.A * spectrumAlphaRect.width) + "px";
        this.setSpectrumValue(s, b);
    };
    AgColorPanel.prototype.onRecentColorClick = function (e) {
        var target = e.target;
        if (!Object(generic["exists"])(target.id)) {
            return;
        }
        var id = parseInt(target.id, 10);
        this.setValue(AgColorPanel.recentColors[id]);
        this.destroy();
    };
    AgColorPanel.prototype.addRecentColor = function () {
        var color = utils["b" /* Color */].fromHSB(this.H * 360, this.S, this.B, this.A);
        var rgbaColor = color.toRgbaString();
        var recentColors = AgColorPanel.recentColors;
        if (!this.colorChanged || recentColors[0] === rgbaColor) {
            return;
        }
        // remove duplicate color
        recentColors = recentColors.filter(function (currentColor) { return currentColor != rgbaColor; });
        // add color to head
        recentColors = [rgbaColor].concat(recentColors);
        // ensure we don't exceed max number of recent colors
        if (recentColors.length > AgColorPanel.maxRecentColors) {
            recentColors = recentColors.slice(0, AgColorPanel.maxRecentColors);
        }
        AgColorPanel.recentColors = recentColors;
    };
    AgColorPanel.prototype.destroy = function () {
        this.addRecentColor();
        _super.prototype.destroy.call(this);
    };
    AgColorPanel.maxRecentColors = 8;
    AgColorPanel.recentColors = [];
    AgColorPanel.TEMPLATE = "<div class=\"ag-color-panel\">\n            <div ref=\"spectrumColor\" class=\"ag-spectrum-color\">\n                <div class=\"ag-spectrum-sat ag-spectrum-fill\">\n                    <div ref=\"spectrumVal\" class=\"ag-spectrum-val ag-spectrum-fill\">\n                        <div ref=\"spectrumDragger\" class=\"ag-spectrum-dragger\"></div>\n                    </div>\n                </div>\n            </div>\n            <div class=\"ag-spectrum-tools\">\n                <div ref=\"spectrumHue\" class=\"ag-spectrum-hue ag-spectrum-tool\">\n                    <div class=\"ag-spectrum-hue-background\"></div>\n                    <div ref=\"spectrumHueSlider\" class=\"ag-spectrum-slider\"></div>\n                </div>\n                <div ref=\"spectrumAlpha\" class=\"ag-spectrum-alpha ag-spectrum-tool\">\n                    <div class=\"ag-spectrum-alpha-background\"></div>\n                    <div ref=\"spectrumAlphaSlider\" class=\"ag-spectrum-slider\"></div>\n                </div>\n                <div ref=\"recentColors\" class=\"ag-recent-colors\"></div>\n            </div>\n        </div>";
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumColor')
    ], AgColorPanel.prototype, "spectrumColor", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumVal')
    ], AgColorPanel.prototype, "spectrumVal", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumDragger')
    ], AgColorPanel.prototype, "spectrumDragger", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumHue')
    ], AgColorPanel.prototype, "spectrumHue", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumHueSlider')
    ], AgColorPanel.prototype, "spectrumHueSlider", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumAlpha')
    ], AgColorPanel.prototype, "spectrumAlpha", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('spectrumAlphaSlider')
    ], AgColorPanel.prototype, "spectrumAlphaSlider", void 0);
    __decorate([
        Object(componentAnnotations["a" /* RefSelector */])('recentColors')
    ], AgColorPanel.prototype, "recentColors", void 0);
    __decorate([
        context["e" /* PostConstruct */]
    ], AgColorPanel.prototype, "postConstruct", null);
    return AgColorPanel;
}(component["a" /* Component */]));


// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agDialog.js
var agDialog = __webpack_require__("8cfd");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agPickerField.js
var agPickerField = __webpack_require__("d53d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agColorPicker.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var agColorPicker_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var agColorPicker_AgColorPicker = /** @class */ (function (_super) {
    agColorPicker_extends(AgColorPicker, _super);
    function AgColorPicker(config) {
        var _this = _super.call(this, config, 'ag-color-picker', 'colorPicker') || this;
        if (config && config.color) {
            _this.value = config.color;
        }
        return _this;
    }
    AgColorPicker.prototype.postConstruct = function () {
        _super.prototype.postConstruct.call(this);
        if (this.value) {
            this.setValue(this.value);
        }
    };
    AgColorPicker.prototype.showPicker = function () {
        var _this = this;
        var eGuiRect = this.getGui().getBoundingClientRect();
        var colorDialog = this.createBean(new agDialog["a" /* AgDialog */]({
            closable: false,
            modal: true,
            hideTitleBar: true,
            minWidth: 190,
            width: 190,
            height: 250,
            x: eGuiRect.right - 190,
            y: eGuiRect.top - 250
        }));
        this.isPickerDisplayed = true;
        Object(dom["addCssClass"])(colorDialog.getGui(), 'ag-color-dialog');
        var colorPanel = this.createBean(new agColorPanel_AgColorPanel({ picker: this }));
        colorPanel.addDestroyFunc(function () {
            if (colorDialog.isAlive()) {
                _this.destroyBean(colorDialog);
            }
        });
        colorDialog.setParentComponent(this);
        colorDialog.setBodyComponent(colorPanel);
        colorPanel.setValue(this.getValue());
        colorDialog.addDestroyFunc(function () {
            // here we check if the picker was already being
            // destroyed to avoid a stack overflow
            if (!_this.isDestroyingPicker) {
                _this.isDestroyingPicker = true;
                if (colorPanel.isAlive()) {
                    _this.destroyBean(colorPanel);
                }
            }
            else {
                _this.isDestroyingPicker = false;
            }
            if (_this.isAlive()) {
                _this.getFocusableElement().focus();
            }
            _this.isPickerDisplayed = false;
        });
        return colorDialog;
    };
    AgColorPicker.prototype.setValue = function (color) {
        if (this.value === color) {
            return this;
        }
        this.eDisplayField.style.backgroundColor = color;
        return _super.prototype.setValue.call(this, color);
    };
    AgColorPicker.prototype.getValue = function () {
        return this.value;
    };
    return AgColorPicker;
}(agPickerField["a" /* AgPickerField */]));



/***/ }),

/***/ "4160":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__("23e7");
var forEach = __webpack_require__("17c2");

// `Array.prototype.forEach` method
// https://tc39.es/ecma262/#sec-array.prototype.foreach
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
$({ target: 'Array', proto: true, forced: [].forEach != forEach }, {
  forEach: forEach
});


/***/ }),

/***/ "41a1":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NumberFilter; });
/* harmony import */ var _widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6835");
/* harmony import */ var _simpleFilter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("cf29");
/* harmony import */ var _scalarFilter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("bad3");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("a74a");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("6352");
/* harmony import */ var _utils_browser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("b8d2");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var NumberFilter = /** @class */ (function (_super) {
    __extends(NumberFilter, _super);
    function NumberFilter() {
        return _super.call(this, 'numberFilter') || this;
    }
    NumberFilter.prototype.mapRangeFromModel = function (filterModel) {
        return {
            from: filterModel.filter,
            to: filterModel.filterTo
        };
    };
    NumberFilter.prototype.getDefaultDebounceMs = function () {
        return 500;
    };
    NumberFilter.prototype.resetUiToDefaults = function (silent) {
        var _this = this;
        return _super.prototype.resetUiToDefaults.call(this, silent).then(function () {
            var fields = [_this.eValueFrom1, _this.eValueFrom2, _this.eValueTo1, _this.eValueTo2];
            fields.forEach(function (field) { return field.setValue(null, silent); });
            _this.resetPlaceholder();
        });
    };
    NumberFilter.prototype.setConditionIntoUi = function (model, position) {
        var positionOne = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One;
        var eValueFrom = positionOne ? this.eValueFrom1 : this.eValueFrom2;
        var eValueTo = positionOne ? this.eValueTo1 : this.eValueTo2;
        eValueFrom.setValue(model ? ('' + model.filter) : null);
        eValueTo.setValue(model ? ('' + model.filterTo) : null);
    };
    NumberFilter.prototype.setValueFromFloatingFilter = function (value) {
        this.eValueFrom1.setValue(value);
        this.eValueTo1.setValue(null);
        this.eValueFrom2.setValue(null);
        this.eValueTo2.setValue(null);
    };
    NumberFilter.prototype.comparator = function () {
        return function (left, right) {
            if (left === right) {
                return 0;
            }
            return left < right ? 1 : -1;
        };
    };
    NumberFilter.prototype.setParams = function (params) {
        this.numberFilterParams = params;
        var allowedCharPattern = this.getAllowedCharPattern();
        if (allowedCharPattern) {
            var config = { allowedCharPattern: allowedCharPattern };
            this.resetTemplate({
                eValueFrom1: config,
                eValueTo1: config,
                eValueFrom2: config,
                eValueTo2: config,
            });
        }
        _super.prototype.setParams.call(this, params);
        this.addValueChangedListeners();
    };
    NumberFilter.prototype.addValueChangedListeners = function () {
        var _this = this;
        var listener = function () { return _this.onUiChanged(); };
        this.eValueFrom1.onValueChange(listener);
        this.eValueTo1.onValueChange(listener);
        this.eValueFrom2.onValueChange(listener);
        this.eValueTo2.onValueChange(listener);
    };
    NumberFilter.prototype.resetPlaceholder = function () {
        var globalTranslate = this.gridOptionsWrapper.getLocaleTextFunc();
        var isRange1 = this.showValueTo(this.getCondition1Type());
        var isRange2 = this.showValueTo(this.getCondition2Type());
        this.eValueFrom1.setInputPlaceholder(this.translate(isRange1 ? 'inRangeStart' : 'filterOoo'));
        this.eValueFrom1.setInputAriaLabel(isRange1
            ? globalTranslate('ariaFilterFromValue', 'Filter from value')
            : globalTranslate('ariaFilterValue', 'Filter Value'));
        this.eValueTo1.setInputPlaceholder(this.translate('inRangeEnd'));
        this.eValueTo1.setInputAriaLabel(globalTranslate('ariaFilterToValue', 'Filter to Value'));
        this.eValueFrom2.setInputPlaceholder(this.translate(isRange2 ? 'inRangeStart' : 'filterOoo'));
        this.eValueFrom2.setInputAriaLabel(isRange2
            ? globalTranslate('ariaFilterFromValue', 'Filter from value')
            : globalTranslate('ariaFilterValue', 'Filter Value'));
        this.eValueTo2.setInputPlaceholder(this.translate('inRangeEnd'));
        this.eValueTo2.setInputAriaLabel(globalTranslate('ariaFilterToValue', 'Filter to Value'));
    };
    NumberFilter.prototype.afterGuiAttached = function (params) {
        _super.prototype.afterGuiAttached.call(this, params);
        this.resetPlaceholder();
        if (!params || !params.suppressFocus) {
            this.eValueFrom1.getInputElement().focus();
        }
    };
    NumberFilter.prototype.getDefaultFilterOptions = function () {
        return NumberFilter.DEFAULT_FILTER_OPTIONS;
    };
    NumberFilter.prototype.createValueTemplate = function (position) {
        var pos = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One ? '1' : '2';
        var allowedCharPattern = this.getAllowedCharPattern();
        var agElementTag = allowedCharPattern ? 'ag-input-text-field' : 'ag-input-number-field';
        return /* html */ "\n            <div class=\"ag-filter-body\" ref=\"eCondition" + pos + "Body\" role=\"presentation\">\n                <" + agElementTag + " class=\"ag-filter-from ag-filter-filter\" ref=\"eValueFrom" + pos + "\"></" + agElementTag + ">\n                <" + agElementTag + " class=\"ag-filter-to ag-filter-filter\" ref=\"eValueTo" + pos + "\"></" + agElementTag + ">\n            </div>";
    };
    NumberFilter.prototype.isConditionUiComplete = function (position) {
        var positionOne = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One;
        var option = positionOne ? this.getCondition1Type() : this.getCondition2Type();
        if (option === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].EMPTY) {
            return false;
        }
        if (this.doesFilterHaveHiddenInput(option)) {
            return true;
        }
        var eValue = positionOne ? this.eValueFrom1 : this.eValueFrom2;
        var eValueTo = positionOne ? this.eValueTo1 : this.eValueTo2;
        var value = this.stringToFloat(eValue.getValue());
        return value != null && (!this.showValueTo(option) || this.stringToFloat(eValueTo.getValue()) != null);
    };
    NumberFilter.prototype.areSimpleModelsEqual = function (aSimple, bSimple) {
        return aSimple.filter === bSimple.filter
            && aSimple.filterTo === bSimple.filterTo
            && aSimple.type === bSimple.type;
    };
    NumberFilter.prototype.getFilterType = function () {
        return 'number';
    };
    NumberFilter.prototype.stringToFloat = function (value) {
        if (typeof value === 'number') {
            return value;
        }
        var filterText = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_3__["makeNull"])(value);
        if (filterText != null && filterText.trim() === '') {
            filterText = null;
        }
        if (this.numberFilterParams.numberParser) {
            return this.numberFilterParams.numberParser(filterText);
        }
        return filterText == null || filterText.trim() === '-' ? null : parseFloat(filterText);
    };
    NumberFilter.prototype.createCondition = function (position) {
        var positionOne = position === _simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* ConditionPosition */ "a"].One;
        var type = positionOne ? this.getCondition1Type() : this.getCondition2Type();
        var eValue = positionOne ? this.eValueFrom1 : this.eValueFrom2;
        var value = this.stringToFloat(eValue.getValue());
        var model = {
            filterType: this.getFilterType(),
            type: type
        };
        if (!this.doesFilterHaveHiddenInput(type)) {
            model.filter = value;
            if (this.showValueTo(type)) {
                var eValueTo = positionOne ? this.eValueTo1 : this.eValueTo2;
                var valueTo = this.stringToFloat(eValueTo.getValue());
                model.filterTo = valueTo;
            }
        }
        return model;
    };
    NumberFilter.prototype.updateUiVisibility = function () {
        _super.prototype.updateUiVisibility.call(this);
        this.resetPlaceholder();
        var condition1Type = this.getCondition1Type();
        var condition2Type = this.getCondition2Type();
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eValueFrom1.getGui(), this.showValueFrom(condition1Type));
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eValueTo1.getGui(), this.showValueTo(condition1Type));
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eValueFrom2.getGui(), this.showValueFrom(condition2Type));
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_4__["setDisplayed"])(this.eValueTo2.getGui(), this.showValueTo(condition2Type));
    };
    NumberFilter.prototype.getAllowedCharPattern = function () {
        var allowedCharPattern = (this.numberFilterParams || {}).allowedCharPattern;
        if (allowedCharPattern) {
            return allowedCharPattern;
        }
        if (!Object(_utils_browser__WEBPACK_IMPORTED_MODULE_5__["isBrowserChrome"])() && !Object(_utils_browser__WEBPACK_IMPORTED_MODULE_5__["isBrowserEdge"])()) {
            // only Chrome and Edge support the HTML5 number field, so for other browsers we provide an equivalent
            // constraint instead
            return '\\d\\-\\.';
        }
        return null;
    };
    NumberFilter.DEFAULT_FILTER_OPTIONS = [
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].EQUALS,
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].NOT_EQUAL,
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].LESS_THAN,
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].LESS_THAN_OR_EQUAL,
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].GREATER_THAN,
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].GREATER_THAN_OR_EQUAL,
        _scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"].IN_RANGE
    ];
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eValueFrom1')
    ], NumberFilter.prototype, "eValueFrom1", void 0);
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eValueTo1')
    ], NumberFilter.prototype, "eValueTo1", void 0);
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eValueFrom2')
    ], NumberFilter.prototype, "eValueFrom2", void 0);
    __decorate([
        Object(_widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eValueTo2')
    ], NumberFilter.prototype, "eValueTo2", void 0);
    return NumberFilter;
}(_scalarFilter__WEBPACK_IMPORTED_MODULE_2__[/* ScalarFilter */ "a"]));



/***/ }),

/***/ "44ad":
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__("d039");
var classof = __webpack_require__("c6b6");

var split = ''.split;

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;


/***/ }),

/***/ "485a":
/***/ (function(module, exports, __webpack_require__) {

var isCallable = __webpack_require__("1626");
var isObject = __webpack_require__("861d");

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
module.exports = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = fn.call(input))) return val;
  if (isCallable(fn = input.valueOf) && !isObject(val = fn.call(input))) return val;
  if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ "48c0":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export ServerSideTransactionResultStatus */
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var ServerSideTransactionResultStatus;
(function (ServerSideTransactionResultStatus) {
    /** Transaction was successfully applied */
    ServerSideTransactionResultStatus["Applied"] = "Applied";
    /**
     * Store was not found, transaction not applied.
     * Either invalid route, or the parent row has not yet been expanded.
     */
    ServerSideTransactionResultStatus["StoreNotFound"] = "StoreNotFound";
    /**
     * Store is loading, transaction not applied.
     */
    ServerSideTransactionResultStatus["StoreLoading"] = "StoreLoading";
    /**
     * Store is loading (as max loads exceeded), transaction not applied.
     */
    ServerSideTransactionResultStatus["StoreWaitingToLoad"] = "StoreWaitingToLoad";
    /**
     * Store load attempt failed, transaction not applied.
     */
    ServerSideTransactionResultStatus["StoreLoadingFailed"] = "StoreLoadingFailed";
    /**
     * Store is type Partial, which doesn't accept transactions
     */
    ServerSideTransactionResultStatus["StoreWrongType"] = "StoreWrongType";
    /**
     * Transaction was cancelled, due to grid.
     * Callback isApplyServerSideTransaction() returning false
     */
    ServerSideTransactionResultStatus["Cancelled"] = "Cancelled";
})(ServerSideTransactionResultStatus || (ServerSideTransactionResultStatus = {}));


/***/ }),

/***/ "4930":
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION = __webpack_require__("2d00");
var fails = __webpack_require__("d039");

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  var symbol = Symbol();
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});


/***/ }),

/***/ "4a00":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgPanel; });
/* harmony import */ var _componentAnnotations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6835");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("9cc8");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("6352");
/* harmony import */ var _utils_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("781c");
/* harmony import */ var _rendering_features_positionableFeature__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("53bb");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var AgPanel = /** @class */ (function (_super) {
    __extends(AgPanel, _super);
    function AgPanel(config) {
        var _this = _super.call(this, AgPanel.getTemplate(config)) || this;
        _this.closable = true;
        _this.config = config;
        return _this;
    }
    AgPanel.getTemplate = function (config) {
        var cssIdentifier = (config && config.cssIdentifier) || 'default';
        return /* html */ "<div class=\"ag-panel ag-" + cssIdentifier + "-panel\" tabindex=\"-1\">\n            <div ref=\"eTitleBar\" class=\"ag-panel-title-bar ag-" + cssIdentifier + "-panel-title-bar ag-unselectable\">\n                <span ref=\"eTitle\" class=\"ag-panel-title-bar-title ag-" + cssIdentifier + "-panel-title-bar-title\"></span>\n                <div ref=\"eTitleBarButtons\" class=\"ag-panel-title-bar-buttons ag-" + cssIdentifier + "-panel-title-bar-buttons\"></div>\n            </div>\n            <div ref=\"eContentWrapper\" class=\"ag-panel-content-wrapper ag-" + cssIdentifier + "-panel-content-wrapper\"></div>\n        </div>";
    };
    AgPanel.prototype.postConstruct = function () {
        var _this = this;
        var _a = this.config, component = _a.component, closable = _a.closable, hideTitleBar = _a.hideTitleBar, title = _a.title, _b = _a.minWidth, minWidth = _b === void 0 ? 250 : _b, width = _a.width, _c = _a.minHeight, minHeight = _c === void 0 ? 250 : _c, height = _a.height, centered = _a.centered, popup = _a.popup, x = _a.x, y = _a.y;
        this.positionableFeature = new _rendering_features_positionableFeature__WEBPACK_IMPORTED_MODULE_5__[/* PositionableFeature */ "a"](this.getGui(), {
            minWidth: minWidth, width: width, minHeight: minHeight, height: height, centered: centered, x: x, y: y, popup: popup,
            calculateTopBuffer: function () { return _this.positionableFeature.getHeight() - _this.getBodyHeight(); }
        });
        this.createManagedBean(this.positionableFeature);
        var eGui = this.getGui();
        if (component) {
            this.setBodyComponent(component);
        }
        if (!hideTitleBar) {
            if (title) {
                this.setTitle(title);
            }
            this.setClosable(closable != null ? closable : this.closable);
        }
        else {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["addCssClass"])(this.eTitleBar, 'ag-hidden');
        }
        this.addManagedListener(this.eTitleBar, 'mousedown', function (e) {
            if (eGui.contains(e.relatedTarget) ||
                eGui.contains(document.activeElement) ||
                _this.eTitleBarButtons.contains(e.target)) {
                e.preventDefault();
                return;
            }
            var focusEl = _this.eContentWrapper.querySelector('button, [href], input, select, textarea, [tabindex]');
            if (focusEl) {
                focusEl.focus();
            }
        });
        if (popup && this.positionableFeature.isPositioned()) {
            return;
        }
        if (this.renderComponent) {
            this.renderComponent();
        }
        this.positionableFeature.initialisePosition();
        this.eContentWrapper.style.height = '0';
    };
    AgPanel.prototype.renderComponent = function () {
        var _this = this;
        var eGui = this.getGui();
        eGui.focus();
        this.close = function () {
            eGui.parentElement.removeChild(eGui);
            _this.destroy();
        };
    };
    AgPanel.prototype.getHeight = function () {
        return this.positionableFeature.getHeight();
    };
    AgPanel.prototype.setHeight = function (height) {
        this.positionableFeature.setHeight(height);
    };
    AgPanel.prototype.getWidth = function () {
        return this.positionableFeature.getWidth();
    };
    AgPanel.prototype.setWidth = function (width) {
        this.positionableFeature.setWidth(width);
    };
    AgPanel.prototype.setClosable = function (closable) {
        if (closable !== this.closable) {
            this.closable = closable;
        }
        if (closable) {
            var closeButtonComp = this.closeButtonComp = new _component__WEBPACK_IMPORTED_MODULE_2__[/* Component */ "a"](AgPanel.CLOSE_BTN_TEMPLATE);
            this.getContext().createBean(closeButtonComp);
            var eGui = closeButtonComp.getGui();
            eGui.appendChild(Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["addCssClass"])(Object(_utils_icon__WEBPACK_IMPORTED_MODULE_4__["createIconNoSpan"])('close', this.gridOptionsWrapper), 'ag-panel-title-bar-button-icon'));
            this.addTitleBarButton(closeButtonComp);
            closeButtonComp.addManagedListener(eGui, 'click', this.onBtClose.bind(this));
        }
        else if (this.closeButtonComp) {
            var eGui = this.closeButtonComp.getGui();
            eGui.parentElement.removeChild(eGui);
            this.closeButtonComp = this.destroyBean(this.closeButtonComp);
        }
    };
    AgPanel.prototype.setBodyComponent = function (bodyComponent) {
        bodyComponent.setParentComponent(this);
        this.eContentWrapper.appendChild(bodyComponent.getGui());
    };
    AgPanel.prototype.addTitleBarButton = function (button, position) {
        var eTitleBarButtons = this.eTitleBarButtons;
        var buttons = eTitleBarButtons.children;
        var len = buttons.length;
        if (position == null) {
            position = len;
        }
        position = Math.max(0, Math.min(position, len));
        var eGui = button.getGui();
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["addCssClass"])(eGui, 'ag-panel-title-bar-button');
        if (position === 0) {
            eTitleBarButtons.insertAdjacentElement('afterbegin', eGui);
        }
        else if (position === len) {
            eTitleBarButtons.insertAdjacentElement('beforeend', eGui);
        }
        else {
            buttons[position - 1].insertAdjacentElement('afterend', eGui);
        }
        button.setParentComponent(this);
    };
    AgPanel.prototype.getBodyHeight = function () {
        return Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["getInnerHeight"])(this.eContentWrapper);
    };
    AgPanel.prototype.getBodyWidth = function () {
        return Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["getInnerWidth"])(this.eContentWrapper);
    };
    AgPanel.prototype.setTitle = function (title) {
        this.eTitle.innerText = title;
    };
    // called when user hits the 'x' in the top right
    AgPanel.prototype.onBtClose = function () {
        this.close();
    };
    AgPanel.prototype.destroy = function () {
        if (this.closeButtonComp) {
            this.closeButtonComp = this.destroyBean(this.closeButtonComp);
        }
        var eGui = this.getGui();
        if (eGui && eGui.offsetParent) {
            this.close();
        }
        _super.prototype.destroy.call(this);
    };
    AgPanel.CLOSE_BTN_TEMPLATE = "<div class=\"ag-button\"></div>";
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eContentWrapper')
    ], AgPanel.prototype, "eContentWrapper", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eTitleBar')
    ], AgPanel.prototype, "eTitleBar", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eTitleBarButtons')
    ], AgPanel.prototype, "eTitleBarButtons", void 0);
    __decorate([
        Object(_componentAnnotations__WEBPACK_IMPORTED_MODULE_0__[/* RefSelector */ "a"])('eTitle')
    ], AgPanel.prototype, "eTitle", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], AgPanel.prototype, "postConstruct", null);
    return AgPanel;
}(_component__WEBPACK_IMPORTED_MODULE_2__[/* Component */ "a"]));



/***/ }),

/***/ "4b14":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HeaderRowContainerCtrl; });
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("59ec");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/* harmony import */ var _eventKeys__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("2377");
/* harmony import */ var _gridBodyComp_centerWidthFeature__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("dae3");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("7347");
/* harmony import */ var _columnDrag_bodyDropTarget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("9969");
/* harmony import */ var _row_headerRowComp__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("2ce1");
/* harmony import */ var _row_headerRowCtrl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("71e5");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __spreadArrays = (undefined && undefined.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};









var HeaderRowContainerCtrl = /** @class */ (function (_super) {
    __extends(HeaderRowContainerCtrl, _super);
    function HeaderRowContainerCtrl(pinned) {
        var _this = _super.call(this) || this;
        _this.groupsRowCtrls = [];
        _this.pinned = pinned;
        return _this;
    }
    HeaderRowContainerCtrl.prototype.setComp = function (comp, eGui) {
        this.comp = comp;
        this.setupCenterWidth();
        this.setupPinnedWidth();
        this.setupDragAndDrop(eGui);
        this.addManagedListener(this.eventService, _eventKeys__WEBPACK_IMPORTED_MODULE_3__[/* Events */ "a"].EVENT_GRID_COLUMNS_CHANGED, this.onGridColumnsChanged.bind(this));
        this.ctrlsService.registerHeaderContainer(this, this.pinned);
        if (this.columnModel.isReady()) {
            this.refresh();
        }
    };
    HeaderRowContainerCtrl.prototype.setupDragAndDrop = function (dropContainer) {
        var bodyDropTarget = new _columnDrag_bodyDropTarget__WEBPACK_IMPORTED_MODULE_6__[/* BodyDropTarget */ "a"](this.pinned, dropContainer);
        this.createManagedBean(bodyDropTarget);
    };
    HeaderRowContainerCtrl.prototype.refresh = function (keepColumns) {
        var _this = this;
        if (keepColumns === void 0) { keepColumns = false; }
        var sequence = new _utils__WEBPACK_IMPORTED_MODULE_5__[/* NumberSequence */ "c"]();
        var focusedHeaderPosition = this.focusService.getFocusHeaderToUseAfterRefresh();
        var refreshColumnGroups = function () {
            var groupRowCount = _this.columnModel.getHeaderRowCount() - 1;
            _this.groupsRowCtrls = _this.destroyBeans(_this.groupsRowCtrls);
            for (var i = 0; i < groupRowCount; i++) {
                var ctrl = _this.createBean(new _row_headerRowCtrl__WEBPACK_IMPORTED_MODULE_8__[/* HeaderRowCtrl */ "a"](sequence.next(), _this.pinned, _row_headerRowComp__WEBPACK_IMPORTED_MODULE_7__[/* HeaderRowType */ "b"].COLUMN_GROUP));
                _this.groupsRowCtrls.push(ctrl);
            }
        };
        var refreshColumns = function () {
            var rowIndex = sequence.next();
            var needNewInstance = _this.columnsRowCtrl == null || !keepColumns || _this.columnsRowCtrl.getRowIndex() !== rowIndex;
            if (needNewInstance) {
                _this.destroyBean(_this.columnsRowCtrl);
                _this.columnsRowCtrl = _this.createBean(new _row_headerRowCtrl__WEBPACK_IMPORTED_MODULE_8__[/* HeaderRowCtrl */ "a"](rowIndex, _this.pinned, _row_headerRowComp__WEBPACK_IMPORTED_MODULE_7__[/* HeaderRowType */ "b"].COLUMN));
            }
        };
        var refreshFilters = function () {
            var includeFloatingFilter = !_this.columnModel.isPivotMode() && _this.columnModel.hasFloatingFilters();
            var destroyPreviousComp = function () {
                _this.filtersRowCtrl = _this.destroyBean(_this.filtersRowCtrl);
            };
            if (!includeFloatingFilter) {
                destroyPreviousComp();
                return;
            }
            var rowIndex = sequence.next();
            if (_this.filtersRowCtrl) {
                var rowIndexMismatch = _this.filtersRowCtrl.getRowIndex() !== rowIndex;
                if (!keepColumns || rowIndexMismatch) {
                    destroyPreviousComp();
                }
            }
            if (!_this.filtersRowCtrl) {
                _this.filtersRowCtrl = _this.createBean(new _row_headerRowCtrl__WEBPACK_IMPORTED_MODULE_8__[/* HeaderRowCtrl */ "a"](rowIndex, _this.pinned, _row_headerRowComp__WEBPACK_IMPORTED_MODULE_7__[/* HeaderRowType */ "b"].FLOATING_FILTER));
            }
        };
        refreshColumnGroups();
        refreshColumns();
        refreshFilters();
        var allCtrls = this.getAllCtrls();
        this.comp.setCtrls(allCtrls);
        this.restoreFocusOnHeader(focusedHeaderPosition);
    };
    HeaderRowContainerCtrl.prototype.restoreFocusOnHeader = function (position) {
        if (position == null || position.column.getPinned() != this.pinned) {
            return;
        }
        this.focusService.focusHeaderPosition(position);
    };
    HeaderRowContainerCtrl.prototype.getAllCtrls = function () {
        var res = __spreadArrays(this.groupsRowCtrls, [this.columnsRowCtrl]);
        if (this.filtersRowCtrl) {
            res.push(this.filtersRowCtrl);
        }
        return res;
    };
    // grid cols have changed - this also means the number of rows in the header can have
    // changed. so we remove all the old rows and insert new ones for a complete refresh
    HeaderRowContainerCtrl.prototype.onGridColumnsChanged = function () {
        this.refresh(true);
    };
    HeaderRowContainerCtrl.prototype.setupCenterWidth = function () {
        var _this = this;
        if (this.pinned != null) {
            return;
        }
        this.createManagedBean(new _gridBodyComp_centerWidthFeature__WEBPACK_IMPORTED_MODULE_4__[/* CenterWidthFeature */ "a"](function (width) { return _this.comp.setCenterWidth(width + "px"); }));
    };
    HeaderRowContainerCtrl.prototype.setHorizontalScroll = function (offset) {
        this.comp.setContainerTransform("translateX(" + offset + "px)");
    };
    HeaderRowContainerCtrl.prototype.setupPinnedWidth = function () {
        var _this = this;
        if (this.pinned == null) {
            return;
        }
        var pinningLeft = this.pinned === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].PINNED_LEFT;
        var pinningRight = this.pinned === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].PINNED_RIGHT;
        var listener = function () {
            var width = pinningLeft ? _this.pinnedWidthService.getPinnedLeftWidth() : _this.pinnedWidthService.getPinnedRightWidth();
            if (width == null) {
                return;
            } // can happen at initialisation, width not yet set
            var hidden = width == 0;
            var isRtl = _this.gridOptionsWrapper.isEnableRtl();
            var scrollbarWidth = _this.gridOptionsWrapper.getScrollbarWidth();
            // if there is a scroll showing (and taking up space, so Windows, and not iOS)
            // in the body, then we add extra space to keep header aligned with the body,
            // as body width fits the cols and the scrollbar
            var addPaddingForScrollbar = _this.scrollVisibleService.isVerticalScrollShowing() && ((isRtl && pinningLeft) || (!isRtl && pinningRight));
            var widthWithPadding = addPaddingForScrollbar ? width + scrollbarWidth : width;
            _this.comp.setPinnedContainerWidth(widthWithPadding + 'px');
            _this.comp.addOrRemoveCssClass('ag-hidden', hidden);
        };
        this.addManagedListener(this.eventService, _eventKeys__WEBPACK_IMPORTED_MODULE_3__[/* Events */ "a"].EVENT_LEFT_PINNED_WIDTH_CHANGED, listener);
        this.addManagedListener(this.eventService, _eventKeys__WEBPACK_IMPORTED_MODULE_3__[/* Events */ "a"].EVENT_RIGHT_PINNED_WIDTH_CHANGED, listener);
        this.addManagedListener(this.eventService, _eventKeys__WEBPACK_IMPORTED_MODULE_3__[/* Events */ "a"].EVENT_SCROLL_VISIBILITY_CHANGED, listener);
        this.addManagedListener(this.eventService, _eventKeys__WEBPACK_IMPORTED_MODULE_3__[/* Events */ "a"].EVENT_SCROLLBAR_WIDTH_CHANGED, listener);
    };
    HeaderRowContainerCtrl.prototype.getHtmlElementForColumnHeader = function (column) {
        if (this.columnsRowCtrl) {
            return this.columnsRowCtrl.getHtmlElementForColumnHeader(column);
        }
    };
    HeaderRowContainerCtrl.prototype.getRowType = function (rowIndex) {
        var allCtrls = this.getAllCtrls();
        var ctrl = allCtrls[rowIndex];
        return ctrl ? ctrl.getType() : undefined;
    };
    HeaderRowContainerCtrl.prototype.focusHeader = function (rowIndex, column) {
        var allCtrls = this.getAllCtrls();
        var ctrl = allCtrls[rowIndex];
        if (!ctrl) {
            return false;
        }
        return ctrl.focusHeader(column);
    };
    HeaderRowContainerCtrl.prototype.getRowCount = function () {
        return this.getAllCtrls().length;
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('ctrlsService')
    ], HeaderRowContainerCtrl.prototype, "ctrlsService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('scrollVisibleService')
    ], HeaderRowContainerCtrl.prototype, "scrollVisibleService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('pinnedWidthService')
    ], HeaderRowContainerCtrl.prototype, "pinnedWidthService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('columnModel')
    ], HeaderRowContainerCtrl.prototype, "columnModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('focusService')
    ], HeaderRowContainerCtrl.prototype, "focusService", void 0);
    return HeaderRowContainerCtrl;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "4c9d":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AutoWidthCalculator; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("6352");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var AutoWidthCalculator = /** @class */ (function (_super) {
    __extends(AutoWidthCalculator, _super);
    function AutoWidthCalculator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoWidthCalculator.prototype.postConstruct = function () {
        var _this = this;
        this.ctrlsService.whenReady(function (p) {
            _this.centerRowContainerCon = p.centerRowContainerCtrl;
        });
    };
    // this is the trick: we create a dummy container and clone all the cells
    // into the dummy, then check the dummy's width. then destroy the dummy
    // as we don't need it any more.
    // drawback: only the cells visible on the screen are considered
    AutoWidthCalculator.prototype.getPreferredWidthForColumn = function (column, skipHeader) {
        var eHeaderCell = this.getHeaderCellForColumn(column);
        // cell isn't visible
        if (!eHeaderCell) {
            return -1;
        }
        var eDummyContainer = document.createElement('span');
        // position fixed, so it isn't restricted to the boundaries of the parent
        eDummyContainer.style.position = 'fixed';
        // we put the dummy into the body container, so it will inherit all the
        // css styles that the real cells are inheriting
        var eBodyContainer = this.centerRowContainerCon.getContainerElement();
        eBodyContainer.appendChild(eDummyContainer);
        // get all the cells that are currently displayed (this only brings back
        // rendered cells, rows not rendered due to row visualisation will not be here)
        this.putRowCellsIntoDummyContainer(column, eDummyContainer);
        if (!skipHeader) {
            // we only consider the lowest level cell, not the group cell. in 99% of the time, this
            // will be enough. if we consider groups, then it gets too complicated for what it's worth,
            // as the groups can span columns and this class only considers one column at a time.
            this.cloneItemIntoDummy(eHeaderCell, eDummyContainer);
        }
        // at this point, all the clones are lined up vertically with natural widths. the dummy
        // container will have a width wide enough just to fit the largest.
        var dummyContainerWidth = eDummyContainer.offsetWidth;
        // we are finished with the dummy container, so get rid of it
        eBodyContainer.removeChild(eDummyContainer);
        // we add padding as I found sometimes the gui still put '...' after some of the texts. so the
        // user can configure the grid to add a few more pixels after the calculated width
        var autoSizePadding = this.gridOptionsWrapper.getAutoSizePadding();
        return dummyContainerWidth + autoSizePadding;
    };
    AutoWidthCalculator.prototype.getHeaderCellForColumn = function (column) {
        var element = null;
        this.ctrlsService.getHeaderRowContainerCtrls().forEach(function (container) {
            var res = container.getHtmlElementForColumnHeader(column);
            if (res != null) {
                element = res;
            }
        });
        return element;
    };
    AutoWidthCalculator.prototype.putRowCellsIntoDummyContainer = function (column, eDummyContainer) {
        var _this = this;
        var eCellElements = this.rowRenderer.getAllCellsForColumn(column);
        eCellElements.forEach(function (eCell) { return _this.cloneItemIntoDummy(eCell, eDummyContainer); });
    };
    AutoWidthCalculator.prototype.cloneItemIntoDummy = function (eCell, eDummyContainer) {
        // make a deep clone of the cell
        var eCellClone = eCell.cloneNode(true);
        // the original has a fixed width, we remove this to allow the natural width based on content
        eCellClone.style.width = '';
        // the original has position = absolute, we need to remove this so it's positioned normally
        eCellClone.style.position = 'static';
        eCellClone.style.left = '';
        // we put the cell into a containing div, as otherwise the cells would just line up
        // on the same line, standard flow layout, by putting them into divs, they are laid
        // out one per line
        var eCloneParent = document.createElement('div');
        if (Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["containsClass"])(eCellClone, 'ag-header-cell')) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(eCloneParent, 'ag-header');
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(eCloneParent, 'ag-header-row');
            eCloneParent.style.position = 'static';
        }
        else {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(eCloneParent, 'ag-row');
        }
        // find parent using classes (headers have ag-header-cell, rows have ag-row), and copy classes from it.
        // if we didn't do this, things like ag-row-level-2 would be missing if present, which sets indents
        // onto group items.
        var pointer = eCell.parentElement;
        while (pointer) {
            if (pointer.classList.contains('ag-header-row') || pointer.classList.contains('ag-row')) {
                pointer.classList.forEach(function (item) {
                    // we skit ag-row-position-absolute, as this has structural CSS applied that stops the
                    // element from fitting into it's parent, and we need the element to stretch the parent
                    // as we are measuring the parents width
                    if (item != 'ag-row-position-absolute') {
                        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(eCloneParent, item);
                    }
                });
                break;
            }
            pointer = pointer.parentElement;
        }
        // table-row, so that each cell is on a row. i also tried display='block', but this
        // didn't work in IE
        eCloneParent.style.display = 'table-row';
        // the twig on the branch, the branch on the tree, the tree in the hole,
        // the hole in the bog, the bog in the clone, the clone in the parent,
        // the parent in the dummy, and the dummy down in the vall-e-ooo, OOOOOOOOO! Oh row the rattling bog....
        eCloneParent.appendChild(eCellClone);
        eDummyContainer.appendChild(eCloneParent);
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('rowRenderer')
    ], AutoWidthCalculator.prototype, "rowRenderer", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('ctrlsService')
    ], AutoWidthCalculator.prototype, "ctrlsService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('rowCssClassCalculator')
    ], AutoWidthCalculator.prototype, "rowCssClassCalculator", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_0__[/* PostConstruct */ "e"]
    ], AutoWidthCalculator.prototype, "postConstruct", null);
    AutoWidthCalculator = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('autoWidthCalculator')
    ], AutoWidthCalculator);
    return AutoWidthCalculator;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "4d64":
/***/ (function(module, exports, __webpack_require__) {

var toIndexedObject = __webpack_require__("fc6a");
var toAbsoluteIndex = __webpack_require__("23cb");
var lengthOfArrayLike = __webpack_require__("07fa");

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = lengthOfArrayLike(O);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ "4d89":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LayoutCssClasses; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return LayoutFeature; });
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("59ec");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("648b");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("bc71");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var LayoutCssClasses;
(function (LayoutCssClasses) {
    LayoutCssClasses["AUTO_HEIGHT"] = "ag-layout-auto-height";
    LayoutCssClasses["NORMAL"] = "ag-layout-normal";
    LayoutCssClasses["PRINT"] = "ag-layout-print";
})(LayoutCssClasses || (LayoutCssClasses = {}));
var LayoutFeature = /** @class */ (function (_super) {
    __extends(LayoutFeature, _super);
    function LayoutFeature(view) {
        var _this = _super.call(this) || this;
        _this.view = view;
        return _this;
    }
    LayoutFeature.prototype.postConstruct = function () {
        this.addManagedListener(this.gridOptionsWrapper, _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_2__[/* GridOptionsWrapper */ "a"].PROP_DOM_LAYOUT, this.updateLayoutClasses.bind(this));
        this.updateLayoutClasses();
    };
    LayoutFeature.prototype.updateLayoutClasses = function () {
        var domLayout = this.gridOptionsWrapper.getDomLayout();
        var params = {
            autoHeight: domLayout === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].DOM_LAYOUT_AUTO_HEIGHT,
            normal: domLayout === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].DOM_LAYOUT_NORMAL,
            print: domLayout === _constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].DOM_LAYOUT_PRINT
        };
        var cssClass = params.autoHeight ? LayoutCssClasses.AUTO_HEIGHT :
            params.print ? LayoutCssClasses.PRINT : LayoutCssClasses.NORMAL;
        this.view.updateLayoutClasses(cssClass, params);
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('gridOptionsWrapper')
    ], LayoutFeature.prototype, "gridOptionsWrapper", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], LayoutFeature.prototype, "postConstruct", null);
    return LayoutFeature;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_3__[/* BeanStub */ "a"]));



/***/ }),

/***/ "4e60":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HeaderFilterCellCtrl; });
/* harmony import */ var _abstractCell_abstractHeaderCellCtrl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("22b5");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var HeaderFilterCellCtrl = /** @class */ (function (_super) {
    __extends(HeaderFilterCellCtrl, _super);
    function HeaderFilterCellCtrl(column, parentRowCtrl) {
        return _super.call(this, column, parentRowCtrl) || this;
    }
    HeaderFilterCellCtrl.prototype.setComp = function (comp, eGui) {
        _super.prototype.setGui.call(this, eGui);
    };
    return HeaderFilterCellCtrl;
}(_abstractCell_abstractHeaderCellCtrl__WEBPACK_IMPORTED_MODULE_0__[/* AbstractHeaderCellCtrl */ "a"]));



/***/ }),

/***/ "5001":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ providedFilter_ProvidedFilter; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/constants/constants.js
var constants = __webpack_require__("59ec");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/function.js
var utils_function = __webpack_require__("e900");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/filterLocaleText.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var DEFAULT_FILTER_LOCALE_TEXT = {
    applyFilter: 'Apply',
    clearFilter: 'Clear',
    resetFilter: 'Reset',
    cancelFilter: 'Cancel',
    textFilter: 'Text Filter',
    numberFilter: 'Number Filter',
    dateFilter: 'Date Filter',
    setFilter: 'Set Filter',
    filterOoo: 'Filter...',
    empty: 'Choose One',
    equals: 'Equals',
    notEqual: 'Not equal',
    lessThan: 'Less than',
    greaterThan: 'Greater than',
    inRange: 'In range',
    inRangeStart: 'From',
    inRangeEnd: 'To',
    lessThanOrEqual: 'Less than or equals',
    greaterThanOrEqual: 'Greater than or equals',
    contains: 'Contains',
    notContains: 'Not contains',
    startsWith: 'Starts with',
    endsWith: 'Ends with',
    andCondition: 'AND',
    orCondition: 'OR',
    dateFormatOoo: 'yyyy-mm-dd',
};

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/managedFocusFeature.js
var managedFocusFeature = __webpack_require__("8453");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/set.js
var set = __webpack_require__("6ad9");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/filter/provided/providedFilter.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};








/**
 * Contains common logic to all provided filters (apply button, clear button, etc).
 * All the filters that come with AG Grid extend this class. User filters do not
 * extend this class.
 */
var providedFilter_ProvidedFilter = /** @class */ (function (_super) {
    __extends(ProvidedFilter, _super);
    function ProvidedFilter(filterNameKey) {
        var _this = _super.call(this) || this;
        _this.filterNameKey = filterNameKey;
        _this.applyActive = false;
        _this.hidePopup = null;
        // after the user hits 'apply' the model gets copied to here. this is then the model that we use for
        // all filtering. so if user changes UI but doesn't hit apply, then the UI will be out of sync with this model.
        // this is what we want, as the UI should only become the 'active' filter once it's applied. when apply is
        // inactive, this model will be in sync (following the debounce ms). if the UI is not a valid filter
        // (eg the value is missing so nothing to filter on, or for set filter all checkboxes are checked so filter
        // not active) then this appliedModel will be null/undefined.
        _this.appliedModel = null;
        return _this;
    }
    ProvidedFilter.prototype.postConstruct = function () {
        this.resetTemplate(); // do this first to create the DOM
        this.createManagedBean(new managedFocusFeature["a" /* ManagedFocusFeature */](this.getFocusableElement(), {
            handleKeyDown: this.handleKeyDown.bind(this)
        }));
    };
    // override
    ProvidedFilter.prototype.handleKeyDown = function (e) { };
    ProvidedFilter.prototype.getFilterTitle = function () {
        return this.translate(this.filterNameKey);
    };
    /** @deprecated */
    ProvidedFilter.prototype.onFilterChanged = function () {
        console.warn("AG Grid: you should not call onFilterChanged() directly on the filter, please call\n        gridApi.onFilterChanged() instead. onFilterChanged is not part of the exposed filter interface (it was\n        a method that existed on an old version of the filters that was not intended for public use.");
        this.providedFilterParams.filterChangedCallback();
    };
    ProvidedFilter.prototype.isFilterActive = function () {
        // filter is active if we have a valid applied model
        return !!this.appliedModel;
    };
    ProvidedFilter.prototype.resetTemplate = function (paramsMap) {
        var templateString = /* html */ "\n            <div class=\"ag-filter-wrapper\">\n                <div class=\"ag-filter-body-wrapper ag-" + this.getCssIdentifier() + "-body-wrapper\">\n                    " + this.createBodyTemplate() + "\n                </div>\n            </div>";
        this.setTemplate(templateString, paramsMap);
    };
    ProvidedFilter.prototype.init = function (params) {
        var _this = this;
        this.setParams(params);
        this.resetUiToDefaults(true).then(function () {
            _this.updateUiVisibility();
            _this.setupOnBtApplyDebounce();
        });
    };
    ProvidedFilter.prototype.setParams = function (params) {
        ProvidedFilter.checkForDeprecatedParams(params);
        this.providedFilterParams = params;
        if (params.newRowsAction === 'keep') {
            this.newRowsActionKeep = true;
        }
        else if (params.newRowsAction === 'clear') {
            this.newRowsActionKeep = false;
        }
        else {
            // the default for SSRM and IRM is 'keep', for CSRM and VRM the default is 'clear'
            var modelsForKeep = [constants["a" /* Constants */].ROW_MODEL_TYPE_SERVER_SIDE, constants["a" /* Constants */].ROW_MODEL_TYPE_INFINITE];
            this.newRowsActionKeep = modelsForKeep.indexOf(this.rowModel.getType()) >= 0;
        }
        this.applyActive = ProvidedFilter.isUseApplyButton(params);
        this.createButtonPanel();
    };
    ProvidedFilter.prototype.createButtonPanel = function () {
        var _this = this;
        var buttons = this.providedFilterParams.buttons;
        if (!buttons || buttons.length < 1) {
            return;
        }
        var eButtonsPanel = document.createElement('div');
        Object(dom["addCssClass"])(eButtonsPanel, 'ag-filter-apply-panel');
        var addButton = function (type) {
            var text;
            var clickListener;
            switch (type) {
                case 'apply':
                    text = _this.translate('applyFilter');
                    clickListener = function (e) { return _this.onBtApply(false, false, e); };
                    break;
                case 'clear':
                    text = _this.translate('clearFilter');
                    clickListener = function () { return _this.onBtClear(); };
                    break;
                case 'reset':
                    text = _this.translate('resetFilter');
                    clickListener = function () { return _this.onBtReset(); };
                    break;
                case 'cancel':
                    text = _this.translate('cancelFilter');
                    clickListener = function (e) { _this.onBtCancel(e); };
                    break;
                default:
                    console.warn('Unknown button type specified');
                    return;
            }
            var button = Object(dom["loadTemplate"])(
            /* html */
            "<button\n                    type=\"button\"\n                    ref=\"" + type + "FilterButton\"\n                    class=\"ag-standard-button ag-filter-apply-panel-button\"\n                >" + text + "\n                </button>");
            eButtonsPanel.appendChild(button);
            _this.addManagedListener(button, 'click', clickListener);
        };
        Object(set["convertToSet"])(buttons).forEach(function (type) { return addButton(type); });
        this.getGui().appendChild(eButtonsPanel);
    };
    ProvidedFilter.checkForDeprecatedParams = function (params) {
        var buttons = params.buttons || [];
        if (buttons.length > 0) {
            return;
        }
        var applyButton = params.applyButton, resetButton = params.resetButton, clearButton = params.clearButton;
        if (clearButton) {
            console.warn('AG Grid: as of AG Grid v23.2, filterParams.clearButton is deprecated. Please use filterParams.buttons instead');
            buttons.push('clear');
        }
        if (resetButton) {
            console.warn('AG Grid: as of AG Grid v23.2, filterParams.resetButton is deprecated. Please use filterParams.buttons instead');
            buttons.push('reset');
        }
        if (applyButton) {
            console.warn('AG Grid: as of AG Grid v23.2, filterParams.applyButton is deprecated. Please use filterParams.buttons instead');
            buttons.push('apply');
        }
        if (params.apply) {
            console.warn('AG Grid: as of AG Grid v21, filterParams.apply is deprecated. Please use filterParams.buttons instead');
            buttons.push('apply');
        }
        params.buttons = buttons;
    };
    // subclasses can override this to provide alternative debounce defaults
    ProvidedFilter.prototype.getDefaultDebounceMs = function () {
        return 0;
    };
    ProvidedFilter.prototype.setupOnBtApplyDebounce = function () {
        var debounceMs = ProvidedFilter.getDebounceMs(this.providedFilterParams, this.getDefaultDebounceMs());
        this.onBtApplyDebounce = Object(utils_function["debounce"])(this.onBtApply.bind(this), debounceMs);
    };
    ProvidedFilter.prototype.getModel = function () {
        return this.appliedModel;
    };
    ProvidedFilter.prototype.setModel = function (model) {
        var _this = this;
        var promise = model ? this.setModelIntoUi(model) : this.resetUiToDefaults();
        return promise.then(function () {
            _this.updateUiVisibility();
            // we set the model from the GUI, rather than the provided model,
            // so the model is consistent, e.g. handling of null/undefined will be the same,
            // or if model is case insensitive, then casing is removed.
            _this.applyModel();
        });
    };
    ProvidedFilter.prototype.onBtCancel = function (e) {
        var _this = this;
        var currentModel = this.getModel();
        var afterAppliedFunc = function () {
            _this.onUiChanged(false, 'prevent');
            if (_this.providedFilterParams.closeOnApply) {
                _this.close(e);
            }
        };
        if (currentModel != null) {
            this.setModelIntoUi(currentModel).then(afterAppliedFunc);
        }
        else {
            this.resetUiToDefaults().then(afterAppliedFunc);
        }
    };
    ProvidedFilter.prototype.onBtClear = function () {
        var _this = this;
        this.resetUiToDefaults().then(function () { return _this.onUiChanged(); });
    };
    ProvidedFilter.prototype.onBtReset = function () {
        this.onBtClear();
        this.onBtApply();
    };
    /**
     * Applies changes made in the UI to the filter, and returns true if the model has changed.
     */
    ProvidedFilter.prototype.applyModel = function () {
        var newModel = this.getModelFromUi();
        if (!this.isModelValid(newModel)) {
            return false;
        }
        var previousModel = this.appliedModel;
        this.appliedModel = newModel;
        // models can be same if user pasted same content into text field, or maybe just changed the case
        // and it's a case insensitive filter
        return !this.areModelsEqual(previousModel, newModel);
    };
    ProvidedFilter.prototype.isModelValid = function (model) {
        return true;
    };
    ProvidedFilter.prototype.onBtApply = function (afterFloatingFilter, afterDataChange, e) {
        if (afterFloatingFilter === void 0) { afterFloatingFilter = false; }
        if (afterDataChange === void 0) { afterDataChange = false; }
        if (this.applyModel()) {
            // the floating filter uses 'afterFloatingFilter' info, so it doesn't refresh after filter changed if change
            // came from floating filter
            this.providedFilterParams.filterChangedCallback({ afterFloatingFilter: afterFloatingFilter, afterDataChange: afterDataChange });
        }
        var closeOnApply = this.providedFilterParams.closeOnApply;
        // only close if an apply button is visible, otherwise we'd be closing every time a change was made!
        if (closeOnApply && this.applyActive && !afterFloatingFilter && !afterDataChange) {
            this.close(e);
        }
    };
    ProvidedFilter.prototype.onNewRowsLoaded = function () {
        var _this = this;
        if (!this.newRowsActionKeep) {
            this.resetUiToDefaults().then(function () { return _this.appliedModel = null; });
        }
    };
    ProvidedFilter.prototype.close = function (e) {
        if (!this.hidePopup) {
            return;
        }
        var keyboardEvent = e;
        var key = keyboardEvent && keyboardEvent.key;
        var params;
        if (key === 'Enter' || key === 'Space') {
            params = { keyboardEvent: keyboardEvent };
        }
        this.hidePopup(params);
        this.hidePopup = null;
    };
    // called by set filter
    ProvidedFilter.prototype.isNewRowsActionKeep = function () {
        return this.newRowsActionKeep;
    };
    /**
     * By default, if the change came from a floating filter it will be applied immediately, otherwise if there is no
     * apply button it will be applied after a debounce, otherwise it will not be applied at all. This behaviour can
     * be adjusted by using the apply parameter.
     */
    ProvidedFilter.prototype.onUiChanged = function (fromFloatingFilter, apply) {
        if (fromFloatingFilter === void 0) { fromFloatingFilter = false; }
        this.updateUiVisibility();
        this.providedFilterParams.filterModifiedCallback();
        if (this.applyActive) {
            var isValid = this.isModelValid(this.getModelFromUi());
            Object(dom["setDisabled"])(this.getRefElement('applyFilterButton'), !isValid);
        }
        if ((fromFloatingFilter && !apply) || apply === 'immediately') {
            this.onBtApply(fromFloatingFilter);
        }
        else if ((!this.applyActive && !apply) || apply === 'debounce') {
            this.onBtApplyDebounce();
        }
    };
    ProvidedFilter.prototype.afterGuiAttached = function (params) {
        if (params == null) {
            return;
        }
        this.hidePopup = params.hidePopup;
    };
    // static, as used by floating filter also
    ProvidedFilter.getDebounceMs = function (params, debounceDefault) {
        if (ProvidedFilter.isUseApplyButton(params)) {
            if (params.debounceMs != null) {
                console.warn('AG Grid: debounceMs is ignored when apply button is present');
            }
            return 0;
        }
        return params.debounceMs != null ? params.debounceMs : debounceDefault;
    };
    // static, as used by floating filter also
    ProvidedFilter.isUseApplyButton = function (params) {
        ProvidedFilter.checkForDeprecatedParams(params);
        return !!params.buttons && params.buttons.indexOf('apply') >= 0;
    };
    ProvidedFilter.prototype.destroy = function () {
        this.hidePopup = null;
        _super.prototype.destroy.call(this);
    };
    ProvidedFilter.prototype.translate = function (key) {
        var translate = this.gridOptionsWrapper.getLocaleTextFunc();
        return translate(key, DEFAULT_FILTER_LOCALE_TEXT[key]);
    };
    __decorate([
        Object(context["a" /* Autowired */])('rowModel')
    ], ProvidedFilter.prototype, "rowModel", void 0);
    __decorate([
        context["e" /* PostConstruct */]
    ], ProvidedFilter.prototype, "postConstruct", null);
    return ProvidedFilter;
}(component["a" /* Component */]));



/***/ }),

/***/ "50c4":
/***/ (function(module, exports, __webpack_require__) {

var toIntegerOrInfinity = __webpack_require__("5926");

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
module.exports = function (argument) {
  return argument > 0 ? min(toIntegerOrInfinity(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ "5230":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return PopupEditorWrapper; });
/* harmony import */ var _widgets_popupComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bdb9");
/* harmony import */ var _utils_keyboard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("756a");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var PopupEditorWrapper = /** @class */ (function (_super) {
    __extends(PopupEditorWrapper, _super);
    function PopupEditorWrapper(params) {
        var _this = _super.call(this, /* html */ "<div class=\"ag-popup-editor\" tabindex=\"-1\"/>") || this;
        _this.params = params;
        return _this;
    }
    PopupEditorWrapper.prototype.postConstruct = function () {
        this.gridOptionsWrapper.setDomData(this.getGui(), PopupEditorWrapper.DOM_KEY_POPUP_EDITOR_WRAPPER, true);
        this.addKeyDownListener();
    };
    PopupEditorWrapper.prototype.addKeyDownListener = function () {
        var _this = this;
        var eGui = this.getGui();
        var params = this.params;
        var listener = function (event) {
            if (!Object(_utils_keyboard__WEBPACK_IMPORTED_MODULE_1__["isUserSuppressingKeyboardEvent"])(_this.gridOptionsWrapper, event, params.node, params.column, true)) {
                params.onKeyDown(event);
            }
        };
        this.addManagedListener(eGui, 'keydown', listener);
    };
    PopupEditorWrapper.DOM_KEY_POPUP_EDITOR_WRAPPER = 'popupEditorWrapper';
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_2__[/* PostConstruct */ "e"]
    ], PopupEditorWrapper.prototype, "postConstruct", null);
    return PopupEditorWrapper;
}(_widgets_popupComponent__WEBPACK_IMPORTED_MODULE_0__[/* PopupComponent */ "a"]));



/***/ }),

/***/ "5265":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export defaultGroupComparator */
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */

function defaultGroupComparator(valueA, valueB, nodeA, nodeB, accentedCompare) {
    if (accentedCompare === void 0) { accentedCompare = false; }
    console.warn('AG Grid: Since ag-grid 11.0.0 defaultGroupComparator is not necessary. You can remove this from your colDef');
    var nodeAIsGroup = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_0__["exists"])(nodeA) && nodeA.group;
    var nodeBIsGroup = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_0__["exists"])(nodeB) && nodeB.group;
    var bothAreGroups = nodeAIsGroup && nodeBIsGroup;
    var bothAreNormal = !nodeAIsGroup && !nodeBIsGroup;
    if (bothAreGroups) {
        return Object(_utils_generic__WEBPACK_IMPORTED_MODULE_0__["defaultComparator"])(nodeA.key, nodeB.key, accentedCompare);
    }
    if (bothAreNormal) {
        return Object(_utils_generic__WEBPACK_IMPORTED_MODULE_0__["defaultComparator"])(valueA, valueB, accentedCompare);
    }
    if (nodeAIsGroup) {
        return 1;
    }
    return -1;
}


/***/ }),

/***/ "528f":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ChangedPath; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
// when doing transactions, or change detection, and grouping is present
// in the data, there is no need for the ClientSideRowModel to update each
// group after an update, ony parts that were impacted by the change.
// this class keeps track of all groups that were impacted by a transaction.
// the the different CSRM operations (filter, sort etc) use the forEach method
// to visit each group that was changed.
var ChangedPath = /** @class */ (function () {
    function ChangedPath(keepingColumns, rootNode) {
        // whether changed path is active of not. it is active when a) doing
        // a transaction update or b) doing change detection. if we are doing
        // a CSRM refresh for other reasons (after sort or filter, or user calling
        // setRowData() without delta mode) then we are not active. we are also
        // marked as not active if secondary columns change in pivot (as this impacts
        // aggregations)
        this.active = true;
        // for each node in the change path, we also store which columns need
        // to be re-aggregated.
        this.nodeIdsToColumns = {};
        // for quick lookup, all items in the change path are mapped by nodeId
        this.mapToItems = {};
        this.keepingColumns = keepingColumns;
        this.pathRoot = {
            rowNode: rootNode,
            children: null
        };
        this.mapToItems[rootNode.id] = this.pathRoot;
    }
    // can be set inactive by:
    // a) ClientSideRowModel, if no transactions or
    // b) PivotService, if secondary columns changed
    ChangedPath.prototype.setInactive = function () {
        this.active = false;
    };
    ChangedPath.prototype.isActive = function () {
        return this.active;
    };
    ChangedPath.prototype.depthFirstSearchChangedPath = function (pathItem, callback) {
        if (pathItem.children) {
            for (var i = 0; i < pathItem.children.length; i++) {
                this.depthFirstSearchChangedPath(pathItem.children[i], callback);
            }
        }
        callback(pathItem.rowNode);
    };
    ChangedPath.prototype.depthFirstSearchEverything = function (rowNode, callback, traverseEverything) {
        if (rowNode.childrenAfterGroup) {
            for (var i = 0; i < rowNode.childrenAfterGroup.length; i++) {
                var childNode = rowNode.childrenAfterGroup[i];
                if (childNode.childrenAfterGroup) {
                    this.depthFirstSearchEverything(rowNode.childrenAfterGroup[i], callback, traverseEverything);
                }
                else if (traverseEverything) {
                    callback(childNode);
                }
            }
        }
        callback(rowNode);
    };
    // traverseLeafNodes -> used when NOT doing changed path, ie traversing everything. the callback
    // will be called for child nodes in addition to parent nodes.
    ChangedPath.prototype.forEachChangedNodeDepthFirst = function (callback, traverseLeafNodes) {
        if (traverseLeafNodes === void 0) { traverseLeafNodes = false; }
        if (this.active) {
            // if we are active, then use the change path to callback
            // only for updated groups
            this.depthFirstSearchChangedPath(this.pathRoot, callback);
        }
        else {
            // we are not active, so callback for everything, walk the entire path
            this.depthFirstSearchEverything(this.pathRoot.rowNode, callback, traverseLeafNodes);
        }
    };
    ChangedPath.prototype.executeFromRootNode = function (callback) {
        callback(this.pathRoot.rowNode);
    };
    ChangedPath.prototype.createPathItems = function (rowNode) {
        var pointer = rowNode;
        var newEntryCount = 0;
        while (!this.mapToItems[pointer.id]) {
            var newEntry = {
                rowNode: pointer,
                children: null
            };
            this.mapToItems[pointer.id] = newEntry;
            newEntryCount++;
            pointer = pointer.parent;
        }
        return newEntryCount;
    };
    ChangedPath.prototype.populateColumnsMap = function (rowNode, columns) {
        var _this = this;
        if (!this.keepingColumns || !columns) {
            return;
        }
        var pointer = rowNode;
        while (pointer) {
            // if columns, add the columns in all the way to parent, merging
            // in any other columns that might be there already
            if (!this.nodeIdsToColumns[pointer.id]) {
                this.nodeIdsToColumns[pointer.id] = {};
            }
            columns.forEach(function (col) { return _this.nodeIdsToColumns[pointer.id][col.getId()] = true; });
            pointer = pointer.parent;
        }
    };
    ChangedPath.prototype.linkPathItems = function (rowNode, newEntryCount) {
        var pointer = rowNode;
        for (var i = 0; i < newEntryCount; i++) {
            var thisItem = this.mapToItems[pointer.id];
            var parentItem = this.mapToItems[pointer.parent.id];
            if (!parentItem.children) {
                parentItem.children = [];
            }
            parentItem.children.push(thisItem);
            pointer = pointer.parent;
        }
    };
    // called by
    // 1) change detection (provides cols) and
    // 2) groupStage if doing transaction update (doesn't provide cols)
    ChangedPath.prototype.addParentNode = function (rowNode, columns) {
        if (!rowNode || rowNode.isRowPinned()) {
            return;
        }
        // we cannot do  both steps below in the same loop as
        // the second loop has a dependency on the first loop.
        // ie the hierarchy cannot be stitched up yet because
        // we don't have it built yet
        // create the new PathItem objects.
        var newEntryCount = this.createPathItems(rowNode);
        // link in the node items
        this.linkPathItems(rowNode, newEntryCount);
        // update columns
        this.populateColumnsMap(rowNode, columns);
    };
    ChangedPath.prototype.canSkip = function (rowNode) {
        return this.active && !this.mapToItems[rowNode.id];
    };
    ChangedPath.prototype.getValueColumnsForNode = function (rowNode, valueColumns) {
        if (!this.keepingColumns) {
            return valueColumns;
        }
        var colsForThisNode = this.nodeIdsToColumns[rowNode.id];
        var result = valueColumns.filter(function (col) { return colsForThisNode[col.getId()]; });
        return result;
    };
    ChangedPath.prototype.getNotValueColumnsForNode = function (rowNode, valueColumns) {
        if (!this.keepingColumns) {
            return null;
        }
        var colsForThisNode = this.nodeIdsToColumns[rowNode.id];
        var result = valueColumns.filter(function (col) { return !colsForThisNode[col.getId()]; });
        return result;
    };
    return ChangedPath;
}());



/***/ }),

/***/ "532c":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SimpleFloatingFilter; });
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("9cc8");
/* harmony import */ var _provided_simpleFilter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("cf29");
/* harmony import */ var _provided_optionsFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("5bd9");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var SimpleFloatingFilter = /** @class */ (function (_super) {
    __extends(SimpleFloatingFilter, _super);
    function SimpleFloatingFilter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SimpleFloatingFilter.prototype.getDefaultDebounceMs = function () {
        return 0;
    };
    // this is a user component, and IComponent has "public destroy()" as part of the interface.
    // so we need to override destroy() just to make the method public.
    SimpleFloatingFilter.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    // used by:
    // 1) NumberFloatingFilter & TextFloatingFilter: Always, for both when editable and read only.
    // 2) DateFloatingFilter: Only when read only (as we show text rather than a date picker when read only)
    SimpleFloatingFilter.prototype.getTextFromModel = function (model) {
        if (!model) {
            return null;
        }
        var isCombined = model.operator;
        if (isCombined) {
            var combinedModel = model;
            var con1Str = this.conditionToString(combinedModel.condition1);
            var con2Str = this.conditionToString(combinedModel.condition2);
            return con1Str + " " + combinedModel.operator + " " + con2Str;
        }
        else {
            var condition = model;
            var customOption = this.optionsFactory.getCustomOption(condition.type);
            // For custom filter options we display the Name of the filter instead
            // of displaying the `from` value, as it wouldn't be relevant
            if (customOption && customOption.hideFilterInput) {
                this.gridOptionsWrapper.getLocaleTextFunc()(customOption.displayKey, customOption.displayName);
                return customOption.displayName;
            }
            return this.conditionToString(condition);
        }
    };
    SimpleFloatingFilter.prototype.isEventFromFloatingFilter = function (event) {
        return event && event.afterFloatingFilter;
    };
    SimpleFloatingFilter.prototype.getLastType = function () {
        return this.lastType;
    };
    SimpleFloatingFilter.prototype.setLastTypeFromModel = function (model) {
        // if no model provided by the parent filter use default
        if (!model) {
            this.lastType = this.optionsFactory.getDefaultOption();
            return;
        }
        var isCombined = model.operator;
        var condition;
        if (isCombined) {
            var combinedModel = model;
            condition = combinedModel.condition1;
        }
        else {
            condition = model;
        }
        this.lastType = condition.type;
    };
    SimpleFloatingFilter.prototype.canWeEditAfterModelFromParentFilter = function (model) {
        if (!model) {
            // if no model, then we can edit as long as the lastType is something we can edit, as this
            // is the type we will provide to the parent filter if the user decides to use the floating filter.
            return this.isTypeEditable(this.lastType);
        }
        // never allow editing if the filter is combined (ie has two parts)
        var isCombined = model.operator;
        if (isCombined) {
            return false;
        }
        var simpleModel = model;
        return this.isTypeEditable(simpleModel.type);
    };
    SimpleFloatingFilter.prototype.init = function (params) {
        this.optionsFactory = new _provided_optionsFactory__WEBPACK_IMPORTED_MODULE_2__[/* OptionsFactory */ "a"]();
        this.optionsFactory.init(params.filterParams, this.getDefaultFilterOptions());
        this.lastType = this.optionsFactory.getDefaultOption();
        // we are editable if:
        // 1) there is a type (user has configured filter wrong if not type)
        //  AND
        // 2) the default type is not 'in range'
        var editable = this.isTypeEditable(this.lastType);
        this.setEditable(editable);
    };
    SimpleFloatingFilter.prototype.doesFilterHaveHiddenInput = function (filterType) {
        var customFilterOption = this.optionsFactory.getCustomOption(filterType);
        return customFilterOption && customFilterOption.hideFilterInput;
    };
    SimpleFloatingFilter.prototype.isTypeEditable = function (type) {
        return !!type && !this.doesFilterHaveHiddenInput(type) &&
            type !== _provided_simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].IN_RANGE
            && type !== _provided_simpleFilter__WEBPACK_IMPORTED_MODULE_1__[/* SimpleFilter */ "b"].EMPTY;
    };
    return SimpleFloatingFilter;
}(_widgets_component__WEBPACK_IMPORTED_MODULE_0__[/* Component */ "a"]));



/***/ }),

/***/ "53bb":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return PositionableFeature; });
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bc71");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("6352");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("562d");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var RESIZE_CONTAINER_STYLE = 'ag-resizer-wrapper';
var RESIZE_TEMPLATE = /* html */ "<div class=\"" + RESIZE_CONTAINER_STYLE + "\">\n        <div ref=\"eTopLeftResizer\" class=\"ag-resizer ag-resizer-topLeft\"></div>\n        <div ref=\"eTopResizer\" class=\"ag-resizer ag-resizer-top\"></div>\n        <div ref=\"eTopRightResizer\" class=\"ag-resizer ag-resizer-topRight\"></div>\n        <div ref=\"eRightResizer\" class=\"ag-resizer ag-resizer-right\"></div>\n        <div ref=\"eBottomRightResizer\" class=\"ag-resizer ag-resizer-bottomRight\"></div>\n        <div ref=\"eBottomResizer\" class=\"ag-resizer ag-resizer-bottom\"></div>\n        <div ref=\"eBottomLeftResizer\" class=\"ag-resizer ag-resizer-bottomLeft\"></div>\n        <div ref=\"eLeftResizer\" class=\"ag-resizer ag-resizer-left\"></div>\n    </div>";
var PositionableFeature = /** @class */ (function (_super) {
    __extends(PositionableFeature, _super);
    function PositionableFeature(element, config) {
        var _this = _super.call(this) || this;
        _this.element = element;
        _this.dragStartPosition = {
            x: 0,
            y: 0
        };
        _this.position = {
            x: 0,
            y: 0
        };
        _this.lastSize = {
            width: -1,
            height: -1
        };
        _this.positioned = false;
        _this.resizersAdded = false;
        _this.resizeListeners = [];
        _this.boundaryEl = null;
        _this.isResizing = false;
        _this.isMoving = false;
        _this.resizable = {};
        _this.movable = false;
        _this.currentResizer = null;
        _this.config = Object(_utils_object__WEBPACK_IMPORTED_MODULE_3__["assign"])({}, { popup: false }, config);
        return _this;
    }
    PositionableFeature.prototype.center = function () {
        var _a = this.offsetParent, clientHeight = _a.clientHeight, clientWidth = _a.clientWidth;
        var x = (clientWidth / 2) - (this.getWidth() / 2);
        var y = (clientHeight / 2) - (this.getHeight() / 2);
        this.offsetElement(x, y);
    };
    PositionableFeature.prototype.initialisePosition = function () {
        var _a = this.config, centered = _a.centered, forcePopupParentAsOffsetParent = _a.forcePopupParentAsOffsetParent, minWidth = _a.minWidth, width = _a.width, minHeight = _a.minHeight, height = _a.height, x = _a.x, y = _a.y;
        if (!this.offsetParent) {
            this.setOffsetParent();
        }
        var computedMinHeight = 0;
        var computedMinWidth = 0;
        // here we don't use the main offset parent but the element's offsetParent
        // in order to calculated the minWidth and minHeight correctly
        var isVisible = !!this.element.offsetParent;
        if (isVisible) {
            var boundaryEl = this.findBoundaryElement();
            var offsetParentComputedStyles = window.getComputedStyle(boundaryEl);
            if (offsetParentComputedStyles.minWidth != null) {
                var paddingWidth = boundaryEl.offsetWidth - this.element.offsetWidth;
                computedMinWidth = parseInt(offsetParentComputedStyles.minWidth, 10) - paddingWidth;
            }
            if (offsetParentComputedStyles.minHeight != null) {
                var paddingHeight = boundaryEl.offsetHeight - this.element.offsetHeight;
                computedMinHeight = parseInt(offsetParentComputedStyles.minHeight, 10) - paddingHeight;
            }
        }
        this.minHeight = minHeight || computedMinHeight;
        this.minWidth = minWidth || computedMinWidth;
        if (width) {
            this.setWidth(width);
        }
        if (height) {
            this.setHeight(height);
        }
        if (!width || !height) {
            this.refreshSize();
        }
        if (centered) {
            this.center();
        }
        else if (x || y) {
            this.offsetElement(x, y);
        }
        else if (isVisible && forcePopupParentAsOffsetParent && this.boundaryEl) {
            var top_1 = parseFloat(this.boundaryEl.style.top);
            var left = parseFloat(this.boundaryEl.style.left);
            this.offsetElement(isNaN(left) ? 0 : left, isNaN(top_1) ? 0 : top_1);
        }
        this.positioned = !!this.offsetParent;
    };
    PositionableFeature.prototype.isPositioned = function () {
        return this.positioned;
    };
    PositionableFeature.prototype.getPosition = function () {
        return this.position;
    };
    PositionableFeature.prototype.setMovable = function (movable, moveElement) {
        if (!this.config.popup || movable === this.movable) {
            return;
        }
        this.movable = movable;
        var params = this.moveElementDragListener || {
            eElement: moveElement,
            onDragStart: this.onMoveStart.bind(this),
            onDragging: this.onMove.bind(this),
            onDragStop: this.onMoveEnd.bind(this)
        };
        if (movable) {
            this.dragService.addDragSource(params);
            this.moveElementDragListener = params;
        }
        else {
            this.dragService.removeDragSource(params);
            this.moveElementDragListener = undefined;
        }
    };
    PositionableFeature.prototype.setResizable = function (resizable) {
        var _this = this;
        this.clearResizeListeners();
        if (resizable) {
            this.addResizers();
        }
        else {
            this.removeResizers();
        }
        if (typeof resizable === 'boolean') {
            if (resizable === false) {
                return;
            }
            resizable = {
                topLeft: resizable,
                top: resizable,
                topRight: resizable,
                right: resizable,
                bottomRight: resizable,
                bottom: resizable,
                bottomLeft: resizable,
                left: resizable
            };
        }
        Object.keys(resizable).forEach(function (side) {
            var resizableStructure = resizable;
            var val = !!resizableStructure[side];
            var resizerEl = _this.getResizerElement(side);
            var params = {
                dragStartPixels: 0,
                eElement: resizerEl,
                onDragStart: function (e) { return _this.onResizeStart(e, side); },
                onDragging: _this.onResize.bind(_this),
                onDragStop: function (e) { return _this.onResizeEnd(e, side); },
            };
            if (!!_this.resizable[side] !== val || (!_this.isAlive() && !val)) {
                if (val) {
                    _this.dragService.addDragSource(params);
                    _this.resizeListeners.push(params);
                    resizerEl.style.pointerEvents = 'all';
                }
                else {
                    resizerEl.style.pointerEvents = 'none';
                }
            }
        });
    };
    PositionableFeature.prototype.removeSizeFromEl = function () {
        this.element.style.removeProperty('height');
        this.element.style.removeProperty('width');
        this.element.style.removeProperty('flex');
    };
    PositionableFeature.prototype.restoreLastSize = function () {
        this.element.style.flex = '0 0 auto';
        var _a = this.lastSize, height = _a.height, width = _a.width;
        if (width !== -1) {
            this.element.style.width = width + "px";
        }
        if (height !== -1) {
            this.element.style.height = height + "px";
        }
    };
    PositionableFeature.prototype.getHeight = function () {
        return this.element.offsetHeight;
    };
    PositionableFeature.prototype.setHeight = function (height) {
        var popup = this.config.popup;
        var eGui = this.element;
        var isPercent = false;
        if (typeof height === 'string' && height.indexOf('%') !== -1) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setFixedHeight"])(eGui, height);
            height = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["getAbsoluteHeight"])(eGui);
            isPercent = true;
        }
        else if (this.positioned) {
            var elRect = this.element.getBoundingClientRect();
            var parentRect = this.offsetParent.getBoundingClientRect();
            height = Math.max(this.minHeight, height);
            var clientHeight = this.offsetParent.clientHeight;
            var yPosition = popup ? this.position.y : elRect.top;
            var parentTop = popup ? 0 : parentRect.top;
            if (clientHeight && (height + yPosition > clientHeight + parentTop)) {
                height = clientHeight - yPosition;
            }
        }
        if (this.getHeight() === height) {
            return;
        }
        if (!isPercent) {
            if (popup) {
                Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setFixedHeight"])(eGui, height);
            }
            else {
                eGui.style.height = height + "px";
                eGui.style.flex = '0 0 auto';
                this.lastSize.height = typeof height === 'number' ? height : parseFloat(height);
            }
        }
        else {
            eGui.style.maxHeight = 'unset';
            eGui.style.minHeight = 'unset';
        }
    };
    PositionableFeature.prototype.getWidth = function () {
        return this.element.offsetWidth;
    };
    PositionableFeature.prototype.setWidth = function (width) {
        var eGui = this.element;
        var popup = this.config.popup;
        var isPercent = false;
        if (typeof width === 'string' && width.indexOf('%') !== -1) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setFixedWidth"])(eGui, width);
            width = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["getAbsoluteWidth"])(eGui);
            isPercent = true;
        }
        else if (this.positioned) {
            width = Math.max(this.minWidth, width);
            var clientWidth = this.offsetParent.clientWidth;
            var xPosition = popup ? this.position.x : this.element.getBoundingClientRect().left;
            if (clientWidth && (width + xPosition > clientWidth)) {
                width = clientWidth - xPosition;
            }
        }
        if (this.getWidth() === width) {
            return;
        }
        if (!isPercent) {
            if (this.config.popup) {
                Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setFixedWidth"])(eGui, width);
            }
            else {
                eGui.style.width = width + "px";
                eGui.style.flex = ' unset';
                this.lastSize.width = typeof width === 'number' ? width : parseFloat(width);
            }
        }
        else {
            eGui.style.maxWidth = 'unset';
            eGui.style.minWidth = 'unset';
        }
    };
    PositionableFeature.prototype.offsetElement = function (x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var ePopup = this.config.forcePopupParentAsOffsetParent ? this.boundaryEl : this.element;
        this.popupService.positionPopup({
            ePopup: ePopup,
            x: x,
            y: y,
            keepWithinBounds: true
        });
        this.setPosition(parseFloat(ePopup.style.left), parseFloat(ePopup.style.top));
    };
    PositionableFeature.prototype.setPosition = function (x, y) {
        this.position.x = x;
        this.position.y = y;
    };
    PositionableFeature.prototype.updateDragStartPosition = function (x, y) {
        this.dragStartPosition = { x: x, y: y };
    };
    PositionableFeature.prototype.calculateMouseMovement = function (params) {
        var e = params.e, isLeft = params.isLeft, isTop = params.isTop, anywhereWithin = params.anywhereWithin, topBuffer = params.topBuffer;
        var xDiff = e.clientX - this.dragStartPosition.x;
        var yDiff = e.clientY - this.dragStartPosition.y;
        var movementX = this.shouldSkipX(e, !!isLeft, !!anywhereWithin, xDiff) ? 0 : xDiff;
        var movementY = this.shouldSkipY(e, !!isTop, topBuffer, yDiff) ? 0 : yDiff;
        return { movementX: movementX, movementY: movementY };
    };
    PositionableFeature.prototype.shouldSkipX = function (e, isLeft, anywhereWithin, diff) {
        var elRect = this.element.getBoundingClientRect();
        var parentRect = this.offsetParent.getBoundingClientRect();
        var boundaryElRect = this.boundaryEl.getBoundingClientRect();
        var xPosition = this.config.popup ? this.position.x : elRect.left;
        // skip if cursor is outside of popupParent horizontally
        var skipX = ((xPosition <= 0 && parentRect.left >= e.clientX) ||
            (parentRect.right <= e.clientX && parentRect.right <= boundaryElRect.right));
        if (skipX) {
            return true;
        }
        if (isLeft) {
            skipX = (
            // skip if we are moving to the left and the cursor
            // is positioned to the right of the left side anchor
            (diff < 0 && e.clientX > xPosition + parentRect.left) ||
                // skip if we are moving to the right and the cursor
                // is positioned to the left of the dialog
                (diff > 0 && e.clientX < xPosition + parentRect.left));
        }
        else {
            if (anywhereWithin) {
                // if anywhereWithin is true, we allow to move
                // as long as the cursor is within the dialog
                skipX = ((diff < 0 && e.clientX > boundaryElRect.right) ||
                    (diff > 0 && e.clientX < xPosition + parentRect.left));
            }
            else {
                skipX = (
                // if the movement is bound to the right side of the dialog
                // we skip if we are moving to the left and the cursor
                // is to the right of the dialog
                (diff < 0 && e.clientX > boundaryElRect.right) ||
                    // or skip if we are moving to the right and the cursor
                    // is to the left of the right side anchor
                    (diff > 0 && e.clientX < boundaryElRect.right));
            }
        }
        return skipX;
    };
    PositionableFeature.prototype.shouldSkipY = function (e, isTop, topBuffer, diff) {
        if (topBuffer === void 0) { topBuffer = 0; }
        var elRect = this.element.getBoundingClientRect();
        var parentRect = this.offsetParent.getBoundingClientRect();
        var boundaryElRect = this.boundaryEl.getBoundingClientRect();
        var yPosition = this.config.popup ? this.position.y : elRect.top;
        // skip if cursor is outside of popupParent vertically
        var skipY = ((yPosition <= 0 && parentRect.top >= e.clientY) ||
            (parentRect.bottom <= e.clientY && parentRect.bottom <= boundaryElRect.bottom));
        if (skipY) {
            return true;
        }
        if (isTop) {
            skipY = (
            // skip if we are moving to towards top and the cursor is
            // below the top anchor + topBuffer
            // note: topBuffer is used when moving the dialog using the title bar
            (diff < 0 && e.clientY > yPosition + parentRect.top + topBuffer) ||
                // skip if we are moving to the bottom and the cursor is
                // above the top anchor
                (diff > 0 && e.clientY < yPosition + parentRect.top));
        }
        else {
            skipY = (
            // skip if we are moving towards the top and the cursor
            // is below the bottom anchor
            (diff < 0 && e.clientY > boundaryElRect.bottom) ||
                // skip if we are moving towards the bottom and the cursor
                // is above the bottom anchor
                (diff > 0 && e.clientY < boundaryElRect.bottom));
        }
        return skipY;
    };
    PositionableFeature.prototype.createResizeMap = function () {
        var eGui = this.element;
        this.resizerMap = {
            topLeft: { element: eGui.querySelector('[ref=eTopLeftResizer]') },
            top: { element: eGui.querySelector('[ref=eTopResizer]') },
            topRight: { element: eGui.querySelector('[ref=eTopRightResizer]') },
            right: { element: eGui.querySelector('[ref=eRightResizer]') },
            bottomRight: { element: eGui.querySelector('[ref=eBottomRightResizer]') },
            bottom: { element: eGui.querySelector('[ref=eBottomResizer]') },
            bottomLeft: { element: eGui.querySelector('[ref=eBottomLeftResizer]') },
            left: { element: eGui.querySelector('[ref=eLeftResizer]') }
        };
    };
    PositionableFeature.prototype.addResizers = function () {
        if (this.resizersAdded) {
            return;
        }
        var eGui = this.element;
        if (!eGui) {
            return;
        }
        var parser = new DOMParser();
        var resizers = parser.parseFromString(RESIZE_TEMPLATE, 'text/html').body;
        eGui.appendChild(resizers.firstChild);
        this.createResizeMap();
        this.resizersAdded = true;
    };
    PositionableFeature.prototype.removeResizers = function () {
        this.resizerMap = undefined;
        var resizerEl = this.element.querySelector("." + RESIZE_CONTAINER_STYLE);
        if (resizerEl) {
            this.element.removeChild(resizerEl);
        }
        this.resizersAdded = false;
    };
    PositionableFeature.prototype.getResizerElement = function (side) {
        return this.resizerMap[side].element;
    };
    PositionableFeature.prototype.onResizeStart = function (e, side) {
        this.boundaryEl = this.findBoundaryElement();
        if (!this.positioned) {
            this.initialisePosition();
        }
        this.currentResizer = {
            isTop: !!side.match(/top/i),
            isRight: !!side.match(/right/i),
            isBottom: !!side.match(/bottom/i),
            isLeft: !!side.match(/left/i),
        };
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.element, 'ag-resizing');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.resizerMap[side].element, 'ag-active');
        var _a = this.config, popup = _a.popup, forcePopupParentAsOffsetParent = _a.forcePopupParentAsOffsetParent;
        if (!popup && !forcePopupParentAsOffsetParent) {
            this.applySizeToSiblings(this.currentResizer.isBottom || this.currentResizer.isTop);
        }
        this.isResizing = true;
        this.updateDragStartPosition(e.clientX, e.clientY);
    };
    PositionableFeature.prototype.getSiblings = function () {
        var element = this.element;
        var parent = element.parentElement;
        if (!parent) {
            return null;
        }
        return Array.prototype.slice.call(parent.children).filter(function (el) { return !Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["containsClass"])(el, 'ag-hidden'); });
    };
    PositionableFeature.prototype.getMinSizeOfSiblings = function () {
        var siblings = this.getSiblings() || [];
        var height = 0;
        var width = 0;
        for (var i = 0; i < siblings.length; i++) {
            var currentEl = siblings[i];
            var isFlex = !!currentEl.style.flex && currentEl.style.flex !== '0 0 auto';
            if (currentEl === this.element) {
                continue;
            }
            var nextHeight = this.minHeight || 0;
            var nextWidth = this.minWidth || 0;
            if (isFlex) {
                var computedStyle = window.getComputedStyle(currentEl);
                if (computedStyle.minHeight) {
                    nextHeight = parseInt(computedStyle.minHeight, 10);
                }
                if (computedStyle.minWidth) {
                    nextWidth = parseInt(computedStyle.minWidth, 10);
                }
            }
            else {
                nextHeight = currentEl.offsetHeight;
                nextWidth = currentEl.offsetWidth;
            }
            height += nextHeight;
            width += nextWidth;
        }
        return { height: height, width: width };
    };
    PositionableFeature.prototype.applySizeToSiblings = function (vertical) {
        var containerToFlex = null;
        var siblings = this.getSiblings();
        if (!siblings) {
            return;
        }
        for (var i = 0; i < siblings.length; i++) {
            var el = siblings[i];
            if (el === containerToFlex) {
                continue;
            }
            if (vertical) {
                el.style.height = el.offsetHeight + "px";
            }
            else {
                el.style.width = el.offsetWidth + "px";
            }
            el.style.flex = '0 0 auto';
            if (el === this.element) {
                containerToFlex = siblings[i + 1];
            }
        }
        if (containerToFlex) {
            containerToFlex.style.removeProperty('height');
            containerToFlex.style.removeProperty('min-height');
            containerToFlex.style.removeProperty('max-height');
            containerToFlex.style.flex = '1 1 auto';
        }
    };
    PositionableFeature.prototype.onResize = function (e) {
        if (!this.isResizing || !this.currentResizer) {
            return;
        }
        var _a = this.config, popup = _a.popup, forcePopupParentAsOffsetParent = _a.forcePopupParentAsOffsetParent;
        var _b = this.currentResizer, isTop = _b.isTop, isRight = _b.isRight, isBottom = _b.isBottom, isLeft = _b.isLeft;
        var isHorizontal = isRight || isLeft;
        var isVertical = isBottom || isTop;
        var _c = this.calculateMouseMovement({ e: e, isLeft: isLeft, isTop: isTop }), movementX = _c.movementX, movementY = _c.movementY;
        var xPosition = this.position.x;
        var yPosition = this.position.y;
        var offsetLeft = 0;
        var offsetTop = 0;
        if (isHorizontal && movementX) {
            var direction = isLeft ? -1 : 1;
            var oldWidth = this.getWidth();
            var newWidth = oldWidth + (movementX * direction);
            var skipWidth = false;
            if (isLeft) {
                offsetLeft = oldWidth - newWidth;
                if (xPosition + offsetLeft <= 0 || newWidth <= this.minWidth) {
                    skipWidth = true;
                    offsetLeft = 0;
                }
            }
            if (!skipWidth) {
                this.setWidth(newWidth);
            }
        }
        if (isVertical && movementY) {
            var direction = isTop ? -1 : 1;
            var oldHeight = this.getHeight();
            var newHeight = oldHeight + (movementY * direction);
            var skipHeight = false;
            if (isTop) {
                offsetTop = oldHeight - newHeight;
                if (yPosition + offsetTop <= 0 || newHeight <= this.minHeight) {
                    skipHeight = true;
                    offsetTop = 0;
                }
            }
            else {
                // do not let the size of all siblings be higher than the parent container
                if (!this.config.popup &&
                    !this.config.forcePopupParentAsOffsetParent &&
                    oldHeight < newHeight &&
                    (this.getMinSizeOfSiblings().height + newHeight) > this.element.parentElement.offsetHeight) {
                    skipHeight = true;
                }
            }
            if (!skipHeight) {
                this.setHeight(newHeight);
            }
        }
        this.updateDragStartPosition(e.clientX, e.clientY);
        if ((popup || forcePopupParentAsOffsetParent) && offsetLeft || offsetTop) {
            this.offsetElement(xPosition + offsetLeft, yPosition + offsetTop);
        }
    };
    PositionableFeature.prototype.onResizeEnd = function (e, side) {
        this.isResizing = false;
        this.currentResizer = null;
        this.boundaryEl = null;
        var params = {
            type: 'resize',
            api: this.gridOptionsWrapper.getApi(),
            columnApi: this.gridOptionsWrapper.getColumnApi()
        };
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["removeCssClass"])(this.element, 'ag-resizing');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["removeCssClass"])(this.resizerMap[side].element, 'ag-active');
        this.dispatchEvent(params);
    };
    PositionableFeature.prototype.refreshSize = function () {
        var eGui = this.element;
        if (this.config.popup) {
            if (!this.config.width) {
                this.setWidth(eGui.offsetWidth);
            }
            if (!this.config.height) {
                this.setHeight(eGui.offsetHeight);
            }
        }
    };
    PositionableFeature.prototype.onMoveStart = function (e) {
        this.boundaryEl = this.findBoundaryElement();
        if (!this.positioned) {
            this.initialisePosition();
        }
        this.isMoving = true;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.element, 'ag-moving');
        this.updateDragStartPosition(e.clientX, e.clientY);
    };
    PositionableFeature.prototype.onMove = function (e) {
        if (!this.isMoving) {
            return;
        }
        var _a = this.position, x = _a.x, y = _a.y;
        var topBuffer;
        if (this.config.calculateTopBuffer) {
            topBuffer = this.config.calculateTopBuffer();
        }
        var _b = this.calculateMouseMovement({
            e: e,
            isTop: true,
            anywhereWithin: true,
            topBuffer: topBuffer
        }), movementX = _b.movementX, movementY = _b.movementY;
        this.offsetElement(x + movementX, y + movementY);
        this.updateDragStartPosition(e.clientX, e.clientY);
    };
    PositionableFeature.prototype.onMoveEnd = function () {
        this.isMoving = false;
        this.boundaryEl = null;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["removeCssClass"])(this.element, 'ag-moving');
    };
    PositionableFeature.prototype.setOffsetParent = function () {
        if (this.config.forcePopupParentAsOffsetParent) {
            this.offsetParent = this.popupService.getPopupParent();
        }
        else {
            this.offsetParent = this.element.offsetParent;
        }
    };
    PositionableFeature.prototype.findBoundaryElement = function () {
        var el = this.element;
        while (el) {
            if (window.getComputedStyle(el).position !== 'static') {
                return el;
            }
            el = el.parentElement;
        }
        return this.element;
    };
    PositionableFeature.prototype.clearResizeListeners = function () {
        while (this.resizeListeners.length) {
            var params = this.resizeListeners.pop();
            this.dragService.removeDragSource(params);
        }
    };
    PositionableFeature.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        if (this.moveElementDragListener) {
            this.dragService.removeDragSource(this.moveElementDragListener);
        }
        this.clearResizeListeners();
        this.removeResizers();
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('popupService')
    ], PositionableFeature.prototype, "popupService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Autowired */ "a"])('dragService')
    ], PositionableFeature.prototype, "dragService", void 0);
    return PositionableFeature;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_0__[/* BeanStub */ "a"]));



/***/ }),

/***/ "5582":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CustomTooltipFeature; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("6352");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("a74a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var TooltipStates;
(function (TooltipStates) {
    TooltipStates[TooltipStates["NOTHING"] = 0] = "NOTHING";
    TooltipStates[TooltipStates["WAITING_TO_SHOW"] = 1] = "WAITING_TO_SHOW";
    TooltipStates[TooltipStates["SHOWING"] = 2] = "SHOWING";
})(TooltipStates || (TooltipStates = {}));
var CustomTooltipFeature = /** @class */ (function (_super) {
    __extends(CustomTooltipFeature, _super);
    function CustomTooltipFeature(parentComp) {
        var _this = _super.call(this) || this;
        _this.DEFAULT_HIDE_TOOLTIP_TIMEOUT = 10000;
        _this.SHOW_QUICK_TOOLTIP_DIFF = 1000;
        _this.FADE_OUT_TOOLTIP_TIMEOUT = 1000;
        _this.state = TooltipStates.NOTHING;
        // when showing the tooltip, we need to make sure it's the most recent instance we request, as due to
        // async we could request two tooltips before the first instance returns, in which case we should
        // disregard the second instance.
        _this.tooltipInstanceCount = 0;
        _this.tooltipMouseTrack = false;
        _this.parentComp = parentComp;
        return _this;
    }
    CustomTooltipFeature.prototype.postConstruct = function () {
        this.tooltipShowDelay = this.gridOptionsWrapper.getTooltipShowDelay() || 2000;
        this.tooltipMouseTrack = this.gridOptionsWrapper.isTooltipMouseTrack();
        var el = this.parentComp.getGui();
        this.addManagedListener(el, 'mouseenter', this.onMouseEnter.bind(this));
        this.addManagedListener(el, 'mouseleave', this.onMouseLeave.bind(this));
        this.addManagedListener(el, 'mousemove', this.onMouseMove.bind(this));
        this.addManagedListener(el, 'mousedown', this.onMouseDown.bind(this));
        this.addManagedListener(el, 'keydown', this.onKeyDown.bind(this));
    };
    CustomTooltipFeature.prototype.destroy = function () {
        // if this component gets destroyed while tooltip is showing, need to make sure
        // we don't end with no mouseLeave event resulting in zombie tooltip
        this.setToDoNothing();
        _super.prototype.destroy.call(this);
    };
    CustomTooltipFeature.prototype.onMouseEnter = function (e) {
        // every mouseenter should be following by a mouseleave, however for some unkonwn, it's possible for
        // mouseenter to be called twice in a row, which can happen if editing the cell. this was reported
        // in https://ag-grid.atlassian.net/browse/AG-4422. to get around this, we check the state, and if
        // state is !=nothing, then we know mouseenter was already received.
        if (this.state != TooltipStates.NOTHING) {
            return;
        }
        // if another tooltip was hidden very recently, we only wait 200ms to show, not the normal waiting time
        var delay = this.isLastTooltipHiddenRecently() ? 200 : this.tooltipShowDelay;
        this.showTooltipTimeoutId = window.setTimeout(this.showTooltip.bind(this), delay);
        this.lastMouseEvent = e;
        this.state = TooltipStates.WAITING_TO_SHOW;
    };
    CustomTooltipFeature.prototype.onMouseLeave = function () {
        this.setToDoNothing();
    };
    CustomTooltipFeature.prototype.onKeyDown = function () {
        this.setToDoNothing();
    };
    CustomTooltipFeature.prototype.setToDoNothing = function () {
        if (this.state === TooltipStates.SHOWING) {
            this.hideTooltip();
        }
        this.clearTimeouts();
        this.state = TooltipStates.NOTHING;
    };
    CustomTooltipFeature.prototype.onMouseMove = function (e) {
        // there is a delay from the time we mouseOver a component and the time the
        // tooltip is displayed, so we need to track mousemove to be able to correctly
        // position the tooltip when showTooltip is called.
        this.lastMouseEvent = e;
        if (this.tooltipMouseTrack &&
            this.state === TooltipStates.SHOWING &&
            this.tooltipComp) {
            this.positionTooltipUnderLastMouseEvent();
        }
    };
    CustomTooltipFeature.prototype.onMouseDown = function () {
        this.setToDoNothing();
    };
    CustomTooltipFeature.prototype.hideTooltip = function () {
        // check if comp exists - due to async, although we asked for
        // one, the instance may not be back yet
        if (this.tooltipComp) {
            this.destroyTooltipComp();
            CustomTooltipFeature.lastTooltipHideTime = new Date().getTime();
        }
        this.state = TooltipStates.NOTHING;
    };
    CustomTooltipFeature.prototype.destroyTooltipComp = function () {
        var _this = this;
        // add class to fade out the tooltip
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.tooltipComp.getGui(), 'ag-tooltip-hiding');
        // make local copies of these variables, as we use them in the async function below,
        // and we clear then to 'undefined' later, so need to take a copy before they are undefined.
        var tooltipPopupDestroyFunc = this.tooltipPopupDestroyFunc;
        var tooltipComp = this.tooltipComp;
        window.setTimeout(function () {
            tooltipPopupDestroyFunc();
            _this.getContext().destroyBean(tooltipComp);
        }, this.FADE_OUT_TOOLTIP_TIMEOUT);
        this.tooltipPopupDestroyFunc = undefined;
        this.tooltipComp = undefined;
    };
    CustomTooltipFeature.prototype.isLastTooltipHiddenRecently = function () {
        // return true if <1000ms since last time we hid a tooltip
        var now = new Date().getTime();
        var then = CustomTooltipFeature.lastTooltipHideTime;
        return (now - then) < this.SHOW_QUICK_TOOLTIP_DIFF;
    };
    CustomTooltipFeature.prototype.showTooltip = function () {
        var params = __assign({ api: this.gridApi, columnApi: this.columnApi, context: this.gridOptionsWrapper.getContext() }, this.parentComp.getTooltipParams());
        if (!Object(_utils_generic__WEBPACK_IMPORTED_MODULE_3__["exists"])(params.value)) {
            this.setToDoNothing();
            return;
        }
        this.state = TooltipStates.SHOWING;
        this.tooltipInstanceCount++;
        // we pass in tooltipInstanceCount so the callback knows what the count was when
        // we requested the tooltip, so if another tooltip was requested in the mean time
        // we disregard it
        var callback = this.newTooltipComponentCallback.bind(this, this.tooltipInstanceCount);
        this.userComponentFactory.newTooltipComponent(params).then(callback);
    };
    CustomTooltipFeature.prototype.newTooltipComponentCallback = function (tooltipInstanceCopy, tooltipComp) {
        var compNoLongerNeeded = this.state !== TooltipStates.SHOWING || this.tooltipInstanceCount !== tooltipInstanceCopy;
        if (compNoLongerNeeded) {
            this.getContext().destroyBean(tooltipComp);
            return;
        }
        var eGui = tooltipComp.getGui();
        this.tooltipComp = tooltipComp;
        if (!Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["containsClass"])(eGui, 'ag-tooltip')) {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(eGui, 'ag-tooltip-custom');
        }
        var translate = this.gridOptionsWrapper.getLocaleTextFunc();
        var addPopupRes = this.popupService.addPopup({
            eChild: eGui,
            ariaLabel: translate('ariaLabelTooltip', 'Tooltip')
        });
        if (addPopupRes) {
            this.tooltipPopupDestroyFunc = addPopupRes.hideFunc;
        }
        // this.tooltipPopupDestroyFunc = this.popupService.addPopup(false, eGui, false);
        this.positionTooltipUnderLastMouseEvent();
        this.hideTooltipTimeoutId = window.setTimeout(this.hideTooltip.bind(this), this.DEFAULT_HIDE_TOOLTIP_TIMEOUT);
    };
    CustomTooltipFeature.prototype.positionTooltipUnderLastMouseEvent = function () {
        this.popupService.positionPopupUnderMouseEvent({
            type: 'tooltip',
            mouseEvent: this.lastMouseEvent,
            ePopup: this.tooltipComp.getGui(),
            nudgeY: 18
        });
    };
    CustomTooltipFeature.prototype.clearTimeouts = function () {
        if (this.showTooltipTimeoutId) {
            window.clearTimeout(this.showTooltipTimeoutId);
            this.showTooltipTimeoutId = undefined;
        }
        if (this.hideTooltipTimeoutId) {
            window.clearTimeout(this.hideTooltipTimeoutId);
            this.hideTooltipTimeoutId = undefined;
        }
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('popupService')
    ], CustomTooltipFeature.prototype, "popupService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('userComponentFactory')
    ], CustomTooltipFeature.prototype, "userComponentFactory", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('columnApi')
    ], CustomTooltipFeature.prototype, "columnApi", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Autowired */ "a"])('gridApi')
    ], CustomTooltipFeature.prototype, "gridApi", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_0__[/* PostConstruct */ "e"]
    ], CustomTooltipFeature.prototype, "postConstruct", null);
    return CustomTooltipFeature;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "562d":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "iterateObject", function() { return iterateObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cloneObject", function() { return cloneObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deepCloneObject", function() { return deepCloneObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deepCloneDefinition", function() { return deepCloneDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getProperty", function() { return getProperty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setProperty", function() { return setProperty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyPropertiesIfPresent", function() { return copyPropertiesIfPresent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyPropertyIfPresent", function() { return copyPropertyIfPresent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAllKeysInObjects", function() { return getAllKeysInObjects; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAllValuesInObject", function() { return getAllValuesInObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mergeDeep", function() { return mergeDeep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return assign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "missingOrEmptyObject", function() { return missingOrEmptyObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "get", function() { return get; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "set", function() { return set; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deepFreeze", function() { return deepFreeze; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getValueUsingField", function() { return getValueUsingField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeAllReferences", function() { return removeAllReferences; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNonNullObject", function() { return isNonNullObject; });
/* harmony import */ var _generic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("a74a");
/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("348a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */


function iterateObject(object, callback) {
    if (object == null) {
        return;
    }
    if (Array.isArray(object)) {
        Object(_array__WEBPACK_IMPORTED_MODULE_1__["forEach"])(object, function (value, index) { return callback("" + index, value); });
    }
    else {
        Object(_array__WEBPACK_IMPORTED_MODULE_1__["forEach"])(Object.keys(object), function (key) { return callback(key, object[key]); });
    }
}
function cloneObject(object) {
    var copy = {};
    var keys = Object.keys(object);
    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var value = object[key];
        copy[key] = value;
    }
    return copy;
}
function deepCloneObject(object) {
    return JSON.parse(JSON.stringify(object));
}
// returns copy of an object, doing a deep clone of any objects with that object.
// this is used for eg creating copies of Column Definitions, where we want to
// deep copy all objects, but do not want to deep copy functions (eg when user provides
// a function or class for colDef.cellRenderer)
function deepCloneDefinition(object, keysToSkip) {
    if (!object) {
        return;
    }
    var obj = object;
    var res = {};
    Object.keys(obj).forEach(function (key) {
        if (keysToSkip && keysToSkip.indexOf(key) >= 0) {
            return;
        }
        var value = obj[key];
        // 'simple object' means a bunch of key/value pairs, eg {filter: 'myFilter'}. it does
        // NOT include the following:
        // 1) arrays
        // 2) functions or classes (eg ColumnAPI instance)
        var sourceIsSimpleObject = isNonNullObject(value) && value.constructor === Object;
        if (sourceIsSimpleObject) {
            res[key] = deepCloneDefinition(value);
        }
        else {
            res[key] = value;
        }
    });
    return res;
}
function getProperty(object, key) {
    return object[key];
}
function setProperty(object, key, value) {
    object[key] = value;
}
/**
 * Will copy the specified properties from `source` into the equivalent properties on `target`, ignoring properties with
 * a value of `undefined`.
 */
function copyPropertiesIfPresent(source, target) {
    var properties = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        properties[_i - 2] = arguments[_i];
    }
    Object(_array__WEBPACK_IMPORTED_MODULE_1__["forEach"])(properties, function (p) { return copyPropertyIfPresent(source, target, p); });
}
/**
 * Will copy the specified property from `source` into the equivalent property on `target`, unless the property has a
 * value of `undefined`. If a transformation is provided, it will be applied to the value before being set on `target`.
 */
function copyPropertyIfPresent(source, target, property, transform) {
    var value = getProperty(source, property);
    if (value !== undefined) {
        setProperty(target, property, transform ? transform(value) : value);
    }
}
function getAllKeysInObjects(objects) {
    var allValues = {};
    objects.filter(function (obj) { return obj != null; }).forEach(function (obj) {
        Object(_array__WEBPACK_IMPORTED_MODULE_1__["forEach"])(Object.keys(obj), function (key) { return allValues[key] = null; });
    });
    return Object.keys(allValues);
}
function getAllValuesInObject(obj) {
    if (!obj) {
        return [];
    }
    var anyObject = Object;
    if (typeof anyObject.values === 'function') {
        return anyObject.values(obj);
    }
    var ret = [];
    for (var key in obj) {
        if (obj.hasOwnProperty(key) && obj.propertyIsEnumerable(key)) {
            ret.push(obj[key]);
        }
    }
    return ret;
}
function mergeDeep(dest, source, copyUndefined, makeCopyOfSimpleObjects) {
    if (copyUndefined === void 0) { copyUndefined = true; }
    if (makeCopyOfSimpleObjects === void 0) { makeCopyOfSimpleObjects = false; }
    if (!Object(_generic__WEBPACK_IMPORTED_MODULE_0__["exists"])(source)) {
        return;
    }
    iterateObject(source, function (key, sourceValue) {
        var destValue = dest[key];
        if (destValue === sourceValue) {
            return;
        }
        // when creating params, we don't want to just copy objects over. otherwise merging ColDefs (eg DefaultColDef
        // and Column Types) would result in params getting shared between objects.
        // by putting an empty value into destValue first, it means we end up copying over values from
        // the source object, rather than just copying in the source object in it's entirety.
        if (makeCopyOfSimpleObjects) {
            var objectIsDueToBeCopied = destValue == null && sourceValue != null;
            if (objectIsDueToBeCopied) {
                // 'simple object' means a bunch of key/value pairs, eg {filter: 'myFilter'}, as opposed
                // to a Class instance (such as ColumnAPI instance).
                var sourceIsSimpleObject = typeof sourceValue === 'object' && sourceValue.constructor === Object;
                var dontCopy = sourceIsSimpleObject;
                if (dontCopy) {
                    destValue = {};
                    dest[key] = destValue;
                }
            }
        }
        if (isNonNullObject(sourceValue) && isNonNullObject(destValue) && !Array.isArray(destValue)) {
            mergeDeep(destValue, sourceValue, copyUndefined, makeCopyOfSimpleObjects);
        }
        else if (copyUndefined || sourceValue !== undefined) {
            dest[key] = sourceValue;
        }
    });
}
function assign(object) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    Object(_array__WEBPACK_IMPORTED_MODULE_1__["forEach"])(sources, function (source) { return iterateObject(source, function (key, value) { return object[key] = value; }); });
    return object;
}
function missingOrEmptyObject(value) {
    return Object(_generic__WEBPACK_IMPORTED_MODULE_0__["missing"])(value) || Object.keys(value).length === 0;
}
function get(source, expression, defaultValue) {
    if (source == null) {
        return defaultValue;
    }
    var keys = expression.split('.');
    var objectToRead = source;
    while (keys.length > 1) {
        objectToRead = objectToRead[keys.shift()];
        if (objectToRead == null) {
            return defaultValue;
        }
    }
    var value = objectToRead[keys[0]];
    return value != null ? value : defaultValue;
}
function set(target, expression, value) {
    if (target == null) {
        return;
    }
    var keys = expression.split('.');
    var objectToUpdate = target;
    while (keys.length > 1) {
        objectToUpdate = objectToUpdate[keys.shift()];
        if (objectToUpdate == null) {
            return;
        }
    }
    objectToUpdate[keys[0]] = value;
}
function deepFreeze(object) {
    Object.freeze(object);
    Object(_array__WEBPACK_IMPORTED_MODULE_1__["forEach"])(Object(_generic__WEBPACK_IMPORTED_MODULE_0__["values"])(object), function (v) {
        if (isNonNullObject(v) || typeof v === 'function') {
            deepFreeze(v);
        }
    });
    return object;
}
function getValueUsingField(data, field, fieldContainsDots) {
    if (!field || !data) {
        return;
    }
    // if no '.', then it's not a deep value
    if (!fieldContainsDots) {
        return data[field];
    }
    // otherwise it is a deep value, so need to dig for it
    var fields = field.split('.');
    var currentObject = data;
    for (var i = 0; i < fields.length; i++) {
        if (currentObject == null) {
            return undefined;
        }
        currentObject = currentObject[fields[i]];
    }
    return currentObject;
}
// used by ColumnAPI and GridAPI to remove all references, so keeping grid in memory resulting in a
// memory leak if user is not disposing of the GridAPI or ColumnApi references
function removeAllReferences(obj, objectName) {
    Object.keys(obj).forEach(function (key) {
        var value = obj[key];
        // we want to replace all the @autowired services, which are objects. any simple types (boolean, string etc)
        // we don't care about
        if (typeof value === 'object') {
            obj[key] = undefined;
        }
    });
    var proto = Object.getPrototypeOf(obj);
    var properties = {};
    Object.keys(proto).forEach(function (key) {
        var value = proto[key];
        // leave all basic types - this is needed for GridAPI to leave the "destroyed: boolean" attribute alone
        if (typeof value === 'function') {
            var func = function () {
                console.warn("AG Grid: " + objectName + " function " + key + "() cannot be called as the grid has been destroyed.\n                     Please don't call grid API functions on destroyed grids - as a matter of fact you shouldn't\n                     be keeping the API reference, your application has a memory leak! Remove the API reference\n                     when the grid is destroyed.");
            };
            properties[key] = { value: func, writable: true };
        }
    });
    Object.defineProperties(obj, properties);
}
function isNonNullObject(value) {
    return typeof value === 'object' && value !== null;
}


/***/ }),

/***/ "5692":
/***/ (function(module, exports, __webpack_require__) {

var IS_PURE = __webpack_require__("c430");
var store = __webpack_require__("c6cd");

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.18.3',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2021 Denis Pushkarev (zloirock.ru)'
});


/***/ }),

/***/ "56a3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ agSelect_AgSelect; });

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agAbstractField.js
var agAbstractField = __webpack_require__("1d31");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agPickerField.js
var agPickerField = __webpack_require__("d53d");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/component.js
var component = __webpack_require__("9cc8");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/context/context.js
var context = __webpack_require__("dc3a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/string.js
var string = __webpack_require__("0e94");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/dom.js
var dom = __webpack_require__("6352");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/array.js
var array = __webpack_require__("348a");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/constants/keyCode.js
var keyCode = __webpack_require__("7a66");

// EXTERNAL MODULE: ./node_modules/@ag-grid-community/core/dist/es6/utils/aria.js
var aria = __webpack_require__("3348");

// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agList.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};








var agList_AgList = /** @class */ (function (_super) {
    __extends(AgList, _super);
    function AgList(cssIdentifier) {
        if (cssIdentifier === void 0) { cssIdentifier = 'default'; }
        var _this = _super.call(this, /* html */ "<div class=\"ag-list ag-" + cssIdentifier + "-list\" role=\"listbox\"></div>") || this;
        _this.cssIdentifier = cssIdentifier;
        _this.options = [];
        _this.itemEls = [];
        return _this;
    }
    AgList.prototype.init = function () {
        this.addManagedListener(this.getGui(), 'keydown', this.handleKeyDown.bind(this));
    };
    AgList.prototype.handleKeyDown = function (e) {
        var key = e.keyCode;
        switch (key) {
            case keyCode["a" /* KeyCode */].ENTER:
                if (!this.highlightedEl) {
                    this.setValue(this.getValue());
                }
                else {
                    var pos = this.itemEls.indexOf(this.highlightedEl);
                    this.setValueByIndex(pos);
                }
                break;
            case keyCode["a" /* KeyCode */].DOWN:
            case keyCode["a" /* KeyCode */].UP:
                var isDown = key === keyCode["a" /* KeyCode */].DOWN;
                var itemToHighlight = void 0;
                e.preventDefault();
                if (!this.highlightedEl) {
                    itemToHighlight = this.itemEls[isDown ? 0 : this.itemEls.length - 1];
                }
                else {
                    var currentIdx = this.itemEls.indexOf(this.highlightedEl);
                    var nextPos = currentIdx + (isDown ? 1 : -1);
                    nextPos = Math.min(Math.max(nextPos, 0), this.itemEls.length - 1);
                    itemToHighlight = this.itemEls[nextPos];
                }
                this.highlightItem(itemToHighlight);
                break;
        }
    };
    AgList.prototype.addOptions = function (listOptions) {
        var _this = this;
        listOptions.forEach(function (listOption) { return _this.addOption(listOption); });
        return this;
    };
    AgList.prototype.addOption = function (listOption) {
        var value = listOption.value, text = listOption.text;
        var sanitisedText = Object(string["escapeString"])(text || value);
        this.options.push({ value: value, text: sanitisedText });
        this.renderOption(value, sanitisedText);
        return this;
    };
    AgList.prototype.renderOption = function (value, text) {
        var _this = this;
        var itemEl = document.createElement('div');
        Object(aria["setAriaRole"])(itemEl, 'option');
        Object(dom["addCssClass"])(itemEl, 'ag-list-item');
        Object(dom["addCssClass"])(itemEl, "ag-" + this.cssIdentifier + "-list-item");
        itemEl.innerHTML = "<span>" + text + "</span>";
        itemEl.tabIndex = -1;
        this.itemEls.push(itemEl);
        this.addManagedListener(itemEl, 'mouseover', function () { return _this.highlightItem(itemEl); });
        this.addManagedListener(itemEl, 'mouseleave', function () { return _this.clearHighlighted(); });
        this.addManagedListener(itemEl, 'click', function () { return _this.setValue(value); });
        this.getGui().appendChild(itemEl);
    };
    AgList.prototype.setValue = function (value, silent) {
        if (this.value === value) {
            this.fireItemSelected();
            return this;
        }
        if (value == null) {
            this.reset();
            return this;
        }
        var idx = Object(array["findIndex"])(this.options, function (option) { return option.value === value; });
        if (idx !== -1) {
            var option = this.options[idx];
            this.value = option.value;
            this.displayValue = option.text != null ? option.text : option.value;
            this.highlightItem(this.itemEls[idx]);
            if (!silent) {
                this.fireChangeEvent();
            }
        }
        return this;
    };
    AgList.prototype.setValueByIndex = function (idx) {
        return this.setValue(this.options[idx].value);
    };
    AgList.prototype.getValue = function () {
        return this.value;
    };
    AgList.prototype.getDisplayValue = function () {
        return this.displayValue;
    };
    AgList.prototype.refreshHighlighted = function () {
        var _this = this;
        this.clearHighlighted();
        var idx = Object(array["findIndex"])(this.options, function (option) { return option.value === _this.value; });
        if (idx !== -1) {
            this.highlightItem(this.itemEls[idx]);
        }
    };
    AgList.prototype.reset = function () {
        this.value = null;
        this.displayValue = null;
        this.clearHighlighted();
        this.fireChangeEvent();
    };
    AgList.prototype.highlightItem = function (el) {
        if (!el.offsetParent) {
            return;
        }
        this.clearHighlighted();
        this.highlightedEl = el;
        Object(dom["addCssClass"])(this.highlightedEl, AgList.ACTIVE_CLASS);
        Object(aria["setAriaSelected"])(this.highlightedEl, true);
        this.highlightedEl.focus();
    };
    AgList.prototype.clearHighlighted = function () {
        if (!this.highlightedEl || !this.highlightedEl.offsetParent) {
            return;
        }
        Object(dom["removeCssClass"])(this.highlightedEl, AgList.ACTIVE_CLASS);
        Object(aria["setAriaSelected"])(this.highlightedEl, false);
        this.highlightedEl = null;
    };
    AgList.prototype.fireChangeEvent = function () {
        this.dispatchEvent({ type: agAbstractField["a" /* AgAbstractField */].EVENT_CHANGED });
        this.fireItemSelected();
    };
    AgList.prototype.fireItemSelected = function () {
        this.dispatchEvent({ type: AgList.EVENT_ITEM_SELECTED });
    };
    AgList.EVENT_ITEM_SELECTED = 'selectedItem';
    AgList.ACTIVE_CLASS = 'ag-active-item';
    __decorate([
        context["e" /* PostConstruct */]
    ], AgList.prototype, "init", null);
    return AgList;
}(component["a" /* Component */]));


// CONCATENATED MODULE: ./node_modules/@ag-grid-community/core/dist/es6/widgets/agSelect.js
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var agSelect_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var agSelect_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var agSelect_AgSelect = /** @class */ (function (_super) {
    agSelect_extends(AgSelect, _super);
    function AgSelect(config) {
        return _super.call(this, config, 'ag-select', 'smallDown', 'listbox') || this;
    }
    AgSelect.prototype.init = function () {
        var _this = this;
        this.listComponent = this.createBean(new agList_AgList('select'));
        this.listComponent.setParentComponent(this);
        this.eWrapper.tabIndex = 0;
        this.listComponent.addManagedListener(this.listComponent, agList_AgList.EVENT_ITEM_SELECTED, function () { if (_this.hideList) {
            _this.hideList();
        } });
        this.listComponent.addManagedListener(this.listComponent, agAbstractField["a" /* AgAbstractField */].EVENT_CHANGED, function () {
            _this.setValue(_this.listComponent.getValue(), false, true);
            if (_this.hideList) {
                _this.hideList();
            }
        });
    };
    AgSelect.prototype.showPicker = function () {
        var _this = this;
        var listGui = this.listComponent.getGui();
        var destroyMouseWheelFunc = this.addManagedListener(document.body, 'wheel', function (e) {
            if (!listGui.contains(e.target) && _this.hideList) {
                _this.hideList();
            }
        });
        var destroyFocusOutFunc = this.addManagedListener(listGui, 'focusout', function (e) {
            if (!listGui.contains(e.relatedTarget) && _this.hideList) {
                _this.hideList();
            }
        });
        var translate = this.gridOptionsWrapper.getLocaleTextFunc();
        var addPopupRes = this.popupService.addPopup({
            modal: true,
            eChild: listGui,
            closeOnEsc: true,
            closedCallback: function () {
                _this.hideList = null;
                _this.isPickerDisplayed = false;
                destroyFocusOutFunc();
                destroyMouseWheelFunc();
                if (_this.isAlive()) {
                    _this.getFocusableElement().focus();
                }
            },
            ariaLabel: translate('ariaLabelSelectField', 'Select Field')
        });
        if (addPopupRes) {
            this.hideList = addPopupRes.hideFunc;
        }
        this.isPickerDisplayed = true;
        Object(dom["setElementWidth"])(listGui, Object(dom["getAbsoluteWidth"])(this.eWrapper));
        listGui.style.maxHeight = Object(dom["getInnerHeight"])(this.popupService.getPopupParent()) + 'px';
        listGui.style.position = 'absolute';
        this.popupService.positionPopupUnderComponent({
            type: 'ag-list',
            eventSource: this.eWrapper,
            ePopup: listGui,
            keepWithinBounds: true
        });
        this.listComponent.refreshHighlighted();
        return this.listComponent;
    };
    AgSelect.prototype.addOptions = function (options) {
        var _this = this;
        options.forEach(function (option) { return _this.addOption(option); });
        return this;
    };
    AgSelect.prototype.addOption = function (option) {
        this.listComponent.addOption(option);
        return this;
    };
    AgSelect.prototype.setValue = function (value, silent, fromPicker) {
        if (this.value === value) {
            return this;
        }
        if (!fromPicker) {
            this.listComponent.setValue(value, true);
        }
        var newValue = this.listComponent.getValue();
        if (newValue === this.getValue()) {
            return this;
        }
        this.eDisplayField.innerHTML = this.listComponent.getDisplayValue();
        return _super.prototype.setValue.call(this, value, silent);
    };
    AgSelect.prototype.destroy = function () {
        if (this.hideList) {
            this.hideList();
        }
        this.destroyBean(this.listComponent);
        _super.prototype.destroy.call(this);
    };
    agSelect_decorate([
        Object(context["a" /* Autowired */])('popupService')
    ], AgSelect.prototype, "popupService", void 0);
    agSelect_decorate([
        context["e" /* PostConstruct */]
    ], AgSelect.prototype, "init", null);
    return AgSelect;
}(agPickerField["a" /* AgPickerField */]));



/***/ }),

/***/ "56ef":
/***/ (function(module, exports, __webpack_require__) {

var getBuiltIn = __webpack_require__("d066");
var getOwnPropertyNamesModule = __webpack_require__("241c");
var getOwnPropertySymbolsModule = __webpack_require__("7418");
var anObject = __webpack_require__("825a");

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ "571b":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RowNodeBlockLoader; });
/* harmony import */ var _rowNodeBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("6fcc");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("bc71");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("7347");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (undefined && undefined.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};




var RowNodeBlockLoader = /** @class */ (function (_super) {
    __extends(RowNodeBlockLoader, _super);
    function RowNodeBlockLoader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.activeBlockLoadsCount = 0;
        _this.blocks = [];
        _this.active = true;
        return _this;
    }
    RowNodeBlockLoader_1 = RowNodeBlockLoader;
    RowNodeBlockLoader.prototype.postConstruct = function () {
        this.maxConcurrentRequests = this.gridOptionsWrapper.getMaxConcurrentDatasourceRequests();
        var blockLoadDebounceMillis = this.gridOptionsWrapper.getBlockLoadDebounceMillis();
        if (blockLoadDebounceMillis && blockLoadDebounceMillis > 0) {
            this.checkBlockToLoadDebounce = _utils__WEBPACK_IMPORTED_MODULE_3__[/* _ */ "d"].debounce(this.performCheckBlocksToLoad.bind(this), blockLoadDebounceMillis);
        }
    };
    RowNodeBlockLoader.prototype.setBeans = function (loggerFactory) {
        this.logger = loggerFactory.create('RowNodeBlockLoader');
    };
    RowNodeBlockLoader.prototype.addBlock = function (block) {
        this.blocks.push(block);
        // note that we do not remove this listener when removing the block. this is because the
        // cache can get destroyed (and containing blocks) when a block is loading. however the loading block
        // is still counted as an active loading block and we must decrement activeBlockLoadsCount when it finishes.
        block.addEventListener(_rowNodeBlock__WEBPACK_IMPORTED_MODULE_0__[/* RowNodeBlock */ "a"].EVENT_LOAD_COMPLETE, this.loadComplete.bind(this));
        this.checkBlockToLoad();
    };
    RowNodeBlockLoader.prototype.removeBlock = function (block) {
        _utils__WEBPACK_IMPORTED_MODULE_3__[/* _ */ "d"].removeFromArray(this.blocks, block);
    };
    RowNodeBlockLoader.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.active = false;
    };
    RowNodeBlockLoader.prototype.loadComplete = function () {
        this.activeBlockLoadsCount--;
        this.checkBlockToLoad();
        if (this.activeBlockLoadsCount == 0) {
            this.dispatchEvent({ type: RowNodeBlockLoader_1.BLOCK_LOADER_FINISHED_EVENT });
        }
    };
    RowNodeBlockLoader.prototype.checkBlockToLoad = function () {
        if (this.checkBlockToLoadDebounce) {
            this.checkBlockToLoadDebounce();
        }
        else {
            this.performCheckBlocksToLoad();
        }
    };
    RowNodeBlockLoader.prototype.performCheckBlocksToLoad = function () {
        if (!this.active) {
            return;
        }
        this.printCacheStatus();
        if (this.maxConcurrentRequests != null && this.activeBlockLoadsCount >= this.maxConcurrentRequests) {
            this.logger.log("checkBlockToLoad: max loads exceeded");
            return;
        }
        var blockToLoad = null;
        this.blocks.forEach(function (block) {
            if (block.getState() === _rowNodeBlock__WEBPACK_IMPORTED_MODULE_0__[/* RowNodeBlock */ "a"].STATE_WAITING_TO_LOAD) {
                blockToLoad = block;
            }
        });
        if (blockToLoad) {
            blockToLoad.load();
            this.activeBlockLoadsCount++;
            this.printCacheStatus();
        }
    };
    RowNodeBlockLoader.prototype.getBlockState = function () {
        var result = {};
        this.blocks.forEach(function (block) {
            var _a = block.getBlockStateJson(), id = _a.id, state = _a.state;
            result[id] = state;
        });
        return result;
    };
    RowNodeBlockLoader.prototype.printCacheStatus = function () {
        if (this.logger.isLogging()) {
            this.logger.log("printCacheStatus: activePageLoadsCount = " + this.activeBlockLoadsCount + ","
                + (" blocks = " + JSON.stringify(this.getBlockState())));
        }
    };
    RowNodeBlockLoader.prototype.isLoading = function () {
        return this.activeBlockLoadsCount > 0;
    };
    var RowNodeBlockLoader_1;
    RowNodeBlockLoader.BLOCK_LOADER_FINISHED_EVENT = 'blockLoaderFinished';
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], RowNodeBlockLoader.prototype, "postConstruct", null);
    __decorate([
        __param(0, Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Qualifier */ "h"])('loggerFactory'))
    ], RowNodeBlockLoader.prototype, "setBeans", null);
    RowNodeBlockLoader = RowNodeBlockLoader_1 = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_1__[/* Bean */ "b"])('rowNodeBlockLoader')
    ], RowNodeBlockLoader);
    return RowNodeBlockLoader;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_2__[/* BeanStub */ "a"]));



/***/ }),

/***/ "5926":
/***/ (function(module, exports) {

var ceil = Math.ceil;
var floor = Math.floor;

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
module.exports = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- safe
  return number !== number || number === 0 ? 0 : (number > 0 ? floor : ceil)(number);
};


/***/ }),

/***/ "59ec":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Constants; });
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var Constants = /** @class */ (function () {
    function Constants() {
    }
    Constants.ROW_BUFFER_SIZE = 10;
    Constants.LAYOUT_INTERVAL = 500;
    Constants.BATCH_WAIT_MILLIS = 50;
    Constants.EXPORT_TYPE_DRAG_COPY = 'dragCopy';
    Constants.EXPORT_TYPE_CLIPBOARD = 'clipboard';
    Constants.EXPORT_TYPE_EXCEL = 'excel';
    Constants.EXPORT_TYPE_CSV = 'csv';
    Constants.ROW_MODEL_TYPE_INFINITE = 'infinite';
    Constants.ROW_MODEL_TYPE_VIEWPORT = 'viewport';
    Constants.ROW_MODEL_TYPE_CLIENT_SIDE = 'clientSide';
    Constants.ROW_MODEL_TYPE_SERVER_SIDE = 'serverSide';
    Constants.ALWAYS = 'always';
    Constants.ONLY_WHEN_GROUPING = 'onlyWhenGrouping';
    Constants.PINNED_TOP = 'top';
    Constants.PINNED_BOTTOM = 'bottom';
    Constants.DOM_LAYOUT_NORMAL = 'normal';
    Constants.DOM_LAYOUT_PRINT = 'print';
    Constants.DOM_LAYOUT_AUTO_HEIGHT = 'autoHeight';
    Constants.GROUP_AUTO_COLUMN_ID = 'ag-Grid-AutoColumn';
    Constants.SOURCE_PASTE = 'paste';
    Constants.PINNED_RIGHT = 'right';
    Constants.PINNED_LEFT = 'left';
    Constants.SORT_ASC = 'asc';
    Constants.SORT_DESC = 'desc';
    Constants.INPUT_SELECTOR = 'input, select, button, textarea';
    Constants.FOCUSABLE_SELECTOR = '[tabindex], input, select, button, textarea';
    Constants.FOCUSABLE_EXCLUDE = '.ag-hidden, .ag-hidden *, [disabled], .ag-disabled, .ag-disabled *';
    return Constants;
}());



/***/ }),

/***/ "59ed":
/***/ (function(module, exports, __webpack_require__) {

var isCallable = __webpack_require__("1626");
var tryToString = __webpack_require__("0d51");

// `Assert: IsCallable(argument) is true`
module.exports = function (argument) {
  if (isCallable(argument)) return argument;
  throw TypeError(tryToString(argument) + ' is not a function');
};


/***/ }),

/***/ "5b49":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CellPositionUtils; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var CellPositionUtils = /** @class */ (function (_super) {
    __extends(CellPositionUtils, _super);
    function CellPositionUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CellPositionUtils.prototype.createId = function (cellPosition) {
        var rowIndex = cellPosition.rowIndex, rowPinned = cellPosition.rowPinned, column = cellPosition.column;
        return this.createIdFromValues(rowIndex, column, rowPinned);
    };
    CellPositionUtils.prototype.createIdFromValues = function (rowIndex, column, rowPinned) {
        return rowIndex + "." + (rowPinned == null ? 'null' : rowPinned) + "." + column.getId();
    };
    CellPositionUtils.prototype.equals = function (cellA, cellB) {
        var colsMatch = cellA.column === cellB.column;
        var floatingMatch = cellA.rowPinned === cellB.rowPinned;
        var indexMatch = cellA.rowIndex === cellB.rowIndex;
        return colsMatch && floatingMatch && indexMatch;
    };
    CellPositionUtils = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('cellPositionUtils')
    ], CellPositionUtils);
    return CellPositionUtils;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "5bd9":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return OptionsFactory; });
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("348a");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */

/* Common logic for options, used by both filters and floating filters. */
var OptionsFactory = /** @class */ (function () {
    function OptionsFactory() {
        this.customFilterOptions = {};
    }
    OptionsFactory.prototype.init = function (params, defaultOptions) {
        this.filterOptions = params.filterOptions || defaultOptions;
        this.mapCustomOptions();
        this.selectDefaultItem(params);
    };
    OptionsFactory.prototype.getFilterOptions = function () {
        return this.filterOptions;
    };
    OptionsFactory.prototype.mapCustomOptions = function () {
        var _this = this;
        if (!this.filterOptions) {
            return;
        }
        this.filterOptions.forEach(function (filterOption) {
            if (typeof filterOption === 'string') {
                return;
            }
            var requiredProperties = ['displayKey', 'displayName', 'test'];
            if (Object(_utils_array__WEBPACK_IMPORTED_MODULE_0__["every"])(requiredProperties, function (key) {
                if (!filterOption[key]) {
                    console.warn("AG Grid: ignoring FilterOptionDef as it doesn't contain a '" + key + "'");
                    return false;
                }
                return true;
            })) {
                _this.customFilterOptions[filterOption.displayKey] = filterOption;
            }
        });
    };
    OptionsFactory.prototype.selectDefaultItem = function (params) {
        if (params.defaultOption) {
            this.defaultOption = params.defaultOption;
        }
        else if (this.filterOptions.length >= 1) {
            var firstFilterOption = this.filterOptions[0];
            if (typeof firstFilterOption === 'string') {
                this.defaultOption = firstFilterOption;
            }
            else if (firstFilterOption.displayKey) {
                this.defaultOption = firstFilterOption.displayKey;
            }
            else {
                console.warn("AG Grid: invalid FilterOptionDef supplied as it doesn't contain a 'displayKey'");
            }
        }
        else {
            console.warn('AG Grid: no filter options for filter');
        }
    };
    OptionsFactory.prototype.getDefaultOption = function () {
        return this.defaultOption;
    };
    OptionsFactory.prototype.getCustomOption = function (name) {
        return this.customFilterOptions[name];
    };
    return OptionsFactory;
}());



/***/ }),

/***/ "5c04":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgInputNumberField; });
/* harmony import */ var _agInputTextField__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("baad");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("6352");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var AgInputNumberField = /** @class */ (function (_super) {
    __extends(AgInputNumberField, _super);
    function AgInputNumberField(config) {
        return _super.call(this, config, 'ag-number-field', 'number') || this;
    }
    AgInputNumberField.prototype.postConstruct = function () {
        var _this = this;
        _super.prototype.postConstruct.call(this);
        this.addManagedListener(this.eInput, 'blur', function () {
            var floatedValue = parseFloat(_this.eInput.value);
            var value = isNaN(floatedValue) ? '' : _this.normalizeValue(floatedValue.toString());
            if (_this.value !== value) {
                _this.setValue(value);
            }
        });
    };
    AgInputNumberField.prototype.normalizeValue = function (value) {
        if (value === '') {
            return '';
        }
        if (this.precision) {
            value = this.adjustPrecision(value);
        }
        var val = parseFloat(value);
        if (this.min != null && val < this.min) {
            value = this.min.toString();
        }
        else if (this.max != null && val > this.max) {
            value = this.max.toString();
        }
        return value;
    };
    AgInputNumberField.prototype.adjustPrecision = function (value) {
        if (this.precision) {
            var floatString = parseFloat(value).toFixed(this.precision);
            value = parseFloat(floatString).toString();
        }
        return value;
    };
    AgInputNumberField.prototype.setMin = function (min) {
        if (this.min === min) {
            return this;
        }
        this.min = min;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["addOrRemoveAttribute"])(this.eInput, 'min', min);
        return this;
    };
    AgInputNumberField.prototype.setMax = function (max) {
        if (this.max === max) {
            return this;
        }
        this.max = max;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["addOrRemoveAttribute"])(this.eInput, 'max', max);
        return this;
    };
    AgInputNumberField.prototype.setPrecision = function (precision) {
        this.precision = precision;
        return this;
    };
    AgInputNumberField.prototype.setStep = function (step) {
        if (this.step === step) {
            return this;
        }
        this.step = step;
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_1__["addOrRemoveAttribute"])(this.eInput, 'step', step);
        return this;
    };
    AgInputNumberField.prototype.setValue = function (value, silent) {
        value = this.adjustPrecision(value);
        var normalizedValue = this.normalizeValue(value);
        if (value != normalizedValue) {
            return this;
        }
        return _super.prototype.setValue.call(this, value, silent);
    };
    return AgInputNumberField;
}(_agInputTextField__WEBPACK_IMPORTED_MODULE_0__[/* AgInputTextField */ "a"]));



/***/ }),

/***/ "5c6c":
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ "5d12":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ResizeObserverService; });
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dc3a");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _utils_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("e900");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("6352");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var DEBOUNCE_DELAY = 50;
var ResizeObserverService = /** @class */ (function (_super) {
    __extends(ResizeObserverService, _super);
    function ResizeObserverService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.polyfillFunctions = [];
        return _this;
    }
    ResizeObserverService.prototype.observeResize = function (element, callback) {
        var _this = this;
        // this gets fired too often and might cause some relayout issues
        // so we add a debounce to the callback here to avoid the flashing effect.
        var debouncedCallback = Object(_utils_function__WEBPACK_IMPORTED_MODULE_2__["debounce"])(callback, DEBOUNCE_DELAY);
        var useBrowserResizeObserver = function () {
            var resizeObserver = new window.ResizeObserver(debouncedCallback);
            resizeObserver.observe(element);
            return function () { return resizeObserver.disconnect(); };
        };
        var usePolyfill = function () {
            // initialise to the current width and height, so first call will have no changes
            var widthLastTime = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["offsetWidth"])(element);
            var heightLastTime = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["offsetHeight"])(element);
            // when finished, this gets turned to false.
            var running = true;
            var periodicallyCheckWidthAndHeight = function () {
                if (running) {
                    var newWidth = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["offsetWidth"])(element);
                    var newHeight = Object(_utils_dom__WEBPACK_IMPORTED_MODULE_3__["offsetHeight"])(element);
                    var changed = newWidth !== widthLastTime || newHeight !== heightLastTime;
                    if (changed) {
                        widthLastTime = newWidth;
                        heightLastTime = newHeight;
                        callback();
                    }
                    _this.doNextPolyfillTurn(periodicallyCheckWidthAndHeight);
                }
            };
            periodicallyCheckWidthAndHeight();
            // the callback function we return sets running to false
            return function () { return running = false; };
        };
        var suppressResize = this.gridOptionsWrapper.isSuppressBrowserResizeObserver();
        var resizeObserverExists = !!window.ResizeObserver;
        if (resizeObserverExists && !suppressResize) {
            return useBrowserResizeObserver();
        }
        else {
            return usePolyfill();
        }
    };
    ResizeObserverService.prototype.doNextPolyfillTurn = function (func) {
        this.polyfillFunctions.push(func);
        this.schedulePolyfill();
    };
    ResizeObserverService.prototype.schedulePolyfill = function () {
        var _this = this;
        if (this.polyfillScheduled) {
            return;
        }
        var executeAllFuncs = function () {
            var funcs = _this.polyfillFunctions;
            // make sure set scheduled to false and clear clear array
            // before executing the funcs, as the funcs could add more funcs
            _this.polyfillScheduled = false;
            _this.polyfillFunctions = [];
            funcs.forEach(function (f) { return f(); });
        };
        this.polyfillScheduled = true;
        this.getFrameworkOverrides().setTimeout(executeAllFuncs, DEBOUNCE_DELAY);
    };
    ResizeObserverService = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_0__[/* Bean */ "b"])('resizeObserverService')
    ], ResizeObserverService);
    return ResizeObserverService;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "5e14":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export initialiseAgGridWithAngular1 */
/* harmony import */ var _grid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("2b8e");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */

function initialiseAgGridWithAngular1(angular) {
    var angularModule = angular.module("agGrid", []);
    angularModule.directive("agGrid", function () {
        return {
            restrict: "A",
            controller: ['$element', '$scope', '$compile', '$attrs', AngularDirectiveController],
            scope: true
        };
    });
}
function AngularDirectiveController($element, $scope, $compile, $attrs) {
    var gridOptions;
    var keyOfGridInScope = $attrs.agGrid;
    gridOptions = $scope.$eval(keyOfGridInScope);
    if (!gridOptions) {
        console.warn("WARNING - grid options for AG Grid not found. Please ensure the attribute ag-grid points to a valid object on the scope");
        return;
    }
    var eGridDiv = $element[0];
    var gridParams = {
        $scope: $scope,
        $compile: $compile
    };
    var grid = new _grid__WEBPACK_IMPORTED_MODULE_0__[/* Grid */ "a"](eGridDiv, gridOptions, gridParams);
    var quickFilterOnScope = keyOfGridInScope + '.quickFilterText';
    var quickFilterUnregisterFn = $scope.$watch(quickFilterOnScope, function (newFilter) {
        gridOptions.api.setQuickFilter(newFilter);
    });
    $scope.$on("$destroy", function () {
        quickFilterUnregisterFn();
        if (grid) {
            grid.destroy();
        }
        grid = null;
    });
}


/***/ }),

/***/ "5e77":
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__("83ab");
var hasOwn = __webpack_require__("1a2d");

var FunctionPrototype = Function.prototype;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn(FunctionPrototype, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));

module.exports = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};


/***/ }),

/***/ "613b":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return GridHeaderComp; });
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("59ec");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("9cc8");
/* harmony import */ var _gridHeaderCtrl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("8f19");
/* harmony import */ var _rowContainer_headerRowContainerComp__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("d8cc");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var GridHeaderComp = /** @class */ (function (_super) {
    __extends(GridHeaderComp, _super);
    function GridHeaderComp() {
        return _super.call(this, GridHeaderComp.TEMPLATE) || this;
    }
    GridHeaderComp.prototype.postConstruct = function () {
        var _this = this;
        var compProxy = {
            addOrRemoveCssClass: function (cssClassName, on) { return _this.addOrRemoveCssClass(cssClassName, on); },
            setHeightAndMinHeight: function (height) {
                _this.getGui().style.height = height;
                _this.getGui().style.minHeight = height;
            }
        };
        var ctrl = this.createManagedBean(new _gridHeaderCtrl__WEBPACK_IMPORTED_MODULE_3__[/* GridHeaderCtrl */ "a"]());
        ctrl.setComp(compProxy, this.getGui(), this.getFocusableElement());
        var addContainer = function (container) {
            _this.createManagedBean(container);
            _this.appendChild(container);
        };
        addContainer(new _rowContainer_headerRowContainerComp__WEBPACK_IMPORTED_MODULE_4__[/* HeaderRowContainerComp */ "a"](_constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].PINNED_LEFT));
        addContainer(new _rowContainer_headerRowContainerComp__WEBPACK_IMPORTED_MODULE_4__[/* HeaderRowContainerComp */ "a"](null));
        addContainer(new _rowContainer_headerRowContainerComp__WEBPACK_IMPORTED_MODULE_4__[/* HeaderRowContainerComp */ "a"](_constants_constants__WEBPACK_IMPORTED_MODULE_0__[/* Constants */ "a"].PINNED_RIGHT));
    };
    GridHeaderComp.TEMPLATE = "<div class=\"ag-header\" role=\"presentation\" unselectable=\"on\"/>";
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], GridHeaderComp.prototype, "postConstruct", null);
    return GridHeaderComp;
}(_widgets_component__WEBPACK_IMPORTED_MODULE_2__[/* Component */ "a"]));



/***/ }),

/***/ "6321":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AgAbstractLabel; });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("9cc8");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("6352");
/* harmony import */ var _utils_aria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3348");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var AgAbstractLabel = /** @class */ (function (_super) {
    __extends(AgAbstractLabel, _super);
    function AgAbstractLabel(config, template) {
        var _this = _super.call(this, template) || this;
        _this.labelSeparator = '';
        _this.labelAlignment = 'left';
        _this.label = '';
        _this.config = config || {};
        return _this;
    }
    AgAbstractLabel.prototype.postConstruct = function () {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.getGui(), 'ag-labeled');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.eLabel, 'ag-label');
        var _a = this.config, labelSeparator = _a.labelSeparator, label = _a.label, labelWidth = _a.labelWidth, labelAlignment = _a.labelAlignment;
        if (labelSeparator != null) {
            this.setLabelSeparator(labelSeparator);
        }
        if (label != null) {
            this.setLabel(label);
        }
        if (labelWidth != null) {
            this.setLabelWidth(labelWidth);
        }
        this.setLabelAlignment(labelAlignment || this.labelAlignment);
        this.refreshLabel();
    };
    AgAbstractLabel.prototype.refreshLabel = function () {
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["clearElement"])(this.eLabel);
        if (typeof this.label === 'string') {
            this.eLabel.innerText = this.label + this.labelSeparator;
        }
        else if (this.label) {
            this.eLabel.appendChild(this.label);
        }
        if (this.label === '') {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addCssClass"])(this.eLabel, 'ag-hidden');
            Object(_utils_aria__WEBPACK_IMPORTED_MODULE_3__["setAriaRole"])(this.eLabel, 'presentation');
        }
        else {
            Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["removeCssClass"])(this.eLabel, 'ag-hidden');
            Object(_utils_aria__WEBPACK_IMPORTED_MODULE_3__["setAriaRole"])(this.eLabel, null);
        }
    };
    AgAbstractLabel.prototype.setLabelSeparator = function (labelSeparator) {
        if (this.labelSeparator === labelSeparator) {
            return this;
        }
        this.labelSeparator = labelSeparator;
        if (this.label != null) {
            this.refreshLabel();
        }
        return this;
    };
    AgAbstractLabel.prototype.getLabelId = function () {
        this.eLabel.id = this.eLabel.id || "ag-" + this.getCompId() + "-label";
        return this.eLabel.id;
    };
    AgAbstractLabel.prototype.getLabel = function () {
        return this.label;
    };
    AgAbstractLabel.prototype.setLabel = function (label) {
        if (this.label === label) {
            return this;
        }
        this.label = label;
        this.refreshLabel();
        return this;
    };
    AgAbstractLabel.prototype.setLabelAlignment = function (alignment) {
        var eGui = this.getGui();
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addOrRemoveCssClass"])(eGui, 'ag-label-align-left', alignment === 'left');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addOrRemoveCssClass"])(eGui, 'ag-label-align-right', alignment === 'right');
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["addOrRemoveCssClass"])(eGui, 'ag-label-align-top', alignment === 'top');
        return this;
    };
    AgAbstractLabel.prototype.setLabelWidth = function (width) {
        if (this.label == null) {
            return this;
        }
        Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__["setElementWidth"])(this.eLabel, width);
        return this;
    };
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_1__[/* PostConstruct */ "e"]
    ], AgAbstractLabel.prototype, "postConstruct", null);
    return AgAbstractLabel;
}(_component__WEBPACK_IMPORTED_MODULE_0__[/* Component */ "a"]));



/***/ }),

/***/ "634e":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return GridApi; });
/* harmony import */ var _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("648b");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("59ec");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("dc3a");
/* harmony import */ var _interfaces_iExcelCreator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3174");
/* harmony import */ var _entities_sideBar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("7d61");
/* harmony import */ var _modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("b5fb");
/* harmony import */ var _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("1de3");
/* harmony import */ var _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("2c7d");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("562d");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("a74a");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("0e94");
/* harmony import */ var _utils_function__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("e900");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};












var GridApi = /** @class */ (function () {
    function GridApi() {
        this.detailGridInfoMap = {};
        this.destroyCalled = false;
    }
    GridApi.prototype.registerOverlayWrapperComp = function (overlayWrapperComp) {
        this.overlayWrapperComp = overlayWrapperComp;
    };
    GridApi.prototype.registerSideBarComp = function (sideBarComp) {
        this.sideBarComp = sideBarComp;
    };
    GridApi.prototype.init = function () {
        var _this = this;
        switch (this.rowModel.getType()) {
            case _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_CLIENT_SIDE:
                this.clientSideRowModel = this.rowModel;
                break;
            case _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_INFINITE:
                this.infiniteRowModel = this.rowModel;
                break;
            case _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_SERVER_SIDE:
                this.serverSideRowModel = this.rowModel;
                break;
        }
        this.ctrlsService.whenReady(function () {
            _this.gridBodyCon = _this.ctrlsService.getGridBodyCtrl();
        });
    };
    /** Used internally by grid. Not intended to be used by the client. Interface may change between releases. */
    GridApi.prototype.__getAlignedGridService = function () {
        return this.alignedGridsService;
    };
    /** Register a detail grid with the master grid when it is created. */
    GridApi.prototype.addDetailGridInfo = function (id, gridInfo) {
        this.detailGridInfoMap[id] = gridInfo;
    };
    /** Unregister a detail grid from the master grid when it is destroyed. */
    GridApi.prototype.removeDetailGridInfo = function (id) {
        this.detailGridInfoMap[id] = undefined;
    };
    /** Returns the `DetailGridInfo` corresponding to the supplied `detailGridId`. */
    GridApi.prototype.getDetailGridInfo = function (id) {
        return this.detailGridInfoMap[id];
    };
    /** Iterates through each `DetailGridInfo` in the grid and calls the supplied callback on each. */
    GridApi.prototype.forEachDetailGridInfo = function (callback) {
        var index = 0;
        Object(_utils_object__WEBPACK_IMPORTED_MODULE_8__["iterateObject"])(this.detailGridInfoMap, function (id, gridInfo) {
            // check for undefined, as old references will still be lying around
            if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["exists"])(gridInfo)) {
                callback(gridInfo, index);
                index++;
            }
        });
    };
    /** Similar to `exportDataAsCsv`, except returns the result as a string rather than download it. */
    GridApi.prototype.getDataAsCsv = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].CsvExportModule, 'api.getDataAsCsv')) {
            return this.csvCreator.getDataAsCsv(params);
        }
    };
    /** Downloads a CSV export of the grid's data. */
    GridApi.prototype.exportDataAsCsv = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].CsvExportModule, 'api.exportDataAsCSv')) {
            this.csvCreator.exportDataAsCsv(params);
        }
    };
    /** Similar to `exportDataAsExcel`, except instead of downloading a file, it will return a [Blob](https://developer.mozilla.org/en-US/docs/Web/API/Blob) to be processed by the user. */
    GridApi.prototype.getDataAsExcel = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].ExcelExportModule, 'api.getDataAsExcel')) {
            var exportMode = (params && params.exportMode) || 'xlsx';
            if (this.excelCreator.getFactoryMode(exportMode) === _interfaces_iExcelCreator__WEBPACK_IMPORTED_MODULE_3__[/* ExcelFactoryMode */ "a"].MULTI_SHEET) {
                console.warn('AG Grid: The Excel Exporter is currently on Multi Sheet mode. End that operation by calling `api.getMultipleSheetAsExcel()` or `api.exportMultipleSheetsAsExcel()`');
                return;
            }
            return this.excelCreator.getDataAsExcel(params);
        }
    };
    /** Downloads an Excel export of the grid's data. */
    GridApi.prototype.exportDataAsExcel = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].ExcelExportModule, 'api.exportDataAsExcel')) {
            var exportMode = (params && params.exportMode) || 'xlsx';
            if (this.excelCreator.getFactoryMode(exportMode) === _interfaces_iExcelCreator__WEBPACK_IMPORTED_MODULE_3__[/* ExcelFactoryMode */ "a"].MULTI_SHEET) {
                console.warn('AG Grid: The Excel Exporter is currently on Multi Sheet mode. End that operation by calling `api.getMultipleSheetAsExcel()` or `api.exportMultipleSheetsAsExcel()`');
                return;
            }
            this.excelCreator.exportDataAsExcel(params);
        }
    };
    /** This is method to be used to get the grid's data as a sheet, that will later be exported either by `getMultipleSheetsAsExcel()` or `exportMultipleSheetsAsExcel()`. */
    GridApi.prototype.getSheetDataForExcel = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].ExcelExportModule, 'api.getSheetDataForExcel')) {
            var exportMode = (params && params.exportMode) || 'xlsx';
            this.excelCreator.setFactoryMode(_interfaces_iExcelCreator__WEBPACK_IMPORTED_MODULE_3__[/* ExcelFactoryMode */ "a"].MULTI_SHEET, exportMode);
            return this.excelCreator.getSheetDataForExcel(params);
        }
    };
    /** Similar to `exportMultipleSheetsAsExcel`, except instead of downloading a file, it will return a [Blob](https://developer.mozilla.org/en-US/docs/Web/API/Blob) to be processed by the user. */
    GridApi.prototype.getMultipleSheetsAsExcel = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].ExcelExportModule, 'api.getMultipleSheetsAsExcel')) {
            return this.excelCreator.getMultipleSheetsAsExcel(params);
        }
    };
    /** Downloads an Excel export of multiple sheets in one file. */
    GridApi.prototype.exportMultipleSheetsAsExcel = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].ExcelExportModule, 'api.exportMultipleSheetsAsExcel')) {
            return this.excelCreator.exportMultipleSheetsAsExcel(params);
        }
    };
    /** @deprecated */
    GridApi.prototype.setEnterpriseDatasource = function (datasource) {
        console.warn("ag-grid: since version 18.x, api.setEnterpriseDatasource() should be replaced with api.setServerSideDatasource()");
        this.setServerSideDatasource(datasource);
    };
    /**
     * Sets an ARIA property in the grid panel (element with `role=\"grid\"`), and removes an ARIA property when the value is null.
     *
     * Example: `api.setGridAriaProperty('label', 'my grid')` will set `aria-label=\"my grid\"`.
     *
     * `api.setGridAriaProperty('label', null)` will remove the `aria-label` attribute from the grid element.
     */
    GridApi.prototype.setGridAriaProperty = function (property, value) {
        if (!property) {
            return;
        }
        var eGrid = this.ctrlsService.getGridBodyCtrl().getGui();
        var ariaProperty = "aria-" + property;
        if (value === null) {
            eGrid.removeAttribute(ariaProperty);
        }
        else {
            eGrid.setAttribute(ariaProperty, value);
        }
    };
    /** Set new datasource for Server-Side Row Model. */
    GridApi.prototype.setServerSideDatasource = function (datasource) {
        if (this.serverSideRowModel) {
            // should really have an IEnterpriseRowModel interface, so we are not casting to any
            this.serverSideRowModel.setDatasource(datasource);
        }
        else {
            console.warn("AG Grid: you can only use an enterprise datasource when gridOptions.rowModelType is '" + _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_SERVER_SIDE + "'");
        }
    };
    /** Set new datasource for Infinite Row Model. */
    GridApi.prototype.setDatasource = function (datasource) {
        if (this.gridOptionsWrapper.isRowModelInfinite()) {
            this.rowModel.setDatasource(datasource);
        }
        else {
            console.warn("AG Grid: you can only use a datasource when gridOptions.rowModelType is '" + _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_INFINITE + "'");
        }
    };
    /** Set new datasource for Viewport Row Model. */
    GridApi.prototype.setViewportDatasource = function (viewportDatasource) {
        if (this.gridOptionsWrapper.isRowModelViewport()) {
            // this is bad coding, because it's using an interface that's exposed in the enterprise.
            // really we should create an interface in the core for viewportDatasource and let
            // the enterprise implement it, rather than casting to 'any' here
            this.rowModel.setViewportDatasource(viewportDatasource);
        }
        else {
            console.warn("AG Grid: you can only use a viewport datasource when gridOptions.rowModelType is '" + _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_VIEWPORT + "'");
        }
    };
    /** Set the row data. */
    GridApi.prototype.setRowData = function (rowData) {
        if (this.gridOptionsWrapper.isRowModelDefault()) {
            if (this.gridOptionsWrapper.isImmutableData()) {
                var transactionAndMap = this.immutableService.createTransactionForRowData(rowData);
                if (!transactionAndMap) {
                    return;
                }
                var transaction = transactionAndMap[0], orderIdMap = transactionAndMap[1];
                var nodeTransaction = this.clientSideRowModel.updateRowData(transaction, orderIdMap);
                // need to force updating of full width rows - note this wouldn't be necessary the full width cell comp listened
                // to the data change event on the row node and refreshed itself.
                if (nodeTransaction) {
                    this.rowRenderer.refreshFullWidthRows(nodeTransaction.update);
                }
            }
            else {
                this.selectionService.reset();
                this.clientSideRowModel.setRowData(rowData);
            }
        }
        else {
            console.warn('cannot call setRowData unless using normal row model');
        }
    };
    /** @deprecated */
    GridApi.prototype.setFloatingTopRowData = function (rows) {
        console.warn('AG Grid: since v12, api.setFloatingTopRowData() is now api.setPinnedTopRowData()');
        this.setPinnedTopRowData(rows);
    };
    /** @deprecated */
    GridApi.prototype.setFloatingBottomRowData = function (rows) {
        console.warn('AG Grid: since v12, api.setFloatingBottomRowData() is now api.setPinnedBottomRowData()');
        this.setPinnedBottomRowData(rows);
    };
    /** @deprecated */
    GridApi.prototype.getFloatingTopRowCount = function () {
        console.warn('AG Grid: since v12, api.getFloatingTopRowCount() is now api.getPinnedTopRowCount()');
        return this.getPinnedTopRowCount();
    };
    /** @deprecated */
    GridApi.prototype.getFloatingBottomRowCount = function () {
        console.warn('AG Grid: since v12, api.getFloatingBottomRowCount() is now api.getPinnedBottomRowCount()');
        return this.getPinnedBottomRowCount();
    };
    /** @deprecated */
    GridApi.prototype.getFloatingTopRow = function (index) {
        console.warn('AG Grid: since v12, api.getFloatingTopRow() is now api.getPinnedTopRow()');
        return this.getPinnedTopRow(index);
    };
    /** @deprecated */
    GridApi.prototype.getFloatingBottomRow = function (index) {
        console.warn('AG Grid: since v12, api.getFloatingBottomRow() is now api.getPinnedBottomRow()');
        return this.getPinnedBottomRow(index);
    };
    /** Set the top pinned rows. */
    GridApi.prototype.setPinnedTopRowData = function (rows) {
        this.pinnedRowModel.setPinnedTopRowData(rows);
    };
    /** Set the bottom pinned rows. */
    GridApi.prototype.setPinnedBottomRowData = function (rows) {
        this.pinnedRowModel.setPinnedBottomRowData(rows);
    };
    /** Gets the number of top pinned rows. */
    GridApi.prototype.getPinnedTopRowCount = function () {
        return this.pinnedRowModel.getPinnedTopRowCount();
    };
    /** Gets the number of bottom pinned rows. */
    GridApi.prototype.getPinnedBottomRowCount = function () {
        return this.pinnedRowModel.getPinnedBottomRowCount();
    };
    /** Gets the top pinned row with the specified index. */
    GridApi.prototype.getPinnedTopRow = function (index) {
        return this.pinnedRowModel.getPinnedTopRow(index);
    };
    /** Gets the top pinned row with the specified index. */
    GridApi.prototype.getPinnedBottomRow = function (index) {
        return this.pinnedRowModel.getPinnedBottomRow(index);
    };
    /**
     * Call to set new column definitions. The grid will redraw all the column headers, and then redraw all of the rows.
     */
    GridApi.prototype.setColumnDefs = function (colDefs, source) {
        if (source === void 0) { source = "api"; }
        this.columnModel.setColumnDefs(colDefs, source);
    };
    /** Call to set new auto group column definition. The grid will recreate any auto-group columns if present. */
    GridApi.prototype.setAutoGroupColumnDef = function (colDef, source) {
        if (source === void 0) { source = "api"; }
        this.gridOptionsWrapper.setProperty('autoGroupColumnDef', colDef, true);
    };
    GridApi.prototype.expireValueCache = function () {
        this.valueCache.expire();
    };
    /**
     * Returns an object with two properties:
     *  - `top`: The top pixel position of the current scroll in the grid
     *  - `bottom`: The bottom pixel position of the current scroll in the grid
     */
    GridApi.prototype.getVerticalPixelRange = function () {
        return this.gridBodyCon.getScrollFeature().getVScrollPosition();
    };
    /**
     * Returns an object with two properties:
     * - `left`: The left pixel position of the current scroll in the grid
     * - `right`: The right pixel position of the current scroll in the grid
     */
    GridApi.prototype.getHorizontalPixelRange = function () {
        return this.gridBodyCon.getScrollFeature().getHScrollPosition();
    };
    /** If `true`, the horizontal scrollbar will always be present, even if not required. Otherwise, it will only be displayed when necessary. */
    GridApi.prototype.setAlwaysShowHorizontalScroll = function (show) {
        this.gridOptionsWrapper.setProperty('alwaysShowHorizontalScroll', show);
    };
    /** If `true`, the vertical scrollbar will always be present, even if not required. Otherwise it will only be displayed when necessary. */
    GridApi.prototype.setAlwaysShowVerticalScroll = function (show) {
        this.gridOptionsWrapper.setProperty('alwaysShowVerticalScroll', show);
    };
    /** Force refresh all tool panels by calling their `refresh` method. */
    GridApi.prototype.refreshToolPanel = function () {
        if (!this.sideBarComp) {
            return;
        }
        this.sideBarComp.refresh();
    };
    /** Performs change detection on all cells, refreshing cells where required. */
    GridApi.prototype.refreshCells = function (params) {
        if (params === void 0) { params = {}; }
        if (Array.isArray(params)) {
            // the old version of refreshCells() took an array of rowNodes for the first argument
            console.warn('since AG Grid v11.1, refreshCells() now takes parameters, please see the documentation.');
            return;
        }
        this.rowRenderer.refreshCells(params);
    };
    /** Flash rows, columns or individual cells. */
    GridApi.prototype.flashCells = function (params) {
        if (params === void 0) { params = {}; }
        this.rowRenderer.flashCells(params);
    };
    /** Remove row(s) from the DOM and recreate them again from scratch. */
    GridApi.prototype.redrawRows = function (params) {
        if (params === void 0) { params = {}; }
        var rowNodes = params ? params.rowNodes : undefined;
        this.rowRenderer.redrawRows(rowNodes);
    };
    /** @deprecated */
    GridApi.prototype.refreshView = function () {
        console.warn('AG Grid: since v11.1, refreshView() is deprecated, please call refreshCells() or redrawRows() instead');
        this.redrawRows();
    };
    /** @deprecated */
    GridApi.prototype.refreshRows = function (rowNodes) {
        console.warn('since AG Grid v11.1, refreshRows() is deprecated, please use refreshCells({rowNodes: rows}) or redrawRows({rowNodes: rows}) instead');
        this.refreshCells({ rowNodes: rowNodes });
    };
    /** @deprecated */
    GridApi.prototype.rowDataChanged = function (rows) {
        console.warn('AG Grid: rowDataChanged is deprecated, either call refreshView() to refresh everything, or call rowNode.setRowData(newData) to set value on a particular node');
        this.redrawRows();
    };
    /** @deprecated */
    GridApi.prototype.softRefreshView = function () {
        console.error('AG Grid: since v16, softRefreshView() is no longer supported. Please check the documentation on how to refresh.');
    };
    /** @deprecated */
    GridApi.prototype.refreshGroupRows = function () {
        console.warn('AG Grid: since v11.1, refreshGroupRows() is no longer supported, call refreshCells() instead. ' +
            'Because refreshCells() now does dirty checking, it will only refresh cells that have changed, so it should ' +
            'not be necessary to only refresh the group rows.');
        this.refreshCells();
    };
    GridApi.prototype.setFunctionsReadOnly = function (readOnly) {
        this.gridOptionsWrapper.setProperty('functionsReadOnly', readOnly);
    };
    /** Redraws the header. Useful if a column name changes, or something else that changes how the column header is displayed. */
    GridApi.prototype.refreshHeader = function () {
        this.ctrlsService.getHeaderRowContainerCtrls().forEach(function (c) { return c.refresh(); });
    };
    /** Returns `true` if any filter is set. This includes quick filter, advanced filter or external filter. */
    GridApi.prototype.isAnyFilterPresent = function () {
        return this.filterManager.isAnyFilterPresent();
    };
    /** @deprecated */
    GridApi.prototype.isAdvancedFilterPresent = function () {
        console.warn('AG Grid: isAdvancedFilterPresent() is deprecated, please use isColumnFilterPresent()');
        return this.isColumnFilterPresent();
    };
    /** Returns `true` if any column filter is set, otherwise `false`. */
    GridApi.prototype.isColumnFilterPresent = function () {
        return this.filterManager.isAdvancedFilterPresent();
    };
    /** Returns `true` if the quick filter is set, otherwise `false`. */
    GridApi.prototype.isQuickFilterPresent = function () {
        return this.filterManager.isQuickFilterPresent();
    };
    /**
     * Returns the row model inside the table.
     * From here you can see the original rows, rows after filter has been applied,
     * rows after aggregation has been applied, and the final set of 'to be displayed' rows.
     */
    GridApi.prototype.getModel = function () {
        return this.rowModel;
    };
    /** Expand or collapse a specific row node. */
    GridApi.prototype.setRowNodeExpanded = function (rowNode, expanded) {
        if (rowNode) {
            rowNode.setExpanded(expanded);
        }
    };
    /**
     *  If after getting the model, you expand or collapse a group, call this method to inform the grid.
     *  It will work out the final set of 'to be displayed' rows again (i.e. expand or collapse the group visually).
     */
    GridApi.prototype.onGroupExpandedOrCollapsed = function (deprecated_refreshFromIndex) {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(this.clientSideRowModel)) {
            console.warn('AG Grid: cannot call onGroupExpandedOrCollapsed unless using normal row model');
        }
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["exists"])(deprecated_refreshFromIndex)) {
            console.warn('AG Grid: api.onGroupExpandedOrCollapsed - refreshFromIndex parameter is no longer used, the grid will refresh all rows');
        }
        // we don't really want the user calling this if only one rowNode was expanded, instead they should be
        // calling rowNode.setExpanded(boolean) - this way we do a 'keepRenderedRows=false' so that the whole
        // grid gets refreshed again - otherwise the row with the rowNodes that were changed won't get updated,
        // and thus the expand icon in the group cell won't get 'opened' or 'closed'.
        this.clientSideRowModel.refreshModel({ step: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].MAP });
    };
    GridApi.prototype.refreshInMemoryRowModel = function (step) {
        console.warn("ag-grid: since version 18.x, api.refreshInMemoryRowModel() should be replaced with api.refreshClientSideRowModel()");
        this.refreshClientSideRowModel(step);
    };
    /** Gets the Client-Side Row Model to refresh, executing the grouping, filtering and sorting again. */
    GridApi.prototype.refreshClientSideRowModel = function (step) {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(this.clientSideRowModel)) {
            console.warn('cannot call refreshClientSideRowModel unless using normal row model');
        }
        var paramsStep = _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].EVERYTHING;
        var stepsMapped = {
            group: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].EVERYTHING,
            filter: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].FILTER,
            map: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].MAP,
            aggregate: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].AGGREGATE,
            sort: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].SORT,
            pivot: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].PIVOT
        };
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["exists"])(step)) {
            paramsStep = stepsMapped[step];
        }
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(paramsStep)) {
            console.error("AG Grid: invalid step " + step + ", available steps are " + Object.keys(stepsMapped).join(', '));
            return;
        }
        var modelParams = {
            step: paramsStep,
            keepRenderedRows: true,
            animate: true,
            keepEditingRows: true
        };
        this.clientSideRowModel.refreshModel(modelParams);
    };
    /** Returns `true` when there are no more animation frames left to process. */
    GridApi.prototype.isAnimationFrameQueueEmpty = function () {
        return this.animationFrameService.isQueueEmpty();
    };
    GridApi.prototype.flushAllAnimationFrames = function () {
        this.animationFrameService.flushAllFrames();
    };
    /**
     * Returns the row node with the given ID.
     * The row node ID is the one you provide from the callback `getRowNodeId(data)`,
     * otherwise the ID is a number auto-generated by the grid when the row data is set.
     */
    GridApi.prototype.getRowNode = function (id) {
        return this.rowModel.getRowNode(id);
    };
    /**
     * Gets the sizes that various UI elements will be rendered at with the current theme.
     * If you override the row or header height using `gridOptions`, the override value you provided will be returned.
     */
    GridApi.prototype.getSizesForCurrentTheme = function () {
        return {
            rowHeight: this.gridOptionsWrapper.getRowHeightAsNumber(),
            headerHeight: this.gridOptionsWrapper.getHeaderHeight()
        };
    };
    /** Expand all groups. */
    GridApi.prototype.expandAll = function () {
        if (this.clientSideRowModel) {
            this.clientSideRowModel.expandOrCollapseAll(true);
        }
        else if (this.serverSideRowModel) {
            this.serverSideRowModel.expandAll(true);
        }
        else {
            console.warn('AG Grid: expandAll only works with Client Side Row Model and Server Side Row Model');
        }
    };
    /** Collapse all groups. */
    GridApi.prototype.collapseAll = function () {
        if (this.clientSideRowModel) {
            this.clientSideRowModel.expandOrCollapseAll(false);
        }
        else if (this.serverSideRowModel) {
            this.serverSideRowModel.expandAll(false);
        }
        else {
            console.warn('AG Grid: collapseAll only works with Client Side Row Model and Server Side Row Model');
        }
    };
    /** Gets the tool panel instance corresponding to the supplied `id`. */
    GridApi.prototype.getToolPanelInstance = function (id) {
        if (!this.sideBarComp) {
            console.warn('AG Grid: toolPanel is only available in AG Grid Enterprise');
            return;
        }
        return this.sideBarComp.getToolPanelInstance(id);
    };
    GridApi.prototype.addVirtualRowListener = function (eventName, rowIndex, callback) {
        if (typeof eventName !== 'string') {
            console.warn('AG Grid: addVirtualRowListener is deprecated, please use addRenderedRowListener.');
        }
        this.addRenderedRowListener(eventName, rowIndex, callback);
    };
    /**
     * Registers a callback to a virtual row.
     * A virtual row is a row that is visually rendered on the screen (rows that are not visible because of the scroll position are not rendered).
     * Unlike normal events, you do not need to unregister rendered row listeners.
     * When the rendered row is removed from the grid, all associated rendered row listeners will also be removed.
     * Currently supports only one event, `virtualRowRemoved`;
     * listen for this event if your `cellRenderer` needs to do cleanup when the row no longer exists.
     */
    GridApi.prototype.addRenderedRowListener = function (eventName, rowIndex, callback) {
        if (eventName === 'virtualRowSelected') {
            console.warn("AG Grid: event virtualRowSelected is deprecated, to register for individual row\n                selection events, add a listener directly to the row node.");
        }
        this.rowRenderer.addRenderedRowListener(eventName, rowIndex, callback);
    };
    /** Pass a quick filter text into the grid for filtering. */
    GridApi.prototype.setQuickFilter = function (newFilter) {
        this.filterManager.setQuickFilter(newFilter);
    };
    GridApi.prototype.selectIndex = function (index, tryMulti, suppressEvents) {
        console.warn('AG Grid: do not use api for selection, call node.setSelected(value) instead');
        if (suppressEvents) {
            console.warn('AG Grid: suppressEvents is no longer supported, stop listening for the event if you no longer want it');
        }
        this.selectionService.selectIndex(index, tryMulti);
    };
    GridApi.prototype.deselectIndex = function (index, suppressEvents) {
        if (suppressEvents === void 0) { suppressEvents = false; }
        console.warn('AG Grid: do not use api for selection, call node.setSelected(value) instead');
        if (suppressEvents) {
            console.warn('AG Grid: suppressEvents is no longer supported, stop listening for the event if you no longer want it');
        }
        this.selectionService.deselectIndex(index);
    };
    GridApi.prototype.selectNode = function (node, tryMulti, suppressEvents) {
        if (tryMulti === void 0) { tryMulti = false; }
        if (suppressEvents === void 0) { suppressEvents = false; }
        console.warn('AG Grid: API for selection is deprecated, call node.setSelected(value) instead');
        if (suppressEvents) {
            console.warn('AG Grid: suppressEvents is no longer supported, stop listening for the event if you no longer want it');
        }
        node.setSelectedParams({ newValue: true, clearSelection: !tryMulti });
    };
    GridApi.prototype.deselectNode = function (node, suppressEvents) {
        if (suppressEvents === void 0) { suppressEvents = false; }
        console.warn('AG Grid: API for selection is deprecated, call node.setSelected(value) instead');
        if (suppressEvents) {
            console.warn('AG Grid: suppressEvents is no longer supported, stop listening for the event if you no longer want it');
        }
        node.setSelectedParams({ newValue: false });
    };
    /** Select all rows, regardless of filtering and rows that are not visible due to grouping being enabled and their groups not expanded. */
    GridApi.prototype.selectAll = function () {
        this.selectionService.selectAllRowNodes();
    };
    /** Clear all row selections, regardless of filtering. */
    GridApi.prototype.deselectAll = function () {
        this.selectionService.deselectAllRowNodes();
    };
    /** Select all filtered rows. */
    GridApi.prototype.selectAllFiltered = function () {
        this.selectionService.selectAllRowNodes(true);
    };
    /** Clear all filtered selections. */
    GridApi.prototype.deselectAllFiltered = function () {
        this.selectionService.deselectAllRowNodes(true);
    };
    GridApi.prototype.recomputeAggregates = function () {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(this.clientSideRowModel)) {
            console.warn('cannot call recomputeAggregates unless using normal row model');
        }
        console.warn("recomputeAggregates is deprecated, please call api.refreshClientSideRowModel('aggregate') instead");
        this.clientSideRowModel.refreshModel({ step: _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_6__[/* ClientSideRowModelSteps */ "a"].AGGREGATE });
    };
    /** Sets columns to adjust in size to fit the grid horizontally. */
    GridApi.prototype.sizeColumnsToFit = function () {
        this.gridBodyCon.sizeColumnsToFit();
    };
    /** Show the 'loading' overlay. */
    GridApi.prototype.showLoadingOverlay = function () {
        this.overlayWrapperComp.showLoadingOverlay();
    };
    /** Show the 'no rows' overlay. */
    GridApi.prototype.showNoRowsOverlay = function () {
        this.overlayWrapperComp.showNoRowsOverlay();
    };
    /** Hides the overlay if showing. */
    GridApi.prototype.hideOverlay = function () {
        this.overlayWrapperComp.hideOverlay();
    };
    GridApi.prototype.isNodeSelected = function (node) {
        console.warn('AG Grid: no need to call api.isNodeSelected(), just call node.isSelected() instead');
        return node.isSelected();
    };
    GridApi.prototype.getSelectedNodesById = function () {
        console.error('AG Grid: since version 3.4, getSelectedNodesById no longer exists, use getSelectedNodes() instead');
        return null;
    };
    /**
     * Returns a list of selected nodes.
     * Getting the underlying node (rather than the data) is useful when working with tree / aggregated data,
     * as the node can be traversed.
     */
    GridApi.prototype.getSelectedNodes = function () {
        return this.selectionService.getSelectedNodes();
    };
    /** Returns a list of selected rows (i.e. row data that you provided). */
    GridApi.prototype.getSelectedRows = function () {
        return this.selectionService.getSelectedRows();
    };
    /**
     * Returns a list of all selected nodes at 'best cost', a feature to be used with groups / trees.
     * If a group has all its children selected, then the group appears in the result, but not the children.
     * Designed for use with `'children'` as the group selection type, where groups don't actually appear in the selection normally.
     */
    GridApi.prototype.getBestCostNodeSelection = function () {
        return this.selectionService.getBestCostNodeSelection();
    };
    /** Retrieve rendered nodes. Due to virtualisation this will contain only the current visible rows and those in the buffer. */
    GridApi.prototype.getRenderedNodes = function () {
        return this.rowRenderer.getRenderedNodes();
    };
    GridApi.prototype.ensureColIndexVisible = function (index) {
        console.warn('AG Grid: ensureColIndexVisible(index) no longer supported, use ensureColumnVisible(colKey) instead.');
    };
    /** Ensures the column is visible, scrolling the table if needed. */
    GridApi.prototype.ensureColumnVisible = function (key) {
        this.gridBodyCon.getScrollFeature().ensureColumnVisible(key);
    };
    /**
     * Ensures the row index is visible by vertically scrolling the grid.
     * If a position of `'top'`, `'middle'` or `'bottom'` is supplied, the grid will scroll the grid to place the row at the top, middle or bottom respectively.
     * Otherwise, the grid will do the minimum scrolling possible to show the row.
     * i.e.
     * - if the grid needs to scroll up then it will scroll so that the row is at the top,
     * - if the grid needs to scroll down then it will scroll so that the row is at the bottom,
     * - if the row is already in view then the grid will do nothing.
     */
    GridApi.prototype.ensureIndexVisible = function (index, position) {
        this.gridBodyCon.getScrollFeature().ensureIndexVisible(index, position);
    };
    /**
     * Ensures a row node is visible, scrolling the grid if needed.
     * Provide either:
     * - the node,
     * - the data object
     * - a comparator function (that takes the node as a parameter, and returns `true` for match or `false` for no match).
     */
    GridApi.prototype.ensureNodeVisible = function (comparator, position) {
        if (position === void 0) { position = null; }
        this.gridBodyCon.getScrollFeature().ensureNodeVisible(comparator, position);
    };
    /**
     * Similar to `forEachNode`, except lists all the leaf nodes.
     * This effectively goes through all the data that you provided to the grid before the grid performed any grouping.
     * If using tree data, goes through all the nodes for the data you provided, including nodes that have children,
     * but excluding groups the grid created where gaps were missing in the hierarchy.
     */
    GridApi.prototype.forEachLeafNode = function (callback) {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(this.clientSideRowModel)) {
            console.warn('cannot call forEachNode unless using normal row model');
        }
        this.clientSideRowModel.forEachLeafNode(callback);
    };
    /**
     * Iterates through each node (row) in the grid and calls the callback for each node.
     * This works similar to the `forEach` method on a JavaScript array.
     * This is called for every node, ignoring any filtering or sorting applied within the grid.
     * If using the Infinite Row Model, then this gets called for each page loaded in the page cache.
     */
    GridApi.prototype.forEachNode = function (callback) {
        this.rowModel.forEachNode(callback);
    };
    /** Similar to `forEachNode`, except skips any filtered out data. */
    GridApi.prototype.forEachNodeAfterFilter = function (callback) {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(this.clientSideRowModel)) {
            console.warn('cannot call forEachNodeAfterFilter unless using normal row model');
        }
        this.clientSideRowModel.forEachNodeAfterFilter(callback);
    };
    /** Similar to `forEachNodeAfterFilter`, except the callbacks are called in the order the rows are displayed in the grid. */
    GridApi.prototype.forEachNodeAfterFilterAndSort = function (callback) {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(this.clientSideRowModel)) {
            console.warn('cannot call forEachNodeAfterFilterAndSort unless using normal row model');
        }
        this.clientSideRowModel.forEachNodeAfterFilterAndSort(callback);
    };
    GridApi.prototype.getFilterApiForColDef = function (colDef) {
        console.warn('ag-grid API method getFilterApiForColDef deprecated, use getFilterInstance instead');
        return this.getFilterInstance(colDef);
    };
    /**
     * Returns the filter component instance for a column.
     * `key` can be a string field name or a ColDef object (matches on object reference, useful if field names are not unique).
     *  */
    GridApi.prototype.getFilterInstance = function (key, callback) {
        var column = this.columnModel.getPrimaryColumn(key);
        if (column) {
            var filterPromise = this.filterManager.getFilterComponent(column, 'NO_UI');
            var currentValue = filterPromise && filterPromise.resolveNow(null, function (filterComp) { return filterComp; });
            if (callback) {
                if (currentValue) {
                    setTimeout(callback, 0, currentValue);
                }
                else if (filterPromise) {
                    filterPromise.then(callback);
                }
            }
            return currentValue;
        }
    };
    GridApi.prototype.getFilterApi = function (key) {
        console.warn('AG Grid: getFilterApi is deprecated, use getFilterInstance instead');
        return this.getFilterInstance(key);
    };
    /** Destroys a filter. Useful to force a particular filter to be created from scratch again. */
    GridApi.prototype.destroyFilter = function (key) {
        var column = this.columnModel.getPrimaryColumn(key);
        if (column) {
            return this.filterManager.destroyFilter(column, "filterDestroyed");
        }
    };
    /** Gets the status panel instance corresponding to the supplied `id`. */
    GridApi.prototype.getStatusPanel = function (key) {
        if (this.statusBarService) {
            return this.statusBarService.getStatusPanel(key);
        }
    };
    GridApi.prototype.getColumnDef = function (key) {
        var column = this.columnModel.getPrimaryColumn(key);
        if (column) {
            return column.getColDef();
        }
        return null;
    };
    /**
     * Returns the current column definitions.
    */
    GridApi.prototype.getColumnDefs = function () { return this.columnModel.getColumnDefs(); };
    /** Informs the grid that a filter has changed. This is typically called after a filter change through one of the filter APIs. */
    GridApi.prototype.onFilterChanged = function () {
        this.filterManager.onFilterChanged();
    };
    /**
     * Gets the grid to act as if the sort was changed.
     * Useful if you update some values and want to get the grid to reorder them according to the new values.
     */
    GridApi.prototype.onSortChanged = function () {
        this.sortController.onSortChanged();
    };
    GridApi.prototype.setSortModel = function (sortModel, source) {
        if (source === void 0) { source = "api"; }
        console.warn('AG Grid: as of version 24.0.0, setSortModel() is deprecated, sort information is now part of Column State. Please use columnApi.applyColumnState() instead.');
        var columnState = [];
        if (sortModel) {
            sortModel.forEach(function (item, index) {
                columnState.push({
                    colId: item.colId,
                    sort: item.sort,
                    sortIndex: index
                });
            });
        }
        this.columnModel.applyColumnState({ state: columnState, defaultState: { sort: null } });
    };
    GridApi.prototype.getSortModel = function () {
        console.warn('AG Grid: as of version 24.0.0, getSortModel() is deprecated, sort information is now part of Column State. Please use columnApi.getColumnState() instead.');
        var columnState = this.columnModel.getColumnState();
        var filteredStates = columnState.filter(function (item) { return item.sort != null; });
        var indexes = {};
        filteredStates.forEach(function (state) {
            var id = state.colId;
            var sortIndex = state.sortIndex;
            indexes[id] = sortIndex;
        });
        var res = filteredStates.map(function (s) {
            return { colId: s.colId, sort: s.sort };
        });
        res.sort(function (a, b) { return indexes[a.colId] - indexes[b.colId]; });
        return res;
    };
    /** Sets the state of all the advanced filters. Provide it with what you get from `getFilterModel()` to restore filter state. */
    GridApi.prototype.setFilterModel = function (model) {
        this.filterManager.setFilterModel(model);
    };
    /** Gets the current state of all the advanced filters. Used for saving filter state. */
    GridApi.prototype.getFilterModel = function () {
        return this.filterManager.getFilterModel();
    };
    /** Returns the focused cell (or the last focused cell if the grid lost focus). */
    GridApi.prototype.getFocusedCell = function () {
        return this.focusService.getFocusedCell();
    };
    /** Clears the focused cell. */
    GridApi.prototype.clearFocusedCell = function () {
        return this.focusService.clearFocusedCell();
    };
    /** Sets the focus to the specified cell. */
    GridApi.prototype.setFocusedCell = function (rowIndex, colKey, floating) {
        this.focusService.setFocusedCell(rowIndex, colKey, floating, true);
    };
    /** Sets the `suppressRowDrag` property. */
    GridApi.prototype.setSuppressRowDrag = function (value) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_SUPPRESS_ROW_DRAG, value);
    };
    /** Sets the `suppressMoveWhenRowDragging` property. */
    GridApi.prototype.setSuppressMoveWhenRowDragging = function (value) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_SUPPRESS_MOVE_WHEN_ROW_DRAG, value);
    };
    /** Sets the `suppressRowClickSelection` property. */
    GridApi.prototype.setSuppressRowClickSelection = function (value) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_SUPPRESS_ROW_CLICK_SELECTION, value);
    };
    /** Adds a drop zone outside of the grid where rows can be dropped. */
    GridApi.prototype.addRowDropZone = function (params) {
        this.gridBodyCon.getRowDragFeature().addRowDropZone(params);
    };
    /** Removes an external drop zone added by `addRowDropZone`. */
    GridApi.prototype.removeRowDropZone = function (params) {
        var activeDropTarget = this.dragAndDropService.findExternalZone(params);
        if (activeDropTarget) {
            this.dragAndDropService.removeDropTarget(activeDropTarget);
        }
    };
    /** Returns the `RowDropZoneParams` to be used by another grid's `addRowDropZone` method. */
    GridApi.prototype.getRowDropZoneParams = function (events) {
        return this.gridBodyCon.getRowDragFeature().getRowDropZone(events);
    };
    /** Sets the height in pixels for the row containing the column label header. */
    GridApi.prototype.setHeaderHeight = function (headerHeight) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_HEADER_HEIGHT, headerHeight);
    };
    GridApi.prototype.setDomLayout = function (domLayout) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_DOM_LAYOUT, domLayout);
    };
    /** Sets the `enableCellTextSelection` property. */
    GridApi.prototype.setEnableCellTextSelection = function (selectable) {
        this.gridBodyCon.setCellTextSelection(selectable);
    };
    /** Sets the preferred direction for the selection fill handle. */
    GridApi.prototype.setFillHandleDirection = function (direction) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_FILL_HANDLE_DIRECTION, direction);
    };
    /** Sets the height in pixels for the rows containing header column groups. */
    GridApi.prototype.setGroupHeaderHeight = function (headerHeight) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GROUP_HEADER_HEIGHT, headerHeight);
    };
    /** Sets the height in pixels for the row containing the floating filters. */
    GridApi.prototype.setFloatingFiltersHeight = function (headerHeight) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_FLOATING_FILTERS_HEIGHT, headerHeight);
    };
    /** Sets the height in pixels for the row containing header column groups when in pivot mode. */
    GridApi.prototype.setPivotGroupHeaderHeight = function (headerHeight) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PIVOT_GROUP_HEADER_HEIGHT, headerHeight);
    };
    GridApi.prototype.setIsExternalFilterPresent = function (isExternalFilterPresentFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_EXTERNAL_FILTER_PRESENT, isExternalFilterPresentFunc);
    };
    GridApi.prototype.setDoesExternalFilterPass = function (doesExternalFilterPassFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_DOES_EXTERNAL_FILTER_PASS, doesExternalFilterPassFunc);
    };
    GridApi.prototype.setNavigateToNextCell = function (navigateToNextCellFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_NAVIGATE_TO_NEXT_CELL, navigateToNextCellFunc);
    };
    GridApi.prototype.setTabToNextCell = function (tabToNextCellFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_TAB_TO_NEXT_CELL, tabToNextCellFunc);
    };
    GridApi.prototype.setTabToNextHeader = function (tabToNextHeaderFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_TAB_TO_NEXT_HEADER, tabToNextHeaderFunc);
    };
    GridApi.prototype.setNavigateToNextHeader = function (navigateToNextHeaderFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_NAVIGATE_TO_NEXT_HEADER, navigateToNextHeaderFunc);
    };
    GridApi.prototype.setGroupRowAggNodes = function (groupRowAggNodesFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GROUP_ROW_AGG_NODES, groupRowAggNodesFunc);
    };
    GridApi.prototype.setGetBusinessKeyForNode = function (getBusinessKeyForNodeFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_BUSINESS_KEY_FOR_NODE, getBusinessKeyForNodeFunc);
    };
    GridApi.prototype.setGetChildCount = function (getChildCountFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_CHILD_COUNT, getChildCountFunc);
    };
    GridApi.prototype.setProcessRowPostCreate = function (processRowPostCreateFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PROCESS_ROW_POST_CREATE, processRowPostCreateFunc);
    };
    GridApi.prototype.setGetRowNodeId = function (getRowNodeIdFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_ROW_NODE_ID, getRowNodeIdFunc);
    };
    GridApi.prototype.setGetRowClass = function (rowClassFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_ROW_CLASS, rowClassFunc);
    };
    GridApi.prototype.setIsFullWidthCell = function (isFullWidthCellFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_FULL_WIDTH_CELL, isFullWidthCellFunc);
    };
    GridApi.prototype.setIsRowSelectable = function (isRowSelectableFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_ROW_SELECTABLE, isRowSelectableFunc);
    };
    GridApi.prototype.setIsRowMaster = function (isRowMasterFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_ROW_MASTER, isRowMasterFunc);
    };
    GridApi.prototype.setPostSort = function (postSortFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_POST_SORT, postSortFunc);
    };
    GridApi.prototype.setGetDocument = function (getDocumentFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_DOCUMENT, getDocumentFunc);
    };
    GridApi.prototype.setGetContextMenuItems = function (getContextMenuItemsFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_CONTEXT_MENU_ITEMS, getContextMenuItemsFunc);
    };
    GridApi.prototype.setGetMainMenuItems = function (getMainMenuItemsFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_MAIN_MENU_ITEMS, getMainMenuItemsFunc);
    };
    GridApi.prototype.setProcessCellForClipboard = function (processCellForClipboardFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PROCESS_CELL_FOR_CLIPBOARD, processCellForClipboardFunc);
    };
    GridApi.prototype.setSendToClipboard = function (sendToClipboardFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_SEND_TO_CLIPBOARD, sendToClipboardFunc);
    };
    GridApi.prototype.setProcessCellFromClipboard = function (processCellFromClipboardFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PROCESS_CELL_FROM_CLIPBOARD, processCellFromClipboardFunc);
    };
    GridApi.prototype.setProcessSecondaryColDef = function (processSecondaryColDefFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PROCESS_TO_SECONDARY_COLDEF, processSecondaryColDefFunc);
    };
    GridApi.prototype.setProcessSecondaryColGroupDef = function (processSecondaryColGroupDefFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PROCESS_SECONDARY_COL_GROUP_DEF, processSecondaryColGroupDefFunc);
    };
    GridApi.prototype.setPostProcessPopup = function (postProcessPopupFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_POST_PROCESS_POPUP, postProcessPopupFunc);
    };
    GridApi.prototype.setDefaultGroupOrderComparator = function (defaultGroupOrderComparatorFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_DEFAULT_GROUP_ORDER_COMPARATOR, defaultGroupOrderComparatorFunc);
    };
    GridApi.prototype.setProcessChartOptions = function (processChartOptionsFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PROCESS_CHART_OPTIONS, processChartOptionsFunc);
    };
    GridApi.prototype.setGetChartToolbarItems = function (getChartToolbarItemsFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_CHART_TOOLBAR_ITEMS, getChartToolbarItemsFunc);
    };
    GridApi.prototype.setPaginationNumberFormatter = function (paginationNumberFormatterFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PAGINATION_NUMBER_FORMATTER, paginationNumberFormatterFunc);
    };
    GridApi.prototype.setGetServerSideStoreParams = function (getServerSideStoreParamsFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_SERVER_SIDE_STORE_PARAMS, getServerSideStoreParamsFunc);
    };
    GridApi.prototype.setIsServerSideGroupOpenByDefault = function (isServerSideGroupOpenByDefaultFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_SERVER_SIDE_GROUPS_OPEN_BY_DEFAULT, isServerSideGroupOpenByDefaultFunc);
    };
    GridApi.prototype.setIsApplyServerSideTransaction = function (isApplyServerSideTransactionFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_APPLY_SERVER_SIDE_TRANSACTION, isApplyServerSideTransactionFunc);
    };
    GridApi.prototype.setIsServerSideGroup = function (isServerSideGroupFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_IS_SERVER_SIDE_GROUP, isServerSideGroupFunc);
    };
    GridApi.prototype.setGetServerSideGroupKey = function (getServerSideGroupKeyFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_SERVER_SIDE_GROUP_KEY, getServerSideGroupKeyFunc);
    };
    GridApi.prototype.setGetRowStyle = function (rowStyleFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_ROW_STYLE, rowStyleFunc);
    };
    GridApi.prototype.setGetRowHeight = function (rowHeightFunc) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GET_ROW_HEIGHT, rowHeightFunc);
    };
    /** Sets the height in pixels for the row containing the columns when in pivot mode. */
    GridApi.prototype.setPivotHeaderHeight = function (headerHeight) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_PIVOT_HEADER_HEIGHT, headerHeight);
    };
    /** Returns `true` if the side bar is visible. */
    GridApi.prototype.isSideBarVisible = function () {
        return this.sideBarComp ? this.sideBarComp.isDisplayed() : false;
    };
    /** Show/hide the entire side bar, including any visible panel and the tab buttons. */
    GridApi.prototype.setSideBarVisible = function (show) {
        if (!this.sideBarComp) {
            if (show) {
                console.warn('AG Grid: sideBar is not loaded');
            }
            return;
        }
        this.sideBarComp.setDisplayed(show);
    };
    /** Sets the side bar position relative to the grid. Possible values are `'left'` or `'right'`. */
    GridApi.prototype.setSideBarPosition = function (position) {
        if (!this.sideBarComp) {
            console.warn('AG Grid: sideBar is not loaded');
            return;
        }
        this.sideBarComp.setSideBarPosition(position);
    };
    /** Opens a particular tool panel. Provide the ID of the tool panel to open. */
    GridApi.prototype.openToolPanel = function (key) {
        if (!this.sideBarComp) {
            console.warn('AG Grid: toolPanel is only available in AG Grid Enterprise');
            return;
        }
        this.sideBarComp.openToolPanel(key);
    };
    /** Closes the currently open tool panel (if any). */
    GridApi.prototype.closeToolPanel = function () {
        if (!this.sideBarComp) {
            console.warn('AG Grid: toolPanel is only available in AG Grid Enterprise');
            return;
        }
        this.sideBarComp.close();
    };
    /** Returns the ID of the currently shown tool panel if any, otherwise `null`. */
    GridApi.prototype.getOpenedToolPanel = function () {
        return this.sideBarComp ? this.sideBarComp.openedItem() : null;
    };
    /** Returns the current side bar configuration. If a shortcut was used, returns the detailed long form. */
    GridApi.prototype.getSideBar = function () {
        return this.gridOptionsWrapper.getSideBar();
    };
    /** Resets the side bar to the provided configuration. The parameter is the same as the sideBar grid property. The side bar is re-created from scratch with the new config. */
    GridApi.prototype.setSideBar = function (def) {
        this.gridOptionsWrapper.setProperty('sideBar', _entities_sideBar__WEBPACK_IMPORTED_MODULE_4__[/* SideBarDefParser */ "a"].parse(def));
    };
    GridApi.prototype.setSuppressClipboardPaste = function (value) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_SUPPRESS_CLIPBOARD_PASTE, value);
    };
    /** Returns `true` if the tool panel is showing, otherwise `false`. */
    GridApi.prototype.isToolPanelShowing = function () {
        return this.sideBarComp.isToolPanelShowing();
    };
    GridApi.prototype.doLayout = function () {
        var message = "AG Grid - since version 25.1, doLayout was taken out, as it's not needed. The grid responds to grid size changes automatically";
        Object(_utils_function__WEBPACK_IMPORTED_MODULE_11__["doOnce"])(function () { return console.warn(message); }, 'doLayoutDeprecated');
    };
    /** Tells the grid to recalculate the row heights. */
    GridApi.prototype.resetRowHeights = function () {
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["exists"])(this.clientSideRowModel)) {
            this.clientSideRowModel.resetRowHeights();
        }
    };
    GridApi.prototype.setGroupRemoveSingleChildren = function (value) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GROUP_REMOVE_SINGLE_CHILDREN, value);
    };
    GridApi.prototype.setGroupRemoveLowestSingleChildren = function (value) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_GROUP_REMOVE_LOWEST_SINGLE_CHILDREN, value);
    };
    /** Tells the grid a row height has changed. To be used after calling `rowNode.setRowHeight(newHeight)`. */
    GridApi.prototype.onRowHeightChanged = function () {
        if (this.clientSideRowModel) {
            this.clientSideRowModel.onRowHeightChanged();
        }
        else if (this.serverSideRowModel) {
            this.serverSideRowModel.onRowHeightChanged();
        }
    };
    /**
     * Gets the value for a column for a particular `rowNode` (row).
     * This is useful if you want the raw value of a cell e.g. if implementing your own CSV export.
     */
    GridApi.prototype.getValue = function (colKey, rowNode) {
        var column = this.columnModel.getPrimaryColumn(colKey);
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(column)) {
            column = this.columnModel.getGridColumn(colKey);
        }
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_9__["missing"])(column)) {
            return null;
        }
        return this.valueService.getValue(column, rowNode);
    };
    /** Add an event listener for the specified `eventType`. Works similar to `addEventListener` for a browser DOM element. */
    GridApi.prototype.addEventListener = function (eventType, listener) {
        var async = this.gridOptionsWrapper.useAsyncEvents();
        this.eventService.addEventListener(eventType, listener, async);
    };
    /** Add an event listener for all event types coming from the grid. */
    GridApi.prototype.addGlobalListener = function (listener) {
        var async = this.gridOptionsWrapper.useAsyncEvents();
        this.eventService.addGlobalListener(listener, async);
    };
    /** Remove an event listener. */
    GridApi.prototype.removeEventListener = function (eventType, listener) {
        var async = this.gridOptionsWrapper.useAsyncEvents();
        this.eventService.removeEventListener(eventType, listener, async);
    };
    /** Remove a global event listener. */
    GridApi.prototype.removeGlobalListener = function (listener) {
        var async = this.gridOptionsWrapper.useAsyncEvents();
        this.eventService.removeGlobalListener(listener, async);
    };
    GridApi.prototype.dispatchEvent = function (event) {
        this.eventService.dispatchEvent(event);
    };
    /** Will destroy the grid and release resources. If you are using a framework you do not need to call this, as the grid links in with the framework lifecycle. However if you are using Web Components or native JavaScript, you do need to call this, to avoid a memory leak in your application. */
    GridApi.prototype.destroy = function () {
        // this is needed as GridAPI is a bean, and GridAPI.destroy() is called as part
        // of context.destroy(). so we need to stop the infinite loop.
        if (this.destroyCalled) {
            return;
        }
        this.destroyCalled = true;
        // destroy the UI first (as they use the services)
        var gridCtrl = this.ctrlsService.getGridCtrl();
        gridCtrl && gridCtrl.destroyGridUi();
        // destroy the services
        this.context.destroy();
    };
    GridApi.prototype.cleanDownReferencesToAvoidMemoryLeakInCaseApplicationIsKeepingReferenceToDestroyedGrid = function () {
        // some users were raising support issues with regards memory leaks. the problem was the customers applications
        // were keeping references to the API. trying to educate them all would be difficult, easier to just remove
        // all references in teh API so at least the core grid can be garbage collected.
        //
        // wait about 100ms before clearing down the references, in case user has some cleanup to do,
        // and needs to deference the API first
        setTimeout(_utils_object__WEBPACK_IMPORTED_MODULE_8__["removeAllReferences"].bind(window, this, 'Grid API'), 100);
    };
    GridApi.prototype.warnIfDestroyed = function (methodName) {
        if (this.destroyCalled) {
            console.warn("AG Grid: Grid API method " + methodName + " was called on a grid that was destroyed.");
        }
        return this.destroyCalled;
    };
    /** Reset the quick filter cache text on every rowNode. */
    GridApi.prototype.resetQuickFilter = function () {
        if (this.warnIfDestroyed('resetQuickFilter')) {
            return;
        }
        this.rowModel.forEachNode(function (node) { return node.quickFilterAggregateText = null; });
    };
    GridApi.prototype.getRangeSelections = function () {
        console.warn("AG Grid: in v20.1.x, api.getRangeSelections() is gone, please use getCellRanges() instead.\n        We had to change how cell selections works a small bit to allow charting to integrate. The return type of\n        getCellRanges() is a bit different, please check the AG Grid documentation.");
        return null;
    };
    /** Returns the list of selected cell ranges. */
    GridApi.prototype.getCellRanges = function () {
        if (this.rangeService) {
            return this.rangeService.getCellRanges();
        }
        console.warn('AG Grid: cell range selection is only available in AG Grid Enterprise');
        return null;
    };
    GridApi.prototype.camelCaseToHumanReadable = function (camelCase) {
        return Object(_utils_string__WEBPACK_IMPORTED_MODULE_10__["camelCaseToHumanText"])(camelCase);
    };
    GridApi.prototype.addRangeSelection = function (deprecatedNoLongerUsed) {
        console.warn('AG Grid: As of version 21.x, range selection changed slightly to allow charting integration. Please call api.addCellRange() instead of api.addRangeSelection()');
    };
    /** Adds the provided cell range to the selected ranges. */
    GridApi.prototype.addCellRange = function (params) {
        if (!this.rangeService) {
            console.warn('AG Grid: cell range selection is only available in AG Grid Enterprise');
        }
        this.rangeService.addCellRange(params);
    };
    /** Clears the selected ranges. */
    GridApi.prototype.clearRangeSelection = function () {
        if (!this.rangeService) {
            console.warn('AG Grid: cell range selection is only available in AG Grid Enterprise');
        }
        this.rangeService.removeAllCellRanges();
    };
    /** Reverts the last cell edit. */
    GridApi.prototype.undoCellEditing = function () {
        this.undoRedoService.undo();
    };
    /** Re-applies the most recently undone cell edit. */
    GridApi.prototype.redoCellEditing = function () {
        this.undoRedoService.redo();
    };
    /** Returns current number of available cell edit undo operations. */
    GridApi.prototype.getCurrentUndoSize = function () {
        return this.undoRedoService.getCurrentUndoStackSize();
    };
    /** Returns current number of available cell edit redo operations. */
    GridApi.prototype.getCurrentRedoSize = function () {
        return this.undoRedoService.getCurrentRedoStackSize();
    };
    /** Returns a list of models with information about the charts that are currently rendered from the grid. */
    GridApi.prototype.getChartModels = function () {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.getChartModels') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.getChartModels')) {
            return this.chartService.getChartModels();
        }
    };
    /** Returns the `ChartRef` using the supplied `chartId`. */
    GridApi.prototype.getChartRef = function (chartId) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.getChartRef') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.getChartRef')) {
            return this.chartService.getChartRef(chartId);
        }
    };
    /** Returns a string containing the requested data URL which contains a representation of the chart image. */
    GridApi.prototype.getChartImageDataURL = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.getChartImageDataURL') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.getChartImageDataURL')) {
            return this.chartService.getChartImageDataURL(params);
        }
    };
    /** Used to programmatically create charts from a range. */
    GridApi.prototype.createRangeChart = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.createRangeChart') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.createRangeChart')) {
            return this.chartService.createRangeChart(params);
        }
    };
    /** Used to programmatically create cross filter charts from a range. */
    GridApi.prototype.createCrossFilterChart = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.createCrossFilterChart') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.createCrossFilterChart')) {
            return this.chartService.createCrossFilterChart(params);
        }
    };
    /** Restores a chart using the `ChartModel` that was previously obtained from `getChartModels()`. */
    GridApi.prototype.restoreChart = function (chartModel, chartContainer) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.restoreChart') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.restoreChart')) {
            return this.chartService.restoreChart(chartModel, chartContainer);
        }
    };
    /** Used to programmatically create pivot charts from a grid. */
    GridApi.prototype.createPivotChart = function (params) {
        if (_modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].RangeSelectionModule, 'api.createPivotChart') &&
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_7__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_5__[/* ModuleNames */ "a"].GridChartsModule, 'api.createPivotChart')) {
            return this.chartService.createPivotChart(params);
        }
    };
    /**
     * Copies the selected rows to the clipboard.
     * Set `includeHeaders = true` to include the headers (default is `false`).
     * Set `columnKeys` to the list of columns if you want just specific columns.
     */
    GridApi.prototype.copySelectedRowsToClipboard = function (includeHeader, columnKeys) {
        if (!this.clipboardService) {
            console.warn('AG Grid: clipboard is only available in AG Grid Enterprise');
        }
        this.clipboardService.copySelectedRowsToClipboard(includeHeader, columnKeys);
    };
    /** Copies the selected ranges to the clipboard. */
    GridApi.prototype.copySelectedRangeToClipboard = function (includeHeader) {
        if (!this.clipboardService) {
            console.warn('AG Grid: clipboard is only available in AG Grid Enterprise');
        }
        this.clipboardService.copySelectedRangeToClipboard(includeHeader);
    };
    /** Copies the selected range down, similar to `Ctrl + D` in Excel. */
    GridApi.prototype.copySelectedRangeDown = function () {
        if (!this.clipboardService) {
            console.warn('AG Grid: clipboard is only available in AG Grid Enterprise');
        }
        this.clipboardService.copyRangeDown();
    };
    /** Shows the column menu after and positions it relative to the provided button element. Use in conjunction with your own header template. */
    GridApi.prototype.showColumnMenuAfterButtonClick = function (colKey, buttonElement) {
        // use grid column so works with pivot mode
        var column = this.columnModel.getGridColumn(colKey);
        this.menuFactory.showMenuAfterButtonClick(column, buttonElement, 'columnMenu');
    };
    /** Shows the column menu after and positions it relative to the mouse event. Use in conjunction with your own header template. */
    GridApi.prototype.showColumnMenuAfterMouseClick = function (colKey, mouseEvent) {
        // use grid column so works with pivot mode
        var column = this.columnModel.getGridColumn(colKey);
        if (!column) {
            column = this.columnModel.getPrimaryColumn(colKey);
        }
        if (!column) {
            console.error("AG Grid: column '" + colKey + "' not found");
            return;
        }
        this.menuFactory.showMenuAfterMouseEvent(column, mouseEvent);
    };
    /** Hides any visible context menu or column menu. */
    GridApi.prototype.hidePopupMenu = function () {
        // hide the context menu if in enterprise
        if (this.contextMenuFactory) {
            this.contextMenuFactory.hideActiveMenu();
        }
        // and hide the column menu always
        this.menuFactory.hideActiveMenu();
    };
    /** DOM element to use as the popup parent for grid popups (context menu, column menu etc). */
    GridApi.prototype.setPopupParent = function (ePopupParent) {
        this.gridOptionsWrapper.setProperty(_gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_0__[/* GridOptionsWrapper */ "a"].PROP_POPUP_PARENT, ePopupParent);
    };
    /** Navigates the grid focus to the next cell, as if tabbing. */
    GridApi.prototype.tabToNextCell = function () {
        return this.navigationService.tabToNextCell(false);
    };
    /** Navigates the grid focus to the previous cell, as if shift-tabbing. */
    GridApi.prototype.tabToPreviousCell = function () {
        return this.navigationService.tabToNextCell(true);
    };
    /** Returns the list of active cell renderer instances. */
    GridApi.prototype.getCellRendererInstances = function (params) {
        if (params === void 0) { params = {}; }
        return this.rowRenderer.getCellRendererInstances(params);
    };
    /** Returns the list of active cell editor instances. Optionally provide parameters to restrict to certain columns / row nodes. */
    GridApi.prototype.getCellEditorInstances = function (params) {
        if (params === void 0) { params = {}; }
        return this.rowRenderer.getCellEditorInstances(params);
    };
    /** If the grid is editing, returns back details of the editing cell(s). */
    GridApi.prototype.getEditingCells = function () {
        return this.rowRenderer.getEditingCells();
    };
    /** If a cell is editing, it stops the editing. Pass `true` if you want to cancel the editing (i.e. don't accept changes). */
    GridApi.prototype.stopEditing = function (cancel) {
        if (cancel === void 0) { cancel = false; }
        this.rowRenderer.stopEditing(cancel);
    };
    /** Start editing the provided cell. If another cell is editing, the editing will be stopped in that other cell. */
    GridApi.prototype.startEditingCell = function (params) {
        var column = this.columnModel.getGridColumn(params.colKey);
        if (!column) {
            console.warn("AG Grid: no column found for " + params.colKey);
            return;
        }
        var cellPosition = {
            rowIndex: params.rowIndex,
            rowPinned: params.rowPinned || null,
            column: column
        };
        var notPinned = params.rowPinned == null;
        if (notPinned) {
            this.gridBodyCon.getScrollFeature().ensureIndexVisible(params.rowIndex);
        }
        var cell = this.navigationService.getCellByPosition(cellPosition);
        if (!cell) {
            return;
        }
        cell.startRowOrCellEdit(params.keyPress, params.charPress);
    };
    /** Add an aggregation function with the specified key. */
    GridApi.prototype.addAggFunc = function (key, aggFunc) {
        if (this.aggFuncService) {
            this.aggFuncService.addAggFunc(key, aggFunc);
        }
    };
    /** Add aggregations function with the specified keys. */
    GridApi.prototype.addAggFuncs = function (aggFuncs) {
        if (this.aggFuncService) {
            this.aggFuncService.addAggFuncs(aggFuncs);
        }
    };
    /** Clears all aggregation functions (including those provided by the grid). */
    GridApi.prototype.clearAggFuncs = function () {
        if (this.aggFuncService) {
            this.aggFuncService.clear();
        }
    };
    /** Apply transactions to the server side row model. */
    GridApi.prototype.applyServerSideTransaction = function (transaction) {
        if (!this.serverSideTransactionManager) {
            console.warn('AG Grid: Cannot apply Server Side Transaction if not using the Server Side Row Model.');
            return;
        }
        return this.serverSideTransactionManager.applyTransaction(transaction);
    };
    GridApi.prototype.applyServerSideTransactionAsync = function (transaction, callback) {
        if (!this.serverSideTransactionManager) {
            console.warn('AG Grid: Cannot apply Server Side Transaction if not using the Server Side Row Model.');
            return;
        }
        return this.serverSideTransactionManager.applyTransactionAsync(transaction, callback);
    };
    /** Gets all failed server side loads to retry. */
    GridApi.prototype.retryServerSideLoads = function () {
        if (!this.serverSideRowModel) {
            console.warn('AG Grid: API retryServerSideLoads() can only be used when using Server-Side Row Model.');
            return;
        }
        this.serverSideRowModel.retryLoads();
    };
    GridApi.prototype.flushServerSideAsyncTransactions = function () {
        if (!this.serverSideTransactionManager) {
            console.warn('AG Grid: Cannot flush Server Side Transaction if not using the Server Side Row Model.');
            return;
        }
        return this.serverSideTransactionManager.flushAsyncTransactions();
    };
    /** Update row data. Pass a transaction object with lists for `add`, `remove` and `update`. */
    GridApi.prototype.applyTransaction = function (rowDataTransaction) {
        if (!this.clientSideRowModel) {
            console.error('AG Grid: updateRowData() only works with ClientSideRowModel. Working with InfiniteRowModel was deprecated in v23.1 and removed in v24.1');
            return;
        }
        var res = this.clientSideRowModel.updateRowData(rowDataTransaction);
        // refresh all the full width rows
        this.rowRenderer.refreshFullWidthRows(res.update);
        // do change detection for all present cells
        if (!this.gridOptionsWrapper.isSuppressChangeDetection()) {
            this.rowRenderer.refreshCells();
        }
        return res;
    };
    /** @deprecated */
    GridApi.prototype.updateRowData = function (rowDataTransaction) {
        var message = 'AG Grid: as of v23.1, grid API updateRowData(transaction) is now called applyTransaction(transaction). updateRowData is deprecated and will be removed in a future major release.';
        Object(_utils_function__WEBPACK_IMPORTED_MODULE_11__["doOnce"])(function () { return console.warn(message); }, 'updateRowData deprecated');
        return this.applyTransaction(rowDataTransaction);
    };
    /** Same as `applyTransaction` except executes asynchronously for efficiency. */
    GridApi.prototype.applyTransactionAsync = function (rowDataTransaction, callback) {
        if (!this.clientSideRowModel) {
            console.error('AG Grid: api.applyTransactionAsync() only works with ClientSideRowModel.');
            return;
        }
        this.clientSideRowModel.batchUpdateRowData(rowDataTransaction, callback);
    };
    /** Executes any remaining asynchronous grid transactions, if any are waiting to be executed. */
    GridApi.prototype.flushAsyncTransactions = function () {
        if (!this.clientSideRowModel) {
            console.error('AG Grid: api.applyTransactionAsync() only works with ClientSideRowModel.');
            return;
        }
        this.clientSideRowModel.flushAsyncTransactions();
    };
    /** @deprecated */
    GridApi.prototype.batchUpdateRowData = function (rowDataTransaction, callback) {
        var message = 'AG Grid: as of v23.1, grid API batchUpdateRowData(transaction, callback) is now called applyTransactionAsync(transaction, callback). batchUpdateRowData is deprecated and will be removed in a future major release.';
        Object(_utils_function__WEBPACK_IMPORTED_MODULE_11__["doOnce"])(function () { return console.warn(message); }, 'batchUpdateRowData deprecated');
        this.applyTransactionAsync(rowDataTransaction, callback);
    };
    GridApi.prototype.insertItemsAtIndex = function (index, items, skipRefresh) {
        if (skipRefresh === void 0) { skipRefresh = false; }
        console.warn('AG Grid: insertItemsAtIndex() is deprecated, use updateRowData(transaction) instead.');
        this.updateRowData({ add: items, addIndex: index, update: null, remove: null });
    };
    GridApi.prototype.removeItems = function (rowNodes, skipRefresh) {
        if (skipRefresh === void 0) { skipRefresh = false; }
        console.warn('AG Grid: removeItems() is deprecated, use updateRowData(transaction) instead.');
        var dataToRemove = rowNodes.map(function (rowNode) { return rowNode.data; });
        this.updateRowData({ add: null, addIndex: null, update: null, remove: dataToRemove });
    };
    GridApi.prototype.addItems = function (items, skipRefresh) {
        if (skipRefresh === void 0) { skipRefresh = false; }
        console.warn('AG Grid: addItems() is deprecated, use updateRowData(transaction) instead.');
        this.updateRowData({ add: items, addIndex: null, update: null, remove: null });
    };
    GridApi.prototype.refreshVirtualPageCache = function () {
        console.warn('AG Grid: refreshVirtualPageCache() is now called refreshInfiniteCache(), please call refreshInfiniteCache() instead');
        this.refreshInfiniteCache();
    };
    GridApi.prototype.refreshInfinitePageCache = function () {
        console.warn('AG Grid: refreshInfinitePageCache() is now called refreshInfiniteCache(), please call refreshInfiniteCache() instead');
        this.refreshInfiniteCache();
    };
    /**
     * Marks all the currently loaded blocks in the cache for reload.
     * If you have 10 blocks in the cache, all 10 will be marked for reload.
     * The old data will continue to be displayed until the new data is loaded.
     */
    GridApi.prototype.refreshInfiniteCache = function () {
        if (this.infiniteRowModel) {
            this.infiniteRowModel.refreshCache();
        }
        else {
            console.warn("AG Grid: api.refreshInfiniteCache is only available when rowModelType='infinite'.");
        }
    };
    GridApi.prototype.purgeVirtualPageCache = function () {
        console.warn('AG Grid: purgeVirtualPageCache() is now called purgeInfiniteCache(), please call purgeInfiniteCache() instead');
        this.purgeInfinitePageCache();
    };
    GridApi.prototype.purgeInfinitePageCache = function () {
        console.warn('AG Grid: purgeInfinitePageCache() is now called purgeInfiniteCache(), please call purgeInfiniteCache() instead');
        this.purgeInfiniteCache();
    };
    /**
     * Purges the cache.
     * The grid is then told to refresh. Only the blocks required to display the current data on screen are fetched (typically no more than 2).
     * The grid will display nothing while the new blocks are loaded.
     * Use this to immediately remove the old data from the user.
     */
    GridApi.prototype.purgeInfiniteCache = function () {
        if (this.infiniteRowModel) {
            this.infiniteRowModel.purgeCache();
        }
        else {
            console.warn("AG Grid: api.purgeInfiniteCache is only available when rowModelType='infinite'.");
        }
    };
    /** @deprecated */
    GridApi.prototype.purgeEnterpriseCache = function (route) {
        console.warn("ag-grid: since version 18.x, api.purgeEnterpriseCache() should be replaced with api.purgeServerSideCache()");
        this.purgeServerSideCache(route);
    };
    /** @deprecated */
    GridApi.prototype.purgeServerSideCache = function (route) {
        if (route === void 0) { route = []; }
        if (this.serverSideRowModel) {
            console.warn("AG Grid: since v25.0, api.purgeServerSideCache is deprecated. Please use api.refreshServerSideStore({purge: true}) instead.");
            this.refreshServerSideStore({
                route: route,
                purge: true
            });
        }
        else {
            console.warn("AG Grid: api.purgeServerSideCache is only available when rowModelType='serverSide'.");
        }
    };
    /**
     * Refresh a server-side store.
     * If you pass no parameters, then the top level cache is purged.
     * To purge a child cache, pass in the string of keys to get to the child cache.
     */
    GridApi.prototype.refreshServerSideStore = function (params) {
        if (this.serverSideRowModel) {
            this.serverSideRowModel.refreshStore(params);
        }
        else {
            console.warn("AG Grid: api.refreshServerSideStore is only available when rowModelType='serverSide'.");
        }
    };
    /** Returns info on all server side stores. */
    GridApi.prototype.getServerSideStoreState = function () {
        if (this.serverSideRowModel) {
            return this.serverSideRowModel.getStoreState();
        }
        else {
            console.warn("AG Grid: api.getServerSideStoreState is only available when rowModelType='serverSide'.");
            return [];
        }
    };
    GridApi.prototype.getVirtualRowCount = function () {
        console.warn('AG Grid: getVirtualRowCount() is now called getInfiniteRowCount(), please call getInfiniteRowCount() instead');
        return this.getInfiniteRowCount();
    };
    /** The row count defines how many rows the grid allows scrolling to. */
    GridApi.prototype.getInfiniteRowCount = function () {
        if (this.infiniteRowModel) {
            return this.infiniteRowModel.getRowCount();
        }
        else {
            console.warn("AG Grid: api.getVirtualRowCount is only available when rowModelType='virtual'.");
        }
    };
    GridApi.prototype.isMaxRowFound = function () {
        console.warn("AG Grid: api.isLastRowIndexKnown is deprecated, please use api.isLastRowIndexKnown()");
        return this.isLastRowIndexKnown();
    };
    /** Returns `true` if grid allows for scrolling past the last row to load more rows, thus providing infinite scroll. */
    GridApi.prototype.isLastRowIndexKnown = function () {
        if (this.infiniteRowModel) {
            return this.infiniteRowModel.isLastRowIndexKnown();
        }
        else {
            console.warn("AG Grid: api.isMaxRowFound is only available when rowModelType='virtual'.");
        }
    };
    GridApi.prototype.setVirtualRowCount = function (rowCount, maxRowFound) {
        console.warn('AG Grid: setVirtualRowCount() is now called setInfiniteRowCount(), please call setInfiniteRowCount() instead');
        this.setRowCount(rowCount, maxRowFound);
    };
    GridApi.prototype.setInfiniteRowCount = function (rowCount, maxRowFound) {
        console.warn('AG Grid: setInfiniteRowCount() is now called setRowCount(), please call setRowCount() instead');
        this.setRowCount(rowCount, maxRowFound);
    };
    /**
     * Sets the `rowCount` and `lastRowIndexKnown` properties.
     * The second parameter, `lastRowIndexKnown`, is optional and if left out, only `rowCount` is set.
     * Set `rowCount` to adjust the height of the vertical scroll.
     * Set `lastRowIndexKnown` to enable / disable searching for more rows.
     * Use this method if you add or remove rows into the dataset and need to reset the number of rows or put the data back into 'look for data' mode.
     */
    GridApi.prototype.setRowCount = function (rowCount, maxRowFound) {
        if (this.infiniteRowModel) {
            this.infiniteRowModel.setRowCount(rowCount, maxRowFound);
        }
        else {
            console.warn("AG Grid: api.setRowCount is only available for Infinite Row Model.");
        }
    };
    GridApi.prototype.getVirtualPageState = function () {
        console.warn('AG Grid: getVirtualPageState() is now called getCacheBlockState(), please call getCacheBlockState() instead');
        return this.getCacheBlockState();
    };
    GridApi.prototype.getInfinitePageState = function () {
        console.warn('AG Grid: getInfinitePageState() is now called getCacheBlockState(), please call getCacheBlockState() instead');
        return this.getCacheBlockState();
    };
    /**
     * Returns an object representing the state of the cache. This is useful for debugging and understanding how the cache is working.
     */
    GridApi.prototype.getCacheBlockState = function () {
        return this.rowNodeBlockLoader.getBlockState();
    };
    GridApi.prototype.checkGridSize = function () {
        console.warn("in AG Grid v25.2.0, checkGridSize() was removed, as it was legacy and didn't do anything uesful.");
    };
    GridApi.prototype.getFirstRenderedRow = function () {
        console.warn('in AG Grid v12, getFirstRenderedRow() was renamed to getFirstDisplayedRow()');
        return this.getFirstDisplayedRow();
    };
    /** Get the index of the first displayed row due to scrolling (includes invisible rendered rows in the buffer). */
    GridApi.prototype.getFirstDisplayedRow = function () {
        return this.rowRenderer.getFirstVirtualRenderedRow();
    };
    GridApi.prototype.getLastRenderedRow = function () {
        console.warn('in AG Grid v12, getLastRenderedRow() was renamed to getLastDisplayedRow()');
        return this.getLastDisplayedRow();
    };
    /** Get the index of the last displayed row due to scrolling (includes invisible rendered rows in the buffer). */
    GridApi.prototype.getLastDisplayedRow = function () {
        return this.rowRenderer.getLastVirtualRenderedRow();
    };
    /** Returns the displayed `RowNode` at the given `index`. */
    GridApi.prototype.getDisplayedRowAtIndex = function (index) {
        return this.rowModel.getRow(index);
    };
    /** Returns the total number of displayed rows. */
    GridApi.prototype.getDisplayedRowCount = function () {
        return this.rowModel.getRowCount();
    };
    /**
     * Returns `true` when the last page is known.
     * This will always be `true` if you are using the Client-Side Row Model for pagination.
     * Returns `false` when the last page is not known; this only happens when using Infinite Row Model.
     */
    GridApi.prototype.paginationIsLastPageFound = function () {
        return this.paginationProxy.isLastPageFound();
    };
    /** Returns how many rows are being shown per page. */
    GridApi.prototype.paginationGetPageSize = function () {
        return this.paginationProxy.getPageSize();
    };
    /** Sets the `paginationPageSize`, then re-paginates the grid so the changes are applied immediately. */
    GridApi.prototype.paginationSetPageSize = function (size) {
        this.gridOptionsWrapper.setProperty('paginationPageSize', size);
    };
    /** Returns the 0-based index of the page which is showing. */
    GridApi.prototype.paginationGetCurrentPage = function () {
        return this.paginationProxy.getCurrentPage();
    };
    /** Returns the total number of pages. Returns `null` if `paginationIsLastPageFound() === false`. */
    GridApi.prototype.paginationGetTotalPages = function () {
        return this.paginationProxy.getTotalPages();
    };
    /** The total number of rows. Returns `null` if `paginationIsLastPageFound() === false`. */
    GridApi.prototype.paginationGetRowCount = function () {
        return this.paginationProxy.getMasterRowCount();
    };
    /** Navigates to the next page. */
    GridApi.prototype.paginationGoToNextPage = function () {
        this.paginationProxy.goToNextPage();
    };
    /** Navigates to the previous page. */
    GridApi.prototype.paginationGoToPreviousPage = function () {
        this.paginationProxy.goToPreviousPage();
    };
    /** Navigates to the first page. */
    GridApi.prototype.paginationGoToFirstPage = function () {
        this.paginationProxy.goToFirstPage();
    };
    /** Navigates to the last page. */
    GridApi.prototype.paginationGoToLastPage = function () {
        this.paginationProxy.goToLastPage();
    };
    /** Goes to the specified page. If the page requested doesn't exist, it will go to the last page. */
    GridApi.prototype.paginationGoToPage = function (page) {
        this.paginationProxy.goToPage(page);
    };
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('immutableService')
    ], GridApi.prototype, "immutableService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('csvCreator')
    ], GridApi.prototype, "csvCreator", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('excelCreator')
    ], GridApi.prototype, "excelCreator", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('rowRenderer')
    ], GridApi.prototype, "rowRenderer", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('navigationService')
    ], GridApi.prototype, "navigationService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('filterManager')
    ], GridApi.prototype, "filterManager", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('columnModel')
    ], GridApi.prototype, "columnModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('selectionService')
    ], GridApi.prototype, "selectionService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('gridOptionsWrapper')
    ], GridApi.prototype, "gridOptionsWrapper", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('valueService')
    ], GridApi.prototype, "valueService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('alignedGridsService')
    ], GridApi.prototype, "alignedGridsService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('eventService')
    ], GridApi.prototype, "eventService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('pinnedRowModel')
    ], GridApi.prototype, "pinnedRowModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('context')
    ], GridApi.prototype, "context", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('rowModel')
    ], GridApi.prototype, "rowModel", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('sortController')
    ], GridApi.prototype, "sortController", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('paginationProxy')
    ], GridApi.prototype, "paginationProxy", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('focusService')
    ], GridApi.prototype, "focusService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('dragAndDropService')
    ], GridApi.prototype, "dragAndDropService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('rangeService')
    ], GridApi.prototype, "rangeService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('clipboardService')
    ], GridApi.prototype, "clipboardService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('aggFuncService')
    ], GridApi.prototype, "aggFuncService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('menuFactory')
    ], GridApi.prototype, "menuFactory", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('contextMenuFactory')
    ], GridApi.prototype, "contextMenuFactory", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('valueCache')
    ], GridApi.prototype, "valueCache", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('animationFrameService')
    ], GridApi.prototype, "animationFrameService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('statusBarService')
    ], GridApi.prototype, "statusBarService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('chartService')
    ], GridApi.prototype, "chartService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('undoRedoService')
    ], GridApi.prototype, "undoRedoService", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('rowNodeBlockLoader')
    ], GridApi.prototype, "rowNodeBlockLoader", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Optional */ "d"])('ssrmTransactionManager')
    ], GridApi.prototype, "serverSideTransactionManager", void 0);
    __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Autowired */ "a"])('ctrlsService')
    ], GridApi.prototype, "ctrlsService", void 0);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_2__[/* PostConstruct */ "e"]
    ], GridApi.prototype, "init", null);
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_2__[/* PreDestroy */ "g"]
    ], GridApi.prototype, "cleanDownReferencesToAvoidMemoryLeakInCaseApplicationIsKeepingReferenceToDestroyedGrid", null);
    GridApi = __decorate([
        Object(_context_context__WEBPACK_IMPORTED_MODULE_2__[/* Bean */ "b"])('gridApi')
    ], GridApi);
    return GridApi;
}());



/***/ }),

/***/ "6352":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addCssClass", function() { return addCssClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeCssClass", function() { return removeCssClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addOrRemoveCssClass", function() { return addOrRemoveCssClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "radioCssClass", function() { return radioCssClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "containsClass", function() { return containsClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isFocusableFormField", function() { return isFocusableFormField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setDisplayed", function() { return setDisplayed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setVisible", function() { return setVisible; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setDisabled", function() { return setDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isElementChildOfClass", function() { return isElementChildOfClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getElementSize", function() { return getElementSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getInnerHeight", function() { return getInnerHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getInnerWidth", function() { return getInnerWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAbsoluteHeight", function() { return getAbsoluteHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAbsoluteWidth", function() { return getAbsoluteWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isRtlNegativeScroll", function() { return isRtlNegativeScroll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getScrollLeft", function() { return getScrollLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setScrollLeft", function() { return setScrollLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "clearElement", function() { return clearElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeElement", function() { return removeElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeFromParent", function() { return removeFromParent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isVisible", function() { return isVisible; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadTemplate", function() { return loadTemplate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "appendHtml", function() { return appendHtml; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getElementAttribute", function() { return getElementAttribute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "offsetHeight", function() { return offsetHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "offsetWidth", function() { return offsetWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ensureDomOrder", function() { return ensureDomOrder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setDomChildOrder", function() { return setDomChildOrder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertWithDomOrder", function() { return insertWithDomOrder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "prependDC", function() { return prependDC; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addStylesToElement", function() { return addStylesToElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isHorizontalScrollShowing", function() { return isHorizontalScrollShowing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isVerticalScrollShowing", function() { return isVerticalScrollShowing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setElementWidth", function() { return setElementWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setFixedWidth", function() { return setFixedWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setElementHeight", function() { return setElementHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setFixedHeight", function() { return setFixedHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "formatSize", function() { return formatSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNode", function() { return isNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isElement", function() { return isElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNodeOrElement", function() { return isNodeOrElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyNodeList", function() { return copyNodeList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "iterateNamedNodeMap", function() { return iterateNamedNodeMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setCheckboxState", function() { return setCheckboxState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addOrRemoveAttribute", function() { return addOrRemoveAttribute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nodeListForEach", function() { return nodeListForEach; });
/* harmony import */ var _browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("b8d2");
/* harmony import */ var _generic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("a74a");
/* harmony import */ var _object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("562d");
/* harmony import */ var _string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("0e94");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("59ec");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */





var rtlNegativeScroll;
function addCssClass(element, className) {
    if (!element || !className || className.length === 0) {
        return;
    }
    if (className.indexOf(' ') >= 0) {
        className.split(' ').forEach(function (value) { return addCssClass(element, value); });
        return;
    }
    if (element.classList) {
        element.classList.add(className);
    }
    else if (element.className && element.className.length > 0) {
        var cssClasses = element.className.split(' ');
        if (cssClasses.indexOf(className) < 0) {
            cssClasses.push(className);
            element.setAttribute('class', cssClasses.join(' '));
        }
    }
    else {
        // do not use element.classList = className here, it will cause
        // a read-only assignment error on some browsers (IE/Edge).
        element.setAttribute('class', className);
    }
    return element;
}
function removeCssClass(element, className) {
    if (!element || !className || className.length === 0) {
        return;
    }
    if (className.indexOf(' ') >= 0) {
        className.split(' ').forEach(function (value) { return removeCssClass(element, value); });
        return;
    }
    if (element.classList) {
        element.classList.remove(className);
    }
    else if (element.className && element.className.length > 0) {
        var newClassName = element.className.split(' ').filter(function (c) { return c !== className; }).join(' ');
        element.setAttribute('class', newClassName);
    }
}
function addOrRemoveCssClass(element, className, addOrRemove) {
    if (addOrRemove) {
        addCssClass(element, className);
    }
    else {
        removeCssClass(element, className);
    }
}
/**
 * This method adds a class to an element and remove that class from all siblings.
 * Useful for toggling state.
 * @param {HTMLElement} element The element to receive the class
 * @param {string} elementClass The class to be assigned to the element
 * @param {boolean} otherElementClass The class to be assigned to siblings of the element, but not the element itself
 */
function radioCssClass(element, elementClass, otherElementClass) {
    var parent = element.parentElement;
    var sibling = parent && parent.firstChild;
    while (sibling) {
        if (elementClass) {
            addOrRemoveCssClass(sibling, elementClass, sibling === element);
        }
        if (otherElementClass) {
            addOrRemoveCssClass(sibling, otherElementClass, sibling !== element);
        }
        sibling = sibling.nextSibling;
    }
}
function containsClass(element, className) {
    if (element.classList) {
        // for modern browsers
        return element.classList.contains(className);
    }
    if (element.className) {
        // for older browsers, check against the string of class names
        // if only one class, can check for exact match
        var onlyClass = element.className === className;
        // if many classes, check for class name, we have to pad with ' ' to stop other
        // class names that are a substring of this class
        var contains = element.className.indexOf(' ' + className + ' ') >= 0;
        // the padding above then breaks when it's the first or last class names
        var startsWithClass = element.className.indexOf(className + ' ') === 0;
        var endsWithClass = element.className.lastIndexOf(' ' + className) === (element.className.length - className.length - 1);
        return onlyClass || contains || startsWithClass || endsWithClass;
    }
    // if item is not a node
    return false;
}
function isFocusableFormField(element) {
    var matches = Element.prototype.matches || Element.prototype.msMatchesSelector;
    var isFocusable = matches.call(element, _constants_constants__WEBPACK_IMPORTED_MODULE_4__[/* Constants */ "a"].INPUT_SELECTOR);
    var isNotFocusable = matches.call(element, _constants_constants__WEBPACK_IMPORTED_MODULE_4__[/* Constants */ "a"].FOCUSABLE_EXCLUDE);
    var isElementVisible = isVisible(element);
    var focusable = isFocusable && !isNotFocusable && isElementVisible;
    return focusable;
}
function setDisplayed(element, displayed) {
    addOrRemoveCssClass(element, 'ag-hidden', !displayed);
}
function setVisible(element, visible) {
    addOrRemoveCssClass(element, 'ag-invisible', !visible);
}
function setDisabled(element, disabled) {
    var attributeName = 'disabled';
    var addOrRemoveDisabledAttribute = disabled ?
        function (e) { return e.setAttribute(attributeName, ''); } :
        function (e) { return e.removeAttribute(attributeName); };
    addOrRemoveDisabledAttribute(element);
    nodeListForEach(element.querySelectorAll('input'), function (input) { return addOrRemoveDisabledAttribute(input); });
}
function isElementChildOfClass(element, cls, maxNest) {
    var counter = 0;
    while (element) {
        if (containsClass(element, cls)) {
            return true;
        }
        element = element.parentElement;
        if (maxNest && ++counter > maxNest) {
            break;
        }
    }
    return false;
}
// returns back sizes as doubles instead of strings. similar to
// getBoundingClientRect, however getBoundingClientRect does not:
// a) work with fractions (eg browser is zooming)
// b) has CSS transitions applied (eg CSS scale, browser zoom), which we don't want, we want the un-transitioned values
function getElementSize(el) {
    var _a = window.getComputedStyle(el), height = _a.height, width = _a.width, paddingTop = _a.paddingTop, paddingRight = _a.paddingRight, paddingBottom = _a.paddingBottom, paddingLeft = _a.paddingLeft, marginTop = _a.marginTop, marginRight = _a.marginRight, marginBottom = _a.marginBottom, marginLeft = _a.marginLeft, boxSizing = _a.boxSizing;
    return {
        height: parseFloat(height),
        width: parseFloat(width),
        paddingTop: parseFloat(paddingTop),
        paddingRight: parseFloat(paddingRight),
        paddingBottom: parseFloat(paddingBottom),
        paddingLeft: parseFloat(paddingLeft),
        marginTop: parseFloat(marginTop),
        marginRight: parseFloat(marginRight),
        marginBottom: parseFloat(marginBottom),
        marginLeft: parseFloat(marginLeft),
        boxSizing: boxSizing
    };
}
function getInnerHeight(el) {
    var size = getElementSize(el);
    if (size.boxSizing === 'border-box') {
        return size.height - size.paddingTop - size.paddingBottom;
    }
    return size.height;
}
function getInnerWidth(el) {
    var size = getElementSize(el);
    if (size.boxSizing === 'border-box') {
        return size.width - size.paddingLeft - size.paddingRight;
    }
    return size.width;
}
function getAbsoluteHeight(el) {
    var size = getElementSize(el);
    var marginRight = size.marginBottom + size.marginTop;
    return Math.ceil(el.offsetHeight + marginRight);
}
function getAbsoluteWidth(el) {
    var size = getElementSize(el);
    var marginWidth = size.marginLeft + size.marginRight;
    return Math.ceil(el.offsetWidth + marginWidth);
}
function isRtlNegativeScroll() {
    if (typeof rtlNegativeScroll === "boolean") {
        return rtlNegativeScroll;
    }
    var template = document.createElement('div');
    template.style.direction = 'rtl';
    template.style.width = '1px';
    template.style.height = '1px';
    template.style.position = 'fixed';
    template.style.top = '0px';
    template.style.overflow = 'hidden';
    template.dir = 'rtl';
    template.innerHTML = /* html */
        "<div style=\"width: 2px\">\n            <span style=\"display: inline-block; width: 1px\"></span>\n            <span style=\"display: inline-block; width: 1px\"></span>\n        </div>";
    document.body.appendChild(template);
    template.scrollLeft = 1;
    rtlNegativeScroll = Math.floor(template.scrollLeft) === 0;
    document.body.removeChild(template);
    return rtlNegativeScroll;
}
function getScrollLeft(element, rtl) {
    var scrollLeft = element.scrollLeft;
    if (rtl) {
        // Absolute value - for FF that reports RTL scrolls in negative numbers
        scrollLeft = Math.abs(scrollLeft);
        if (Object(_browser__WEBPACK_IMPORTED_MODULE_0__["isBrowserChrome"])() && !isRtlNegativeScroll()) {
            scrollLeft = element.scrollWidth - element.clientWidth - scrollLeft;
        }
    }
    return scrollLeft;
}
function setScrollLeft(element, value, rtl) {
    if (rtl) {
        // Chrome and Safari when doing RTL have the END position of the scroll as zero, not the start
        if (isRtlNegativeScroll()) {
            value *= -1;
        }
        else if (Object(_browser__WEBPACK_IMPORTED_MODULE_0__["isBrowserSafari"])() || Object(_browser__WEBPACK_IMPORTED_MODULE_0__["isBrowserChrome"])()) {
            value = element.scrollWidth - element.clientWidth - value;
        }
    }
    element.scrollLeft = value;
}
function clearElement(el) {
    while (el && el.firstChild) {
        el.removeChild(el.firstChild);
    }
}
/** @deprecated */
function removeElement(parent, cssSelector) {
    removeFromParent(parent.querySelector(cssSelector));
}
function removeFromParent(node) {
    if (node && node.parentNode) {
        node.parentNode.removeChild(node);
    }
}
function isVisible(element) {
    return element.offsetParent !== null;
}
/**
 * Loads the template and returns it as an element. makes up for no simple way in
 * the dom api to load html directly, eg we cannot do this: document.createElement(template)
 * @param {string} template
 * @returns {HTMLElement}
 */
function loadTemplate(template) {
    var tempDiv = document.createElement('div');
    tempDiv.innerHTML = (template || '').trim();
    return tempDiv.firstChild;
}
function appendHtml(eContainer, htmlTemplate) {
    if (eContainer.lastChild) {
        // https://developer.mozilla.org/en-US/docs/Web/API/Element/insertAdjacentHTML
        // we put the items at the start, so new items appear underneath old items,
        // so when expanding/collapsing groups, the new rows don't go on top of the
        // rows below that are moving our of the way
        eContainer.insertAdjacentHTML('afterbegin', htmlTemplate);
    }
    else {
        eContainer.innerHTML = htmlTemplate;
    }
}
/** @deprecated */
function getElementAttribute(element, attributeName) {
    if (element.attributes && element.attributes[attributeName]) {
        var attribute = element.attributes[attributeName];
        return attribute.value;
    }
    return null;
}
function offsetHeight(element) {
    return element && element.clientHeight ? element.clientHeight : 0;
}
function offsetWidth(element) {
    return element && element.clientWidth ? element.clientWidth : 0;
}
function ensureDomOrder(eContainer, eChild, eChildBefore) {
    // if already in right order, do nothing
    if (eChildBefore && eChildBefore.nextSibling === eChild) {
        return;
    }
    if (eChildBefore) {
        if (eChildBefore.nextSibling) {
            // insert between the eRowBefore and the row after it
            eContainer.insertBefore(eChild, eChildBefore.nextSibling);
        }
        else {
            // if nextSibling is missing, means other row is at end, so just append new row at the end
            eContainer.appendChild(eChild);
        }
    }
    else {
        // otherwise put at start
        if (eContainer.firstChild && eContainer.firstChild !== eChild) {
            // insert it at the first location
            eContainer.insertAdjacentElement('afterbegin', eChild);
        }
    }
}
function setDomChildOrder(eContainer, orderedChildren) {
    for (var i = 0; i < orderedChildren.length; i++) {
        var correctCellAtIndex = orderedChildren[i];
        var actualCellAtIndex = eContainer.children[i];
        if (actualCellAtIndex !== correctCellAtIndex) {
            eContainer.insertBefore(correctCellAtIndex, actualCellAtIndex);
        }
    }
}
function insertWithDomOrder(eContainer, eToInsert, eChildBefore) {
    if (eChildBefore) {
        // if previous element exists, just slot in after the previous element
        eChildBefore.insertAdjacentElement('afterend', eToInsert);
    }
    else {
        if (eContainer.firstChild) {
            // insert it at the first location
            eContainer.insertAdjacentElement('afterbegin', eToInsert);
        }
        else {
            // otherwise eContainer is empty, so just append it
            eContainer.appendChild(eToInsert);
        }
    }
}
/** @deprecated */
function prependDC(parent, documentFragment) {
    if (Object(_generic__WEBPACK_IMPORTED_MODULE_1__["exists"])(parent.firstChild)) {
        parent.insertBefore(documentFragment, parent.firstChild);
    }
    else {
        parent.appendChild(documentFragment);
    }
}
function addStylesToElement(eElement, styles) {
    if (!styles) {
        return;
    }
    Object.keys(styles).forEach(function (key) {
        var keyCamelCase = Object(_string__WEBPACK_IMPORTED_MODULE_3__["hyphenToCamelCase"])(key);
        if (keyCamelCase) {
            eElement.style[keyCamelCase] = styles[key];
        }
    });
}
function isHorizontalScrollShowing(element) {
    return element.clientWidth < element.scrollWidth;
}
function isVerticalScrollShowing(element) {
    return element.clientHeight < element.scrollHeight;
}
function setElementWidth(element, width) {
    if (width === 'flex') {
        element.style.removeProperty('width');
        element.style.removeProperty('minWidth');
        element.style.removeProperty('maxWidth');
        element.style.flex = '1 1 auto';
    }
    else {
        setFixedWidth(element, width);
    }
}
function setFixedWidth(element, width) {
    width = formatSize(width);
    element.style.width = width.toString();
    element.style.maxWidth = width.toString();
    element.style.minWidth = width.toString();
}
function setElementHeight(element, height) {
    if (height === 'flex') {
        element.style.removeProperty('height');
        element.style.removeProperty('minHeight');
        element.style.removeProperty('maxHeight');
        element.style.flex = '1 1 auto';
    }
    else {
        setFixedHeight(element, height);
    }
}
function setFixedHeight(element, height) {
    height = formatSize(height);
    element.style.height = height.toString();
    element.style.maxHeight = height.toString();
    element.style.minHeight = height.toString();
}
function formatSize(size) {
    if (typeof size === 'number') {
        return size + "px";
    }
    return size;
}
/**
 * Returns true if it is a DOM node
 * taken from: http://stackoverflow.com/questions/384286/javascript-isdom-how-do-you-check-if-a-javascript-object-is-a-dom-object
 * @param {any} o
 * @return {boolean}
 */
function isNode(o) {
    return (typeof Node === 'function'
        ? o instanceof Node
        : o && typeof o === 'object' && typeof o.nodeType === 'number' && typeof o.nodeName === 'string');
}
//
/**
 * Returns true if it is a DOM element
 * taken from: http://stackoverflow.com/questions/384286/javascript-isdom-how-do-you-check-if-a-javascript-object-is-a-dom-object
 * @param {any} o
 * @returns {boolean}
 */
function isElement(o) {
    return (typeof HTMLElement === 'function'
        ? o instanceof HTMLElement //DOM2
        : o && Object(_object__WEBPACK_IMPORTED_MODULE_2__["isNonNullObject"])(o) && o.nodeType === 1 && typeof o.nodeName === 'string');
}
function isNodeOrElement(o) {
    return isNode(o) || isElement(o);
}
/**
 * Makes a copy of a node list into a list
 * @param {NodeList} nodeList
 * @returns {Node[]}
 */
function copyNodeList(nodeList) {
    if (nodeList == null) {
        return [];
    }
    var result = [];
    nodeListForEach(nodeList, function (node) { return result.push(node); });
    return result;
}
function iterateNamedNodeMap(map, callback) {
    if (!map) {
        return;
    }
    for (var i = 0; i < map.length; i++) {
        var attr = map[i];
        callback(attr.name, attr.value);
    }
}
/** @deprecated */
function setCheckboxState(eCheckbox, state) {
    if (typeof state === 'boolean') {
        eCheckbox.checked = state;
        eCheckbox.indeterminate = false;
    }
    else {
        // isNodeSelected returns back undefined if it's a group and the children
        // are a mix of selected and unselected
        eCheckbox.indeterminate = true;
    }
}
function addOrRemoveAttribute(element, name, value) {
    if (value == null) {
        element.removeAttribute(name);
    }
    else {
        element.setAttribute(name, value.toString());
    }
}
function nodeListForEach(nodeList, action) {
    if (nodeList == null) {
        return;
    }
    for (var i = 0; i < nodeList.length; i++) {
        action(nodeList[i]);
    }
}


/***/ }),

/***/ "63bb":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/* harmony import */ var _columns_columnFactory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("860a");
/* harmony import */ var _columns_columnModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("f76c");
/* harmony import */ var _columns_columnKeyCreator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("bc5d");
/* harmony import */ var _columns_columnUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("c98a");
/* harmony import */ var _columns_displayedGroupCreator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("1071");
/* harmony import */ var _columns_groupInstanceIdCreator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("8d07");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "n", function() { return _columns_groupInstanceIdCreator__WEBPACK_IMPORTED_MODULE_5__["a"]; });

/* harmony import */ var _components_componentUtil__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("854d");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "i", function() { return _components_componentUtil__WEBPACK_IMPORTED_MODULE_6__["a"]; });

/* harmony import */ var _components_agStackComponentsRegistry__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("8418");
/* harmony import */ var _components_colDefUtil__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("d3ed");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "g", function() { return _components_colDefUtil__WEBPACK_IMPORTED_MODULE_8__["a"]; });

/* harmony import */ var _components_framework_userComponentRegistry__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("3522");
/* harmony import */ var _components_framework_userComponentFactory__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("2ebc");
/* harmony import */ var _components_agGridNg1__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("5e14");
/* harmony import */ var _components_agGridWebComponent__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("9c76");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("bc71");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "d", function() { return _context_beanStub__WEBPACK_IMPORTED_MODULE_13__["a"]; });

/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("dc3a");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "a", function() { return _context_context__WEBPACK_IMPORTED_MODULE_14__["a"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "r", function() { return _context_context__WEBPACK_IMPORTED_MODULE_14__["e"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "q", function() { return _context_context__WEBPACK_IMPORTED_MODULE_14__["d"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "c", function() { return _context_context__WEBPACK_IMPORTED_MODULE_14__["b"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "t", function() { return _context_context__WEBPACK_IMPORTED_MODULE_14__["h"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "s", function() { return _context_context__WEBPACK_IMPORTED_MODULE_14__["g"]; });

/* harmony import */ var _widgets_componentAnnotations__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("6835");
/* harmony import */ var _interfaces_iExcelCreator__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("3174");
/* harmony import */ var _dragAndDrop_dragAndDropService__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("255a");
/* harmony import */ var _dragAndDrop_dragService__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("95b8");
/* harmony import */ var _entities_column__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__("70d4");
/* harmony import */ var _entities_columnGroup__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__("64bd");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "h", function() { return _entities_columnGroup__WEBPACK_IMPORTED_MODULE_20__["a"]; });

/* harmony import */ var _entities_providedColumnGroup__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__("d78e");
/* harmony import */ var _entities_rowNode__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__("fb19");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "v", function() { return _entities_rowNode__WEBPACK_IMPORTED_MODULE_22__["b"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "u", function() { return _entities_rowNode__WEBPACK_IMPORTED_MODULE_22__["a"]; });

/* harmony import */ var _filter_filterManager__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__("cbde");
/* harmony import */ var _filter_provided_providedFilter__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__("5001");
/* harmony import */ var _filter_provided_simpleFilter__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__("cf29");
/* harmony import */ var _filter_provided_scalarFilter__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__("bad3");
/* harmony import */ var _filter_provided_number_numberFilter__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__("41a1");
/* harmony import */ var _filter_provided_text_textFilter__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__("1294");
/* harmony import */ var _filter_provided_date_dateFilter__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__("b09a");
/* harmony import */ var _filter_provided_text_textFloatingFilter__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__("d29e");
/* harmony import */ var _headerRendering_cells_floatingFilter_headerFilterCellComp__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__("16a5");
/* harmony import */ var _filter_floating_floatingFilterMapper__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__("a664");
/* harmony import */ var _gridBodyComp_gridBodyComp__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__("db4b");
/* harmony import */ var _gridBodyComp_gridBodyCtrl__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__("ab4d");
/* harmony import */ var _gridBodyComp_scrollVisibleService__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__("036c");
/* harmony import */ var _gridBodyComp_mouseEventService__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__("fe3a");
/* harmony import */ var _gridBodyComp_navigationService__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__("6e5a");
/* harmony import */ var _gridBodyComp_rowContainer_rowContainerComp__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__("f0ea");
/* harmony import */ var _gridBodyComp_rowContainer_rowContainerCtrl__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__("f50b");
/* harmony import */ var _headerRendering_columnDrag_bodyDropPivotTarget__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__("97f9");
/* harmony import */ var _headerRendering_columnDrag_bodyDropTarget__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__("9969");
/* harmony import */ var _headerRendering_cells_cssClassApplier__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__("bf26");
/* harmony import */ var _headerRendering_rowContainer_headerRowContainerComp__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__("d8cc");
/* harmony import */ var _headerRendering_gridHeaderComp__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__("613b");
/* harmony import */ var _headerRendering_gridHeaderCtrl__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__("8f19");
/* harmony import */ var _headerRendering_row_headerRowComp__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__("2ce1");
/* harmony import */ var _headerRendering_row_headerRowCtrl__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__("71e5");
/* harmony import */ var _headerRendering_cells_column_headerCellCtrl__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__("7ae0");
/* harmony import */ var _headerRendering_cells_floatingFilter_headerFilterCellCtrl__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__("4e60");
/* harmony import */ var _headerRendering_cells_columnGroup_headerGroupCellCtrl__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__("e1ad");
/* harmony import */ var _headerRendering_cells_abstractCell_abstractHeaderCellCtrl__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__("22b5");
/* harmony import */ var _headerRendering_rowContainer_headerRowContainerCtrl__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__("4b14");
/* harmony import */ var _headerRendering_common_horizontalResizeService__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__("7512");
/* harmony import */ var _headerRendering_columnDrag_moveColumnFeature__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__("781d");
/* harmony import */ var _headerRendering_cells_column_standardMenu__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__("fc41");
/* harmony import */ var _layout_tabbedLayout__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__("92a9");
/* harmony import */ var _misc_simpleHttpRequest__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__("3337");
/* harmony import */ var _misc_resizeObserverService__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__("5d12");
/* harmony import */ var _misc_animationFrameService__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__("b636");
/* harmony import */ var _rendering_cellEditors_largeTextCellEditor__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__("bde0");
/* harmony import */ var _rendering_cellEditors_popupEditorWrapper__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__("5230");
/* harmony import */ var _rendering_cellEditors_popupSelectCellEditor__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__("7548");
/* harmony import */ var _rendering_cellEditors_popupTextCellEditor__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__("d86f");
/* harmony import */ var _rendering_cellEditors_selectCellEditor__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__("be7d");
/* harmony import */ var _rendering_cellEditors_textCellEditor__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__("f1fd");
/* harmony import */ var _rendering_beans__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__("c8d4");
/* harmony import */ var _rendering_cellRenderers_animateShowChangeCellRenderer__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__("20ba");
/* harmony import */ var _rendering_cellRenderers_animateSlideCellRenderer__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__("cafa");
/* harmony import */ var _rendering_cellRenderers_groupCellRenderer__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__("6f6e");
/* harmony import */ var _rendering_cellRenderers_groupCellRendererCtrl__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__("103b");
/* harmony import */ var _rendering_features_setLeftFeature__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__("6420");
/* harmony import */ var _rendering_features_positionableFeature__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__("53bb");
/* harmony import */ var _rendering_autoWidthCalculator__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__("4c9d");
/* harmony import */ var _rendering_checkboxSelectionComponent__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__("35c3");
/* harmony import */ var _rendering_cell_cellComp__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__("2e13");
/* harmony import */ var _rendering_cell_cellCtrl__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__("8912");
/* harmony import */ var _rendering_row_rowCtrl__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__("afa3");
/* harmony import */ var _rendering_rowRenderer__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__("8eef");
/* harmony import */ var _rendering_valueFormatterService__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__("0450");
/* harmony import */ var _pinnedRowModel_pinnedRowModel__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__("bf0c");
/* harmony import */ var _interfaces_serverSideTransaction__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__("48c0");
/* harmony import */ var _utils_changedPath__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__("528f");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "e", function() { return _utils_changedPath__WEBPACK_IMPORTED_MODULE_82__["a"]; });

/* harmony import */ var _rowNodeCache_rowNodeBlock__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__("6fcc");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "w", function() { return _rowNodeCache_rowNodeBlock__WEBPACK_IMPORTED_MODULE_83__["a"]; });

/* harmony import */ var _rowNodeCache_rowNodeBlockLoader__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__("571b");
/* harmony import */ var _pagination_paginationProxy__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__("37c1");
/* harmony import */ var _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__("1de3");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "f", function() { return _interfaces_iClientSideRowModel__WEBPACK_IMPORTED_MODULE_86__["a"]; });

/* harmony import */ var _styling_stylingService__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__("d28c");
/* harmony import */ var _styling_layoutFeature__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__("4d89");
/* harmony import */ var _widgets_agAbstractField__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__("1d31");
/* harmony import */ var _widgets_agCheckbox__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__("b678");
/* harmony import */ var _widgets_agRadioButton__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__("8783");
/* harmony import */ var _widgets_agToggleButton__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__("1e85");
/* harmony import */ var _widgets_agInputTextField__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__("baad");
/* harmony import */ var _widgets_agInputTextArea__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__("852c");
/* harmony import */ var _widgets_agInputNumberField__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__("5c04");
/* harmony import */ var _widgets_agInputRange__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__("e06a");
/* harmony import */ var _widgets_agSelect__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__("56a3");
/* harmony import */ var _widgets_agSlider__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__("e620");
/* harmony import */ var _widgets_agAngleSelect__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__("d0e6");
/* harmony import */ var _widgets_agColorPicker__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__("3ad0");
/* harmony import */ var _widgets_agGroupComponent__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__("31bf");
/* harmony import */ var _widgets_agDialog__WEBPACK_IMPORTED_MODULE_102__ = __webpack_require__("8cfd");
/* harmony import */ var _widgets_agPanel__WEBPACK_IMPORTED_MODULE_103__ = __webpack_require__("4a00");
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_104__ = __webpack_require__("9cc8");
/* harmony import */ var _widgets_managedFocusFeature__WEBPACK_IMPORTED_MODULE_105__ = __webpack_require__("8453");
/* harmony import */ var _widgets_tabGuardComp__WEBPACK_IMPORTED_MODULE_106__ = __webpack_require__("1946");
/* harmony import */ var _widgets_tabGuardCtrl__WEBPACK_IMPORTED_MODULE_107__ = __webpack_require__("8e65");
/* harmony import */ var _widgets_popupComponent__WEBPACK_IMPORTED_MODULE_108__ = __webpack_require__("bdb9");
/* harmony import */ var _widgets_popupService__WEBPACK_IMPORTED_MODULE_109__ = __webpack_require__("c7f0");
/* harmony import */ var _widgets_touchListener__WEBPACK_IMPORTED_MODULE_110__ = __webpack_require__("ec7d");
/* harmony import */ var _widgets_virtualList__WEBPACK_IMPORTED_MODULE_111__ = __webpack_require__("7d49");
/* harmony import */ var _interfaces_IRangeService__WEBPACK_IMPORTED_MODULE_112__ = __webpack_require__("cee8");
/* harmony import */ var _autoScrollService__WEBPACK_IMPORTED_MODULE_113__ = __webpack_require__("1f74");
/* harmony import */ var _vanillaFrameworkOverrides__WEBPACK_IMPORTED_MODULE_114__ = __webpack_require__("0632");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "x", function() { return _vanillaFrameworkOverrides__WEBPACK_IMPORTED_MODULE_114__["a"]; });

/* harmony import */ var _cellNavigationService__WEBPACK_IMPORTED_MODULE_115__ = __webpack_require__("ec31");
/* harmony import */ var _alignedGridsService__WEBPACK_IMPORTED_MODULE_116__ = __webpack_require__("6deb");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_117__ = __webpack_require__("59ec");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "j", function() { return _constants_constants__WEBPACK_IMPORTED_MODULE_117__["a"]; });

/* harmony import */ var _constants_keyCode__WEBPACK_IMPORTED_MODULE_118__ = __webpack_require__("7a66");
/* harmony import */ var _grid__WEBPACK_IMPORTED_MODULE_119__ = __webpack_require__("2b8e");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "l", function() { return _grid__WEBPACK_IMPORTED_MODULE_119__["a"]; });

/* harmony import */ var _gridApi__WEBPACK_IMPORTED_MODULE_120__ = __webpack_require__("634e");
/* harmony import */ var _eventKeys__WEBPACK_IMPORTED_MODULE_121__ = __webpack_require__("2377");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "k", function() { return _eventKeys__WEBPACK_IMPORTED_MODULE_121__["a"]; });

/* harmony import */ var _focusService__WEBPACK_IMPORTED_MODULE_122__ = __webpack_require__("0b0e");
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_123__ = __webpack_require__("5265");
/* harmony import */ var _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_124__ = __webpack_require__("648b");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "m", function() { return _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_124__["a"]; });

/* harmony import */ var _eventService__WEBPACK_IMPORTED_MODULE_125__ = __webpack_require__("896f");
/* harmony import */ var _rowNodes_selectableService__WEBPACK_IMPORTED_MODULE_126__ = __webpack_require__("377f");
/* harmony import */ var _rowNodes_rowNodeSorter__WEBPACK_IMPORTED_MODULE_127__ = __webpack_require__("68a7");
/* harmony import */ var _ctrlsService__WEBPACK_IMPORTED_MODULE_128__ = __webpack_require__("102e");
/* harmony import */ var _gridComp_gridComp__WEBPACK_IMPORTED_MODULE_129__ = __webpack_require__("f4f1");
/* harmony import */ var _gridComp_gridCtrl__WEBPACK_IMPORTED_MODULE_130__ = __webpack_require__("a73b");
/* harmony import */ var _logger__WEBPACK_IMPORTED_MODULE_131__ = __webpack_require__("98cb");
/* harmony import */ var _selectionService__WEBPACK_IMPORTED_MODULE_132__ = __webpack_require__("fb7e");
/* harmony import */ var _sortController__WEBPACK_IMPORTED_MODULE_133__ = __webpack_require__("735a");
/* harmony import */ var _templateService__WEBPACK_IMPORTED_MODULE_134__ = __webpack_require__("a4ec");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_135__ = __webpack_require__("7347");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "p", function() { return _utils__WEBPACK_IMPORTED_MODULE_135__["c"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "y", function() { return _utils__WEBPACK_IMPORTED_MODULE_135__["d"]; });

/* harmony import */ var _valueService_valueService__WEBPACK_IMPORTED_MODULE_136__ = __webpack_require__("a7ec");
/* harmony import */ var _valueService_valueCache__WEBPACK_IMPORTED_MODULE_137__ = __webpack_require__("acf8");
/* harmony import */ var _valueService_expressionService__WEBPACK_IMPORTED_MODULE_138__ = __webpack_require__("843e");
/* harmony import */ var _entities_cellPosition__WEBPACK_IMPORTED_MODULE_139__ = __webpack_require__("5b49");
/* harmony import */ var _entities_rowPosition__WEBPACK_IMPORTED_MODULE_140__ = __webpack_require__("3483");
/* harmony import */ var _headerRendering_common_headerPosition__WEBPACK_IMPORTED_MODULE_141__ = __webpack_require__("217a");
/* harmony import */ var _headerRendering_common_headerNavigationService__WEBPACK_IMPORTED_MODULE_142__ = __webpack_require__("35fe");
/* harmony import */ var _propertyKeys__WEBPACK_IMPORTED_MODULE_143__ = __webpack_require__("eb85");
/* harmony import */ var _columns_columnApi__WEBPACK_IMPORTED_MODULE_144__ = __webpack_require__("d206");
/* harmony import */ var _components_framework_frameworkComponentWrapper__WEBPACK_IMPORTED_MODULE_145__ = __webpack_require__("bf15");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "b", function() { return _components_framework_frameworkComponentWrapper__WEBPACK_IMPORTED_MODULE_145__["a"]; });

/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_146__ = __webpack_require__("6838");
/* harmony import */ var _widgets_customTooltipFeature__WEBPACK_IMPORTED_MODULE_147__ = __webpack_require__("5582");
/* harmony import */ var _interfaces_iChartOptions__WEBPACK_IMPORTED_MODULE_148__ = __webpack_require__("b4bf");
/* harmony import */ var _modules_moduleNames__WEBPACK_IMPORTED_MODULE_149__ = __webpack_require__("b5fb");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "o", function() { return _modules_moduleNames__WEBPACK_IMPORTED_MODULE_149__["a"]; });

/* harmony import */ var _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_150__ = __webpack_require__("2c7d");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_151__ = __webpack_require__("ad5d");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var globalObj = typeof global === 'undefined' ? {} : global;
globalObj.HTMLElement = typeof HTMLElement === 'undefined' ? {} : HTMLElement;
globalObj.HTMLButtonElement = typeof HTMLButtonElement === 'undefined' ? {} : HTMLButtonElement;
globalObj.HTMLSelectElement = typeof HTMLSelectElement === 'undefined' ? {} : HTMLSelectElement;
globalObj.HTMLInputElement = typeof HTMLInputElement === 'undefined' ? {} : HTMLInputElement;
globalObj.Node = typeof Node === 'undefined' ? {} : Node;
globalObj.MouseEvent = typeof MouseEvent === 'undefined' ? {} : MouseEvent;
// columns






// components







// context



// excel

// dragAndDrop


// entities














// gridPanel





// rowContainer


// headerRendering
















// layout

// misc









// rendering / cellRenderers





// features


// rendering







// row models







//styling


// widgets























// range

// root



































// charts



//  events


/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("c8ba")))

/***/ }),

/***/ "6420":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SetLeftFeature; });
/* harmony import */ var _entities_column__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("70d4");
/* harmony import */ var _context_beanStub__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("bc71");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("59ec");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("dc3a");
/* harmony import */ var _utils_aria__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("3348");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("348a");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("a74a");
/* harmony import */ var _eventKeys__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("2377");
/* harmony import */ var _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("648b");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};









var SetLeftFeature = /** @class */ (function (_super) {
    __extends(SetLeftFeature, _super);
    function SetLeftFeature(columnOrGroup, eCell, beans, colsSpanning) {
        var _this = _super.call(this) || this;
        _this.columnOrGroup = columnOrGroup;
        _this.eCell = eCell;
        _this.ariaEl = _this.eCell.querySelector('[role=columnheader]') || _this.eCell;
        _this.colsSpanning = colsSpanning;
        _this.beans = beans;
        return _this;
    }
    SetLeftFeature.prototype.setColsSpanning = function (colsSpanning) {
        this.colsSpanning = colsSpanning;
        this.onLeftChanged();
    };
    SetLeftFeature.prototype.getColumnOrGroup = function () {
        if (this.beans.gridOptionsWrapper.isEnableRtl() && this.colsSpanning) {
            return Object(_utils_array__WEBPACK_IMPORTED_MODULE_5__["last"])(this.colsSpanning);
        }
        return this.columnOrGroup;
    };
    SetLeftFeature.prototype.postConstruct = function () {
        this.addManagedListener(this.columnOrGroup, _entities_column__WEBPACK_IMPORTED_MODULE_0__[/* Column */ "a"].EVENT_LEFT_CHANGED, this.onLeftChanged.bind(this));
        this.setLeftFirstTime();
        // when in print layout, the left position is also dependent on the width of the pinned sections.
        // so additionally update left if any column width changes.
        this.addManagedListener(this.eventService, _eventKeys__WEBPACK_IMPORTED_MODULE_7__[/* Events */ "a"].EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED, this.onLeftChanged.bind(this));
        // setting left has a dependency on print layout
        this.addManagedListener(this.beans.gridOptionsWrapper, _gridOptionsWrapper__WEBPACK_IMPORTED_MODULE_8__[/* GridOptionsWrapper */ "a"].PROP_DOM_LAYOUT, this.onLeftChanged.bind(this));
    };
    SetLeftFeature.prototype.setLeftFirstTime = function () {
        var suppressMoveAnimation = this.beans.gridOptionsWrapper.isSuppressColumnMoveAnimation();
        var oldLeftExists = Object(_utils_generic__WEBPACK_IMPORTED_MODULE_6__["exists"])(this.columnOrGroup.getOldLeft());
        var animateColumnMove = this.beans.columnAnimationService.isActive() && oldLeftExists && !suppressMoveAnimation;
        if (animateColumnMove) {
            this.animateInLeft();
        }
        else {
            this.onLeftChanged();
        }
    };
    SetLeftFeature.prototype.animateInLeft = function () {
        var _this = this;
        var colOrGroup = this.getColumnOrGroup();
        var left = colOrGroup.getLeft();
        var oldLeft = colOrGroup.getOldLeft();
        var oldActualLeft = this.modifyLeftForPrintLayout(colOrGroup, oldLeft);
        var actualLeft = this.modifyLeftForPrintLayout(colOrGroup, left);
        this.setLeft(oldActualLeft);
        // we must keep track of the left we want to set to, as this would otherwise lead to a race
        // condition, if the user changed the left value many times in one VM turn, then we want to make
        // make sure the actualLeft we set in the timeout below (in the next VM turn) is the correct left
        // position. eg if user changes column position twice, then setLeft() below executes twice in next
        // VM turn, but only one (the correct one) should get applied.
        this.actualLeft = actualLeft;
        this.beans.columnAnimationService.executeNextVMTurn(function () {
            // test this left value is the latest one to be applied, and if not, do nothing
            if (_this.actualLeft === actualLeft) {
                _this.setLeft(actualLeft);
            }
        });
    };
    SetLeftFeature.prototype.onLeftChanged = function () {
        var colOrGroup = this.getColumnOrGroup();
        var left = colOrGroup.getLeft();
        this.actualLeft = this.modifyLeftForPrintLayout(colOrGroup, left);
        this.setLeft(this.actualLeft);
    };
    SetLeftFeature.prototype.modifyLeftForPrintLayout = function (colOrGroup, leftPosition) {
        var printLayout = this.beans.gridOptionsWrapper.getDomLayout() === _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].DOM_LAYOUT_PRINT;
        if (!printLayout) {
            return leftPosition;
        }
        if (colOrGroup.getPinned() === _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_LEFT) {
            return leftPosition;
        }
        var leftWidth = this.beans.columnModel.getDisplayedColumnsLeftWidth();
        if (colOrGroup.getPinned() === _constants_constants__WEBPACK_IMPORTED_MODULE_2__[/* Constants */ "a"].PINNED_RIGHT) {
            var bodyWidth = this.beans.columnModel.getBodyContainerWidth();
            return leftWidth + bodyWidth + leftPosition;
        }
        // is in body
        return leftWidth + leftPosition;
    };
    SetLeftFeature.prototype.setLeft = function (value) {
        // if the value is null, then that means the column is no longer
        // displayed. there is logic in the rendering to fade these columns
        // out, so we don't try and change their left positions.
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_6__["exists"])(value)) {
            this.eCell.style.left = value + "px";
        }
        var indexColumn;
        if (this.columnOrGroup instanceof _entities_column__WEBPACK_IMPORTED_MODULE_0__[/* Column */ "a"]) {
            indexColumn = this.columnOrGroup;
        }
        else {
            var columnGroup = this.columnOrGroup;
            var children = columnGroup.getLeafColumns();
            if (!children.length) {
                return;
            }
            if (children.length > 1) {
                Object(_utils_aria__WEBPACK_IMPORTED_MODULE_4__["setAriaColSpan"])(this.ariaEl, children.length);
            }
            indexColumn = children[0];
        }
        var index = this.beans.columnModel.getAriaColumnIndex(indexColumn);
        Object(_utils_aria__WEBPACK_IMPORTED_MODULE_4__["setAriaColIndex"])(this.ariaEl, index);
    };
    __decorate([
        _context_context__WEBPACK_IMPORTED_MODULE_3__[/* PostConstruct */ "e"]
    ], SetLeftFeature.prototype, "postConstruct", null);
    return SetLeftFeature;
}(_context_beanStub__WEBPACK_IMPORTED_MODULE_1__[/* BeanStub */ "a"]));



/***/ }),

/***/ "648b":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return GridOptionsWrapper; });
/* harmony import */ var _eventService__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("896f");
/* harmony import */ var _constants_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("59ec");
/* harmony import */ var _components_componentUtil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("854d");
/* harmony import */ var _context_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("dc3a");
/* harmony import */ var _propertyKeys__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("eb85");
/* harmony import */ var _components_colDefUtil__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("d3ed");
/* harmony import */ var _eventKeys__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("2377");
/* harmony import */ var _entities_sideBar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("7d61");
/* harmony import */ var _modules_moduleNames__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("b5fb");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("562d");
/* harmony import */ var _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("2c7d");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("866e");
/* harmony import */ var _utils_generic__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("a74a");
/* harmony import */ var _utils_fuzzyMatch__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("073f");
/* harmony import */ var _utils_function__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("e900");
/* harmony import */ var _utils_browser__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("b8d2");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("0e94");
/**
 * @ag-grid-community/core - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v26.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (undefined && undefined.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __spreadArrays = (undefined && undefined.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};

















var DEFAULT_ROW_HEIGHT = 25;
var DEFAULT_DETAIL_ROW_HEIGHT = 300;
var DEFAULT_VIEWPORT_ROW_MODEL_PAGE_SIZE = 5;
var DEFAULT_VIEWPORT_ROW_MODEL_BUFFER_SIZE = 5;
var DEFAULT_KEEP_DETAIL_ROW_COUNT = 10;
function isTrue(value) {
    return value === true || value === 'true';
}
function toNumber(value) {
    if (typeof value == 'number') {
        return value;
    }
    if (typeof value == 'string') {
        return parseInt(value, 10);
    }
}
function zeroOrGreater(value, defaultValue) {
    if (value >= 0) {
        return value;
    }
    // zero gets returned if number is missing or the wrong type
    return defaultValue;
}
function oneOrGreater(value, defaultValue) {
    var valueNumber = parseInt(value, 10);
    if (Object(_utils_number__WEBPACK_IMPORTED_MODULE_11__["isNumeric"])(valueNumber) && valueNumber > 0) {
        return valueNumber;
    }
    return defaultValue;
}
var GridOptionsWrapper = /** @class */ (function () {
    function GridOptionsWrapper() {
        this.propertyEventService = new _eventService__WEBPACK_IMPORTED_MODULE_0__[/* EventService */ "a"]();
        this.domDataKey = '__AG_' + Math.random().toString();
        this.destroyed = false;
    }
    GridOptionsWrapper_1 = GridOptionsWrapper;
    GridOptionsWrapper.prototype.agWire = function (gridApi, columnApi) {
        this.gridOptions.api = gridApi;
        this.gridOptions.columnApi = columnApi;
        this.checkForDeprecated();
        this.checkForViolations();
    };
    GridOptionsWrapper.prototype.destroy = function () {
        // need to remove these, as we don't own the lifecycle of the gridOptions, we need to
        // remove the references in case the user keeps the grid options, we want the rest
        // of the grid to be picked up by the garbage collector
        this.gridOptions.api = null;
        this.gridOptions.columnApi = null;
        this.destroyed = true;
    };
    GridOptionsWrapper.prototype.init = function () {
        var _this = this;
        if (this.gridOptions.suppressPropertyNamesCheck !== true) {
            this.checkGridOptionsProperties();
            this.checkColumnDefProperties();
        }
        // parse side bar options into correct format
        if (this.gridOptions.sideBar != null) {
            this.gridOptions.sideBar = _entities_sideBar__WEBPACK_IMPORTED_MODULE_7__[/* SideBarDefParser */ "a"].parse(this.gridOptions.sideBar);
        }
        var async = this.useAsyncEvents();
        this.eventService.addGlobalListener(this.globalEventHandler.bind(this), async);
        if (this.isGroupSelectsChildren() && this.isSuppressParentsInRowNodes()) {
            console.warn("AG Grid: 'groupSelectsChildren' does not work with 'suppressParentsInRowNodes', this selection method needs the part in rowNode to work");
        }
        if (this.isGroupSelectsChildren()) {
            if (!this.isRowSelectionMulti()) {
                console.warn("AG Grid: rowSelection must be 'multiple' for groupSelectsChildren to make sense");
            }
            if (this.isRowModelServerSide()) {
                console.warn('AG Grid: group selects children is NOT support for Server Side Row Model. ' +
                    'This is because the rows are lazy loaded, so selecting a group is not possible as' +
                    'the grid has no way of knowing what the children are.');
            }
        }
        if (this.isGroupRemoveSingleChildren() && this.isGroupHideOpenParents()) {
            console.warn("AG Grid: groupRemoveSingleChildren and groupHideOpenParents do not work with each other, you need to pick one. And don't ask us how to us these together on our support forum either you will get the same answer!");
        }
        if (this.isRowModelServerSide()) {
            var msg = function (prop) { return "AG Grid: '" + prop + "' is not supported on the Server-Side Row Model"; };
            if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["exists"])(this.gridOptions.groupDefaultExpanded)) {
                console.warn(msg('groupDefaultExpanded'));
            }
            if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["exists"])(this.gridOptions.groupDefaultExpanded)) {
                console.warn(msg('groupIncludeFooter'));
            }
            if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["exists"])(this.gridOptions.groupDefaultExpanded)) {
                console.warn(msg('groupIncludeTotalFooter'));
            }
        }
        if (this.isEnableRangeSelection()) {
            _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_10__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_8__[/* ModuleNames */ "a"].RangeSelectionModule, 'enableRangeSelection');
        }
        if (!this.isEnableRangeSelection() && (this.isEnableRangeHandle() || this.isEnableFillHandle())) {
            console.warn("AG Grid: 'enableRangeHandle' and 'enableFillHandle' will not work unless 'enableRangeSelection' is set to true");
        }
        var warnOfDeprecaredIcon = function (name) {
            if (_this.gridOptions.icons && _this.gridOptions.icons[name]) {
                console.warn("gridOptions.icons." + name + " is no longer supported. For information on how to style checkboxes and radio buttons, see https://www.ag-grid.com/javascript-grid-icons/");
            }
        };
        warnOfDeprecaredIcon('radioButtonOff');
        warnOfDeprecaredIcon('radioButtonOn');
        warnOfDeprecaredIcon('checkboxChecked');
        warnOfDeprecaredIcon('checkboxUnchecked');
        warnOfDeprecaredIcon('checkboxIndeterminate');
        // sets an initial calculation for the scrollbar width
        this.getScrollbarWidth();
    };
    GridOptionsWrapper.prototype.checkColumnDefProperties = function () {
        var _this = this;
        if (this.gridOptions.columnDefs == null) {
            return;
        }
        this.gridOptions.columnDefs.forEach(function (colDef) {
            var userProperties = Object.getOwnPropertyNames(colDef);
            var validProperties = __spreadArrays(_components_colDefUtil__WEBPACK_IMPORTED_MODULE_5__[/* ColDefUtil */ "a"].ALL_PROPERTIES, _components_colDefUtil__WEBPACK_IMPORTED_MODULE_5__[/* ColDefUtil */ "a"].FRAMEWORK_PROPERTIES);
            _this.checkProperties(userProperties, validProperties, validProperties, 'colDef', 'https://www.ag-grid.com/javascript-grid-column-properties/');
        });
    };
    GridOptionsWrapper.prototype.checkGridOptionsProperties = function () {
        var userProperties = Object.getOwnPropertyNames(this.gridOptions);
        var validProperties = __spreadArrays(_propertyKeys__WEBPACK_IMPORTED_MODULE_4__[/* PropertyKeys */ "a"].ALL_PROPERTIES, _propertyKeys__WEBPACK_IMPORTED_MODULE_4__[/* PropertyKeys */ "a"].FRAMEWORK_PROPERTIES, Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["values"])(_eventKeys__WEBPACK_IMPORTED_MODULE_6__[/* Events */ "a"]).map(function (event) { return _components_componentUtil__WEBPACK_IMPORTED_MODULE_2__[/* ComponentUtil */ "a"].getCallbackForEvent(event); }));
        var validPropertiesAndExceptions = __spreadArrays(validProperties, ['api', 'columnApi']);
        this.checkProperties(userProperties, validPropertiesAndExceptions, validProperties, 'gridOptions', 'https://www.ag-grid.com/javascript-grid-properties/');
    };
    GridOptionsWrapper.prototype.checkProperties = function (userProperties, validPropertiesAndExceptions, validProperties, containerName, docsUrl) {
        var invalidProperties = Object(_utils_fuzzyMatch__WEBPACK_IMPORTED_MODULE_13__["fuzzyCheckStrings"])(userProperties, validPropertiesAndExceptions, validProperties);
        Object(_utils_object__WEBPACK_IMPORTED_MODULE_9__["iterateObject"])(invalidProperties, function (key, value) {
            console.warn("ag-grid: invalid " + containerName + " property '" + key + "' did you mean any of these: " + value.slice(0, 8).join(", "));
        });
        if (Object.keys(invalidProperties).length > 0) {
            console.warn("ag-grid: to see all the valid " + containerName + " properties please check: " + docsUrl);
        }
    };
    GridOptionsWrapper.prototype.getDomDataKey = function () {
        return this.domDataKey;
    };
    // returns the dom data, or undefined if not found
    GridOptionsWrapper.prototype.getDomData = function (element, key) {
        var domData = element[this.getDomDataKey()];
        return domData ? domData[key] : undefined;
    };
    GridOptionsWrapper.prototype.setDomData = function (element, key, value) {
        var domDataKey = this.getDomDataKey();
        var domData = element[domDataKey];
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["missing"])(domData)) {
            domData = {};
            element[domDataKey] = domData;
        }
        domData[key] = value;
    };
    GridOptionsWrapper.prototype.isRowSelection = function () {
        return this.gridOptions.rowSelection === 'single' || this.gridOptions.rowSelection === 'multiple';
    };
    GridOptionsWrapper.prototype.isSuppressRowDeselection = function () {
        return isTrue(this.gridOptions.suppressRowDeselection);
    };
    GridOptionsWrapper.prototype.isRowSelectionMulti = function () {
        return this.gridOptions.rowSelection === 'multiple';
    };
    GridOptionsWrapper.prototype.isRowMultiSelectWithClick = function () {
        return isTrue(this.gridOptions.rowMultiSelectWithClick);
    };
    GridOptionsWrapper.prototype.getContext = function () {
        return this.gridOptions.context;
    };
    GridOptionsWrapper.prototype.isPivotMode = function () {
        return isTrue(this.gridOptions.pivotMode);
    };
    GridOptionsWrapper.prototype.isSuppressExpandablePivotGroups = function () {
        return isTrue(this.gridOptions.suppressExpandablePivotGroups);
    };
    GridOptionsWrapper.prototype.getPivotColumnGroupTotals = function () {
        return this.gridOptions.pivotColumnGroupTotals;
    };
    GridOptionsWrapper.prototype.getPivotRowTotals = function () {
        return this.gridOptions.pivotRowTotals;
    };
    GridOptionsWrapper.prototype.isRowModelInfinite = function () {
        return this.gridOptions.rowModelType === _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_INFINITE;
    };
    GridOptionsWrapper.prototype.isRowModelViewport = function () {
        return this.gridOptions.rowModelType === _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_VIEWPORT;
    };
    GridOptionsWrapper.prototype.isRowModelServerSide = function () {
        return this.gridOptions.rowModelType === _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_SERVER_SIDE;
    };
    GridOptionsWrapper.prototype.isRowModelDefault = function () {
        return (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["missing"])(this.gridOptions.rowModelType) ||
            this.gridOptions.rowModelType === _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].ROW_MODEL_TYPE_CLIENT_SIDE);
    };
    GridOptionsWrapper.prototype.isFullRowEdit = function () {
        return this.gridOptions.editType === 'fullRow';
    };
    GridOptionsWrapper.prototype.isSuppressFocusAfterRefresh = function () {
        return isTrue(this.gridOptions.suppressFocusAfterRefresh);
    };
    GridOptionsWrapper.prototype.isSuppressBrowserResizeObserver = function () {
        return isTrue(this.gridOptions.suppressBrowserResizeObserver);
    };
    GridOptionsWrapper.prototype.isSuppressMaintainUnsortedOrder = function () {
        return isTrue(this.gridOptions.suppressMaintainUnsortedOrder);
    };
    GridOptionsWrapper.prototype.isSuppressClearOnFillReduction = function () {
        return isTrue(this.gridOptions.suppressClearOnFillReduction);
    };
    GridOptionsWrapper.prototype.isShowToolPanel = function () {
        return isTrue(this.gridOptions.sideBar && Array.isArray(this.getSideBar().toolPanels));
    };
    GridOptionsWrapper.prototype.getSideBar = function () {
        return this.gridOptions.sideBar;
    };
    GridOptionsWrapper.prototype.isSuppressTouch = function () {
        return isTrue(this.gridOptions.suppressTouch);
    };
    GridOptionsWrapper.prototype.isMaintainColumnOrder = function () {
        return isTrue(this.gridOptions.maintainColumnOrder);
    };
    GridOptionsWrapper.prototype.isSuppressRowTransform = function () {
        return isTrue(this.gridOptions.suppressRowTransform);
    };
    GridOptionsWrapper.prototype.isSuppressColumnStateEvents = function () {
        return isTrue(this.gridOptions.suppressColumnStateEvents);
    };
    GridOptionsWrapper.prototype.isAllowDragFromColumnsToolPanel = function () {
        return isTrue(this.gridOptions.allowDragFromColumnsToolPanel);
    };
    GridOptionsWrapper.prototype.useAsyncEvents = function () {
        return !isTrue(this.gridOptions.suppressAsyncEvents);
    };
    GridOptionsWrapper.prototype.isEnableCellChangeFlash = function () {
        return isTrue(this.gridOptions.enableCellChangeFlash);
    };
    GridOptionsWrapper.prototype.getCellFlashDelay = function () {
        return this.gridOptions.cellFlashDelay || 500;
    };
    GridOptionsWrapper.prototype.getCellFadeDelay = function () {
        return this.gridOptions.cellFadeDelay || 1000;
    };
    GridOptionsWrapper.prototype.isGroupSelectsChildren = function () {
        var result = isTrue(this.gridOptions.groupSelectsChildren);
        if (result && this.isTreeData()) {
            console.warn('AG Grid: groupSelectsChildren does not work with tree data');
            return false;
        }
        return result;
    };
    GridOptionsWrapper.prototype.isSuppressRowHoverHighlight = function () {
        return isTrue(this.gridOptions.suppressRowHoverHighlight);
    };
    GridOptionsWrapper.prototype.isColumnHoverHighlight = function () {
        return isTrue(this.gridOptions.columnHoverHighlight);
    };
    GridOptionsWrapper.prototype.isGroupSelectsFiltered = function () {
        return isTrue(this.gridOptions.groupSelectsFiltered);
    };
    GridOptionsWrapper.prototype.isGroupHideOpenParents = function () {
        return isTrue(this.gridOptions.groupHideOpenParents);
    };
    GridOptionsWrapper.prototype.isGroupMaintainOrder = function () {
        return isTrue(this.gridOptions.groupMaintainOrder);
    };
    GridOptionsWrapper.prototype.getAutoGroupColumnDef = function () {
        return this.gridOptions.autoGroupColumnDef;
    };
    GridOptionsWrapper.prototype.isGroupMultiAutoColumn = function () {
        if (this.gridOptions.groupDisplayType) {
            return this.matchesGroupDisplayType('multipleColumns', this.gridOptions.groupDisplayType);
        }
        // if we are doing hideOpenParents we also show multiple columns, otherwise hideOpenParents would not work
        return isTrue(this.gridOptions.groupHideOpenParents);
    };
    GridOptionsWrapper.prototype.isGroupUseEntireRow = function (pivotMode) {
        // we never allow groupUseEntireRow if in pivot mode, otherwise we won't see the pivot values.
        if (pivotMode) {
            return false;
        }
        return this.gridOptions.groupDisplayType ?
            this.matchesGroupDisplayType('groupRows', this.gridOptions.groupDisplayType) : false;
    };
    GridOptionsWrapper.prototype.isGroupSuppressAutoColumn = function () {
        var isCustomRowGroups = this.gridOptions.groupDisplayType ?
            this.matchesGroupDisplayType('custom', this.gridOptions.groupDisplayType) : false;
        if (isCustomRowGroups) {
            return true;
        }
        return this.gridOptions.treeDataDisplayType ?
            this.matchesTreeDataDisplayType('custom', this.gridOptions.treeDataDisplayType) : false;
    };
    GridOptionsWrapper.prototype.isGroupRemoveSingleChildren = function () {
        return isTrue(this.gridOptions.groupRemoveSingleChildren);
    };
    GridOptionsWrapper.prototype.isGroupRemoveLowestSingleChildren = function () {
        return isTrue(this.gridOptions.groupRemoveLowestSingleChildren);
    };
    GridOptionsWrapper.prototype.isGroupIncludeFooter = function () {
        return isTrue(this.gridOptions.groupIncludeFooter);
    };
    GridOptionsWrapper.prototype.isGroupIncludeTotalFooter = function () {
        return isTrue(this.gridOptions.groupIncludeTotalFooter);
    };
    GridOptionsWrapper.prototype.isGroupSuppressBlankHeader = function () {
        return isTrue(this.gridOptions.groupSuppressBlankHeader);
    };
    GridOptionsWrapper.prototype.isSuppressRowClickSelection = function () {
        return isTrue(this.gridOptions.suppressRowClickSelection);
    };
    GridOptionsWrapper.prototype.isSuppressCellSelection = function () {
        return isTrue(this.gridOptions.suppressCellSelection);
    };
    GridOptionsWrapper.prototype.isSuppressMultiSort = function () {
        return isTrue(this.gridOptions.suppressMultiSort);
    };
    GridOptionsWrapper.prototype.isMultiSortKeyCtrl = function () {
        return this.gridOptions.multiSortKey === 'ctrl';
    };
    GridOptionsWrapper.prototype.isPivotSuppressAutoColumn = function () {
        return isTrue(this.gridOptions.pivotSuppressAutoColumn);
    };
    GridOptionsWrapper.prototype.isSuppressDragLeaveHidesColumns = function () {
        return isTrue(this.gridOptions.suppressDragLeaveHidesColumns);
    };
    GridOptionsWrapper.prototype.isSuppressScrollOnNewData = function () {
        return isTrue(this.gridOptions.suppressScrollOnNewData);
    };
    GridOptionsWrapper.prototype.isSuppressScrollWhenPopupsAreOpen = function () {
        return isTrue(this.gridOptions.suppressScrollWhenPopupsAreOpen);
    };
    GridOptionsWrapper.prototype.isRowDragEntireRow = function () {
        return isTrue(this.gridOptions.rowDragEntireRow);
    };
    GridOptionsWrapper.prototype.isSuppressRowDrag = function () {
        return isTrue(this.gridOptions.suppressRowDrag);
    };
    GridOptionsWrapper.prototype.isRowDragManaged = function () {
        return isTrue(this.gridOptions.rowDragManaged);
    };
    GridOptionsWrapper.prototype.isSuppressMoveWhenRowDragging = function () {
        return isTrue(this.gridOptions.suppressMoveWhenRowDragging);
    };
    GridOptionsWrapper.prototype.isRowDragMultiRow = function () {
        return isTrue(this.gridOptions.rowDragMultiRow);
    };
    // returns either 'print', 'autoHeight' or 'normal' (normal is the default)
    GridOptionsWrapper.prototype.getDomLayout = function () {
        var domLayout = this.gridOptions.domLayout || _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_NORMAL;
        var validLayouts = [
            _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_PRINT,
            _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_AUTO_HEIGHT,
            _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_NORMAL
        ];
        if (validLayouts.indexOf(domLayout) === -1) {
            Object(_utils_function__WEBPACK_IMPORTED_MODULE_14__["doOnce"])(function () {
                return console.warn("AG Grid: " + domLayout + " is not valid for DOM Layout, valid values are " + _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_NORMAL + ", " + _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_AUTO_HEIGHT + " and " + _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_PRINT);
            }, 'warn about dom layout values');
            return _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].DOM_LAYOUT_NORMAL;
        }
        return domLayout;
    };
    GridOptionsWrapper.prototype.isSuppressHorizontalScroll = function () {
        return isTrue(this.gridOptions.suppressHorizontalScroll);
    };
    GridOptionsWrapper.prototype.isSuppressMaxRenderedRowRestriction = function () {
        return isTrue(this.gridOptions.suppressMaxRenderedRowRestriction);
    };
    GridOptionsWrapper.prototype.isExcludeChildrenWhenTreeDataFiltering = function () {
        return isTrue(this.gridOptions.excludeChildrenWhenTreeDataFiltering);
    };
    GridOptionsWrapper.prototype.isAlwaysShowHorizontalScroll = function () {
        return isTrue(this.gridOptions.alwaysShowHorizontalScroll);
    };
    GridOptionsWrapper.prototype.isAlwaysShowVerticalScroll = function () {
        return isTrue(this.gridOptions.alwaysShowVerticalScroll);
    };
    GridOptionsWrapper.prototype.isDebounceVerticalScrollbar = function () {
        return isTrue(this.gridOptions.debounceVerticalScrollbar);
    };
    GridOptionsWrapper.prototype.isSuppressLoadingOverlay = function () {
        return isTrue(this.gridOptions.suppressLoadingOverlay);
    };
    GridOptionsWrapper.prototype.isSuppressNoRowsOverlay = function () {
        return isTrue(this.gridOptions.suppressNoRowsOverlay);
    };
    GridOptionsWrapper.prototype.isSuppressFieldDotNotation = function () {
        return isTrue(this.gridOptions.suppressFieldDotNotation);
    };
    GridOptionsWrapper.prototype.getPinnedTopRowData = function () {
        return this.gridOptions.pinnedTopRowData;
    };
    GridOptionsWrapper.prototype.getPinnedBottomRowData = function () {
        return this.gridOptions.pinnedBottomRowData;
    };
    GridOptionsWrapper.prototype.isFunctionsPassive = function () {
        return isTrue(this.gridOptions.functionsPassive);
    };
    GridOptionsWrapper.prototype.isSuppressChangeDetection = function () {
        return isTrue(this.gridOptions.suppressChangeDetection);
    };
    GridOptionsWrapper.prototype.isSuppressAnimationFrame = function () {
        return isTrue(this.gridOptions.suppressAnimationFrame);
    };
    GridOptionsWrapper.prototype.getQuickFilterText = function () {
        return this.gridOptions.quickFilterText;
    };
    GridOptionsWrapper.prototype.isCacheQuickFilter = function () {
        return isTrue(this.gridOptions.cacheQuickFilter);
    };
    GridOptionsWrapper.prototype.isUnSortIcon = function () {
        return isTrue(this.gridOptions.unSortIcon);
    };
    GridOptionsWrapper.prototype.isSuppressMenuHide = function () {
        return isTrue(this.gridOptions.suppressMenuHide);
    };
    GridOptionsWrapper.prototype.isEnterMovesDownAfterEdit = function () {
        return isTrue(this.gridOptions.enterMovesDownAfterEdit);
    };
    GridOptionsWrapper.prototype.isEnterMovesDown = function () {
        return isTrue(this.gridOptions.enterMovesDown);
    };
    GridOptionsWrapper.prototype.isUndoRedoCellEditing = function () {
        return isTrue(this.gridOptions.undoRedoCellEditing);
    };
    GridOptionsWrapper.prototype.getUndoRedoCellEditingLimit = function () {
        return toNumber(this.gridOptions.undoRedoCellEditingLimit);
    };
    GridOptionsWrapper.prototype.getRowStyle = function () {
        return this.gridOptions.rowStyle;
    };
    GridOptionsWrapper.prototype.getRowClass = function () {
        return this.gridOptions.rowClass;
    };
    GridOptionsWrapper.prototype.getRowStyleFunc = function () {
        return this.gridOptions.getRowStyle;
    };
    GridOptionsWrapper.prototype.getRowClassFunc = function () {
        return this.gridOptions.getRowClass;
    };
    GridOptionsWrapper.prototype.rowClassRules = function () {
        return this.gridOptions.rowClassRules;
    };
    GridOptionsWrapper.prototype.getServerSideStoreType = function () {
        return this.gridOptions.serverSideStoreType;
    };
    GridOptionsWrapper.prototype.getServerSideStoreParamsFunc = function () {
        return this.gridOptions.getServerSideStoreParams;
    };
    GridOptionsWrapper.prototype.getCreateChartContainerFunc = function () {
        return this.gridOptions.createChartContainer;
    };
    GridOptionsWrapper.prototype.getPopupParent = function () {
        return this.gridOptions.popupParent;
    };
    GridOptionsWrapper.prototype.getBlockLoadDebounceMillis = function () {
        return this.gridOptions.blockLoadDebounceMillis;
    };
    GridOptionsWrapper.prototype.getPostProcessPopupFunc = function () {
        return this.gridOptions.postProcessPopup;
    };
    GridOptionsWrapper.prototype.getPaginationNumberFormatterFunc = function () {
        return this.gridOptions.paginationNumberFormatter;
    };
    GridOptionsWrapper.prototype.getChildCountFunc = function () {
        return this.gridOptions.getChildCount;
    };
    GridOptionsWrapper.prototype.getIsApplyServerSideTransactionFunc = function () {
        return this.gridOptions.isApplyServerSideTransaction;
    };
    GridOptionsWrapper.prototype.getDefaultGroupOrderComparator = function () {
        return this.gridOptions.defaultGroupOrderComparator;
    };
    GridOptionsWrapper.prototype.getIsFullWidthCellFunc = function () {
        return this.gridOptions.isFullWidthCell;
    };
    GridOptionsWrapper.prototype.getFullWidthCellRendererParams = function () {
        return this.gridOptions.fullWidthCellRendererParams;
    };
    GridOptionsWrapper.prototype.isEmbedFullWidthRows = function () {
        return isTrue(this.gridOptions.embedFullWidthRows) || isTrue(this.gridOptions.deprecatedEmbedFullWidthRows);
    };
    GridOptionsWrapper.prototype.isDetailRowAutoHeight = function () {
        return isTrue(this.gridOptions.detailRowAutoHeight);
    };
    GridOptionsWrapper.prototype.getSuppressKeyboardEventFunc = function () {
        return this.gridOptions.suppressKeyboardEvent;
    };
    GridOptionsWrapper.prototype.getBusinessKeyForNodeFunc = function () {
        return this.gridOptions.getBusinessKeyForNode;
    };
    GridOptionsWrapper.prototype.getApi = function () {
        return this.gridOptions.api;
    };
    GridOptionsWrapper.prototype.getColumnApi = function () {
        return this.gridOptions.columnApi;
    };
    GridOptionsWrapper.prototype.isImmutableData = function () {
        return isTrue(this.gridOptions.immutableData);
    };
    GridOptionsWrapper.prototype.isEnsureDomOrder = function () {
        return isTrue(this.gridOptions.ensureDomOrder);
    };
    GridOptionsWrapper.prototype.isEnableCharts = function () {
        if (isTrue(this.gridOptions.enableCharts)) {
            return _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_10__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_8__[/* ModuleNames */ "a"].GridChartsModule, 'enableCharts');
        }
        return false;
    };
    GridOptionsWrapper.prototype.getColResizeDefault = function () {
        return this.gridOptions.colResizeDefault;
    };
    GridOptionsWrapper.prototype.isSingleClickEdit = function () {
        return isTrue(this.gridOptions.singleClickEdit);
    };
    GridOptionsWrapper.prototype.isSuppressClickEdit = function () {
        return isTrue(this.gridOptions.suppressClickEdit);
    };
    GridOptionsWrapper.prototype.isStopEditingWhenCellsLoseFocus = function () {
        return isTrue(this.gridOptions.stopEditingWhenCellsLoseFocus);
    };
    GridOptionsWrapper.prototype.getGroupDefaultExpanded = function () {
        return this.gridOptions.groupDefaultExpanded;
    };
    GridOptionsWrapper.prototype.getMaxConcurrentDatasourceRequests = function () {
        return this.gridOptions.maxConcurrentDatasourceRequests;
    };
    GridOptionsWrapper.prototype.getMaxBlocksInCache = function () {
        return this.gridOptions.maxBlocksInCache;
    };
    GridOptionsWrapper.prototype.getCacheOverflowSize = function () {
        return this.gridOptions.cacheOverflowSize;
    };
    GridOptionsWrapper.prototype.getPaginationPageSize = function () {
        return toNumber(this.gridOptions.paginationPageSize);
    };
    GridOptionsWrapper.prototype.isPaginateChildRows = function () {
        var shouldPaginate = this.isGroupRemoveSingleChildren() || this.isGroupRemoveLowestSingleChildren();
        if (shouldPaginate) {
            return true;
        }
        return isTrue(this.gridOptions.paginateChildRows);
    };
    GridOptionsWrapper.prototype.getCacheBlockSize = function () {
        return oneOrGreater(this.gridOptions.cacheBlockSize);
    };
    GridOptionsWrapper.prototype.getInfiniteInitialRowCount = function () {
        return this.gridOptions.infiniteInitialRowCount;
    };
    GridOptionsWrapper.prototype.isPurgeClosedRowNodes = function () {
        return isTrue(this.gridOptions.purgeClosedRowNodes);
    };
    GridOptionsWrapper.prototype.isSuppressPaginationPanel = function () {
        return isTrue(this.gridOptions.suppressPaginationPanel);
    };
    GridOptionsWrapper.prototype.getRowData = function () {
        return this.gridOptions.rowData;
    };
    GridOptionsWrapper.prototype.isEnableRtl = function () {
        return isTrue(this.gridOptions.enableRtl);
    };
    GridOptionsWrapper.prototype.getRowGroupPanelShow = function () {
        return this.gridOptions.rowGroupPanelShow;
    };
    GridOptionsWrapper.prototype.getPivotPanelShow = function () {
        return this.gridOptions.pivotPanelShow;
    };
    GridOptionsWrapper.prototype.isAngularCompileRows = function () {
        return isTrue(this.gridOptions.angularCompileRows);
    };
    GridOptionsWrapper.prototype.isAngularCompileFilters = function () {
        return isTrue(this.gridOptions.angularCompileFilters);
    };
    GridOptionsWrapper.prototype.isDebug = function () {
        return isTrue(this.gridOptions.debug);
    };
    GridOptionsWrapper.prototype.getColumnDefs = function () {
        return this.gridOptions.columnDefs;
    };
    GridOptionsWrapper.prototype.getColumnTypes = function () {
        return this.gridOptions.columnTypes;
    };
    GridOptionsWrapper.prototype.getDatasource = function () {
        return this.gridOptions.datasource;
    };
    GridOptionsWrapper.prototype.getViewportDatasource = function () {
        return this.gridOptions.viewportDatasource;
    };
    GridOptionsWrapper.prototype.getServerSideDatasource = function () {
        return this.gridOptions.serverSideDatasource;
    };
    GridOptionsWrapper.prototype.isAccentedSort = function () {
        return isTrue(this.gridOptions.accentedSort);
    };
    GridOptionsWrapper.prototype.isEnableBrowserTooltips = function () {
        return isTrue(this.gridOptions.enableBrowserTooltips);
    };
    GridOptionsWrapper.prototype.isEnableCellExpressions = function () {
        return isTrue(this.gridOptions.enableCellExpressions);
    };
    GridOptionsWrapper.prototype.isEnableGroupEdit = function () {
        return isTrue(this.gridOptions.enableGroupEdit);
    };
    GridOptionsWrapper.prototype.isSuppressMiddleClickScrolls = function () {
        return isTrue(this.gridOptions.suppressMiddleClickScrolls);
    };
    GridOptionsWrapper.prototype.isPreventDefaultOnContextMenu = function () {
        return isTrue(this.gridOptions.preventDefaultOnContextMenu);
    };
    GridOptionsWrapper.prototype.isSuppressPreventDefaultOnMouseWheel = function () {
        return isTrue(this.gridOptions.suppressPreventDefaultOnMouseWheel);
    };
    GridOptionsWrapper.prototype.isSuppressColumnVirtualisation = function () {
        return isTrue(this.gridOptions.suppressColumnVirtualisation);
    };
    GridOptionsWrapper.prototype.isSuppressContextMenu = function () {
        return isTrue(this.gridOptions.suppressContextMenu);
    };
    GridOptionsWrapper.prototype.isAllowContextMenuWithControlKey = function () {
        return isTrue(this.gridOptions.allowContextMenuWithControlKey);
    };
    GridOptionsWrapper.prototype.isSuppressCopyRowsToClipboard = function () {
        return isTrue(this.gridOptions.suppressCopyRowsToClipboard);
    };
    GridOptionsWrapper.prototype.isCopyHeadersToClipboard = function () {
        return isTrue(this.gridOptions.copyHeadersToClipboard);
    };
    GridOptionsWrapper.prototype.isSuppressClipboardPaste = function () {
        return isTrue(this.gridOptions.suppressClipboardPaste);
    };
    GridOptionsWrapper.prototype.isSuppressLastEmptyLineOnPaste = function () {
        return isTrue(this.gridOptions.suppressLastEmptyLineOnPaste);
    };
    GridOptionsWrapper.prototype.isPagination = function () {
        return isTrue(this.gridOptions.pagination);
    };
    GridOptionsWrapper.prototype.isSuppressEnterpriseResetOnNewColumns = function () {
        return isTrue(this.gridOptions.suppressEnterpriseResetOnNewColumns);
    };
    GridOptionsWrapper.prototype.getProcessDataFromClipboardFunc = function () {
        return this.gridOptions.processDataFromClipboard;
    };
    GridOptionsWrapper.prototype.getAsyncTransactionWaitMillis = function () {
        return Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["exists"])(this.gridOptions.asyncTransactionWaitMillis) ? this.gridOptions.asyncTransactionWaitMillis : _constants_constants__WEBPACK_IMPORTED_MODULE_1__[/* Constants */ "a"].BATCH_WAIT_MILLIS;
    };
    GridOptionsWrapper.prototype.isSuppressMovableColumns = function () {
        return isTrue(this.gridOptions.suppressMovableColumns);
    };
    GridOptionsWrapper.prototype.isAnimateRows = function () {
        // never allow animating if enforcing the row order
        if (this.isEnsureDomOrder()) {
            return false;
        }
        return isTrue(this.gridOptions.animateRows);
    };
    GridOptionsWrapper.prototype.isSuppressColumnMoveAnimation = function () {
        return isTrue(this.gridOptions.suppressColumnMoveAnimation);
    };
    GridOptionsWrapper.prototype.isSuppressAggFuncInHeader = function () {
        return isTrue(this.gridOptions.suppressAggFuncInHeader);
    };
    GridOptionsWrapper.prototype.isSuppressAggAtRootLevel = function () {
        return isTrue(this.gridOptions.suppressAggAtRootLevel);
    };
    GridOptionsWrapper.prototype.isSuppressAggFilteredOnly = function () {
        return isTrue(this.gridOptions.suppressAggFilteredOnly);
    };
    GridOptionsWrapper.prototype.isShowOpenedGroup = function () {
        return isTrue(this.gridOptions.showOpenedGroup);
    };
    GridOptionsWrapper.prototype.isEnableRangeSelection = function () {
        return _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_10__[/* ModuleRegistry */ "a"].isRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_8__[/* ModuleNames */ "a"].RangeSelectionModule) && isTrue(this.gridOptions.enableRangeSelection);
    };
    GridOptionsWrapper.prototype.isEnableRangeHandle = function () {
        return isTrue(this.gridOptions.enableRangeHandle);
    };
    GridOptionsWrapper.prototype.isEnableFillHandle = function () {
        return isTrue(this.gridOptions.enableFillHandle);
    };
    GridOptionsWrapper.prototype.getFillHandleDirection = function () {
        var direction = this.gridOptions.fillHandleDirection;
        if (!direction) {
            return 'xy';
        }
        if (direction !== 'x' && direction !== 'y' && direction !== 'xy') {
            Object(_utils_function__WEBPACK_IMPORTED_MODULE_14__["doOnce"])(function () { return console.warn("AG Grid: valid values for fillHandleDirection are 'x', 'y' and 'xy'. Default to 'xy'."); }, 'warn invalid fill direction');
            return 'xy';
        }
        return direction;
    };
    GridOptionsWrapper.prototype.getFillOperation = function () {
        return this.gridOptions.fillOperation;
    };
    GridOptionsWrapper.prototype.isSuppressMultiRangeSelection = function () {
        return isTrue(this.gridOptions.suppressMultiRangeSelection);
    };
    GridOptionsWrapper.prototype.isPaginationAutoPageSize = function () {
        return isTrue(this.gridOptions.paginationAutoPageSize);
    };
    GridOptionsWrapper.prototype.isRememberGroupStateWhenNewData = function () {
        return isTrue(this.gridOptions.rememberGroupStateWhenNewData);
    };
    GridOptionsWrapper.prototype.getIcons = function () {
        return this.gridOptions.icons;
    };
    GridOptionsWrapper.prototype.getAggFuncs = function () {
        return this.gridOptions.aggFuncs;
    };
    GridOptionsWrapper.prototype.getSortingOrder = function () {
        return this.gridOptions.sortingOrder;
    };
    GridOptionsWrapper.prototype.getAlignedGrids = function () {
        return this.gridOptions.alignedGrids;
    };
    GridOptionsWrapper.prototype.isMasterDetail = function () {
        var masterDetail = isTrue(this.gridOptions.masterDetail);
        if (masterDetail) {
            return _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_10__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_8__[/* ModuleNames */ "a"].MasterDetailModule, 'masterDetail');
        }
        else {
            return false;
        }
    };
    GridOptionsWrapper.prototype.isKeepDetailRows = function () {
        return isTrue(this.gridOptions.keepDetailRows);
    };
    GridOptionsWrapper.prototype.getKeepDetailRowsCount = function () {
        var keepDetailRowsCount = this.gridOptions.keepDetailRowsCount;
        if (Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["exists"])(keepDetailRowsCount) && keepDetailRowsCount > 0) {
            return this.gridOptions.keepDetailRowsCount;
        }
        return DEFAULT_KEEP_DETAIL_ROW_COUNT;
    };
    GridOptionsWrapper.prototype.getIsRowMasterFunc = function () {
        return this.gridOptions.isRowMaster;
    };
    GridOptionsWrapper.prototype.getIsRowSelectableFunc = function () {
        return this.gridOptions.isRowSelectable;
    };
    GridOptionsWrapper.prototype.getGroupRowRendererParams = function () {
        return this.gridOptions.groupRowRendererParams;
    };
    GridOptionsWrapper.prototype.getOverlayLoadingTemplate = function () {
        return this.gridOptions.overlayLoadingTemplate;
    };
    GridOptionsWrapper.prototype.getOverlayNoRowsTemplate = function () {
        return this.gridOptions.overlayNoRowsTemplate;
    };
    GridOptionsWrapper.prototype.isSuppressAutoSize = function () {
        return isTrue(this.gridOptions.suppressAutoSize);
    };
    GridOptionsWrapper.prototype.isEnableCellTextSelection = function () {
        return isTrue(this.gridOptions.enableCellTextSelection);
    };
    GridOptionsWrapper.prototype.isSuppressParentsInRowNodes = function () {
        return isTrue(this.gridOptions.suppressParentsInRowNodes);
    };
    GridOptionsWrapper.prototype.isSuppressClipboardApi = function () {
        return isTrue(this.gridOptions.suppressClipboardApi);
    };
    GridOptionsWrapper.prototype.isFunctionsReadOnly = function () {
        return isTrue(this.gridOptions.functionsReadOnly);
    };
    GridOptionsWrapper.prototype.isFloatingFilter = function () {
        return this.gridOptions.floatingFilter;
    };
    GridOptionsWrapper.prototype.isEnableCellTextSelect = function () {
        return isTrue(this.gridOptions.enableCellTextSelection);
    };
    GridOptionsWrapper.prototype.isEnableOldSetFilterModel = function () {
        return isTrue(this.gridOptions.enableOldSetFilterModel);
    };
    GridOptionsWrapper.prototype.getDefaultColDef = function () {
        return this.gridOptions.defaultColDef;
    };
    GridOptionsWrapper.prototype.getDefaultColGroupDef = function () {
        return this.gridOptions.defaultColGroupDef;
    };
    GridOptionsWrapper.prototype.getDefaultExportParams = function (type) {
        if (this.gridOptions.defaultExportParams) {
            console.warn("AG Grid: Since v25.2 `defaultExportParams`  has been replaced by `default" + Object(_utils_string__WEBPACK_IMPORTED_MODULE_16__["capitalise"])(type) + "ExportParams`'");
            if (type === 'csv') {
                return this.gridOptions.defaultExportParams;
            }
            return this.gridOptions.defaultExportParams;
        }
        if (type === 'csv' && this.gridOptions.defaultCsvExportParams) {
            return this.gridOptions.defaultCsvExportParams;
        }
        if (type === 'excel' && this.gridOptions.defaultExcelExportParams) {
            return this.gridOptions.defaultExcelExportParams;
        }
    };
    GridOptionsWrapper.prototype.isSuppressCsvExport = function () {
        return isTrue(this.gridOptions.suppressCsvExport);
    };
    GridOptionsWrapper.prototype.isAllowShowChangeAfterFilter = function () {
        return isTrue(this.gridOptions.allowShowChangeAfterFilter);
    };
    GridOptionsWrapper.prototype.isSuppressExcelExport = function () {
        return isTrue(this.gridOptions.suppressExcelExport);
    };
    GridOptionsWrapper.prototype.isSuppressMakeColumnVisibleAfterUnGroup = function () {
        return isTrue(this.gridOptions.suppressMakeColumnVisibleAfterUnGroup);
    };
    GridOptionsWrapper.prototype.getDataPathFunc = function () {
        return this.gridOptions.getDataPath;
    };
    GridOptionsWrapper.prototype.getIsServerSideGroupFunc = function () {
        return this.gridOptions.isServerSideGroup;
    };
    GridOptionsWrapper.prototype.getIsServerSideGroupOpenByDefaultFunc = function () {
        return this.gridOptions.isServerSideGroupOpenByDefault;
    };
    GridOptionsWrapper.prototype.getIsGroupOpenByDefaultFunc = function () {
        return this.gridOptions.isGroupOpenByDefault;
    };
    GridOptionsWrapper.prototype.getServerSideGroupKeyFunc = function () {
        return this.gridOptions.getServerSideGroupKey;
    };
    GridOptionsWrapper.prototype.getGroupRowAggNodesFunc = function () {
        return this.gridOptions.groupRowAggNodes;
    };
    GridOptionsWrapper.prototype.getContextMenuItemsFunc = function () {
        return this.gridOptions.getContextMenuItems;
    };
    GridOptionsWrapper.prototype.getMainMenuItemsFunc = function () {
        return this.gridOptions.getMainMenuItems;
    };
    GridOptionsWrapper.prototype.getRowNodeIdFunc = function () {
        return this.gridOptions.getRowNodeId;
    };
    GridOptionsWrapper.prototype.getNavigateToNextHeaderFunc = function () {
        return this.gridOptions.navigateToNextHeader;
    };
    GridOptionsWrapper.prototype.getTabToNextHeaderFunc = function () {
        return this.gridOptions.tabToNextHeader;
    };
    GridOptionsWrapper.prototype.getNavigateToNextCellFunc = function () {
        return this.gridOptions.navigateToNextCell;
    };
    GridOptionsWrapper.prototype.getTabToNextCellFunc = function () {
        return this.gridOptions.tabToNextCell;
    };
    GridOptionsWrapper.prototype.getGridTabIndex = function () {
        return (this.gridOptions.tabIndex || 0).toString();
    };
    GridOptionsWrapper.prototype.isTreeData = function () {
        var usingTreeData = isTrue(this.gridOptions.treeData);
        if (usingTreeData) {
            return _modules_moduleRegistry__WEBPACK_IMPORTED_MODULE_10__[/* ModuleRegistry */ "a"].assertRegistered(_modules_moduleNames__WEBPACK_IMPORTED_MODULE_8__[/* ModuleNames */ "a"].RowGroupingModule, 'Tree Data');
        }
        return false;
    };
    GridOptionsWrapper.prototype.isValueCache = function () {
        return isTrue(this.gridOptions.valueCache);
    };
    GridOptionsWrapper.prototype.isValueCacheNeverExpires = function () {
        return isTrue(this.gridOptions.valueCacheNeverExpires);
    };
    GridOptionsWrapper.prototype.isDeltaSort = function () {
        return isTrue(this.gridOptions.deltaSort);
    };
    GridOptionsWrapper.prototype.isAggregateOnlyChangedColumns = function () {
        return isTrue(this.gridOptions.aggregateOnlyChangedColumns);
    };
    GridOptionsWrapper.prototype.getProcessSecondaryColDefFunc = function () {
        return this.gridOptions.processSecondaryColDef;
    };
    GridOptionsWrapper.prototype.getProcessSecondaryColGroupDefFunc = function () {
        return this.gridOptions.processSecondaryColGroupDef;
    };
    GridOptionsWrapper.prototype.getSendToClipboardFunc = function () {
        return this.gridOptions.sendToClipboard;
    };
    GridOptionsWrapper.prototype.getProcessRowPostCreateFunc = function () {
        return this.gridOptions.processRowPostCreate;
    };
    GridOptionsWrapper.prototype.getProcessCellForClipboardFunc = function () {
        return this.gridOptions.processCellForClipboard;
    };
    GridOptionsWrapper.prototype.getProcessHeaderForClipboardFunc = function () {
        return this.gridOptions.processHeaderForClipboard;
    };
    GridOptionsWrapper.prototype.getProcessCellFromClipboardFunc = function () {
        return this.gridOptions.processCellFromClipboard;
    };
    GridOptionsWrapper.prototype.getViewportRowModelPageSize = function () {
        return oneOrGreater(this.gridOptions.viewportRowModelPageSize, DEFAULT_VIEWPORT_ROW_MODEL_PAGE_SIZE);
    };
    GridOptionsWrapper.prototype.getViewportRowModelBufferSize = function () {
        return zeroOrGreater(this.gridOptions.viewportRowModelBufferSize, DEFAULT_VIEWPORT_ROW_MODEL_BUFFER_SIZE);
    };
    GridOptionsWrapper.prototype.isServerSideSortingAlwaysResets = function () {
        return isTrue(this.gridOptions.serverSideSortingAlwaysResets);
    };
    GridOptionsWrapper.prototype.isServerSideFilteringAlwaysResets = function () {
        return isTrue(this.gridOptions.serverSideFilteringAlwaysResets);
    };
    GridOptionsWrapper.prototype.getPostSortFunc = function () {
        return this.gridOptions.postSort;
    };
    GridOptionsWrapper.prototype.getChartToolbarItemsFunc = function () {
        return this.gridOptions.getChartToolbarItems;
    };
    GridOptionsWrapper.prototype.getChartThemeOverrides = function () {
        return this.gridOptions.chartThemeOverrides;
    };
    GridOptionsWrapper.prototype.getCustomChartThemes = function () {
        return this.gridOptions.customChartThemes;
    };
    GridOptionsWrapper.prototype.getChartThemes = function () {
        // return default themes if user hasn't supplied any
        return this.gridOptions.chartThemes || ['ag-default', 'ag-material', 'ag-pastel', 'ag-vivid', 'ag-solar'];
    };
    GridOptionsWrapper.prototype.getAllowProcessChartOptions = function () {
        return this.gridOptions.allowProcessChartOptions;
    };
    GridOptionsWrapper.prototype.getProcessChartOptionsFunc = function () {
        return this.gridOptions.processChartOptions;
    };
    GridOptionsWrapper.prototype.getClipboardDeliminator = function () {
        return Object(_utils_generic__WEBPACK_IMPORTED_MODULE_12__["exists"])(this.gridOptions.clipboardDeliminator) ? this.gridOptions.clipboardDeliminator : '\t';
    };
    GridOptionsWrapper.prototype.setProperty = function (key, value, force) {
        if (force === void 0) { force = false; }
        var gridOptionsNoType = this.gridOptions;
        var previousValue = gridOptionsNoType[key];
        if (force || previousValue !== value) {
            gridOptionsNoType[key] = value;
            var event_1 = {
                type: key,
                currentValue: value,
                previousValue: previousValue
            };
            this.propertyEventService.dispatchEvent(event_1);
        }
    };
    GridOptionsWrapper.prototype.addEventListener = function (key, listener) {
        this.propertyEventService.addEventListener(key, listener);
    };
    GridOptionsWrapper.prototype.removeEventListener = function (key, listener) {
        this.propertyEventService.removeEventListener(key, listener);
    };
    GridOptionsWrapper.prototype.isSkipHeaderOnAutoSize = function () {
        return !!this.gridOptions.skipHeaderOnAutoSize;
    };
    GridOptionsWrapper.prototype.getAutoSizePadding = function () {
        var value = this.gridOptions.autoSizePadding;
        return value != null && value >= 0 ? value : 20;
    };
    // properties
    GridOptionsWrapper.prototype.getHeaderHeight = function () {
        if (typeof this.gridOptions.headerHeight === 'number') {
            return this.gridOptions.headerHeight;
        }
        return this.getFromTheme(25, 'headerHeight');
    };
    GridOptionsWrapper.prototype.getFloatingFiltersHeight = function () {
        if (typeof this.gridOptions.floatingFiltersHeight === 'number') {
            return this.gridOptions.floatingFiltersHeight;
        }
        return this.getFromTheme(25, 'headerHeight');
    };
    GridOptionsWrapper.prototype.getGroupHeaderHeight = function () {
        if (typeof this.gridOptions.groupHeaderHeight === 'number') {
            return this.gridOptions.groupHeaderHeight;
        }
        return this.getHeaderHeight();
    };
    GridOptionsWrapper.prototype.getPivotHeaderHeight = function () {
        if (typeof this.gridOptions.pivotHeaderHeight === 'number') {
            return this.gridOptions.pivotHeaderHeight;
        }
        return this.getHeaderHeight();
    };
    GridOp