# Generated by Django 3.1.7 on 2021-03-21 10:45

from django.db import migrations, models
from django.db.models import Case, When, Q, Value as V, F


def transform_success_to_status(apps, schema_editor):
	db_alias = schema_editor.connection.alias
	Email = apps.get_model('django_email_log.Email')
	char_field = models.CharField(max_length=1)
	transform = Case(
		When(Q(success=True), then=V('s')),
		default=V('f'), output_field=char_field
	)
	Email.objects.using(db_alias).annotate(new_value=transform).update(status=F('new_value'))


def transform_status_to_success(apps, schema_editor):
	db_alias = schema_editor.connection.alias
	Email = apps.get_model('django_email_log.Email')
	bool_field = models.BooleanField()
	transform = Case(
		When(Q(status='f'), then=V(False)),
		default=V(True), output_field=bool_field
	)
	Email.objects.using(db_alias).annotate(new_value=transform).update(success=F('new_value'))


class Migration(migrations.Migration):

	dependencies = [
		('django_email_log', '0001_initial'),
	]

	operations = [
		migrations.AddField(
			model_name='email',
			name='readed',
			field=models.BooleanField(blank=True, db_index=True, default=False, verbose_name='readed'),
		),
		migrations.AddField(
			model_name='email',
			name='status',
			field=models.CharField(choices=[('p', 'Pending'), ('s', 'Success'), ('f', 'Fail'), ('r', 'Received')], db_index=True, default='p', max_length=1, verbose_name='status'),
		),
		migrations.RunPython(transform_success_to_status, transform_status_to_success),
		migrations.RemoveField(
			model_name='email',
			name='success',
		),
		migrations.AlterField(
			model_name='email',
			name='message_data',
			field=models.TextField(verbose_name='data'),
		),
		migrations.AlterField(
			model_name='email',
			name='message_data',
			field=models.BinaryField(),
		),
	]
