"""
----------------------------------------------
PythonToSW: A Python package that allows you to make Stormworks addons with Python.
https://github.com/Cuh4/PythonToSW
----------------------------------------------

Copyright (C) 2025 Cuh4

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

# // Imports
from enum import Enum

# // Main
__all__ = [
    "CallEnum",
    "CallbackEnum"
]

class CallbackEnum(Enum):
    """
    An enum for all the available callbacks in Stormworks.
    """
    
    ON_CLEAR_OIL_SPILL = "onClearOilSpill"
    ON_CREATE = "onCreate"
    ON_DESTROY = "onDestroy"
    ON_CUSTOM_COMMAND = "onCustomCommand"
    ON_CHAT_MESSAGE = "onChatMessage"
    ON_PLAYER_JOIN = "onPlayerJoin"
    ON_PLAYER_SIT = "onPlayerSit"
    ON_PLAYER_UNSIT = "onPlayerUnsit"
    ON_CHARACTER_SIT = "onCharacterSit"
    ON_CHARACTER_UNSIT = "onCharacterUnsit"
    ON_CHARACTER_PICKUP = "onCharacterPickup"
    ON_CREATURE_SIT = "onCreatureSit"
    ON_CREATURE_UNSIT = "onCreatureUnsit"
    ON_CREATURE_PICKUP = "onCreaturePickup"
    ON_EQUIPMENT_PICKUP = "onEquipmentPickup"
    ON_EQUIPMENT_DROP = "onEquipmentDrop"
    ON_PLAYER_RESPAWN = "onPlayerRespawn"
    ON_PLAYER_LEAVE = "onPlayerLeave"
    ON_TOGGLE_MAP = "onToggleMap"
    ON_PLAYER_DIE = "onPlayerDie"
    ON_VEHICLE_SPAWN = "onVehicleSpawn"
    ON_GROUP_SPAWN = "onGroupSpawn"
    ON_VEHICLE_DESPAWN = "onVehicleDespawn"
    ON_VEHICLE_LOAD = "onVehicleLoad"
    ON_VEHICLE_UNLOAD = "onVehicleUnload"
    ON_VEHICLE_TELEPORT = "onVehicleTeleport"
    ON_OBJECT_LOAD = "onObjectLoad"
    ON_OBJECT_UNLOAD = "onObjectUnload"
    ON_BUTTON_PRESS = "onButtonPress"
    ON_SPAWN_ADDON_COMPONENT = "onSpawnAddonComponent"
    ON_VEHICLE_DAMAGED = "onVehicleDamaged"
    ON_HTTP_REPLY = "httpReply"
    ON_FIRE_EXTINGUISHED = "onFireExtinguished"
    ON_FOREST_FIRE_SPAWNED = "onForestFireSpawned"
    ON_FOREST_FIRE_EXTINGUISHED = "onForestFireExtinguished"
    ON_TORNADO = "onTornado"
    ON_METEOR = "onMeteor"
    ON_TSUNAMI = "onTsunami"
    ON_WHIRLPOOL = "onWhirlpool"
    ON_VOLCANO = "onVolcano"
    ON_OIL_SPILL = "onOilSpill"

class CallEnum(Enum):
    """
    An enum for all the available server functions that can be called in Stormworks.
    """
    
    GET_ADDON_INDEX = "getAddonIndex"
    GET_PLAYLIST_INDEX_CURRENT = "getPlaylistIndexCurrent"
    GET_PLAYLIST_INDEX_BY_NAME = "getPlaylistIndexByName"
    GET_LOCATION_INDEX = "getLocationIndex"
    SPAWN_THIS_ADDON_LOCATION = "spawnThisAddonLocation"
    SPAWN_THIS_PLAYLIST_MISSION_LOCATION = "spawnThisPlaylistMissionLocation"
    SPAWN_NAMED_ADDON_LOCATION = "spawnNamedAddonLocation"
    SPAWN_ADDON_LOCATION = "spawnAddonLocation"
    SPAWN_MISSION_LOCATION = "spawnMissionLocation"
    GET_ADDON_PATH = "getAddonPath"
    GET_PLAYLIST_PATH = "getPlaylistPath"
    GET_ZONES = "getZones"
    IS_IN_ZONE = "isInZone"
    GET_ADDON_COUNT = "getAddonCount"
    GET_PLAYLIST_COUNT = "getPlaylistCount"
    GET_ADDON_DATA = "getAddonData"
    GET_PLAYLIST_DATA = "getPlaylistData"
    GET_LOCATION_DATA = "getLocationData"
    GET_LOCATION_COMPONENT_DATA = "getLocationComponentData"
    SPAWN_ADDON_COMPONENT = "spawnAddonComponent"
    SPAWN_MISSION_COMPONENT = "spawnMissionComponent"
    ANNOUNCE = "announce"
    COMMAND = "command"
    NOTIFY = "notify"
    GET_MAP_ID = "getMapID"
    REMOVE_MAP_ID = "removeMapID"
    ADD_MAP_OBJECT = "addMapObject"
    REMOVE_MAP_OBJECT = "removeMapObject"
    ADD_MAP_LABEL = "addMapLabel"
    REMOVE_MAP_LABEL = "removeMapLabel"
    ADD_MAP_LINE = "addMapLine"
    REMOVE_MAP_LINE = "removeMapLine"
    SET_POPUP = "setPopup"
    SET_POPUP_SCREEN = "setPopupScreen"
    REMOVE_POPUP = "removePopup"
    GET_PLAYERS = "getPlayers"
    GET_PLAYER_NAME = "getPlayerName"
    GET_PLAYER_POS = "getPlayerPos"
    SET_PLAYER_POS = "setPlayerPos"
    GET_PLAYER_LOOK_DIRECTION = "getPlayerLookDirection"
    GET_PLAYER_CHARACTER_ID = "getPlayerCharacterID"
    SPAWN_OBJECT = "spawnObject"
    SPAWN_FIRE = "spawnFire"
    SPAWN_CHARACTER = "spawnCharacter"
    SPAWN_ANIMAL = "spawnAnimal"
    SPAWN_CREATURE = "spawnCreature"
    SET_CREATURE_MOVE_TARGET = "setCreatureMoveTarget"
    SPAWN_EQUIPMENT = "spawnEquipment"
    DESPAWN_OBJECT = "despawnObject"
    GET_OBJECT_POS = "getObjectPos"
    GET_OBJECT_SIMULATING = "getObjectSimulating"
    SET_OBJECT_POS = "setObjectPos"
    SET_FIRE_DATA = "setFireData"
    GET_FIRE_DATA = "getFireData"
    KILL_CHARACTER = "killCharacter"
    REVIVE_CHARACTER = "reviveCharacter"
    SET_SEATED = "setSeated"
    SET_CHARACTER_SEATED = "setCharacterSeated"
    SET_CREATURE_SEATED = "setCreatureSeated"
    GET_OBJECT_DATA = "getObjectData"
    GET_CHARACTER_DATA = "getCharacterData"
    GET_CHARACTER_VEHICLE = "getCharacterVehicle"
    SET_CHARACTER_DATA = "setCharacterData"
    SET_CHARACTER_TOOLTIP = "setCharacterTooltip"
    SET_CREATURE_TOOLTIP = "setCreatureTooltip"
    SET_CHARACTER_ITEM = "setCharacterItem"
    GET_CHARACTER_ITEM = "getCharacterItem"
    SPAWN_ADDON_VEHICLE = "spawnAddonVehicle"
    SPAWN_VEHICLE = "spawnVehicle"
    SPAWN_VEHICLE_SAVE_FILE = "spawnVehicleSavefile"
    DESPAWN_VEHICLE = "despawnVehicle"
    IS_LOCATION_CLEAR = "isLocationClear"
    GET_VEHICLE_POS = "getVehiclePos"
    SET_VEHICLE_POS = "setVehiclePos"
    SET_VEHICLE_POS_SAFE = "setVehiclePosSafe"
    RESET_VEHICLE_STATE = "resetVehicleState"
    CLEAN_VEHICLES = "cleanVehicles"
    CLEAR_RADIATION = "clearRadiation"
    GET_VEHICLE_DATA = "getVehicleData"
    GET_VEHICLES_BY_NAME = "getVehiclesByName"
    GET_VEHICLE_COMPONENTS = "getVehicleComponents"
    GET_VEHICLE_GROUP = "getVehicleGroup"
    DESPAWN_VEHICLE_GROUP = "despawnVehicleGroup"
    SET_GROUP_POS = "setGroupPos"
    MOVE_GROUP = "moveGroup"
    MOVE_GROUP_SAFE = "moveGroupSafe"
    MOVE_VEHICLE = "moveVehicle"
    MOVE_VEHICLE_SAFE = "moveVehicleSafe"
    SET_GROUP_POS_SAFE = "setGroupPosSafe"
    GET_ASTROPOS = "getAstroPos"
    GET_VEHICLE_TANK = "getVehicleTank"
    GET_VEHICLE_SIGN = "getVehicleSign"
    GET_VEHICLE_SEAT = "getVehicleSeat"
    GET_VEHICLE_BUTTON = "getVehicleButton"
    GET_VEHICLE_DIAL = "getVehicleDial"
    GET_VEHICLE_BATTERY = "getVehicleBattery"
    GET_VEHICLE_HOPPER = "getVehicleHopper"
    GET_VEHICLE_WEAPON = "getVehicleWeapon"
    GET_VEHICLE_ROPE_HOOK = "getVehicleRopeHook"
    SET_VEHICLE_SEAT = "setVehicleSeat"
    PRESS_VEHICLE_BUTTON = "pressVehicleButton"
    SET_VEHICLE_KEYPAD = "setVehicleKeypad"
    SET_VEHICLE_TANK = "setVehicleTank"
    SET_VEHICLE_BATTERY = "setVehicleBattery"
    SET_VEHICLE_HOPPER = "setVehicleHopper"
    SET_VEHICLE_WEAPON = "setVehicleWeapon"
    SPAWN_VEHICLE_ROPE = "spawnVehicleRope"
    GET_VEHICLE_FIRE_COUNT = "getVehicleFireCount"
    SET_VEHICLE_TOOLTIP = "setVehicleTooltip"
    ADD_DAMAGE = "addDamage"
    GET_VEHICLES_SIMULATING = "getVehicleSimulating"
    GET_VEHICLE_LOCAL = "getVehicleLocal"
    SET_VEHICLE_TRANSPONDER = "setVehicleTransponder"
    SET_VEHICLE_EDITABLE = "setVehicleEditable"
    SET_VEHICLE_INVULNERABLE = "setVehicleInvulnerable"
    SET_VEHICLE_SHOW_ON_MAP = "setVehicleShowOnMap"
    SET_AI_STATE = "setAIState"
    SET_AI_TARGET = "setAITarget"
    GET_AI_TARGET = "getAITarget"
    SET_AI_TARGET_CHARACTER = "setAITargetCharacter"
    SET_AI_TARGET_VEHICLE = "setAITargetVehicle"
    SET_AI_CHARACTER_TEAM = "setAICharacterTeam"
    SET_AI_VEHICLE_TEAM = "setAIVehicleTeam"
    SET_AI_CHARACTER_TARGET_TEAM = "setAICharacterTargetTeam"
    GET_FISH_DATA = "getFishData"
    GET_FISH_HOTSPOTS = "getFishHotspots"
    SPAWN_TSUNAMI = "spawnTsunami"
    SPAWN_WHIRLPOOL = "spawnWhirlpool"
    CANCEL_GERSTNER = "cancelGerstner"
    SPAWN_TORNADO = "spawnTornado"
    SPAWN_METEOR = "spawnMeteor"
    SPAWN_METEOR_SHOWER = "spawnMeteorShower"
    SPAWN_VOLCANO = "spawnVolcano"
    GET_VOLCANOS = "getVolcanos"
    GET_OIL_SPILL = "getOilSpill"
    SET_OIL_SPILL = "setOilSpill"
    CLEAR_OIL_SPILL = "clearOilSpill"
    SPAWN_EXPLOSION = "spawnExplosion"
    SET_GAME_SETTING = "setGameSetting"
    GET_GAME_SETTINGS = "getGameSettings"
    SET_CURRENCY = "setCurrency"
    GET_CURRENCY = "getCurrency"
    GET_RESEARCH_POINTS = "getResearchPoints"
    GET_DATE_VALUE = "getDateValue"
    GET_DATE = "getDate"
    GET_TIME = "getTime"
    GET_WEATHER = "getWeather"
    SET_WEATHER = "setWeather"
    SET_AUDIO_MOOD = "setAudioMood"
    GET_OCEAN_TRANSFORM = "getOceanTransform"
    GET_OCEAN_FLOOR = "getOceanFloor"
    GET_TILE_TRANSFORM = "getTileTransform"
    GET_TILE = "getTile"
    GET_START_TILE = "getStartTile"
    GET_START_ISLAND = "getStartIsland"
    GET_TILE_PURCHASE = "getTilePurchased"
    GET_TILE_INVENTORY = "getTileInventory"
    SET_TILE_INVENTORY = "setTileInventory"
    IS_IN_TRANSFORM_AREA = "isInTransformArea"
    PATH_FIND = "pathfind"
    PATH_FIND_OCEAN = "pathfindOcean"
    GET_OIL_DEPOSITS = "getOilDeposits"
    BAN_PLAYER = "banPlayer"
    KICK_PLAYER = "kickPlayer"
    ADD_ADMIN = "addAdmin"
    REMOVE_ADMIN = "removeAdmin"
    ADD_AUTH = "addAuth"
    REMOVE_AUTH = "removeAuth"
    SAVE = "save"
    GET_TIME_MILLISEC = "getTimeMillisec"
    GET_TUTORIAL = "getTutorial"
    SET_TUTORIAL = "setTutorial"
    GET_VIDEO_TUTORIAL = "getVideoTutorial"
    IS_DEV = "isDev"
    DLC_WEAPONS = "dlcWeapons"
    DLC_ARID = "dlcArid"
    DLC_SPACE = "dlcSpace"
    GET_SEASONAL_EVENT = "getSeasonalEvent"