vcpkg_check_linkage(ONLY_DYNAMIC_LIBRARY)

vcpkg_from_github(
	OUT_SOURCE_PATH SOURCE_PATH
	REPO DragonJoker/Ashes
	REF 0f4e6d0ea308eb60ae32274acc9a4d345a4977ff
	SHA512 0ce74780786d018e7a447c4e49d3cd83ad53b238a79fc484025e2034cd49a64253363cd592d2da367befa7cd5443b90eb1c5dae54b22756f7b4a0cdecb93c588
    PATCHES
        fix-cast.patch
)
vcpkg_configure_cmake(
	SOURCE_PATH ${SOURCE_PATH}
	PREFER_NINJA
	OPTIONS
		-DCMAKE_INSTALL_PREFIX=${CURRENT_INSTALLED_DIR}
		-DPROJECTS_USE_PRECOMPILED_HEADERS=OFF
		-DVCPKG_PACKAGE_BUILD=ON
		-DASHES_BUILD_TEMPLATES=OFF
		-DASHES_BUILD_TESTS=OFF
		-DASHES_BUILD_INFO=OFF
		-DASHES_BUILD_SAMPLES=OFF
)

vcpkg_install_cmake()
vcpkg_fixup_cmake_targets(CONFIG_PATH lib/cmake/ashes)

file(INSTALL ${SOURCE_PATH}/LICENSE DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)
