import numpy as np
from scipy.interpolate import BSpline

DATA_EMOR_F0 = [
    [
        0.0,
        0.0,
        0.0,
        0.0,
        0.007820136852394917,
        0.015640273704789834,
        0.03128054740957967,
        0.06256109481915934,
        0.12512218963831867,
        0.25024437927663734,
        0.375366568914956,
        0.5004887585532747,
        0.750733137829912,
        1.0,
        1.0,
        1.0,
        1.0,
    ],
    [
        0.0012723461632234538,
        0.020479960023890353,
        0.04252978458007196,
        0.0770503702270126,
        0.12858236882729446,
        0.21441665163305657,
        0.3667304806819671,
        0.5305560134553865,
        0.6641402794924216,
        0.7937716129985108,
        0.9063570405865657,
        0.9718029007094517,
        1.0003555514234432,
        0.0,
        0.0,
        0.0,
        0.0,
    ],
]


DATA_EMOR_H = [
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.06256109481915934,
            0.12512218963831867,
            0.25024437927663734,
            0.375366568914956,
            0.5004887585532747,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -0.0017611192178370685,
            -0.00905396012791815,
            -0.021708846640993453,
            -0.03925541513615783,
            -0.04668203581700403,
            -0.04364885860968977,
            -0.031161695398661437,
            -0.014663354068849745,
            -1.1973235040448998e-06,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.007820136852394917,
            0.015640273704789834,
            0.03128054740957967,
            0.06256109481915934,
            0.12512218963831867,
            0.25024437927663734,
            0.375366568914956,
            0.5004887585532747,
            0.750733137829912,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -0.001296472912828145,
            -0.014263509558219034,
            -0.023739679506930542,
            -0.03884782978936699,
            -0.05430472003452498,
            -0.07189365763827614,
            -0.060563141974868465,
            -0.014707237718088326,
            0.01681877170074782,
            0.03361576903822866,
            0.026980225725529182,
            0.009541273052582079,
            -0.00011368899439436125,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0039100684261974585,
            0.007820136852394917,
            0.015640273704789834,
            0.03128054740957967,
            0.06256109481915934,
            0.12512218963831867,
            0.187683284457478,
            0.25024437927663734,
            0.375366568914956,
            0.5004887585532747,
            0.563049853372434,
            0.6256109481915934,
            0.750733137829912,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -0.0012509481117472848,
            -0.01979446499323059,
            -0.03164016278974113,
            -0.04721087686243314,
            -0.06476302403593792,
            -0.08195718367484738,
            -0.07004109716464571,
            -0.0026405358663040383,
            0.03774832085888399,
            0.046584591184903844,
            0.02049377132520529,
            -0.005660123539124646,
            -0.01947186290005622,
            -0.03064036477594024,
            -0.03368286027372229,
            -0.02237093181618999,
            5.5118175890822886e-05,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.0039100684261974585,
            0.007820136852394917,
            0.011730205278592375,
            0.015640273704789834,
            0.02346041055718475,
            0.03128054740957967,
            0.0469208211143695,
            0.06256109481915934,
            0.093841642228739,
            0.10948191593352884,
            0.12512218963831867,
            0.15640273704789834,
            0.187683284457478,
            0.20332355816226783,
            0.21896383186705767,
            0.25024437927663734,
            0.281524926686217,
            0.29716520039100686,
            0.3128054740957967,
            0.34408602150537637,
            0.375366568914956,
            0.43792766373411535,
            0.5004887585532747,
            0.563049853372434,
            0.6256109481915934,
            0.750733137829912,
            0.8758553274682307,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -2.086514533162671e-05,
            -0.0388206006974841,
            -0.04757966420800301,
            -0.06463428638710732,
            -0.07467832486754465,
            -0.08543495007257929,
            -0.0921561951167886,
            -0.09242445566594437,
            -0.08882904383304673,
            -0.06456634684052714,
            -0.016114998164541493,
            0.018799703659101573,
            0.041273150271679424,
            0.053029375582413295,
            0.05396007896813727,
            0.04382435477261213,
            0.026310994608256606,
            0.010544363657924992,
            -0.006256089616888477,
            -0.017979889034186694,
            -0.02342250006368173,
            -0.029031078093926372,
            -0.033274385921943456,
            -0.034054527935654645,
            -0.02946612443768442,
            -0.017182423371978537,
            -0.0036149882418308505,
            0.021841764040781763,
            0.03082572085832964,
            0.029189361475536843,
            0.014074838308012325,
            -9.229436286004135e-05,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0009775171065493646,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.007820136852394917,
            0.011730205278592375,
            0.015640273704789834,
            0.02346041055718475,
            0.03128054740957967,
            0.0469208211143695,
            0.06256109481915934,
            0.07820136852394917,
            0.093841642228739,
            0.12512218963831867,
            0.15640273704789834,
            0.187683284457478,
            0.21896383186705767,
            0.25024437927663734,
            0.26588465298142716,
            0.281524926686217,
            0.3128054740957967,
            0.375366568914956,
            0.43792766373411535,
            0.46920821114369504,
            0.5004887585532747,
            0.5317693059628543,
            0.563049853372434,
            0.6256109481915934,
            0.656891495601173,
            0.6881720430107527,
            0.7194525904203324,
            0.750733137829912,
            0.7820136852394917,
            0.8132942326490713,
            0.844574780058651,
            0.8758553274682307,
            0.9071358748778103,
            0.9384164222873901,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -9.135166878252464e-05,
            -0.03644133012961691,
            -0.0721535699781753,
            -0.07861060099699714,
            -0.08702199928038036,
            -0.09732090032112903,
            -0.10264595679946123,
            -0.10756935816503183,
            -0.1009323738718814,
            -0.08366301142868947,
            -0.04927327930002001,
            -0.001780494347925703,
            0.04400935402324827,
            0.06456918329185288,
            0.06979138898046237,
            0.029279880043753998,
            -0.020534405361820635,
            -0.036271226014361356,
            -0.03730842978593276,
            -0.03285719596238867,
            -0.026230939312825035,
            -0.017190376714665178,
            -0.003007009639752509,
            0.0123602308205297,
            0.01740427582438768,
            0.023719308786500488,
            0.024930247043978795,
            0.024775151733932545,
            0.023105458606467014,
            0.015340922364634644,
            0.006307244624725053,
            -0.002330297262743064,
            -0.009297213581477606,
            -0.018446161345263626,
            -0.027515227737721422,
            -0.03399330059972515,
            -0.03896066819095154,
            -0.04160274410405659,
            -0.03930373051773798,
            -0.03158531374632557,
            -0.014312329827939937,
            -0.00014769318499318202,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.007820136852394917,
            0.015640273704789834,
            0.03128054740957967,
            0.0469208211143695,
            0.05474095796676442,
            0.06256109481915934,
            0.07820136852394917,
            0.093841642228739,
            0.10948191593352884,
            0.12512218963831867,
            0.15640273704789834,
            0.187683284457478,
            0.20332355816226783,
            0.21896383186705767,
            0.23460410557184752,
            0.25024437927663734,
            0.281524926686217,
            0.3128054740957967,
            0.34408602150537637,
            0.375366568914956,
            0.40664711632453565,
            0.43792766373411535,
            0.45356793743890517,
            0.46920821114369504,
            0.48484848484848486,
            0.5004887585532747,
            0.563049853372434,
            0.5943304007820137,
            0.6256109481915934,
            0.656891495601173,
            0.6881720430107527,
            0.750733137829912,
            0.7820136852394917,
            0.7976539589442815,
            0.8132942326490713,
            0.844574780058651,
            0.8758553274682307,
            0.9071358748778103,
            0.9384164222873901,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -6.021289100903602e-05,
            -0.10854928493807917,
            -0.10153762317652618,
            -0.108965470873499,
            -0.11451148280292114,
            -0.10555642069348373,
            -0.07040791555173115,
            -0.008005923193874285,
            0.03236475317965529,
            0.043014041613776456,
            0.04953829021756146,
            0.050644816260468,
            0.03414928716558747,
            0.0029698006672237097,
            -0.03386533544655423,
            -0.048642314182751285,
            -0.05158931817886711,
            -0.021768243524997562,
            -0.003316965331348359,
            0.009391519282519786,
            0.02359252639564321,
            0.03076172631902415,
            0.029650373678184405,
            0.02800862365441713,
            0.024476629409036343,
            0.01484156113860279,
            0.0068328917855269315,
            -0.0007202257583679118,
            -0.007087817344959303,
            -0.012643374337096057,
            -0.0209481197893369,
            -0.03062956787329054,
            -0.03236830889969666,
            -0.03096611335197288,
            -0.02579652612701234,
            -0.015854332702683858,
            -0.0023422782506247186,
            0.015077617530803266,
            0.02251071567517165,
            0.030119307595421172,
            0.03853484957480838,
            0.046322154855616096,
            0.04702725031580355,
            0.04026990562471544,
            0.018984088855705034,
            6.253276218167924e-05,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.005865102639296188,
            0.007820136852394917,
            0.011730205278592375,
            0.015640273704789834,
            0.02346041055718475,
            0.02737047898338221,
            0.03128054740957967,
            0.0469208211143695,
            0.050830889540566956,
            0.05474095796676442,
            0.05865102639296188,
            0.06256109481915934,
            0.07820136852394917,
            0.093841642228739,
            0.10166177908113391,
            0.10948191593352884,
            0.11730205278592376,
            0.12512218963831867,
            0.15640273704789834,
            0.17204301075268819,
            0.187683284457478,
            0.20332355816226783,
            0.21896383186705767,
            0.25024437927663734,
            0.26588465298142716,
            0.281524926686217,
            0.29716520039100686,
            0.30498533724340177,
            0.3128054740957967,
            0.3284457478005865,
            0.34408602150537637,
            0.375366568914956,
            0.40664711632453565,
            0.43792766373411535,
            0.46920821114369504,
            0.5004887585532747,
            0.5161290322580645,
            0.5317693059628543,
            0.563049853372434,
            0.5943304007820137,
            0.6256109481915934,
            0.656891495601173,
            0.6881720430107527,
            0.750733137829912,
            0.7820136852394917,
            0.8132942326490713,
            0.8758553274682307,
            0.9384164222873901,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            -1.9913918432209107e-05,
            -0.0584007851289397,
            -0.052384232042207164,
            -0.062218313767777596,
            -0.05755087277200719,
            -0.05693790528474832,
            -0.053873069964127066,
            -0.05762919665155575,
            -0.039128938070977025,
            -0.00985710993248853,
            0.009605185734513659,
            0.027520254297961257,
            0.0403490089464861,
            0.04766035299695161,
            0.052564735707716276,
            0.05241322078172732,
            0.038061607060813796,
            0.0028790891890231444,
            -0.01372778949004754,
            -0.02732335195519721,
            -0.03199593238843834,
            -0.03437565281696217,
            -0.041047878610204376,
            -0.050844204579026026,
            -0.03114386425458709,
            -0.0022133544114853448,
            0.028973575419815437,
            0.05018272440840531,
            0.050138916356077465,
            0.04483087182467871,
            0.04217962258471614,
            0.039246698887109306,
            0.03406950930642702,
            0.025737812960469314,
            0.012216534017046327,
            -0.00985509734954057,
            -0.03644336660460358,
            -0.05331361429501515,
            -0.05492472465971698,
            -0.035991673810450125,
            -0.022950058249252888,
            -0.015486897364728977,
            -0.006221685967939113,
            0.009580309499651924,
            0.0277697520706502,
            0.03911104011527189,
            0.03896728423873116,
            0.03223025497851636,
            0.01762073477723189,
            0.0003898757492195019,
            -0.01348230442933015,
            -0.02929010880193326,
            -0.03323685233335033,
            -0.015968306635657424,
            0.0001401695448852596,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.007820136852394917,
            0.011730205278592375,
            0.015640273704789834,
            0.019550342130987292,
            0.02346041055718475,
            0.02737047898338221,
            0.03128054740957967,
            0.039100684261974585,
            0.0469208211143695,
            0.05474095796676442,
            0.05865102639296188,
            0.06256109481915934,
            0.07820136852394917,
            0.093841642228739,
            0.10166177908113391,
            0.10948191593352884,
            0.12512218963831867,
            0.13294232649071358,
            0.1407624633431085,
            0.14858260019550343,
            0.15640273704789834,
            0.16422287390029325,
            0.17204301075268819,
            0.1798631476050831,
            0.187683284457478,
            0.20332355816226783,
            0.21896383186705767,
            0.23460410557184752,
            0.25024437927663734,
            0.25806451612903225,
            0.26588465298142716,
            0.281524926686217,
            0.3128054740957967,
            0.3284457478005865,
            0.34408602150537637,
            0.3597262952101662,
            0.375366568914956,
            0.39100684261974583,
            0.40664711632453565,
            0.43792766373411535,
            0.5004887585532747,
            0.5161290322580645,
            0.5317693059628543,
            0.563049853372434,
            0.5786901270772239,
            0.5943304007820137,
            0.6099706744868035,
            0.6256109481915934,
            0.6881720430107527,
            0.7194525904203324,
            0.750733137829912,
            0.7820136852394917,
            0.8132942326490713,
            0.8758553274682307,
            0.9071358748778103,
            0.9384164222873901,
            0.9696969696969697,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            0.00010218921547788561,
            0.2046020904352806,
            0.16474967718394584,
            0.15916322194133212,
            0.1379769270899568,
            0.09874467387749501,
            0.0554582109806686,
            0.0224690542530206,
            -0.008680058662101453,
            -0.02236614594757423,
            -0.029453843106224287,
            -0.04634035314892616,
            -0.05812821011857106,
            -0.06028172633127636,
            -0.03891970639873116,
            -0.018329865952924723,
            0.009375769282335196,
            0.0462284087820623,
            0.02982149952825472,
            0.02831388422609509,
            0.029680825622612397,
            0.02672166381932222,
            0.013344508594401146,
            -0.001370722009829223,
            -0.013463422613561902,
            -0.019372482046943307,
            -0.023335867162525403,
            -0.024352339889535987,
            -0.024595201731223145,
            -0.021819310491458424,
            -0.01956418664672496,
            -0.02392844161120935,
            -0.02846415130379142,
            -0.027249226192512632,
            -0.021620457014424038,
            -0.015077361272212883,
            0.006218259489797848,
            0.039831907529625635,
            0.053845392938922376,
            0.05674842417845659,
            0.049901453293685574,
            0.03853717397005311,
            0.025465935599891028,
            0.01269605510268006,
            -0.016852654400572487,
            -0.047739649098642874,
            -0.05280633497330778,
            -0.05373598520471367,
            -0.042940628359415825,
            -0.026094117642736517,
            -0.01200358980180333,
            0.0015869686198052653,
            0.02753690755079327,
            0.03724344395720616,
            0.030726126801812345,
            0.02217231105972027,
            0.011608135037754534,
            -0.0004793512506055113,
            -0.012456043279665787,
            -0.01717501432861727,
            -0.020005293126838096,
            -0.01602335831822455,
            -0.007531287896485441,
            0.0002478479181506515,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.007820136852394917,
            0.011730205278592375,
            0.013685239491691105,
            0.015640273704789834,
            0.019550342130987292,
            0.02346041055718475,
            0.02737047898338221,
            0.03128054740957967,
            0.039100684261974585,
            0.0469208211143695,
            0.05474095796676442,
            0.06256109481915934,
            0.07038123167155425,
            0.07820136852394917,
            0.093841642228739,
            0.10948191593352884,
            0.12512218963831867,
            0.13294232649071358,
            0.1407624633431085,
            0.14858260019550343,
            0.15640273704789834,
            0.187683284457478,
            0.19550342130987292,
            0.20332355816226783,
            0.21896383186705767,
            0.23460410557184752,
            0.25024437927663734,
            0.26588465298142716,
            0.281524926686217,
            0.3128054740957967,
            0.34408602150537637,
            0.375366568914956,
            0.39100684261974583,
            0.40664711632453565,
            0.4222873900293255,
            0.43792766373411535,
            0.46920821114369504,
            0.48484848484848486,
            0.5004887585532747,
            0.5161290322580645,
            0.5317693059628543,
            0.563049853372434,
            0.5943304007820137,
            0.6256109481915934,
            0.656891495601173,
            0.6881720430107527,
            0.7194525904203324,
            0.750733137829912,
            0.7820136852394917,
            0.8132942326490713,
            0.844574780058651,
            0.8602150537634409,
            0.8758553274682307,
            0.9071358748778103,
            0.9227761485826002,
            0.9384164222873901,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            0.00013533458855937518,
            0.187667032260034,
            0.14807393064019655,
            0.14200405750866496,
            0.13585295909003553,
            0.11348649472773642,
            0.07993607754991841,
            0.04981574880799202,
            0.030623747383124175,
            0.006637316704047294,
            -0.02281249235010562,
            -0.05059394744689305,
            -0.0650305347366578,
            -0.06961816680091375,
            -0.05567942324196059,
            -0.04032330665493525,
            -0.018253828195390467,
            0.003933630719089933,
            0.02831548269014096,
            0.07605917667255802,
            0.061556666029009,
            0.024830619315301013,
            -0.004378122204225914,
            -0.02120547172076915,
            -0.03560818642655671,
            -0.06270623588313409,
            -0.07225421117508948,
            -0.03508300474627697,
            -0.0036579332606030903,
            0.023968771614393727,
            0.044610503773307233,
            0.051049407657656504,
            0.051517909896350654,
            0.03548806845959076,
            -0.004081051045340935,
            -0.03311695090552109,
            -0.03659012082613832,
            -0.034676538324351934,
            -0.0342368676466874,
            -0.028984192175470318,
            -0.014896560627601089,
            0.006308881642583644,
            0.023312738601993354,
            0.03076312934207433,
            0.03359379859648888,
            0.03638355191532406,
            0.02901092852188013,
            0.010981722752987628,
            -0.009385108584974182,
            -0.01996858820972459,
            -0.021318697512133777,
            -0.018181100878325907,
            -0.011536820563804772,
            -0.004058274552992265,
            0.002127410570982295,
            0.006007266484032375,
            0.01002146208573598,
            0.012689315021559964,
            0.012954386429321885,
            0.014568092657396463,
            0.013065653285413651,
            0.008463272903323629,
            6.2223487205621735e-06,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.004887585532746823,
            0.005865102639296188,
            0.007820136852394917,
            0.009775171065493646,
            0.011730205278592375,
            0.013685239491691105,
            0.015640273704789834,
            0.019550342130987292,
            0.021505376344086023,
            0.02346041055718475,
            0.02737047898338221,
            0.03128054740957967,
            0.039100684261974585,
            0.043010752688172046,
            0.0469208211143695,
            0.05474095796676442,
            0.05865102639296188,
            0.06256109481915934,
            0.07038123167155425,
            0.07820136852394917,
            0.08602150537634409,
            0.093841642228739,
            0.09775171065493646,
            0.10166177908113391,
            0.10948191593352884,
            0.12512218963831867,
            0.13294232649071358,
            0.1407624633431085,
            0.14858260019550343,
            0.15640273704789834,
            0.16422287390029325,
            0.17204301075268819,
            0.187683284457478,
            0.20332355816226783,
            0.21896383186705767,
            0.23460410557184752,
            0.24242424242424243,
            0.25024437927663734,
            0.281524926686217,
            0.3128054740957967,
            0.3206256109481916,
            0.3284457478005865,
            0.3362658846529814,
            0.34408602150537637,
            0.3597262952101662,
            0.375366568914956,
            0.39100684261974583,
            0.40664711632453565,
            0.4222873900293255,
            0.43792766373411535,
            0.46920821114369504,
            0.48484848484848486,
            0.49266862170087977,
            0.5004887585532747,
            0.5317693059628543,
            0.563049853372434,
            0.5786901270772239,
            0.5943304007820137,
            0.6099706744868035,
            0.6256109481915934,
            0.656891495601173,
            0.6881720430107527,
            0.7194525904203324,
            0.750733137829912,
            0.7820136852394917,
            0.8132942326490713,
            0.844574780058651,
            0.8602150537634409,
            0.8758553274682307,
            0.9071358748778103,
            0.9384164222873901,
            0.9696969696969697,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            8.234156605314762e-05,
            0.030664993715924675,
            0.026054907514774298,
            0.03219402852370968,
            0.020929886036414415,
            0.003943777377903501,
            0.0007531780827520384,
            0.0016136102497380969,
            0.004214097829275482,
            0.014547003767244491,
            0.014206467660096032,
            0.0009685251048579911,
            0.00585226974399905,
            -0.006919502200705912,
            -0.016246683406919257,
            -0.027076487617749296,
            -0.026899196164833255,
            -0.013605812277463174,
            0.005915068446843492,
            0.010204295787554298,
            -0.003425590541947881,
            -0.01262157883945734,
            -0.0037627156314040265,
            0.011841512303181265,
            0.03456159868954059,
            0.05313068538358812,
            0.04940202544107208,
            0.03351820532337647,
            0.015660915309782933,
            -0.028006345514888984,
            -0.0637346639204426,
            -0.06127902989393218,
            -0.037200636129932727,
            -0.015320355235284829,
            -0.007973009703941181,
            -0.0020618069928454463,
            -0.004667826345742389,
            -0.010539528210830096,
            0.026839526924978617,
            0.05307025623827283,
            0.062504639188845,
            0.058506367598249315,
            0.039298540204402946,
            -0.019308333704027146,
            -0.06790362959558222,
            -0.07231220003147305,
            -0.07312775048131953,
            -0.06855482216032506,
            -0.05490690877396149,
            -0.027797658049257126,
            0.009564661728376464,
            0.04092624221729501,
            0.05460680681510419,
            0.06245560712061115,
            0.050807142018401,
            0.022372724087135434,
            0.000735214717276238,
            -0.007883739321788428,
            -0.014219559046061637,
            -0.020902620707301908,
            -0.02890798419890642,
            -0.03260155649416247,
            -0.03258685231414169,
            -0.028733922733329434,
            -0.016389560400683827,
            0.0030882884610780197,
            0.017793847445810876,
            0.028665422191658064,
            0.029750247769299635,
            0.024681094704576446,
            0.008969805798685946,
            -0.0025114216372781927,
            -0.013180484031657402,
            -0.0200170712194829,
            -0.02558640839320529,
            -0.028937305799982545,
            -0.020434665631455042,
            -0.008547752152331134,
            0.00024569247623815584,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.007820136852394917,
            0.011730205278592375,
            0.015640273704789834,
            0.019550342130987292,
            0.02346041055718475,
            0.02737047898338221,
            0.03128054740957967,
            0.03519061583577712,
            0.039100684261974585,
            0.0469208211143695,
            0.050830889540566956,
            0.05474095796676442,
            0.05865102639296188,
            0.06256109481915934,
            0.07038123167155425,
            0.07820136852394917,
            0.08602150537634409,
            0.093841642228739,
            0.10166177908113391,
            0.10948191593352884,
            0.11730205278592376,
            0.12512218963831867,
            0.13294232649071358,
            0.1407624633431085,
            0.14858260019550343,
            0.15640273704789834,
            0.187683284457478,
            0.19550342130987292,
            0.19941348973607037,
            0.20332355816226783,
            0.21896383186705767,
            0.25024437927663734,
            0.26588465298142716,
            0.281524926686217,
            0.29716520039100686,
            0.3128054740957967,
            0.3284457478005865,
            0.34408602150537637,
            0.3597262952101662,
            0.375366568914956,
            0.40664711632453565,
            0.4222873900293255,
            0.43792766373411535,
            0.46920821114369504,
            0.5004887585532747,
            0.5161290322580645,
            0.5317693059628543,
            0.563049853372434,
            0.5943304007820137,
            0.6099706744868035,
            0.6256109481915934,
            0.6412512218963832,
            0.656891495601173,
            0.6881720430107527,
            0.7038123167155426,
            0.7116324535679375,
            0.7194525904203324,
            0.7350928641251222,
            0.750733137829912,
            0.7820136852394917,
            0.7976539589442815,
            0.8132942326490713,
            0.8289345063538612,
            0.844574780058651,
            0.8602150537634409,
            0.8758553274682307,
            0.9071358748778103,
            0.9384164222873901,
            0.9540566959921799,
            0.9696969696969697,
            0.9853372434017595,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            6.825470601649674e-05,
            0.2635948757657055,
            0.17893715367909682,
            0.15555339771647014,
            0.1036002293065616,
            0.043693256220115405,
            -0.023695265472473668,
            -0.06043552451964282,
            -0.05726606015796205,
            -0.05414916505674481,
            -0.04766290774337991,
            -0.05591702359564404,
            -0.056646162477551144,
            -0.0388728767546203,
            -0.010844687525324545,
            0.014169726413247317,
            0.04470274466037018,
            0.06633509931697967,
            0.07948031328008347,
            0.08675883387640348,
            0.07450348421556001,
            0.048084351272265353,
            0.0060537762502183255,
            -0.04686872986227789,
            -0.07565893067051777,
            -0.08318184923233621,
            -0.08333497210592902,
            -0.06744900046191123,
            -0.04282854823905556,
            -0.017082454895781574,
            0.022403995967173476,
            0.0801778055156385,
            0.06463996226659366,
            0.05346085767644204,
            0.03692830855901323,
            0.006696656759168034,
            -0.022155334977892675,
            -0.04110314484466834,
            -0.029414206266780055,
            -0.007735434031871766,
            0.007659355707385104,
            0.0016128241007449032,
            -0.0007580437662239992,
            -0.0019600029835305766,
            0.0003085420803514463,
            0.0014327199216395826,
            0.0019181062627137355,
            0.0027372324324301373,
            -0.0003044910370269392,
            -0.002695792090959992,
            -0.0024184840416206113,
            -0.003020014429941725,
            0.007830874573668715,
            0.025538166638935742,
            0.031272798565905466,
            0.03019979202021709,
            0.018026184645881627,
            0.0019292031300059533,
            -0.01108184768865839,
            -0.019367705405442075,
            -0.023529743053035963,
            -0.026248971710957216,
            -0.02963620267737382,
            -0.030485203040266768,
            -0.026492365118711062,
            -0.0203818193337434,
            -0.012883734643563882,
            -0.0063051929497867564,
            0.0014748264319088878,
            0.008344416721095494,
            0.016127168558041867,
            0.02394177497458219,
            0.028617063373586903,
            0.02651558910214932,
            0.021364077324461873,
            0.01354955518534404,
            0.004160666817144856,
            -1.0576736575877274e-05,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
    [
        [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0009775171065493646,
            0.0019550342130987292,
            0.002932551319648094,
            0.0039100684261974585,
            0.005865102639296188,
            0.007820136852394917,
            0.011730205278592375,
            0.013685239491691105,
            0.015640273704789834,
            0.019550342130987292,
            0.02346041055718475,
            0.02737047898338221,
            0.03128054740957967,
            0.03519061583577712,
            0.039100684261974585,
            0.043010752688172046,
            0.0469208211143695,
            0.050830889540566956,
            0.05474095796676442,
            0.05865102639296188,
            0.06256109481915934,
            0.07038123167155425,
            0.07820136852394917,
            0.093841642228739,
            0.10166177908113391,
            0.10948191593352884,
            0.11730205278592376,
            0.12121212121212122,
            0.12512218963831867,
            0.1407624633431085,
            0.15640273704789834,
            0.16422287390029325,
            0.17204301075268819,
            0.187683284457478,
            0.19550342130987292,
            0.20332355816226783,
            0.21896383186705767,
            0.23460410557184752,
            0.24242424242424243,
            0.25024437927663734,
            0.25806451612903225,
            0.26588465298142716,
            0.281524926686217,
            0.29716520039100686,
            0.3128054740957967,
            0.3284457478005865,
            0.34408602150537637,
            0.3597262952101662,
            0.375366568914956,
            0.39100684261974583,
            0.40664711632453565,
            0.4222873900293255,
            0.43792766373411535,
            0.45356793743890517,
            0.46920821114369504,
            0.48484848484848486,
            0.5004887585532747,
            0.5161290322580645,
            0.5317693059628543,
            0.5474095796676441,
            0.563049853372434,
            0.5786901270772239,
            0.5943304007820137,
            0.6021505376344086,
            0.6099706744868035,
            0.6256109481915934,
            0.6412512218963832,
            0.656891495601173,
            0.6725317693059628,
            0.6803519061583577,
            0.6881720430107527,
            0.6959921798631477,
            0.7038123167155426,
            0.7116324535679375,
            0.7194525904203324,
            0.7350928641251222,
            0.750733137829912,
            0.7663734115347018,
            0.7820136852394917,
            0.7976539589442815,
            0.8132942326490713,
            0.8289345063538612,
            0.844574780058651,
            0.8602150537634409,
            0.8758553274682307,
            0.8914956011730205,
            0.9071358748778103,
            0.9227761485826002,
            0.9384164222873901,
            0.9540566959921799,
            0.9696969696969697,
            0.9853372434017595,
            1.0,
            1.0,
            1.0,
            1.0,
        ],
        [
            7.742219605865305e-07,
            0.45454464523307775,
            0.1850482747970103,
            0.24026152927258773,
            0.16630914999053104,
            0.1348254636538327,
            0.08510765247914721,
            0.019641738794315886,
            -0.03846749556654184,
            -0.08051297745073611,
            -0.09910242466134395,
            -0.11407075865611072,
            -0.11090301548392499,
            -0.09667104407130184,
            -0.04515300505818389,
            0.005601758589306577,
            0.047038371815030136,
            0.08091970238287047,
            0.10220798098745897,
            0.11306867312249348,
            0.10134906107750426,
            0.08056115479539196,
            0.043764429277395725,
            -0.014490609662677992,
            -0.07634396725821105,
            -0.05594592148274706,
            -0.028929778686336092,
            -0.015441498668634599,
            -0.007561759232824778,
            0.003793587980202724,
            0.018892577016471214,
            0.03492405822766409,
            0.03615201444951879,
            0.027009341819037365,
            0.014398889963644818,
            -0.000815663530796242,
            -0.02502674375005198,
            -0.04336890372576155,
            -0.04304076633500612,
            -0.022491328209969963,
            -0.005304637026597398,
            0.007398859874830709,
            0.01949308236576228,
            0.033546512903292205,
            0.03053414869222142,
            0.013960450155705057,
            -0.004313298805528957,
            -0.0044890093427107465,
            -0.006426867470135985,
            -0.0046304613017645255,
            -0.004661605330345554,
            -0.007084933220985617,
            -0.013125378617422795,
            -0.015208137750846272,
            -0.007146677841837651,
            0.0035887238555569858,
            0.01700981119708114,
            0.026010371048858127,
            0.028561435789922634,
            0.023335811404259735,
            0.019888939778577832,
            0.008485781498713624,
            -0.006203913576718009,
            -0.023245432838793784,
            -0.032964016084709745,
            -0.036865156466743675,
            -0.04044621091270205,
            -0.039397921876917104,
            -0.026939922254060306,
            -0.014505215851827699,
            -0.004258480342021284,
            0.0009525986775615231,
            0.005057473455987356,
            0.007207800739583845,
            0.011712999004364667,
            0.013091697053428369,
            0.015944902833871333,
            0.019005304529554914,
            0.01974656446401535,
            0.023814003446183306,
            0.020616907014966837,
            0.019974422688290024,
            0.014050503363351261,
            0.010263768586866716,
            0.004466642985830479,
            0.0017878316064368091,
            -0.004305287927197149,
            -0.009829449768734877,
            -0.014314634849558526,
            -0.0182415276122636,
            -0.020821206749897746,
            -0.02358168157588116,
            -0.021439037340324787,
            -0.015367426053675786,
            -0.004724001022855374,
            5.1180639016405716e-05,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
    ],
]

EMOR_LENGTH = 1024
EMOR_MAX_FACTORS = 13

EMOR_X = np.linspace(0, 1, EMOR_LENGTH)

def EMOR_F0(x):
    x = np.asarray(x)

    k = 3
    t, c = DATA_EMOR_F0
    spline = BSpline.construct_fast(np.asarray(t), np.asarray(c), k)
    return spline(x)

def EMOR_H(x, degree):
    x = np.asarray(x)

    k = 3
    points = []
    for t, c, in DATA_EMOR_H[:degree]:
        spline = BSpline.construct_fast(np.asarray(t), np.asarray(c), k)
        points.append(spline(x))

    return np.asarray(points)
