"""File type identification using libmagic.

Constants exported by magic.h header file.

See libmagic(3) for low level details.
"""
# magic.h constants

MAGIC_NONE = 0x000000
MAGIC_DEBUG = 0x000001
MAGIC_SYMLINK = 0x000002
MAGIC_COMPRESS = 0x000004
MAGIC_DEVICES = 0x000008
MAGIC_MIME_TYPE = 0x000010
MAGIC_CONTINUE = 0x000020
MAGIC_CHECK = 0x000040
MAGIC_PRESERVE_ATIME = 0x000080
MAGIC_RAW = 0x000100
MAGIC_ERROR = 0x000200
MAGIC_MIME_ENCODING = 0x000400
MAGIC_MIME = MAGIC_MIME_TYPE | MAGIC_MIME_ENCODING
MAGIC_APPLE = 0x000800

MAGIC_NO_CHECK_COMPRESS = 0x001000
MAGIC_NO_CHECK_TAR = 0x002000
MAGIC_NO_CHECK_SOFT = 0x004000
MAGIC_NO_CHECK_APPTYPE = 0x008000
MAGIC_NO_CHECK_ELF = 0x010000
MAGIC_NO_CHECK_TEXT = 0x020000
MAGIC_NO_CHECK_CDF = 0x040000
MAGIC_NO_CHECK_TOKENS = 0x100000
MAGIC_NO_CHECK_ENCODING = 0x200000

MAGIC_NO_CHECK_BUILTIN = (
        MAGIC_NO_CHECK_COMPRESS |
        MAGIC_NO_CHECK_TAR |
        MAGIC_NO_CHECK_APPTYPE |
        MAGIC_NO_CHECK_ELF |
        MAGIC_NO_CHECK_TEXT |
        MAGIC_NO_CHECK_CDF |
        MAGIC_NO_CHECK_TOKENS |
        MAGIC_NO_CHECK_ENCODING
)

MAGIC_NO_CHECK_ASCII = MAGIC_NO_CHECK_TEXT

MAGIC_NO_CHECK_FORTRAN = 0x000000
MAGIC_NO_CHECK_TROFF = 0x000000
