import json
import os

BIDS_raw_folder = { 'dataset_description.json' : { '__RequirementLevel__': 'REQUIRED',
                                                     'Name': 'REQUIRED',
                                                     'BIDSVersion' : 'REQUIRED',
                                                     'HEDVersion' : 'RECOMMENDED',
                                                     'DatasetType': 'RECOMMENDED',
                                                     'License' : 'RECOMMENDED',
                                                     'Authors' : 'OPTIONAL',
                                                     'Acknowledgements' : 'OPTIONAL',
                                                     'HowToAcknowledge' : 'OPTIONAL',
                                                     'Funding' : 'OPTIONAL',
                                                     'EthicsApprovals' : 'OPTIONAL',
                                                     'ReferencesAndLinks' : 'OPTIONAL',
                                                     'DatasetDOI' : 'OPTIONAL',
                                                   },
                         'participants.tsv' : {'__RequirementLevel__': 'RECOMMENDED',
                                               'participant_id':'REQUIRED',
                                               'age':'RECOMMENDED',
                                               'sex':'RECOMMENDED',
                                               'handedness':'RECOMMENDED',
                                              },
                         'README' : {'__RequirementLevel__': 'OPTIONAL'},
                         'CHANGES' : {'__RequirementLevel__': 'OPTIONAL'},
                         'LICENSE' : {'__RequirementLevel__': 'OPTIONAL'}, 
                        }

BIDS_fNIRS_subject_folder = {'_nirs.json' : { '__RequirementLevel__': 'REQUIRED',
                                              'TaskName' : 'REQUIRED',
                                              'SamplingFrequency' : 'REQUIRED',
                                              'NIRSChannelCount' : 'REQUIRED',
                                              'NIRSSourceOptodeCount' : 'REQUIRED',
                                              'NIRSDetectorOptodeCount' : 'REQUIRED',
                                              'InstitutionName' : 'RECOMMENDED',
                                              'InstitutionAddress' : 'RECOMMENDED',
                                              'Manufacturer' : 'RECOMMENDED',
                                              'ManufacturersModelName' : 'RECOMMENDED',
                                              'SoftwareVersions' : 'RECOMMENDED',
                                              'TaskDescription' : 'RECOMMENDED',
                                              'Instructions' : 'RECOMMENDED',
                                              'CogAtlasID' : 'RECOMMENDED',
                                              'CogPOID' : 'RECOMMENDED',
                                              'DeviceSerialNumber' : 'RECOMMENDED',
                                              'RecordingDuration' : 'RECOMMENDED',
                                              'HeadCircumference' : 'RECOMMENDED',
                                              'HardwareFilters' : 'RECOMMENDED',
                                              'SubjectArtefactDescription' : 'RECOMMENDED',
                                              'CapManufacturer' : 'RECOMMENDED',
                                              'CapManufacturersModelName' : 'RECOMMENDED',
                                              'SourceType' : 'RECOMMENDED',
                                              'DetectorType' : 'RECOMMENDED',
                                              'ShortChannelCount' : 'RECOMMENDED',
                                              'NIRSPlacementScheme' : 'RECOMMENDED',
                                              'ACCELChannelCount' : 'CONDITIONAL',
                                              'GYROChannelCount' : 'CONDITIONAL',
                                              'MAGNChannelCount' : 'CONDITIONAL',
                                              },
                             
                             '_events.tsv' : { '__RequirementLevel__': 'REQUIRED',
                                                 'onset': 'REQUIRED',
                                                 'duration' : 'REQUIRED',
                                                 'StimulusPresentation' : 'RECOMMENDED',
                                                 'OperatingSystem' : 'RECOMMENDED',
                                                 'SoftwareName' : 'RECOMMENDED',
                                                 'SoftwareRRID' : 'RECOMMENDED',
                                                 'SoftwareVersion' : 'RECOMMENDED',
                                                 'Code' : 'RECOMMENDED',
                                                 'sample' : 'OPTIONAL',
                                                 'trial_type' : 'OPTIONAL',
                                                 'response_time' : 'OPTIONAL',
                                                 'value' : 'OPTIONAL',
                                                 'HED' : 'OPTIONAL',
                                                 'stim_file' : 'OPTIONAL'
                                               },

                              '_channels.tsv' : { '__RequirementLevel__': 'REQUIRED',
                                                  'name' : 'REQUIRED',
                                                  'type' : 'REQUIRED',
                                                  'source' : 'REQUIRED',
                                                  'detector' : 'REQUIRED',
                                                  'wavelength_nominal' : 'REQUIRED',
                                                  'units' : 'REQUIRED',
                                                  'sampling_frequency' : 'CONDITIONAL',
                                                  'orientation_component' : 'CONDITIONAL',
                                                  'wavelength_actual' : 'OPTIONAL',
                                                  'description' : 'OPTIONAL',
                                                  'wavelength_emission_actual' : 'OPTIONAL',
                                                  'short_channel' : 'OPTIONAL',
                                                  'status' : 'OPTIONAL',
                                                  'status_description' : 'OPTIONAL',
                                                },

                             '_optodes.tsv' : {'__RequirementLevel__': 'OPTIONAL',
                                               'name' : 'REQUIRED',
                                               'type' : 'REQUIRED',
                                               'x' : 'REQUIRED',
                                               'y' : 'REQUIRED',
                                               'z' : 'REQUIRED',
                                               'template_x' : 'CONDITIONAL',
                                               'template_y' : 'CONDITIONAL',
                                               'template_z' : 'CONDITIONAL',
                                               'description' : 'OPTIONAL',
                                               'detector_type' : 'OPTIONAL',
                                               'source_type' : 'OPTIONAL',

                                              },

                             '_coordsystem.json' : {'__RequirementLevel__' : 'CONDITIONAL',
                                                    'NIRSCoordinateSystem' : 'REQUIRED' ,
                                                    'NIRSCoordinateUnits' : 'REQUIRED' ,
                                                    'NIRSCoordinateSystemDescription' : 'CONDITIONAL',
                                                    'NIRSCoordinateProcessingDescription' : 'RECOMMENDED' ,
                                                    'FiducialsCoordinates' : 'RECOMMENDED' ,
                                                    'FiducialsCoordinateSystem' : 'RECOMMENDED' ,
                                                    'FiducialsCoordinateUnits' : 'RECOMMENDED' ,
                                                    'AnatomicalLandmarkCoordinates' : 'RECOMMENDED' ,
                                                    'AnatomicalLandmarkCoordinateSystem' : 'RECOMMENDED' ,
                                                    'AnatomicalLandmarkCoordinateUnits' : 'RECOMMENDED' ,
                                                    'FiducialsCoordinateSystemDescription' : 'CONDITIONAL' ,
                                                    'AnatomicalLandmarkCoordinateSystemDescription' : 'CONDITIONAL',
                                                    'FiducialsDescription' : 'OPTIONAL',
                                                }
                                 }
                                 
with open('BIDS_raw_folder.json', 'w') as outfile:
    json.dump(BIDS_raw_folder, outfile)
    
with open('BIDS_fNIRS_subject_folder.json', 'w') as outfile:
    json.dump(BIDS_fNIRS_subject_folder, outfile)