import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The connection string to the publisher. It should follow the keyword/value format (https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#conninfo Subscription#conninfo}
    */
    readonly conninfo: string;
    /**
    * Specifies whether the command should create the replication slot on the publisher
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#create_slot Subscription#create_slot}
    */
    readonly createSlot?: boolean | cdktf.IResolvable;
    /**
    * Sets the database to add the subscription for
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#database Subscription#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#id Subscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the subscription
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#name Subscription#name}
    */
    readonly name: string;
    /**
    * Names of the publications on the publisher to subscribe to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#publications Subscription#publications}
    */
    readonly publications: string[];
    /**
    * Name of the replication slot to use. The default behavior is to use the name of the subscription for the slot name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/subscription#slot_name Subscription#slot_name}
    */
    readonly slotName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/subscription postgresql_subscription}
*/
export declare class Subscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/subscription postgresql_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionConfig);
    private _conninfo?;
    get conninfo(): string;
    set conninfo(value: string);
    get conninfoInput(): string | undefined;
    private _createSlot?;
    get createSlot(): boolean | cdktf.IResolvable;
    set createSlot(value: boolean | cdktf.IResolvable);
    resetCreateSlot(): void;
    get createSlotInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publications?;
    get publications(): string[];
    set publications(value: string[]);
    get publicationsInput(): string[] | undefined;
    private _slotName?;
    get slotName(): string;
    set slotName(value: string);
    resetSlotName(): void;
    get slotNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
