import cdk = require('@aws-cdk/core');
/**
 * Properties for defining a `AWS::Serverless::Api`
 *
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export interface CfnApiProps {
    /**
     * `AWS::Serverless::Api.StageName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly stageName: string;
    /**
     * `AWS::Serverless::Api.AccessLogSetting`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly accessLogSetting?: CfnApi.AccessLogSettingProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Auth`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly auth?: CfnApi.AuthProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly binaryMediaTypes?: string[];
    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly cacheClusterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.CacheClusterSize`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly cacheClusterSize?: string;
    /**
     * `AWS::Serverless::Api.Cors`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly cors?: string;
    /**
     * `AWS::Serverless::Api.DefinitionBody`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly definitionBody?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.DefinitionUri`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly definitionUri?: CfnApi.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.EndpointConfiguration`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly endpointConfiguration?: string;
    /**
     * `AWS::Serverless::Api.MethodSettings`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly methodSettings?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Name`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly name?: string;
    /**
     * `AWS::Serverless::Api.TracingEnabled`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly tracingEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Variables`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly variables?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Serverless::Api`
 *
 * @cloudformationResource AWS::Serverless::Api
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare class CfnApi extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Api";
    /**
     * The `Transform` a template must use in order to use this resource
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::Api.StageName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    stageName: string;
    /**
     * `AWS::Serverless::Api.AccessLogSetting`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    accessLogSetting: CfnApi.AccessLogSettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Auth`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    auth: CfnApi.AuthProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    binaryMediaTypes: string[] | undefined;
    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    cacheClusterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.CacheClusterSize`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    cacheClusterSize: string | undefined;
    /**
     * `AWS::Serverless::Api.Cors`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    cors: string | undefined;
    /**
     * `AWS::Serverless::Api.DefinitionBody`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    definitionBody: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.DefinitionUri`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    definitionUri: CfnApi.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.EndpointConfiguration`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    endpointConfiguration: string | undefined;
    /**
     * `AWS::Serverless::Api.MethodSettings`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    methodSettings: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Name`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    name: string | undefined;
    /**
     * `AWS::Serverless::Api.TracingEnabled`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    tracingEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Variables`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    variables: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Serverless::Api`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApi {
    /**
     * @stability external
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    interface AccessLogSettingProperty {
        /**
         * `CfnApi.AccessLogSettingProperty.DestinationArn`
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        readonly destinationArn?: string;
        /**
         * `CfnApi.AccessLogSettingProperty.Format`
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        readonly format?: string;
    }
}
export declare namespace CfnApi {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
     */
    interface AuthProperty {
        /**
         * `CfnApi.AuthProperty.Authorizers`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        readonly authorizers?: any | cdk.IResolvable;
        /**
         * `CfnApi.AuthProperty.DefaultAuthorizer`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        readonly defaultAuthorizer?: string;
    }
}
export declare namespace CfnApi {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnApi.S3LocationProperty.Bucket`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly bucket: string;
        /**
         * `CfnApi.S3LocationProperty.Key`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly key: string;
        /**
         * `CfnApi.S3LocationProperty.Version`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly version: number;
    }
}
/**
 * Properties for defining a `AWS::Serverless::Application`
 *
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
export interface CfnApplicationProps {
    /**
     * `AWS::Serverless::Application.Location`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly location: CfnApplication.ApplicationLocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.NotificationArns`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly notificationArns?: string[];
    /**
     * `AWS::Serverless::Application.Parameters`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.Tags`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly timeoutInMinutes?: number;
}
/**
 * A CloudFormation `AWS::Serverless::Application`
 *
 * @cloudformationResource AWS::Serverless::Application
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
export declare class CfnApplication extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Application";
    /**
     * The `Transform` a template must use in order to use this resource
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::Application.Location`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    location: CfnApplication.ApplicationLocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.NotificationArns`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    notificationArns: string[] | undefined;
    /**
     * `AWS::Serverless::Application.Parameters`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Application.Tags`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    timeoutInMinutes: number | undefined;
    /**
     * Create a new `AWS::Serverless::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    interface ApplicationLocationProperty {
        /**
         * `CfnApplication.ApplicationLocationProperty.ApplicationId`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        readonly applicationId: string;
        /**
         * `CfnApplication.ApplicationLocationProperty.SemanticVersion`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        readonly semanticVersion: string;
    }
}
/**
 * Properties for defining a `AWS::Serverless::Function`
 *
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export interface CfnFunctionProps {
    /**
     * `AWS::Serverless::Function.CodeUri`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly codeUri: CfnFunction.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Handler`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly handler: string;
    /**
     * `AWS::Serverless::Function.Runtime`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly runtime: string;
    /**
     * `AWS::Serverless::Function.AutoPublishAlias`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly autoPublishAlias?: string;
    /**
     * `AWS::Serverless::Function.DeadLetterQueue`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly deadLetterQueue?: CfnFunction.DeadLetterQueueProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.DeploymentPreference`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    readonly deploymentPreference?: CfnFunction.DeploymentPreferenceProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Description`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::Function.Environment`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly environment?: CfnFunction.FunctionEnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Events`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly events?: {
        [key: string]: (CfnFunction.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.FunctionName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly functionName?: string;
    /**
     * `AWS::Serverless::Function.KmsKeyArn`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::Serverless::Function.Layers`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly layers?: string[];
    /**
     * `AWS::Serverless::Function.MemorySize`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly memorySize?: number;
    /**
     * `AWS::Serverless::Function.PermissionsBoundary`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly permissionsBoundary?: string;
    /**
     * `AWS::Serverless::Function.Policies`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly policies?: Array<CfnFunction.IAMPolicyDocumentProperty | CfnFunction.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnFunction.IAMPolicyDocumentProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly reservedConcurrentExecutions?: number;
    /**
     * `AWS::Serverless::Function.Role`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly role?: string;
    /**
     * `AWS::Serverless::Function.Tags`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Function.Timeout`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly timeout?: number;
    /**
     * `AWS::Serverless::Function.Tracing`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly tracing?: string;
    /**
     * `AWS::Serverless::Function.VpcConfig`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly vpcConfig?: CfnFunction.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Serverless::Function`
 *
 * @cloudformationResource AWS::Serverless::Function
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare class CfnFunction extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Function";
    /**
     * The `Transform` a template must use in order to use this resource
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::Function.CodeUri`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    codeUri: CfnFunction.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Handler`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    handler: string;
    /**
     * `AWS::Serverless::Function.Runtime`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    runtime: string;
    /**
     * `AWS::Serverless::Function.AutoPublishAlias`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    autoPublishAlias: string | undefined;
    /**
     * `AWS::Serverless::Function.DeadLetterQueue`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    deadLetterQueue: CfnFunction.DeadLetterQueueProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.DeploymentPreference`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    deploymentPreference: CfnFunction.DeploymentPreferenceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.Description`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::Function.Environment`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    environment: CfnFunction.FunctionEnvironmentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.Events`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    events: {
        [key: string]: (CfnFunction.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.FunctionName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    functionName: string | undefined;
    /**
     * `AWS::Serverless::Function.KmsKeyArn`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::Serverless::Function.Layers`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    layers: string[] | undefined;
    /**
     * `AWS::Serverless::Function.MemorySize`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    memorySize: number | undefined;
    /**
     * `AWS::Serverless::Function.PermissionsBoundary`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    permissionsBoundary: string | undefined;
    /**
     * `AWS::Serverless::Function.Policies`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    policies: Array<CfnFunction.IAMPolicyDocumentProperty | CfnFunction.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnFunction.IAMPolicyDocumentProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    reservedConcurrentExecutions: number | undefined;
    /**
     * `AWS::Serverless::Function.Role`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    role: string | undefined;
    /**
     * `AWS::Serverless::Function.Tags`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Function.Timeout`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    timeout: number | undefined;
    /**
     * `AWS::Serverless::Function.Tracing`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    tracing: string | undefined;
    /**
     * `AWS::Serverless::Function.VpcConfig`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    vpcConfig: CfnFunction.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Serverless::Function`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
     */
    interface AlexaSkillEventProperty {
        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    interface ApiEventProperty {
        /**
         * `CfnFunction.ApiEventProperty.Method`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly method: string;
        /**
         * `CfnFunction.ApiEventProperty.Path`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly path: string;
        /**
         * `CfnFunction.ApiEventProperty.RestApiId`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly restApiId?: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface BucketSAMPTProperty {
        /**
         * `CfnFunction.BucketSAMPTProperty.BucketName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly bucketName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     */
    interface CloudWatchEventEventProperty {
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        readonly input?: string;
        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        readonly inputPath?: string;
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface CollectionSAMPTProperty {
        /**
         * `CfnFunction.CollectionSAMPTProperty.CollectionId`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly collectionId: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deadletterqueue-object
     */
    interface DeadLetterQueueProperty {
        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly targetArn: string;
        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly type: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/safe_lambda_deployments.rst
     */
    interface DeploymentPreferenceProperty {
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly type: string;
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly alarms?: string[];
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly hooks?: string[];
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface DomainSAMPTProperty {
        /**
         * `CfnFunction.DomainSAMPTProperty.DomainName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly domainName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
     */
    interface DynamoDBEventProperty {
        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly startingPosition: string;
        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly stream: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface EmptySAMPTProperty {
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     */
    interface EventSourceProperty {
        /**
         * `CfnFunction.EventSourceProperty.Properties`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         */
        readonly properties: CfnFunction.S3EventProperty | CfnFunction.SNSEventProperty | CfnFunction.SQSEventProperty | CfnFunction.KinesisEventProperty | CfnFunction.DynamoDBEventProperty | CfnFunction.ApiEventProperty | CfnFunction.ScheduleEventProperty | CfnFunction.CloudWatchEventEventProperty | CfnFunction.IoTRuleEventProperty | CfnFunction.AlexaSkillEventProperty | cdk.IResolvable;
        /**
         * `CfnFunction.EventSourceProperty.Type`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         */
        readonly type: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
     */
    interface FunctionEnvironmentProperty {
        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
         */
        readonly variables: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface FunctionSAMPTProperty {
        /**
         * `CfnFunction.FunctionSAMPTProperty.FunctionName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly functionName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     */
    interface IAMPolicyDocumentProperty {
        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`
         * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         */
        readonly statement: any | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface IdentitySAMPTProperty {
        /**
         * `CfnFunction.IdentitySAMPTProperty.IdentityName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly identityName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
     */
    interface IoTRuleEventProperty {
        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        readonly awsIotSqlVersion?: string;
        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        readonly sql: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface KeySAMPTProperty {
        /**
         * `CfnFunction.KeySAMPTProperty.KeyId`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly keyId: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
     */
    interface KinesisEventProperty {
        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.KinesisEventProperty.Enabled`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly startingPosition: string;
        /**
         * `CfnFunction.KinesisEventProperty.Stream`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly stream: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface LogGroupSAMPTProperty {
        /**
         * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly logGroupName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface QueueSAMPTProperty {
        /**
         * `CfnFunction.QueueSAMPTProperty.QueueName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly queueName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
     */
    interface S3EventProperty {
        /**
         * `CfnFunction.S3EventProperty.Bucket`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        readonly bucket: string;
        /**
         * `CfnFunction.S3EventProperty.Events`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        readonly events: string[] | string | cdk.IResolvable;
        /**
         * `CfnFunction.S3EventProperty.Filter`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        readonly filter?: CfnFunction.S3NotificationFilterProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnFunction.S3LocationProperty.Bucket`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly bucket: string;
        /**
         * `CfnFunction.S3LocationProperty.Key`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly key: string;
        /**
         * `CfnFunction.S3LocationProperty.Version`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly version?: number;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    interface S3NotificationFilterProperty {
        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         */
        readonly s3Key: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface SAMPolicyTemplateProperty {
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly amiDescribePolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly cloudFormationDescribeStacksPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly cloudWatchPutMetricPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly dynamoDbCrudPolicy?: CfnFunction.TableSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly dynamoDbReadPolicy?: CfnFunction.TableSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly dynamoDbStreamReadPolicy?: CfnFunction.TableStreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly ec2DescribePolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly elasticsearchHttpPostPolicy?: CfnFunction.DomainSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly filterLogEventsPolicy?: CfnFunction.LogGroupSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly kmsDecryptPolicy?: CfnFunction.KeySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly kinesisCrudPolicy?: CfnFunction.StreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly kinesisStreamReadPolicy?: CfnFunction.StreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly lambdaInvokePolicy?: CfnFunction.FunctionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionDetectOnlyPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionLabelsPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionNoDataAccessPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionReadPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionWriteOnlyAccessPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly s3CrudPolicy?: CfnFunction.BucketSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly s3ReadPolicy?: CfnFunction.BucketSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesBulkTemplatedCrudPolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesCrudPolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesEmailTemplateCrudPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesSendBouncePolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly snsCrudPolicy?: CfnFunction.TopicSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly snsPublishMessagePolicy?: CfnFunction.TopicSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sqsPollerPolicy?: CfnFunction.QueueSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sqsSendMessagePolicy?: CfnFunction.QueueSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly stepFunctionsExecutionPolicy?: CfnFunction.StateMachineSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly vpcAccessPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
     */
    interface SNSEventProperty {
        /**
         * `CfnFunction.SNSEventProperty.Topic`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
         */
        readonly topic: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
     */
    interface SQSEventProperty {
        /**
         * `CfnFunction.SQSEventProperty.BatchSize`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.SQSEventProperty.Enabled`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.SQSEventProperty.Queue`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        readonly queue: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     */
    interface ScheduleEventProperty {
        /**
         * `CfnFunction.ScheduleEventProperty.Input`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        readonly input?: string;
        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        readonly schedule: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface StateMachineSAMPTProperty {
        /**
         * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly stateMachineName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface StreamSAMPTProperty {
        /**
         * `CfnFunction.StreamSAMPTProperty.StreamName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly streamName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface TableSAMPTProperty {
        /**
         * `CfnFunction.TableSAMPTProperty.TableName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly tableName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface TableStreamSAMPTProperty {
        /**
         * `CfnFunction.TableStreamSAMPTProperty.StreamName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly streamName: string;
        /**
         * `CfnFunction.TableStreamSAMPTProperty.TableName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly tableName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface TopicSAMPTProperty {
        /**
         * `CfnFunction.TopicSAMPTProperty.TopicName`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly topicName: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::Serverless::LayerVersion`
 *
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 */
export interface CfnLayerVersionProps {
    /**
     * `AWS::Serverless::LayerVersion.CompatibleRuntimes`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly compatibleRuntimes?: string[];
    /**
     * `AWS::Serverless::LayerVersion.ContentUri`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly contentUri?: string;
    /**
     * `AWS::Serverless::LayerVersion.Description`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::LayerVersion.LayerName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly layerName?: string;
    /**
     * `AWS::Serverless::LayerVersion.LicenseInfo`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly licenseInfo?: string;
    /**
     * `AWS::Serverless::LayerVersion.RetentionPolicy`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly retentionPolicy?: string;
}
/**
 * A CloudFormation `AWS::Serverless::LayerVersion`
 *
 * @cloudformationResource AWS::Serverless::LayerVersion
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 */
export declare class CfnLayerVersion extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::LayerVersion";
    /**
     * The `Transform` a template must use in order to use this resource
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::LayerVersion.CompatibleRuntimes`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    compatibleRuntimes: string[] | undefined;
    /**
     * `AWS::Serverless::LayerVersion.ContentUri`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    contentUri: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.Description`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.LayerName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    layerName: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.LicenseInfo`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    licenseInfo: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.RetentionPolicy`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    retentionPolicy: string | undefined;
    /**
     * Create a new `AWS::Serverless::LayerVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLayerVersionProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Serverless::SimpleTable`
 *
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export interface CfnSimpleTableProps {
    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     */
    readonly primaryKey?: CfnSimpleTable.PrimaryKeyProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    readonly provisionedThroughput?: CfnSimpleTable.ProvisionedThroughputProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly sseSpecification?: CfnSimpleTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.TableName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly tableName?: string;
    /**
     * `AWS::Serverless::SimpleTable.Tags`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`
 *
 * @cloudformationResource AWS::Serverless::SimpleTable
 * @stability external
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export declare class CfnSimpleTable extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::SimpleTable";
    /**
     * The `Transform` a template must use in order to use this resource
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     */
    primaryKey: CfnSimpleTable.PrimaryKeyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    provisionedThroughput: CfnSimpleTable.ProvisionedThroughputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    sseSpecification: CfnSimpleTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.TableName`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    tableName: string | undefined;
    /**
     * `AWS::Serverless::SimpleTable.Tags`
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Serverless::SimpleTable`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSimpleTableProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSimpleTable {
    /**
     * @stability external
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     */
    interface PrimaryKeyProperty {
        /**
         * `CfnSimpleTable.PrimaryKeyProperty.Name`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
         */
        readonly name?: string;
        /**
         * `CfnSimpleTable.PrimaryKeyProperty.Type`
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
         */
        readonly type: string;
    }
}
export declare namespace CfnSimpleTable {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnSimpleTable.ProvisionedThroughputProperty.ReadCapacityUnits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
         */
        readonly readCapacityUnits?: number;
        /**
         * `CfnSimpleTable.ProvisionedThroughputProperty.WriteCapacityUnits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
         */
        readonly writeCapacityUnits: number;
    }
}
export declare namespace CfnSimpleTable {
    /**
     * @stability external
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    interface SSESpecificationProperty {
        /**
         * `CfnSimpleTable.SSESpecificationProperty.SSEEnabled`
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
         */
        readonly sseEnabled?: boolean | cdk.IResolvable;
    }
}
