# Generated by Django 2.0.5 on 2018-07-11 13:34

import model_utils.fields
from django.db import migrations


def forward(apps, schema_editor):
    config_model = apps.get_model('django_netjsonconfig', 'Config')
    for config in config_model.objects.all():
        if config.status != 'running':
            continue
        config.status = 'applied'
        config.save()


def backward(apps, schema_editor):
    config_model = apps.get_model('django_netjsonconfig', 'Config')
    for config in config_model.objects.all():
        if config.status != 'applied':
            continue
        config.status = 'running'
        config.save()


class Migration(migrations.Migration):

    dependencies = [
        ('django_netjsonconfig', '0034_device_management_ip'),
    ]

    operations = [
        migrations.AlterField(
            model_name='config',
            name='status',
            field=model_utils.fields.StatusField(choices=[(0, 'dummy')], default='modified', help_text='"modified" means the configuration is not applied yet; \n"applied" means the configuration is applied successfully; \n"error" means the configuration caused issues and it was rolled back;', max_length=100, no_check_for_status=True, verbose_name='configuration status'),
        ),
    ]
