"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchAccessPolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class ElasticsearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        super(scope, id, {
            resourceType: 'Custom::ElasticsearchAccessPolicy',
            onUpdate: {
                action: 'updateElasticsearchDomainConfig',
                service: 'ES',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: cdk.Lazy.string({
                        produce: () => JSON.stringify(new iam.PolicyDocument({
                            statements: this.accessPolicyStatements,
                        }).toJSON()),
                    }),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPaths: ['DomainConfig.ElasticsearchClusterConfig.AccessPolicies'],
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: [props.domainArn] }),
        });
        this.accessPolicyStatements = [];
        this.addAccessPolicies(...props.accessPolicies);
    }
    /**
     * Add policy statements to the domain access policy
     */
    addAccessPolicies(...accessPolicyStatements) {
        this.accessPolicyStatements.push(...accessPolicyStatements);
    }
}
exports.ElasticsearchAccessPolicy = ElasticsearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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